;
;
;******************************************************************************
;
;				KEYBOARD FLUSH
;
;******************************************************************************
;
;
KEY_IN_FL:
	CMP	AL,SRH_FLUSH_L				;TEST DATA BLOCK LENGTH
	JAE	KEY_IN_FL_1
   	MOV	AL,5
	JMP	ERROR
;
KEY_IN_FL_1:
	CALL	KBD_FL
	JMP	EXIT
;
KBD_FL:
	PUSH	AX					;SAVE ALL REGISTERS
	PUSH	DX					;THAT WILL BE CHANGED
	AND	BYTE PTR FLAG_BUF,NOT MASK IN_BUFF	;RESET BUFFER FULL FLAG
	AND	BYTE PTR FLAG_BUF,NOT MASK FK_ACT	;FORGET ACTIV FUNCTION
	MOV	BUF_E,OFFSET INP_BUF			;CLEAR SW-BUFFER
	MOV	BUF_A,OFFSET INP_BUF
;
FLUSS:							;CLEAR HW-BUFFER
	MOV	DX,RSKEY
	IN	AL,DX
	TEST	AL,KBDAT86
	JNZ	FLUSHH
	POP	DX					;RESTORE REGISTERS
	POP	AX
	RET
;
FLUSHH:
	MOV	DX,RDKEY
	IN	AL,DX
	JMP	FLUSS
;
;
PAGE
;
;
;******************************************************************************
;
;				NORMAL READ
;
;******************************************************************************
;
;
KEY_IN:
	CMP	AL,SRH_R_W_L			;RETURN AN ERROR CODE IF 
	JAE	LENGTH_OK			;LENGTH OF I/O-PACKET < 20
	MOV	AL,5
	JMP 	ERROR
;
LENGTH_OK:
	CMP	CX,00H				;EXIT IF COUNT = 0 
	JNZ	COUNT_OK
	JMP	EXIT
;
COUNT_OK:
	PUSH	BX				;SAVE REGISTERS THAT WILL BE
	PUSH	DX				;CHANGED
	CLD
	XOR	AX,AX				;CLEAR AKKU
	TEST	FLAG_BUF,MASK FK_ACT		;LAST FUNCTION KEY COMPLETE ?
	JZ	GET_CHAR
	JMP	GET_OLD_FUNC			;IF NOT, COMPLETE IT 
;
GET_CHAR:
	CMP	AL,0DH				;CR ?
	JZ	KEY_IN_END			;YES - THEN RETURN TO MS-DOS
	CMP	AL,7FH				;LINE SHALL BE CLEARED ?
	JZ	KEY_IN_END			;YES - THEN RETURN TO MS-DOS
;
GET_CHAR_1:
	MOV	DX,RSKEY			;GET KEYBOARD STATUS
	IN	AL,DX
	TEST	AL,KBDAT86			;CHARACTER READY ON KEYBOARD ?
	JZ	HW_BUFF_EMPTY			;NO - CONTINUE
	MOV	DX,RDKEY
	IN	AL,DX				;GET CHARACTER FROM KEYBOARD
	CALL	KBD_BUFF_IN			;STORE CHARACTER IN SW-BUFFER
	XOR	AX,AX
	JMP	GET_CHAR_1			;LOOP UNTIL HW-BUFFER EMPTY
;
HW_BUFF_EMPTY:
	MOV	BX,BUF_A			;GET INPUT OFFSET
	CMP	BX,BUF_E			;EQUAL TO BUFFER END?
	JZ	GET_CHAR			;FOR AN EMPTY BUFFER, WAIT
	MOV	AL,[BX]				;ELSE GET 1ST CONTENT
	AND	FLAG_BUF,NOT MASK IN_BUFF	;INPUT BUFFER NO LONGER FULL
	INC	BX				;RESET POINTER
	CMP	BX,INP_BUF_E       		;REACHING THE END?
	JNE	DBK5	
	MOV	BX,OFFSET INP_BUF		;YES - CLOSE THE CIRCLE
;
DBK5:
	MOV	BUF_A,BX
	OR	AL,AL				;NUL CODE ?
	JZ	KEY_TRANSFER			;YES _ THEN TRANSFER IT
	MOV	DX,AX				;SAVE ORIGINAL CODE IN CX
	CMP	AL,0A0H				;FUNCTION KEY > 9FH ?
	JAE	GET_NEW_FUNC			;YES - THEN GET FUNCTION
	MOV	BX,OFFSET KBD_RDEF_TBL
	XLAT					;TRANSLATE CHARACTER
	CMP	AL,0FFH				;UNDEFINED KEY ?
	JZ	GET_CHAR			;YES - THEN GET NEXT CHARACTER
	OR	AL,AL				;FUNCTION KEY BETWEEN 80H-9FH ?
	JZ	GET_NEW_FUNC			;YES - THEN GET FUNCTION
	TEST	CONSOLE_FLAGS,MASK HEBR_KBD	;HEBREW KEYBOARD ?
	JZ	KEY_TRANSFER
	CMP	AL,9EH				;HEBREW ON ?
	JNZ	HEBREW_1
	OR	FLAG_BUF,MASK HEBR_ON		;SET HEBREW ON FLAG
	JMP	GET_CHAR
;
HEBREW_1:
	CMP	AL,9FH				;HEBREW OFF ?
	JNZ	KEY_TRANSFER
	AND	FLAG_BUF,NOT MASK HEBR_ON	;RESET HEBREW ON FLAG
	JMP	GET_CHAR
;
KEY_TRANSFER:
	STOSB					;TRANSFER CHARACTER
	LOOP	GET_CHAR			;LOOP UNTIL TRANS. BUFFER FULL
;
KEY_IN_END:
	POP	DX				;GET SEAVED REGISTERS BACK
	POP	BX
	MOV	ES,WORD PTR PTRSAV+2		;GET I/O-PACKET SEGMENT BACK
	MOV	AX,ES:[BX].COUNT
	SUB	AX,CX				;GET COUNTER AND
	MOV	ES:[BX].COUNT,AX		;RETURN IT TO MS-DOS
	JMP	EXIT   
;
GET_OLD_FUNC:
	MOV	SI,FUNCOFF			;GET OFFSET OF NEXT BYTE OF
	MOV	BX,WORD PTR REMNUM		;UNCOMPLETED FUNCTION
	JMP	FUNC_TRANSFER
;
GET_NEW_FUNC:
	MOV	AX,DX
	TEST	FLAG_BUF,MASK DISFK		;FUNCTION KEYS DISABLED ?
	JNZ	KEY_TRANSFER			;YES - THEN RETURN REAL CODE
	MOV	SI,OFFSET FUNCTBL		;GET POINTER TO FUNCTION TABLE
	SUB	AX,80H
	MOV	BX,OFFSET FUNCLAT
	XLAT
	CMP	AL,NO_KEY
	JNZ	KEYISOK
	JMP	GET_CHAR
;
KEYISOK:
	DEC	AL
	JZ	GET_NEW_1			;JUMP IF 1ST FUNCTION REQUESTED
	XCHG	CX,AX				;SAVE COUNTER
;
GET_NEW_2:
	MOV	DL,[DS:SI]
	ADD	SI,DX
	LOOP	GET_NEW_2			;GET CORRECT FUNCTION OFFSET
	XCHG	CX,AX				;GET SAVED COUNTER BACK
;
GET_NEW_1:
	MOV	BX,00H
	MOV	BL,DS:[SI]
	DEC	BX
	INC	SI
;
FUNC_TRANSFER:
	CMP	CX,BX				;TRANSFER OF WHOLE FUNCTION
	JB	FUNC_TRANS_1			;POSSIBLE ? JUMP IF NOT
	AND	FLAG_BUF,NOT MASK FK_ACT	;RESET FUNCTION NOT COMPL. FLAG
	SUB	CX,BX				;GET REMAINING # OF REQUESTED
	XCHG	CX,BX				;CHARACTERS AND SAVE IT IN BX
;
FUNC_TRANS_2:
	REP	MOVSB				;TRANSFER FUNCTION
	MOV	WORD PTR FUNCOFF,SI		;SAVE POINTER TO NEXT BYTE
 	MOV	CX,BX				;GET SAVED COUNTER BACK
	AND	CX,CX				;SET FLAGS
	JZ	KEY_IN_END
	MOV	AX,00H				;CLEAR AKKU
	JMP	GET_CHAR
;
FUNC_TRANS_1:
	OR	FLAG_BUF,MASK FK_ACT		;SET FUNCTION NOT COMPLETE FLAG
	SUB	BX,CX				;GET NUMBER OF REMAINING FUNC.
	MOV	WORD PTR REMNUM,BX		;BYTES AND SAVE IT
	MOV	BX,00H				;SET COUNTER TO ZERO
	JMP	FUNC_TRANS_2
;
;
PAGE
;
;
;******************************************************************************
;
;			NON-DESTRUCTIVE READ
;
;******************************************************************************
;
;
KEY_ND_IN:
	CMP	AL,SRH_ND_L			;LOOK FOR CORRECT DATA BLOCK 
	JAE	PACKET_OK			;LENGTH
	MOV	AL,5
	JMP	ERROR				;IF NOT RETURN THIS
;
PACKET_OK:
	PUSH	BX				;SAVE REGISTERS THAT WILL BE
	PUSH	DX				;CHANGED
	MOV	DI,BX				;SET DESTINATION POINTER
	ADD	DI,NDREAD
	MOV	ES,WORD PTR PTRSAV+2
	TEST	FLAG_BUF,MASK FK_ACT		;LAST FUNCTION KEY COMPLETE ?
	JNZ	GET_OLD				;COMPLETE IT IF NOT 
	MOV	BX,BUF_A			;GET BUFFER OFFSET AND COMPARE
	CMP	BX,BUF_E			;WITH ITS END
	JNZ	GET_IT
	MOV	DX,RSKEY
	IN	AL,DX
	TEST	AL,KBDAT86
	JZ	BUSSI
	MOV	DX,RDKEY
	IN	AL,DX
	CALL	KBD_BUFF_IN
;
GET_IT:
	MOV	BX,BUF_A
	MOV	AL,[BX]				;GET 1ST CONTENT
	OR	AL,AL				;NUL CODE ?
	JZ	TRANSFER_KEY			;YES _ THEN TRANSFER IT
	MOV	CX,AX				;SAVE ORIGINAL CODE IN CX
	CMP	AL,0A0H				;FUNCTION KEY > 9FH ?
	JAE	GET_NEW				;YES - THEN GET FUNCTION
	MOV	BX,OFFSET KBD_RDEF_TBL
	XLAT					;TRANSLATE CHARACTER
	OR	AL,AL				;FUNCTION KEY BETWEEN 80H-9FH ?
	JZ	GET_NEW				;YES - THEN GET FUNCTION
	TEST	CONSOLE_FLAGS,MASK HEBR_KBD	;HEBREW KEYBOARD ?
	JZ	TRANSFER_KEY
	CMP	AL,9EH				;HEBREW ON ?
	JNZ	HEBR_1
	OR	FLAG_BUF,MASK HEBR_ON		;SET HEBREW ON FLAG
	JMP	TRANSFER_KEY
;
HEBR_1:
	CMP	AL,9FH				;HEBREW OFF ?
	JNZ	TRANSFER_KEY
	AND	FLAG_BUF,NOT MASK HEBR_ON	;RESET HEBREW ON FLAG
;
TRANSFER_KEY:
	STOSB					;TRANSFER CHARACTER TO MS-DOS
	POP	DX				;GET SAVED REGISTERS BACK
	POP	BX
	JMP	EXIT				;RETURN GOOD STATUS
;
GET_OLD:
	MOV	SI,FUNCOFF			;GET OFFSET OF NEXT BYTE OF
	JMP	TRANSFER_FUNC			;UNCOMPLETED FUNCTION
;
GET_NEW:
	TEST	FLAG_BUF,MASK DISFK		;FUNCTION KEYS DISABLED ?
	JNZ	TRANSFER_KEY			;YES - THEN RETURN REAL CODE
	MOV	SI,OFFSET FUNCTBL		;GET POINTER TO FUNCTION TABLE
	SUB	CX,80H
	MOV	AX,CX
	MOV	BX,OFFSET FUNCLAT
	XLAT
	DEC	AX
	JZ	GET_N_1				;JUMP IF 1ST FUNCTION REQUESTED
	MOV	CX,AX
;
GET_N_2:
	MOV	AL,[DS:SI]
	ADD	SI,AX
	LOOP	GET_N_2				;GET CORRECT FUNCTION OFFSET
;
GET_N_1:
	INC	SI
;
TRANSFER_FUNC:
	MOVSB					;TRANSFER FIRST BYTE TO I/O-PA.
	POP	DX				;GET SAVED REGISTERS BACK
	POP	BX
	JMP 	NEAR PTR EXIT  			;RETURN WITH GOOD STATUS
;
BUSSI:
	POP	DX				;GET SAVED REGISTER BACK
	POP	BX
	JMP	NEAR PTR BUS_EXIT      		;SET BUSY FLAG ON
;
;
PAGE  
;
;
;******************************************************************************
;
;			K E Y B O A R D   O U T P U T
;
;******************************************************************************
;
;
;****************
; RING THE BELL *
;****************
;
BELL:
	MOV	CL,7				;BELL CODE
;
KBD_OUT:					;CL MUST CONTAIN OUTPUT CHAR.
	TEST	CONSOLE_FLAGS,MASK BELL_OFF	;BELL SWITCHED OFF ?
	JNZ	NO_BELL				;YES - THEN RETURN WITH NO BELL
	PUSH	DX
;
KBD_OUT_2:
	MOV	DX,RSKEY
	IN	AL,DX				;GET KEYBOARD STATUS
	TEST	AL,KBDAT86   			;IS A CHARACTER READY TO READ ?
	JZ	KBD_OUT_1			
	MOV	DX,RDKEY
	IN	AL,DX				;YES - THEN DO A DUMMY READ 
;
KBD_OUT_1:
	MOV	DX,RSKEY
	IN	AL,DX				;GET KEYBOARD STATUS
	TEST	AL,INPBUFF86			;OUTPUT TO KEYBOARD POSSIBLE ?
	JNZ	KBD_OUT_2			;IF NOT, TRY AGAIN
	MOV	AL,CL				;GET CHARACTER FOR OUTPUT
	MOV	DX,KBELL
	OUT	DX,AL				;AND SEND IT
	POP	DX
;
NO_BELL:
	RET
;
;
PAGE
;
;
;****************
; MUSIC ROUTINE *
;****************
;
PLAY_MUSIC:
	MOV	DREQ,-1				;INDICATE REQUEST FOR MORE DATA
	MOV	RADDR,OFFSET PM_FREQ 		;FREQUENCY IS NEXT
	RET
;
PM_FREQ:
	MOV	FREQUENCY,AL
	MOV	RADDR,OFFSET PM_TLENGTH 	;TONE LENGTH IS NEXT
	RET
;
PM_TLENGTH:
	MOV	TONE_LENGTH,AL			;SET LENGTH OF TONE
	MOV	DREQ,0				;CLEAR DATA REQUEST
	MOV	STATE,OFFSET ST1		;SET STATE 1 AGAIN
	MOV	CL,06
	CALL	KBD_OUT
	MOV	CL,FREQUENCY	
	CALL	KBD_OUT
	MOV	CL,TONE_LENGTH
	CALL	KBD_OUT
	RET
;
;
PAGE
;
;
;******************************************************************************
;
;				KEYBOARD STATUS
;
;******************************************************************************
;
;
KEY_ST:
	CMP	AL,SRH_STAT_L
	JAE	KEY_ST_3         		;TEST LENGTH OF DATA BLOCK
  	MOV	AL,5
	JMP	ERROR
;
KEY_ST_3:
	TEST	FLAG_BUF,MASK FK_ACT		;LOOK AT ACTIVE FUNCTION KEYS
	JNZ	KEY_ST_1
	MOV	AX,BUF_A			;CHARACTER READY IN BUFFER ?
	CMP	AX,BUF_E
	JNZ	KEY_ST_1			;YES - THEN RETURN THIS
	PUSH	DX
	MOV	DX,RSKEY			;GET KEYBOARD STATUS
	IN	AL,DX
	TEST	AL,KBDAT86			;CHARACTER READY ON KEYBOARD ?
	JNZ	KEY_ST_2			;YES - THEN RETURN THIS 
	POP	DX
	JMP	NEAR PTR BUS_EXIT          	;ELSE RETURN BUISY FLAG ON
;
KEY_ST_2:
	POP	DX
;
KEY_ST_1:
	JMP	NEAR PTR EXIT              	;SET BUISY FLAG OFF
;
;
PAGE
;
;
;******************************************************************************
;	
;	S O F T W A R E   B U F F E R   I N P U T   R O U T I N E
;
;******************************************************************************
;
;
KBD_BUFF_IN:
	PUSH	AX
	PUSH	DX
	PUSH	SI
	CMP	AL,CLR_INPUT			;CLEAR KEY ?
	JNZ	KBD_IN_4			;NO - THEN CONTINUE
	AND	BYTE PTR FLAG_BUF,NOT MASK IN_BUFF
	AND	BYTE PTR FLAG_BUF,NOT MASK FK_ACT
	MOV	BUF_E,OFFSET INP_BUF
	MOV	BUF_A,OFFSET INP_BUF
;
FLU:
	MOV	DX,RSKEY			;GET KEYBOARD STATUS
	IN	AL,DX
	TEST	AL,KBDAT86			;CHARACTER READY ON KEYBOARD ?
	JZ	FLUS				;NO - CONTINUE
	MOV	DX,RDKEY
	IN	AL,DX				;GET CHARACTER FROM KEYBOARD
	JMP	FLU
;
FLUS:
	POP	SI
	POP	DX
	POP	AX
	RET
;
KBD_IN_4:
	TEST	FLAG_BUF,MASK IN_BUFF		;INPUT BUFFER FULL ?
	JNZ	KBD_IN_5			;YES - THEN SEND A BEEP
	MOV	DX,BUF_E			;NO - THEN STORE IT
	MOV	SI,DX
	INC	DX				;RESET POINTER
	CMP	DX,INP_BUF_E       		;REACHING THE END?
	JNE	KBD5	
	MOV	DX,OFFSET INP_BUF		;YES - THEN CLOSE THE CIRCLE
;
KBD5:
	CMP	DX,BUF_A			;IS BUFFER FULL NOW?
	JZ	KBD_IN_1			;YES,SO BEEP AND FORGET
	MOV	BUF_E,DX			;NO,SAVE END-POINTER
	MOV	[SI],AL				;AND THE CHARACTER
	POP	SI
	POP	DX
	POP	AX
	RET
;
KBD_IN_1:
	OR	FLAG_BUF,MASK IN_BUFF
;
KBD_IN_5:
	MOV	DX,RSKEY
	IN	AL,DX				;GET KEYBOARD STATUS
	TEST	AL,KBDAT86   			;IS A CHARACTER READY TO READ ?
	JZ	DBK_OUT_1			
	MOV	DX,RDKEY
	IN	AL,DX				;YES - THEN DO A DUMMY READ 
;
DBK_OUT_1:
	MOV	DX,RSKEY
	IN	AL,DX				;GET KEYBOARD STATUS
	TEST	AL,INPBUFF86			;OUTPUT TO KEYBOARD POSSIBLE ?
	JNZ	KBD_IN_5			;IF NOT, TRY AGAIN
	MOV	AL,BEEP				;GET CHARACTER FOR OUTPUT
	MOV	DX,KBELL
	OUT	DX,AL				;AND SEND IT
	POP	SI
	POP	DX
	POP	AX
	RET
;
;
PAGE
;
;
;******************************************************************************
;	
;		I N T E R R U P T   1 6   H A N D L E R
;
;******************************************************************************
;
;
INTERRUPT_16	PROC	FAR
;
;
;*********************
; INTERRUPT 16 ENTRY *
;*********************
;
I16_HANDLER:
	STI
	PUSH	BX				;SAVE ALL REGISTERS THAT WILL
	PUSH	DX				;BE CHANGED
	PUSH	DS
	PUSH	CS				;GET CORRECT DATA SEGMENT
	POP	DS
	XOR	AL,AL				;CLEAR AL
	AND	AH,AH
	JZ	GET_KEY_CODE			;NORMAL READ ?
	DEC	AH
	JZ	ND_GET_KEY_CODE			;NONDESTRUCTIVE READ ?
;
I16EXIT:
	MOV	AH,AL				;COPY CHARACTER INTO AH
	POP	DS
	POP	DX				;RESTORE REGISTERS
	POP	BX
	IRET					;RETURN TO CALLING ROUTINE
;
;
PAGE
;
;
;************************
; NORMAL CHARACTER READ *
;************************
;
GET_KEY_CODE:
	MOV	BX,BUF_A			;GET INPUT OFFSET
	CMP	BX,BUF_E			;BUFFER EMPTY ?
	JNZ	BUFFILLED			;NO - THEN GET FIRST CONTENT
	MOV	DX,RSKEY			;GET KEYBOARD STATUS
;
LOOPY:
	IN	AL,DX
	TEST	AL,KBDAT86			;CHARACTER READY ON KEYBOARD ?
	JZ	LOOPY				;NO - THEN TRY AGAIN
	MOV	DX,RDKEY
	IN	AL,DX				;GET CHARACTER FROM KEYBOARD
	JMP	I16EXIT
;
BUFFILLED:
	MOV	AL,[BX]				;ELSE GET 1ST CONTENT
	AND	FLAG_BUF,NOT MASK IN_BUFF	;INPUT BUFFER NO LONGER FULL
	INC	BX				;RESET POINTER
	CMP	BX,INP_BUF_E       		;REACHING THE END?
	JNE	DDD5	
	MOV	BX,OFFSET INP_BUF		;YES - CLOSE THE CIRCLE
;
DDD5:
	MOV	BUF_A,BX
	JMP	I16EXIT
;
;
PAGE
;
;
;**********************
; NONDESTRUCTIVE READ *
;**********************
;
ND_GET_KEY_CODE:
	MOV	BX,BUF_A			;GET BUFFER OFFSET
	CMP	BX,BUF_E			;BUFFER EMPTY
	JNZ	GETTIN				;NO - THEN GET FIRST CONTENT
	MOV	DX,RSKEY			;ELSE TRY TO GET ONE FROM KBD
	IN	AL,DX
	TEST	AL,KBDAT86			;CHARACTER READY ?
	JZ	NCEXIT				;NO - THEN RETURN WITH ZF SET
	MOV	DX,RDKEY			;ELSE GET IT
	IN	AL,DX
	CALL	KBD_BUFF_IN			;STORE CHARACTER IN SW-BUFFER
	AND	DX,DX				;RESET ZERO FLAG
;
GOBACK:
	MOV	AH,AL				;COPY AL INTO AH
	POP	DS
	POP	DX				;RESTORE REGISTERS
	POP	BX
	RET	2				;RETURN WITH FLAGS
;
GETTIN:
	MOV	BX,BUF_A
	MOV	AL,[BX]				;GET 1ST CONTENT
	JMP	GOBACK
;
NCEXIT:
	MOV	AL,00H				;CLEAR AKKU 
	JMP	GOBACK
;
;
INTERRUPT_16	ENDP
;
;
PAGE
;
;
;******************************************************************************
;	
;		R E D E F I N I T I O N   O F   K E Y   C O D E S
;
;******************************************************************************
;
;
KEY_RDEF:
	MOV	SI,OFFSET KBD_RDEF_TBL
	XOR	AH,AH
	ADD	SI,AX
	SUB	CX,OFFSET PARMS
	CMP	CX,00H
	JZ	DEF_KEY
	INC	BX
	MOV	CL,AL
	MOV	AL,[BX]
	CMP	AL,00H
	JNZ	DEF_KEY
	MOV	AL,CL
;
DEF_KEY:
	MOV	[SI],AL
	RET
;
;
PAGE
;
;
;******************************************************************************
;	
;	R O U T I N E   F O R   D E F I N I N G   F U N C T I O N   K E Y S
;
;******************************************************************************
;
;
DEFFK:
	MOV	STRINGF,0			;CLEAR STRING FLAG.
	MOV	BX,OFFSET PARMS
	MOV	AL,[BX]
	CMP	AL,00H
	JNZ	KEY_RDEF
	INC	BX
	MOV	AX,OFFSET PARMS 		;BEGIN OF PARAMETER BUFFER.
	SUB	CX,AX				;CX = LENGTH IN BYTES.
	CMP	BYTE PTR [PRMPNT],0
	JNZ	FK1
	DEC	CX
;
FK1:
	CMP	CX,0FFH
	JA	FORGETIT
	MOV	AX,00H
	MOV	AL,[BX]				;# OF FUNCTION TO BE CHANGED
	CMP	AL,00H				;FUNCTION # 0 : 
	JZ	SET_FUN_DIS			;DISABLE FUNCTION KEYS
	CMP	AL,99D				;FUNCTION # 1 - 98 :
	JB	RESET_FUN			;CHANGE THE FUNCTION CONTENTS
	JZ	SET_FUN_EN			;ENABLE FUNCTION KEYS
FORGETIT:
	RET
;
SET_FUN_DIS:
	OR	FLAG_BUF,MASK DISFK		;SET FLAG FUNCTION KEY DISABLED
	RET
;
SET_FUN_EN:
	AND	FLAG_BUF,NOT MASK DISFK 	;RESET FLAG : GETTING CONTENTS
	RET					;OF FUNCTION KEYS IS ENABLED
;
;
PAGE
;
;
RESET_FUN:
	PUSH	BX
	PUSH	CX				;SAVE ALL INCOMING DATA
	CLD
	DEC	AL
	MOV	SI,OFFSET FUNCTBL
	MOV	BX,00H
	MOV	CX,99D
;
GET_LENGTH:
	MOV	BL,[DS:SI]
	ADD	SI,BX
	LOOP	GET_LENGTH
	INC	SI				;SOURCE POINTER TO FIRST CHAR.
	MOV	REMLEN,SI
	MOV	SI,OFFSET FUNCTBL
	MOV	BX,00H
	XCHG	AX,CX
	CMP	CX,00H				;IF FIRST FUNCTION IS
	JZ	NEW_F2				;REQUESTED, TAKE IT DIRECTLY
;
NEW_F1:
	MOV	BL,[DS:SI]
	ADD	SI,BX
	LOOP	NEW_F1
	XCHG	CX,AX
;
NEW_F2:
	MOV	BX,00H
	MOV	BL,DS:[SI]			;GET LENGTH OF FUNCTION IN BX
	INC	SI				;SOURCE POINTER TO FIRST CHAR.
	MOV	AX,OFFSET FUNCTBL
	ADD	AX,FUNCLEN
	SUB	AX,REMLEN
	ADD	AX,BX				;MAX.LENGTH NEW CONTENTS CAN BE
	DEC	SI				;ADDRESS OF 1.BYTE (LENGTH)
	SUB	REMLEN,SI   			;LENGTH OF FUNCTIONS > REQ.ONE
	SUB	REMLEN,BX
	POP	CX
	PUSH	CX 
	CMP	CX,AX				;IF WHOLE STRING IS TOO LONG
	JA	FK2				;RETURN 
	PUSH	SI				;SAVE BEGIN OF FUNCTION STRING
	CMP	CX,BX
	JA	RES4
	JZ	RES2
;
RES1:
	MOV	DI,SI   			;SET POINTERS TO MOVE THE
	ADD	DI,CX
	MOV	AX,CS				;REMAINDING FUNCTIONS
	MOV	ES,AX
	ADD	SI,BX
	MOV	CX,REMLEN
	INC	CX
	REP MOVSB
	CLD					;DIRECTION NOW UP
;
RES2:
	MOV	AX,CS
	MOV	ES,AX				;SET POINTERS TO MOVE THE
	POP	DI				;NEW CONTENTS
	POP	CX
	POP	SI
	INC	SI
	SUB	SP,4				;RESET STACK POINTER
	MOV	AX,CX				;FIRST WRITE LENGTH OF STRING
	STOSB					;OF THE NEW FUNCTION
	DEC	CX				;CX= STRING LENGTH
	REP	MOVSB				;STORE CONTENTS OF NEW FUNCTION
	JMP	FK2				;RETURN WITH GOOD STATUS
;
RES4:
	ADD	SI,REMLEN			;SET POINTERS TO END OF TABLE
	STD					;DIRECTION : DOWN
	JMP	NEAR PTR RES1			;CONTINUE
;
FK2:
	POP	CX
	POP	BX
	RET
;
;
