PAGE 65,132
TITLE	INTERVAL TIMER DRIVER 

;******************************************************************************
;*********                                                           **********
;*********                     CHANGE SHEET                          **********
;*********                                                           **********
;******************************************************************************
;									    
;   DATE                       CHANGES MADE                         SPARS   BY
;------------------------------------------------------------------------------
; 05-22-84 I ORIGINAL ENTRY                                       I       I WK 
; 07-06-84 I OPTIMIZE STACK USAGE                                 I       I WK
;	   I                                                      I       I
;------------------------------------------------------------------------------
PAGE

;------------------------------------------------------------------------------
;
; MODULE:	TIMDRV
;		
; CONTENTS:	- MS-DOS 'TIME' AND 'DATE' SUPPORT
;		- INTERRUPT SERVICE ROUTINE FOR INTERVAL TIMER VECTOR 8
;		- APPLICATION INTERCEPTION SUPPORT (VECTOR 1CH)
;
;------------------------------------------------------------------------------
PAGE

CSEG	SEGMENT PUBLIC 'CODE'
ASSUME	CS:CSEG,DS:CSEG,ES:CSEG

;----------------------------------
; REFERENCES TO OTHER BIOS MODULES
;----------------------------------

PUBLIC	TIM_INT,TIM2_ISR,TIMER_RET
EXTRN	PTRSAV:DWORD

;---------------
; START OF BIOS
;---------------

BIOSTRT		EQU	400H

;----------------------
; MS-DOS STATUS VALUES
;----------------------

ILL_COMMAND     EQU	8103H
BUSY		EQU	0300H
DONE		EQU	0100H

;------------
; STRUCTURES
;------------

REQ_HEADER	STRUC
	
CMDLEN		DB	?		;LENGTH OF THIS COMMAND
UNIT		DB	?		;SUB UNIT SPECIFIER
CMD		DB	?		;COMMAND CODE
STATUS		DW	?		;STATUS
		DB	8 DUP (?)
MEDIA		DB	?		;MEDIA DESCRIPTOR
TRANS		DD	?		;TRANSFER ADDRESS
COUNT		DW	?		;COUNT OF BLOCKS OR CHARACTERS

REQ_HEADER	ENDS
PAGE

;------------
; RELEASE ID
;------------

RELEASE_ID	DB	2,1,0
 
;----------------------------
; TIME CONVERSION PARAMETERS
;----------------------------

MIN_PER_DAY 	DW	1440
MIN_PER_HOUR	DB	60
MS10_PER_SEC	DB	100

;---------------------------
; INTERVAL TIMER'S COUNTERS
;---------------------------

MS10_COUNTER	DW	0	;COUNT 10 MS 
MIN_COUNTER	DW	0	;COUNT OF MINUTES SINCE TIME READ

;---------------------------------
; MS-DOS FORMAT 'TIME' AND 'DATE'
;---------------------------------

TIM_DAYS  DW	0		;Number of days since 1-1-80 
TIM_MINS  DB    0               ;Minutes.
TIM_HRS   DB    0               ;Hours.
TIM_HSEC  DB    0               ;Hundreths of a second.
TIM_SECS  DB    0               ;Seconds.
PAGE

;--------------------
; COMMAND JUMP TABLE
;--------------------

TIMTBL: DW      TIME_INIT       ;0  - INIT
        DW      EXIT            ;1  - Media check (Not used)
        DW      EXIT            ;2  - Get Bios Parameter Block (Not used)
        DW      COMMAND_ERR     ;3  - Reserved. (Currently returns an error)
        DW      READ_TIME       ;4  - Character read. (Destructive)
        DW      BUSY_EXIT       ;5  - (Not used, returns busy flag.)
        DW      EXIT            ;6  - Return status. (Not used)
        DW      EXIT            ;7  - Flush Input buffer. (Not used)
        DW      WRITE_TIME      ;8  - Character write.
        DW      WRITE_TIME      ;9  - Character write with verify.
        DW      EXIT            ;10 - Character write status. (Not used)
        DW      EXIT            ;11 - Flush output buffer. (Not used)
        DW      EXIT            ;12 - IO Control OUTPUT
	DW	COMMAND_ERR
	DW	COMMAND_ERR
	DW	COMMAND_ERR
PAGE

;--------------------------
; MS-DOS INTERRUPT ROUTINE 
;--------------------------

TIM_INT:
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DI
	PUSH	SI
	PUSH	DS
	PUSH	ES
	LES	BX,CS:PTRSAV		;ES:BX	= POINTER TO REQUEST HEADER
	MOV	ES:[BX.STATUS],DONE	;PRESET DONE STATUS
	MOV	AL,ES:[BX.CMD]		;AL = COMMAND
	SHL	AL,1			;DOUBLE COMMAND VALUE FOR JUMP TABLE
	AND	AX,1EH			;MASK FOR TABLE 
	MOV	SI,OFFSET TIMTBL	;SI = BASE ADDRESS OF JUMP TABLE
	ADD	SI,AX			;SI = ENTRY OF SPECIFIC FUNCTION 
	CALL	CS:[SI]			;GO DO COMMAND

EXIT	PROC	FAR

	POP	ES
	POP	DS
	POP	SI	
	POP	DI
	POP	CX
	POP	BX
	POP	AX
	RET

EXIT	ENDP

COMMAND_ERR:				;UNKNOWN COMMAND ERROR
	OR	ES:[BX.STATUS],ILL_COMMAND
	RET

BUSY_EXIT:
	OR	ES:[BX.STATUS],BUSY
	RET
PAGE

;--------------------------------------------------------------------
; INIT - NO PROCESSING REQUIRED, TIMER INITIALIZED IN MODULE BASINIT  
;--------------------------------------------------------------------

TIME_INIT PROC NEAR

	RET	

TIME_INIT	ENDP

;----------------------------------------------
; INTERVAL TIMER (2) INTERRUPT SERVICE ROUTINE
;----------------------------------------------

TIM2_ISR PROC NEAR

	CMP	CS:MS10_COUNTER+BIOSTRT,5999 ;10 MS LESS THAN A MINUTE
	JB	LT_MIN
	INC	CS:MIN_COUNTER+BIOSTRT	
	MOV	CS:MS10_COUNTER+BIOSTRT,-1
LT_MIN:
	INC	CS:MS10_COUNTER+BIOSTRT	;UPDATE 10 MS COUNTER 
	JMP	DWORD PTR CS:[70H]	;JUMP FAR TO ADDRESS AT |1CH*4|
	
TIMER_RET:				;ALL TIMER 2 INTERRUPTS MUST RETURN
					; TO HERE
	IRET
		
TIM2_ISR	ENDP
PAGE
				
;-----------------
; WRITE TIME/DATE
;-----------------

WRITE_TIME	PROC NEAR 

	LDS	SI,ES:[BX.TRANS]	
        MOV     DI,OFFSET TIM_DAYS
	PUSH	CS
	POP	ES
        MOV     CX,6
	CLI
        REP     MOVSB
	STI
        RET

WRITE_TIME	ENDP

;----------------
; READ TIME/DATE
;----------------

READ_TIME	PROC	NEAR 

	PUSH	CS			
	POP	DS			;DS = CS
	PUSH	DX
	XOR	DX,DX
	XOR	AX,AX
	CLI				;DISABLE INTERRUPTS WHILE UPDATING 
					; TIME/DATE VARIABLES
	XCHG	AX,MIN_COUNTER		;AX = MINUTES COUNTER, MIN COUNTER = 0 
	DIV	MIN_PER_DAY		;AX = DAYS, DX = MINUTES < 1 DAY
	ADD	TIM_DAYS,AX		;UPDATE MS-DOS TIME/DATE
	MOV	AX,DX			;REMAINDER (MINUTES)
	DIV	MIN_PER_HOUR		;AL = HOURS, AH = MINUTES < 1 HOUR
	ADD	TIM_HRS,AL		;UPDATE MS-DOS HOURS
	ADD	TIM_MINS,AH		;UPDATE MS-DOS MINUTES
	XOR	AX,AX
	XCHG	AX,MS10_COUNTER		;AX = 10MS-COUNTER, 10MS-COUNTER = 0
	STI				;REENABLE INTERRUPTS
	DIV	MS10_PER_SEC		;AL = SECONDS, AH = 1/100 SECONDS < 1 SEC
	ADD	TIM_SECS,AL		;UPDATE MS-DOS SECONDS
	ADD	TIM_HSEC,AH		;UPDATE MS-DOS 1/100 SECONDS COUNTER
	CMP	TIM_HSEC,100		;IF 1/100 SEC COUNTER < 100
	JB	TEST_SECONDS		; TEST SECONDS COUNTER
	SUB	TIM_HSEC,100		;ELSE 1/100 SEC COUNTER - 100
	INC	TIM_SECS		; SECONDS COUNTER + 1
	
TEST_SECONDS:				

	CMP	TIM_SECS,60		;IF SECONDS COUNTER < 60
	JB	TEST_MINUTES		; TEST MINUTES COUNTER
	SUB	TIM_SECS,60		;ELSE SECONDS COUNTER - 60
	INC	TIM_MINS		; MINUTES COUNTER + 1

TEST_MINUTES:
	
	CMP	TIM_MINS,60		;IF MINUTES COUNTER < 60
	JB	TEST_HOURS		; TEST HOURS COUNTER
	SUB	TIM_MINS,60		;ELSE MINUTES COUNTER - 60
	INC	TIM_HRS			; HOURS COUNTER + 1

TEST_HOURS:
			
	CMP	TIM_HRS,24		;IF HOURS COUNTER < 24
	JB	TIME_TRANS		; DONE, RETURN TIME/DATE
	SUB	TIM_HRS,24		;ELSE HOURS COUNTER - 24
	INC	TIM_DAYS		; DAYS COUNTER + 1

TIME_TRANS:

        MOV     SI,OFFSET TIM_DAYS	;RETURN 6-BYTE TIME/DATE COUNTERS
	LES	DI,ES:[BX.TRANS]	; IN TRANSFER BUFFER
        MOV     CX,6
        REP     MOVSB
	POP	DX
	RET

READ_TIME	ENDP

CSEG	ENDS
	END
