
PAGE 65,132
TITLE    IOBASE FOR THE NCR DECISION MATE V.

;******************************************************************************
;*********                                                           **********
;*********                     CHANGE SHEET                          **********
;*********                                                           **********
;******************************************************************************
;									    
;   DATE                       CHANGES MADE                         SPARS   BY
;------------------------------------------------------------------------------
; 05-22-84 I ORIGINAL ENTRY                                       I       I WK 
; 06-28-84 I ADD DEFAULT VALUES FOR COM CHANNELS 2 TO 5           I G2815 I WK
; 06-29-84 I PRINTERS SUPPORT IOCTL CALLS NOW                     I G2818 I HD
; 07-13-84 I SYSTEM PRINTER (PRN/LPT1) ID AS IN MS-DOS 2.0        I G2861 I WK
; 07-18-84 I CHANGE SYSTEM DEFINITION AREA FOR COMPATIBILITY      I G2876 I WK 
; 07-20-84 I SUPPRESS DISPLAY OF CHARACTERS < 20H                 I G2878 I WK
; 08-29-84 I ADDED SPECIAL WRITE PROTECTION FLAG FOR 48/96 TPI    I       I WK
;------------------------------------------------------------------------------
PAGE

;------------------------------------------------------------------------------
;
; MODULE:	IOBASE	(FIRST MODULE OF IO.SYS)
;		
; CONTENTS:	- REFERENCES TO TABLES FOR ACCESS FROM OUTSIDE IO.SYS
;		- DEVICES PARAMETER TABLES
;		- DEVICE HEADERS
;		- KEYBOARD/CRT TRANSLATION TABLES
;		- KEYBOARD REDEFINITION TABLE
;		- TABLES OF SUPPORTED ESCAPE SEQUENCES
;		- TABLE OF 1-BYTE CRT CONTROL CODES
;		- KEYBOARD/CRT BUFFERS
;		- TRAP FOR UNDEFINED INTERRUPTS 
;	        - RE_INIT RETURN FOR SYSINIT
;		- MEMORY SIZE REPORTING ROUTINE
;		- COMMON STRATEGY ROUTINE
;
;------------------------------------------------------------------------------
      

PUBLIC	RE_INIT,INT_TRAP,MEM_SIZE_DET,MEMORY_SIZEK,PTRSAV,STACKTOP
PUBLIC  FLTAB,FLOPPY_DRIVES,FL_OUT_RETRIES,FL_IN_RETRIES,FL_FLAGS,PRINTER_IF_TYPE
PUBLIC  WINCH_DRIVES,WI_OUT_RETRIES,WI_IN_RETRIES,WI_FLAGS
PUBLIC  CRT_ROWS,CONSOLE_FLAGS,CURSOR_TYPE,CMDTABL,CRTACTTBL,ETBLENT
PUBLIC	KBD_TT,CLEAR_1,CLEAR_2,DEC_SIGN_1,DEC_SIGN_2,CONFIG_FLAGS
PUBLIC  PRINTER_TBL,PRNTBL,LPT2TBL,LPT3TBL,LPT4TBL,LPT5TBL
PUBLIC  COMM_TBL,AUXTBL,COM2TBL,COM3TBL,COM4TBL,COM5TBL	
PUBLIC  DEVSTART,CONDEV,AUXDEV,COM1DEV,COM2DEV,COM3DEV,COM4DEV,COM5DEV
PUBLIC  PRNDEV,LPT1DEV,LPT2DEV,LPT3DEV,LPT4DEV,LPT5DEV,GW_COMM
PUBLIC  TIMDEV,DSKDEV,WINDEV,KBD_RDEF_TBL,KBDTBL,ESCTBL,COMTBL,DEC_S_1,DEC_S_2 
PUBLIC  LINBUF,PARMS,LASTPRM,INP_BUF,BUF_A,BUF_E,HEB_SW,M1RS232,M2RS232,PVRS232

EXTRN 	HWINIT:NEAR,FUNCTBL:NEAR,CUU:NEAR,CUD:NEAR,CUF:NEAR,CUB:NEAR,CUP:NEAR
EXTRN   EL:NEAR,ED:NEAR,SGR:NEAR,PSCP:NEAR,PRCP:NEAR,DEFFK:NEAR,XDSR:NEAR
EXTRN   BELL:NEAR,BACKSP:NEAR,LINEFD:NEAR,RLF:NEAR,NDFS:NEAR,CARRET:NEAR
EXTRN   VHOME:NEAR,SHALF_INT:NEAR,RHALF_INT:NEAR,BLEOS:NEAR,INSLIN:NEAR
EXTRN   DELLIN:NEAR,ICHR:NEAR,DCHR:NEAR,POSIT:NEAR,PLAY_MUSIC:NEAR,REVERSE:NEAR
EXTRN   WI_STRATEGY:NEAR,WI_INTERRUPT:NEAR,DSK_INT:NEAR,LPT1_ACT:NEAR
EXTRN   LPT2_ACT:NEAR,LPT3_ACT:NEAR,LPT4_ACT:NEAR,LPT5_ACT:NEAR,COM_INT1:NEAR
EXTRN   COM_INT2:NEAR,COM_INT3:NEAR,COM_INT4:NEAR,COM_INT5:NEAR,CON_INT:NEAR
EXTRN   TIM_INT:NEAR,H2:NEAR,ST12:NEAR

CSEG    SEGMENT	PUBLIC	'CODE'
ASSUME  CS:CSEG,DS:CSEG,ES:CSEG,SS:NOTHING

ORG     0               		;STARTS AT AN OFFSET OF ZERO.

INIT:   JMP     HWINIT			;PASS PARAMETERS TO SYSINIT AND ACTIVATE
					; SYSTEM INITIALIZATION (HWINIT)
PAGE

;-------------------------------------------------
;	
; SYSTEM DEFINITION AREA AT ABSOLUTE ADDRESS 403H
;
;-------------------------------------------------

CRT_SB_FUNCT	DW	OFFSET COMTBL	;TABLE OF SINGLE BYTE CRT CONTROL
					; FUNCTIONS
ANSI_ESC_SEQ	DW	OFFSET CMDTABL	;TABLE OF ANSI ESCAPE SEQUENCES

CRT_TR_TABLE	DW	OFFSET CRTACTTBL;CRT TRANSLATION TABLE

NON_ANSI_ESC	DW	OFFSET ETBLENT	;TABLE OF NON ANSI ESCAPE SEQUENCES

KEYBOARD_TBL	DW	OFFSET KBD_TT   ;KEYBOARD TRANSLATION TABLE


		DW	0,0		;SPARE

;------------------------
; FLOPPY DISK PARAMETERS
;------------------------
		
FLTAB           DW      0               ;FLEX MEDIA CHANGE BYTES    
					;1ST BYTE - UNIT 0
					;2ND BYTE - UNIT 1

FLOPPY_DRIVES	DB	2		;DEFAULTS TO 2
FL_OUT_RETRIES	DB	5		;DEFAULTS TO 5
FL_IN_RETRIES	DB	5		;DEFAULTS TO 5

;----------------------
; HARD DISK PARAMETERS
;----------------------

WINCH_DRIVES	DB	0		;DEFAULTS TO 0
WI_OUT_RETRIES	DB	5		;DEFAULTS TO 5
WI_IN_RETRIES	DB	5		;DEFAULTS TO 5

;-------------------
; SYSTEM PRINTER ID
;-------------------

PRINTER_IF_TYPE	DB	'P'		;DEFAULTS TO PARALLEL INTERFACE

;-----------------------------------
; SERIAL SYSTEM PRINTER DEFINITIONS
;-----------------------------------

M1RS232		DB	79H		
M2RS232		DB	3EH
PVRS232		DB	0
PAGE

;--------------------
; CONSOLE PARAMETERS
;--------------------

CRT_ROWS	DB	24		;DEFAUTS TO 24 ROWS SCROLLING
					; 25 OPTIONAL

CONSOLE_FLAGS	DB	0		;BIT 7   	1 = COLOR 
					;	 	0 = MONOCHROME 
					;BIT 6		1 = HEBREW KEYBOARD
					;BIT 5		1 = BELL OFF
					;BIT 4		1 = VIDEO DISK ADAPTED
					;BIT 3-0	RESERVED
								
CURSOR_TYPE	DB	8FH,0CEH,72H	;INITIAL CURSOR TYPE UNDERLINE BLINKING
		DB	0

;---------------------
; CONFIGURATION FLAGS
;---------------------

CONFIG_FLAGS	DW	0		;BIT 0 		1 = REAL-TIME-CLOCK IN USE
					;BIT 1		0 = NO WRITING TO 48 TPI
					;		    DISKETTES IN 96 TPI DRIVES
					;		1 = WRITING ENABLED FOR 48 TPI
					;                   DISKETTES IN 96 TPI DRIVES
 	
;----------------
; DISKETTE FLAGS
;----------------

FL_FLAGS	DB	0,0,0

;-----------------
; HARD DISK FLAGS
;-----------------

WI_FLAGS	DB	87H		;DEFAULTS TO 3 MS-DOS UNITS OF 10 MB EACH
		DB	0,0

;---------------------------------
; GW-BASIC CONFIGURATION CONTROLS
;---------------------------------

GW_COMM		DB	11H		;XON CHARACTER
		DB      13H             ;XOFF CHARACTER
		DB	0		;OPERATION FLAGS		

;-------------------------------
; POINTER TO FUNCTION KEY TABLE
;-------------------------------

KEYBFUNC_TBL    DW	OFFSET FUNCTBL  ;TABLE OF FUNCTION KEY ASSIGNMENTS
PAGE
 
ORG	30H

;--------------------
; PRINTER PARAMETERS
;--------------------

PRINTER_TBL:				;DEFAULT PARAMETERS FOR PRN/LPT1
PRNTBL		DB	60H		;PORT ADDRESS 60H
		DB	79H		;1 STOP-BIT,EVEN PARITY,PARITY ENABLED
					;7 BITS PER CHARACTER,ASYNCHRONOUS 		
		DB	3EH		;9600 BAUD,INTERNAL CLOCKS
		DB	80H		;DEFAULTS TO CENTRONICS PARALLEL INTERFACE
					;BIT 7   	1 = CENTRONICS PARALLEL
					;        	0 = RS232
					;BIT 6-2     	RESERVED
					;BIT 1,0        0 = NO PROTOCOL
					;		1 = XON/XOFF
					;		2 = RDY/BSY
					;		3 = ETX/ACK	

LPT2TBL		DB	4 DUP (0)	;PARAMETER AREA FOR LPT2
LPT3TBL		DB	4 DUP (0)	;PARAMETER AREA FOR LPT3
LPT4TBL		DB	4 DUP (0)	;PARAMETER AREA FOR LPT4
LPT5TBL		DB	4 DUP (0)	;PARAMETER AREA FOR LPT5
PAGE

ORG	46H
;---------------------------------
; RS232 COMMUNICATIONS PARAMETERS
;---------------------------------

COMM_TBL:				;DEFAULT PARAMETERS FOR AUX/COM1
AUXTBL		DW	70H		;PORT ADDRESS 70H
		DB	79H		;1 STOP-BIT,EVEN PARITY,PARITY ENABLED
					;7 BITS PER CHARACTER,ASYNCHRONOUS 		
		DB	3EH		;9600 BAUD,INTERNAL CLOCKS
		DB	37H		;COMMAND 
		DB	0A0H		;KEEP TRYING 
					;BIT 7		0 = RETURN ON TIMEOUT
					;		1 = CONTROL-C BREAK 
					;BIT 6          0 = UNBUFFERED COMM
					;		1 = BUFFERED COMM		
					;BIT 5		0 = RTS RESET
					;		1 = RTS HELD ON			
					;BIT 4-0	RESERVED
		DW	1000		;TIMEOUT	~1000 MS
		DB	0		;LINE STATUS
		DB	0		;COMMUNICATION STATUS FLAGS
		DB	0		;SPACE FOR NON DESTRUCTIVE INPUT
		

COM2TBL		DB	70H,00H,79H,3EH,37H,0A0H,0E8H,03H,0,0,0
COM3TBL		DB	70H,00H,79H,3EH,37H,0A0H,0E8H,03H,0,0,0
COM4TBL		DB	70H,00H,79H,3EH,37H,0A0H,0E8H,03H,0,0,0
COM5TBL		DB	70H,00H,79H,3EH,37H,0A0H,0E8H,03H,0,0,0
PAGE

ORG	80H
;------------
; RELEASE ID                                               
;------------

	DB	02H			;ISSUE
	DB	07H			;SUB-ISSUE
	DB	00H			;PATCH LEVEL

;-----------------------------
; TOTAL MEMORY SIZE  (K-BYTE)
;-----------------------------

MEMORY_SIZEK	DW	0		;MEMORY SIZE IN K-BYTES

;----------------------------------
; REQUEST HEADER POINTER SAVE AREA
;----------------------------------

PTRSAV		DD	0		;STRATEGY ROUTINE SAVES ES:BX HERE
					 
;-------------------------------
; CRT LINE/ESCAPE STRING BUFFER 
;-------------------------------

LINBUF	EQU 	THIS BYTE
PARMS	DB	256 DUP(0)
LASTPRM DB	0

ORG	197H
;--------------------------------------
; ASSIGN TABLE FOR GIBS ASSIGN UTILITY
;--------------------------------------

ASSIGN_TBL:
	DB	00H,01H,02H,03H,04H,05H,06H,07H

;----------------------
; KEYBARD INPUT BUFFER
;----------------------

INP_BUF	DB	80 DUP(0)
BUF_A	DW	OFFSET	INP_BUF
BUF_E	DW	OFFSET	INP_BUF
PAGE

ORG	21DH				;REFERRED TO BY GWBASIC
;----------------------------
; KEYBOARD TRANSLATION TABLE
;----------------------------

KBD_TT	DB	00H			; 80 H
	DB	17H			; 81 H
	DB	13H			; 82 H	CURSOR LEFT
	DB	18H			; 83 H  CURSOR DOWN
	DB	05H			; 84 H  CURSOR UP
	DB	04H			; 85 H  CURSOR RIGHT
CLEAR_1  DB	18H			; 86 H  CLEAR LINE (RUBOUT)	
	DB	07H			; 87 H
	DB	0DH			; 88 H	CARRIGE RETURN
	DB	09H			; 89 H
DEC_SIGN_1  DB  2CH			; 8A H  COMMA (MAY BE CHANGED BY KBD_INIT ROUTINE)
	DB	08H			; 8B H  BACKSPACE
	DB	0CH			; 8C H
	DB	0DH			; 8D H
	DB	0EH			; 8E H
	DB	0FH			; 8F H

	DB	10H			; 90 H
	DB	17H			; 91 H
	DB	13H			; 92 H  CURSOR LEFT
	DB	18H			; 93 H  CURSOR DOWN
	DB	05H			; 94 H  CURSOR UP
	DB	04H			; 95 H  CURSOR RIGHT
CLEAR_2  DB	18H			; 96 H  CLEAR LINE (RUBOUT)	
	DB	17H			; 97 H
	DB	0DH			; 98 H  CARRIGE RETURN
	DB	19H			; 99 H
DEC_SIGN_2  DB  2CH			; 9A H  COMMA (MAY BE CHANGED BY KBD_INIT ROUTINE)
	DB	08H			; 9B H  BACKSPACE
	DB	1CH			; 9C H
	DB	1DH			; 9D H
	DB	1EH			; 9E H
	DB	1FH			; 9F H
PAGE

;-----------------------
; ANSI ESCAPE SEQUENCES
;-----------------------

CMDTABL DB      'A'             	;CURSOR UP.  ESC[#A
        DW      CUU
        DB      'B'             	;CURSOR DOWN. ESC[#B
        DW      CUD
        DB      'C'             	;CURSOR FORWARD. ESC[#C
        DW      CUF
        DB      'D'                   	;CURSOR BACK. ESC[#D
        DW      CUB
        DB      'H'	             	;DIRECT CURSOR POSIT. ESC[X;YH
        DW      CUP
        DB      'f'             	;DIRECT CURSOR POSIT. ESC[X;Yf
        DW      CUP
        DB      'J'             	;ERASE. ESC[#J
        DW      ED
        DB      'K'             	;ERASE IN LINE. ESC[#K
        DW      EL
        DB      'm'             	;SPECIAL VIDEO MODE. ESC[#;...m
        DW      SGR
        DB      's'             	;SAVE CURSOR POSIT. ESC[s
        DW      PSCP
        DB      'u'             	;MOVE CURSOR TO SAVED. ESC[u
        DW      PRCP
	DB	'p'			;DEFINE FUNCTION KEY
	DW	DEFFK			;ESC[0;#;"STRING"...p
					;DISABLE FUNCTION KEY EXTENSION
					;ESC[0;0p
					;ENABLE FUNCTION KEY EXTENSION
					;ESC[0;99p
					;REDEFINE KEY
					;ESC[<OLD CODE>;<NEW CODE>p

	DB	'n'			;CURSOR POSITION REPORT
	DW     	XDSR			;ESC[6n
        DB      00              	;END OF TABLE.
PAGE

;-----------------------------------
; SINGLE BYTE CRT CONTROL FUNCTIONS
;-----------------------------------

EVEN
COMTBL:
	DW	H2			;NO OUTPUT TO CRT
	DW	H2			;NO OUTPUT TO CRT
	DW	H2			;NO OUTPUT TO CRT
	DW	H2			;NO OUTPUT TO CRT
	DW	H2			;NO OUTPUT TO CRT
	DW	H2			;NO OUTPUT TO CRT
	DW	H2			;NO OUTPUT TO CRT
	DW	BELL			;RING THE BELL
	DW	BACKSP			;NON DESTRUCTIVE BACKWARD SPACE
	DW	H2			;NO OUTPUT TO CRT
	DW	LINEFD			;LINE FEED
	DW	RLF			;REVERSE LINE FEED
	DW	NDFS			;NON DESTRUCTIVE FORWARD SPACE
	DW	CARRET			;CARRIAGE RETURN
	DW	H2			;NO OUTPUT TO CRT
	DW	H2			;NO OUTPUT TO CRT
	DW	H2			;NO OUTPUT TO CRT
	DW	H2			;NO OUTPUT TO CRT
	DW	H2			;NO OUTPUT TO CRT
	DW	H2			;NO OUTPUT TO CRT
	DW	H2			;NO OUTPUT TO CRT
	DW	H2			;NO OUTPUT TO CRT
	DW	H2			;NO OUTPUT TO CRT
	DW	EL			;ERASE TO END OF LINE
	DW	H2			;NO OUTPUT TO CRT
	DW	H2			;NO OUTPUT TO CRT
	DW	ED			;CLEAR SCREEN
	DW	ST12			;STATE FOR ESCAPE SEQUENCES
	DW	H2			;NO OUTPUT TO CRT
	DW	H2			;NO OUTPUT TO CRT
	DW	VHOME			;CURSOR HOME
	DW	H2			;NO OUTPUT TO CRT
PAGE

;------------------------------------
; TABLE OF NON ANSI ESCAPE FUNCTIONS
;------------------------------------
	
ETBLENT DW	15			;NUMBER OF TABLE ENTRIES
ESCTBL  DB	3AH
	DW	ED			;CLEAR SCREEN
	DB	2AH
	DW	ED			;CLEAR SCREEN
	DB	29H	
	DW	SHALF_INT		;SET HALF INTENSITY
	DB	28H
	DW	RHALF_INT		;RESET HALF INTENSITY
	DB	'Y'
	DW	BLEOS			;ERASE TO END OF SCREEN
	DB	'y'
	DW	BLEOS
	DB	'T'
	DW	EL			;ERASE TO END OF LINE
	DB	't'
	DW	EL
	DB	'E'
	DW	INSLIN			;INSERT LINE
	DB	'R'
	DW	DELLIN			;DELETE LINE
	DB	'Q'
	DW	ICHR			;INSERT CHARACTER
	DB	'W'
	DW	DCHR			;DELETE CHARACTER
	DB	'='
	DW	POSIT			;POSITION CURSOR
	DB	'M'
	DW	PLAY_MUSIC 		;MUSIC 
	DB	'G'
	DW	REVERSE			;INVERSE VIDEO
PAGE

;--------------------------------------
; KEY-REDEFINITION TABLE (CODES < 80H)
;--------------------------------------

KBD_RDEF_TBL:

;	ASCII CODES

	DB	00H,01H,02H,03H,04H,05H,06H,07H,08H,09H,0AH,0BH,0CH,0DH,0EH,0FH
       	DB	10H,11H,12H,13H,14H,15H,16H,17H,18H,19H,1AH,1BH,1CH,1DH,1EH,1FH
       	DB	20H,21H,22H,23H,24H,25H,26H,27H,28H,29H,2AH,2BH,2CH,2DH,2EH,2FH
       	DB	30H,31H,32H,33H,34H,35H,36H,37H,38H,39H,3AH,3BH,3CH,3DH,3EH,3FH
       	DB	40H,41H,42H,43H,44H,45H,46H,47H,48H,49H,4AH,4BH,4CH,4DH,4EH,4FH
       	DB	50H,51H,52H,53H,54H,55H,56H,57H,58H,59H,5AH,5BH,5CH,5DH,5EH,5FH
       	DB	60H,61H,62H,63H,64H,65H,66H,67H,68H,69H,6AH,6BH,6CH,6DH,6EH,6FH
       	DB	70H,71H,72H,73H,74H,75H,76H,77H,78H,79H,7AH,7BH,7CH,7DH,7EH,7FH

;	KEY CODES FROM 80H UP TO 9FH

KBDTBL:
       	DB	0FFH,00H,00H,00H,00H,00H,00H,0FFH
	DB	0DH,0FFH
DEC_S_1:
	DB	2CH
	DB	08H,0FFH,0FFH,0FFH,0FFH
       	DB	0FFH,00H,00H,00H,00H,00H,00H,0FFH
	DB	0DH,0FFH
DEC_S_2:
	DB	2CH
	DB	08H,0FFH,0FFH
HEB_SW	DB	0FFH,0FFH
PAGE

ORG	376H				;REFERRED TO BY GWBASIC	
;------------------------------
; ACTIVE CRT TRANSLATION TABLE
;------------------------------

CRTACTTBL:
	DB	00H,01H,02H,03H,04H,05H,06H,07H,08H,09H,0AH,0BH,0CH,0DH,0EH,0FH
	DB	10H,11H,12H,13H,14H,15H,16H,17H,18H,19H,1AH,1BH,1CH,1DH,1EH,1FH
	DB	20H,21H,22H,23H,24H,25H,26H,27H,28H,29H,2AH,2BH,2CH,2DH,2EH,2FH
	DB	30H,31H,32H,33H,34H,35H,36H,37H,38H,39H,3AH,3BH,3CH,3DH,3EH,3FH
	DB	40H,41H,42H,43H,44H,45H,46H,47H,48H,49H,4AH,4BH,4CH,4DH,4EH,4FH
	DB	50H,51H,52H,53H,54H,55H,56H,57H,58H,59H,5AH,5BH,5CH,5DH,5EH,5FH
	DB	60H,61H,62H,63H,64H,65H,66H,67H,68H,69H,6AH,6BH,6CH,6DH,6EH,6FH
	DB	70H,71H,72H,73H,74H,75H,76H,77H,78H,79H,7AH,7BH,7CH,7DH,7EH,7FH
	DB	80H,81H,82H,83H,84H,85H,86H,87H,88H,89H,8AH,8BH,8CH,8DH,8EH,8FH
	DB	90H,91H,92H,93H,94H,95H,96H,97H,98H,99H,9AH,9BH,9CH,9DH,9EH,9FH
	DB	0A0H,0A1H,0A2H,0A3H,0A4H,0A5H,0A6H,0A7H,0A8H,0A9H,0AAH,0ABH,0ACH,0ADH,0AEH,0AFH
	DB	0B0H,0B1H,0B2H,0B3H,0B4H,0B5H,0B6H,0B7H,0B8H,0B9H,0BAH,0BBH,0BCH,0BDH,0BEH,0BFH
	DB	0C0H,0C1H,0C2H,0C3H,0C4H,0C5H,0C6H,0C7H,0C8H,0C9H,0CAH,0CBH,0CCH,0CDH,0CEH,0CFH
	DB	0D0H,0D1H,0D2H,0D3H,0D4H,0D5H,0D6H,0D7H,0D8H,0D9H,0DAH,0DBH,0DCH,0DDH,0DEH,0DFH
	DB	0E0H,0E1H,0E2H,0E3H,0E4H,0E5H,0E6H,0E7H,0E8H,0E9H,0EAH,0EBH,0ECH,0EDH,0EEH,0EFH
	DB	0F0H,0F1H,0F2H,0F3H,0F4H,0F5H,0F6H,0F7H,0F8H,0F9H,0FAH,0FBH,0FCH,0FDH,0FEH,0FFH
PAGE

;-----------------------------------------------+
;            MS-DOS DEVICE HEADERS              |
;-----------------------------------------------+
;     DWORD POINTER TO NEXT DEVICE              | 
;         (-1,-1 IF LAST DEVICE)                | 
;-----------------------------------------------+
;     DEVICE ATTRIBUTES (WORD)                  | 
;       BIT 15 = 1 FOR CHACTER DEVICES.         |
;                0 FOR BLOCK DEVICES.           |
;                                               |
;       CHARCTER DEVICES. (BIT 15=1)            |
;         BIT 0 = 1  CURRENT STI DEVICE.        |
;         BIT 1 = 1  CURRENT STO DEVICE.        |
;         BIT 2 = 1  CURRENT NUL DEVICE.        |
;         BIT 3 = 1  CURRENT CLOCK DEVICE.      |
;                                               |
;         BIT 13 = 1 FOR NON IBM MACHINES.      |
;                  0 FOR IBM MACHINES ONLY.     |
;         BIT 14 = 1 IOCTL CONTROL BIT.         |
;-----------------------------------------------+
;     DEVICE STRATEGY POINTER (WORD OFFSET)     |
;-----------------------------------------------+
;     DEVICE INTERRUPT POINTER (WORD OFFSET)    |
;-----------------------------------------------+
;     DEVICE NAME FIELD (8 BYTES)               |
;       CHARACTER DEVICES ARE ANY VALID NAME    |
;         LEFT JUSTIFIED, IN A SPACE FILLED     |
;         FIELD.                                |
;       BLOCK DEVICES CONTAIN # OF UNITS IN     |
;         THE FIRST BYTE.                       |
;-----------------------------------------------+
EVEN

DEVSTART LABEL WORD
CONDEV:                         	;HEADER FOR DEVICE CON
        DW      AUXDEV,CSEG     	;LINK TO NEXT DEVICE
        DW      0C013H           	;ATTRIBUTES - CONSOLE INPUT, OUTPUT DEVICE
					; IOCTL AND INT 29H SUPPORT	
        DW      STRATEGY        	;SRATEGY ENTRY POINT
        DW      CON_INT         	;INTERRUPT ENTRY POINT
        DB      "CON     "      	;DEVICE NAME

AUXDEV:
	DW	PRNDEV,CSEG
	DW	1100000000000000B	;CHARACTER DEVICE WITH IOCTL
	DW	STRATEGY
	DW	COM_INT1
	DB	'AUX     '

PRNDEV:                         	;HEADER FOR DEVICE PRN
        DW      TIMDEV,CSEG
	DW	1100000000000000B	;CHARACTER DEVICE WITH IOCTL
        DW      STRATEGY
        DW      LPT1_ACT
        DB      "PRN     "

TIMDEV:                         	;HEADER FOR DEVICE CLOCK
        DW      COM1DEV,CSEG
        DW      8008H
        DW      STRATEGY
        DW      TIM_INT
        DB      "CLOCK$  "

COM1DEV:
	DW	COM2DEV,CSEG
	DW	1100000000000000B	;CHARACTER DEVICE WITH IOCTL
	DW	STRATEGY
	DW	COM_INT1
	DB	'COM1    '
PAGE

COM2DEV:
	DW	COM3DEV,CSEG
	DW	1100000000000000B	;CHARACTER DEVICE WITH IOCTL
	DW	STRATEGY
	DW	COM_INT2
	DB	'COM2    '

COM3DEV:
	DW	COM4DEV,CSEG
	DW	1100000000000000B	;CHARACTER DEVICE WITH IOCTL
	DW	STRATEGY
	DW	COM_INT3
	DB	'COM3    '

COM4DEV:
	DW	COM5DEV,CSEG
	DW	1100000000000000B	;CHARACTER DEVICE WITH IOCTL
	DW	STRATEGY
	DW	COM_INT4
	DB	'COM4    '

COM5DEV:
	DW	LPT1DEV,CSEG
	DW	1100000000000000B	;CHARACTER DEVICE WITH IOCTL
	DW	STRATEGY
	DW	COM_INT5
	DB	'COM5    '

LPT1DEV:				;HEADER FOR DEVICE LPT1
        DW      LPT2DEV,CSEG  	
	DW	1100000000000000B	;CHARACTER DEVICE WITH IOCTL
        DW      STRATEGY       
        DW      LPT1_ACT       
        DB      "LPT1    "     

LPT2DEV:                        	;HEADER FOR DEVICE LPT2
        DW      LPT3DEV,CSEG
	DW	1100000000000000B	;CHARACTER DEVICE WITH IOCTL
        DW      STRATEGY
        DW      LPT2_ACT
        DB      "LPT2    "
PAGE

LPT3DEV:                        	;HEADER FOR DEVICE LPT3
        DW      LPT4DEV,CSEG
	DW	1100000000000000B	;CHARACTER DEVICE WITH IOCTL
        DW      STRATEGY
        DW      LPT3_ACT
        DB      "LPT3    "

LPT4DEV:                         	;HEADER FOR DEVICE LPT4
        DW      LPT5DEV,CSEG
	DW	1100000000000000B	;CHARACTER DEVICE WITH IOCTL
        DW      STRATEGY
        DW      LPT4_ACT
        DB      "LPT4    "

LPT5DEV:                         	;HEADER FOR DEVICE LPT5
        DW      DSKDEV,CSEG
	DW	1100000000000000B	;CHARACTER DEVICE WITH IOCTL
        DW      STRATEGY
        DW      LPT5_ACT
        DB      "LPT5    "

DSKDEV:                         	;HEADER FOR FLOPPY DISK DEVICES
        DW      WINDEV,CSEG     
        DW      2000H           	;IS A BLOCK DEVICE
        DW      STRATEGY
        DW      DSK_INT
	DB      2,7 DUP (0)     	;NUMBER OF UNITS


WINDEV:					;HEADER FOR HARD DISK DEVICES
	DW	-1,-1			;LAST IN DEVICE HEADER QUEUE
	DW	2000H			;IS A BLOCK DEVICE
	DW	WI_STRATEGY
	DW	WI_INTERRUPT
	DB	0,7 DUP (0)
PAGE

;--------------------------------------------------------
; RE_INIT IS CALLED BY SYSINIT AFTER DEVICE INSTALLATION  
;--------------------------------------------------------

RE_INIT	PROC	FAR
	
	PUSHF
	PUSH	AX
	IN	AL,91H			;UNMASK TIMER 2 INTERRUPT
	AND	AL,0FEH
	OUT	91H,AL
	POP	AX
	POPF
	RET

RE_INIT	ENDP

;-------------------------------------------
; MEM_SIZE_DET
; RETURNS TOTAL MEMORY SIZE IN AX (K-BYTES)
; ENTERED VIA INTERRUPT 12H
;------------------------------------------- 

MEM_SIZE_DET	PROC 	NEAR

	MOV	AX,CS:MEMORY_SIZEK		;MEMORY SIZE TO AX (K-BYTES)
	IRET

MEM_SIZE_DET	ENDP

;---------------------------------------------------
; INT_TRAP
; DOES INTERRUPT RETURN FOR ALL UNSPECIFIED VECTORS
;---------------------------------------------------

INT_TRAP	PROC	NEAR

	IRET

INT_TRAP	ENDP

;------------------------------------------------------------
; STRATEGY	SAVES REQUEST HEADER POINTER ES:BX AT PTRSAV
;------------------------------------------------------------
 
STRATEGY	PROC	FAR

	MOV	WORD PTR CS:PTRSAV,BX
	MOV	WORD PTR CS:PTRSAV+2,ES
	RET

STRATEGY	ENDP

;----------
; IO STACK
;----------

EVEN
IOSTACK		DW	40 DUP (0)
STACKTOP:	DW	0

CSEG    ENDS
        END	INIT
