page 65,132
title	CONFIG Utility V. 2.5    for MS-DOS 2.04.00
;
;	*******************************************************
;	*******************************************************
;	******						*******
;	******     C O N F I G    U T I L I T Y		*******
;	******						*******
;	*******************************************************
;	*******************************************************
;
;
;
;
;*****************************************************************************
;*********                                                          **********
;*********                      CHANGE SHEET                        **********
;*********                                                          **********
;*****************************************************************************
;
;     Date               Changes Made                                     By
;_____________________________________________________________________________
;   7-06-84   I   Original Entry                                       I  HD 
;   7-09-84   I   all return/exit function requests are selected via   I 
;             I   'X' or 'x'                                           I  HD
;   7-12-84   I a)Correction of SPAR G2845 flex conf.destroyes IO.SYS  I  HD
;             I b)Wait-loop added for getting answers read             I  HD
;             I c)Change of Display Disk Configuration    SPAR Q2836   I  HD
;             I d)header two of Exit program  corrected                I  HD
;   7-17-84   I a)changes to IOBASE module request changes on CONFIG   I  HD
;             I b)no request for buffered interface K815 needed        I  HD
;             I c)set printer IF flag in IOBASE for applications as    I
;             I    system printer PRN is set                           I  HD
;             I                                                        I
;   7-19-84   I  Change to old IOBASE : change of memory dependend     I
;             I   addresses                                            I  HD
;   7-24-84   I  CONFIG.SYS created not allways                        I  HD
;   7-27-84   I  Message of function key entering (mess4) corrected    I  HD
;   8-30-84   I  Special write protect.  added                         I  HD
;             I                                                        I
;_____________________________________________________________________________
;      
PAGE
cseg	segment
	assume cs:cseg,ss:cseg,es:cseg,ds:cseg
;
;
org 100h
START:
;
	mov	ax,cs
	mov	ss,ax
	mov	ds,ax				; set all segment registers
	mov	ax,start_iosys
	mov	es,ax
	mov	ax,offset stack_e
;
;
	mov	sp,ax			; set SP to top of stack
 	jmp	beg00
page
;*****************************************************************************
;************			DATA  SEGMENT			**************
;*****************************************************************************
;
;
;
;
;		***********************************
;		*****	STRING TABLE	***********
;		***********************************
;
;
;********************  VERSION  NUMBER   ************************************
;
;
	vers1	db	"CONFIG UTILITY FOR NCR DECISION MATE V$"
	vers2	db	"VERSION   2.5$"
	vers3	db	"COPYRIGHT (C),  NCR CORPORATION 1984$"
;
;
;
;********************   FUNCTION TABLE   ************************************
;
	line_era	db	1bh,5bh,4bh,24h
	screen_era	db	1bh,5bh,32h,4ah,24h
	cursor_set	db	1bh,3dh
	L		db	20h
	C		db	20h
			db	24h
	func_string	db	1bh,5bh,30h,3bh
	FH		db	00h
	FL		db	00h
			db	3bh
	string_c	db	100h dup (20h)
			db	22h,70h,24h
;
;
;********************************************************************
;***************   ERROR TABLE	  ***********************************
;********************************************************************
	error1		db	"NO O.S. DISK IN DRIVE "
	dr_no1		db	"A$"
	error2		db	"WRITE-ERROR ON O.S. DISK$"
	error3		db	"REMOVE DISK AND PUT LAST O.S. DISK ON"
	dr_no3		db	"A$"
	error4		db	"DIRECTORY FULL$"
	error41		db	"DELETE A FILE FROM YOUR O.S. DISK; "
			db	"THEN REPEAT THIS FUNCTION.$"
	error5		db	"DISK FULL$"
	error51		db	"DELETE OR SHORTEN A FILE FROM YOUR O.S. DISK; "
			db	"THEN REPEAT THIS FUNCTION.$"
;
page
;*********************************************************************
;****************	MESSAGE TABLE		**********************
;*********************************************************************
;
;
	mess1		db	"C O N F I G   UTILITY$"
	mess2		db	15h dup("_")
			db	24h
	mess3 		db	"Hit any Key to continue$"
	mess4 		db	"Enter the key combination, enter the definition,$"
	mess5		db	"and terminate by pressing the key combination again.$"
	mess6		db	"Start by addressing the first of the 8 functions you want to display  $"
	mess7		db	"*   R=Retry / O=Return to Main Menu$"
	mess8		db	"no port address available$"
	mess9		db	"Enter Function Key$"
	mess10		db	"ATTENTION: Changes to the disk configuration"
	db	" and the installation/removal of",0dh,0ah
	db	"           a Real Time Clock K803  "
	db	"must be written to disk  (permanent)  and",0dh,0ah
	db	"           must be followed by a restart.  Update the"
	db	" disk, exit CONFIG  and",0dh,0ah
	db	"           then turn off and on the computer when"
	db	" the system prompt appears.$"
	mess11		db	"ATTENTION: This unit is defined at port address"
	db	" (hex.) "
	mess11a		db	"  ",0dh,0ah,0ah
			db	"           Modify your $"
	mess12		db	"!$"		
	mess13		db	"F  1        F1                           $"
		lmess13 equ	$-mess13
			db	"F  2        F2                           $"
			db	"F  3        F3                           $"
			db	"F  4        F4                           $"
			db	"F  5        F5                           $"
			db	"F  6        F6                           $"
			db	"F  7        F7                           $"
			db	"F  8        F8                           $"
			db	"F  9        F9                           $"
			db	"F 10        F10                          $"
			db	"F 11        F11                          $"
			db	"F 12        F12                          $"
			db	"F 13        F13                          $"
			db	"F 14        F14                          $"
			db	"F 15        F15                          $"
			db	"F 16        F16                          $"
			db	"F 17        F17                          $"
			db	"F 18        F18                          $"
			db	"F 19        F19                          $"
			db	"F 20        F20                          $"
			db	"F 21    SHF F1                           $"
			db	"F 22    SHF F2                           $"
			db	"F 23    SHF F3                           $"
			db	"F 24    SHF F4                           $"
			db	"F 25    SHF F5                           $"
			db	"F 26    SHF F6                           $"
			db	"F 27    SHF F7                           $"
			db	"F 28    SHF F8                           $"
			db	"F 29    SHF F9                           $"
			db	"F 30    SHF F10                          $"
			db	"F 31    SHF F11                          $"
			db	"F 32    SHF F12                          $"
			db	"F 33    SHF F13                          $"
			db	"F 34    SHF F14                          $"
			db	"F 35    SHF F15                          $"
			db	"F 36    SHF F16                          $"
			db	"F 37    SHF F17                          $"
			db	"F 38    SHF F18                          $"
			db	"F 39    SHF F19                          $"
			db	"F 40    SHF F20                          $"
			db	"F 41    CTL F1                           $"
			db	"F 42    CTL F2                           $"
			db	"F 43    CTL F3                           $"
			db	"F 44    CTL F4                           $"
			db	"F 45    CTL F5                           $"
			db	"F 46    CTL F6                           $"
			db	"F 47    CTL F7                           $"
			db	"F 48    CTL F8                           $"
			db	"F 49    CTL F9                           $"
			db	"F 50    CTL F10                          $"
			db	"F 51    CTL F11                          $"
			db	"F 52    CTL F12                          $"
			db	"F 53    CTL F13                          $"
			db	"F 54    CTL F14                          $"
			db	"F 55    CTL F15                          $"
			db	"F 56    CTL F16                          $"
			db	"F 57    CTL F17                          $"
			db	"F 58    CTL F18                          $"
			db	"F 59    CTL F19                          $"
			db	"F 60    CTL F20                          $"
			db	"F 61    SHF  1             Numeric Keypad$"
			db	"F 62    SHF  2             Numeric Keypad$"    
			db	"F 63    SHF  3             Numeric Keypad$"    
			db	"F 64    SHF  4             Numeric Keypad$"    
			db	"F 65    SHF  5             Numeric Keypad$"    
			db	"F 66    SHF  6             Numeric Keypad$"    
			db	"F 67    SHF  7             Numeric Keypad$"    
			db	"F 68    SHF  8             Numeric Keypad$"    
			db	"F 69    SHF  9             Numeric Keypad$"    
			db	"F 70         CLR           Numeric Keypad$"    
			db	"F 71    CTL  1             Numeric Keypad$"    
			db	"F 72    CTL  2             Numeric Keypad$"    
			db	"F 73    CTL  3             Numeric Keypad$"    
			db	"F 74    CTL  4             Numeric Keypad$"    
			db	"F 75    CTL  5             Numeric Keypad$"    
			db	"F 76    CTL  6             Numeric Keypad$"    
			db	"F 77    CTL  7             Numeric Keypad$"    
			db	"F 78    CTL  8             Numeric Keypad$"    
			db	"F 79    CTL  9             Numeric Keypad$"    
			db	"F 80    CTL  CLR           Numeric Keypad$"    
			db	"F 81         Cursor Home   Numeric Keypad$"    
			db	"F 82         Cursor Left   Numeric Keypad$"    
			db	"F 83         Cursor Down   Numeric Keypad$"    
			db	"F 84         Cursor Up     Numeric Keypad$"    
			db	"F 85         Cursor Right  Numeric Keypad$"    
			db	"F 86    SHF  +             Numeric Keypad$"    
			db	"F 87    SHF  -             Numeric Keypad$"    
			db	"F 88    SHF  *             Numeric Keypad$"    
			db	"F 89    SHF  /             Numeric Keypad$"    
			db	"F 90    CTL  Cursor Home   Numeric Keypad$"    
			db	"F 91    CTL  Cursor Left   Numeric Keypad$"    
			db	"F 92    CTL  Cursor Down   Numeric Keypad$"    
			db	"F 93    CTL  Cursor Up     Numeric Keypad$"    
			db	"F 94    CTL  Cursor Right  Numeric Keypad$"    
			db	"F 95    CTL  +             Numeric Keypad$"    
			db	"F 96    CTL  -             Numeric Keypad$"    
			db	"F 97    CTL  *             Numeric Keypad$"    
			db	"F 98    CTL  /             Numeric Keypad$"    
	mess14		db	"Function Table overflow ****  no Change is "
			db	"done$"
	mess15		db	"no Initial Definition$"
	mess18		db	"Current Value of Restore Counter on Flex Disk is : $"
	mess19		db	"Current Value of Retry Counter on Flex Disk is   : $"
	mess20		db	"Enter any value from 1 to 9  $"
	mess211		db	", B=A )$"
	mess21		db	"   (Drive unit $"
	mess22		db	"A$"
	mess23		db	"B$"
	mess24		db	"C$"
	mess25		db	"D$"
	mess26		db	"E$"
	mess27		db	"F$"
	mess28		db	"G$"
	mess29		db	"H$"
	mess30		db	"I$"
	mess31		db	"J$"
	mess32		db	")$" 
	mess33		db	"+$"
	mess34		db	"Current Value of Retry Counter on Fixed Disk is   : $"
	mess35		db	"Current Value of Restore Counter on Fixed Disk is : $"
	mess36		db	"  $"
	mess37		db	"Size of one unit "
	mess37a		dw	3520h
	mess37b		db	" megabyte $"
	mess617		db	"*****$"	;for input of 5 numbers
;
;
; 
	messc		db	"<NUL>$"
			db	"<SOH>$"
			db	"<STX>$"
			db	"<ETX>$"
			db	"<EOT>$"
			db	"<ENQ>$"
			db	"<ACK>$"
			db	"<BEL>$"
			db	"< BS>$"
			db	"< HT>$"
			db	"< LF>$"
			db	"< VT>$"
			db	"< FF>$"
			db	"< CR>$"
			db	"< SO>$"
			db	"< SI>$"
			db	"<DLE>$"
			db	"<DC1>$"
			db	"<DC2>$"
			db	"<DC3>$"
			db	"<DC4>$"
			db	"<NAK>$"
			db	"<SYN>$"
			db	"<ETB>$"
			db	"<CAN>$"
			db	"< EM>$"
			db	"<SUB>$"
			db	"<ESC>$"
			db	"< FS>$"
			db	"< GS>$"
			db	"< RS>$"
			db	"< US>$"
	messdel		db	"<DEL>$"
;
;
;
	menu0_1		db	l01,"1) Modify Function and Numeric Key Pad Keys$"                 
		l01	equ	$-menu0_1
	menu0_2		db	l02,"2) Modify Retry/Restore Counter$"
		l02	equ	$-menu0_2
	menu0_3		db	l03,"3) Define Disk Configuration$"
		l03	equ	$-menu0_3
	menu0_3a	db	l03a,"4) Special Write Protection on Flex Disk$"
		l03a	equ	$-menu0_3a
	menu0_4		db	l04,"5) Video Disk System$"
		l04	equ	$-menu0_4
	menu0_5		db	l05,"6) Define up to 5 Printers $"
		l05	equ	$-menu0_5
	menu0_6		db	l06,"7) Define up to 5 Communications Lines$"
		l06	equ	$-menu0_6
	menu0_7		db	l07,"8) Modify Cursor Type$"
		l07	equ	$-menu0_7
	menu0_8		db	l08,"9) Change Number of Lines per Screen$" 
		l08	equ	$-menu0_8
	menu0_9		db	l09,"A) Change Bell$"
		l09	equ	$-menu0_9
	menu0_a		db	l0a,"B) Real Time Clock   K803$"
		l0a	equ	$-menu0_a
	menu0_b		db	l0b,"X) Exit Program$"
		l0b	equ	$-menu0_b
	menu0_e		db	l0e,"*  Enter Selection$"
		l0e	equ	$-menu0_e
;
;
;
	menu1_1		db	l11,"1) Define a Function $"
		l11	equ	$-menu1_1
	menu1_2		db	l12,"2) Display 8 Functions$"
		l12	equ	$-menu1_2
	menu1_e		db	l13,"X) Return to Main Program$"
		l13	equ	$-menu1_e
	menu2_1		db	l21,"1) Modify Retry Counter on Flex Disk$"
		l21	equ	$-menu2_1
	menu2_2		db	l22,"2) Modify Restore Counter on Flex Disk$"
		l22	equ	$-menu2_2
	menu2_3		db	l23,"3) Modify Retry Counter on Fixed Disk$"
		l23	equ	$-menu2_3
	menu2_4		db	l24,"4) Modify Restore Counter on Fixed Disk$"
		l24	equ	$-menu2_4
	menu2_e		db	l2e,"X) $"
		l2e	equ	$-menu2_e
	menu3_1		db	l31,"1) Specify Number of Flex Disks$"
		l31	equ	$-menu3_1
	menu3_2		db	l32,"2) Specify Number of Fixed Disks$"
		l32	equ	$-menu3_2
	menu3_3		db	l33,"3) Display Disk Configuration$"
		l33	equ	$-menu3_3
	menu3_e		db	l3e,"X) $"
		l3e	equ	$-menu3_e
	menu31_1	db	l311,"1) One Flex Disks$"
		l311	equ	$-menu31_1
	menu31_2	db	l312,"2) Two Flex Disks$" 
		l312	equ	$-menu31_2
	menu31_e	db	l31e,"X) Return to Main Program$"
		l31e	equ	$-menu31_e
	menu32_1	db	l321,"1) No Fixed Disk$"
		l321	equ	$-menu32_1
	menu32_2	db	l322,"2) One Fixed Disk$"
		l322	equ	$-menu32_2
	menu32_3	db	l323,"3) Two Fixed Disks$"
		l323	equ	$-menu32_3
	menu32_4	db	l324,"4) Three Fixed Disks$"
		l324	equ	$-menu32_4
	menu32_e	db	l32e,"X) Return$"
		l32e	equ	$-menu32_e
	menu325_1	db	l3251,"1) A fixed disk with two logical units of 5 Megabytes each$"
		l3251	equ	$-menu325_1
	menu325_2	db	l3252,"2) A fixed disk with one logical unit of 10 Megabytes$"
		l3252	equ	$-menu325_2
	menu325_e	db	l325e,"X) Return to Main Program$"
		l325e	equ	$-menu325_e
;
;
	menu3a_0	db	"If you've got (a) 96 TPI flex disk drive(s) and need to write on disks",0dh,0ah
			db	09h,"formatted  on  48 TPI flex disk drives, set write  protection to  OFF.",0dh,0ah
			db	0dh,0ah,09h,09h,09h,"  *** W A R N I N G ***",0DH,0AH,0AH
			db	09h,"48 TPI disks written to on 96 TPI drives may not be readable on",0dh,0ah
			db	09h,"48 TPI drives anymore. Therefore, if your application allows it, ",0dh,0ah
			db	09h,"copy the files you need to a disk formatted on a 96 TPI drive, ",0dh,0ah
			db	09h,"and leave the write protection switch ON.$",0ah,0dh
	menu3a_0a	db	l3a0a,"Currently  O  $"
		l3a0a	equ	$-menu3a_0a
	menu3a_1	db	l3a1,"1) ON$"
		l3a1	equ	$-menu3a_1
	menu3a_2	db	l3a2,"2) OFF$"
		l3a2	equ	$-menu3a_2
	menu3a_e	db	l3ae,"X) Return to Main Program$"
		l3ae	equ	$-menu3a_e
;
;
;
	menu4_0		db	l40,"Initial Definition  "
	menu4_0a	db	"  "
	menu4_0b	db	"  "
		l40	equ	$-menu4_0
	menu4_1		db	l41,"1) YES$"
		l41	equ	$-menu4_1
	menu4_2		db	l42,"2) NO$"
		l42	equ	$-menu4_2	
	menu4_e		db	l4e,"X) Return to Main Program$"
		l4e	equ	$-menu4_e
;
	menu5_1		db	l51,"1) PRN = LPT1$"
		l51	equ	$-menu5_1
	menu5_2		db	l52,"2) LPT2$"
		l52	equ	$-menu5_2	
	menu5_3		db	l53,"3) LPT3$"
		l53	equ	$-menu5_3
	menu5_4		db	l54,"4) LPT4$"
		l54	equ	$-menu5_4
	menu5_5		db	l55,"5) LPT5$"
		l55	equ	$-menu5_5	
	menu5_e		db	l5e,"X) Return to Main Program$"
		l5e	equ	$-menu5_e
	menu6_1		db	l61,"1) AUX = COM1$"
		l61	equ	$-menu6_1
	menu6_2		db	l62,"2) COM2$"
		l62	equ	$-menu6_2	
	menu6_3		db	l63,"3) COM3$"
		l63	equ	$-menu6_3
	menu6_4		db	l64,"4) COM4$"
		l64	equ	$-menu6_4
	menu6_5		db	l65,"5) COM5$"
		l65	equ	$-menu6_5	
	menu6_e		db	l6e,"X) Return to Main Program$"
		l6e	equ	$-menu6_e
;
	menu51_1	db	l511,"1) Port Address (hex.)        "
	menu51_1a	db	"  $"
		l511	equ	$-menu51_1
	menu51_2	db	l512,"2) Serial or Parallel         "
	menu51_2a	db	"P$"
		l512	equ	$-menu51_2	
	menu51_3	db	l513,"3) Delete$"
		l513	equ	$-menu51_3
	menu51_e	db	l51e,"X) Return$"
		l51e	equ	$-menu51_e
	menu52_1	db	l521,"1) Port Address (hex.)  "
	menu52_1a	db	"  $"
		l521	equ	$-menu52_1
	menu52_2	db	l522,"2) Serial or Parallel   "
	menu52_2a	db	"S$"
		l522	equ	$-menu52_2
	menu52_3	db	l523,"3) Stop Bits            $"
		l523	equ	$-menu52_3
	menu52_4	db	l524,"4) Parity               $"
		l524	equ	$-menu52_4
	menu52_5	db	l525,"5) Character Length     $"
		l525	equ	$-menu52_5
	menu52_6	db	l526,"6) Transfer Rate        $"
		l526	equ	$-menu52_6
	menu52_7	db	l527,"7) Protocol             $"
		l527	equ	$-menu52_7
	menu52_8	db	l528,"8) Delete$"
		l528	equ	$-menu52_8
	menu52_e	db	l52e,"X) Return $"
		l52e	equ	$-menu52_e
;
;
	menu5SP	db	"                              $"
	menu5P	db	"Available Port Addresses (hex)$"
	menu6Y1	EQU	"EY"
	menu6Y2	EQU	"$S"
	menu6N1	EQU	"ON"
	menu6N2	EQU	"$ "
;
;
	menu61_1	db	l611,"1) Port Address (hex.)       "
	menu61_1a	db	"  $"
		l611	equ	$-menu61_1
	menu61_3	db	l613,"2) Stop Bits                 $"
		l613	equ	$-menu61_3
	menu61_4	db	l614,"3) Parity                    $"
		l614	equ	$-menu61_4
	menu61_5	db	l615,"4) Character Length          $"
		l615	equ	$-menu61_5
	menu61_6	db	l616,"5) Transfer Rate             $"
		l616	equ	$-menu61_6
	menu61_7	db	l617,"6) Timeout  (ms)             "
	menu61_7a	db	"     $"
		l617	equ	$-menu61_7
	menu61_8	db	l618,"7) Keep Trying (no Timeout)  "
	menu61_8a	db	"  "
	menu61_8b	db	" $"
		l618	equ	$-menu61_8
	menu61_9	db	l619,"8) Continues Request-to-Send "
	menu61_9a	db	"  "
	menu61_9b	db	" $"
		l619	equ	$-menu61_9
	menu61_a	db	l61a,"9) Delete$"
		l61a	equ	$-menu61_a
	menu61_e	db	l61e,"X) Return $"
		l61e	equ	$-menu61_e
;
;
	menu62_1	db	l621,"1) 1     $"
		l621	equ	$-menu62_1
	menu62_2	db	l622,"2) 1 1/2 $"
		l622	equ	$-menu62_2
	menu62_3	db	l623,"3) 2 $"
		l623	equ	$-menu62_3
	
	menu42_1	db	l421,"1) Disable$"
		l421	equ	$-menu42_1
	menu42_2	db	l422,"2) Even$"
		l422	equ	$-menu42_2
	menu42_3	db	l423,"3) Odd$"
		l423	equ	$-menu42_3
	
	menu43_1	db	l431,"1) 5 Bits$"
		l431	equ	$-menu43_1
	menu43_2	db	l432,"2) 6 Bits$"
		l432	equ	$-menu43_2
	menu43_3	db	l433,"3) 7 Bits$"
		l433	equ	$-menu43_3
	menu43_4	db	l434,"4) 8 Bits$"
		l434	equ	$-menu43_4
	
	menu44_1	db	l441,"1) 50 Baud   $"
		l441	equ	$-menu44_1
	menu44_2	db	l442,"2) 75 Baud   $"
		l442	equ	$-menu44_2
	menu44_3	db	l443,"3) 110 Baud  $"
		l443	equ	$-menu44_3
	menu44_4	db	l444,"4) 134.5 Baud$"
		l444	equ	$-menu44_4
	menu44_5	db	l445,"5) 150 Baud  $"
		l445	equ	$-menu44_5
	menu44_6	db	l446,"6) 300 Baud  $"
		l446	equ	$-menu44_6
	menu44_7	db	l447,"7) 600 Baud  $"
		l447	equ	$-menu44_7
	menu44_8	db	l448,"8) 1200 Baud $"
		l448	equ	$-menu44_8
	menu44_9	db	l449,"9) 1800 Baud $"
		l449	equ	$-menu44_9
	menu44_a	db	l44a,"A) 2000 Baud $"
		l44a	equ	$-menu44_a
	menu44_b	db	l44b,"B) 2400 Baud $"
		l44b	equ	$-menu44_b
	menu44_c	db	l44c,"C) 3600 Baud $"
		l44c	equ	$-menu44_c
	menu44_d	db	l44d,"D) 4800 Baud $"
		l44d	equ	$-menu44_d
	menu44_e	db	l44e,"E) 7200 Baud $"
		l44e	equ	$-menu44_e
	menu44_f	db	l44f,"F) 9600 Baud $"
		l44f	equ	$-menu44_f
	menu44_g	db	l44g,"G) 19200 Baud$"
		l44g	equ	$-menu44_g

	menu45_1	db	l451,"1) No     $"
		l451	equ	$-menu45_1
	menu45_2	db	l452,"2) XON/XOFF$"
		l452	equ	$-menu45_2
	menu45_3	db	l453,"3) RDY/BSY$"
		l453	equ	$-menu45_3
	menu45_4	db	l454,"4) ETX/ACK$"
		l454	equ	$-menu45_4
	menu7_1		db	l71,"1) Cursor  On/Off             "
	menu7_1a	db	"O  $"
		l71	equ	$-menu7_1
	menu7_2		db	l72,"2) Blinking/Steady (B/S)      "
	menu7_2a	db	"  $"
		l72	equ	$-menu7_2
	menu7_3		db	l73,"3 Blinking Rate              "
	menu7_3a	db	"      $"
		l73	equ	$-menu7_3
	menu7_4		db	l74,"4) Top Line (0 - 15)          "
	menu7_4a	db	"   $"
		l74	equ	$-menu7_4
	menu7_5		db	l75,"5) Bottom Line (0 - 15)       "
	menu7_5a	db	"   $"
		l75	equ	$-menu7_5
	menu7_e		db	l7e,"X) Return to Main Program$"
		l7e	equ	$-menu7_e
	menu8_0		db	l80,"Current Value of Lines per Screen :  "
	menu8_0a	db	"   $"
		l80	equ	$-menu8_0
	menu8_1		db	l81,"1) 24 Lines$"
		l81	equ	$-menu8_1
	menu8_2		db	l82,"2) 25 Lines $"
		l82	equ	$-menu8_2
	menu8_e		db	l8e,"X) Return to Main Program$"
		l8e	equ	$-menu8_e
	menu9_0		db	l90,"Bell is set :  "
	menu9_0a	db	"O  $"
		l90	equ	$-menu9_0	
	menu9_1		db	l91,"1) ON$"
		l91	equ	$-menu9_1
	menu9_2		db	l92,"2) OFF$"
		l92	equ	$-menu9_2
	menu9_e		db	l9e,"X) Return to Main Program$"
		l9e	equ	$-menu9_e	
;
	menua_1		db	la1,"1) Update O.S.Disk in Drive "
 	menua_dr	db	"A$"
		la1	equ	$-menua_1
	menua_2		db	la2,"2) Return to Main Program$"
		la2	equ	$-menua_2
	menua_e		db	lae,"X) Exit CONFIG$"
		lae	equ	$-menua_e
;
;
;
;
;
;*****************************    TABLE END    *******************************
page
;		****************************
;		***  FILE CONTROL BLOCK  ***
;		****************************
;
;
	FCB		db	0ffh		; extended FCB
			db	5 dup(00h)
			db	06h		; hidden file
	drive_no	db	01h		; drive number 00=default
						;	01= A	02= b
	filename	db	"IO",6 dup(20h) ;
	extention	db	"SYS"		;
	block_no	db	2 dup(00h)	; current block number
	rec_size	dw	10h       	; record size default 80h
	file_size	db	4 dup(?)	; correct size of file
			db	12 dup(00h)	;
	curr_record	db	?		; current record number
			db	4 dup (?)
;
;
;
	fcb1		db	01h,"CONFIG  SYS" ; file name w/i extention
	curr_bl		dw	00h		; current block number
	rec_s		dw	80h		; selected record size
	file_s		dd	00h		; length of whole file
			db	12 dup(00h)
	curr_r  	db	00h		; current record number
			db	4 dup(?)
;
;
;		**************************
;		***   EQUATES NEEDED   ***
;		**************************
;
;*****************  SYSTEM  CALLS   ************************************
	print_string		equ	0900h	; print a string
	in_char_echo		equ	0100h	; get one character from
						;  keyboard and echo it on CRT
	file_open		equ	0f00h	; open a file via FCB
	file_creat		equ	1600h	; creat a new file
	file_read		equ	1400h	; read one record of a file
	file_write		equ	1500h	; write in file via FCB 
	file_close		equ	1000h	; close a file via FCB
	set_trans_add		equ	1a00h	; set transfer address of disk
						;  file I/O
	chdir			equ	3b00h	; change current directory
	curr_disk		equ	1900h	; get number of actuell drive 
	disp_char		equ	0200h	; display only one character
	in_wo_echo		equ	0700h	; get one char.from keyboard
	inp_buf_e		equ	0a00h	; fill buffer from kbd input
	open_io			equ	3D02h	; open file handle for i/o
	ioctl_wr		equ	4403h	; write via ioctl call
	ioctl_rd		equ	4402h	; read via ioctl call
	close_io		equ	3E00h	; close a file handle
;
;
;
;*****************  INTERRUPTS      ***************************************
	func_request		equ	21h	; interrupt:function request
;
;
;*****************  MEMORY  DEPENDEND   ***********************************
	start_iosys		equ	40h	; start segment of IO.SYS
	flex_drives		equ	13h	; address of flex.table
	fl_in_retries		equ	15h	; rel.address of retry counter
	fl_out_retries		equ	14h	; rel.address of restore counter
	winch_drives		equ	16h	; address of winch.table
	wi_in_retries		equ	18h	; rel.address of retry counter
	wi_out_retries		equ	17h	; rel.address of restore counter
	wi_flags		equ	28h	; address of flags for winch.flags
	config_flags		equ	23h	;address of console flags (RTC)
	keybfunc_tbl		equ	2eh	;address for offset of function keys
	PRN			equ	30h	; offset of PRN-table in IO.SYS
	printer_if_type		equ	19h	; offset of "S"or"P" flag for applications
	m1_2rs232		equ	1ah	;mode of 1.printer IF if serial
;
;*****************  ADDITIONALS     ****************************************
	wi_10mb			equ	80h	; bit 7 of wi_flags =1 for 10Mb
						;		    =0 for 5Mb
	winch_port		equ	0C0h	; port address of hard disks
;
;
	last_func		equ	98d	; total number of functions
	no_drives		db	?	; current no.of drives
	first_drive		dw	?	; address of first drive name
;
;
	fun1_request	db	"F"		; prefix for IOCLT-call get addess
						;  of function key def. table
	fun1		dw	?		; offset on function table
	funclen		equ	610		; max.length of total function keys
	fctbl			db	last_func dup (?) ; length of all functions
	last_menu		dw	?	; offset to last menu displayed
	last_ans0		db	?	; last answer to menu 0
	last_ans1		db	?	; last answer to 2.menu
	ATT			db	00h	; for Attention message on exit
						;  =01 RTC integrated or removed
						;  =02 disk conf. changed
	six			db	06h	; needed for multiplication
	string_end		equ	24h	; last character of print string
	func_end		equ	70h	; last character of ESC-sequence
						;  for changings on keyboard
	quot_mark		equ	22h	; quotation mark
	semicolon		equ	3bh
	tab			equ	09h	; tabulator
	stopbit			equ	01000000b ; m1rs232
	parity			equ	00010000b ; m1rs232
	even_parity		equ	00100000b ; m1rs232
	char_len		equ	00000100b ; m1rs232
	root			db	5ch,00h  ; symbol to define the root directory
;
buff_inp	db	7			;buffer used for buffered kbd
	buff_length  db ?			;input,length w/o CR
	buff_input   db 7 dup (?)		;5 bytes needed,but BS on last
						;character possible via 6 + CR
;
decitbl		dw	10000,1000,100		;table used to get decimal from
ten		dw	10,1			;hex. value
;
;
	handle	db	"COM"			;complete filename for communications
	handle1 db	"     ",0		;lines
;
	phandle db	"LPT"			;complete filename for printers
	phandle1 db	"     ",0	
;
	cu_li_bell		db	8 dup (?)	;1-4 cursor
							;5,6 line
							;7,8 bell
;
	PRN_length	equ	4	; length of one PRN-table	
	parallel	equ	80h	; Protocol = parallel flag
;
	PRNTBL	struc
	port		db	?	; Port Address
	mode1		db	?	; Mode 1 for RS232 Interface
	mode2		db	?	; Mode 2  "    "      "
	protocol	db	?	; Protocol Type bit 7 = 1 parallel
					;		      = 0 serial
					;	bit 0-2       = 0 no serial protocol
					;		      = 1 XON/XOFF
					;		      = 2 RDY/BSY
					;		      = 3 ETX/ACK
	PRNTBL ends
;	
;	
	video_bit	equ	10h	;bit in consol-flag set if video disk system
	video_port	equ	0B0h	;port address of video disk
	RTC_bit		equ	01h	;bit for RTC in console flags
	RTC_port	equ	0C8h	;port address of real time clock
	AUX		db	40 dup (?) ;table of communications COM1 - COM5
	COM_length	equ	08h	;length of one communication table
	full_d_com	equ	37h	;commamnd byte for full duplex
	half_d_com	equ	17h	;   "      "    "  half   "
;
	COMTBL   struc
	cport		dw	?	;port address
	cmode1		db	?	;mode 1 for RS232 interface
	cmode2		db	?	;mode 2 for RS232 interface
	ccom		db	?	;command for RS232   "
	cflags		db	?	;bit 7  =0 return on timeout
					;	=1 keep trying till ^C
					;bit 6  =0 unbuffered interface
					;	=1 buffered comm.interface
					;bit 5  =0 continues RTS
					;	=1 RTS only for send(half duplex)
	timeout		dw	?	;timeout on DSR or CTS line
	COMTBL	ends
;
;
commflags record keep_try:1,buff_int:1,full_dup:1,not_used:5
;
;
;**********************************************************************
;*********	TABLES TO GET ALL FREE PORT ADDRESSES (OF K801)  ******
;**********************************************************************
;
	tbl1	db	30h,38h,60h,68h,70h,78h,0b0h,0b8h,0c0h,0c8h
	tbl2	db	13 dup (00h)
	tbl3	db	11 dup (00h)
;
	port_tbl db	30h,"30$",38h,"38$",60h,"60$",68h,"68$",70h,"70$"
		db	78h,"78$",0b0h,"B0$",0b8h,"B8$",0c0h,"C0$",0c8h,"C8$"
;
	tbl4	db	"COM5$COM4$COM3$COM2$COM1$"
		DB	"LPT5$LPT4$LPT3$LPT2$LPT1$"
; ************** NEEDED FOR SEARCHING 'RECORD' IN FILE : CONFIG.SYS  **********
; 
	trans_addr		db	127 dup(00h)	; TRANSFER BUFFER FOR
	trans_end		db	00h		; CONFIG.SYS  FILE
	rec0			db	0dh,0ah		; BEGIN ADDING NEEDED
							; WITH A NEW LINE
	rec1			db	"DEVICE=TIMDRIVE.SYS C8 00 00" ; NEEDED RECORD
	rec2			db	0dh,0ah,1ah	; ending record
	lw			db	6,21		; LENGTH OF STEPS FOR
							; SEARCHING THE RECORD
	file_flag		db	?		; RETURNING FLAG AFTER
							; READING CONFIG.SYS
	offs_first		dw	?		; BEGIN OF RECORD IN
							; TRANSFER BUFFER
	offs_last		dw	?		; END OF RECORD IN
							; TRANSFER BUFFER + 1
	remain			db	?		; NUMBER OF BYTES > 20H
							; IF RECORD WAS LAST 
							; FILE ENTRY
	rem2			dd	?		; FILE SIZE STORE
	rem1			db	00h		; return addr. for cut records
	rec_cut			db	00h		; FLAG=0 'RECORD' FOUND
							;        IN 1 PHYSICAL
							; FLAG=1 'RECORD' FOUND
							;        IN 2 CONT.PHYS.
;
include kc-fn.tbl
;
;
;
PAGE
;****************************************************************************
;********		CODE SEGMENT			*********************
;****************************************************************************
;
;	*****************************************************************
;	****		P R O C E D U R E S			*********
;	*****************************************************************
					; ENTRY CONDITIONS :
					;	dx = offset to string
					;	C  = column of string begin
					;	L  = line of string 
di_strings	proc   			; porcedure to send a string to CRT
	inc	dx			; first character is length of string
di_string:				;     string must be filled completely
	push	dx			; and correctly
	mov	dx,offset cursor_set		; set pointers requested by
	mov	ax,print_string			; system call
	int	func_request			; send interrupt function call
	pop	dx
di_string0:
	mov	ax,print_string
	int	func_request
	ret
di_strings	endp
;
;
;
inp_echo	proc			; process to get one character from
					; keyboard incl. echo to CRT
					; no conditions , only register AX will
					; change
	mov	ax,in_char_echo
	int	func_request
	ret
inp_echo	endp
;
;
;
;
wait_loop	proc
	push	ax			;timer to leave a display on screen
	push	bx			;of aa short time
	push	cx
	push	dx
	mov	cx,2fffh
	mov	bx,1
	mov	ax,1111h
wait_l1:
	imul	bx
	loop	wait_l1
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	ret
wait_loop	endp
page
inp_wo:
	mov	ax,in_wo_echo			; get one input char.from 
	int	func_request			; keyboard
	ret
;
;
;
header_one:				; no CONDITIONS
	mov	dx,offset screen_era
	call	near ptr di_string0		; screen erase
	mov	L,22h				; line 1
	mov	C,3bh				; column 28 (position 28)
	mov	dx,offset mess1
	call	near ptr di_string		; display header
	mov	L,23h				; line 2
	mov	dx,offset mess2
	call	near ptr di_string		; underline header
	mov	L,25h				
	mov	C,20h
	ret
;
;
;
header_two:		; CONDITIONS :  al = answer of last menu
	call	header_one		; display header
	mov	al,last_ans0			; get last menu answer
	mov	dx,offset menu0_1
	call	head_string			; display second header
	ret	
;
;
;
header_three:		; CONDITIONS :  al = answer of last menu
	call	clear_L6           		; clear lines of menu
	mov	L,26h
	mov	dx,last_menu
	mov	al,last_ans1
	call	head_string       		; display second header 
	ret
;
;
;
menu_d:			; CONDITION:  bx = menu begin  ,  cx = menu end
	inc	L				; next line
	mov	dx,bx				; get next message
	add	bl,byte ptr [bx]
	jnc	menu_d1
	inc	bh
menu_d1:
	call	near ptr di_strings		; display lines of menu 
	cmp	dx,cx				; if last line is not displayed
	jnz	menu_d				; continue
	inc	L
	ret
;
;
;
enter_func:			; returns answer in al
	mov	dx,offset menu0_e
	call	di_strings			; display "enter function"
enter_f1:
	mov	dx,offset cursor_set		;
	call	di_string0
	call	inp_echo			; get answer
	mov	last_ans1,al
	ret
;
;
;
head_string:			; CONDITIONS:   al = answer to a menu
				;		dx = top of last menu	
				;		L and C correct
				;	bx,cx,dx will be destroyed
	cmp	al,39h			;for answer > 9  
	jbe	head_str0
	or	al,20h
	sub	al,27h			;get correct hex value
head_str0:
	sub	al,30h
	mov	ah,00
	mov	cx,ax
	mov	bx,00
	xchg	bx,dx
head_str1:
	add	bx,dx
	mov	dl,[bx]				; get offset to mess.of 
	loop	head_str1			; selected funct. in last menu
	xchg	dx,bx
	add	dx,4
	call	di_string
	add	L,2
	ret
;
;
;
clear_L6:
	mov	L,26h
	mov	C,20h
	mov	dx,offset line_era
clear_L61:
	call	di_string 			; clear all lines of menu
	inc	L
	cmp	L,39h				; until last of screen
	jnz	clear_L61
	ret
page
di_fst:					; entry conditions:
					;	ds = dseg
					;	dl = char.for display
	cmp	dl,7fh				; for control characters
	jz	di_fst4				; display a string
	cmp	dl,20h				; to show there ASCII value
	jnb	di_fst2
di_fst4:
	cmp	C,6bh				; will line be long enough
	jna	di_fst1				; to print string of 5 char.
	call	near ptr next_line		; if not,go to next line
di_fst1:
	cmp	dl,7fh				; for DEL get diff. string
	jz	di_fst5				; offset
	mov	al,dl
	mul	six
	mov	dx,ax				; get offset to correct
	add	dx,offset messc			; control character string
di_fst6:
	call 	near ptr di_string0		; display string of control 
	add	C,5
	jmp	near ptr di_fste		; return
;
di_fst2:
	cmp	C,6fh				; if normal character shall be
	jna	di_fst3				; displayed
	call	near ptr next_line
di_fst3:
	mov	ax,disp_char			; function call to display only
	int	func_request			; one character
	inc	C
di_fste:
	ret
;
di_fst5:
	mov	dx,offset messdel
	jmp	short di_fst6
page
next_line:			; position cursor to next line
				; if next line = 23, ask for erasing lines 7-24
				; and continue in line 7
				; CONDITIONS: ax distroyed
				;	   L and C get new value
	push 	dx				; save message offset
	cmp	L,35h
	jb	next_l2				; no erasing necessary
next_l3:
	mov	C,42h				; column 35
	mov	L,37h				; line 24
	mov	dx,offset mess3			; "hit <CR> to continue"
	call	near ptr di_string
	call	near ptr inp_echo		; wait for any answer
	mov	C,20h
	mov	dx,offset line_era		;
next_l1:
	call	near ptr di_string		; erase all lines
	dec	L				;  24 ... 7
	cmp	L,29h
	jnz	next_l1	
next_l2:
	inc	L
	mov	C,20h
	mov	dx,offset cursor_set
	call	near ptr di_string0
	pop	dx
	ret
;
;
;
get_fno	proc
	push	bx
	sub	al,80h			; get offset instead of number
	jc	get_b
	mov	bx,offset kc_fn_tb
	xlat
	jnz	get_c
get_b:
	stc
	pop	bx
	ret
get_c:
	clc
	pop	bx
	ret
;
get_fno		endp
page	
;	****************************************************************
;	****		R O U T I N E S				********
;	****************************************************************
beg00:
	mov	dx,offset screen_era		; clear screen
	call	di_string0
	mov	L,2ah
	mov	C,20h
	mov	dx,offset vers1			; display version
	call	di_string			; number of CONFIG
	inc	L
	mov	dx,offset vers2
	call	di_string
	inc	L
	mov	dx,offset vers3
	call	di_string
	mov	cx,0ffffh
	mov	bx,1
	mov	ax,1111h
beg0:
	imul	bx				; number
	loop	beg0
;
	mov	dx,word ptr es:[keybfunc_tbl]	; get offset to function key table
	mov	fun1,dx				; save start address
;
;
begin:
	call	header_one				; display header 
	mov	cx,offset menu0_b + 1
	mov	bx,offset menu0_1
	call	menu_d				; display menu0
	inc	L
begin1:
	call	enter_func			; get answer to menu0
	mov	last_ans0,al			; save menu 0 answer
	cmp	al,31h				; answer = 1
	jz	ch_d_fun			; perform menu 2
	cmp	al,32h				; answer = 2
	jnz	beg2
	jmp	ret_rest_c
beg2:		
	cmp	al,33h				; answer = 3
	jnz	beg3
	jmp	disk_config
beg3:
	cmp	al,34h				; answer = 4
	jnz	beg4
	jmp	write_protect 
beg4:
	cmp	al,35h				; answer = 5
	jnz	beg5
	jmp	video_sys
beg5:
	cmp	al,36h				; answer = 6
	jnz	beg6
	jmp	def_printer
beg6:
	cmp	al,37h				; answer = 7
	jnz	beg7
	jmp	def_comm
beg7:
	cmp	al,38h				; answer = 8
	jnz	beg8
	jmp	m_cursor
beg8:
	cmp	al,39h				; answer = 9
	jnz	bega
	jmp	ch_lines
bega:
	or	al,20h
	cmp	al,61H				; answer = A
	jnz	begb
	jmp	ch_bell
begb:
	cmp	al,62h
	jnz	begc				; answer = B
	jmp	RTC_sys
begc:
	cmp	al,78h				; answer = X
	jnz	near ptr begin1			; answer not allowed : retry
	mov	last_ans0,62h
	jmp	exit_p				; terminate program
page
include func.hlp
include disk.hlp
include video.hlp
include print.hlp
include comm.hlp
include cursor.hlp
include lines.hlp
include bell.hlp
include RTC.hlp
include exit.hlp
;
;
;**********************************************************************
;*****************	STACK	SEGMENT		**********************
;*********************************************************************
;
;
s_stack	db	150h dup (?)
stack_e:
	db	2 dup (?)
cseg	ends
end	START

