PAGE 65,132
TITLE RS232 COMMUNICATIONS DRIVER FOR NCR DECISION MATE V

;******************************************************************************
;*********                                                           **********
;*********                     CHANGE SHEET                          **********
;*********                                                           **********
;******************************************************************************
;									    
;   DATE                       CHANGES MADE                         SPARS   BY
;------------------------------------------------------------------------------
; 06-26-84 I ORIGINAL ENTRY                                       I       I WK 
; 06-28-84 I ALLOW CONTROL-C ABORT FOR BUFFERED INTERFACE HANGUP  I G2813 I WK
; 07-12-84 I K215 CONTROLLER HANDSHAKING NOT ABORTABLE            I G2859 I WK
; 07-12-84 I INTERFACE TYPE AUTOSCAN IMPLEMENTED                  I G2858 I WK
; 08-10-84 I TIMEOUT HANDLING FOR BUFFERED INTERFACE CORRECTED    I       I WK
;------------------------------------------------------------------------------
PAGE

;------------------------------------------------------------------------------
;
; MODULE:	COMDRV	RS232 COMMUNICATIONS DRIVER 
;		
; CONTENTS:	- MS-DOS CALLS SUPPORT FOR BUFFERED AND UNBUFFERED INTERFACES
;		- INTERRUPT 14H SUPPORT FOR BUFFERED AND UNBUFFERED INTERFACES
;
;------------------------------------------------------------------------------
PAGE

CSEG	SEGMENT	PUBLIC	'CODE'
ASSUME 	CS:CSEG,DS:CSEG,ES:CSEG

;-----------------------------
; REFERENCES TO OTHER MODULES
;-----------------------------

EXTRN	AUXTBL:WORD,COM2TBL:BYTE,COM3TBL:BYTE,COM4TBL:BYTE,COM5TBL:BYTE
EXTRN	KBD_BUFF_IN:NEAR,PTRSAV:DWORD

PUBLIC	COM_INT1,COM_INT2,COM_INT3,COM_INT4,COM_INT5,RS232_INT

;-----------------------------------------
; OFFSETS TO PORT BASE ADDRESSES PCI 2661
;-----------------------------------------

DREAD		EQU	0		;READ DATA
SREAD		EQU	1		;READ STATUS
MREAD		EQU	2		;READ MODE REGISTERS 1 AND 2
CREAD		EQU	3		;READ COMMAND REGISTER
DWRITE		EQU	4		;WRITE DATA
S1S2DLE 	EQU	5		;SYN1 SYN2 DLE
MWRITE		EQU	6		;WRITE MODE REGISTERS 1 AND 2
CWRITE		EQU	7		;WRITE COMMAND REGISTER

;-------------------
; COMMANDS PCI 2661
;-------------------

RTS		EQU	20H		;REQUEST TO SEND LINE
RESET_ERROR	EQU	10H

;---------------------------------
; INTERFACE STATUS LINES PCI 2661
;---------------------------------

DSR		EQU	80H		;DATA SET READY
CTS		EQU	01H		;CLEAR TO SEND (SAME AS TXRDY)
DCD		EQU	40H		;DATA CARRIER DETECT
FRAME		EQU	20H		;FRAMING ERROR
OVERR		EQU	10H		;OVERRUN ERROR
PARER		EQU	08H		;PARITY ERROR
TXEMT		EQU	04H		;TRANSMIT SHIFT REGISTER EMPTY
RXRDY		EQU	02H		;RECEIVE HOLDING REGISTER HAS DATA
TXRDY		EQU	01H		;TRANSMIT HOLDING REGISTER EMPTY	 	 		

;----------------------------------
; KEYBOARD PORTADDRESSES AND CODES
;----------------------------------

KBD_STAT	EQU	41H		;KEYBOARD STATUS PORT
KBD_DATA	EQU	40H		;KEYBOARD INPUT DATA PORT
CONTROL_C	EQU	03H		;CONTROL_C KEY COMBINATION
PAGE

;------------------------------------------------
; OFFSETS TO PORT BASE ADDRESS OF INTERFACE K215
;------------------------------------------------

BUART		EQU	0		;UART DATA PORT OFFSET
BCMST		EQU	1		;COMMAND/STATUS PORT OFFSET

;----------------
; STATUS OF K215
;----------------

BOUTF		EQU	1		;OUTPUT BUFFER FULL
BINF		EQU	2		;INPUT BUFFER FULL

;----------------------------------
; TIMEOUT VALUE FOR INTERFACE TEST
;----------------------------------

INIT_TO		EQU	50

;---------------
; COMMANDS K215
;---------------

BSCMD		EQU	0		;SEND UART COMMAND
BSM12		EQU	1		;SEND UART MODE BYTE 1 AND 2
BRUST		EQU	3		;RECEIVE UART STATUS BYTE
BRUCM		EQU	4		;RECEIVE UART COMMAND BYTE
BRDAT		EQU	8		;RECEIVE DATA BYTE
BTDAT		EQU	9		;TRANSMIT DATA BYTE
PAGE

;---------------------
; MS-DOS ERROR STATII
;---------------------

DONE		EQU	0100H
WRITE_FAULT	EQU	810AH
READ_FAULT	EQU	810BH
ILL_COMMAND     EQU	8103H
BUSY		EQU	0300H
TOUT		EQU	8102H
ILL_UNIT	EQU	8101H

;------------------------
; STRUCTURES AND RECORDS
;------------------------

COMM_PRO RECORD	 KEEP_TRYING:1,BUF_COM:1,FDX_COM:1,UNDEFP:5

COMM_STA RECORD  NDI_ERR:1,NDI:1,UNDEFS:6

COMM_PAR_LEN	EQU	11		;LENGTH OF CHANNEL PARAMETER AREA

COMM_PAR	STRUC

COM_PORT	DW	?		;PORT ADDRESS
COM_MR1		DB	?		;MODE REGISTER 1 
COM_MR2		DB	?		;MODE REGISTER 2
COM_CMD		DB	?		;COMMAND
COM_PRO		DB	?		;PROTOCOL
COM_TO		DW	?		;TIMEOUT (MS)
COM_LSTAT	DB	?		;LINE STATUS	
COM_STAT	DB	?		;COMMUNICATION STATUS FLAGS
COM_NDI		DB	?		;CHARACTER BUFFER FOR NON DEST. INPUT

COMM_PAR	ENDS

REQ_HEADER	STRUC
	
CMDLEN		DB	?		;LENGTH OF THIS COMMAND
UNIT		DB	?		;SUB UNIT SPECIFIER
CMD		DB	?		;COMMAND CODE
STATUS		DW	?		;STATUS
		DB	8 DUP (?)
MEDIA		DB	?		;MEDIA DESCRIPTOR
TRANS		DD	?		;TRANSFER ADDRESS
COUNT		DW	?		;COUNT OF BLOCKS OR CHARACTERS

REQ_HEADER	ENDS
PAGE
;------------
; RELEASE ID
;------------

	DB	2,4,0

;---------------------------------------------
; COMMAND JUMP TABLE FOR UNBUFFERED INTERFACE
;---------------------------------------------

EVEN 
COMTBL:
	DW	INIT
	DW	EXIT
	DW	EXIT
	DW	CONTROL_IN
	DW	INPUT
	DW	ND_INPUT
	DW	EXIT
	DW	IN_FLUSH
	DW	OUTPUT
	DW	OUTPUT
	DW	OUTPUT_STATUS
	DW	EXIT
	DW	CONTROL_OUT
	DW	CMDERR
	DW	CMDERR
	DW	CMDERR

;-------------------------------------------
; COMMAND JUMP TABLE FOR BUFFERED INTERFACE
;-------------------------------------------

BUFTBL:
	DW	INIT
	DW	EXIT
	DW	EXIT
	DW	CONTROL_IN
	DW	BUF_INPUT
	DW	BUF_NDINPUT
	DW	EXIT
	DW	BUF_INFLUSH
	DW	BUF_OUTPUT
	DW	BUF_OUTPUT
	DW	BUF_OUTSTA
	DW	EXIT
	DW	CONTROL_OUT
	DW	CMDERR
	DW	CMDERR
	DW	CMDERR

COMM_P_TBL:
	DW	OFFSET AUXTBL
	DW	OFFSET COM2TBL
	DW	OFFSET COM3TBL
	DW	OFFSET COM4TBL
	DW	OFFSET COM5TBL

PAGE

;----------------------------------------------------------------------------
; COM_INTX	MS-DOS CALLS COM_INTX RIGHT AFTER PASSING THE REQUEST HEADER
;----------------------------------------------------------------------------

COM_INT1:
	PUSH	SI
	MOV	SI,OFFSET AUXTBL	;AUX/COM1 SELECTED
	JMP SHORT ENTRY
COM_INT2:
	PUSH	SI
	MOV	SI,OFFSET COM2TBL	;COM2 SELECTED			
	JMP SHORT ENTRY
COM_INT3:
	PUSH	SI
	MOV	SI,OFFSET COM3TBL	;COM3 SELECTED
	JMP SHORT ENTRY
COM_INT4:
	PUSH	SI
	MOV	SI,OFFSET COM4TBL	;COM4 SELECTED
	JMP SHORT ENTRY
COM_INT5:
	PUSH	SI
	MOV	SI,OFFSET COM5TBL	;COM5 SELECTED

ENTRY:
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	DI
	PUSH	DS
	PUSH	ES
	PUSH	CS
	POP	DS
	LES	BX,[PTRSAV]
	MOV	ES:[BX.STATUS],DONE
	MOV	DI,OFFSET COMTBL
	TEST	[SI.COM_PRO],MASK BUF_COM
	JZ	ENTRY1
	MOV	DI,OFFSET BUFTBL		
ENTRY1:
	MOV	AL,ES:[BX.CMD]
	SHL	AL,1
	AND	AX,001EH
	ADD	DI,AX
	MOV	CX,ES:[BX.COUNT]	;CX = TRANSFER COUNT
	MOV	DX,[SI.COM_PORT]	;DX = BASE PORT ADDRESS
	CMP	DL,30H			;DX < 30H FOR UNKNOWN UNIT
	JB	UNK_UNIT
CTL_ENT:
	CALL	CS:[DI]			;GO DO COMMAND

EXIT	PROC	FAR

	POP	ES
	POP	DS
	POP	DI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	POP	SI
	RET

EXIT	ENDP
PAGE

UNK_UNIT:				;UNKNOWN UNIT
	CMP	AX,6			;IOCTL INPUT
	JE	CTL_ENT			
	CMP	AX,18H			;IOCTL OUTPUT
	JE	CTL_ENT
	MOV	ES:[BX.STATUS],ILL_UNIT
	JMP	SHORT EXIT


CMDERR:					;UNKNOWN COMMAND ERROR
	MOV	ES:[BX.STATUS],ILL_COMMAND
	RET

;-----------------------------------------
; INIT - INTERFACE INITIALIZATION ROUTINE
;-----------------------------------------

INIT:
	CMP	DX,30H			;SEE IF LEGAL PORTADDRESS
	JB	EXINIT			; SKIP INITIALIZATION IF NOT
	INC	DX			;DX = X1H
	CLI
	CALL	IWAITIE			;TRY TO INITIALIZE BUFFERED INTERFACE
	JZ	INITU			;ON TIMEOUT GO TO UNBUFFERED INIT ROUT.
	MOV	AL,BSCMD		;SEND COMMAND TO BUFFERED INTERFACE
	OUT	DX,AL 
	CALL	IWAITIE			;WAIT FOR INPUT BUFFER EMPTY
	JZ	INITU			;ON TIMEOUT GO TO UNBUFFERED INIT ROUT.
	DEC	DX
	MOV	AL,[SI.COM_CMD]		;SEND UART COMMAND
	OUT	DX,AL
	INC	DX			;DX = X1H
	CALL	IWAITIE			;WAIT FOR INPUT BUFFER EMPTY
	JZ	INITU			;ON TIMEOUT GO TO UNBUFFERED INIT ROUT.
	MOV	AL,BRUCM		;RECEIVE UART COMMAND BYTE
	OUT	DX,AL
	CALL	IWAITOF			;WAIT FOR OUTPUT BUFFER FULL
	JZ	INITU			;ON TIMEOUT GO TO UNBUFFERED INIT ROUT.
	DEC	DX
	IN	AL,DX			;AL = UART COMMAND SENT OUT IF BUFFERED
	INC	DX
	OR	AL,RESET_ERROR
	CMP	AL,[SI.COM_CMD]		
	JE	BUF_INIT		;MATCH IF BUFFERED
INITU:
	AND	[SI.COM_PRO],NOT MASK BUF_COM ;RESET BUFFERED INTERFACE FLAG 
	OR	DX,CWRITE		;COMMAND REGISTER OFFSET UNBUFFERED IF
	MOV	AL,RESET_ERROR		;RESET ANY ERROR
	OUT	DX,AL
	MOV	AL,[SI.COM_MR1]		;VALUE FOR MODE REGISTER 1
	DEC	DX			;MODE REGISTER OFFSET
	OUT	DX,AL			;SET MODE REGISTER 1
	MOV	AL,[SI.COM_MR2]		;VALUE FOR MODE REGISTER 2
	OUT	DX,AL			;SET MODE REGISTER 2
	INC	DX			;COMMAND REGISTER OFFSET
	MOV	AL,37H			;FDX COMMAND
	TEST	[SI.COM_PRO],MASK FDX_COM
	JNZ	INIT1
	SUB	AL,21H			;HDX REC COMMAND = 16H
INIT1:
	MOV	[SI.COM_CMD],AL		;ACTIVATE INTERFACE ACCORDING TO MODE
	OUT	DX,AL
	SUB	DX,(CWRITE-DREAD)
	IN	AL,DX			;CLEAR RECEIVE HOLDING REGISTER
	IN	AL,DX
	INC	DX			;STATUS REGISTER OFFSET
	IN	AL,DX			;READ INTERFACE STATUS 
	MOV	[SI.COM_LSTAT],AL	;SAVE LINE STATUS
EXINIT:
	STI
	RET
PAGE

;------------------------------------------
; BUF_INIT - INITIALIZE BUFFERED INTERFACE
;------------------------------------------

BUF_INIT:				

	MOV	AL,RESET_ERROR
	CALL	SNDCMD			;RESET INTERFACE
	MOV	AL,[SI.COM_MR1]		;WRITE MODE REGISTER 1
	CALL	SNDMOD
	MOV	AL,[SI.COM_MR2]		;WRITE MODE REGISTER 2
	CALL	SNDMOD
	MOV	AL,37H			;FDX COMMAND
	TEST	[SI.COM_PRO],MASK FDX_COM
	JNZ	BUF_INIT1
	SUB	AL,21H			;HDX REC COMMAND = 16H
BUF_INIT1:
	MOV	[SI.COM_CMD],AL		;ACTIVATE INTERFACE ACCORDING TO MODE
	CALL	SNDCMD
	CALL	BIN_FLUSH1		;FLUSH INPUT BUFFER
	OR	[SI.COM_PRO],MASK BUF_COM ;FLAG BUFFERED INTERFACE
	JMP	EXINIT

IWAITIE:				
	MOV	CX,INIT_TO		;LOOP COUNTER FOR BUFFERED INIT
IE0:
	IN	AL,DX			;READ STATUS OF CONTROLLER
	NOT	AL
	AND	AL,BINF			;TEST FOR INPUT BUFFER FULL
	JNZ	IE1			;NOT ZERO IF EMPTY
	LOOP	IE0			;KEEP TRYING UNTIL TIMEOUT OR INPUT
					; BUFFER EMPTY
IE1:
	RET

IWAITOF:
	MOV	CX,INIT_TO		;LOOP COUNTER FOR BUFFERED INIT
IO0:
	IN	AL,DX			;READ STATUS OF CONTROLLER
	AND	AL,BOUTF		;TEST FOR OUTPUT BUFFER FULL
	JNZ	IE1			;EXIT IF FULL
	LOOP	IO0			;KEEP TRYING UNTIL TIMEOUT OR OUTPUT
					; BUFFER FULL
	RET	
PAGE

;--------------------------------------------------------------------------
; IOCTL OUTPUT - WRITES SPECIFIED NUMBER OF BYTES INTO THE PARAMETER BLOCK
;		 OF SPECIFIED CHANNEL AND INITIALIZES THAT CHANNEL
;--------------------------------------------------------------------------

CONTROL_OUT:
	LES	DI,ES:[BX.TRANS]
INT_INIT:
	JCXZ	CO_END
	CMP	CX,COMM_PAR_LEN		;MAKE SURE WE DO NOT WRITE BEYOND BLOCK
	JBE	CO_OK
	MOV	CX,COMM_PAR_LEN
CO_OK:
	PUSH	DS
	PUSH	ES
	POP	DS
	POP	ES			;SOURCE POINTER TO DS:SI
	PUSH	SI			;SAVE POINTER TO CHANNEL PARAMETERS
	XCHG	SI,DI
	CLD
	REP	MOVSB			;TRANSFER BUFFER TO PARAMETER BLOCK
	POP	SI			;RESTORE POINTER TO CHANNEL PARAMETERS
	PUSH	ES
	POP	DS
CO_END:
	JMP	INIT			;INITIALIZE INTERFACE
PAGE

;---------------------------------------------------------------------------
; IOCTL INPUT - RETURNS SPECIFIED NUMBER OF BYTES OF THE SELECTED CHANNEL's
;		PARAMETER BLOCK
;---------------------------------------------------------------------------

CONTROL_IN:
	JCXZ	CTI_E
	PUSH	ES
	LES	DI,ES:[BX.TRANS]
	CMP	CX,COMM_PAR_LEN
	JBE	TCX
	MOV	CX,COMM_PAR_LEN		;RETURN LENGTH = INTERFACE PB LENGTH
TCX:
	PUSH	CX
	CLD
	REP	MOVSB
	POP	CX			;RESTORE RETURN LENGTH
	POP	ES
	MOV	WORD PTR ES:[BX.COUNT],CX
CTI_E:
	RET
PAGE

;--------------------------------------------------------
; INPUT	-- READS 'COUNT' CHARACTERS FROM RS232 INTERFACE
;--------------------------------------------------------

INPUT:
	JCXZ	INP_E
	CLD
	INC	DX			;DX = STATUS PORT	
	CMP	[SI.COM_CMD],33H	;TEST FOR HDX TRANSMIT ACTIVE
	JNE	INP0			; JUMP IF NOT
	MOV	AL,16H			;HDX REC COMMAND
	MOV	[SI.COM_CMD],AL	
	OR	DX,CWRITE		;DX = WRITE COMMAND PORT
	OUT	DX,AL			;RTS RESET NOW
	SUB	DX,(CWRITE-SREAD)	;DX = STATUS PORT
INP0: 
	LES	DI,ES:[BX.TRANS]
	MOV	AH,0
	XCHG	AH,[SI.COM_STAT]	;AH = STATUS FLAGS, COM_STAT = 0
	SHL	AH,1			;TEST FOR ERROR DURING NON DEST INPUT
	JB	INPUT_ERROR		;JUMPS IF THERE WAS AN ERROR
	SHL	AH,1			;BYTE WAITING ?
	JNB	INPH			;JUMPS IF NONE IS WAITING
	MOV	AL,[SI.COM_NDI]		;AL = BYTE READ DURING NON DEST INPUT
	JMP	SHORT INST		;RETURN THIS BYTE
INPH:
	PUSH	CX			;SAVE COUNT
	CALL	READ_BYTE		;READ 1 BYTE FROM RS232 INTERFACE
	POP	CX			;RESTORE COUNT	
	JB	INPUT_ERROR		;CARRY SET ON ERROR
	JNZ	INPUT_TO_BR		;TIMEOUT OR CONTROL-C ABORT
INST:
	STOSB				;STORE BYTE IN TRANSFER BUFFER
	LOOP	INPH
INP_E:
	RET
INPUT_ERROR:
	LES	BX,[PTRSAV]		;ES:BX = DEV REQUEST HEADER POINTER
	SUB	ES:[BX.COUNT],CX	;RETURN LENGTH = REQUESTED - COUNTER
	MOV	ES:[BX.STATUS],READ_FAULT
	RET				;REPORT DEVICE READ ERROR
INPUT_TO_BR:
	LES	BX,[PTRSAV]		;ES:BX = DEV REQUEST HEADER POINTER
	SUB	ES:[BX.COUNT],CX	;RETURN LENGTH = REQUESTED - COUNTER
	MOV	ES:[BX.STATUS],TOUT	;TIMEOUT OR CTRL-C BREAK
	RET

READ_BYTE:
	MOV	AH,DSR+RXRDY		;AH = DSR+RECEIVE HOLDING REG HAS DATA BITS
	CALL	TEST_STATUS		;WAIT FOR SPECIFIED STATUS BITS
	JNE	IN_TO			;JUMPS ON TIMEOUT ERROR
	DEC	DX			;DX = DATA PORT
	IN	AL,DX			;READ CHARACTER
	INC	DX			;DX = STATUS PORT
	MOV	AH,[SI.COM_LSTAT]	;AH = LINE STATUS
	TEST	AH,FRAME+OVERR+PARER	;CHECK FRAMING, OVERRUN, AND PARITY
	JNZ	IN_ERROR
IN_TO:
	RET
IN_ERROR:	
	OR	DX,CWRITE		;RESET I/F ERROR BITS
	MOV	AL,[SI.COM_CMD]
	OUT	DX,AL
	STC
	RET				;CARRY SET ON ERROR
PAGE

;-----------------------------------------------------------------------------
; NON-DESTRUCTIVE INPUT - RETURNS ONE BYTE FROM RS232 INTERFACE IF AVAILABLE
;			  AND BUFFERS THIS CHARACTER FOR SUBSEQUENT INPUT
;----------------------------------------------------------------------------- 

ND_INPUT:
	TEST	[SI.COM_STAT],MASK NDI	;CHECK FOR CHARACTER WAITING
	JZ	NDI_PH			; IF NOT CHECK PORT
	MOV	AL,[SI.COM_NDI]		;RETURN THE CHARACTER
	JMP	SHORT NDI_R
NDI_PH:
	INC	DX			;DX = STATUS PORT
	CMP	[SI.COM_CMD],33H	;TEST FOR HDX TRANSMIT ACTIVE
	JNE	ND_INP0			; JUMP IF NOT
	MOV	AL,16H			;HDX RECEIVE COMMAND
	MOV	[SI.COM_CMD],AL	
	OR	DX,CWRITE		;DX = WRITE COMMAND PORT
	OUT	DX,AL			;RTS RESET NOW
	SUB	DX,(CWRITE-SREAD)	;DX = STATUS PORT
ND_INP0:
	IN	AL,DX			;READ INTERFACE STATUS
	MOV	[SI.COM_LSTAT],AL	;SAVE LINE STATUS
	AND	AL,DSR+RXRDY+FRAME+OVERR+PARER
	XCHG	AH,AL
	TEST	AH,RXRDY		;TEST FOR DSR AND DATA AVAILABLE
	JZ	NO_CHAR			;JUMPS IF NO CHARACTER AVAILABLE
	DEC	DX			;DX = INPUT DATA PORT
	IN	AL,DX			;AL = CHARACTER RECEIVED
	MOV	[SI.COM_NDI],AL		;SAVE CHARACTER FOR INPUT
	OR	[SI.COM_STAT],MASK NDI	;REMEMBER THIS CHARACTER
	CMP	AH,DSR+RXRDY		;TEST FOR ERROR BIT IN STATUS	
	JE	NDI_R			;JUMPS IF EVERYTHING OK
	OR	[SI.COM_STAT],MASK NDI_ERR ;REMEMBER THE ERROR
	MOV	ES:[BX.MEDIA],AL	;RETURN THIS BYTE
	JMP	SHORT IN_ERROR		;ERROR EXIT
NDI_R:
	MOV	ES:[BX.MEDIA],AL	;RETURN THIS BYTE
	RET
NO_CHAR:
	MOV	ES:[BX.STATUS],BUSY
	RET
PAGE

;------------------------------------------------------------------------------
; INPUT_FLUSH -	READS CHARACTERS FROM INTERFACE UNTIL RECEIVE HOLDING REGISTER
;		IS FOUND EMPTY
;------------------------------------------------------------------------------

IN_FLUSH:
	INC	DX			;DX = STATUS PORT
	IN	AL,DX			;READ STATUS
	MOV	[SI.COM_LSTAT],AL	;SAVE LINE STATUS
	TEST	AL,RXRDY		;TEST FOR CHARACTER I RECEIVE HOLD. REG.
	JNZ	FL_CH			; GO TO READ IN THAT CHARACTER IF SO
	JMP	IN_ERROR		; ELSE RESET POSSIBLE ERROR AND RETURN
FL_CH:
	DEC	DX			;DX = INPUT DATA PORT
	IN	AL,DX			;READ CHARACTER
	JMP	SHORT IN_FLUSH		;SEE IF THERE'S ANOTHER ONE
PAGE

;-----------------------------------------------------
; OUTPUT - SEND CHARACTERS FROM (ES:[DI]) LENGTH (CX)
;-----------------------------------------------------

OUTPUT:
	JCXZ	OUT_E
	INC	DX			;DX = STATUS PORT
	CMP	[SI.COM_CMD],16H	;TEST FOR HDX RECEIVE ACTIVE
	JNE	OUT2			; JUMP IF NOT
	MOV	AL,33H			;HDX TRANSMIT COMMAND
	MOV	[SI.COM_CMD],AL	
	OR	DX,CWRITE		;DX = WRITE COMMAND PORT
	OUT	DX,AL			;HDX SEND SET NOW
	SUB	DX,(CWRITE-SREAD)	;DX = STATUS PORT
OUT2:
	LES	DI,ES:[BX.TRANS]	;ES:DI = BUFFER ADDRESS
OUT1:
	PUSH	CX			;SAVE COUNT
	MOV	AL,BYTE PTR ES:[DI]	;AL = BYTE FROM TRANSFER BUFFER
	CALL	WRITE_BYTE		;SEND ONE BYTE FROM ES:DI
	POP	CX			;RESTORE COUNT
	JB	OUTPUT_ERROR		;CARRY RESET IF ERROR OCCURED
	INC	DI			;MOVE TRANSFER BUFFER POINTER
	LOOP	OUT1			;LOOP UNTIL COUNT NUMBER OF BYTES SENT
OUT_E:
	RET

OUTPUT_ERROR:
	LES	BX,[PTRSAV]		;RESTORE POINTER TO REQUEST HEADER
	SUB	ES:[BX.COUNT],CX	;RETURN LENGTH = REQUESTED - COUNTER
	MOV	ES:[BX.STATUS],TOUT
	RET

WRITE_BYTE:
					;DX = STATUS PORT
	PUSH	AX			;SAVE BYTE TO BE SENT
	MOV	AH,DSR+TXRDY		;AH = DSR+TRANSMIT HOLD. REG. EMPTY
	CALL	TEST_STATUS		;WAIT FOR DSR
	POP	AX			;AL = BYTE TO BE SENT
	JNE	OUT_ERROR		;JUMPS ON TIMEOUT ERROR
	ADD	DX,(DWRITE-SREAD)	;DX = WRITE DATA PORT
	OUT	DX,AL			;SEND IT OUT
	SUB	DX,(DWRITE-SREAD)	;DX = STATUS PORT ADDRESS
	RET				;CARRY RESET TO INDICATE GOOD OUTPUT
OUT_ERROR:
	STC			
	RET				;CARRY SET FOR ERROR
PAGE

;----------------------------------------------------------------
; OUTPUT STATUS - RETURNS STATUS OF TRANSMITTER HOLDING REGISTER 	
;----------------------------------------------------------------

OUTPUT_STATUS:
	INC	DX			;DX = STATUS PORT
	IN	AL,DX
	MOV	[SI.COM_LSTAT],AL	;SAVE LINE STATUS
	TEST	AL,TXRDY		;TEST FOR TRANSMIT HOLDING REG EMPTY
	JZ	TX_BUSY
	RET
TX_BUSY:
	MOV	ES:[BX.STATUS],BUSY
	RET
PAGE


;--------------------------------------------------------------------
; BUF_INPUT - READS 'COUNT' CHARACTERS FROM BUFFERED RS232 INTERFACE
;--------------------------------------------------------------------

BUF_INPUT:
	JCXZ	BINP_E
	CLD
	INC	DX			;DX = STATUS/COMMAND PORT	
	CMP	[SI.COM_CMD],33H	;TEST FOR HDX TRANSMIT ACTIVE
	JNE	BINP0			; JUMP IF NOT
	MOV	AL,16H			;HDX RECEIVE COMMAND
	MOV	[SI.COM_CMD],AL	
	CALL	SNDCMD			
BINP0: 
	LES	DI,ES:[BX.TRANS]
	MOV	AH,0
	XCHG	AH,[SI.COM_STAT]	;AH = STATUS FLAGS, COM_STAT = 0
	SHL	AH,1			;TEST FOR ERROR DURING NON DEST INPUT
	JB	BINPUT_ERROR		;JUMPS IF THERE WAS AN ERROR
	SHL	AH,1			;BYTE WAITING ?
	JNB	BINPH			;JUMPS IF NONE IS WAITING
	MOV	AL,[SI.COM_NDI]		;AL = BYTE READ DURING NON DEST INPUT
	JMP	SHORT BINST		;RETURN THIS BYTE
BINPH:
	PUSH	CX			;SAVE COUNT
	CALL	BREAD_BYTE		;READ 1 BYTE FROM RS232 INTERFACE
	POP	CX			;RESTORE COUNT	
	JB	BINPUT_ERROR		;CARRY SET ON ERROR
	JZ	BINPUT_TO_BR		;TIMEOUT OR CONTROL-C ABORT
BINST:
	STOSB				;STORE BYTE IN TRANSFER BUFFER
	LOOP	BINPH
BINP_E:
	RET
BINPUT_ERROR:
	LES	BX,[PTRSAV]		;ES:BX = DEV REQUEST HEADER POINTER
	SUB	ES:[BX.COUNT],CX	;RETURN LENGTH = REQUESTED - COUNTER
	MOV	ES:[BX.STATUS],READ_FAULT
	RET				;REPORT DEVICE READ ERROR
BINPUT_TO_BR:
	LES	BX,[PTRSAV]		;ES:BX = DEV REQUEST HEADER POINTER
	SUB	ES:[BX.COUNT],CX	;RETURN LENGTH = REQUESTED - COUNTER
	MOV	ES:[BX.STATUS],TOUT	;TIMEOUT OR CTRL-C BREAK
	RET

BREAD_BYTE:
	MOV	AH,RXRDY		;AH = RECEIVE HOLDING REG HAS DATA BITS
	CALL	BTEST_STATUS		;WAIT FOR SPECIFIED STATUS BITS
	JZ	BIN_TO			;JUMPS ON TIMEOUT ERROR
	CALL	BRECDAT			;AL = RECEIVED CHARACTER
	MOV	AH,[SI.COM_LSTAT]	;AH = LINE STATUS
	TEST	AH,FRAME+OVERR+PARER 	;TEST LINE STATUS FOR ANY ERROR
	JNZ	BIN_FLUSH1
	OR	DX,DX			;RESET ZERO FLAG
BIN_TO:
	CLC
	RET

;------------------------------------------------------------------------------
; BUF_INFLUSH - READS CHARACTERS FROM INTERFACE UNTIL RECEIVE HOLDING REGISTER
;               IS FOUND EMPTY
;------------------------------------------------------------------------------

BUF_INFLUSH:
	INC	DX			;DX = COMMAND/STATUS PORT
BIN_FLUSH1:
	CALL	BGETSTA			;READ STATUS
	TEST	AL,RXRDY		;TEST FOR CHARACTER IN RECEIVE HOLD. REG.
	JZ	BIN_ERROR		; IF TRUE READ THE CHARACTER 
					; ELSE EXIT
	CALL	BRECDAT			;READ CHARACTER
	JMP	SHORT BIN_FLUSH1	;SEE IF THERE'S ANOTHER ONE
BIN_ERROR:
	MOV	AL,[SI.COM_CMD]
	CALL	SNDCMD			;RESET INTERFACE ERROR
	STC
	RET				;CARRY SET ON ERROR
PAGE

;---------------------------------------------------------------------------
; BUF_NDINPUT - RETURNS ONE BYTE FROM BUFFERED RS232 INTERFACE IF AVAILABLE
;               AND BUFFERS THIS CHARACTER FOR SUBSEQUENT INPUT
;--------------------------------------------------------------------------- 

BUF_NDINPUT:
	TEST	[SI.COM_STAT],MASK NDI	;CHECK FOR CHARACTER WAITING
	JZ	BNDI_PH			; IF NOT CHECK PORT
	MOV	AL,[SI.COM_NDI]		;RETURN THE CHARACTER
	JMP	SHORT BNDI_R
BNDI_PH:
	INC	DX			;DX = STATUS PORT
	CMP	[SI.COM_CMD],33H	;TEST FOR HDX TRANSMIT ACTIVE
	JNE	BND_INP0		; JUMP IF NOT
	MOV	AL,16H			;HDX RECEIVE COMMAND
	MOV	[SI.COM_CMD],AL	
	CALL	SNDCMD			;NEW COMMAND TO BUFFERED INTERFACE
BND_INP0:
	CALL	BGETSTA			;READ INTERFACE STATUS
	AND	AL,RXRDY+FRAME+OVERR+PARER
	MOV	AH,AL
	TEST	AH,RXRDY		;TEST FOR DSR AND DATA AVAILABLE
	JZ	BNO_CHAR		;JUMPS IF NO CHARACTER AVAILABLE
	CALL	BRECDAT			;READ BYTE FROM BUFFERED INTERFACE
					;AL = CHARACTER RECEIVED
	MOV	[SI.COM_NDI],AL		;SAVE CHARACTER FOR INPUT
	OR	[SI.COM_STAT],MASK NDI	;REMEMBER THIS CHARACTER
	TEST	AH,FRAME+OVERR+PARER	;TEST FOR ERROR BIT IN STATUS	
	JZ	BNDI_R			;JUMPS IF EVERYTHING OK
	OR	[SI.COM_STAT],MASK NDI_ERR ;REMEMBER THE ERROR
	MOV	ES:[BX.MEDIA],AL	;RETURN THIS BYTE
	JMP	SHORT BIN_FLUSH1	;ERROR EXIT
BNDI_R:
	MOV	ES:[BX.MEDIA],AL	;RETURN THIS BYTE
	RET
BNO_CHAR:
	MOV	ES:[BX.STATUS],BUSY	;NO CHARACTER RECEIVED
	RET
PAGE

;---------------------------------------------------------
; BUF_OUPUT - SEND CHARACTERS FROM (ES:[DI]) LENGTH (CX)
;---------------------------------------------------------

BUF_OUTPUT:
	JCXZ	BOUT_E			;EXIT IF COUNT = 0
	INC	DX			;DX = COMMAND/STATUS PORT
	CMP	[SI.COM_CMD],16H	;TEST FOR HDX RECEIVE ACTIVE
	JNE	BOUT2			; JUMP IF NOT
	MOV	AL,33H			;HDX TRANSMIT COMMAND
	MOV	[SI.COM_CMD],AL	
	CALL	SNDCMD			
BOUT2:
	LES	DI,ES:[BX.TRANS]	;ES:DI = BUFFER ADDRESS
BOUT1:
	PUSH	CX			;SAVE COUNT
	MOV	AL,BYTE PTR ES:[DI]	;AL = BYTE FROM TRANSFER BUFFER
	CALL	BWRITE_BYTE		;SEND ONE BYTE FROM ES:DI
	POP	CX			;RESTORE COUNT
	JZ	BOUTPUT_ERROR		;ZERO SET IF ERROR OCCURED
	INC	DI			;MOVE TRANSFER BUFFER POINTER
	LOOP	BOUT1			;LOOP UNTIL COUNT NUMBER OF BYTES SENT
BOUT_E:
	RET

BOUTPUT_ERROR:
	LES	BX,[PTRSAV]		;RESTORE POINTER TO REQUEST HEADER
	SUB	ES:[BX.COUNT],CX	;RETURN LENGTH = REQUESTED - COUNTER
	MOV	ES:[BX.STATUS],TOUT
	RET

BWRITE_BYTE:
					;DX = STATUS PORT
	PUSH	AX			;SAVE BYTE TO BE SENT
	MOV	AH,TXRDY		;AH = TRANSMIT HOLD. REG. EMPTY
	CALL	BTEST_STATUS		;WAIT FOR DSR
	POP	AX			;AL = BYTE TO BE SENT
	JZ	BOUT_EX			;JUMPS ON TIMEOUT ERROR
	CALL	BSNDDAT			;WRITE DATA CHARACTER TO BUFFERED INTERFACE
BOUT_EX:
	RET				;Z-FLAG RESET TO INDICATE GOOD OUTPUT
PAGE

;-------------------------------------------------------------
; BUF_OUTSTA - RETURNS STATUS OF TRANSMITTER HOLDING REGISTER 	
;-------------------------------------------------------------

BUF_OUTSTA:
	INC	DX			;DX = COMMAND/STATUS PORT
	CALL	BGETSTA
	TEST	AL,TXRDY		;TEST FOR TRANSMIT HOLDING REG EMPTY
	JZ	BTX_BUSY
	RET
BTX_BUSY:
	MOV	ES:[BX.STATUS],BUSY
	RET
PAGE

;------------------------------------------------------------
; TEST_STATUS - WAIT SPEC. TIME FOR STATUS BITS PASSED IN AH
;		OR TRY UNTIL CONTROL_C PRESSED 
;------------------------------------------------------------

TEST_STATUS:
					;DX = STATUS PORT ADDRESS
	MOV	CX,[SI.COM_TO]		;LOAD TIMEOUT VALUE
TUC:	IN	AL,DX			;READ INTERFACE STATUS
	MOV	[SI.COM_LSTAT],AL	;SAVE LINE STATUS
	AND	AL,AH			;EXTRACT THE BITS WE ARE LOOKING FOR
	CMP	AL,AH			
	JE	TEST_END		;JUMPS ON MATCH
	TEST	[SI.COM_PRO],MASK KEEP_TRYING
	JZ	TY
	CALL	KEYCHECK
	JNZ	SHORT TUC
	JMP	SHORT TEST_E2
TY:
	PUSH	CX			;SAVE COUNT
	MOV	CX,50			;VALUE TO MAKE LOOP LAST 1MS
TX:
	IN	AL,DX			;READ INTERFACE STATUS
	MOV	[SI.COM_LSTAT],AL	;SAVE LINE STATUS
	AND	AL,AH
	CMP	AL,AH
	JE	TEST_E1			;JUMPS ON MATCH
	LOOP	TX			;LOOP UNTIL 1MS ELAPSED
	POP	CX			;RESTORE COUNT
	CALL	KEYCHECK
	JZ	TEST_E2
	LOOP	TY			;LOOP COUNT MILLISECONDS
TEST_E2:
	OR	DX,DX			;RESET ZERO FLAG FOR TIMEOUT
	RET				
TEST_E1:
	POP	CX			;CLEAN STACK
TEST_END:
	RET				;ZERO FLAG SET FOR MATCH
	
KEYCHECK:
	IN	AL,KBD_STAT		;READ KEYBOARD STATUS
	NOT	AL
	TEST	AL,1			;BIT 0 RESET FOR DATA AVAILABLE
	JNZ	KEYC_END		;TEST COMM STATUS IF SET
	IN	AL,KBD_DATA		;READ CHARACTER
	CMP	AL,CONTROL_C		;TEST FOR CONTROL_C
	JE	KEYC_END		;EXIT IF TRUE
	CALL	KBD_BUFF_IN		;WRITE CHARACTER INTO KBD BUFFER
	OR	DX,DX			;RESET Z-FLAG	
KEYC_END:
	RET				;ZERO FLAG SET IFCONTROL_C HIT

PAGE


;-------------------------------------------------------------
; BTEST_STATUS - WAIT SPEC. TIME FOR STATUS BITS PASSED IN AH
;		OR TRY UNTIL CONTROL_C PRESSED 
;-------------------------------------------------------------

BTEST_STATUS:
					;DX = COMMAND/STATUS PORT ADDRESS
	MOV	CX,[SI.COM_TO]		;LOAD TIMEOUT VALUE
BTUC:
	CALL	BGETSTA			;READ INTERFACE STATUS
	AND	AL,AH			;EXTRACT THE BITS WE ARE LOOKING FOR
	CMP	AL,AH			
	JE	BSTL1			;JUMPS ON MATCH
	TEST	[SI.COM_PRO],MASK KEEP_TRYING
	JZ	BTY
	CALL	KEYCHECK
	JNZ	SHORT BTUC
	JMP	SHORT TEST_END
BTY:
	PUSH	CX			;SAVE COUNT
	MOV	CX,5			;VALUE TO MAKE LOOP LAST 1MS
BTX:
	CALL	BGETSTA			;READ INTERFACE STATUS
	AND	AL,AH
	CMP	AL,AH
	JE	BSTL2			;JUMPS ON MATCH
	LOOP	BTX			;LOOP UNTIL 1MS ELAPSED
	POP	CX			;RESTORE COUNT
	CALL	KEYCHECK
	JZ	TEST_END
	DEC	CX			;LOOP COUNT MILLISECONDS
	JNZ	BTY
	RET
BSTL2:
	POP	CX
BSTL1:
	OR 	DX,DX			;RESET ZERO FOR MATCH
	RET
PAGE

	
;--------------------------------------------------
; SNDCMD - SEND UART COMMAND TO BUFFERED INTERFACE
;--------------------------------------------------

SNDCMD:
	PUSH	AX			;SAVE COMMAND (AL)
	CALL	WAITIE			;WAIT FOR INPUT BUFFER EMPTY
	MOV	AL,BSCMD		;INSTRUCT PROC TO RECEIVE UART COMMAND
	OUT	DX,AL
	CALL	WAITIE			;WAIT FOR INPUT BUFFER EMPTY
	DEC	DX			;DX = DATA PORT
	POP	AX			;COMMAND BYTE PASSED IN AL
	OUT	DX,AL
	INC	DX
	RET

;------------------------------------------------
; SNDMOD - SEND MODE BYTES TO BUFFERED INTERFACE 
;------------------------------------------------

SNDMOD:
	PUSH	AX			;SAVE MODE BYTE (AL)
	CALL	WAITIE			;WAIT FOR INPUT BUFFER EMPTY
	MOV	AL,BSM12		;INSTRUCT PROC TO RECEIVE MODE BYTE
	OUT	DX,AL
	CALL	WAITIE			;WAIT FOR INPUT BUFFER EMPTY
	DEC	DX			;DX = DATA PORT
	POP	AX			;MODE BYTE PASSED IN AL
	OUT	DX,AL
	INC	DX
	RET
PAGE

;--------------------------------------------------
; BGETSTA - READ UART STATUS OF BUFFERED INTERFACE
;--------------------------------------------------

BGETSTA:
	CALL	WAITIE			;WAIT FOR INPUT BUFFER EMPTY
	MOV	AL,BRUST		;INSTRUCT PROC TO SEND UART STATUS BYTE
	OUT	DX,AL
	CALL	WAITOF			;WAIT FOR OUTPUT BUFFER FULL STATUS
	DEC	DX			;DX = DATA PORT
	IN      AL,DX			;AL = UART STATUS
	MOV	[SI.COM_LSTAT],AL	;SAVE LINE STATUS
	INC	DX
	RET
	
;------------------------------------------------
; BSNDDAT - SEND DATA BYTE TO BUFFERED INTERFACE
;------------------------------------------------

BSNDDAT:
	PUSH	AX			;SAVE DATA BYTE
	CALL	WAITIE			;WAIT FOR INPUT BUFFER EMPTY
	MOV	AL,BTDAT		;INSTRUCT PROC TO TRANSMIT DATA BYTE
	OUT	DX,AL
	CALL	WAITIE			;WAIT FOR INPUT BUFFER EMPTY
	DEC	DX			;DX = DATA PORT
	POP	AX			;RESTORE DATA BYTE IN AL
	OUT	DX,AL
	INC	DX
	RET
PAGE

;-----------------------------------------------------
; BRECDAT - RECEIVE DATA BYTE FROM BUFFERED INTERFACE
;-----------------------------------------------------

BRECDAT:
	CALL	WAITIE			;WAIT FOR INPUT BUFFER EMPTY
	MOV	AL,BRDAT		;INSTRUCT PROC TO RECEIVE DATA BYTE
	OUT	DX,AL
	CALL	WAITOF			;WAIT FOR OUTPUT BUFFER FULL STATUS
	DEC	DX			;DX = DATA PORT
	IN	AL,DX			;AL = DATA BYTE
	INC	DX			;DX = STATUS/COMMAND PORT
	RET

;--------------------------------------
; WAITIE - WAIT FOR INPUT BUFFER EMPTY
;--------------------------------------

WAITIE:
	IN	AL,DX			;GET CONTROLLER STATUS
	NOT	AL
	AND	AL,BINF
	JZ	WAITIE
	RET		

;--------------------------------------
; WAITOF - WAIT FOR OUTPUT BUFFER FULL
;--------------------------------------

WAITOF:
	IN	AL,DX
	AND	AL,BOUTF
	JZ	WAITOF
	RET
PAGE

;------------------------------------------------------------------------------
;
;           RS232 SOFTWARE INTERRUPT ENTRY POINT (VECTOR 14H)
;
;------------------------------------------------------------------------------
;
; ENTRY: DX = INTERFACE NUMBER	0 = AUX/COM1
;				1 = COM2
;				2 = COM3
;				3 = COM4
;				4 = COM5
;	 AH = COMMAND		0 = INITIALIZE INTERFACE
;				    ES:DI = POINTER TO PARAMETER STRING
;				    CX	  = NUMBER OF BYTES TO WRITE
;				1 = SEND CHARACTER
;				    AL = CHARACTER TO BE SENT
;				2 = RECEIVE CHARACTER
;				3 = READ LINE STATUS
;				4 = READ INTERFACE PARAMETERS  
;				    ES:DI = POINTER TO BUFFER
;				    CX	  = NUMBER OF BYTES TO READ
;
;
; EXIT: ALL REGISTERS EXCEPT AX PRESERVED
;
;	AH = LINE STATUS	BIT 0 = TRANSMIT HOLDING REGISTER EMPTY
;				BIT 1 = RECEIVE HOLDING REGISTER HAS DATA
;				BIT 2 = TRANSMIT SHIFT REGISTER EMPTY
;				BIT 3 = PARITY ERROR
;				BIT 4 = OVERRUN ERROR
;				BIT 5 = FRAMING ERROR
;				BIT 6 = DATA CARRIER DETECT
;				BIT 7 = DATA SET READY
;
;	COMMAND	1 - SEND CHARACTER: 
;
;	GOOD STATUS: 	
;	AH = 1XXXXXX1 DATA SET READY AND TRANSMIT HOLDING REGISTER EMPTY
;	AL = CHARACTER SENT 
;	BAD STATUS:
;	AH = BIT 7 = 0 OR BIT 0 = 0 OR BOTH = 0
;	CHARACTER NOT SENT
;
;	COMMAND 2 - RECEIVE CHARACTER:
;
;	GOOD STATUS:
;	AH = 1X000X1X DATA SET READY AND RECEIVE HOLDING REGISTER HAS DATA
;	AL = CHARACTER RECEIVED
;	BAD STATUS:
;	AH = BIT 7 = 0 OR BIT 1 = 0 --> TIMEOUT OR CONTROL-C ABORT
;	AH = BIT 7 = 1 AND BIT 1 = 1 AND BIT 3,4,5 NOT ZERO --> DATA ERROR
;
;------------------------------------------------------------------------------
PAGE


RS232_INT:
	STI				;TURN INTERRUPTS BACK ON
	PUSH	SI
	PUSH	CX
	PUSH	DX
	PUSH	DS
	PUSH	CS
	POP	DS
	MOV	SI,OFFSET COMM_P_TBL
	CMP	DX,4			;CHECK IF SUPPORTED INTERFACE NUMBER
	JA	RS232_EXIT		;EXIT IF NOT
	SHL	DX,1
	ADD	SI,DX
	MOV	SI,WORD PTR [SI]
	MOV	DX,[SI.COM_PORT]
	CMP	DL,30H			;TEST FOR ILLEGAL PORT
	JB	CHKCTRL			; EXIT IF NO CTRL COMMAND
IS_CTRL:
	INC	DX			;DX = STATUS PORT	
	DEC	AH
	JS	CINT_CTRLOUT
	JZ	CINT_SEND
	DEC	AH
	JZ	CINT_RECEIVE
	DEC	AH
	JZ	CINT_STAT
	DEC	AH
	JZ	CINT_CTRLIN

RS232_EXIT:
	POP	DS
	POP	DX
	POP	CX
	POP	SI
	IRET

CHKCTRL:
	CMP	AH,4			;IOCTRL INPUT ?
	JE	IS_CTRL
	OR	AH,AH			;IOCTRL OUTPUT ?
	JE	IS_CTRL
	JMP	SHORT RS232_EXIT
PAGE

;-----------------------------------
; CONTROL OUT WITH INITIALIZATION
;
; ES:DI = POINTER TO CONTROL STRING
; CX    = NUMBER OF BYTES
;-----------------------------------

CINT_CTRLOUT:
	PUSH	ES
	PUSH	DI
	CALL	INT_INIT
	POP	DI
	POP	ES		
	JMP	CINT_STAT
	
;----------------------
; SEND CHARACTER IN AL 
;----------------------

CINT_SEND:
	TEST	[SI.COM_PRO],MASK BUF_COM ;TEST FOR BUFFERED INTERFACE
	JNZ	CINT_BSEND		  ; JUMP IF TRUE 
	CALL	WRITE_BYTE
	MOV	AH,[SI.COM_LSTAT]	;AH = LINE STATUS, AL = CHARACTER SENT
	JMP	SHORT RS232_EXIT
CINT_BSEND:
	CALL	BWRITE_BYTE		;WRITE CHARACTER IN AL TO BUFFERED INTERFACE
	JZ	CINT_TOB		;JUMPS ON TIMEOUT/BREAK
	MOV	AH,[SI.COM_LSTAT]
	JMP	SHORT RS232_EXIT	;AH = LINE STATUS, AL = CHARACTER SENT
;-----------------------------
; RECEIVE 1 CHARACTER INTO AL
;-----------------------------	

CINT_RECEIVE:
	TEST	[SI.COM_PRO],MASK BUF_COM ;TEST FOR BUFFERED INTERFACE
	JNZ	CINT_BREC		  ; JUMP IF TRUE 
	CALL	READ_BYTE
	MOV	AH,[SI.COM_LSTAT]
	JMP	SHORT RS232_EXIT	;AH = LINE STATUS, AL =CHARACTER RECEIVED
CINT_BREC:
	CALL	BREAD_BYTE		
	JZ	CINT_TOB		;JUMPS ON TIMEOUT/BREAK
	JMP 	SHORT RS232_EXIT	;AH = LINE STATUS, AL =CHARACTER RECEIVED
PAGE

;--------------------
; RETURN LINE STATUS
;--------------------

CINT_STAT:
	TEST	[SI.COM_PRO],MASK BUF_COM ;TEST FOR BUFFERED INTERFACE
	JNZ	CINT_BSTAT		  ; JUMP IF TRUE 
	IN	AL,DX
	MOV	[SI.COM_LSTAT],AL
	MOV	AH,AL			;AH = LINE STATUS 
	JMP	SHORT RS232_EXIT
CINT_BSTAT:
	CALL	BGETSTA			;READ STATUS OF BUFFERED INTERFACE
	MOV	AH,AL			;AH = LINE STATUS
	JMP	SHORT RS232_EXIT

CINT_TOB:				;INDICATES TIMEOUT/BREAK BY SETTING
					; AH = 0
	MOV	AH,0
	JMP	RS232_EXIT

;------------------------------------
; RETURN CHANNEL PARAMETERS 
;
; ES:DI  = POINTER TO BUFFER
; CX     = REQUESTED NUMBER OF BYTES
;------------------------------------

CINT_CTRLIN:
	JCXZ	RS232_EXIT
	PUSH	DI
	CLD
	REP	MOVSB
	MOV	AH,[SI.COM_LSTAT]
	POP	DI
	JMP	SHORT RS232_EXIT


CSEG	ENDS
	END
