

PAGE 65,132
TITLE    BASINIT LAST MODULE BEFORE SYSINIT.

;******************************************************************************
;*********                                                           **********
;*********                     CHANGE SHEET                          **********
;*********                                                           **********
;******************************************************************************
;									    
;   DATE                       CHANGES MADE                         SPARS   BY
;------------------------------------------------------------------------------
; 05-22-84 I ORIGINAL ENTRY                                       I       I WK 
; 07-04-84 I DISABLE INTERRUPTS WHILE READING ROM                 I G2816 I WK
; 07-6-84  I TIMER INTERRUPT SEGMENT ZERO                         I       I WK
;------------------------------------------------------------------------------
PAGE

;------------------------------------------------------------------------------
;
; MODULE:	BASINIT	(LAST MODULE OF IO.SYS, OVERLAYED BY MS-DOS AFTER
;			SYSTEM INITIALIZATION)
;		
; CONTENTS:	- SIGNON MESSAGE CREATION AND DISPLAY
;		- INTERRUPT INITIALIZATION
;		- INTERVAL TIMER INITIALIZATION
;		- CRT TRANSLATION TABLE INITIALIZATION
;		- KEYBOARD TRANSLATION TABLE INITIALIZATION
;		- INITIALIZATION OF SYSTEM DEFINITION AREA 
;		- HARD DISK DRIVER RELOCATION
;		- SYSINIT INVOCATION		
;
;------------------------------------------------------------------------------
PAGE

BIOSIZ  EQU	20*1024			;SIZE OF BIOS IN BYTES
BIOSIZP EQU     (BIOSIZ+15)/16  	;Size of BIOS in Paragraphs.
CR	EQU	0DH
LF	EQU	0AH
BIOSSEG EQU     040H            	;BIOS SEGMENT
BIOSTRT EQU	BIOSSEG*16
MEM_SIZ_ID EQU	0FE06H			;Absolute address where firmware passes
					; THE MEMORY SIZE ID
FW_VER	EQU	0FF7H			;LOCATION OF FIRMWARE VERSION IN ROM
ROM	EQU	11H			;ROM PORT
RAM	EQU	10H			;RAM PORT
HEBREW		EQU	0CAH		;LANGUAGE CODE HEBREW
HEB_FLAG	EQU	40H		;KBD/CRT HEBREW FLAG
COUNTRY EQU	01H			;KEYBORD COMMAND TO GET LANGUAGE CODE
KBD_CMD_PORT	EQU	41H		;KEYBOARD COMMAND PORT
KBD_STA_PORT	EQU	41H		;KEYBOARD STATUS PORT
KBD_DATA_PORT	EQU	40H		;KEYBOARD DATA PORT
KBD_DATA_RDY	EQU	01H		;KEYBOARD DATA READY
KBD_LANG_VAR	EQU	80H		;KEYBOARD LANGUAGE CODE READY


;-----------------------
; REFERENCES TO SYSINIT
;-----------------------

EXTRN   SYSINIT:FAR                   	;The entry point of SYSINIT
EXTRN   CURRENT_DOS_LOCATION:WORD     	;Where the DOS is when SYSINIT called
EXTRN   FINAL_DOS_LOCATION:WORD       	;Where I want SYSINIT to put the DOS
EXTRN   DEVICE_LIST:DWORD             	;Pointer to the DEVICE list.
EXTRN   MEMORY_SIZE:WORD              	;Size in paragraphs of Physical memory.
EXTRN   DEFAULT_DRIVE:BYTE            	;Default Drive to use when system booted
EXTRN   BUFFERS:BYTE                  	;Number of default buffers.

;----------------------------------
; REFERENCES TO OTHER BIOS MODULES
;----------------------------------

EXTRN	DEVSTART:NEAR,DREND:NEAR,I29_HANDLER:NEAR,I16_HANDLER:NEAR,STACKTOP:NEAR
EXTRN	INT_TRAP:NEAR,WINCH_DRIVES:BYTE,DSKDEV:NEAR,MEM_SIZE_DET:NEAR
EXTRN	RS232_INT:NEAR,CONSOLE_FLAGS:BYTE,HEB_SW:BYTE,DEC_SIGN_1:BYTE
EXTRN	DEC_SIGN_2:BYTE,DEC_S_1:BYTE,DEC_S_2:BYTE,CRTACTTBL:NEAR,FLTAB:WORD
EXTRN	COMM_TBL:NEAR,WI_FLAGS:BYTE,WI_START:NEAR,DUMMY5_START:NEAR,DUMMY5_END:NEAR
EXTRN	WI_END:NEAR,MEMORY_SIZEK:WORD,TIM2_ISR:NEAR,TIMER_RET:NEAR,FL_FLAGS:BYTE

PUBLIC  HWINIT
PAGE

CSEG	SEGMENT	PUBLIC	'CODE'
ASSUME	CS:CSEG,DS:CSEG,SS:CSEG,ES:CSEG

;-------------------------------
; Overlayed by MSDOS by SYSINIT
;-------------------------------

RELEASE_ID	DB	2,3,0
LAST_OFF	DW	OFFSET WI_END	;PRESET END OF 10-MB HARD DISK DRIVER

PAGE

;---------------------
;  NCR SIGNON MESSAGE
;---------------------

MESS_LEN	DW	OFFSET SIZ_TBL - OFFSET SIGNON_MESSAGE

SIGNON_MESSAGE	DB	  1BH,':'	;CLEAR SCREEN
  		DB        'MS-DOS for NCR DECISION MATE V',CR,LF
		DB	  'NCR-version 2.11 (02.00)',CR,LF
SIZ_MESS	DB  	  '0000 kbytes memory',CR,LF
		DB  	  'D006-0225-0000',CR,LF
		DB	  'Serial number '
SERIAL_NR	DB  	  '000000',CR,LF
          	DB  	  'Firmware version:'
FIRM_MESS	DB	  ' M.00.00',CR,LF

;-------------------
; MEMORY SIZE TABLE
;-------------------

SIZ_TBL		DB	'  64'
		DB	' 128'
		DB	' 192'
		DB	' 256'
		DB	' 320'
		DB	' 384'
		DB	' 448'
		DB	' 512'
		DB	' 576'
		DB	' 640'
		DB	' 704'
		DB	' 786'
		DB	' 832'
		DB	' 896'
		DB	' 960'
		DB	'1024'
PAGE

;---------------------------
; LANGUAGE TABLE REFERENCES
;---------------------------

LANG_TBL:
	DW	OFFSET SWISS
	DW	OFFSET SWISS
	DW	OFFSET FRANCE
	DW	OFFSET CANADA
	DW	OFFSET CANADA2
	DW	OFFSET SOUTH_AFRICA
	DW	OFFSET PORTUGAL
	DW	OFFSET YUGOSLAVIA
	DW	OFFSET US
	DW	OFFSET UK
	DW	OFFSET DENMARK
	DW	OFFSET GERMANY
	DW	OFFSET SWED_FIN
	DW	OFFSET DENMARK
	DW	OFFSET SPAIN
	DW	OFFSET ITALY
	DW	OFFSET US
	DW	OFFSET UK
	DW	OFFSET FRANCE
	DW	OFFSET GERMANY
	DW	OFFSET SWED_FIN
	DW	OFFSET DENMARK
	DW	OFFSET SPAIN
	DW	OFFSET ITALY
PAGE

;-------------------------------
; CRT LANGUAGE VARIATIONS TABLE	
;-------------------------------

CRTTBL:
US		DW	1
		DB	8AH,2EH

UK		DW	3
		DB	5EH,0EH,23H,03H,8AH,2EH

FRANCE		DW	10
		DB	5BH,0DH,5CH,08H,5DH,1CH,40H,0AH,7BH,14H,7CH,1AH
		DB	7DH,0BH,7EH,0FH,23H,03H,27H,0CH

GERMANY 	DW	9
		DB	5BH,00H,5CH,06H,5DH,09H,40H,1CH,7BH,10H,7CH,16H
		DB	7DH,19H,7EH,1EH,27H,0CH

SWED_FIN	DW	9
		DB	5BH,00H,5CH,06H,5DH,02H,24H,13H,7BH,10H,7CH,16H
		DB	7DH,12H,7EH,0FH,27H,0CH

DENMARK		DW	9
		DB	5BH,01H,5CH,07H,5DH,02H,23H,03H,7BH,11H,7CH,17H
		DB	7DH,12H,7EH,0FH,27H,0CH
SPAIN		DW	6
		DB	5BH,1FH,5CH,05H,5DH,1DH,27H,0CH,7CH,15H,23H,03H

ITALY		DW	11
		DB	5BH,0DH,5CH,08H,5DH,14H,23H,03H,40H,1CH,7BH,0AH
		DB	7CH,18H,7DH,0BH,7EH,1BH,60H,1AH,27H,0CH

SWISS   	DW	10
		DB	23H,03H,27H,0CH,40H,08H,5BH,0AH,5CH,14H,5DH,0BH
	        DB	7BH,10H,7CH,16H,7DH,19H,7EH,0FH

CANADA		DW	1
		DB	8AH,2EH                         

CANADA2		DW	7
		DB	27H,0CH,40H,0AH,5CH,08H,7BH,14H,7CH,9FH,7DH,0BH,7EH,0FH 

SOUTH_AFRICA	DW	8
		DB	27H,0CH,5BH,83H,5CH,84H,5DH,82H,7BH,93H 
		DB	7CH,94H,7DH,92H,7EH,0FH

PORTUGAL	DW	8	
		DB	23H,03H,27H,0CH,5BH,80H,5CH,81H,5DH,85H,7BH,90H
		DB	7CH,91H,7DH,08H

YUGOSLAVIA	DW	10
		DB	40H,8CH,5BH,8BH,5CH,88H,5DH,89H,5EH,8AH,60H,9CH 
		DB	7BH,9BH,7CH,98H,7DH,99H,7EH,9AH 		
PAGE

;---------------------
; BASINIT ENTRY POINT
;---------------------

HWINIT:
	CLI
	XOR     BX,BX
	MOV	DS,BX			;DS = ZERO	
	MOV	ES,BX			;ES = ZERO

;---------------------------------------------
; INITIALIZE ALL INTERRUPTS TO ADDRESS TRAP
;---------------------------------------------

	CLD
	MOV	WORD PTR [BX],OFFSET INT_TRAP
	INC	BX
	INC	BX
	MOV	WORD PTR [BX],CS
	MOV	DI,4
	XOR	SI,SI
	MOV	CX,510
	REP	MOVSW

;------------------------------------------
;  SET VECTORS 8H, 12H, 14H, 16H, 1CH, 29H
;------------------------------------------

	MOV	BX,29H*4		;INT 29H VECTOR ADDRESS
	MOV	WORD PTR [BX],OFFSET I29_HANDLER 
	MOV	BX,14H*4		;RS232 COMMUNICATIONS INTERRUPT
	MOV	WORD PTR [BX],OFFSET RS232_INT
	MOV	BX,12H*4		;MEMORY SIZE DETERMINATION (K-BYTES)
	MOV	WORD PTR [BX],OFFSET MEM_SIZE_DET		
	MOV	BX,8H*4			;TIMER 2 INTERRUPT VECTOR
	MOV	WORD PTR [BX],OFFSET TIM2_ISR
	ADD	WORD PTR [BX],BIOSTRT
	ADD	BX,2
	MOV	WORD PTR [BX],0
	MOV	BX,1CH*4		;TIMER 2 RETURN VECTOR
	MOV	WORD PTR [BX],OFFSET TIMER_RET
	ADD	WORD PTR [BX],BIOSTRT	
	ADD	BX,2
	MOV	WORD PTR [BX],0
	MOV	BX,16H*4		;KEYBOARD INPUT VECTOR
	MOV	WORD PTR [BX],OFFSET I16_HANDLER

;---------------------
;  DEFINE DS,ES,SS,SP  
;---------------------

	MOV	AX,CS
	MOV	SS,AX			;SS = CS 
	MOV	DS,AX			;DS = CS
	MOV	ES,AX			;ES = CS
	MOV	SP,OFFSET STACKTOP	;INITIALIZE STACK POINTER
PAGE

;---------------------------------------
; INITIALIZE INTERRUPT CONTROLLER 8259A
;---------------------------------------

	MOV	AL,17H			;EDGE TRIG,ADDRESS SPACE 4,SINGLE,ICW4
	OUT	90H,AL
	MOV	AL,8			;INT TYPE 8 FOR IRQ0
	OUT 	91H,AL
	MOV	AL,3			;AEOI,8088 MODE
	OUT	91H,AL

;------------------------------------------------------------
;  INITIALIZE TIMER 2 FOR INTERRUPTING EVERY 10 MILLISECONDS
;------------------------------------------------------------

	MOV	AL,0B6H
	OUT	83H,AL
	MOV	AX,5000			;5000 * 500 KHZ = 10 MS
	OUT	82H,AL
	XCHG	AH,AL
	OUT	82H,AL

;-----------------------------------
; INITIALIZE SYSTEM DEFINITION AREA
;-----------------------------------

	MOV	FLTAB,0			;RESET DISKETTE MEDIA CHANGE IDs
	MOV	WORD PTR FL_FLAGS,0     ;RESET 
	MOV	BYTE PTR FL_FLAGS+2,0   ;      DISKETTE FLAGS
	AND	WI_FLAGS,80H		;RESET
	OR	WI_FLAGS,07H		;      HARD DISK
	MOV	WORD PTR WI_FLAGS+1,0   ;                FLAGS
	AND	CONSOLE_FLAGS,3FH	;RESET CONSOLE's COLOR AND HEBREW BITS 
PAGE

;-----------------------------	
; SETUP CRT TRANSLATION TABLE
;-----------------------------

	MOV	AL,COUNTRY		;COMMAND TO GET LANGUAGE CODE
	OUT	KBD_CMD_PORT,AL	
KBD_LANG:
	IN	AL,KBD_STA_PORT		;GET KEYBOARD STATUS
	TEST	AL,KBD_DATA_RDY		;WAIT FOR DATA READY
	JZ	KBD_LANG		
	TEST	AL,KBD_LANG_VAR		;TEST FOR LANGUAGE CODE READY 
	IN	AL,KBD_DATA_PORT	; READ THE CODE
	JZ	KBD_LANG		;KEEP TRYING IF NOT LANGUAGE CODE
	CMP	AL,HEBREW		;TEST FOR HEBREW KEYBOARD
	JNE	KBD1			; JUMP IF FALSE
	OR	CONSOLE_FLAGS,HEB_FLAG	;SET HEBREW FLAG FOR CRT
	MOV	WORD PTR HEB_SW,9F9EH	;DEFINE HEBREW ON/OFF CODES
KBD1:
	CMP	AL,0F8H			;FOR F8H AND F9H CHANGE ',' TO '.'
	JB	KBD3
	CMP	AL,0F9H
	JA	KBD3
	MOV	AH,2EH
	MOV	DEC_SIGN_1,AH
	MOV	DEC_SIGN_2,AH
	MOV	DEC_S_1,AH
	MOV	DEC_S_2,AH
KBD3:
	SUB	AL,0D8H			;NORMALIZE LANGUAGE CODE FOR TABLE REF.
	MOV	DL,AL
	AND	DL,0F0H
	AND	AL,0FH
	SHL	AL,1			;WORD TABLE
	OR	AL,DL
	XOR	AH,AH
	MOV	BX,OFFSET LANG_TBL	;BX = BASE ADDRESS OF LANGUAGE TABLE
	ADD	BX,AX			;BX = LANGUAGE POINTER
	MOV	SI,WORD PTR [BX]	;SI = POINTER TO LANGUAGE ENTRY LENGTH
	MOV	DI,OFFSET CRTACTTBL	;DI = POINTER TO CRTACTTBL
	MOV	CX,WORD PTR [SI]	;CX = LENGTH OF ENTRY (WORDS)
	ADD	SI,2			;SI = POINTER TO FIRST PAIR
	XOR	BX,BX
KBD2:
	LODSW				;AX = AH - CODE, AL - OFFSET INTO CRTACTTBL
	MOV	BL,AL			;BX = OFFSET INTO TABLE
	MOV	BYTE PTR [DI][BX],AH	;UPDATE SPECIFIC ENTRY
	LOOP	KBD2			;DO IT FOR EACH PAIR
PAGE

;-----------------------
; CALCULATE END OF BIOS
;-----------------------

	TEST	WINCH_DRIVES,-1
	JNZ	X1
	MOV	LAST_OFF,OFFSET DREND	;NO HARD DRIVE, DISKETTE DRIVER IS LAST
	MOV	BX,OFFSET DSKDEV	;UNLINK WINCHESTER HEADER
	MOV	WORD PTR [BX],-1
	MOV	WORD PTR [BX+2],-1
	JMP 	SHORT X2
X1:
	TEST	WI_FLAGS,80H		;TEST FOR 10-MB HARD DRIVES
	JNZ	X2
	MOV	DI,OFFSET WI_START	;RELOCATE 5-MB HARD DISK DRIVER
	MOV	SI,OFFSET DUMMY5_START
	MOV	CX,OFFSET DUMMY5_END
	SUB	CX,OFFSET DUMMY5_START
	PUSH	CX
	REP	MOVSB
	POP	CX			;CALCULATE END OF BIOS
	MOV	AX,OFFSET WI_START
	ADD	AX,CX
	MOV	LAST_OFF,AX		;BIOS END IS END OF HARD DISK DRIVER 
X2:
PAGE

;----------------------------------------------------------------
; Calculate memory size in paragraphs from ID passed by firmware
; at absolute address FE06 hex	
;----------------------------------------------------------------

	XOR	AX,AX			
	MOV	ES,AX			;ES = 0 FOR FIRMWARE REFERENCES
	MOV	BX,MEM_SIZ_ID		
	MOV	AL,BYTE PTR ES:[BX]	;AL = MEMORY SIZE ID
	INC	AX
	MOV	CL,6
	SHL	AX,CL			;MAKE IT K-BYTES
	MOV	MEMORY_SIZEK,AX
	MOV	CL,6
	SHL	AX,CL			;AX = Total memory size in paragraphs.
	MOV	BX,AX			; needed in BX.
	PUSH	BX			;SAVE MEMORY SIZE (PARAGRAPHS)
PAGE

;----------------------
; BUILD SIGN0N MESSAGE
;----------------------

	OUT	ROM,AL			;SWITCH IN ROM
	MOV	BX,FW_VER 		;POINTER TO ROM LOCATION WHERE
					;FIRMWARE VERSION IS DEFINED
	MOV	CL,BYTE PTR ES:[BX]	;FIRST BYTE IS LENGTH OF STRING
	MOV	CH,0			;CX = LENGTH IN BYTES
	CMP	CL,08H			;TEST FOR NO FIRMWARE MESSAGE
	JNZ	F3			; JUMP IF NO MESSAGE
	MOV	SI,OFFSET FIRM_MESS     ;FIELD IN SIGNON MESSAGE
F1:	INC	BX			;MOVE SOURCE POINTER
	MOV	AL,BYTE PTR ES:[BX]
	MOV	BYTE PTR [SI],AL	
	INC	SI			;MOVE DESTINATION POINTER
	LOOP	F1			;LOOP TILL DONE (CX = 00)
F3:
	OUT	RAM,AL			;SWITCH BACK TO RAM
	CMP	BYTE PTR FIRM_MESS+1,'C';TEST FOR COLOR TUBE
	JNE	F2
	OR	CONSOLE_FLAGS,80H	; IF TRUE, SET FLAG FOR CRT DRIVER  	
F2:
	MOV	BX,MEM_SIZ_ID
	MOV	AL,BYTE PTR ES:[BX]
	INC	BX
	MOV	AH,BYTE PTR ES:[BX]
	CMP	AH,1			;IF BOOTED FROM HARD DISK
	JE	F4			;  SET DEFAULT DRIVE C
	XOR	AH,AH			; ELSE DEFAULT DRIVE IS A
	JMP 	SHORT F5
F4:
	MOV	AH,3			;DRIVE C
F5:
	PUSH	AX
	MOV	AH,0
	SHL	AL,1
	SHL	AL,1
	PUSH	CS
	POP	ES			;ES = CS = DS
	MOV	SI,OFFSET SIZ_TBL
	ADD	SI,AX
	MOV	DI,OFFSET SIZ_MESS
	MOV	CX,4
   REP	MOVSB
	MOV	SI,BIOSIZ + 0CD3H	
	MOV	BX,OFFSET SERIAL_NR
	MOV	CX,3			
USER_NXT:
	MOV	AL,BYTE PTR [SI]
	PUSH	AX
	AND	AL,0F0H
	SHR	AL,1
	SHR	AL,1
	SHR	AL,1
	SHR	AL,1
	OR	BYTE PTR [BX],AL
	POP	AX
	AND	AL,0FH
	INC	BX
	OR	BYTE PTR [BX],AL
	INC	SI
	INC	BX
	LOOP	USER_NXT
	MOV	SI,OFFSET SIGNON_MESSAGE
	MOV	CX,WORD PTR MESS_LEN
NEXTCH:	LODS	BYTE PTR [SI]
	INT	29H			;DISPLAY CHARACTER
	LOOP	NEXTCH
PAGE

;------------------------------------------------
; PASS SYSTEM PARAMETERS TO SYSINIT AND ENTER IT
;------------------------------------------------
	
      	MOV     AX,SEG SYSINIT
        MOV     DS,AX

ASSUME  DS:SEG SYSINIT

        MOV     AX,CS
        ADD     AX,BIOSIZP		;CS + SIZE OF BIOS IN PARAGRAPHS
        MOV     CURRENT_DOS_LOCATION,AX
	MOV	BX,CS
	MOV	AX,CS:LAST_OFF
	ADD	AX,15
	MOV	CL,4
	SHR	AX,CL		;(LAST_OFF+15)/16
	ADD	AX,BX
	MOV	FINAL_DOS_LOCATION,AX
	POP	AX
	MOV	DEFAULT_DRIVE,AH
	POP	BX			;RESTORE MEMORY SIZE (PARAGRAPHS)
        MOV     MEMORY_SIZE,BX
        MOV     AX,CS
        MOV     WORD PTR DEVICE_LIST+2,AX
        MOV     WORD PTR DEVICE_LIST,OFFSET DEVSTART
	MOV	BUFFERS,2
	STI
        JMP     SYSINIT

CSEG	ENDS
	END
