(*---------------------------------------------------------------------------*)
{ This program is an example of how to access the Real Time Clock (3273-K803) }
{ of the  NCR DECISION MATE V. It was written  using  Borland International's }
{ TURBO PASCAL (TM). This  software may be distributed  freely.  No warranty. }
{ ---------- Written by M. Rajkay, PCDMS-HL, NCR Corporation, 1985 ---------- }
(*---------------------------------------------------------------------------*)
program timer(input,output);
var   month: byte;
      dayom: byte;
      dayow: byte;
       hour: byte;
     minute: byte;
     second: byte;
     tenths: byte;
     millis: byte;
   decmonth: byte;
   decdayom: byte;
   decdayow: byte;
    dechour: byte;
  decminute: byte;
  decsecond: byte;
  dectenths: byte;
  decmillis: byte;
     answer: char;
      value: byte;
      block: byte;
(*---------------------------------------------------------------------------*)
procedure writelatches;
begin
  port(.200.):=block;                 {setting the add-latch to BADD,block}
       millis:=port(.204.);                       {reading register BADD+4}
       tenths:=port(.205.);                       {reading register BADD+5}
       second:=port(.206.);                       {reading register BADD+6}
       minute:=port(.207.);                       {reading register BADD+7}
  port(.200.):=block + 1;           {setting the add-latch to BADD,block+1}
         hour:=port(.204.);                       {reading register BADD+4}
        dayow:=port(.205.);                       {reading register BADD+5}
        dayom:=port(.206.);                       {reading register BADD+6}
        month:=port(.207.);                       {reading register BADD+7}

  decmillis:=(millis div 16)*10 + (millis mod 16); {<--- converting BCD to dec}
  dectenths:=(tenths div 16)*10 + (tenths mod 16);
  decsecond:=(second div 16)*10 + (second mod 16);
  decminute:=(minute div 16)*10 + (minute mod 16);
    dechour:=(hour div 16)*10 + (hour mod 16);
   decdayow:=(dayow div 16)*10 + (dayow mod 16);
   decdayom:=(dayom div 16)*10 + (dayom mod 16);
   decmonth:=(month div 16)*10 + (month mod 16);

 if block=0 then writeln('Displaying all Counters of RTC-K803')
            else writeln('Displaying all Alarm Latches of RTC 3273-K803');
 writeln;
 writeln('Register Month:        BCD: ',month:3,'    DEC: ',decmonth:3);
 writeln('Register Day of Month: BCD: ',dayom:3,'    DEC: ',decdayom:3);
 writeln('Register Day of Week:  BCD: ',dayow:3,'    DEC: ',decdayow:3);
 writeln('Register Hour:         BCD: ',hour:3,'    DEC: ',dechour:3);
 writeln('Register Minute:       BCD: ',minute:3,'    DEC: ',decminute:3);
 writeln('Register Seconds:      BCD: ',second:3,'    DEC: ',decsecond:3);
 writeln('Register 1/10 Seconds: BCD: ',tenths:3,'    DEC: ',dectenths:3);
 writeln('Register Milliseconds: BCD: ',millis:3,'    DEC: ',decmillis:3);
 writeln;
end;
(*---------------------------------------------------------------------------*)
procedure resetlatches;
begin
 port(.200.):=block;               {setting the add-latch to BADD,block}
 port(.204.):=decmillis;              {writing value to register BADD+4}
 port(.205.):=dectenths;              {writing value to register BADD+5}
 port(.206.):=decsecond;              {writing value to register BADD+6}
 port(.207.):=decminute;              {writing value to register BADD+7}
 port(.200.):=block + 1;         {setting the add-latch to BADD,block+1}
 port(.204.):=dechour;                {writing value to register BADD+4}
 port(.205.):=decdayow;               {writing value to register BADD+5}
 port(.206.):=decdayom;               {writing value to register BADD+6}
 port(.207.):=decmonth;               {writing value to register BADD+7}
end;
(*---------------------------------------------------------------------------*)
procedure manipulate_RTC(callpar:integer);
begin
clrscr;
 block := callpar;
 writelatches;
 writeln('Reset Counter Registers? (Y/N)');
 repeat
  read(kbd,answer);
 until (answer in ['n','N','y','Y']);
 if (answer in ['Y','y']) then
  begin
   ClrScr;
   writeln('Enter Decimal Values for the Registers:');
   writeln;
   write('Register Month:.......... ');
   readln(decmonth);
   write('Register Day of Month:... ');
   readln(decdayom);
   write('Register Day of Week:.... ');
   readln(decdayow);
   write('Register Hour:........... ');
   readln(dechour);
   write('Register Minute:......... ');
   readln(decminute);
   write('Register Seconds:........ ');
   readln(decsecond);
   write('Register 1/10 Seconds:... ');
   readln(dectenths);
   write('Register Milliseconds:... ');
   readln(decmillis);
   writeln;
   resetlatches;
   writelatches;
  end;
end;
(*---------------------------------------------------------------------------*)
begin
 ClrScr;
 writeln('3273-K803 RTC register display and set tool');
 writeln('RTC Port address is assumed to be Hex C8');
 writeln;
 writeln('Display RTC Counter Registers? (Y/N)');
 repeat
  read(kbd,answer);
 until (answer in ['n','N','y','Y']);
 if (answer in ['Y','y']) then manipulate_RTC(0);
 ClrScr;
 writeln('Display RTC Alarm Latch Registers? (Y/N)');
 repeat
  read(kbd,answer);
 until (answer in ['n','N','y','Y']);
 if (answer in ['Y','y']) then manipulate_RTC(2);
end.
