program MGDEMO (input,output);

(* Dies ist ein kleines Demonstrationsprogramm *)
(* fuer die Anwendung von TURBO.GRAF. Diese    *)
(* Version zeigt die Verwendung des Treibers   *)
(* auf der HIGH LEVEL Ebene                    *)
(*                                             *)
(*      DEMOVERSION 4.0 ( C ) ComSoft          *)
(*      f}r TURBOGRAF V 4.x / 13.03.84         *)

(*$ICGRAF.LIB*)   (* Durch Verwendung von CGRAF wird Color selektiert *)

procedure BEGRUESSUNG;
begin
ClrScr;
Writeln ; Writeln ; Writeln;
Writeln ('Demonstration - Program for');
Writeln ('      Turbograf V 4.x');
Writeln ('         Color');
Writeln ('     (C) ComSoft  1984');
DELAY (1500);
end;

procedure DISTR;
begin
GMODE (0);
SELCHAR (1,1);
SETTEXT (20,0,
    ' Turbograf Vers. 4/ ComSoft D-8901 Stadtbergen 2, Fuggerstr. 4 ',0,0,6);
SELCHAR (1,0);
end;

procedure VIELECK;
var
X   :array [0 .. 18] of integer;
Y   :array [0 .. 18] of integer;

A,B :integer;

begin
    for A:=0 to 18 do
       begin
          X[A] := ROUND (((COS ((6.28/360) * A*20)) * 180) + 320);
          Y[A] := ROUND (((SIN ((6.28/360) * A*20)) * 180) + 200);
       end;

    GCLEAR;
    DISTR;
    GMODE (0);
       for B:=0 to 17 do
          for A:=B+1 to 18 do
             begin
                SETLINE (X[B],Y[B],X[A],Y[A],2);
             end;
DELAY (800);
end;


Procedure Textdemo;
Begin
Gclear;
Selchar (0,1);
Settext (16,350,'Turbograf Version 4.0',0,1,5);
Settext (30,320,'New special features implemented:',0,0,1);
Selchar (0,0);
Settext (30,250,'Faster stringoutput using Settext and Gtext',0,0,1);
Settext (30,230,'Faster Gline, Garc and Gcircl ',0,0,1);
Settext (30,210,'Controlcommands in Readstring',0,0,1);
Settext (30,190,'Possibility to zoom the display using Dispzoom',0,0,1);
Settext (30,170,'Saving and loading parts of the screen on and from disk',0,0,1);
delay (2000);
end;

Procedure Dzoom;
var a,b:Integer;
Begin
Gmode (1);
Settext (1,0,'Zoom',0,0,7);
Setrect (0,0,34,16,0,0,1);
For B:=0 to 5 do
  Begin
  For A:=0 to 15 do
    Begin
       Dispzoom (0,0,A);
       delay (100);
    End;
  For A:=15 downto 0 do
    Begin
       Dispzoom (0,0,A);
       Delay (100);
    End;
  End;
Settext (1,0,'Zoom',0,0,7);
Setrect (0,0,34,16,0,0,1);
Dispzoom (0,0,0);
Delay (800);
End;


procedure CIRCLES;

var A:integer;
begin
A:=180;
GCLEAR;
DISTR;
repeat
    SETCIRCL (450-A,290-TRUNC(A/2),A,1);
    SETCIRCL (190+A,290-TRUNC(A/2),A,2);
    A:=A-3;
until A=3;
Delay(1500);
end;

PROCEDURE RECT;
var N   :integer;

begin
GCLEAR;
SETTEXT (50,350,'Fast Rectangle Drawing',0,2,7);
DISTR;
for N:=1 to 15 do
       begin
         SETRECT (100+N*6,50+N*6,20+N*20,8+N*10,0,0,4);
       end;
DELAY (1500);
GCLEAR;
for N:=0 to 7 do
    begin
       SETRECT (320,200,60,60,N,0,3);
    end;
DELAY (600);
end;


procedure BOX;

var N    :integer;
M        :array [ 0 .. 3 ] of array [ 1 .. 2 ] OF INTEGER;
begin
M [ 0,1 ] := 50; M [ 0,2 ] := 50;
M [ 1,1 ] :=350; M [ 1,2 ] := 50;
M [ 2,1 ] := 50; M [ 2,2 ] := 180;
M [ 3,1 ] :=350; M [ 3,2 ] := 180;
GCLEAR;
SETTEXT (50,350,'Fast Box Drawing',0,2,7);
SETTEXT (70,300,'With 16 Patterns',0,2,7);
DISTR;
DELAY (600);
GMODE (0);
for N:=0 to 15 do
       begin
          GPATT (N);
          SETBOX (M [ N AND 3,1 ], M [ N AND 3,2 ],50,20,0,4,1);
          DELAY (100);
       end;
GPATT (0);
DELAY (1500);
end;

procedure ARC;
var A,B,C  :integer;

begin
GINIT;
GMODE (1);
DISTR;
B:=0;
C:=0;
for A:=20 to 40 do
    begin
    SETARC (320,200,A*4,B,B+100,7);
    B:=B+36;
    if B>260 then B:=0;
    end;
DELAY (1500);
end;

procedure INOUT;

Var A:Integer;
begin
Gclear;
Settext (450,80,'Screenwindowing',0,0,1);
Readwindow ('f1.pix',0,0);
Readwindow ('f2.pix',0,150);
Readwindow ('f3.pix',400,0);
For A:=0 to 15 do
    Begin
       Dispzoom (0,0,A);
       Delay (900);
    End;
Dispzoom (0,0,0);
Delay (400);
end;

begin
BEGRUESSUNG;
GINIT;
repeat
   if not keypressed then TEXTDEMO;
   if not keypressed then DZOOM;
   if not Keypressed then VIELECK;
   if not Keypressed then CIRCLES;
   if not Keypressed then RECT;
   if not Keypressed then BOX;
   if not Keypressed then ARC;
   if not Keypressed then INOUT;
until Keypressed;
GEXIT;
end.


