;*************************************************
;                                                *
; PERIF  Ansteuerung peripherer Baugr.  13.11.85 *
;                                                *
;*************************************************
;
;
org    1ba0h
ofs    0ba0h
;
;
;****************************************************
;
; PRM  Aufruf der EPROM-Programmier-Software
;
;****************************************************
;
; Unterscheidet 87er- und 89er-Prommer-Hardware
; durch Abfrage der Adresse 2000h; in der 89er-Hard-
; ware steht dort (nach Umschaltung auf Hilfsbank 3)
; ein NOP (=00h), andernfalls ein JMP (=C3h) bzw.FFh.
;
prm:   mvi  a,0c0h
       out  fdctrl    ;Hilfsbank 3 einschalten
       lda  2001h     ;Testadresse auslesen
       cpi  0h        ;00h nur bei 89er-Hardware
       jz   2000h     ;dann dorthin
       jmp  promsw    ;87er-Software hinter Editor
;
;
;****************************************************
;
;      Bildschirmabzug
;
;****************************************************
;
hrdcpy:lxi  h,ioflg   ;I/O-FLAG einstellen
       lda  srcbeg    ;N0,4,5,6,7 erlaubt!
       mvi  m,10h     ;=LO4
       cpi  4h        ;Eingabe N4?
       jz   print     ;ja: JMP
       mvi  m,20h     ;=LO5
       cpi  5h        ;Eingabe N5?
       jz   print     ;ja: JMP
       mvi  m,40h     ;=LO6
       cpi  6h        ;Eingabe N6?
       jz   print     ;ja: JMP
       mvi  m,80h     ;Eingabe 0 oder 7: LO7
;
print: lhld linz
       dcx  h
       xchg           ;D&E: Bufferende
       lxi  h,vidram
prloop:mov  c,m
       call lo
       mov  a,l
       cmp  e
       jnz  prtcte
       mov  a,h
       cmp  d
       jnz  prtcte    ;kein Ende: weiter
       xra  a
       inr  a         ;FLAGs l|schen
       ret
prtcte:inx  h
       jmp  prloop
;
;
;****************************************************
;
; V24OT/V24IN  Verwaltung der V.24-Schnittstelle
;
;****************************************************
;
vvot:  lxi  h,v24ot-  ;V.24-Ausgabe
       jmp  vvcte
vvin:  lxi  h,v24in-  ;V.24-Eingabe
;
vvcte: shld hbuf2
       mvi  a,0c3h    ;"JMP"
       sta  hibuf2
       lxi  h,inosub  ;RET-Adresse
       push h         ;in den Stack
       lhld v24ini    ;=CALL V24INI
       pchl
;
inosub:lhld srcbeg
       mov  c,m
       push h
       call hibuf2    ;I/O-Subroutine
       pop  d
       lhld srcend
       xchg
       mov  a,l
       cmp  e
       jnz  inrhl
       mov  a,h
       cmp  d
       jnz  inrhl     ;I/O fortsetzen
inoend:call loinit    ;wieder Drucker einstellen
       xra  a
       inr  a         ;FLAGs l|schen
       ret
;
inrhl: inx  h         ;Pointer erh|hen
       shld srcbeg
       jmp  inosub
;
v24ot-:lxi  d,3h      ;Sprungziele ermitteln
       jmp  v24
v24in-:lxi  d,6h
v24:   lhld v24ini    ;Bezugsadresse
       dad  d
       pchl
;
;
;*****************************************************
;
; EZU  Ansteuerung der Echtzeit-Uhr
;
;*****************************************************
;
;  Stellen der Uhr: Kommando "u", gefolgt von
;                   Stunden/Minuten,Wochentag-   
;                   Code (1=Montag)/Kalendertag,  
;                   Monat/Jahr; Return.
;  Beispiel: Fr,08.11.85;15:47:00h wird eingegeben
;            als 1547 (15:47h; Sekunden immer 00),
;            508 (Freitag der 8.), 1185 (Nov.85).
;
;  Lesen der Uhr: Kommando "u" ohne weitere Parameter
;                 
;  Anschlie~end wird die Uhrzeit automatisch rechts
;  oben in den Bildschirm eingeblendet; dazu wird
;  der Interrupt RST6.5 (beim 8085) bzw. RSTB (beim
;  NSC800 benutzt.
;
ezu:   di
       lhld srcbeg
       mov  a,h
       ora  l         ;Nullabfrage
       jz   rdezu     ;Null: Uhr lesen
;
wrezu: lhld srcend    ;Wo/Kal-Tag
       mov  b,h
       mov  c,l
       lhld dstbeg    ;Monat/Jahr
       xchg
       lhld srcbeg
       call writur
;
rdezu: lxi  h,int65   ;RST6.5-ISR vorbereiten
       mvi  m,0c3h    ;"JMP" 
       inx  h
       lxi  d,isr65
       mov  m,e       ;Zieladresse ins RAM
       inx  h
       mov  m,d
       mvi  a,1dh     ;RST6.5 freigeben
       sim
       nop            ;wg.NSC800-JR-Befehl
       mvi  a,4h      ;RSTB freigeben
       out  0bbh
;
       mvi  c,0ah     ;Linefeed
       call co
       call time
       lxi  h,ascbuf
       call string    ;Uhrzeit/Datum ausgeben
       inr  c         ;ZERO-FLAG l|schen
       nop            ;./. EI
;
; RST6.5-Interrupt-Service-Routine (ca.3 ms b. 6 MHz)
;
isr65: push psw
       push h
       push d
       push b
;
       lhld second
       inx  h         ;Sekundenz{hler erh|hen
       shld second    ;(max. 18:12:16 h)
;
       lhld lin2      ;Bildschirmeinblendung
       lxi  d,0ffebh  ;oben rechts vorbereiten
       dad  d         ;H&L: Bildposition
       push h
       call time      ;ASCII-String erzeugen
       pop  h
       lxi  d,ascbuf
;
wrtlop:ldax d         ;ASCII-Code auslesen
       ora  a         ;Endabfrage
       jz   isrend    ;Stringende: JMP
       mov  c,a
wrtlp: in   vidctl    ;Blanking abwarten
       rrc            ;(nicht CO wg.Par.Druck)
       jnc  wrtlp
       mov  m,c       ;Code ausgeben
       inx  d
       inx  h
       jmp  wrtlop
;
isrend:pop  b
       pop  d
       pop  h
       pop  psw
       ei
       ret
;
;
;****************************************************
;
; BYTE  Einzel-Byte-Betrieb
;
;****************************************************
;
;  Setzt das Einzelschritt-Modul voraus (bzw.89er-CPU
;  mit LED-Anzeige)
;
byte:  lhld srcbeg    ;Startadresse
       mvi  a,40h
       out  stpff     ;STEP-Flipflop
       pchl
;
;
;****************************************************
;
; BREAK  Breakpoint-Betrieb im RAM
;
;****************************************************
;
; Der OpCode an der n{chstfolgenden (bzw. an der
; Break-)Adresse wird durch einen Software-Inter-
; rupt (RS2=D7h) ersetzt; deshalb m}ssen die im
; BREAK- oder STEP-Mode durchlaufenen Programm-
; teile im RAM stehen.
;
; Im Anwenderprogramm d}rfen nicht die Befehle
; RST1 und RST2 verwendet werden (f}r den Monitor
; reserviert); der User-Stack-Pointer darf, wenn
; er modifiziert wird, nur unterhalb 2E00h liegen.
;
posa   equ   8h       ;Pos. von REG-A-Daten
leng   equ  27h       ;String ges. 39d lang
len    equ  1fh       ;Reg-String 31d lang
;
brkpt: call brkini    ;Breakpoints vorbereiten
       lhld srcend    ;Break-Adresse
       shld adres     ;}bergeben und retten
bresto:shld brkpt1    ;BREAK-RESTOR-Ersatz
       mov  a,m       ;OpCode holen
       sta  opcod1    ;und retten
       mvi  m,0d7h    ;"RST2" einsetzen 
       lda  regf      ;BREAK-RESTOR-Ersatz
       mov  c,a       ;REG C: CPU-FLAGs
       push b
       pop  psw       ;CPU-FLAGs setzen
       lhld regs      ;User-Stack-Pointer
       mov  a,l       ;sortieren
       mov  l,h       ;(H&L vertauschen)
       mov  h,a
       sphl           ;in CPU-Stack-Pointer
       lxi  h,regb    ;Pointer auf REG-Buffer
       mov  b,m       ;REG B laden
       inx  h
       mov  c,m       ;REG C laden
       inx  h
       mov  d,m       ;REG D laden
       inx  h
       mov  e,m       ;REG E laden
       lhld srcbeg    ;Startadresse holen
       push h         ;und im Stack ablegen
       lhld regh      ;Daten f}r H&L holen
       mov  a,l       ;und sortieren
       mov  l,h       ;((H&L vertauschen)
       mov  h,a
       lda  rega      ;REG A laden
       ret            ;Start bis zum Breakpoint
;
;
;******************************************************
;
; STEP  Einzelschritt-Betrieb im RAM
;
;******************************************************
;
; Es sind dieselben Randbedingungen zu beachten wie
; beim Breakpoint-Betrieb.
;
step:  call brkini
       lhld srcbeg
       shld adres
       jmp  bresto    ;D7h einsetzen und Start
;
brkcte:call crlflo    ;CRLF nur an Printer
       call crlflo
       lda  ioflg     ;Kopfzeile ausdrucken?
       ani  0f0h
       jz   inloop    ;kein Paralleldruck: JMP
       lxi  h,hedlin  ;Indexleiste
prtlop:mov  a,m
       ora  a
       jz   prtend    ;Ende: JMP 
       mov  c,a
       call lo        ;ausdrucken
       inx  h
       jmp  prtlop
prtend:call crlflo
       mvi  c,"-"
       mvi  b,leng
prtlp: call lo        ;Unterstreichung
       dcr  b
       jnz  prtlp
       jmp  inloop
;
;
; BRKINI  Breakpoints vorbereiten
;
brkini:lxi  h,brkcte
       shld hbuf2     ;CTE-Adresse (Warmstart)
       mvi  a,0c3h    ;"JMP"
       sta  hibuf2    ;CTE-Adresse f}r HIBUF
       lda  modflg    ;Mode-FLAG holen
       ani  0f7h      ;FCT-FLAG l|schen
       ori  80h       ;STP-Bit setzen
       sta  modflg
       xra  a
       sta  regf      ;REG F l|schen
       lxi  h,0h      ;Breakpoint-Adr. l|schen
       shld brkpt1
       shld brkpt2
       ret
;
;
;****************************************************
;
; INLOP  Register-Inhalte anzeigen und modifizieren
;
;****************************************************
;
; Bewegung des Cursors nach links und rechts }ber
; die Pfeiltaste neben "TAB", die Cursor-Steuer-
; tasten sowie CTL+H (links) bzw. CTL+J (rechts)
;
inloop:lxi  h,inlop
       shld hbuf2
       call crlf
inlop: lhld linz
       shld update
       call clrlin
       lhld adres
       push h
       call adrot     ;RAM-Adresse anzeigen
       mvi  c,20h     ;Blank
       call co  
       pop  h
       mov  a,m
       call bytot     ;RAM-Inhalt anzeigen
       call regsot    ;REG-Inhalte anzeigen
;
       call crlf
       lda  ioflg     ;Paralleldruck
       push psw       ;unterdr}cken
       ani  0fh
       sta  ioflg
       lxi  h,hedlin  ;Indexzeile ausgeben
       call undrln
       pop  psw
       sta  ioflg     ;alter Zustand
       lhld liny      ;vorletzte Zeile
       lxi  d,posa
       dad  d         ;auf REG A posit.
       call crspos
       call crson
       lxi  sp,stack  ;Monitor-Stack!
;
inlp:  call ci
       cpi  0dh       ;Ret?
       jz   nxt
       cpi  20h       ;Blank?
       jz   nxt
       cpi  3ch       ;Pfeil links?
       jz   left
       cpi  80h       ;Cursor links?
       jz   left
       cpi  3eh       ;Pfeil rechts?
       jz   right
       cpi  82h       ;Cursor rechts?
       jz   right
       cpi  1bh       ;CTL+C?
       jz   warm      ;Monitor-R}cksprung
;
       call hxtest    ;Eingabe verarbeiten
       jnz  incte     ;HEX-Input: JMP
       out  belout    ;Eingabe ignorieren
       jmp  inlp
incte: ori  30h       ;ASCII-Umsetzung
       cpi  3ah       ;"9"+1
       jc   cte
       adi  7h        ;Buchstabe
cte:   mov  c,a
       lhld update
blklop:in   vidctl    ;Blanking abwarten
       rrc
       jnc  blklop
       mov  m,c       ;Bildschirm-Ausgabe
movcrs:inx  h
       call crspos
       push h
       lhld liny      ;Endabfrage
       lxi  d,leng
       dad  d         ;H&L:Zeilenende
       pop  d         ;D&E:Cursor-Pos.
       xchg
       mov  a,l
       cmp  e
       jnz  inct
       mov  a,h
       cmp  d
       jnz  inct      ;nicht am rechten Rand: JMP
       lhld liny      ;Cursor auf REG A
       lxi  d,posa
       dad  d
       call crspos
       jmp  inlp
inct:  in   vidctl    ;Blanking abwarten
       rrc
       jnc  inct
       mov  a,m
       cpi  20h       ;auf Blank?
       jnz  inlp
       jmp  right     ;Cursor weiter rechts
;
nxt:   call input     ;Daten vom Bildschirm einlesen
       jmp  restor    ;REGs laden und Start
;
left:  lhld update
       dcx  h
       call crspos
       push h
       lhld liny      ;links von REG A?
       lxi  d,posa
       dcx  d
       dad  d
       pop  d
       mov  a,l
       cmp  e
       jnz  lftcte 
       mov  a,h
       cmp  d
       jnz  lftcte    ;nein: weiter
       lxi  d,len
       dad  d
       call crspos
       jmp  inlp
lftcte:xchg
lftlop:in   vidctl    ;Blanking abwarten
       rrc
       jnc  lftlop
       mov  a,m
       cpi  20h       ;auf Blank?
       jnz  inlp
       jmp  left
;
right: lhld update
       jmp  movcrs
;
crlf:  mvi  c,0ah
       call co        ;Linefeed
       mvi  c,0dh
       call co        ;Carriage Return
       ret
;
crlflo:mvi  c,0ah     ;CRLF nur f}r Printer
       call lo
       mvi  c,0dh
       call lo
       ret
;
;
; INPUT  Daten vom Bildschirm einlesen
;
input: lhld liny
       lxi  d,posa    ;bei REG A anfangen
       dad  d
       call regin
       sta  rega      ;REG A laden
       inx  h
       call regin
       sta  regb      ;REG B laden
       call regin
       sta  regc      ;REG C laden
       inx  h
       call regin
       sta  regd      ;REG D laden
       call regin
       sta  rege      ;REG E laden
       inx  h
       call regin
       sta  regh      ;REG H laden
       call regin
       sta  regl      ;REG L laden
       inx  h
       call regin
       sta  regs      ;SP (upper) laden
       call regin
       sta  regp      ;SP (lower) laden
       inx  h
       call flgin     ;FLAGs einlesen
       sta  regf
       ret
;
regin: in   vidctl    ;Blanking abwarten
       rrc
       jnc  regin
       mov  a,m       ;upper Nibble holen
       call hxtest
       rlc
       rlc
       rlc
       rlc
       mov  c,a
       inx  h
reglop:in   vidctl    ;Blanking abwarten
       rrc
       jnc  reglop
       mov  a,m       ;lower Nibble holen
       call hxtest
       ora  c         ;Byte zusammensetzen
       inx  h
       ret
;
flgin: lxi  b,8h      ;B=00, C=08
flglop:in   vidctl    ;Blanking abwarten
       rrc
       jnc  flglop
       mov  a,m       ;Bit holen
       ani  1h        ;LSB maskieren
       push psw
       rrc
       pop  psw
       jnz  flgcte
       mvi  a,0h      ;Null nachschieben
flgcte:ora  b         ;Bit ins SR
       rlc
       mov  b,a
       inx  h
       dcr  c
       jnz  flglop
       mov  a,b
       rrc
       ret
;
;
hedlin:db   "A"
       db   "d"
       db   "r"
       db   2eh
       db   "I"
       db   "n"
       db   "h"
       db   2eh
       db   "A"
       db   20h
       db   20h
       db   "B"
       db   "&"
       db   "C"
       db   20h
       db   20h
       db   "D"
       db   "&"
       db   "E"
       db   20h
       db   20h
       db   "H"
       db   "&"
       db   "L"
       db   20h
       db   20h
       db   20h
       db   "S"
       db   "P"
       db   20h
       db   20h
       db   "S"  ;SIGN
       db   "Z"  ;ZERO
       db   "x"  ;Overflow (16 Bit)
       db   "c"  ;Aux. CARRY
       db   "x"  ;0
       db   "P"  ;PARITY
       db   "x"  ;Overflow (bin.)
       db   "C"  ;CARRY
       db   0h
;
;
;****************************************************
;
;      HELP  Menue-Anweisungen listen
;
;****************************************************
;
help:  lxi  h,hlptxt
       call string
       inr  a         ;FLAGs l|schen
       ret
hlptxt:ds   0h
;
end
;
@:user
a;Assembler
b;BASIC
c:copy
d;Disassembler
e;Editor
f;Floppy
g:go
h:help
i:casin
j:jump back
k:kill
l:list
m:mem/fill
n:hardcopy
o:casot
p;Prommer
q:sample
r:revise
s:step
t:text
u:uhr
v:v24in
w:v24out
x:exchange
y:byte
z:break
;


B>