;**************************************************
;                                                 *
;      RAM  Speicherverwaltung           13.11.85 *
;                                                 *
;**************************************************
;
;
org    18dah
ofs     8dah
;
;
;****************************************************
;
;      KILL  Zeichen durch anderes ersetzen
;
;****************************************************
;
;
; Ersetzt im Bereich der angegebenen Anfangs- und
; Endadressen ein Bitmuster durch ein anderes; Bei-
; spiel: Im Bereich 9000...AFFFh sollen alle vor-
; kommenden "FFh" eliminiert (durch 00h ersetzt)
; werden.
;
; Eingabe: "k 9000,AFFF,FF00"; Return
;
kill:  lhld srcend
       xchg           ;D&E: Endadresse
       lhld dstbeg
       mov  b,l       ;Ersatzzeichen
       mov  c,h       ;zu ersetzendes Zeichen
       lhld srcbeg    ;H&L: Anfangsadresse
;
kilop: mov  a,m
       cmp  c
       jnz  kicte     ;nicht zu ersetzen: JMP
       mov  m,b       ;Zeichen ersetzen
       mov  a,m       ;Kontrollesen
       cmp  b
       jz   kicte     ;o.k.: JMP
       push h
       push d
       push b
       mvi  a,14h     ;fehlgeschlagen:
       call error     ;Fehlermeldung
       pop  b
       pop  d
       pop  h
kicte: mov  a,l
       cmp  e         ;Endabfrage
       jnz  kict
       mov  a,h
       cmp  d
       jnz  kict      ;nicht am Ende: JMP
       lhld srcbeg
       jmp  copct2    ;eine Zeile listen
kict:  inx  h
       jmp  kilop
;
;
;****************************************************
;
;      TXT  Ausgabe eines ASCII-Strings
;
;****************************************************
;
; Ausgabe eines Textes von der angegebenen Start-
; adresse an bis zum ebenfalls angegebenen End-
; zeichen; Beispiel: ASCII-String ab 9000h ausge-
; ben, bis das Endzeichen "00h" erreicht ist:
;
; Eingabe: "t 9000,00"; Return
;
txt:   call crlf
       lhld srcbeg
       lda  srcend  
txtlop:mov  c,m
       cmp  c
       jz   txtend    ;Endzeichen erreicht: JMP
       call co
       inx  h
       jmp  txtlop
txtend:xra  a
       inr  a         ;FLAGs l|schen
       ret
;
;
;***************************************************
;
;      GO  Anwenderprogramm starten
;
;***************************************************
;
go:    lhld srcbeg
       xra  a
       cmp  h         ;Nulleingabe?
       jnz  gocte     ;nein: JMP
       cmp  l
       jnz  gocte
       lxi  h,rambeg  ;RAM-Anfangsadresse laden
gocte: shld adres
       jmp  restor    ;REGs laden, Start
;
;
;***************************************************
;
;      FILL      RAM mit Konstante f}llen
;
;***************************************************
;
fill-: call fill
       lhld srcbeg
       jmp  copct2
;
;
;***************************************************
;
;      COPY      Speicherbereich verschieben
;
;***************************************************
;
copy-: call copy
copcte:lhld dstbeg
       shld srcbeg
copct2:shld srcend
       jmp  list
;
;
;**************************************************
;
;      EXCHAN    Speicherbereich verschieben  und
;                dabei Adressen anpassen
;
;**************************************************
;
excha-:call exchan
       jmp  copcte
;
;
;***************************************************
;
;      LIST      HEX-Dump des Speicherinhaltes
;
;***************************************************
;
smlvid equ  28h       ;HORDSP bei  Kleinformat
;
list:  lhld srcbeg
       mov  a,l
       ani  0f0h      ;abrunden        
       mov  e,a
       mov  d,h       ;D&E: Anfangsadresse
       lhld srcend
       mov  a,l
       ori  0fh       ;aufrunden
       mov  l,a       ;H&L: Endadresse
       inx  h         ;wg. COMP
       call crlf
       mvi  a,0h
       sta  hibuf2    ;Zeilenz{hler
;
       xchg           ;D&E:Ende; H&L:Pointer
lilop: call adrot     ;Adresse ausgeben
       xchg           ;wg. ADROT-XCHG
       call byt8      ;8 Bytes ausgeben
       jnz  lict
lend:  xra  a
       inr  a         ;Z-FLAG l|schen
       ret
lict:  lda  hordsp
       cpi  smlvid
       jnz  licte     ;Gro~format: JMP
       jmp  inrlin    ;Linefeed bei Kleinformat
;
licte: call byt8
       jz   lend
inrlin:call crlf
       lda  hibuf2
       inr  a         ;Zeilenz{hler
       sta  hibuf2
       ani  3fh       ;mod. 64d?
       jnz  lilop
       lda  ioflg     ;Paralleldruck?
       ani  0f0h
       jz   lilop
       mvi  c,0ch     ;Formfeed
       call lo
       jmp  lilop
;
byt8:  call space
       call byt4
       call byt4
       call comp
       ret
;
byt4:  call space
       call byt2
       call byt2
       ret
;
byt2:  call byt1
       call byt1
       ret
;
byt1:  call space
       mov  a,m
       call bytot
       push d
       push h
       lxi  h,warm
       call break
       pop  h
       pop  d
       inx  h
       ret
;
spaces:call space
space: mvi  c,20H
       call co
       ret
;
crlf:  mvi  c,0dh
       call co
       mvi  c,0ah
       call co
       ret
;
comp:  mov  a,e
       cmp  l
       rnz
       mov  a,d
       cmp  h
       ret
;
;****************************************************
;
;      MEM       RAM-Inhalt inspiz./modifizieren
;
;****************************************************
;
mem:   lhld srcend
       mov  a,l
       ora  h
       jnz  fill-     ;Par.2 nicht Null: JMP
;
memode:call crson     ;Memory-Mode
       call crlf
       lda  ioflg     ;save IO-FLAG
       sta  hibuf2
       ani  0fh       ;Paralleldruck
       sta  ioflg     ;ausschalten
       lhld srcbeg
       xra  a
       cmp  h         ;Nulleingabe?
       jnz  memlop    ;nein: JMP
       cmp  l
       jnz  memlop
       lxi  h,rambeg
;
memlop:shld adres
memlp: lhld adres
       mov  a,m
mlop:  sta  data      ;Speicherinhalt auslesen
       call adrot     ;Adresse ausgeben
       xchg           ;wg. ADROT-XCHG
       call spaces
       mvi  c,3eh     ;Daten-Pfeil (rechts)
       lxi  d,0ah
       lda  modflg
       ani  1h
       jnz  memcte    ;Daten-Mode: JMP
       mvi  c,3ch     ;Adre~-Pfeil (links)
       lxi  d,3h
memcte:call co
       lhld linz      ;Cursor auf Daten- oder
       dad  d         ;Adre~feld
       push h
       call spaces
       lda  data
       push psw
       call bytot     ;Daten ausgeben
       call spaces
       pop  psw
       call bytbin    ;Daten bin{r ausgeben
       pop  h
       call crspos
;
       call ci        ;Tastatur abfragen
       cpi  1bh       ;CTL+C?
       jz   memend
       mov  b,a       ;f}r Fehlerbeh. retten
       cpi  0dh       ;RET?
       jz   nxt
       cpi  20h       ;Blank?
       jz   nxt       ;(=RET)
       cpi  2dh       ;Minus?
       jz   bak
       cpi  3ch       ;Adr?
       jz   adr
       cpi  3eh       ;Dat?
       jz   dat
;
       lxi  d,0h
       call hxtest    ;HEX-Zeichen?
       jnz  mprocs
       mov  c,b
       call co        ;falsches Zeichen ausgeben 
       call error
       call crlf
       jmp  memlp
;
memend:lda  hibuf2    ;restore IOFLG
       sta  ioflg
       jmp  warm
;
mprocs:mov  b,a       ;Verarbeitung
       lda  modflg
       ani  1h
       lhld adres
       jz   sftadr    ;Adre~-Mode: JMP
sftdat:lda  data      ;Daten nachschieben
       ani  0fh
       rlc
       rlc
       rlc
       rlc
       ora  b
       mvi  c,0dh
       call co
       jmp  mlop
sftadr:mov  a,h       ;Adresse nachschieben
       ani  0fh
       rlc
       rlc
       rlc
       rlc
       mov  h,a
;
       mov  a,l
       rlc
       rlc
       rlc
       rlc
       mov  l,a
       ani  0fh
       ora  h
       mov  h,a
;
       mov  a,l
       ani  0f0h
       ora  b
       mov  l,a
       mvi  c,0dh
       call co
       jmp  memlop
;
nxt:   lhld adres     ;Adresse erh|hen
       lda  data
       mov  m,a
       mov  b,m
       cmp  b
       jz   nxtcte    ;Einschreiben o.k.:JMP
       mvi  a,14h
       call error     ;Einschreiben fehlgeschl.
       jmp  memlp     ;Adresse bleibt erhalten
nxtcte:inx  h
       call prtcrl
       jmp  memlop
;
bak:   call prtcrl    ;Adresse erniedrigen
       call prtcrl
       lhld adres
       dcx  h
       jmp  memlop
;
adr:   lda  modflg    ;Adre~-Mode w{hlen
       ani  0feh
       ori  2h
adrcte:sta  modflg
       mvi  c,0dh
       call co
       jmp  memlp
;
dat:   lda  modflg    ;Daten-Mode w{hlen
       ani  0fdh
       ori  1h
       jmp  adrcte
;
prtcrl:lda  hibuf2    ;CRLF mit evtl.Paralleldruck
       sta  ioflg
       call crlf
       lda  ioflg
       sta  hibuf2
       ani  0fh
       sta  ioflg
       ret
;
;
;***************************************************
;
;      COMPAR  Speicherbereiche vergleichen
;
;***************************************************
;
; Listet die Abweichungen auf (links=SRCBEG,
; rechts:DSTBEG)
;
compa-:call crlf
cmplop:lhld dstbeg
       xchg           ;D&E:Zielbereich
       lhld srcbeg    ;H&L:Quellbereich
       ldax d
       cmp  m         ;Vergleich
       jz   ready     ;gleich: Endabfrage
;
       push h
       call adrot     ;Quelladresse ausgeben
       mvi  c,"="
       call co
       pop  h
       mov  a,m
       call bytot     ;Inhalt Quell-Speicher
       call spaces
       lhld dstbeg
       push h
       call adrot     ;Zieladresse ausgeben
       mvi  c,3ah     ;":"
       call co
       pop  h
       mov  a,m
       call bytot     ;Inhalt Ziel-Speicher
       call crlf
       lxi  h,warm
       call break     ;Abbruch?
;
ready: lhld srcend
       xchg
       lhld srcbeg
       mov  a,l
       cmp  e
       jnz  rdyend
       mov  a,h
       cmp  d
       jnz  rdyend
       xra  a         ;Endadresse erreicht
       inr  a         ;FLAGs l|schen
       ret
rdyend:inx  h
       shld srcbeg
       lhld dstbeg
       inx  h
       shld dstbeg
       jmp  cmplop
;
end

B>