;*************************************************
;                                                *
; CO  Console-Ausgabe                   13.11.85 *
;                                                *
;*************************************************
;
;
;      Ausgabe von Zeichen ins Video-RAM zur
;      Darstellung auf dem Bildschirm; Paral-
;      leldruck wird vom I/O-FLAG gesteuert:
;
;      Aufbau des I/O-FLAGs (IOFLG):
;
;      Bit  7  6  5  4  3  2  1  0
;           :  :  :  :  x  x  x  :
;           :  :  :  :           :..Shift Lock
;           :  :  :  :..Thermo-       /Drucker
;           :  :  :.....8255-         /  l{uft
;           :  :........Centronics-   /  zu CO
;           :.......... V.24-        /parallel
;
;
;      Das Umschalten der Bits 1...7 erfolgt
;      durch Bet{tigen der Tasten CTL+1...7.
;
org    15e3h
ofs     5e3h
;
co-:   push psw
       push h
       push d
       push b
;
       mov  a,c
       lxi  h,coutct  ;cte-Adresse
       push h         ;in den Stack
;
       cpi  7h        ;Bell
       jz   bell
;
       cpi  8h        ;BS
       jz   delet
;
       cpi  7fh       ;Delete
       jz   delet
;
       cpi  81h       ;PROMO-DEL
       jz   delet
;
       cpi  9h        ;HT
       jz   tabhor
htab   equ  8h        ;hor. TAB-Weite
;
       cpi  0ah       ;LF
       jz   linfe-
;
       cpi  0bh       ;VT
       jz   tabver
vtab   equ  4h        ;vert. TAB-Weite
;
       cpi  0ch       ;FF
       jz   clrvi-
;
       cpi  0dh       ;CR
       jz   caret
;
       cpi  0ffh      ;Shift Lock?
       jz   shilok
;
       ani  0f0h      ;4 MSB maskieren
       cpi  80h       ;Cursor-Fct?
       jz   cursor
;
       cpi  0b0h      ;CTL-Codes
       jz   contrl
;
       cpi  0a0h      ;Sonderzeichen
       jnz  cout
       mov  a,c
       ani  1fh
       mov  c,a
cout:  pop  h         ;cte-Adr. l|schen
       lhld update
blk1:  in   vidctl    ;Blanking abwarten
       rrc
       jnc  blk1
       mov  m,c       ;Zeichen ausgeben
       inx  h
       inx  h         ;wg. RAMAX-Limit +1
       call ramax     ;au~erhalb?
       dcx  h
       jc   coutct    ;nein: JMP
       call crlf-     ;Zeilenvorschub
coutct:call crspo-
;
coprt: lda  ioflg
       ani  0f0h      ;4 MSB maskieren
       jz   coend     ;kein Paralleldruck:JMP
;
       mvi  a,0eh     ;(h)
       cmp  c
       jnz  coprt2
       mvi  c,"h"
       jmp  colo
coprt2:inr  a         ;(m)
       cmp  c
       jnz  coprt3
       mvi  c,"m"
       jmp  colo
coprt3:inr  a         ;(s)
       cmp  c
       jnz  colo
       mvi  c,"s"
colo:  call lo        ;Drucker-Routine
       push psw
       cz   error     ;ev. Fehler melden
       pop  psw
       cpi  0dh       ;Return?
       jnz  coend     ;nein: JMP
       mvi  c,0ah     ;f}r explizites LF
       jmp  coend     ;(dann hier CALL LO)
;
coend: pop  b
       pop  d
       pop  h
       pop  psw
       ret
;
bell:  lhld update
       out  belout
       ret
;
delet: call left      ;Rubout
       mvi  c,20h     ;Blank
       call co-
       call left
       ret
;
tabhor:mvi  a,htab
       mov  b,a
       lda  ioflg     ;Paralleldruck
       push psw       ;unterdr}cken
       ani  0fh       ;(4 MSB ausblenden)
       sta  ioflg     ;kein Paralleldruck
tablop:mvi  c,20h     ;Blank ausgeben
       call co-
       dcr  b
       jnz  tablop
       pop  psw       ;altes I/O-FLAG
       sta  ioflg     ;zur}ckladen
       lhld update
       ret
;
crlf-: call linfe-
;
caret: lhld linz      ;CR nach unten links!
       ret
;
tabver:mvi  a,vtab
       mov  b,a
tbvlop:call linfe-
       dcr  b
       jnz  tbvlop
       ret
;
linfe-:push b
       push d
       lxi  b,vidram  ;Ziel
       lxi  d,vidend  ;Ende
       lhld lin2      ;Beginn
linlop:in   vidctl    ;Blanking abwarten
       rrc
       jnc  linlop
       mov  a,m       ;RAM auslesen und
       stax b         ;hochkopieren
       inx  b
       inx  h
       mov  a,d
       cmp  h         ;Endabfrage
       jnz  linlop
       mov  a,e
       cmp  l
       jnz  linlop
;
       lhld linz      ;unterste Zeile l|schen
       call clrli-
blk3:  in   vidctl    ;Blanking abwarten
       rrc
       jnc  blk3
       mvi  m,20h     ;hinter Bildfenster dunkel
;
       lhld update    ;Cursor-Pos. beibehalten!
       pop  d
       pop  b
       ret
;
clrli-:push b
       push h
       lda  hordsp
       mov  e,a
       mvi  d,0h
       dad  d
       xchg           ;D&E: Zeilenende (+1)
       pop  h         ;H&L: Zeilenanfang
clrcte:mvi  c,20h     ;Blank
blk4:  in   vidctl    ;Blanking abwarten
       rrc
       jnc  blk4
       mov  m,c
       inx  h
       mov  a,d
       cmp  h         ;Endabfrage
       jnz  blk4
       mov  a,e
       cmp  l
       jnz  blk4
       pop  b
       ret
;
clrvi-:ds   0h
;
clram: push b
       lxi  h,vidram
       lxi  d,vidend
       inx  d
       jmp  clrcte
;
shilok:pop  h
       lxi  h,warm    ;anschlie~end Warmstart
       push h         ;in den Stack
       lda  ioflg
       xri  1h        ;LSB invertieren
       sta  ioflg
       jmp  iofout    ;I/O-FLAGs anzeigen
;
;
;***************************************************
;
; Cursor-Steuerung im Monitor
;
;***************************************************
;
cursor:pop  h         ;cte-Adr. l|schen
       lxi  h,coend   ;cte-Adresse
       push h         ;in den Stack
       mov  a,c
       cpi  80h       ;CTL+H
       jz   left
;
       cpi  82h       ;CTL+J
       jz   right
;
       cpi  88h       ;CTL+DEL
       jz   lleft
;
       cpi  89h       ;CTL+U
       jz   up
;
       cpi  8ah       ;CTL+TAB
       jz   rright
;
       cpi  8bh       ;CTL+N
       jz   down
;
       cpi  8fh       ;CTL+Z
       jz   home
       ret            ;zu COEND
;
left:  push b
       lhld update
       dcx  h
       call ramin     ;au~erhalb?
       jnc  lftend    ;nein:JMP
       lxi  h,vidend
       dcx  h
lftend:call crspo-
       pop  b
       ret
;
right: push b
       lhld update
       inx  h
       call ramax
       jc   rigend
       lxi  h,vidram
rigend:jmp  lftend
;
lleft: mvi  a,htab    ;CTL+DEL
       mov  b,a
llop:  call left
       dcr  b
       jnz  llop
       ret
;
up:    lhld update
       lda  hordsp
       cma
       mov  e,a
       mvi  d,0ffh
       inx  d         ;D&E=(-vidram)
       dad  d
       call ramin
       jnc  upend
       xchg
       lxi  h,vidend
       mov  a,h
       ani  0fh       ;4 MSB ausblenden
       mov  h,a
       dad  d
upend: jmp  crspo-
;
rright:mvi  a,htab    ;CTL+TAB
       mov  b,a
rlop:  call right
       dcr  b
       jnz  rlop
       ret
;
down:  lhld update
       lda  hordsp
       mov  e,a
       mvi  d,0h
       dad  d
       call ramax
       jc   dowend
       xchg
       lxi  h,vidend
       mov  a,h
       ani  0fh       ;4 MSB unterdr}cken
       cma
       mov  h,a
       mov  a,l
       cma
       mov  l,a
       inx  h         ;H&L=(-vidram)
       dad  d
dowend:jmp  upend
;
home:  lxi  h,vidram
crspo-:shld update
       mvi  a,0eh     ;CRS-Reg
       out  vidreg
       mov  a,h
       ani  0fh       ;4 LSB maskieren
       out  vidat
       mvi  a,0fh     ;CRS-Reg
       out  vidreg
       mov  a,l
       out  vidat
       ret
;
crson-:mvi  a,0ah     ;CRS-Reg
       out  vidreg
       mvi  a,6ah     ;CRS schmal
       out  vidat
       ret
;
crsof-:mvi  a,0ah     ;CRS-Reg
       out  vidreg
       mvi  a,20h     ;CRS off
       out  vidat
       ret
;
ramin: xchg           ;D&E:Video-Pointer
       lxi  h,vidram
       mov  a,d       ;(A): Pointer (HI)
       cmp  h         ;(H): LIN1 (HI)
       jnc  minend    ;(A) nicht kl.(H):JMP
       jnz  minend    ;(A) nicht gl.(H):JMP
       mov  a,e
       cmp  l
minend:xchg
       ret
;
ramax: xchg           ;D&E:Video-Pointer
       lxi  h,vidend
       mov  a,d       ;(A): Pointer (HI)
       cmp  h         ;(H): LINUL (HI)
       jc   maxend    ;(A) kleiner (H):JMP
       jnz  maxend    ;(A) nicht gl.(H):JMP
       mov  a,e
       cmp  l
maxend:jmp  minend
;
;***************************************************
;
; Beeinflussung des I/O-FLAGs (CTL-Codes)
;
;***************************************************
;
contrl:lxi  h,0ah     ;5 PUSHs ausgleichen
       dad  sp
       sphl           ;SP unter RET-Adresse
       pop  h         ;H&L: RET-Adresse
       mov  a,h
       ani  0f0h      ;oberes Nibbel bleibt
       mov  h,a       ;Warmstart-Adr.(upper)
       mvi  l,3h      ;Warmstart-Adr.(lower)
       push h
       mov  a,c
       ani  07h       ;3 LSB maskieren
       rz             ;CTL+0: RET
       mov  c,a       ;CTL+1...7 (nicht EXT!)
       mvi  a,1h
ctlop: rlc
       dcr  c
       jnz  ctlop
       mov  c,a       ;Invers-Bit
       lda  ioflg
       xra  c         ;Bit invertieren
iofout:sta  ioflg
       push psw
       lxi  h,iotxt
       call strin-
       pop  psw
       call bytbin    ;I/O-FLAGs ausgeben
       ret            ;Warmstart im lfd.Programm
;
iotxt: db   "I"
       db   "/"
       db   "O"
       db   "-"
       db   "F"
       db   "L"
       db   "A"
       db   "G"
       db   "s"
       db   3ah
       db   20h
       db   0h
;
;***************************************************
;
; Ausgabe von Zeichenketten
;
;***************************************************
;
;      H&L: Pointer; Stringende: 00h
;
strin-:xchg           ;D&E:String-Pointer
       lhld update    ;H&L:RAM-Pointer
       nop
strlop:ldax d
       ora  a         ;Ende?
       rz             ;ja: RET
       mov  c,a
       call co-       ;Ausgabe
       cpi  0dh
       jnz  strcte    ;kein CR: JMP
       mvi  c,0ah     ;in STRING LF anh{ngen
       call co-
strcte:inx  d
       jmp  strlop
;
undrl-:xchg           ;Inversdarstellung
       lhld update
       ldax d
       mov  c,a
blk5:  in   vidctl    ;Blanking abwarten
       rrc
       jnc  blk5
       mov  m,c       ;erstes Zeichen ausgeben
       inx  d
       inx  h
undlop:ldax d
       ora  a
       jz   undend    ;Stringende  
       ori  80h       ;Inversbit setzen
       mov  c,a
blk6:  in   vidctl    ;Blanking abwarten
       rrc
       jnc  blk6
       mov  m,c
       inx  d
       inx  h
       jmp  undlop
undend:in   vidctl    ;Blanking abwarten
       rrc  
       jnc  undend
       mov  a,m
       ori  80h       ;letztes Zeichen auch invers
       mov  c,a
blk7:  in   vidctl    ;Blanking abwarten
       rrc
       jnc  blk7
       mov  m,c
       ret
;
;      BREAK     verharrt bei gedr}ckter Taste; bei
;                Eingabe des BREAK-Codes erfolgt
;                Sprung nach ((H&L)); kein Stack-
;                Ausgleich, kein CRSON!
;
brkcod equ  1bh       ;CTL+C
;
break-:push psw
       push h
       call csts      ;Taste aktiv?     
       jz   brkend    ;nein: JMP
       call ci
       cpi  brkcod    ;Abbruch?
       jnz  lokon     ;nein: JMP
loklop:call csts 
       jnz  loklop    ;bei Loslassen
       pchl           ;zum Warmstart
lokon: call csts
       jnz  lokon     ;auf Loslassen warten
lokof: call csts 
       jz   lokof     ;auf Tastendruck warten
lokout:call csts
       jnz  lokout    ;wieder Loslassen abwarten
;
brkend:pop  h
       pop  psw
       ret
;
end
;

B>