;*************************************************
;                                                ;
; CI/CSTS  Console-Eingabe, -Status     13.11.85 ;
;                                                ;
;*************************************************
;
;      Verwaltung mittels zweier Unterprogramme:
;
;      CI   (Console Input) wartet auf Tastendruck,
;           entprellt, liest Zeichen ein und }ber-
;           gibt es in REG A.
;
;      CSTS (Console Status) meldet Tastatur-Status
;           key:   (REG A)=FFh, ZERO-FLAG off (Z=0)
;                  (REG D)=Input 80h...01h
;                  (REG E)=Zeilen-Nr. 0...Fh
;           no key:(REG A)=00h, ZERO-FLAG on (Z=1)
;
;
org    13a0h
ofs     3a0h
;
;***************************************************
;
;      Einlese-Unterprogramm
;
;***************************************************
;
ci-:   jmp  ci2
cipar: jmp  cip       ;ASCII parallel
ci2:   push h
       push d
       push b
       lda  ciflag
       ora  a
       jz   cionlp    ;CI-FLAG off: JMP
cioflp:call csts-     ;auf Loslassen warten
       jnz  cioflp
cionlp:call csts-     ;auf Tastendruck warten
       jz  cionlp
cict:  lda  timprl    ;Prellzeit in ms
prlop: call dely1
       dcr  a
       jnz  prlop
       call csts-     ;Tastenmatrix abfragen
       lhld hibuf     ;Inputs holen
       xchg           ;in D&E }bergeben
       mvi  a,0fh
       sta  ciflag    ;FLAG setzen (CSTS l|scht es)
       mov  a,d       ;Input ins REG A
       ani  1fh       ;CTL-Keys ausblenden
       jz   endci     ;keine anderen Keys: JMP
       push psw       ;modif. Input retten
       mov  a,e
       rlc
       rlc            ;Zeilen-Nr. ;4
       mov  e,a
       pop  psw
inrci: rrc            ;Spalten-Nr. bin{r ums.
       jc   cicte
       inr  e
       jmp  inrci
cicte: mov  a,d
       ani  10h       ;Cursor-Taste?
       jnz  cursor    ;ja: JMP
       mov  a,d
       ani  20h       ;FCT-Taste?
       jnz  funct     ;ja: JMP
       mov  a,d
       ani  0c0h      ;SFT/CTL-Keys maskieren
       mov  b,a       ;REG B: Basis-Versatz
       cpi  0c0h      ;beide gleichz.aktiv?
       mvi  a,0h      ; =NUL
       jz   endci     ;ja: JMP
;
getcod:lda  ioflg     ;Shift lock abfragen
       ani  1h        ;LSB gesetzt
       jz   getct     ;nein: JMP
       mvi  b,40h     ;SHIFT-Versatz
;
getct: lxi  h,0h      ;CP/M-Abfrage
       dad  sp
       mvi  a,0fah    ;SP=FAxx?
       cmp  h
       jz   getcpm    ;CP/M: JMP
       mvi  a,7ah     ;SP=7Axx?
       cmp  h
       jz   getcpm    ;CP/M: JMP
       mvi  a,29h     ;SP=29xx?
       cmp  h
       jz   getcpm    ;CP/M: JMP
       xra  a         ;SP=0080/0100?
       cmp  h
       jnz  getcte    ;CP/M: JMP
getcpm:mvi  a,80h     ;CTL-Codes in CP/M?
       cmp  b
       jnz  getcte    ;nein: JMP
       mvi  b,0c0h    ;CP/M-CTL-Versatz
getcte:xra  a         ;REG A l|schen
       add  b         ;Basis-Versatz addieren
       add  e         ;Key-Nr. addieren
       mov  e,a
       mvi  d,0h
       lxi  h,asctab
       dad  d         ;H&L: Tabellenadresse
       mov  a,m       ;ASCII-Code auslesen
endci: pop  b
       pop  d
       pop  h
       ret
;
;      CURSOR    erzeugt die Cursor-Steuercodes
;
;      80h: links    (CTL+H ./. 08h = BS)
;      82h: rechts   (CTL+J ./. 0Ah = LF)
;      89h: auf      (CTL+U ./. 15h = NAK)
;      8Bh: ab       (CTL+N ./. 0Eh = SO)
;      8Fh: home     (CTL+Z ./. 1Ah = SUB)
;
;      88h: llinks    (CTL+DEL)
;      8Ah: rrechts   (CTL+TAB)
;
cursor:mov  a,e       ;Zeilen-Nr. ;4
       ani  3ch       ;Spalten-Anteil l|schen
       rrc
       rrc
       dcr  a         ;Zeilen-Nr. 0...F
       mov  e,a
       mvi  d,0h
       lxi  h,crstab  ;Code-Tabelle
       dad  d
       mov  a,m       ;ASCII-Code auslesen
       jmp  endci
;
crstab:db   8fh       ;HOME/F
       db   2bh       ;+/REG
       db   2ah       ;;/DAT
       db   2eh       ;./BST
       db   3fh       ;?/RUN
       db   2fh       ;./. /D
       db   2dh       ;-/ADR
       db   8fh       ;HOME (Ext)
       db   8bh       ;down (Ext)
       db   80h       ;left/C; auch Ext
       db   82h       ;right (Ext)
       db   ffh       ;n.c.
       db   8bh       ;down/B
       db   82h       ;right/A
       db   89h       ;up/E
       db   89h       ;up (Ext)
;
;
;      FUNCT     verzweigt zu Sprungzielen, die
;                im FCTBUF im RAM abgelegt sind
;                (erst untere, dann obere Adre~-
;                h{lfte); Aufruf durch gleich-
;                zeitiges Dr}cken der (gr}nen)
;                Funktionstaste und einer der
;                oben (!) liegenden Zifferntasten
;                0...9 (bei FCT+7 wird zu derjenigen
;                Adresse verzweigt, die in den
;                RAM-Zellen 2E20/21h abgelegt
;                ist usf; vgl.Basis-Symboltabelle)
;                Die vier Tasten einer Zeile sind
;                gleichberechtigt, d.h. "FCT+0" be-
;                wirkt dieselbe Reaktion wie "FCT+\"
;
funct: mov  a,e       ;REG E: 1Ch...3Fh
       ani  3ch
       rrc
       rrc            ;alte Zeilennummer
       mov  e,a
       mvi  d,0h
       lxi  h,fctbuf  ;Zieladressen im RAM
       dad  d
       mov  e,m
       inx  h
       mov  d,m
       xchg
       pchl           ;H&L: Sprungziel
;
;***************************************************
;
;      Abfrage-Unterprogramm
;
;***************************************************
;
csts-: jmp  csts2
cstspa:jmp  cstsp     ;ASCII parallel
csts2: push h
       push d
       push b
       lxi  h,hibuf   ;Input-Hilfsroutine
       mvi  m,0dbh    ;"IN"
       inx  h
       inx  h
       mvi  m,0c9h    ;"RET"
       dcx  h         ;H&L: RAM-Zelle f.Portadr.
       mvi  m,0fch    ;oberste Key-Portadresse
       mvi  c,0fh     ;Zeilenz{hler
cstlop:call hibuf     ;Key-Port einlesen
;
       push h
       lxi  h,keybyt  ;und bei Bedarf
       xra  m         ;invertieren
       pop  h
;
       mov  d,a       ;REG D: Input-Daten
       ani  1fh       ;3 MSB ausblenden
       jz   dcradr    ;no key: JMP
       mov  e,c       ;Key: Z{hlerstand retten
       jmp  cstend    ;und zur}ckspringen
dcradr:mov  a,m       ;Portadresse holen
       sui  10h       ;erniedrigen
       mov  m,a       ;und wieder ablegen
       dcr  c         ;Zeilenz{hler erniedrigen
       jp   cstlop    ;nicht fertig: JMP
cstend:mov  a,d       ;Input auf 00 abfragen
       ani  1fh       ;Input-Daten
       jz   csret     ;no Key: (REG A)=00, Z=1
       mvi  a,0ffh    ;Key:    (REG A)=FF, Z=0
       xchg           ;D&E f}r CI retten
       shld hibuf
csret: pop  b
       pop  d
       pop  h
       push psw
       mvi  a,0h
       sta  ciflag    ;CI-FLAG l|schen
       pop  psw
       ret
;
;
;****************************************************
;
;      ASCII-Paralleleingabe (Standard-Tastatur)
;
;****************************************************
;
;  Anschlu~ der Tastatur }ber einen 8-Bit-Parallel-
;  Port (STROBE auf Bit 7); gew{hlte Portadresse:A8h
;
asport equ  0a8h      ;z.B. Parallel-Interface
;
cip:   push h
       push d
       push b
       lda  ciflag
       ora  a
       jz   cponlp   ;CI-FLAG off: JMP
cpoflp:call cstsp    ;auf Loslassen warten
       jnz  cpoflp
cponlp:call cstsp    ;auf Tastendruck warten
       jz   cponlp
       mvi  a,0fh
       sta  ciflag   ;FLAG setzen (CSTS l|scht es)
       in   asport   ;Code einlesen
       pop  b
       pop  d
       pop  h
       ret
;
cstsp: mvi  a,0h
       sta  ciflag    ;CI-FLAG l|schen
       in   asport    ;STROBE einlesen
       nop            ;evtl. invertieren
       ani  80h       ;MSB maskieren
       rz             ;no key: ACC=0; Z=on
       mvi  a,0ffh
       ret            ;key: ACC=FF; Z=off
;
;****************************************************
;
;      Tabelle der ASCII-Codes
;
;****************************************************
;
;      Normal Codes
;
asctab:ds   0h
;0
       db   37h  ;7
       db   6ah  ;j
       db   6dh  ;m
       db   75h  ;u
;1
       db   33h  ;3
       db   64h  ;d
       db   63h  ;c
       db   65h  ;e
;2
       db   35h  ;5
       db   67h  ;g
       db   62h  ;b
       db   74h  ;t
;3
       db   31h  ;1
       db   61h  ;a
       db   79h  ;y
       db   71h  ;q
;4
       db   36h  ;6
       db   68h  ;h
       db   6eh  ;n
       db   7ah  ;z
;5
       db   32h  ;2
       db   73h  ;s
       db   78h  ;x
       db   77h  ;w
;6
       db   34h  ;4
       db   66h  ;f
       db   76h  ;v
       db   72h  ;r
;7+
       db   39h  ;9
       db   33h  ;3
       db   0dh  ;Return
       db   36h  ;6
;8+
       db   37h  ;7
       db   31h  ;1
       db   30h  ;0
       db   34h  ;4
;9
       db   81h  ;Delete (PROMO)
       db   0dh  ;Return
       db   0ffh ;Shift lock
       db   09h  ;Horizontal Tabulation
;A
       db   2bh  ;+
       db   23h  ;#
       db   0h   ;HALT
       db   3ch  ;"less than"
;B
       db   7eh  ;~
       db   7bh  ;{
       db   20h  ;"Blank"
       db   7dh  ;}
;C
       db   30h  ;0
       db   7ch  ;|
       db   2dh  ;-
       db   70h  ;p
;D
       db   39h  ;9
       db   6ch  ;l
       db   2eh  ;.
       db   6fh  ;o
;E
       db   38h  ;8
       db   6bh  ;k
       db   2ch  ;,
       db   69h  ;i
;F+
       db   38h  ;8
       db   32h  ;2
       db   2eh  ;.
       db   35h  ;5
;
;      Shift Codes
;
;0
       db   2fh  ;/
       db   4ah  ;J
       db   4dh  ;M
       db   55h  ;U
;1
       db   40h  ;@
       db   44h  ;D
       db   43h  ;C
       db   45h  ;E
;2
       db   25h  ;%
       db   47h  ;G
       db   42h  ;B
       db   54h  ;T
;3
       db   21h  ;!
       db   41h  ;A
       db   59h  ;Y
       db   51h  ;Q
;4
       db   26h  ;&
       db   48h  ;H
       db   4eh  ;N
       db   5ah  ;Z
;5
       db   22h  ;"
       db   53h  ;S
       db   58h  ;X
       db   57h  ;W
;6
       db   24h  ;$
       db   46h  ;F
       db   56h  ;V
       db   52h  ;R
;7+
       db   39h  ;9
       db   33h  ;3
       db   0dh  ;Return
       db   36h  ;6
;8+
       db   37h  ;7
       db   31h  ;1
       db   30h  ;0
       db   34h  ;4
;9
       db   08h  ;Delete (ASCII BS)
       db   0dh  ;Return
       db   0ffh ;Shift lock
       db   09h  ;Horizontal Tabulation
;A
       db   2ah  ;"Asterisk"
       db   5eh  ;"Circumflex"
       db   0h   ;HALT
       db   3eh  ;"greater than"
;B
       db   3fh  ;?
       db   5bh  ;[
       db   20h  ;"Blank"
       db   5dh  ;]
;C
       db   3dh  ;=
       db   5ch  ;\
       db   5fh  ;"Underline"
       db   50h  ;P
;D
       db   29h  ;)
       db   4ch  ;L
       db   3ah  ;:
       db   4fh  ;O
;E
       db   28h  ;(
       db   4bh  ;K
       db   3bh  ;;
       db   49h  ;I
;F+
       db   38h  ;8
       db   32h  ;2
       db   2eh  ;.
       db   35h  ;5
;
;      Control Codes (MOPPEL)
;
;0
       db   0b7h ;7; Wurzel
       db   82h  ;j; Cursor rechts
       db   0a8h ;m; griech. "m"
       db   89h  ;u; Cursor up
;1
       db   0b3h ;3; 3 Exp.
       db   0a4h ;d; griech. "d"
       db   1bh  ;c; ESC (BREAK)
       db   0a5h ;e; griech. "e"
;2
       db   0b5h ;5; Winkel
       db   0a3h ;g; griech. "g"
       db   0a2h ;b; griech. "b"
       db   0abh ;t; griech. "t"
;3
       db   0b1h ;1; 1/
       db   0a1h ;a; griech. "a"
       db   0eh  ;y; SO
       db   11h  ;q; DC1
;4
       db   0b6h ;6; Promille
       db   80h  ;h; Cursor links
       db   8bh  ;n; Cursor down
       db   8fh  ;z; Cursor home
;5
       db   0b2h ;2; 2 Exp.
       db   0aah ;s; griech. "s"
       db   15h  ;x; NAK
       db   13h  ;w; DC3
;6
       db   0b4h ;4; +/-
       db   90h  ;f; Apostroph
       db   0fh  ;v; SI
       db   07h  ;r; Bell
;7+
       db   0f9h ;CTL+9
       db   0f3h ;CTL+3
       db   0dh  ;Return
       db   0f6h ;CTL+6
;8+
       db   0f7h ;CTL+7
       db   0f1h ;CTL+1
       db   0f0h ;CTL+0
       db   0f4h ;CTL+4
;9
       db   88h  ;CTL+DEL (=LLEFT)
       db   0dh  ;Return
       db   0ffh ;Shift Lock
       db   8ah  ;CTL+TAB (=RRIGHT)
;A
       db   0bch ;+; eck.Kl. auf
       db   0bdh ;#; eck.Kl. zu
       db   0h   ;HALT
       db   0beh ;less than; geschw.Kl.auf
;B
       db   0bfh ;~; geschw.Kl.zu
       db   0a0h ;{; At Sign
       db   20h  ;Blank
       db   0bbh ;}; F}~e oben
;C
       db   0b0h ;0; fettes "s"
       db   0bah ;|; F}~e unten
       db   0afh ;-; fettes "m"
       db   0a9h ;p; griech. "p"
;D
       db   0b9h ;9; Strich
       db   0a7h ;l; griech. "l"
       db   0aeh ;.; fettes "h"
       db   0ach ;o; griech. "o"
;E
       db   0b8h ;8; ungef{hr
       db   0a6h ;k; griech. "k"
       db   0adh ;,; Grad
       db   91h  ;i; Gegen-Apostroph
;F+
       db   0f8h ;CTL+8
       db   0f2h ;CTL+2
       db   0feh ;CTL+"."
       db   0f5h ;CTL+5
;
;      Control Codes (CP/M)
;
;0
       db   60h  ;7; Spare
       db   0ah  ;J; Line Feed
       db   0dh  ;M; Return
       db   15h  ;U; NAK
;1
       db   1dh  ;3; GS
       db   04h  ;D; End of Transmission
       db   03h  ;C; ETX
       db   05h  ;E; Enquiry
;2
       db   1fh  ;5; US
       db   07h  ;G; Bell
       db   02h  ;B; Start of Text
       db   14h  ;T; Device Control 4
;3
       db   1Bh  ;1; ESC
       db   01h  ;A; Start of Heading
       db   19h  ;Y; End of Medium
       db   11h  ;Q  Device Control 1
;4
       db   27h  ;6; Spare
       db   08h  ;H; BS
       db   0eh  ;N; SO
       db   1ah  ;Z; SUB
;5
       db   1ch  ;2; FS
       db   13h  ;S; Device Control 3
       db   18h  ;X; Cancel
       db   17h  ;W; End of Transm. Block
;6
       db   1eh  ;4; RS
       db   06h  ;F; Acknowledge
       db   16h  ;V; Synchronous idle
       db   12h  ;R; Device Control 2
;7+
       db   7fh  ;9; Spare
       db   1dh  ;3; GS
       db   0dh  ;Return
       db   27h  ;6; Spare
;8+
       db   60h  ;7; Spare
       db   1bh  ;1; ESC
       db   00h  ;0; (NUL)
       db   1eh  ;4; RS
;9
       db   7fh  ;Delete (ASCII DEL)
       db   0dh  ;Return
       db   0ffh ;Shift Lock
       db   00h  ;TAB; (NUL)
;A
       db   00h  ;+; (NUL)
       db   00h  ;#; (NUL)
       ds   1h   ;Spare Key
       db   00h  ;greater; (NUL)
;B
       db   00h  ;~; (NUL)
       db   00h  ;[; (NUL)
       db   00h  ;Blank; (NUL)
       db   00h  ;]; (NUL)
;C
       db   00h  ;0; (NUL)
       db   00h  ;\; (NUL)
       db   00h  ;-; (NUL)
       db   10h  ;P; Data Link escape
;D
       db   7fh  ;9; Spare
       db   0ch  ;L; Form feed
       db   00h  ;.; (NUL)
       db   0fh  ;O; Shift in
;E
       db   67h  ;8; Spare
       db   0bh  ;K; Vertical Tabulation
       db   00h  ;,; (NUL)
       db   09h  ;I; Horizontal Tabulation
;F+
       db   67h  ;8; Spare
       db   1ch  ;2; FS
       db   00h  ;.; (NUL)
       db   1fh  ;5; US
;
;
;***************************************************
;
;      Control- und Spare-Codes f}r CP/M
;
;***************************************************
;
;      00h: CTL+Space NUL  Null
;      01h: CTL+A     SOH  Start of Heading
;      02h: CTL+B     STX  Start of Text
;      03h: CTL+C     ETX  End of Text
;      04h: CTL+D     EOT  End of Transmission
;      05h: CTL+E     ENQ  Enquiry
;      06h: CTL+F     ACK  Acknowledge
;      07h: CTL+G     BEL  Bell
;      08h: CTL+H     BS   Backspace
;      09h: CTL+I     HT   Horizontal Tabulation
;      0Ah: CTL+J     LF   Line feed
;      0Bh: CTL+K     VT   Vertical Tabulation
;      0Ch: CTL+L     FF   Form feed
;      0Dh: CTL+M     CR   Carriage Return
;      0Eh: CTL+N     SO   Shift out
;      0Fh: C7L+O     SI   Shift in
;      10h: CTL+P     DLE  Data Link Escape
;      11h: CTL+Q     DC1  Device Control 1
;      12h: CTL+R     DC2  Device Control 2
;      13h: CTL+S     DC3  Device Control 3
;      14h: CTL+T     DC4  Device Control 4
;      15h: CTL+U     NAK  Negative Acknowledge
;      16h: CTL+V     SYN  Synchronous idle
;      17h: CTL+W     ETB  End of transm. Block
;      18h: CTL+X     CAN  Cancel
;      19h: CTL+Y     EM   End of Medium
;      1Ah: CTL+Z     SUB  Substitute Character
;
;      1Bh: CTL+1     ESC  Escape
;      1Ch: CTL+2     FS   File Separator
;      1Dh: CTL+3     GS   Group Separator
;      1Eh: CTL+4     RS   Record Separator
;      1Fh: CTL+5     US   Unit Separator
;
;      27h: CTL+6          "Apostroph"
;      60h: CTL+7          "Apostroph2"
;      67h: CTL+8          Spare
;      7fh: CTL+9     DEL  Delete
;
;
end
;

B>