;*************************************************
;                                                *
; ASCMO  MOPPEL-ASCII-Monitor  V 7.5    13.11.85 *
;                                                *
;*************************************************
;
;
;      Monitor f}r Bildschirmbetrieb und ASCII-
;      Tastatur; Verzweigung zu den verschie-
;      denen Routinen }ber Sprungtabelle MENTAB
;      nach Eingabe von "Return".
;
;
;***************************************************
;
;      Hauptprogrammschleife
;
;***************************************************
;
;      Parameter-Eingabe A...Z (auch a...z m|glich),
;      getrennt durch ein Blank (kann entfallen) und
;      gefolgt von maximal drei (bis zu vierstelli-
;      gen) HEX-Parametern.
;
;      Beispiel: C 2e,d00,29af
;                :  :   :   :..Zieladresse
;                :  :   :......Endadresse
;                :  :..........Startadresse
;                :...Befehl "C" (COPY=kopieren)
;
;      Anstelle von A...Z kann der Anwender-Parame-
;      ter "@" eingegeben werden (ebenfalls mit
;      maximal drei HEX-Parametern); nach "Return"
;      erfolgt in diesem Fall der Sprung zur
;      USER-Adresse mit ]bergabe der Parameter in
;      den Zellen SRCBEG, SRCEND und DSTBEG
;
;      Fehlermeldungen:0=Parameter fehlt
;                      1=zu viele Parameter
;                      2=Zeichenfehler (kein HEX)
;                      3=unerlaubter Parameter
;
;
org    1080h
ofs      80h
;
kalt-: lxi  sp,stack  ;Kaltstart
       call init
mokalt:lxi  h,text0   ;"Video-Monitor..."
       call string
warm-: xra  a         ;Hilfsbank 0 einstellen
       out  fdctrl    ;(d.h. FDC-Software)
mowarm:lxi  sp,stack
       lxi  h,text1   ;Input-Zeichen
       call string
       call crson
moni:  call ci        ;Taste einlesen
       mov  c,a       ;]bergabe an CO
       call co        ;Echo ausgeben
       cpi  1bh       ;CTL+C?
       jz   mokalt
       lxi  h,moret   ;Ret-Adresse
       push h         ;in den Stack
       cpi  0dh       ;Return?
       jnz  mocte     ;kein Ret: JMP
       call crsoff
       jmp  proces    ;Verarbeitung
mocte: pop  h
       jmp  moni
;
moret: cz   error     ;bei Err: Fehlerroutine
       jz   mowarm    ;ohne "o.k." weiter
       lxi  h,text2   ;"o.k."
       call string
       jmp  mowarm
;
;****************************************************
;
;      Initialisierung
;
;****************************************************
;
init:  mvi  a,rstoff  ;RSTs sperren
       sim
       nop            ;wg. NSC800-JR-Befehl
;
       mvi  a,0h      ;CI-FLAG l|schen
       sta  ciflag
;
       lxi  h,0000h   ;FDC-Spurregs. undefiniert
       shld track0
       shld track2
;
       call loinit    ;Drucker voreinstellen
       call clrvid    ;Bildschirm l|schen
;
;      Video-Controller initialisieren
;
;      In der VIDLOP-Schleife wird jeweils eine
;      6845-Register-Adresse ausgegeben, gefolgt
;      vom zugeh|rigen Datenbyte aus der Tabelle.
;
       mvi  c,8h      ;Tabellenl{nge
       lxi  d,hordsp  ;Tabellenanfang
       lxi  h,bigtab
       in   vidctl    ;Formatwahl
       ani  80h       ;MSB maskieren
       jnz  bigcte    ;Gro~form.:JMP
       lxi  h,smltab
bigcte:mov  a,m       ;Tabellenwert
       stax d         ;ablegen
       inx  h
       inx  d
       dcr  c
       jnz  bigcte    ;Schleife
;
       lxi  b,0eh     ;B=00,C=14d
vidlop:mov  a,b       ;Reg-Nr.
       out  vidreg    ;Reg-Nr.
       mov  a,m       ;Tabellenwert
       out  vidat     ;Reg-Daten
       inx  h
       inr  b
       dcr  c
       jnz  vidlop
;
       lhld linz
       shld update
       shld 0h        ;Res.
       ret
;
bigtab:ds   0h        ;Tab.Gro~format
       db   50h       ;80d Zeichen/Zeile
       db   18h       ;24d Zeilen/Seite
       dw   3050h     ;Beginn Zeile 2
       dw   36e0h     ;Beg.vorletzte Zeile
       dw   3730h     ;Beg.letzte Zeile
;
       db   71h       ;hortot=114-1
       db   50h       ;hordsp
       db   59h       ;horsyn
       db   69h       ;vhpuls
       db   19h       ;vertot=26-1
       db   20h       ;veradj
       db   18h       ;verdsp
       db   18h       ;versyn
       db   30h       ;mode
       db   0bh       ;lines=12-1
       db   6ah       ;crssta
       db   0bh       ;crsend
       db   0h
       db   0h
;
smltab:ds   0h        ;Tab. Kleinformat
       db   28h       ;40d Zeichen/Zeile
       db   12h       ;18d Zeilen/Seite
       dw   3028h     ;Beginn Zeile 2
       dw   3280h     ;Beg.vorletzte Zeile
       dw   32a8h     ;Beg.letzte Zeile
;
       db   38h       ;hortot=57-1
       db   28h       ;hordsp
       db   2ch       ;horsyn
       db   25h       ;vhpuls
       db   19h       ;vertot=26-1
       db   01h       ;veradj
       db   12h       ;verdsp
       db   15h       ;versyn
       db   30h       ;mode
       db   0bh       ;lines=12-1
       db   6ah       ;crssta
       db   0bh       ;crsend
       db   0h
       db   0h
;
;***************************************************
;
; Verarbeitung der Eingabezeile
;
;***************************************************

;
proces:lhld linz      ;Eingabezeile
       lxi  d,12h     ;max. 3 Vierstellige Param.
       dad  d         ;H&L auf Blank hinter Param.
       mvi  c,10h     ;L{nge ohne "M="
       call parin-    ;Parameter einlesen
       rz             ;fehlerhafte Eingabe
;
projmp:ani  5fh       ;Gro~buchstaben erzeugen
       cpi  5bh       ;"Z"+1
       jnc  inperr
       cpi  40h       ;"@" (=User)
       jnc  procte
inperr:xra  a         ;FLAGs setzen
       mvi  a,13h     ;Input nicht im Menue
       ret            ;Fehler: Z=1
procte:sui  40h       ;Versatz erzeugen
       rlc
       mov  e,a
       lxi  h,mentab  ;Menue-Sprungadressen
       dad  d
       mov  e,m       ;Zieladresse (lower)
       inx  h
       mov  d,m       ;Zieladresse (upper)
       xchg           ;H&L=Zieladresse
       pchl           ;Verzweigung
       nop
;
;***************************************************
;
;      PARIN  Parameter vom Bildschirm einlesen
;
;***************************************************
;
;  Einsprung: H&L zeigen auf Blank hinter Parameter
;             REG C h{lt Parameter-L{nge
;
;  R}cksprung:Z=1 hei~t Fehler (Fehlercode in REG A)
;             sonst stehen die Parameter 1,2 und 3
;             in den Zellen SRCBEG,SRCEND u. DSTBEG
;
parin-:push h
       lxi  h,0h      ;Parameter-Buffer l|schen
       shld srcbeg
       shld srcend
       shld dstbeg
       pop  h
;
       mov  a,m       ;Zeichen vom Bildschirm holen
       cpi  20h       ;Blank?
       jz   inloop    ;Blank=o.k, d.h. JMP
       xra  a         ;FLAGs setzen
       mvi  a,11h     ;String zu lang
       ret            ;Fehler: Z=1
;
inloop:lxi  d,0h      ;Displacement
       xchg
       shld dig1      ;Hilfs-Buffer l|schen
       shld dig3
       xchg
;
inlop: dcx  h
       dcr  c
       jp   inlop2
       xra  a         ;FLAGs setzen
       mvi  a,10h     ;Input fehlt
       ret            ;Fehler: Z=1
;
inlop2:mov  a,m
       cpi  20h       ;Blank?
       jz   inlop     ;ja:JMP (nachr}cken)
       mov  b,a       ;Zeichen retten
;
       xra  a         ;REG A l|schen
       cmp  c         ;Param.-Anfang erreicht?
       mov  a,b
       jnz  incte     ;nein: JMP
       call assemb    ;Digits zusammensetzen
       inr  c         ;FLAGs l|schen
parend:ret
;
incte: cpi  2ch       ;Komma?
       jz   inct      ;ja: JMP
       cpi  2eh       ;Punkt?
       jz   inct      ;ja: JMP
       call hxtst     ;Input }berpr}fen
       rz             ;Fehler: Z=1
       jmp  inlop     ;sonst weiter
;
inct:  call assemb    ;Digits zusammensetzen
       jmp  inloop
;
assemb:push psw
       push h
       push d
       lxi  h,dig1    ;Digits zu Doppelwort
       mov  e,m       ;zusammensetzen
       inx  h
       mov  a,m
       rlc            ;oberes Nibble im
       rlc            ;unteren Wort
       rlc
       rlc
       ora  e         ;unteres Wort kpl.
       mov  e,a
       inx  h
       mov  d,m
       inx  h
       mov  a,m
       rlc            ;oberes Nibble im
       rlc            ;oberen Wort
       rlc
       rlc
       ora  d         ;oberes Wort kpl.
       mov  d,a
;
       lhld srcend    ;Parameter nachschieben
       shld dstbeg
       lhld srcbeg
       shld srcend
       xchg
       shld srcbeg
       pop  d
       pop h
       pop  psw
       ret
;
hxtes-:lxi  d,0h      ;f.externen Einsprung
hxtst: ani  5fh       ;Gro~buchstabe
       cpi  10h       ;"0"
       jc   hexerr    ;Code zu klein:JMP
       cpi  1ah       ;"9"+1
       jc   hexcte    ;Code o.k.:JMP
       adi  0c9h      ;A...F adjust
       cpi  10h       ;"F"+1
       jnc  hexerr    ;Code zu gro~:JMP
       cpi  0ah       ;korr. "A"
       jnc  insft     ;A...F: JMP
hexerr:xra  a         ;FLAGs setzen
       mvi  a,12h     ;kein HEX-Digit
       ret            ;Fehler: Z=1
;
hexcte:sui  10h       ;Rest der "3x"
insft: push h         ;Param. einsammeln
       lxi  h,dig1    ;Parameter-Buffer
       dad  d         ;Displacement
       mov  m,a
       inx  d
       pop  h
       mov  b,a
       xra  a
       inr  a         ;FLAGs l|schen
       mov  a,b
       ret            ;REG A: HEX-Nibble
;
text0: db   0dh       ;Ret
       db   "M"
       db   "O"
       db   "P"
       db   "P"
       db   "E"
       db   "L"
       db   "-"
       db   "V"
       db   "i"
       db   "d"
       db   "e"
       db   "o"
       db   "-"
       db   "M"
       db   "o"
       db   "n"
       db   "i"
       db   "t"
       db   "o"
       db   "r"
       db   20h
       db   "V"
       db   20h
       db   "7"
       db   "."
       db   "5"
       db   0dh       ;Ret
       db   "C"
       db   "o"
       db   "p"
       db   "y"
       db   "r"
       db   "i"
       db   "g"
       db   "h"
       db   "t"
       db   20h
       db   "("
       db   "C"
       db   ")"
       db   20h
       db   0eh
       db   0fh
       db   10h
       db   27h
       db   "8"
       db   "5"
       db   0dh       ;Ret
       db   0dh       ;Ret
       db   "A"
       db   "n"
       db   "w"
       db   "e"
       db   "i"
       db   "s"
       db   "u"
       db   "n"
       db   "g"
       db   20h
       db   "a"
       db   2eh
       db   2eh
       db   2eh
       db   "Z"
       db   20h
       db   "e"
       db   "i"
       db   "n"
       db   "g"
       db   "e"
       db   "b"
       db   "e"
       db   3ah
       db   0h
;
text1: db   0dh       ;Ret
       db   0dh       ;Ret
       db   "M"
       db   3eh
       db   0h
;
text2: db   0dh       ;Ret
       db   "o"
       db   2eh
       db   "k"
       db   2eh
       db   0h
;
;***************************************************
;
; Zeichenvorrat darstellen
;
;***************************************************
;
sampl-:call clrvid    ;clear screen
       lda  verdsp
       sui  4h
       rrc            ;wg. Leerzeile
       ani  0fh
       mov  b,a       ;Zeilenz{hler
       mvi  c,0ffh    ;Code-Z{hler
;
samlop:lda  hordsp    ;Zeichenz{hler
       rrc            ;wg.Zwischenraum
       ani  0f0h      ;4 LSB ausblenden
samlp: push psw
       mov  a,c
       inr  a         ;n{chster Code
       ani  7fh       ;Invers-Bit unterdr}cken
       mov  c,a
       pop  psw
       call co2       ;Character ausgeben
       dcr  a
       jnz  samlp
       call crlf
       call crlf
       dcr  b
       jnz  samlop
       jmp  warm
;
;***************************************************
;
; Fehlermeldung erzeugen
;
;***************************************************
;
error-:push psw       ;Err-Code retten
       lxi  h,errmsg
       call string
       pop  psw
       push psw
       rrc            ;oberes Nibble
       rrc
       rrc
       rrc
       ani  7h
       mov  e,a       ;Prefix 0...7
       mvi  d,0h
       lxi  h,errtab
       dad  d
       mov  c,m       ;Buchstaben auslesen
       call co
       mvi  c,30h     ;Null ausgeben
       call co        ;Code-Nr. (HI)
       pop  psw
       ani  0fh       ;unteres Nibble
       ori  30h       ;ASCII-Zahl
       mov  c,a
       call co        ;Code-Nr. (LO)
       call crlf
       out  belout    ;akustisches Signal
       xra  a         ;Err-Kennzeichen
       ret
;
errmsg:db   0dh       ;CRLF
       db   0dh
       db   "E"
       db   "r"
       db   "r"
       db   "o"
       db   "r"
       db   20h       ;Blank
       db   23h       ;#
       db   20h       ;Blank
       db   0h
       dw   0h        ;Res.
;
errtab:db   "H"  ;HEX-Monitor
       db   "M"  ;MOVID
       db   "F"  ;Floppy
       db   "P"  ;Printer
       db   "B"  ;BASIC
       db   "D"  ;Disassembler
       db   "A"  ;Assembler
       db   "E"  ;Editor
;
;***************************************************
;
; Ausgabe von Registerinhalten (ab UPDATE)
;
;***************************************************
;
bytbi-:mvi  c,8h      ;Bitz{hler
bytlop:rlc            ;MSB ins CY-Bit
       push psw
       mvi  a,0h      ;Acc l|schen
       jnc  bytcte    ;LOW-Bit:JMP
       inr  a         ;HIGH-Bit
bytcte:push b
       call nibot
       pop  b
       pop  psw
       dcr  c
       jnz  bytlop
       ret
;
nibot: ani  0fh       ;lower Nibble maskieren
       adi  30h       ;w{re ASCII-Ziffer
       cpi  3ah       ;"9"+1
       jc   nibcte    ;"0"..."9":JMP
       adi  7h        ;"A"..."F"
nibcte:mov  c,a       ;Zeichen ausgeben
       call co
       ret
;
bytspc:call space
bytot-:push psw
       rrc
       rrc
       rrc
       rrc
       call nibot
       pop  psw
       call nibot
       ret
;
adrspc:call space
       jmp  adro
adrot-:xchg
adro:  push d
       mov  a,d
       call bytot-
       pop  d
       mov  a,e
       call bytot-
       ret
;
regso-:lda  rega      ;REG A ausgeben
       call bytspc
       lhld regb      ;REG B&C ausgeben
       mov  e,h
       mov  d,l
       call adrspc
       lhld regd      ;REG D&E ausgeben
       mov  e,h
       mov  d,l
       call adrspc
       lhld regh      ;REG H&L ausgeben
       mov  e,h
       mov  d,l
       call adrspc
       lhld regs      ;SP ausgeben
       mov  e,h
       mov  d,l
       call adrspc
       call space     ;Zwischenraum
       lda  regf      ;FLAGs ausgeben
       call bytbi-
       ret
;
co2:   push psw
       mov  a,c
       cpi  08h       ;"Bell" +1
       jc   cocte     ;kleiner: JMP
       cpi  0eh       ;"CR"  +1
       jnc  cocte     ;nicht kleiner: JMP
       pop  psw
       call space     ;Codes 7...Dh unterdr}cken
       jmp  space
cocte: pop  psw
       call co
;
space: push b
       mvi  c,20h     ;Blank
       call co
       pop  b
       ret
;
crlf:  push b
       mvi  c,0dh     ;Wagenr}cklauf
       call co
       mvi  c,0ah     ;Zeilenvorschub
       call co
       pop  b
       ret
;
end
;

B>