;*************************************************
;                                                *
; MOVID  Basis-Symboltabelle            13.11.85 *
;                                                *
;*************************************************
;
; Gilt f}r alle }brigen MOVID-Programmteile: ASCMO,
; CI/CSTS, CO sowie RAM- und Peripherieverwaltung
;
; Zum Assemblieren eines dieser Programmteile wie
; folgt vorgehen:
;
; 1. Programmteil nach 9000 ff. ins RAM laden, mit
;    Editor bearbeiten und auf Diskette abspeichern.
; 2. Basis-Symboltabelle nach 9000 ff. ins RAM laden
;    und Assembler-Durchlauf 1 und 2 starten.
; 3. Quell-Listing von 1. nach 9000 ff. ins RAM
;    laden und Assembler-Durchl{ufe 0 und 2
;    starten (an vorhandene Symboltabelle anh{ngen).
; 4. Bei Bedarf Assembler-Durchlauf 3 starten und/
;    oder Objektcode aus F000 ff. ins EPROM laden.
;
;
stpff  equ  1ah  ;STP-Flipflop
vidreg equ  28h  ;CRT-Reg-Adr.
vidat  equ  29h  ;CRT-Dat-Adr.
vidctl equ  2ah  ;Format/Blanking Update
fdctrl equ  40h  ;FDC/Adre~latch
belout equ  0b9h ;Schnarre
;
rst5on equ  1eh  ;8085
rstcon equ  02h  ;NSC800
rst6on equ  1dh
rstbon equ  04h
rst7on equ  1bh
rstaon equ  08h
rstoff equ  17h
nscoff equ  00h
;
timprl equ  7h
rst1   equ  8h
dely1  equ  0bh
rst2   equ  10h
lo     equ  4fh
csinit equ  55h
loinit equ  58h
maxram equ  5bh
time   equ  61h
v24ini equ  64h  ;Adresse, kein JMP!
writur equ  79h
readur equ  7ch
save   equ  7fh
restor equ  82h
fill   equ  85h
copy   equ  88h
casot  equ  8bh
casin  equ  8eh
exchan equ  91h
;
rambeg equ  2800h     ;CPU-RAM
vidram equ  3000h     ;Anfang Video-RAM
vidend equ  3780h     ;hinter Bildausschnitt
promsw equ  7a00h     ;Ende Editor-PROM
;
org    1000h          ;CPU-ROM (upper)
;
kalt:  jmp  1080h     ;Kaltstart
warm:  jmp  108ch     ;Warmstart
co:    jmp  15e3h     ;Console Output
ci:    jmp  13a0h     ;Console Input
csts:  jmp  146bh     ;Console Status
break: jmp  18aeh     ;Programmabbruch?
parin: jmp  116bh     ;Parameter einlesen
hxtest:jmp  11edh     ;ASCII/HEX-Umsetzung
compar:jmp  1b3bh     ;MEM-Differenz ermitteln
sample:jmp  1272h     ;Zeichenvorrat ausgeben
v24ot: jmp  1c26h     ;PO }ber V.24
string:jmp  185fh     ;Video-Ausgabe
v24in: jmp  1c2ch     ;RI }ber V.24
error: jmp  12a1h     ;Fehlermeldung
undrln:jmp  1879h     ;String invers
clrvid:jmp  171dh     ;Clear Video-RAM
clrlin:jmp  16fch     ;Bildzeile l|schen
crspos:jmp  17dfh     ;Cursor positionieren
crson: jmp  17f3h     ;Cursor einschalten
crsoff:jmp  17fch     ;Cursor ausschalten
adrot: jmp  1320h     ;(H&L) ausgeben
bytot: jmp  130dh     ;(ACC) ausgeben
bytbin:jmp  12e5h     ;(ACC) bin{r ausgeben
regsot:jmp  132ch     ;(Regs) ausgeben
       dw   0h        ;Res.
;
;
mentab:ds   0h     ;Menue-Sprungadressen
       dw   0f000h ;User-Funktion (@)
       dw   6000h  ;Assembler
       dw   4000h  ;BASIC
       dw   1946h  ;COPY
       dw   6c00h  ;Disassembler
       dw   7000h  ;Editor
       dw   2000h  ;FDC-Routinen
       dw   1928h  ;GO
       dw   1f08h  ;HELP
       dw   casin  ;PROMO-CASIN
       dw   00cdh  ;Jump Back PROMO
       dw   18dah  ;KILL
       dw   195bh  ;LIST
       dw   19fch  ;MEM insp./modif./fill
       dw   1bafh  ;Hardcopy
       dw   casot  ;PROMO-CASOT
       dw   1ba0h  ;Prommer
       dw   101bh  ;Sample   
       dw   1018h  ;Revise (COMPAR)
       dw   1ce1h  ;STEP
       dw   1910h  ;TEXT
       dw   1c34h  ;Uhr
       dw   1be9h  ;V.24 Out
       dw   1befh  ;V.24 In
       dw   1955h  ;Exchange
       dw   1ca2h  ;BYTE
       dw   1caah  ;Breakpoint
;
;
;      MAIN: ASCMO, CI/CSTS, CO, RAM, Peripherie
;
;
;
;
;      bis  2DFFh     :Anwender-RAM-Bereich
;
org    equ  2e00h     ;Buffer f.Thermo-Drucker
thbuf: ds   17h
;
org    equ  2e20h     ;FCT-Sprungziele (zuerst unter
fctbuf:ds   0h        ;dann obere Adre~h{lfte ablege
fct7:  ds   02h
fct6:  ds   02h
fct5:  ds   02h
fct4:  ds   02h
fct3:  ds   02h
fct2:  ds   02h
fct1:  ds   02h
fct9+: ds   02h       ;Extension
fct7+: ds   02h       ;dito
fctdel:ds   02h
fct+:  ds   02h
fctsz: ds   02h
fct0:  ds   02h
fct9:  ds   02h
fct8:  ds   02h
fct8+: ds   02h       ;dito
;
org    equ  2e4eh     ;Video-Parameter
hordsp:ds   1h        ;Zeichen/Zeile (-1)
verdsp:ds   1h        ;Zeilen/Seite
lin2:  ds   2h        ;2.Zeile
liny:  ds   2h        ;vorletzte Zeile
linz:  ds   2h        ;letzte Zeile
update:ds   2h        ;Cursor-Position
;
org    equ  2e60h     ;LINFED-Buffer
linbuf:ds   50h       ;80 Zeichen
;
;      ab   2EB0h     :Monitor-Stack
stack  equ  2f00h     ;40 Level tief
;
org    equ  stack     ;Assembler-Bereich
assbuf:ds   64h
;
;      ab   2F64h     :Anwender-Stack
usrstk equ  2f70h     ;6 Level tief
;
org    equ  usrstk    ;FDC-Bereich
fdcbuf:ds   1ch
track0 equ  2f75h     ;Spur-Regs.
track2 equ  2f77h
;
org    equ  2f8ch     ;Interrupt-Sprungverteiler
intrap:ds   3h
int3:  ds   3h
int4:  ds   3h
int5:  ds   3h
int55: ds   3h
int6:  ds   3h
int65: ds   3h
int7:  ds   3h
int75: ds   3h
;
;      Hilfszellen f}r den Monitor
;
rega:  ds   1h        ; REG A
regb:  ds   1h        ; REG B
regc:  ds   1h        ; REG C
regd:  ds   1h        ; REG D
rege:  ds   1h        ; REG E
regf:  ds   1h        ; FLAGs
regh:  ds   1h        ; REG H
regl:  ds   1h        ; REG L
regs:  ds   1h        ; Stack-Pointer (HI)
regp:  ds   1h        ; Stack-Pointer (LO)
       ds   1h        ; frei
;
dspbuf:ds   1h        ; LED-Zeile
dig1:  ds   1h        ; Digit 1
dig2:  ds   1h        ; Digit 2
dig3:  ds   1h        ; Digit 3
dig4:  ds   1h        ; Digit 4
dig5:  ds   1h        ; Digit 5
dig6:  ds   1h        ; Digit 6
dig7:  ds   1h        ; Digit 7
;
data:  ds   1h        ; Daten
adres: ds   1h        ; Adresse
adrhi: ds   1h
modflg:ds   1h        ; Mode-FLAG
fctbf: ds   1h        ; FCT-Nr.
srcbeg:ds   2h        ; Par.1
srcend:ds   2h        ; Par.2
dstbeg:ds   2h        ; Par.3
dstend:ds   2h        ; Par.4
regnr: ds   1h        ; REG-Nr.
ioflg: ds   1h        ; I/O-Param.
nxtbuf:ds   1h        ; FCT-Eingaben
maxbuf:ds   1h        ; max. Anz.
keybyt:ds   1h        ; KEY true./.invers
ciflag:ds   1h        ; FLAG f. CI-Routine
hibuf: ds   2h        ; I/O-Hilfsroutine
hbuf:  ds   1h
;
hibuf2:ds   1h        ; CTE-Sprungziel
hbuf2: ds   2h
brkpt1:ds   2h        ; BRK-Adresse #1
opcod1:ds   1h        ; OpCode-Buf. #1
brkpt2:ds   2h        ; BRK-Adresse #2
opcod2:ds   2h        ; OpCode-Buf. #2
;
second:ds   2h        ; Sekundenz{hler
;
uhrbuf equ  2fdch     ; BCD-Uhrzeit-Buffer
;
ascbuf equ  2feah     ; ASCII-Uhrzeit-Buf.
;
end
;

B>