;--------------------------------------------------
;
; Moppel--FDC-Utilities V10.5 (C)hms85 Reinhard Gler
;
; neu aufgebaut aus Listing 10.1-10.5
; W.Rmer 2014/2016
;
; Erweiterung fr CF-Karte lesen/schreiben
; Erweiterung in RD/WR SEC eingefgt
; Parameterbergabe wie FDC-Routinen
;
; 
; Letzte nderung:	FDC-CFV12
;
;	06.05.2016	CF-Karte als LW 0 eingerichtet
;			Batchbuffer auf 512Byte erhht wg. CF-Karte
;
;	15.04.2015	Copy berichtigt (Sprungziel CRLF in Videomonitor)
;			Texte fr Systemmeldung ans Ende gestellt
;			Code optimiert, nun passt alles wieder in 2000h
;	12.04.2015	CF-Routine Readsektor berichtigt
;	10.03.2015	Optimierung Quellcode V1.2 Texte eingekrzt
;	08.03.2015	CF-Teil in 4300h verlagert
;			FDC auf 2000h Platz reicht hier derzeit nicht aus
;	07.03.2015	Init Routine berarbeitet
;			Damit knnen 80 Spuren a 16Sektoren/2 a512Byte (320kByte)
;			auf CF-Karte geschrieben und gelesen werden 
;			
;	05.03.2015
;	03.03.2015 
;	09.02.2014 
;
;--------------------------------------------------
; Parameter:
;	RD/WR		
;		(B)  = SelctByte
;		(C)  = Anzahl Sektoren die bertragen werden
;		(D)  = Spur-Nr. 0..79
;		(E)  = Sektor-Nr. 1 ..16
;		(HL) = Buffer-Anfang
;		
;	Format
;		(B)  = SelectByte
;		(L)  = Anzahl Spuren
;
; Select-Byte:	
;	Bit	7 6 5 4 3 2 1 0
;		: : : : : : : :
;		: : : : : : : 0 = DD
;		: : : : : : : 1 = SD
;		: : : : : 0 0   = Drive 0
;		: : : : : 0 1	= Drive 1
;		: : : : : 1 0   = Drive 2
;		: : : : : 1 1   = Drive 3 = CF-Karte
;		: : : 0 0       = 6ms Step Rate
;		: : : 0 1       = 12ms
;		: : : 1 0       = 20ms
;		: : : 1 1       = 30ms
;		: : 0           = Side 0
;		: : 1           = Side 1
;		: : 
;		n.c.
;
; Status-Reg:
;	Bit	7 6 5 4 3 2 1 0
;		: : : : : : : :
;		: : : : : : 0 0
;		: : : : : 1     = Lost Daten
;		: : : : 1       = CRC-Error
;		: : : 1         = Record not found
;		: : 1           = Record Type/Spin-up
;		: 1             = Write Protect
;		1               = Disk not ready

;
; Startadresse = F000h fuer Test
;
;-----------------------------------------------------------------------------
;
; PIO Ansteuerung
;
PIO_A	equ	0cah		; CAh   Daten Kanal A
PIO_B	equ	0dah		; DAh   Daten Kanal B
PIO_C	equ	0eah		; EAh   Daten Kanal C
PIO_Ctl	equ	0fah		; FAh   Steuerwort
;
PIO_BA	equ	0c1h		; Betriebsart
				; Kanal A bidirektional, Handshake Kanal C
				; Kanal B als Ausgabe
;
; AVR Befehle
;
AVRres	equ	00h		; Spur 0 Sektor 0 ansteuern
SetSpur	equ	10h		; Spurnummer setzen
SetSekt	equ	20h		; Sektornummer setzen
Rdsekt	equ	30h		; Daten vom aktuellen Sektor lesen
Wrsekt	equ	40h		; Daten in den aktuellen Sektor schreiben
AVRstat	equ	0F0h		; Status ermittel
;
;
;-----------------------------------------------------------------------------
;
; Vorspann Parameterbereich
;
; Monitorprogramme  
;  
CI	EQU 0043h			; CI 	Tastaturabfrage wartet auf Taste ASCII(A)    
CO	EQU 0049h			; CO 	Bildschirmausgabe ASCII(C) Ziel (UPDATE)
LOM	EQU 004Fh			; LO 	Drucker ber RS232	          
CSTS	EQU 0052h  			; CSTS	Tastaturstatus Taste Z=0, k.Taste Z=1  	          
FILL	EQU 0085h  			; FILL  Speicher mit Konstante fllen SRCBEG,SRCEND,DSTBEG        
COPYM	EQU 0088h  			; COPY  Speicherbereich verschieben 
onesec	EQU 001bh			; Wartezeit 1Sekunde
dely1	EQU 000bh			;           1ms
;
BELPOR	EQU 52h				; Port fr Summer 
BYTFF	EQU 1Ah				; PORT FF auf Singel-Step-Modul
COMREG	EQU 48h				; Register Adressen
TRKREG	EQU 49h				; WD1770
SECREG	EQU 4Ah
DATREG	EQU 4BH
STATUS	EQU COMREG
CTRL	EQU 40H      
;
MOVID	EQU 1003h  			; Warmstart Videomonitor
BREAK	EQU 100Fh			; Unterbrechung mit CTRL-C
PARIN	EQU 1012h			;
STRING	EQU 1021h			; STRING Textzeiger(HL) bis (00)
ERROR	EQU 1027h			; Error Videomonitor
CLRVID	EQU 102Dh			; CLRVID  
CLRLIN	EQU 1030h			; CLRLIN        
CRSPOS	EQU 1033h			; CRSPOS         
CRSON	EQU 1036h 			; CRSON         
CRSOFF	EQU 1039h			; CRSOFF
BYTOT	EQU 103Fh			; BYTOT  (A) zweistellig darstellen Adresse (HL) 
ADROT	EQU 103ch			; (DE) vierstellig ausgeben
CRLF	EQU 137bh			; gibt CR/LF aus
;
; Exteren Programme
;
FDC	EQU 2000h			; Floppy 
EDIT	EQU 7000h			; Editor
ASS:	EQU 6000h			; Assembler
DISSK	EQU 6C00h			; Disassembler
;
; RAM Belegung
;
STACK	EQU 2F00H			; 
TRAP	EQU 2F8Ch
RST55	EQU 2F98h
RST551	EQU 2F99h
;
HORDSP	EQU 2E50h			; 40/80 Zeichen pro Zeile
BEGIN	EQU 2E54h			; Anfangsadresse letzte Zeile
UPDATE	EQU 2E56h			; aktuelle Cursorposition
;
SRCBEG	EQU 2FBFh			; Startadresse
SRCEND	EQU 2FC1h			; Endadresse
DSTBEG	EQU 2FC3h			; Anfang Zieladresse/Parameter
DSTEND	EQU 2FC5h			; 
LINZ	EQU 2E54h
;
VIDBEG	EQU 3000h			; Bildschirmadresse	oben links
VIDEND	EQU 377Fh			; 			unten rechts
PRTFLG	EQU 37AFh			; 
RAMBEG	EQU 37B0h			; Anfang Parameterbereich Videomonitor

;
; Buffer Adressen
;
BATBUF	EQU 2C00h			; Batchbuffer auf 512Byte erweitert
FDCBUF	EQU 2F70h
CPYBUF	EQU 8000h
;
	ORG FDCBUF

TRKNR:	DS 1h				; Spurnummer
SECNR:  DS 1h				; Sektornummer
SIDNR:	DS 1h				; Seite 0/1
SELBYT: DS 1h				; SelectByte Bit1,2 = Laufwerksnummer
SELOUT: DS 1h
TRACK0: DS 4h
RWBEF:	DS 1h
DATADR:	DS 2h				; Buffer-Adresse r/w Sektoren
INTPRG:	DS 2h
RWSUB:	DS 1h
RWSUB1: DS 2h
HIBUF:	DS 2h
BUFDST: DS 1h
BUFSRC: DS 1h				; IM CF-Betrieb = Anzahl der Sektoren die bertragen werden
CPYEND: DS 1h
;
TIMOUT	EQU 32h				;
FQUARZ	EQU 06h				;
DLY100	EQU 13h				;
SECZAL	EQU 16				;
SECLDD	EQU 1				; 256 Bytes
;INTON	EQU 1Eh				; RST 5.5 freigeben
;INTOF	EQU 1Fh				; RST 5.5 sperren
;
;-----------------------------------------------------------------
;
; Start FDC
;

	ORG 02000h			; EPROM #2

FDCK:	JMP	FKALT			; Kaltstart
WARM:	JMP	MAIN			;
	JMP	WRBLK			; Block schreiben
	JMP	RDBLK			; Block lesen
	JMP	WRSEC			; Sektor schreiben
	JMP	RDSEC			; Sektor lesen
	JMP	COPY			; 32kByte kopieren
	JMP	FORDSK			; Diskette formartieren
;
INTFOR:	OUT	DATREG			;
	RET	

INTWR:	LDAX	D
	OUT	DATREG
	INX	D
	RET	

INTRD:	IN	DATREG
	STAX	D
	INX	D
	RET	

INTPG2:	IN	DATREG
	RET
	
ISR:	POP	PSW
	IN	STATUS
	RET	

INTON:	PUSH	B
	MVI	A,1EH
	MVI	B,02H
	JMP	INTCTE
INTOF:	PUSH	B
	MVI	A,1FH
	MVI	B,00H
INTCTE	SIM	
	NOP	
	MOV	A,B
	OUT	0BBH
	POP	B
	RET
	
WRSEC:	CALL	INIT
	PUSH	H
	LXI	H,INTWR
	SHLD	INTPRG
	POP	H
	LDA	TRKNR
	MOV	D,A
	MVI	A,2AH
	CMP	D
	MVI	A,0A6H
	JNC	START
	MOV	B,A
	LDA	SELBYT
	ANI	01H
	MOV	A,B
	JNZ	START
	ANI	0FDH
	JMP	START

RDSEC:	CALL	INIT
	PUSH	H
	LXI	H,INTRD
	SHLD	INTPRG
	POP	H
	MVI	A,84H
START:	STA	RWBEF
	CALL	CRSOFF
	MOV	A,M
	RLC	
	CNC	RECAL
	MOV	A,M
	ANI	7FH
	OUT	TRKREG
	LDA	TRKNR
	OUT	DATREG
	MVI	B,14H
	CALL	POSIT
	ANI	19H
	JNZ	END0
	IN	TRKREG
	MOV	D,A
	LDA	TRKNR
	CMP	D
	JZ	STACTE
	MVI	M,00H
	MVI	A,10H
	RET
	
STACTE:	XRA	A
	CMP	B
	MOV	A,C
	RZ
	
	IN	TRKREG
	ORI	80H
	MOV	M,A
	MVI	B,03H
WDHG:	PUSH	B
	PUSH	H
	CALL	RDWR
	ANI	5CH
	POP	H
	POP	B
	JZ	ENDE
	DCR	B
	JNZ	WDHG
END0:	MVI	M,00H
ENDE:	IN	STATUS
	ANI	7CH		; FDC Status lesen
	PUSH	PSW
	CALL	INTOF		; Interuppt abschalten
	POP	PSW
	RET	
;


FORMAT:	CALL	DRVSID
	CALL	TRKSTP
FORDSK:	MOV	L,H
	CALL	CRSOFF
	CALL	FORM
	CALL	DRIVOF
	CPI	24H
	JZ	OK
	JMP	TEST
;		
FORM:	CALL	INIT
DD:	LXI	H,INTFOR
	SHLD	INTPRG
	LDA	SELBYT
	ANI	20H
	RLC	
	RLC	
	RLC	
	STA	SIDNR
	MVI	B,04H
	CALL	POSIT
	XRA	A
	CMP	B
	MOV	A,C
	RZ
	
ANF0:	MVI	E,00H
ANF1:	MVI	H,02H
ANF2:	MVI	C,0FEH
	PUSH	H
	CALL	FORMDD
	POP	H
	IN	STATUS
	ANI	7CH
	JZ	ADRP
	DCR	H
	JNZ	ANF2
	JMP	ENDE

ADRP:	IN	TRKREG
	INR	A
	LHLD	DATADR
	CMP	L
	JZ	FOREND
	MVI	B,54H
	PUSH	D
	CALL	POSIT
	POP	D
	XRA	A
	CMP	B
	MOV	A,C
	RZ	
	INR	E
	JMP	ANF1

FOREND:	MVI	B,04H
	CALL	POSIT
	LDA	SELBYT
	RRC	
	ANI	03H
	LXI	H,TRACK0
	MVI	D,00H
	MOV	E,A
	DAD	D
	JMP	END0

FORMDD:	MVI	D,01H
	LHLD	INTPRG
	MVI	B,3CH
	IN	STATUS
	CALL	INTON
	MVI	A,2AH
	CMP	E
	MVI	A,0F6H
	JNC	FORM1
	ANI	0FDH
FORM1:	OUT	COMREG
	EI	

	MVI	A,4EH
ADR6:	HLT	
	DCR	B
	JNZ	ADR6

	XRA	A
	HLT	
	MVI	B,0AH
ADR4:	HLT	
	DCR	B
	JNZ	ADR4
	HLT
	
	MVI	A,0F5H
	HLT	
	HLT	
ADR5:	HLT	
	MVI	A,0FEH
	HLT	
	MOV	A,E
	HLT	
	LDA	SIDNR
	HLT
	
	MOV	A,D
	HLT	
	MVI	A,SECLDD
	HLT	

	MVI	A,0F7H
	HLT
	INR	D
	MVI	A,4EH
	HLT	
	MVI	B,14H
ADR11:	HLT	
	DCR	B
	JNZ	ADR11
	HLT
	
	XRA	A
	HLT	
	MVI	B,0AH
ADR12:	HLT	
	DCR	B
	JNZ	ADR12
	HLT	

	MVI	A,0F5H
	HLT	
	HLT	
ADR13:	HLT	
	MVI	A,0FBH
	HLT	
	MVI	A,0E5H
	HLT	
	MOV	B,C
ADR14:	HLT	
	DCR	B
	JNZ	ADR14
	HLT	

	MVI	A,0F7H
	HLT	
ADRX:	MVI	A,4EH
	HLT	
	MVI	B,34H
ADR16:	HLT	
	DCR	B
	JNZ	ADR16
	HLT
	
	XRA	A
	HLT	
	MVI	B,0AH
ADR17:	HLT	
	DCR	B
	JNZ	ADR17
	HLT	
	MVI	A,0F5H
	HLT	
	HLT	
ADR18:	HLT	
	MVI	A,0FEH
	HLT	
	MOV	A,E
	HLT	
	LDA	SIDNR
	HLT	
	MOV	A,D
	HLT	
	MVI	A,SECLDD
	HLT	
	MVI	A,0F7H
	HLT	
	INR	D
	MVI	A,4EH
	HLT	
	MVI	B,14H
ADR19:	HLT	
	DCR	B
	JNZ	ADR19
	HLT	
	XRA	A
	HLT	
	MVI	B,0AH
ADR20:	HLT	
	DCR	B
	JNZ	ADR20
	HLT	
	MVI	A,0F5H
	HLT	
	HLT	
ADR21:	HLT	
	MVI	A,0FBH
	HLT	
	MVI	A,0E5H
	HLT	
	MOV	B,C
ADR22:	HLT	
	DCR	B
	JNZ	ADR22
	HLT	
	MVI	A,0F7H
	HLT	
	MVI	A,SECZAL
	INR	A
	CMP	D
	JNZ	ADRX

ADRY:	MVI	A,4EH
	EI	
ADRZ:	HLT	
	EI	
	JMP	ADRZ
;
;--------------------------------------------------
;
RECAL:	MVI	B,04H
	CALL	POSIT
	XRA	A
	CMP	B
	JZ	RECAL1
	MVI	M,80H
	IN	STATUS
	RET
	
RECAL1:	MOV	A,C
	RET
	
INIT:	DI	
	SHLD	DATADR
	PUSH	B
	MOV	L,D
	MOV	H,E
	SHLD	TRKNR
	MVI	A,0C3H
	STA	RST55
	LXI	H,ISR
	SHLD	RST551
	XRA	A
	OUT	BYTFF
	MOV	A,B
	STA	SELBYT
	RRC	
	ANI	03H
	PUSH	PSW
	LXI	H,LAUFW0
	MVI	D,00H
	MOV	E,A
	DAD	D
	MOV	C,M
	LXI	H,SELBYT
	MOV	A,M
	ANI	21H
	ORA	C
	INX	H
	MOV	M,A
	INX	H
	POP	PSW
	MVI	D,00H
	MOV	E,A
	DAD	D
	POP	B
	call	cfq		; Test auf Laufwerk 0 CF-Karte
	RET
	
POSIT:	CALL	INTON
	LDA	SELBYT
	RRC	
	RRC	
	RRC	
	ANI	03H
	ORA	B
	OUT	COMREG
POSIT1:	IN	STATUS
	RLC	
	JNC	POSIT1
	LDA	SELOUT
	OUT	CTRL
	EI
	
	MVI	B,TIMOUT
POSLOP	LDA	FQUARZ
	MOV	C,A
POSLP:	LXI	D,0800H
POSL	DCX	D
	MOV	A,E
	ORA	D
	JNZ	POSL
	DCR	C
	JNZ	POSLP
	DCR	B
	JNZ	POSLOP
	MVI	A,0D0H
	OUT	COMREG
	CALL INTOF
	IN	STATUS
	ANI	7CH
	ORI	80H
	MOV	C,A
	RET
	
READC:	MVI	A,01H
	OUT	SECREG
	MVI	D,SECZAL
	MVI	B,00H
	CALL	INTON
	MVI	A,94H
	OUT	COMREG
	EI
	
ADRG:	HLT	
	DCR	B
	JNZ	ADRG
	DCR	D
	JNZ	ADRG
	MVI	B,SECZAL
	INR	B
ADR99:	IN	SECREG
	CMP	B
	JNZ	ADR99
	MVI	A,0D4H
	OUT	COMREG
	EI	
	HLT
	
RDWR:	LHLD	DATADR
	PUSH	H
	POP	D
	LHLD	INTPRG
	LDA	SECNR
	OUT	SECREG
	CALL	INTON
	LDA	RWBEF
	OUT	COMREG
RDWR1:	EI	
	HLT	
	JMP	RDWR1

LAUFW0:	DB	02H
LAUFW1:	DB	04H
LAUFW2:	DB	08H
LAUFW4:	DB	10H
	
FKALT:	call	cfinit		; Test ob CF-Interface vorhanden
	LXI	H,MSG0		; abgeschaltet
	CALL	STRING
MENUE:	LXI	H,MSG1
	CALL	STRING
MAIN	LXI	SP,STACK
	LXI	H,MAIN
	PUSH	H
	LXI	H,ARROW
	CALL	STRING
	CALL	CRSON
	CALL	CI
	MOV	C,A
	CALL	CO
	CPI	1BH
	JZ	FKALT	
	ANI	5FH
	CPI	"A"
	JZ	ASS
	CPI	"B"
	JZ	BATCH
	CPI	"C"
	JZ	COPY
	CPI	"D"
	JZ	DISKIN
	CPI	"E"
	JZ	EDIT
	CPI	"F"
	JZ	FORMAT
	CPI	"M"
	JZ	MOVID
	CPI	"R"
	JZ	READ
	CPI	"W"
	JZ	WRITE
	MVI	A,20H
	CALL	ERROR
	JMP	MAIN

BATCH	CALL	RD0
	CALL	CRSON
BATOT:	LXI	H,NUMB
	CALL	INSUB
	MOV	A,H
	CALL	ASCHEX
	CPI	20H
	CNC	INPERR
	JNC	BATOT
	LXI	D,BATBUF
	RLC	
	RLC	
	RLC	
	MOV	E,A
	MOV	H,L
	MVI	L,00H
	MOV	A,L
	STAX	D
	INX	D
	MOV	A,H
	STAX	D
	INX	D
	XCHG	
	PUSH	H
	CALL	BLOKIN
	SHLD	BUFSRC
	POP	H
	MOV	M,C
	INX	H
	MOV	M,B
	INX	H
	MOV	M,E
	INX	H
	MOV	M,D
	INX	H
	XCHG	
	LHLD	BUFSRC
	XCHG	
	MOV	M,E
	INX	H
	MOV	M,D
;	
; Sektor 1 von Spur 0 schreiben (Batchbetrieb)	
;
WR0:	MVI	B,18H
	LXI	D,0001H
	LXI	H,BATBUF
	CALL	WRSEC
	JMP	TEST
;	
; Sektor 1 von Spur 0 lesen (Batchbetrieb)	
;
RD0:	MVI	B,18H		; SelektByte fr Laufwerk 0
	LXI	D,0001H		; 1 Sektor lesen
	LXI	H,BATBUF	; Zieladresse
	CALL	RDSEC		; Sektor lesen
	JMP	TEST		;

COPY:	MVI	B,00H
	LXI	D,0404H
	LXI	H,MSRCDS
	CALL	INSUB
	CNC	INPERR
	JNC	COPY
	SHLD	BUFDST
	CALL	TRKSTP
	MOV	A,H
	CPI	00H
	JZ	OK
	STA	CPYEND
	LXI	H,0000H

CPYLOP:	CALL	CRLF
	PUSH	H
	MOV	A,H
	CALL	BYTOT
	MOV	A,B
	ANI	0F9H
	MOV	B,A
	LDA	BUFSRC
	CALL	CPYPAR
	PUSH	H
	CALL	RDBLK
	POP	H
	POP	H
	CALL	DRIVOF
	RZ	
	PUSH	H

	MOV	A,B
	ANI	0F9H
	MOV	B,A
	LDA	BUFDST
	CALL	CPYPAR
	PUSH	H
	CALL	RDBLK
	POP	H
	POP	H
	CALL	DRIVOF
	RZ	
	MOV	A,H
	INR	A
	DAA	
	MOV	H,A
	INR	L
	LDA	CPYEND
	DCR	A
	STA	CPYEND
	JNZ	CPYLOP
	CALL	DRIVOF
	RET	

CPYPAR:	RLC	
	ORA	B
	MOV	B,A
	MVI	C,SECZAL
	MOV	D,L
	MVI	E,01H
	LXI	H,CPYBUF
	RET	

DISKIN:	LXI	H,BNUM		; Meldetext
	CALL	INSUB		; Eingabe Batch-Nr. 0-31
	MOV	A,H
	CALL	ASCHEX		; 
	CPI	20H		; Daten gueltig ? 0-31
	CNC	INPERR
	JNC	DISKIN		; nein Fehler und zurueck
	RLC	
	RLC	
	RLC	
	LXI	H,BATBUF	; Buffer einstellen
	MOV	L,A
	PUSH	H
	CALL	RD0		; Spur 0, Sektor 1 lesen (Batchvorspann)
	POP	H		; Parameter uebernehmen
	MOV	E,M
	INX	H
	MOV	D,M
	INX	H
	PUSH	D
	MOV	C,M
	INX	H
	MOV	B,M
	INX	H
	MOV	E,M
	INX	H
	MOV	D,M
	INX	H
	MOV	A,M
	INX	H
	MOV	H,M
	MOV	L,A
	CALL	RDBLK		; Daten einlesen
	POP	H
	CALL	CRSON		;
	CALL	DRIVOF		;
	PCHL			; Sprung zum Zielprogramm
;
; Bloecke lesen/schreiben
;
READ:	CALL	BLOKIN
RDBLK:	PUSH	H
	LXI	H,RDSEC		; RWSUB auf lesen stellen
	JMP	RDWRSB

WRITE:	CALL	BLOKIN
WRBLK:	PUSH	H
	LXI	H,WRSEC		; RWSUB auf schreiben stellen

RDWRSB:	SHLD	RWSUB1		; Call RD/WR Sektor vorbereiten
	POP	H
	MVI	A,0C3H		; JMP in RWSUB ablegen
	STA	RWSUB

RWLOP:	PUSH	H
	PUSH	D
	PUSH	B
	CALL	RWSUB		; RD/WR Sektor
	POP	B
	POP	D
	POP	H
	ORA	A		; Fehler-Code auswerten
	JNZ	TEST
	DCR	C
	JZ	TEST		; Fertig ?
	INR	H		; Nchste Bufferadresse
	INR	E		; nchster Sektor
	MVI	A,SECZAL	; Sektoranzahl (16) holen
	CMP	E
	JNC	RWLOP		; alle (16)Sektoren gelesen/geschrieben
	MVI	E,01H
	INR	D		; nchste Spur
	JMP	RWLOP

BLOKIN:	CALL	DRVSID		; Parameter Drive,Side holen
PAR2:	LXI	H,MSTRAK
	MVI	E,SECZAL
	INR	E
	CALL	PARIN2
	LDA	HIBUF
	CPI	00H
	CZ	INPERR
	JZ	PAR2

PAR3:	LXI	H,MSTART	; Parameter Start-/Endadresse holen
	CALL	INSUB
	MOV	A,L
	SUB	H
	CC	INPERR
	JC	PAR3
	INR	A
	MOV	C,A
	MVI	L,00H
	PUSH	H
	LHLD	HIBUF
	XCHG	
	POP	H
	RET	

PARIN2:	MVI	D,51H		; Parameter Track/Sector holen
	PUSH	B
	PUSH	D
	PUSH	H
	CALL	INSBHX
	SHLD	HIBUF
	POP	H
	POP	D
	POP	B
	CNC	INPERR
	JNC	PARIN2
	RET
	
DRVSID:	MVI	B,00H
	LXI	D,0402H
	LXI	H,MSDRIV
	CALL	INSUB
	CNC	INPERR
	JNC	DRVSID
	MOV	A,L
	RRC	
	RRC	
	RRC	
	ORI	18H
	ORA	B
	MOV	B,A
	MOV	A,H
	RLC	
	ORA	B
	MOV	B,A
	RET
	
TRKSTP:	LXI	H,MSGTRK
	MVI	E,04H
	CALL	PARIN2
	LHLD	HIBUF
	MOV	A,B
	ANI	0E7H
	MOV	B,A
	MOV	A,L
	RLC	
	RLC	
	RLC	
	ORA	B
	MOV	B,A
	RET
	
INSUB:	PUSH	B
	PUSH	D
	CALL	STRING
	LHLD	LINZ
	LXI	D,000EH
	DAD	D
	CALL	CRSPOS
INLOP:	CALL	CI
	MOV	C,A
	CALL	CO
	CPI	1BH
	JZ	MAIN
	CPI	0DH
	JNZ	INLOP
	LHLD	LINZ
	LXI	D,0013H
	DAD	D
	MVI	C,06H
	CALL	PARIN
	LDA	SRCBEG
	MOV	H,A
	LDA	SRCEND
	MOV	L,A
	POP	D
	POP	B
INCTE:	CMP	E
	RNC	
	MOV	A,H
	CMP	D
	RET	

INSBHX:	CALL	INSUB
	MOV	A,H
	CALL	ASCHEX
	MOV	H,A
	MOV	A,L
	CALL	ASCHEX
	MOV	L,A
	JMP	INCTE

ASCHEX	PUSH	D
	MOV	D,A
	ANI	0FH
	MOV	E,A
	CPI	0AH
	MOV	A,D
	ANI	0F0H
	RRC	
	RRC	
	RRC	
	RRC	
	CPI	0AH
	MOV	D,A
	ORA	A
	JZ	ASCEND
	XRA	A
ASCLOP:	ADI	0AH
	DCR	D
	JNZ	ASCLOP
ASCEND:	ADD	E
	POP	D
	RET
	
INPERR:	PUSH	PSW
	PUSH	H
	PUSH	D
	PUSH	B
	MVI	A,21H
	CALL	ERROR
	POP	B
	POP	D
	POP	H
	POP	PSW
	RET	
; 
; Test ob Floppy rd/wr abgearbeitet wurde
TEST:	ANI	0FCH
		JZ	OK		; kein Fehler
		CALL	DRIVOF
		MVI	C,08H
TELOP:	DCR	C
		RLC	
		JNC	TELOP
		MOV	A,C
		MOV	A,C
		ADI	20H
		JMP	ERROR

OK:		LXI	H,OKMSG		; alles OK
		CALL	STRING
		CALL	DRIVOF
		XRA	A
		INR	A
		RET
	
DRIVOF:	PUSH	PSW
		POP	PSW
		RET	
;
;===========================================================
;
; CF-karte lesen/schreiben
;  Laufwerk 0 = CF_Karte
;
; Parameterbergabe:
;
; TRKNR	 = Spur
; SECNR  = Sektor
; DATADR = Buffer Zieladresse
; BUFSCR = Anzahl der zu bertragenden Sektoren
;          auf 512Byte/Sektor angepasst
;
;===========================================================
; cfq = Test ob Laufwerk = 0 (geaendert 05.05.2016)
;	wenn nein weiter mit Floppy
;       und Test auf rd/wr Sektor aus RWSUB
;
cfq:	push	psw
	lda	selbyt		; 
	cpi	18h		; Test ob Laufwerk 0
	jnz	cfq_e		; nein weiter mit Floppy
	lda	rwsub1		; RWSUB1 testen
	cpi	40h		; 
	jz	cfwrbl		; ja CF-Karte schreiben
	cpi	66h		;
	jz	cfrdbl		; ja CF-Karte lesen
cfq_e	pop	psw
	ret

;
cfrdbl:	PUSH	H		; Code Vorbereitung
	LXI	H,rdsek		; RD Sektor
	JMP	cfrw

cfwrbl:	PUSH	H		; 
	LXI	H,wrsek		; WR Sektor

cfrw:	SHLD	RWSUB1		; CF rd/wr in RWSUB
	pop	h
	mov	a,c
	sta	bufsrc
	pop	psw		; 
;	
	call	settr		;
	call	setsek		;
cfrwl:  lda	bufsrc		;
	cpi	0		;
	jz	cfrwe		; Fertig	
	dcr	a		;
	sta 	bufsrc		;

	call	rwsub		; Sektor lesen/schreiben
	call	avr_stat	; alles OK
	call	updsek		; Update Spur/Sektor
	jmp	cfrwl		; nchster Sektor		
	;
cfrwe:	lxi	h,okmsg		; Endemeldung
	call	string		;
	jmp	warm		;
;
; updsek/sp = Sektor und Spurnummern aktualisieren
;             und an CF-Karte senden
;	      Fehler wenn Spur 80 erreicht ist
;
updsek: lda	secnr		; Sektor holen
	cpi	10h		; letzter Sektor spur
	jz	updsp		;
	inr	a		; nchster Sektor gleiche Spur
	sta	secnr		;
	call	setsek		; Sektor fr CF setzen
	ret
	
updsp:	mvi	a,01h		; nchste Spur mit Sektor 1
	sta	secnr		; 
	lda	trknr		;
	cpi	50h		; Spur 79 erreicht
	jz	upderr		; Fehler
	inr	a		;
	sta	trknr		;
	call	settr		; Spur/Sektor fr CF setzen
	call	setsek		;
	ret
	
upderr: mvi	a,20h		; Fehlermeldung
	call	error
	jmp	fdck
	;
;-----------------------------------------------------------------------------
;
; PIO Initialisieren mit Betriebsart
; Kanal A bidirektional
; Kanal C Handshake
; Kanal B Ausgabe
;
pioinit:	push	psw		; PIO Betriebsart einstellen
		mvi	a,PIO_BA	; PIO_BA	equ	0c1h
		out	PIO_Ctl		; 
		pop	psw		;
		ret			;
;
;---------------------------------------------------------------------------
;
; PIO-A lesen (A)
; wartet bis Daten bereitstehen 

piord:		in	PIO_C		; Status ermitteln
		ani	00100000b	; IBF maskieren
		jz	piord		; warte auf Daten
		in	PIO_A		; daten lesen
		ret			; (A) Daten
;
; (A) PIO-A schreiben
; 

piowr:		push	psw		;
pio_sts:	in	PIO_C		; Status ermitteln
		ani	10000000b	; /OBF maskieren
		jz	pio_sts		; warten auf Quittung /ACK
		pop	psw
		out	PIO_A		; Daten schreiben
		ret			; 
;
;-------------------------------------------------------------------------
;
; cfinit = Reset Befehl an CF-Karte
;          
;
cfinit:		call	pioinit		; PIO und AVR initialisieren
		mvi	a,avrres	; Test ob CF-Erweiterung vorhanden ist;
		call	piowr		;
		xra	a		;
		call	piord		;
		cpi	00h		; 	
		jnz	cferr		; CF nicht bereit -> Fehler
		ret			; CF-Interface OK
;
; avr_stat = Status CF-Karte ermitteln 0=OK
;            sonst Fehlermeldung
;
avr_stat:	mvi	a,avrstat	; Status AVR ermitteln
		call	piowr		; 
		call	piord		;
		cpi	00h		;
		jnz	cferr1		; Driver Error
		ret			;

;
cferr:		lxi	h,errmsg1	; Fehlermeldung 
		call	string		; CF nicht bereit
		mvi	a,01		;
		ret
		
cferr1:		lxi	h,errmsg	; Lese/schreibfehler
		mvi	a,27h		;
		call	error
		jmp	fdck
		
		
;---------------------------------------------------------------------
;
; Spur/Sektor setzen
;
settr:		mvi	a,setspur	; Befehl Spur setzen
		call	piowr		;
		lda	trknr		; Spur laden
		call	piowr		;
		ret			;
		
setsek:		mvi	a,setsekt	; Befehl Sektor setzen
		call	piowr		;
		lda	secnr		; Sektor laden
		call	piowr		;
		ret			;
;
; Sektoren lesen/schreiben (512Byte)
;
wrsek:		mvi	a,wrsekt	; Befehl schreiben
		call	piowr		;
		lhld	datadr		; 
		lxi	b,200h		; 512 byte
wrsek_l:	mov	a,m		;
		call	piowr		;
		inx	h		;
		dcr	c		;				;
		jnz	wrsek_l		;
		dcr	b		;
		jnz	wrsek_l		;
		shld	datadr		; Buffer sichern
		ret			;		
	
		
rdsek:		mvi	a,rdsekt	; Befehl lesen
		call	piowr		;
		lhld	datadr	; 
		lxi	b,200h		; 512 byte
rdsek_l:	call	piord		;
		mov	m,a		;
		inx	h		;		
		dcr	c		;
		jnz	rdsek_l		;
		dcr	b		;
		jnz	rdsek_l		;
		shld	datadr		; Bufferadresse sichern
		ret			;		
;
;------------------------------------------------------------------------------
; Texte zu CF-Karte
;
errmsg1: DB 0Dh			;
	DB 0Ah 			;
	DB ' CF-Karte'
	db ' nicht bereit'
	DB 00h			;

;------------------------------------------------------------------------------
; Texte
;
MSG0:	DB 0Dh			; CR
	DB 0Ah			; LF               
	
	DB "MOPPEL-FDC"
	DB " V10.5.122"
	DB 0Dh			; 
;
	DB "(C) "
	DB 0EH 			; hms als Sonderzeichen
	DB 0Fh
	DB 10h
	DB "'85/2016"
	DB 00h			; Ende MSG0

MSG1:	DB 0Dh			;
	DB 0Ah			;

	DB " B: Batch out"
	DB 0Dh			;
;
	DB " C: Copy"
	DB 0Dh			;
;
	DB " D: Disk in"
	DB 0Dh			;
;
	DB " F: Form."
	DB 0Dh			;
;
	DB " R: rd"
	DB 0Dh
;
	DB " W: wr"
	DB 0Dh
	DB 00h                  ; Ende MSG1 Hilfe Meldungen geloescht
;
ARROW:	DB 0Dh			;
	DB 0Dh 			;
	DB "F>"			; ">"
	DB 00h              	; Ende Arrow
;	
;
MSDRIV:	DB 0Dh			;
	DB "Drive"
	DB 2Ch			; ","
	DB "Side   >"
	DB "0"
	DB 2Ch			; ","
	DB "0"
	DB 00h			;

MSTRAK:	DB 0Dh			;
	DB 'Track'
	DB 2Ch
	DB 'Sector'
	DB ' >01'
	DB 2Ch
	DB '1' 
	DB 00h			;
;
MSRCDS:	DB 0Dh
	DB "Source"
	DB 2Ch
	DB "Dest"
	DB 2Eh
	DB " >0"
	DB 2Ch
	DB "1"
	DB 00h			;
; 
MSTART:	DB 0Dh			;
	DB "Start"
	DB 2Ch
	DB "End Pg"
	DB 2Eh
	DB ">90"
	DB 2Ch
	DB '9F'
	DB 00h			;
;
MSGTRK: DB 0Dh			;
	DB "Tracks"
	DB 2Ch
	DB "Step  >40"
	DB 2Ch
	DB "1"
	DB 00h			;
;
NUMB:	DB 0Dh			;
	DB "Number"
	DB 2Ch
	DB "Start >0"
	DB 2Ch
	DB "28"
	DB 00h			;
;
BNUM:	DB 0Dh			;
	DB "Batch Number >0"
	DB 00h			;
;
OKMSG:	DB 0Dh			;
	DB ' o.k.'
	DB 00h			;
;
ERRMSG:	DB 0Dh			;
	DB 0Ah 			;
	DB ' Error # F0'
	DB 00h			;	
;

END

