;---------------------------------------------------
;                                                   
; MOPPEL-BIOS fr CP/M Rel. 2.2  V 12.5    30.10.85
; (C) Rheinhard Gssler 85			
; 
; neu aufgebaut W.Rmer 01.2014
;
; Stand:
;	27.07.2016	Test der Moppel 87er V24 abgeschlossen	#V43
;	16.07.2016	BIOS-Sprungleiste fuer V24 erweitert	#V42-2
;	13.07.2016	V24 Treiber fuer Moppel 87er Hardware 	#V42-1
;	30.06.2016	IO-Treiber umgebaut
;	24.06.2016	Fehler IO-Verwaltung berichtigt
;	04.06.2016	BIOS-Funktion eingerichtet
;	02:06:2016	Treiber verbessert
;	18.05.2016	RDR: und PUN: ueber schnelle V24 CF-Karte
;	16.05.2016	LST: ueber schnelle V24 CF-Karte
;	12.05.2016	CF-Karte als Bootlaufwerk
;	10.04.2015	DPB fr CF-Karte eingerichtet
;	08.04.2015	Testroutinen entfernt
;	07.04.2015	Fehlerbeseitigung CF-Routinen
;	03.04.2015	Testprogramm kopiert Buffer nach Bank #0
;	31.03.2014	CF-Routinen berarbeitet Statusabfrage ergnzt
;	24.03.2015	mit Testprogramm fr TPA analyse
;	22.03.2015	Fehlerbeseitung
;	20.03.2015	Fehlerbeseitung CF-Interface
;			CF-Karte luft noch mit DPB von Floppy
;			
;	15.03.2015	DPB erweitert
;			CF-Interface eingebunden
;                                                   
;---------------------------------------------------;
;
;      60-K-Version
;
;
BIOS    equ	0EA00h  ; bei 60 K 
CCP     equ	0D400h  ; bei 60 K
BDOS    equ	0DC06h  ; bei 60 K
;
begin   equ	0002h   ; bei 60 K
;
stack2  equ	0FAFFh  ; bei 60 K
;
verbuf  equ	0FB00h  ; bei 60 K
;
buffer  equ	0FC00h  ; bei 60 K
;
; Moppel V24 IO-Zuordnung
;
UART_C	EQU  0E9h	; UART 6850 Control/Statusregister
UART_D	EQU  0F9H	;           Daten lesen/schreiben
;
CS_MODE	EQU  0A9H	; Modus (Eingangswahlschalter)
CS_BELL	EQU  0B9H	; Bell  (Schnarre)
;
TIMER_C EQU  0D9H	; Timer 8253 Controlregister
TIMER_0	EQU  89H	;            Zaehler 0
TIMER_1	EQU  99h	;	     Zaehler 1	* nicht benutzt
TIMER_2	EQU  0C9h	;	     Zaehler 2	* nicht benutzt
;
; Moppel Monitor Routinen
;
cimo	equ     43h	; Console Input
como    equ     49h     ; Console Output
cstsmo  equ     52h     ; Console Status
lomo    equ     4fh     ; Lister Output
curson	equ	1036h	; Curson
;
ioflag	equ	2fc8h	; LO Select
;
stack0	equ	2950h	; Bank 0 Stack
;
;
nsects	equ     2ch     ; Anzahl Sector fr CPML
offset  equ	04h     ; Start bei Track 4
vers    equ	22h     ; Versions-Nr.
;
buff    equ	0080h	; default Buffer Adress
stack   equ	0100h   ; default STACK
ndisks  equ    	04h	;
iobyte  equ	0003h	;
cdisk   equ     0004h   ; Adr 4 fr last Drive
;
;
	org	bios
;
       	jmp	boot		; Einsprungleiste
wboote:	jmp	wboot		;
;
; IO-Geraete
;
       	jmp	csts		; Status Console
       	jmp	ci		; Input  Console
       	jmp	co		; Output Console
       	jmp	list		; Output Lineprinter
       	jmp	punch		; Output Puncher
       	jmp	reader		; Input  Reader
;
; Floppy
;
       	jmp	home		;
       	jmp	seldsk		; Select Disk
       	jmp	settrk		; Set    Track
       	jmp	setsec		; Set    Sector
       	jmp	setdma		; Set    Disk-Buffer
       	jmp	read		; Read   Disk *	
       	jmp	write		; Write  Disk *
       	jmp	lsts		; Status Lineprinter
       	jmp	sectra		; nicht benutzt
;
; BIOS Erweiterung V24
;
; V24 Moppel 87er Hardware	WBOOT + 30h
;
	jmp	mv24bd		; (DE) Baudrate einstellen
	jmp	mv24ist		; Status (A)=00h kein Zeichen, FFh Zeichen
	jmp	mv24rx		; (A) Byte empfangen, wartet auf Zeichen
	jmp	mv24rxz		; (A) Byte empfangen, abbruch nach 10s mit Control-Z (1ah)
	jmp	mv24tx		; (C) Byte senden
	jmp	mv24txz		; (C) Byte senden, abbruch wenn Geraet nicht bereit
;
; V24 auf CF-Karte 
;
	jmp	cv24ist		; Status (A)=00h kein Zeichen, FFh Zeichen
	jmp	cv24rxb		; (A) Byte empfangen
	jmp	cv24txb		; (C) Byte senden
	
; * mit Erweiterungen fuer CF-Interface
;
;====================================================
;
;      DPBase
;
;====================================================
;
dpbase equ  dpe0
;
dpe0:  dw   xlt0      ; Translate table
       dw   0000h
       dw   0000h     ; Sratch area
       dw   0000h
       dw   dirbuf    ; Dir. Buffer
       dw   dpb3      ; Parameter Block
       dw   csv3      ; Check
       dw   alv3      ; Allocation Vectors
;
dpe1:  dw   xlt1
       dw   0000h
       dw   0000h
       dw   0000h
       dw   dirbuf
       dw   dpb1
       dw   csv1
       dw   alv1
;
dpe2:  dw   xlt2
       dw   0000h
       dw   0000h
       dw   0000h
       dw   dirbuf
       dw   dpb2
       dw   csv2
       dw   alv2
;
dpe3:  dw   xlt3
       dw   0000h
       dw   0000h
       dw   0000h
       dw   dirbuf
       dw   dpb3
       dw   csv3
       dw   alv3
;
;
;====================================================
;
;      Disk Parameter Block
;
;====================================================
;
; dpb0 fr 80 	Spur Laufwerke
;		Blockgroesse 2k	
;
dpb0:  dw   20h  ; Sectors per Track
       db   04h   ; Block shift
       db   0Fh   ; Block Mask
       db   0h   ; Extnt Mask
       dw   97h  ; Disk Size-1
       dw   3fh  ; Directory max.
       db   0c0h ; Alloc0
       db   00h  ; Alloc1
       dw   10h  ; Check Size
       dw   4h   ; Offset
;
xlt0   equ	0h   ;Sec.Translate Vec.;no Transl.Table
;
; 
;
dpb1:  dw   20h  ; Sectors per Track
       db   04h  ; Block shift
       db   0Fh  ; Block Mask
       db   0h   ; Extnt Mask
       dw   97h  ; Disk Size-1
       dw   3fh  ; Directory max.
       db   0c0h ; Alloc0
       db   00h  ; Alloc1
       dw   10h  ; Check Size
       dw   4h   ; Offset
;
xlt1   equ	xlt0
;
; dpb2 wie dpb0
;
dpb2:  dw   20h  ; Sectors per Track
       db   04h  ; Block shift
       db   0fh  ; Block Mask
       db   0h   ; Extnt Mask
       dw   97h  ; Disk Size-1
       dw   3fh  ; Directory max.
       db   0c0h ; Alloc0
       db   00h  ; Alloc1
       dw   10h  ; Check Size
       dw   4h   ; Offset
;
xlt2   equ	xlt0
;
; CF-Karte 
;
; 8MB File auf CF-Karte
; Offset fr Sektoren sind im AVR-Teil einzurichten
; 
; 32 Records a 128Byte
; 4kBlcke
; 512 Dir Eintrge
;     ohne Check (CF-Karte als "Festplatte")
; 4 Systemspuren
;
; Wichtig alv3 anpassen
; Parameter stehen im hinteren Bereich
; ab Soft-System
; alv3 = DSM+1 / 8
; 
dpb3:  dw   32  	; Sectors per Track
       db   5  		; Block shift
       db   31  	; Block Mask
       db   1   	; Extnt Mask
       dw   2047  	; DSM Disk Size-1 = 8MB
       dw   511  	; Directory max.
       db   11110000b 	; Alloc0
       db   0	  	; Alloc1
       dw   0	  	; Check Size
       dw   4	   	; Offset
;
xlt3:  equ	xlt0	; keine Sektorbersetzung
;
;
;====================================================
;
;      Peripherie-Verwaltung
;
;	mv24..	= V24 auf Moppel 87er Hardware 	9600Bd
;       cv24..  = schnelle V24 auf CF-Karte	115000Bd
;
;====================================================
;
co:    	lda  iobyte	; CP/M : Console Output
       	ani  03h
       	lxi  h,cotab	; Startadr CO-Tab
       	jmp  decode
cotab: 	dw   co-mon     ; TTY
       	dw   mv24tx     ; CRT	; Moppel
       	dw   cv24txb	; BAT	; Moppel
       	dw   cv24txb    ; UC1	; CF-Karte
;
ci:    	lda  iobyte	; CP/M : Console Input
       	ani  03h
       	lxi  h,citab	; Startadr CI-Tab
       	jmp  decode
citab: 	dw   ci-mon	; TTY
       	dw   mv24rx	; CRT	; Moppel
       	dw   cv24rxb	; BAT	; Moppel
       	dw   cv24rxb	; UC1	; CF
;
reader:	lda  iobyte    ; CP/M : Reader Input
       rrc
       rrc
       ani  03h
       lxi  h,ritab	; Startadr Reader-Tab
       jmp  decode
ritab: dw   ci-mon	; TTY
       dw   mv24rx	; PTR;	Moppel
       dw   mv24rxz	; UR1;  Moppel 10s Abbruch
       dw   cv24rxb	; UR2;  CF-Karte
;
punch: lda  iobyte	; CP/M : Puncher Output
       rrc
       rrc
       rrc
       rrc
       ani  03h
       lxi  h,potab	; Startadr Puncher-Tab
       jmp  decode
potab: dw   co-mon	; TTY
       dw   mv24tx	; PTP	; Moppel
       dw   mv24txz	; UP1	; Moppel m Zeitueberwachung
       dw   cv24txb	; UP2	; CF-Karte
;
list:  lda  iobyte	; CP/M : List Output
       rlc
       rlc
       ani  03h
       lxi  h,lotab	; Startadr List-Tab
       jmp  decode
lotab: dw   co-mon	; TTY
       dw   prt		; CRT
       dw   mv24tx	; LPT	; Moppel
       dw   cv24txb	; UL1
;
csts:  	lda  iobyte	; CP/M : Console Status
       	ani  03h
       	lxi  h,csttab
       	jmp  decode
csttab:	dw   cs-mon	; TTY
       	dw   mv24ist	; CRT	; Moppel
       	dw   cv24ist	; BAT
       	dw   cv24ist	; UC1	; CF-Karte
;
lsts:  	lda  iobyte	; CP/M : Lister Status
       	rlc
       	rlc
       	ani  03h
       	lxi  h,lsttab
       	jmp  decode
lsttab:	dw   mcosta	; TTY
       	dw   crtost	; CRT
       	dw   prtst	; LPT
       	dw   cv24ost    ; UC1	; CF-Karte
;
pustat:	lda  iobyte
       	rrc
       	rrc
       	rrc
       	rrc
       	ani  03h
       	lxi  h,pustab
       	jmp  decode
pustab:	dw   mcosta	; TTY
       	dw   rest	; PTP; Res.
       	dw   censta	; UP1
       	dw   cv24ost	; UP2	; CF-Karte
;
; IO-Tabelle auswerten
;
decode:	jz   found     ; Setzt PC entsprechend IOBYTE
       	inx  h
       	inx  h
       	dcr  a
       	jmp  decode
found: 	mov  e,m       ;Zieladresse auslesen 
       	inx  h
       	mov  d,m
       	xchg
       	pchl           ;Verzweigung
;
;
;====================================================
;
;      Ausgabe ueber die serielle Schnittstelle
;
;====================================================
;
prt:   push h
       lxi  h,0h
       dad  sp        ;Bank 1 Stack in H&L
       lxi  d,stack0
       xchg
       sphl           ;Bank 0 Stack
       mvi  a,81h
       out  24h       ;Umschalten auf Bank 0
;
       push d         ;Bank 1 Stack retten
       mvi  a,80h     ;Printer waehlen
       sta  ioflag
       call lomo      ;Monitor-UP
       mvi  a,0h      ;Printer inaktiv
       sta  ioflag    ;(wg.CO; sonst doppeltes LO) 
       pop  h         ;Bank 1 Stack zurueck 
       mvi  a,1h
       out  24h       ;Umschalten auf Bank 1
;
       sphl           ;alter Bank 1 Stack
       pop  h
       ret
;
prtst: mvi  a,0ffh
       ret
;
;
;====================================================
;
;      Ausgabe ueber die parallele Schnittstelle
;
;====================================================
;
centr: push h
       lxi  h,0h
       dad  sp        ;Bank 1 Stack in H&L
       lxi  d,stack0
       xchg
       sphl           ;Bank 0 Stack
       mvi  a,81h
       out  24h       ;Umschalten auf Bank 0
;
       push d         ;Bank 1 Stack retten
       mvi  a,40h     ;Centronics waehlen
       sta  ioflag
       call lomo      ;Monitor-UP
       mvi  a,0h      ;Centronics inaktiv
       sta  ioflag    ;(wg.CO; sonst doppeltes LO)
       pop  h         ;Bank 1 Stack zurueck
       mvi  a,1h
       out  24h       ;Umschalten auf Bank 1
;
       sphl           ;alter Bank 1 Stack
       pop  h
       ret
;
censta:	mvi  a,0ffh
       	ret
;
;
;====================================================
;
;      Monitor-Routinen CO, CI und CSTS
;
;====================================================
;
;
;      Ausgabe auf Bildschirm
;
co-mon:	push h
       lxi  h,0h
       dad  sp        ;Bank 1 Stack in H&L
       lxi  d,stack0
       xchg
       sphl           ;Bank 0 Stack
       mvi  a,81h
       out  24h       ;Umschalten auf Bank 0
;
       push d         ;Bank 1 Stack retten
       call como      ;Monitor-UP
       pop  h         ;Bank 1 Stack zurueck
       mvi  a,01h
       out  24h       ;Umschalten auf Bank 1
;
       sphl           ;alter Bank 1 Stack
       pop  h
       ret
;
mcosta:	mvi  a,0ffh    ; Status CO-MON
       ret
;
;
;      Eingabe von der ASCII-Tastatur
;
ci-mon:	push h
       lxi  h,0h
       dad  sp        ;Bank 1 Stack in H&L
       lxi  d,stack0
       xchg
       sphl           ;Bank 0 Stack
       mvi  a,81h
       out  24h       ;Umschalten auf Bank 0
;
       push d         ;Bank 1 Stack retten
       call cimo      ;Monitor-UP
       push psw       ;wg. MOVID-5.3-CSTS
cilop: call cstsmo    ;Monitor-UP
       jnz  cilop     ;auf Loslassen warten
       pop  psw
       mov  c,a       ;temp. ablegen
       pop  h         ;Bank 1 Stack zurueck
       mvi  a,1h
       out  24h       ;Umschalten auf Bank 1
;
       sphl           ;alter Bank 1 Stack
       pop  h
       mov  a,c       ;Input zurueckholen
       rlc            ;CTL-Codes MOVID 5.3?
       jc   ctlkey    ;ja: JMP
       mov  a,c
       ret
;
ctlkey:	mov  a,c       ;fehlende CTL-Codes erzeugen
       cpi  8fh       ;HOME?
       jz   mark      ;ja: JMP
       ani  7fh
       sui  20h
       ret
;
mark:  mvi  a,27h     ;Hochkomma
       ret
;
;
;      Status der ASCII-Tastatur
;
cs-mon:	push h
       lxi  h,0h
       dad  sp        ;Bank 1 Stack in H&L
       lxi  d,stack0
       xchg
       sphl           ;Bank 0 Stack
       mvi  a,81h
       out  24h       ;Umschalten auf Bank 0
;
       push d         ;Bank 1 Stack retten
       call cstsmo    ;Monitor-UP
       pop  h         ;Bank 1 Stack zurueck
       mov  c,a       ;Status retten
       mvi  a,1h
       out  24h       ;Umschalten auf Bank 1
;
       sphl           ;alter Bank 1 Stack
       pop  h
       mov  a,c       ;Status zurueckholen
       ret
;
;
;====================================================
;
;      Peripherie-Ansprache (Reserve)
;
;====================================================
;
crtout:	ret
;
crtost:	xra  a
       	ret
;
;
crtin:	ret
;
crtist:	xra  a
       	ret
;
;
;
;
thermo:	ret
;
therst:	xra  a
       	ret
;
resout:	ret
;
rest:  	xra  a
       	ret
;
;
;====================================================
;
;      Disketten-Management
;
;====================================================
;
; BIOS-Funktion Home
;		Set Track (C)=Track
home:  	mvi  c,00h          ; Track 0
settrk:	lxi  h,iotrk        ; Trackbuffer laden
       	mov  m,c
       	ret
;
; BIOS-Funktion Set Sektor (C)=Sektor
;
setsec:	lxi  h,iosec        ; Sectorbuffer laden
       	mov  m,c
       	ret
;
; BIOS-Funktion Set DMA	(BC)=DMA Adresse
;
setdma:	mov  l,c            ; DMA - Adresse laden
       	mov  h,b
       	shld iodma
       	ret
;
; BIOS-Funktion Set Drive (C)=Laufwerk
;			  (HL)= DPH
;
seldsk:	lxi  h,0000h   ; Bei Fehler notwendig
       	mov  a,c
       	cpi  ndisks    ; LW im Bereich ?
       	rnc
;
       	sta  dbank     ; LW in Buffer
       	add  a         ; ;2
       	add  a         ; ;4
       	add  a         ; ;8
       	add  a         ; ;16 (Laenge eines DPBs)
       	mov  l,a
       	lxi  d,dpbase
       	dad  d
       	ret
;
; BIOS-Funktion Sec Translate
; !im Moppel nicht bentigt
;
sectra:	mov  a,d
       	ora  e
       	jz   se1       ; Test ob Xlate-Tab vorhanden
;
       	xchg
       	dad  b
       	mov  a,m
       	sta  iosec
       	mov  l,a
       	mvi  h,00h
       	ret
;
se1:   	mov  l,c
       	mov  a,c
       	sta  iosec
       	mvi  h,0h
       	ret
;
;------------------------------------------------------------
;
; calc - CP/M Sektorgre auf Moppel Sektorgre umrechnen
;	 CP/M-Format 	32 Sektoren/Track
;	 Moppel-Format 	16 Sektoren/Track
;	 (E)= Startsektor fr R/W Disk
;
calc:  lda  iosec
       rrc
       ani  0ch
       inr  a
       mov  e,a
       lda  dbank
       mov  c,a
       lda  iotrk
       mov  d,a
       ret
;
; comp - Test ob Drive/Track/Sektor noch gleich ist
;
comp:  lda  aktdrv
       cmp  c
       rnz
       lda  akttrk
       cmp  d
       rnz
       lda  aktsec
       cmp  e
       ret
;
; BIOS-Funktion Sektor lesen
;
read:  	di		;
	call calc	; <== Einsprung von BDOS
	call comp
	jnz  rload	; 
;
r1rd:  call bufcal	; Daten im Buffer, nur kopieren
       call copyx
       xra  a
       ret
;
; bufcal - Record auf 1kByte-Buffer abbilden
;
bufcal:	lxi  h,buffer
       	lda  iosec
       	ani  07h
       	rrc
       	mov  d,a
       	mvi  a,00h
       	rar
       	mov  e,a
       	mov  a,d
       	ani  7fh
       	mov  d,a
       	dad  d
       	xchg
       	lhld iodma
       	xchg
       	mvi  b,80h     ; Recordlaenge = 128 Bytes
       	ret
;
;
; rload - Test ob Buffer gltig ist (wrtflg)=1
;         wenn nein, alten Buffer zurckschreiben
;
rload: 	lda  	wrtflg	
       	ora  	a
       	jz   	r1load
       	call 	puttrk		; alten Buffer sichern
 	jc   	errio
;
; Buffer von Disk holen 
;
r1load:	call 	calc
       	call 	store
       	call 	gettrk		; 
	jc   	errio
       	jmp  	r1rd
;
; store - sicher Drive/Track/Sektor
;	  fr Disk-Routinen
;
store: mov  a,c			; 
       sta  aktdrv		; 
       mov  a,e			; 
       sta  aktsec
       mov  a,d
       sta  akttrk
       ret
;
; Copyx kopiert die Daten vom Buffer (FC00h) in DMA-Buffer
;			  und umgekehrt (DE-HL) getauscht
;
; (B)	Recordlnge
; (DE)	= Zieladress
; (HL)	= Quelladresse
;
copyx: 	mov  a,m		; 
	stax d
	inx  h
	inx  d
	dcr  b
	jnz  copyx
	ret
;
; BIOS-Funktion Sektor schreiben
;
write: 	di			;
	call calc		; <== Einsprung von BDOS
	call comp
	jnz  wload	
;
w1wr:  call bufcal		; Daten im Buffer, nur kopieren
       xchg
       call copyx		; Record in DMA Buffer
       mvi  a,01h
       sta  wrtflg		; Buffer wieder gltig
       xra  a
       ret
;
;
wload: 	lda  	wrtflg		; 
	ora  	a
	jz   	w1load
	call	puttrk		; alten Buffer Sichern
	ana	a
	jnz  	errio
;
w1load:	call 	calc
	call 	store
	call 	gettrk		; neuen Buffer holen
	ana  	a
	jnz  	errio
	jmp  	w1wr
;
; Fehlermeldung an BDOS (A)=01h
;
errio: mvi  a,1h
       ora  a
       ret
;
;
;====================================================
;
;      	GETTRK/PUTTRK (Bufferverwaltung)
;	Block lesen/schreiben 1KB-Buffer
;	mit CF-Interface
;
; Datenbergabe:
;	aktdrv <== dbank BDOS SET-DISK
;	akttrk <== iotrk BDOS SET-Track
;	aktsec <== iosec 1.Sektor in Moppelformat
;			(Umrechnung aus CP/M) <== BDOS SET-Sektor
;	
;	wrtflg wird auf 0 gesetzt Buffer ungltig)
;
; interne Speicherzellen:
;	datadr	= aktuelle Bufferadresse
;	trknr	= laufende Spurnummer
;	secnr	= laufende Sektornummer
;
; Rckgabe:
;	Buffer 	= 1KByte Daten, werden dann Recordweise mit DMA ausgetauscht
;	(A)	= 0 fr OK
;	(CY) 	= 1 Fehler lesen/schreiben
;
;====================================================
;
; Test ob Laufwerk A ausgewhlt wurde
;			dann zu den CF-Routinen
;
gettrk:	push	psw	;
	lda	aktdrv	;
	cpi	00h	; Laufwerk = A?
	jnz	get_fl	; nein weiter mit Floppy
	pop	psw	;
	jmp	get_cf	; ==> zu CF-Routinen

;
puttrk:	push	psw	;
	lda	aktdrv	;
	cpi	00h	; Laufwerk = A ?
	jnz	put_fl	; nein weiter mit Floppy
	pop	psw	;
	jmp	put_cf	; ==> zu CF-Routinen
	
;
; Floppy-Routinen vorbereiten
;	Buffer
;	Sektor
;	Laufwerksnummer fr FDC aufbereiten
;	Anzahl der zu kopierenden Sektoren
;
codbuf:	xra  a         	; clear wrtflg -"Buffer leer"
       sta  wrtflg
       lxi  h,buffer   	; Bereitet Reg fuer LW-Anspr.
       lda  aktsec   	; 
       mov  e,a
       lda  aktdrv	;
       rlc
       ani  06h
       ori  18h       	; DD / 30ms / Side 0
       mov  b,a
       mvi  d,4h      	; 4 Sectoren
       ret
;
; Buffer mit 4 Sektoren laden
;	
get_fl:	pop	psw	;
	call codbuf    	; Reg vorbereiten
;
getlp: push h
       push d
       push b
       lda  akttrk
       mov  d,a
       call secrd
       pop  b
       pop  d
       pop  h
       ana  a
       jnz  errx
       call nxtsec
       jnz  getlp
       xra  a
       ret		; zurck zum Disk-Manager
;
;
nxtsec:	push d         	; Reg fuer naechsten Sec setzten
       lxi  d,0100h
       dad  d         	; Bufferadr + 256 Bytes
       pop  d
       inr  e         	; Sec-Nr. + 1
       dcr  d         	;%Sec-Zaehler - 1
       ret
;
; 4 Sektoren vom Buffer auf Floppy schreiben
;	
put_fl:	pop	psw	;
	call codbuf	;
putlp: push h
       push d
       push b
       lda  akttrk
       mov  d,a
       call secwr
       pop  b
       pop  d
       pop  h
       ana  a
       jnz  errx
       call nxtsec
       jnz  putlp
       xra  a
       ret		; zurck zum Disk-Manager
;
; Fehler an Diskmanager bergeben (CY)=1
;
errx:  stc
       ret
;
;
;====================================================
;
;      Floppy-Routinen
;
;====================================================
;
comreg      equ	48h  ; FDC
trkreg      equ	49h  ; FDC
secreg      equ	4ah  ; FDC
datreg      equ	4bh  ; FDC
status      equ	comreg
ctrl        equ	40h  ; (FDC)-Drive-Select
;
;
       nop
;
intrd: in   datreg
       stax d
       inx  d
       ret
;
;
intwr: ldax d
       out  datreg;
       inx  d;
       ret
;
;
inton: push b
       mvi  a,1eh     	; 8085-RST5.5 enable
       mvi  b,02h     	; NSC800-RSTC enable
       jmp  intcte	;
intof: push b
       mvi  a,1fh     	; 8085-RST5.5 disable
       mvi  b,00h     	; NSC800-RSTC disable
intcte:	sim
       nop            	; fuer NSC800-JR-Befehl
       mov  a,b
       out  0bbh
       pop  b
       ret
;
secwrx:	call init
       push h
       lxi  h,intwr
       shld intprg
       pop  h
       lda  trknr
       mov  d,a
       mvi  a,2ah
       cmp  d         ; Sec kleiner Sec 42 ?
       mvi  a,0a6h
       jnc  write1
       mov  b,a
       lda  selbyt
       ani  01h
       mov  a,b
       jnz  write1
       ani  0fdh
write1:	sta  rwbef
       jmp  start
;
;
;
secrdx:	call init
       push h
       lxi  h,intrd
       shld intprg
       pop  h
       mvi  a,84h     ;rdsec;+30 ms
       sta  rwbef
;
start: mov  a,m
;
       rlc
       cnc  recal
       mov  a,m
       ani  7fh
       out  trkreg
       lda  trknr
       out  datreg
       mvi  b,14h     ; Seek
       call posit
;
       ani  19h       ; Verify
       jnz  end0
       in   trkreg
       mov  d,a
       lda  trknr
       cmp  d
       jnz  poserr
;
       xra  a
       cmp  b
       mov  a,c
       rz
;
       in   trkreg    ; FDC-Befehl wurde mit Fehler
       ori  80h       ; abgeschlossen
       mov  m,a
;
       mvi  b,4h
wdhg:  push b
       push h
       call rdwr
       ani  5ch
       pop  h
       pop  b
       jz   ende
;
       dcr  b
;
;
       jnz  wdhg
;
end0:  mvi  m,0h
ende:  in   status
       ani  7ch
end1:  push psw
;
       call intof
       pop  psw
       ret
;
;
recal: mvi  b,04h     ; Restore
       call posit
       xra  a
       cmp  b
       jz   recal1
       mvi  m,80h
       in   status
       ret
;
recal1:	mov  a,c
       ret
;
;
;
init:  di
       shld datadr
       push b
       mov  a,d
       sta  trknr
       mov  a,e
       sta  secnr
;
;
       lxi  h,0024h
       mvi  m,0e9h    ; TRAP :   PCHL
       lxi  h,0066h
       mvi  m,0e9h
;
       lxi  h,002ch
       mvi  m,0f1h    ; RST5.5:  POP  PSW
       inx  h
       mvi  m,0dbh    ;          IN
       inx  h
       mvi  m,048h    ;          48h
       inx  h
       mvi  m,0c9h    ;          RET
;
;
;
;
;
       mov  a,b
       sta  selbyt
       rrc
       ani  03h
       push psw
       lxi  h,laufw0
       mvi  d,0h
       mov  e,a
       dad  d
       mov  c,m
       lda  selbyt
       ani  21h
       ora  c
       sta  selout
       lxi  h,track0
       pop  psw
       mvi  d,0h
       mov  e,a
       dad  d
       pop  b
       ret
;
;
;
;
rdwr:  lhld datadr
       push h
       pop  d
       lhld intprg
       lda  secnr
       out  secreg
       call inton
;
       lda  rwbef
       out  comreg
rdwr1: ei
       hlt
       jmp  rdwr1
;
;
laufw0:	db   02h
laufw1:	db   04h
laufw2:	db   08h
laufw3:	db   10h
;
;
posit: call inton
;
       lda  selbyt
       rrc
       rrc
       rrc
       ani  03h
       ora  b
       out  comreg
posit1:	in   status
       rlc
       jnc  posit1
       lda  selout
       out  ctrl
       ei
       mvi  b,2h
posit2:	lxi  d,0ffffh
posit3:	dcx  d
       mov  a,d
       ora  e
       jnz  posit3
       dcr  b
       jnz  posit2
       mvi  a,0d0h
       out  comreg
       call intof
;
       in   status
       ani  7ch
       ori  80h
       mov  c,a
       ret
;
poserr:	mvi  m,0h      ;Posit.-Fehler
       mvi  a,10h
       ret
;
;
secrd: lda  0066h
       sta  nscbuf
;
vsecrd:	shld hlbuff
;
       lxi  h,0h
       dad  sp
       shld spbuff
       lxi  sp,stack2
       lhld hlbuff
;
       call secrd0
       shld hlbuff
       lhld spbuff
       sphl
       lhld hlbuff
       push psw
       lda  nscbuf
       sta  0066h
       pop  psw
       ret
;
;
;
secrd0:	mvi  c,10h
       lda  tbit
       ora  a
       jz   secrdl
       mvi  a,"R"
       call test
secrdl:	push h
       push d
       push b
       call secrdx
       pop  b
       pop  d
       pop  h
       ora  a
       rz
       dcr  c
       jnz  secrdl
       inr  a
       ret
;
;
secwr: lda  0066h
       sta  nscbuf
       mvi  c,10h
vsecwr:	lda  tbit
       ora  a
       jz   secwrl
       mvi  a,"W"
       call test
secwrl:	push h
       push d
       push b
       call secwrx
       pop  b
       pop  d
       pop  h
       ora  a
       jz   verify
       dcr  c
       jnz  secwrl
       inr  a
       push psw
       lda  nscbuf
       sta  0066h
       pop  psw
       ret
;
;
verify:	push h
       shld vbufhl
       lda  tbit
       ora  a
       jz   verxx
       mvi  a,"V"
       call test
;
verxx: push d
       push b
       lxi  h,verbuf
       call vsecrd
       lhld vbufhl
       call compar
       pop  b
       pop  d
       pop  h
       jnz  vsecwr
       lda  nscbuf
       sta  0066h
       xra  a
       ret
;
;
compar:	mvi  b,0h
       lxi  d,verbuf
compl: ldax d
       cmp  m
       rnz
;
       inx  h
       inx  d
       dcr  b
       jnz  compl
       ret
;
;
;====================================================
;
;      Kalt- und Warmstart
;
;====================================================
;
boot:	call	curson		; Cursor einschalten
	mvi	a,01h		;
	out	24h		; Only Bank 1 select
	lxi	sp,stack	; Initialisierung STACK
;
	call	cfinit		; CF Interface vorbereite
	call	inibd		; 87er Moppel-V24 mit 9600Bd
	mvi	a,80h		; LPT+CON
	sta	iobyte		; IO-BYTE initialisieren
;    
; Systemmeldung ausgeben
;
	lxi	h,msg1		;
msgout:	mov	a,m		;
	ora	a		;
	jz	clear		;
	mov	c,a		;
	push	h		;
	call	co		;
	pop	h		;
	inx	h		;
	jmp	msgout		;	
;
clear:	xra	a		;
	sta	tbit		; loescht Testbit
	xra	a		;
	sta	wrtflg		; Buffer ungueltig
	sta	cdisk		; Select Drive 0
	cma			;
	sta	aktdrv		; letztes Drive undefiniert
	lxi	h,0000h		;
	shld	track0		; trk-reg 0+1  undefiniert
	shld	track2		; trk-reg 2+3  undefiniert

gocpm:	mvi	a,0c3h		; Initialisierung Page 0
	sta	0000h		;
	sta	0005h		;
	lxi	h,wboote	;
	shld	1h		;
	lxi	h,bdos		;
	shld	6h		;
	lxi	b,buff		;
	call	setdma		;
	lda	cdisk		;
	mov	c,a		;
	jmp	ccp		;
;
;
;
;
wboot: 	lxi  	sp,buff
;
	lda  	wrtflg    	; wurde alter Buffer auf Disk
	ora	a         	; geschrieben ?
	jz   	load		; write alten Buffer auf Disk
	call 	puttrk    	; weiter mit Floppy
;
load:  xra  a
       cma
       sta wrtflg     ; Buffer ungueltig
;
; CCP und BDOS neu laden
;
	lxi	h,ccp		; Startadresse 60k CP/M
	shld	datadr		; - sichern
	mvi	a,0h		; Startspur = 0
	sta	trknr		; - sichern
	mvi	a,2h		; Startsektor = 2
	sta	secnr		; - sichern
	;
bootl:	call	settr		; Spur setzen
	call	setsek		; Sektor setzen
	call	rdsek		; Sektor schreiben
	lda	secnr		;
	inr	a		; Sektornummer hochzaehlen
	inr	a		; wg. Sektorberechnung im AVR
	sta	secnr		;
	cpi	23		; 11 Sektoren laden
	jc	bootl		; nein - weiter
	;
	jmp	gocpm		; zum ccp

;
;====================================================
;
; CF Interface
; Datenbergabe:
;
;	akttrk <== iotrk BDOS SET-Track
;	aktsec <== iosec 1.Sektor in Moppelformat
;			 wird im AVR-Teil auf 512B/Sektor umgerechnet
;	
;	wrtflg wird auf 0 gesetzt Buffer ungltig
;
; interne Speicherzellen:
;	datadr	= aktuelle Bufferadresse
;	trknr	= laufende Spurnummer
;	secnr	= laufende Sektornummer
;
; Rckgabe:
;	Buffer 	= 1KByte Daten, werden dann Recordweise mit DMA ausgetauscht
;	(A)	= 0 fr OK
;	(CY) 	= 1 Fehler lesen/schreiben
;
;
;====================================================
;
; PIO Ansteuerung
;
PIO_A	equ 	0cah			; CAh   Daten Kanal A
PIO_B	equ	0dah			; DAh   Daten Kanal B
PIO_C	equ	0eah			; EAh   Daten Kanal C
PIO_Ctl	equ	0fah			; FAh   Steuerwort
;
PIO_BA	equ	0c1h			; Betriebsart 2
;					; Kanal A bidirektional, Handshake Kanal C
;
; AVR Befehle
;
AVRres	equ	00h			; Spur 0 Sektor 0 ansteuern
SetSpur equ	10h			; Spurnummer setzen
SetSekt equ	20h   			; Sektornummer setzen
Rdsekt	equ	30h			; Daten vom aktuellen Sektor lesen
Wrsekt	equ	40h			; Daten in den aktuellen Sektor schreiben
AVRstat	equ	0F0h			; Status ermittel
;
;
; CF-karte lesen/schreiben
;  Laufwerk 4 = CF_Karte
;
; Parameterbergabe:
;
; TRKNR	 = Spur
; SECNR  = Sektor
; DATADR = Buffer Zieladresse
;
;===========================================================
;
; initrw =	Buffer, Spur, Sektorregister vorbereiten
;	
initrw:	xra  	a	        ; clear wrtflg -"Buffer ungltig"
	sta  	wrtflg		;
	di			; Interrupt sperren
	lxi	h,buffer	;
	shld	datadr		;
	lda	akttrk		;
	sta	trknr		;
	lda	aktsec		;
	sta	secnr		;
	call	settr		;
	call	setsek		;
	ret			;
;	
; get/put_cf =	Block von CF lesen/schreiben
;
get_cf: push	h
	push	d
	push	b
	call 	initrw		;

cfrd_l: call 	rdsek		;
	call	avr_stat	; Status abfragen
	ana	a		;
	jnz	cf_err		; Fehler
	call 	updsek		;
	call	rdsek		;
	call	avr_stat	; Status abfragen
	ana	a		;
	jnz	cf_err		; Fehler
;
bufret: pop	b		; <== Rcksprung von Testroutine
	pop	d
	pop	h
	xra	a		;
	ret			; zurck zum Disk-Manager
	
put_cf: push	h
	push	d
	push	b
	call 	initrw		;

cfwr_l:	call 	wrsek		;
	call	avr_stat	; Status abfragen
	ana	a		;
	jnz	cf_err		; Fehler
	call 	updsek		;
	call	wrsek		;
	call	avr_stat	; Status abfragen
	ana	a		;
	jnz	cf_err		; Fehler
	pop	b
	pop	d
	pop	h
	xra	a		;
	ret			; zurck zum Disk-Manager
;
;
; updsek/sp = Sektor und Spurnummern aktualisieren
;             und an CF-Karte senden
;	     
;	! Format 64 Sektoren pro Spur !
;
updsek: lda	secnr		; Sektor holen
	cpi	16		; letzter Sektor spur
	jz	updsp		;
	inr	a		; nchster Sektor gleiche Spur
	sta	secnr		;
	call	setsek		; Sektor fr CF setzen
	ret
	
updsp:	mvi	a,01h		; nchste Spur mit Sektor 1
	sta	secnr		; 
	lda	trknr		;
	inr	a		;
	sta	trknr		;
	call	settr		; Spur/Sektor fr CF setzen
	call	setsek		;
	ret
;
; Fehler (A)=1
;
cf_err	pop	b		;
	pop	d		;
	pop	h		;
	mvi	a,01		;
	stc			;
	ret			; Zurck mit Fehler
	
;====================================================
;
; PIO-A lesen (A)
; wartet bis Daten bereitstehen 

piord:		in	PIO_C		; Status ermitteln
		ani	00100000b	; IBF maskieren
		jz	piord		; warte auf Daten
		in	PIO_A		; daten lesen
		ret			; (A) Daten
;
; (A) PIO-A schreiben
; 

piowr:		push	psw		;
pio_sts:	in	PIO_C		; Status ermitteln
		ani	10000000b	; /OBF maskieren
		jz	pio_sts		; warten auf Quittung /ACK
		pop	psw
		out	PIO_A		; Daten schreiben
		ret			; 
;
;====================================================
;
; PIO Initialisieren mit Betriebsart
; Kanal A bidirektional
; Kanal C Handshake
; Kanal B Ausgabe
;
pioinit:	push	psw		; PIO Betriebsart einstellen
		mvi	a,PIO_BA	; PIO_BA	equ	0c1h
		out	PIO_Ctl		; 
		pop	psw		;
		ret			;
;
;
; cfinit = Reset Befehl an CF-Karte
;          
;
cfinit:		call	pioinit		; PIO und AVR initialisieren
		mvi	a,avrres	; Test ob CF-Erweiterung vorhanden ist;
		call	piowr		;
		xra	a		;
		call	piord		;
		cpi	00h		; 	
		jnz	cferr		; CF nicht bereit -> Fehler
		ret			; CF-Interface OK
;
; avr_stat = Status CF-Karte ermitteln 0=OK
;            sonst Fehlermeldung
;
avr_stat:	mvi	a,avrstat	; Status AVR ermitteln
		call	piowr		; 
		call	piord		;
		ret			;

;
cferr:	mvi	a,01h		; Fehler CF-Karte
	ora	a		;
	ret			;
	;

		
;====================================================
;
; Spur/Sektor setzen
;
settr:		mvi	a,setspur	; Befehl Spur setzen
		call	piowr		;
		lda	trknr		; Spur laden
		call	piowr		;
		ret			;
		
setsek:		mvi	a,setsekt	; Befehl Sektor setzen
		call	piowr		;
		lda	secnr		; Sektor laden
		call	piowr		;
		ret			;
;
; Sektoren lesen/schreiben (512Byte)
;
wrsek:		mvi	a,wrsekt	; Befehl schreiben
		call	piowr		;
		lhld	datadr		; 
		lxi	b,200h		; 512 byte
wrsek_l:	mov	a,m		;
		call	piowr		;
		inx	h		;
		dcr	c		;				;
		jnz	wrsek_l		;
		dcr	b		;
		jnz	wrsek_l		;
		shld	datadr		; Buffer sichern
		ret			;		
	
		
rdsek:		mvi	a,rdsekt	; Befehl lesen
		call	piowr		;
		lhld	datadr		; 
		lxi	b,200h		; 512 byte
rdsek_l:	call	piord		;
		mov	m,a		;
		inx	h		;		
		dcr	c		;
		jnz	rdsek_l		;
		dcr	b		;
		jnz	rdsek_l		;
		shld	datadr		; Bufferadresse sichern
		ret			;		
;
;-------------------------------------------------------
; Testprogramm wird ber tbit = 1 gesteuert
; Floppy-Routinen Systemmeldung
; Read/Write
;
test:  push h
       push d
       push b
       mov  c,a
       call co
       pop  b
       pop  d
       pop  h
       ret
      
;====================================================
; Geraetetreiber fuer schnelle V24 auf CF-Karte
;
; Befehle fuer AVR
;
v24tx   equ	52h		; ein byte senden		ohne Buffe
v24rx	equ	53h		; ein byte empfangen
v24stat equ	5Fh		; Status der V24 Schnittstelle
				; Bit 3 CTS Signal
				; Bit 4 RTS Signal
				; Bit 5 Senderegister leer
				; Bit 7 Empfangsregister voll
;
;
; Byte von V24 holen
; (A) von CF-Karte
cv24rxb: mvi  	a,v24rx		; Befehl
	call 	piowr		;
	call 	piord		; Zeichen holen
	ret

;
; (A)=00h kein Zeichen 
; (A)=FFh Zeichen wartet	
cv24ist: mvi  	a,v24stat	; Status fr Eingabe
	call 	piowr		; abfragen
	call 	piord		;
	ani	10000000b	; Bit 7 Maskieren
	jz	cv24ie		; kein zeichen
	mvi	a,0ffh		; Zeichen im Eingangsbuffer
cv24ie:  ret			;	

; (C) an CF-Karte
cv24txb: mvi  	a,v24tx		; Befehl
	call 	piowr		;
	mov  	a,c		; Zeichen	
	call 	piowr		; ausgeben
	ret			;
	
; (A)=00h Schnittstelle belegt
; (A)=FFh Schnittstelle frei	
cv24ost: mvi  	a,v24stat	; Status fr Ausgabe
	call 	piowr		; abfragen
	call 	piord		;
	ani  	00100000b	; Bit 5 maskieren
	jz   	cv24oe		; kein Zeichen vorhanden
	mvi  	a,0ffh		; Zeichen im Eingangsbuffer
cv24oe:  ret	
;
;=============================================================================
; V24 Moppel 87er Hardware
;
; Baudratentabelle fuer
; CPU-Frequenz 6,144MHz
;
; Teilfaktor fuer Timer = CPU-Frequenz /2 = Systemtakt / 4800bd / 16 = 40
;                                                                  I
;                                                                  UART Teiler
; Wert als BCD, da Timer auf BCD Zaehler eingestellt wird
;               sonst Umrechnung nach Binaer notwendig
;
; 9600Bd = 20h lowByte
; 4800Bd = 40h .
; 2400Bd = 80h .
; 1200Bd = 60h lowByte
;	   01h highByte
;
; (DE) Baudrate laden
;
inibd:	lxi	d,0020h		; Startwert 9600Bd
;
; Baudrate laden (DE)
;
mv24bd:	mvi	a,37h		; Ctl Zaehler als BCD-Zaehler
	out	TIMER_C		;
	mov	a,e		;
	out 	TIMER_0		; Zaehler untere haelfte
	mov	a,d		;
	out 	TIMER_0		; Zaehler obere haelfte
	mvi 	a,48h		; v24 modus
	out 	CS_MODE		;
	mvi 	a,03		; Reset UART
	out 	UART_C		; 
	ret
;
; V24 Input-Status	(A)=00h kein Zeichen
;			(A)=FFh Zeichen vorhanden
;
mv24ist: mvi 	a,15h		; 
	out 	UART_C		; clk/16,8bit,1stop,ohne paritaet , RTS off
mvist_l: IN 	UART_C		; Warten bis Empfangsregister voll
	ANI 	01H		;
	jnz 	mvist_e		; Zeichen vorhanden
	mvi 	a,55h		; RTS on
	out 	UART_C		; 
	xra 	a		;
	ret			;
	
mvist_e: mvi 	a,55h		; RTS on
	out 	UART_C		; 
	mvi 	a,0ffh		;
	ret			;
;	
; Byte von V24 empfangen (A)
; wartet bis Zeichen vorhanden ist
;
mv24rx: mvi 	a,15h		; 
	out 	UART_C		; clk/16,8bit,1stop,ohne paritaet , RTS off
mvrx_l:	IN 	UART_C		; Warten bis Empfangsregister voll
	ANI 	01H		;
	jz  	mvrx_l		; warten
	mvi 	a,55h		; RTS on
	out 	UART_C		; 
	IN 	UART_D		; Daten auslesen
	ret			;
;
; Byte v24 senden (C)
; wartet bis Empfaenger bereit ist
;
mv24tx:	mvi 	a,55h		; 
	out 	UART_C		; clk/16,8bit,1stop,ohne paritaet , RTS on
mvtx_l:	IN 	UART_C		; Warten bis Senderegister leer
	ANI 	02H		;
	jz	mvtx_l		;
	mov	a,c		;
	out 	UART_D		;
	ret			;
;
; Byte V24 empfangen (A) 
; mit Zeitueberwachung 10s (A)=1ah Control Z
;
mv24rxz: Push 	b		; ein Byte ueber V24 empfangen (A)
	lxi 	b,10000		; max Wartezeit 10s
	mvi 	a,15h		; 
	out 	UART_C		; clk/16,8bit,1stop,ohne paritaet , RTS off
mvrxz_l: IN 	UART_C		; Warten bis Empfangsregister voll
	ANI 	01H		;
	jnz  	mvrxz_e		;
	call 	dely1		; 1ms warten 
	dcr	c		;
        JNZ 	mvrxz_l		;
	dcr	b		;
	jnz	mvrxz_l		;
        POP 	B		;
	mvi	a,55h		; RTS on
	out	UART_C		;
	mvi 	a,1Ah		; SUB (Control-Z)
	ret
	
mvrxz_e: mvi	a,55h		; RTS on
	out	UART_C		; 
	IN	UART_D		; Daten auslesen
	pop	b		;
	ret			;
;
; Byte V24 senden (C)
; mit Zeitueberwachung
;
mv24txz: mvi 	a,55h		; ein Byte ueber V24 senden (C)
	out 	UART_C		; clk/16,8bit,2stop,ohne paritaet RTS on
	mvi 	b,10		; max Wartezeit 10ms
mvtxz_l: IN 	UART_C		; Warten bis Senderegister leer
	ANI 	02H		;
	jnz  	mvtxz_o		;
	call 	dely1		;
	dcr 	b		;
	jnz 	mvtxz_l		;
	mvi 	a,04h		; Zeituebschreitung (End of Transmission)
	ret			;
	;
mvtxz_o: mov 	a,c		; Daten ausgeben
	out 	UART_D		;
	ret			;
;
;-----------------------------------------------------------------------------
;
; Zeitverzoegerung 1ms, 10ms, 100ms 1sec
;
onesec: push 	psw		; 1s warten
	mvi 	a,10
one_l:  call 	dely100
	dcr 	a
	jnz 	one_l
	pop 	psw
	ret
;
dely100: push 	psw		; 100ms warten
	mvi 	a,100
d100_l: call 	dely1
	dcr 	a
	jnz 	d100_l
	pop 	psw
	ret
;
dely10: push 	psw		; 10ms warten
	mvi 	a,10
d10_l:  call 	dely1
	dcr 	a
	jnz 	d10_l
	pop 	psw
	ret
;
dely1:  push 	psw		; 1ms warten
	mvi 	a,06h
	add 	a
	add 	a
	inr 	a
	add 	a
	add 	a
	add 	a
d1_l: 	dcr 	a
	jnz 	d1_l
	pop 	psw
	ret
;
;-----------------------------------------------------------------------------
;
; BIOS-Meldetext
;
msg1:  	db   0ah
	db   0dh
	db   "This is 60 K"
	db   " CP/M Rel.2.2"
	db   0ah
	db   0dh
	db   "BIOS CFV4.3 "
	db   "27.07.2016"
	db   0ah
	db   0dh
	db   00h
;
;
;=============================================================================
;
; Soft-System
;
	org	0F800h	;
trknr: 	db   0h		; fr Disk-Routinen
secnr: 	db   0h		;     	-- " --
selbyt:	db   0h		;	-- " --
selout:	db   0h		;	-- " --
versnr:	db   0h		; ?
trkbak:	dw   0h		; ?
;
tbit:  	db   0h		; Test-Flag wenn 1 Systemmeldung Read/Write
;
;
track0:	db   80h       	; trk-reg undefiniert
track1:	db   80h       	;     --  "  --
track2:	db   80h       	;     --  "  --
track3:	db   80h       	;     --  "  --
;
rwbef: 	db   0h		; fr Disk-Routinen
datadr:	dw   0h		; 	-- " --		Bufferadresse
intprg:	dw   0h		; 	-- " --
;
wrtflg:	db   0h		; 0= Buffer ungltig, Daten nachladen
aktdrv:	db   0h		; Laufwerk
akttrk:	db   0h		; Track nach Blocking/Deblocking
aktsec:	db   0h		; Sektor -- " --
;
nscbuf:	db   0h		; Zwischenspeicher fr RAM 0066h
;			  wg. Floppy-Routine TRAP
hlbuff:	dw   0h		; Zwischenspeicher fr STACK-Umschaltung
spbuff:	dw   0h		; Zwischenspeicher fr BDOS-STACK
;
vbufhl:	ds   2h		;
;
dbank: 	db   0h		; Laufwerksnummer aus seldsk
iopb:  	db   80h  	; norm IO
ion:   	db   1h
iotrk: 	db   offset	; <==    BDOS
iosec: 	db   1h		;	-- " --
iodma: 	dw   buff	;	-- " --
trkbuf:	db   0h
       	db   0h
       	db   0h
       	db   0h
altdrv:	db   1h
indadr:	dw   0h
indad2:	dw   0h
;
begdat  equ    dirbuf
;
dirbuf:	ds   80h  	; Directory Access Buffer
alv0:  	ds   12h
csv0:  	ds   10h
alv1:  	ds   12h
csv1:  	ds   10h
alv2:  	ds   12h
csv2:  	ds   10h
alv3:  	ds   256	; fr 2048 Blcke a/4096 Byte
csv3:  	ds   10h
enddat:	ds   0h
;
datsiz  equ    0108h    ; = ENDDAT - BEGDAT
;
uc1out:	ds   3h        	; User-Consol-Output
uc1in: 	ds   3h        	; User-Consol-Input
uc1sta:	ds   3h        	; User-Consol-Status
;
ptr:   ds   3h        	; Paper-Tape-Reader
ur1:   ds   3h        	; User-Reader 1
ur2:   ds   3h        	; User-Reader 2
;
ptrsta:	ds   3h        	; Paper-Tape-Reader-Status
ur1sta:	ds   3h        	; User-Reader 1 - Status
ur2sta:	ds   3h        	; User-Reader 2 - Status
;
;=================================================
;	RAM frei bis
;
;	stack2  	0FAFFh  ; bei 60 K
;
;	verbuf  	0FB00h  ; bei 60 K
;
;	buffer  	0FC00h  ; bei 60 K
;
;
end
;
