*****************************************************
*                                                   *
*      CP/M-Boot-Loader  V 11.5            30.10.85 *
*                                                   *
*****************************************************
*
trkb0  equ  2h   *Start f}r     30 K
secb0  equ  1h   *Start-Sektor  30 K
nums0  equ  1fh  *Sektor-Anzahl 30 K
*
trkb1  equ  0h   *Start-Spur    60 K
secb1  equ  2h   *Start-Sektor  60 K
nums1  equ  1fH  *Sektor-Anzahl 60 K   
*
ccp30k equ  05c00h
ccp60k equ  0d400h
*
bios30 equ  07200h
bios60 equ  0ea00h
*
ci     equ    43h
movid  equ  1003h
string equ  1021h
crson  equ  1036h
crsoff equ  1039h
rdsec  equ  200fh
rambeg equ  2800h     *Boot-Bereich
cpyram equ  2900h     *(C)-Text
*
bank   equ  24h       *Latch A16...A18
*
*
org    2800h
ofs    3800h
*
*
boot0: dw   boot30    *Batch 30-K-CP/M
       db   1h        *Anzahl Sektoren
       db   18h       *SELBYT
       db   1h        *Start-Sektor
       db   0h        *Start-Spur
       dw   rambeg    *Boot-Buffer
*
boot1: dw   boot60    *Batch 60-K-CP/M
       db   1h        *Anzahl Sektoren
       db   18h       *SELBYT
       db   1h        *Start-Sektor
       db   0h        *Start-Spur
       dw   rambeg    *Boot-Buffer
*
boot2: dw   cpyrig    *Batch Copyright
       db   1h        *Anzahl Sektoren
       db   18h       *SELBYT
       db   10h       *Start-Sektor
       db   3h        *Start-Spur 
       dw   cpyram    *(C)-Buffer
*
cpyrig:lxi  h,cpyram
       call string
       jmp  movid     *./. Floppy-Routinen
*
boot30:xra  a
       call strin2
b30:   lxi  h,ccp30k
       mvi  d,trkb0
       mvi  e,secb0
       mvi  b,nums0
       call loadlp
       call crson
       jmp  bios30
*
boot60:mvi  a,1h
       call strin2
b60:   lxi  h,ccp60k
       mvi  d,trkb1
       mvi  e,secb1
       mvi  b,nums1
       call loadlp
       call crson
       jmp  bios60
*
loadlp:push d
       push h
       push b
       mvi  b,18h     *SELBYT
       call rdsec
       pop  b
       pop  h
       lxi  d,100h
       dad  d
       pop  d
       ora  a
       jnz  boterr
*
       dcr  b
       rz
       inr  e
       mov  a,e
       cpi  11h
       jnz  loadlp
*
       inr  d         *n{chste Spur
       mvi  e,1h      *erster Sektor
       jmp  loadlp
*
strin2:sta  flag
       call crsoff
       lxi  h,text0
       call string
       mvi  a,81h     *Bank 1 parallel
       out  bank
       ret
*
*
boterr:lxi  h,errmsg
       call string
       call crson
       call ci
       cpi  0dh       *Return?
       jnz  movid     *nein: Monitor-Warmstart
       lda  flag
       ora  a         *30 K?
       jz   boot30    *ja: JMP
       jmp  boot60    *sonst 60 K
*
text0: db   0dh
       db   0dh
       db   "M"
       db   "O"
       db   "P"
       db   "P"
       db   "E"
       db   "L"
       db   "-"
       db   "C"
       db   "P"
       db   "/"
       db   "M"
       db   "-"
       db   "U"
       db   "r"
       db   "l"
       db   "o"
       db   "a"
       db   "d"
       db   20h
       db   "V"
       db   20h
       db   "1"
       db   "1"
       db   "."
       db   "5"
       db   0dh
       db   "C"
       db   "o"
       db   "p"
       db   "y"
       db   "r"
       db   "i"
       db   "g"
       db   "h"
       db   "t"
       db   20h
       db   "("
       db   "C"
       db   ")"
       db   20h
       db   0eh
       db   0fh
       db   10h
       db   27h
       db   "8"
       db   "5"
       db   0dh
       db   0h
*
errmsg:db   0dh
       db   0dh
       db   "B"
       db   "o"
       db   "o"
       db   "t"
       db   20h
       db   "E"
       db   "r"
       db   "r"
       db   "o"
       db   "r"
       db   0dh
       db   "P"
       db   "r"
       db   "e"
       db   "s"
       db   "s"
       db   20h
       db   "R"
       db   "E"
       db   "T"
       db   "U"
       db   "R"
       db   "N"
       db   20h
       db   "t"
       db   "o"
       db   20h
       db   "R"
       db   "e"
       db   "s"
       db   "t"
       db   "a"
       db   "r"
       db   "t"
       db   7h        *Bell
       db   0dh
       db   0h
*
flag:  ds   1h        *30 K ./. 60 K
*
*
*****************************************************
*
*      Disketten-Organisation:
*
*****************************************************
*
* Tr0, Sec01 (2800h): Batch-Vorspann, Urloader
*
* Tr0, Sec02 (D400h): CCP (60 K)
*      ...
*      Sec09 (DB00h)
*
* Tr0, Sec10 (DC00h): BDOS (60 K)
*      ...
* Tr1, Sec07 (E900h)
*
* Tr1, Sec08 (EA00h): BIOS (60 K)
*      ...
* Tr1, Sec16 (F200h)
*
* Tr2, Sec01 (5C00h): CCP (30 K)
*      ... 
*      Sec08 (6300h)
*
* Tr2, Sec09 (6400h): BDOS (30 K)
*      ...
* Tr3, Sec06 (7100h)
*
* Tr3, Sec07 (7200h): BIOS (30 K)
*      ...
*      Sec15 (7A00h)
*
* Tr3, Sec16 (2900h): Copyright-Vermerk
*
* Tr4, Sec01 (-----): Directory
*
end

A>