*****************************************************
*                                                   *
* MOPPEL-BIOS f}r CP/M Rel. 2.2  V 12.5    30.10.85 *
*                                                   *
*****************************************************
*
*      30-K-Version
*
*
BIOS    7200h         * 0EA00h  * bei 60 K 
CCP     5c00h         * 0D400h  * bei 60 K
BDOS    6406h         * 0DC06h  * bei 60 K
*
begin   0201h         * 0002h   * bei 60 K
*
stack2  7affh         * 0FAFFh  * bei 60 K
*
verbuf  7b00h         * 0FB00h  * bei 60 K
*
buffer  7c00h         * 0FC00h  * bei 60 K
*
*
cimo        43h       * Console Input
como        49h       * Console Output
cstsmo      52h       * Console Status
lomo        4fh       * Lister Output
*
ioflag    2fc8h       * LO Select
*
stack0    2950h       * Bank 0 Stack
*
*
nsects      2ch       * Anzahl Sector f}r CPML
offset      04h       * Start bei Track 4
vers        22h       * Versions-Nr.
*
buff      0080h       * default Buffer Adress
stack     0100h       * default STACK
ndisks      04h
iobyte    0003h
cdisk     0004h       * Adr 4 f}r last Drive
*
*
org    bios
*
       jmp  boot      * Einsprungleiste
wboote:jmp  wboot
       jmp  csts      * Status Console
       jmp  ci        * Input  Console
       jmp  co        * Output Console
       jmp  list      * Output Lineprinter
       jmp  punch     * Output Puncher
       jmp  reader    * Input  Reader
*
       jmp  home
       jmp  seldsk    * Select Disk
       jmp  settrk    * Set    Track
       jmp  setsec    * Set    Sector
       jmp  setdma    * Set    Disk-Buffer
       jmp  read      * Read   Disk
       jmp  write     * Write  Disk
       jmp  lsts      * Status Lineprinter
       jmp  sectra
*
*
*****************************************************
*
*      DPBase
*
*****************************************************
*
dpbase equ  dpe0
*
dpe0:  dw   xlt0      * Translate table
       dw   0000h
       dw   0000h     * Sratch area
       dw   0000h
       dw   dirbuf    * Dir. Buffer
       dw   dpb0      * Parameter Block
       dw   csv0      * Check
       dw   alv0      * Allocation Vectors
*
dpe1:  dw   xlt1
       dw   0000h
       dw   0000h
       dw   0000h
       dw   dirbuf
       dw   dpb1
       dw   csv1
       dw   alv1
*
dpe2:  dw   xlt2
       dw   0000h
       dw   0000h
       dw   0000h
       dw   dirbuf
       dw   dpb2
       dw   csv2
       dw   alv2
*
dpe3:  dw   xlt3
       dw   0000h
       dw   0000h
       dw   0000h
       dw   dirbuf
       dw   dpb3
       dw   csv3
       dw   alv3
*
*
*****************************************************
*
*      Disk Parameter Block
*
*****************************************************
*
dpb0:  dw   20h  * Sectors per Track
       db   3h   * Block shift
       db   7h   * Block Mask
       db   0h   * Extnt Mask
       dw   8eh  * Disk Size-1
       dw   3fh  * Directory max.
       db   0c0h * Alloc0
       db   00h  * Alloc1
       dw   10h  * Check Size
       dw   4h   * Offset
*
xlt0   0h   *Sec.Translate Vec.;no Transl.Table
*
*
dpb1   dpb0
*
xlt1   xlt0
*
*
dpb2   dpb0
*
xlt2   xlt0
*
*
dpb3   dpb0
*
xlt3   xlt0
*
*
*****************************************************
*
*      Peripherie-Verwaltung
*
*****************************************************
*
co:    lda  iobyte    * CP/M : Console Output
       ani  03h
       lxi  h,cotab   * Startadr CO-Tab
       jmp  decode
cotab: dw   co-mon    * TTY
       dw   crtout    * CRT
       dw   list      * BAT
       dw   uc1out    * UC1; Ext.
*
ci:    lda  iobyte    * CP/M : Console Input
       ani  03h
       lxi  h,citab   * Startadr CI-Tab
       jmp  decode
citab: dw   ci-mon    * TTY
       dw   crtin     * CRT
       dw   reader    * BAT
       dw   uc1in     * UC1; Ext.
*
reader:lda  iobyte    * CP/M : Reader Input
       rrc
       rrc
       ani  03h
       lxi  h,ritab   * Startadr Reader-Tab
       jmp  decode
ritab: dw   ci-mon    * TTY
       dw   ptr       * PTR
       dw   ur1       * UR1; Ext.
       dw   ur2       * UR2; Ext.
*
punch: lda  iobyte    * CP/M : Puncher Output
       rrc
       rrc
       rrc
       rrc
       ani  03h
       lxi  h,potab   * Startadr Puncher-Tab
       jmp  decode
potab: dw   co-mon    * TTY
       dw   resout    * PTP; Res.
       dw   centr     * UP1
       dw   thermo    * UP2; Res.
*
list:  lda  iobyte    * CP/M : List Output
       rlc
       rlc
       ani  03h
       lxi  h,lotab   * Startadr List-Tab
       jmp  decode
lotab: dw   co-mon    * TTY
       dw   crtout    * CRT
       dw   prt       * LPT
       dw   punch     * UL1
*
csts:  lda  iobyte    * CP/M : Console Status
       ani  03h
       lxi  h,csttab
       jmp  decode
csttab:dw   cs-mon    * TTY
       dw   crtist    * CRT
       dw   ristat    * BAT
       dw   uc1sta    * UC1; Ext.
*
lsts:  lda  iobyte    * CP/M : Lister Status
       rlc
       rlc
       ani  03h
       lxi  h,lsttab
       jmp  decode
lsttab:dw   mcosta    * TTY
       dw   crtost    * CRT
       dw   prtst     * LPT
       dw   pustat    * UC1
*
pustat:lda  iobyte
       rrc
       rrc
       rrc
       rrc
       ani  03h
       lxi  h,pustab
       jmp  decode
pustab:dw   mcosta    * TTY
       dw   rest      * PTP; Res.
       dw   censta    * UP1
       dw   therst    * UP2; Res.
*
ristat:lda  iobyte
       rrc
       rrc
       ani  03h
       lxi  h,ristab
       jmp  decode
ristab:dw   cs-mon    * TTY
       dw   ptrsta    * PTR; Ext.
       dw   ur1sta    * UR1; Ext.
       dw   ur2sta    * UR2; Ext.
*
decode:jz   found     * Setzt PC entsprechend IOBYTE
       inx  h
       inx  h
       dcr  a
       jmp  decode
found: mov  e,m       *Zieladresse auslesen 
       inx  h
       mov  d,m
       xchg
       pchl           *Verzweigung
*
*
*****************************************************
*
*      Ausgabe }ber die serielle Schnittstelle
*
*****************************************************
*
prt:   push h
       lxi  h,0h
       dad  sp        *Bank 1 Stack in H&L
       lxi  d,stack0
       xchg
       sphl           *Bank 0 Stack
       mvi  a,81h
       out  24h       *Umschalten auf Bank 0
*
       push d         *Bank 1 Stack retten
       mvi  a,80h     *Printer w{hlen
       sta  ioflag
       call lomo      *Monitor-UP
       mvi  a,0h      *Printer inaktiv
       sta  ioflag    *(wg.CO; sonst doppeltes LO) 
       pop  h         *Bank 1 Stack zur}ck 
       mvi  a,1h
       out  24h       *Umschalten auf Bank 1
*
       sphl           *alter Bank 1 Stack
       pop  h
       ret
*
prtst: mvi  a,0ffh
       ret
*
*
*****************************************************
*
*      Ausgabe }ber die parallele Schnittstelle
*
*****************************************************
*
centr: push h
       lxi  h,0h
       dad  sp        *Bank 1 Stack in H&L
       lxi  d,stack0
       xchg
       sphl           *Bank 0 Stack
       mvi  a,81h
       out  24h       *Umschalten auf Bank 0
*
       push d         *Bank 1 Stack retten
       mvi  a,40h     *Centronics w{hlen
       sta  ioflag
       call lomo      *Monitor-UP
       mvi  a,0h      *Centronics inaktiv
       sta  ioflag    *(wg.CO; sonst doppeltes LO)
       pop  h         *Bank 1 Stack zur}ck
       mvi  a,1h
       out  24h       *Umschalten auf Bank 1
*
       sphl           *alter Bank 1 Stack
       pop  h
       ret
*
censta:mvi  a,0ffh
       ret
*
*
*****************************************************
*
*      Monitor-Routinen CO, CI und CSTS
*
*****************************************************
*
*
*      Ausgabe auf Bildschirm
*
co-mon:push h
       lxi  h,0h
       dad  sp        *Bank 1 Stack in H&L
       lxi  d,stack0
       xchg
       sphl           *Bank 0 Stack
       mvi  a,81h
       out  24h       *Umschalten auf Bank 0
*
       push d         *Bank 1 Stack retten
       call como      *Monitor-UP
       pop  h         *Bank 1 Stack zur}ck
       mvi  a,01h
       out  24h       *Umschalten auf Bank 1
*
       sphl           *alter Bank 1 Stack
       pop  h
       ret
*
mcosta:mvi  a,0ffh    * Status CO-MON
       ret
*
*
*      Eingabe von der ASCII-Tastatur
*
ci-mon:push h
       lxi  h,0h
       dad  sp        *Bank 1 Stack in H&L
       lxi  d,stack0
       xchg
       sphl           *Bank 0 Stack
       mvi  a,81h
       out  24h       *Umschalten auf Bank 0
*
       push d         *Bank 1 Stack retten
       call cimo      *Monitor-UP
       push psw       *wg. MOVID-5.3-CSTS
cilop: call cstsmo    *Monitor-UP
       jnz  cilop     *auf Loslassen warten
       pop  psw
       mov  c,a       *temp. ablegen
       pop  h         *Bank 1 Stack zur}ck
       mvi  a,1h
       out  24h       *Umschalten auf Bank 1
*
       sphl           *alter Bank 1 Stack
       pop  h
       mov  a,c       *Input zur}ckholen
       rlc            *CTL-Codes MOVID 5.3?
       jc   ctlkey    *ja: JMP
       mov  a,c
       ret
*
ctlkey:mov  a,c       *fehlende CTL-Codes erzeugen
       cpi  8fh       *HOME?
       jz   mark      *ja: JMP
       ani  7fh
       sui  20h
       ret
*
mark:  mvi  a,27h     *Hochkomma
       ret
*
*
*      Status der ASCII-Tastatur
*
cs-mon:push h
       lxi  h,0h
       dad  sp        *Bank 1 Stack in H&L
       lxi  d,stack0
       xchg
       sphl           *Bank 0 Stack
       mvi  a,81h
       out  24h       *Umschalten auf Bank 0
*
       push d         *Bank 1 Stack retten
       call cstsmo    *Monitor-UP
       pop  h         *Bank 1 Stack zur}ck
       mov  c,a       *Status retten
       mvi  a,1h
       out  24h       *Umschalten auf Bank 1
*
       sphl           *alter Bank 1 Stack
       pop  h
       mov  a,c       *Status zur}ckholen
       ret
*
*
*****************************************************
*
*      Peripherie-Ansprache (Reserve)
*
*****************************************************
*
crtout:ret
*
crtost:xra  a
       ret
*
*
crtin:ret
*
crtist:xra  a
       ret
*
*
*
*
thermo:ret
*
therst:xra  a
       ret
*
resout:ret
*
rest:  xra  a
       ret
*
*
*****************************************************
*
*      Disketten-Management
*
*****************************************************
*
home:  mvi  c,00h          * Track 0
settrk:lxi  h,iotrk        * Trackbuffer laden
       mov  m,c
       ret
*
*
setsec:lxi  h,iosec        * Sectorbuffer laden
       mov  m,c
       ret
*
*
setdma:mov  l,c            * DMA - Adresse laden
       mov  h,b
       shld iodma
       ret
*
*
seldsk:lxi  h,0000h   * Bei Fehler notwendig
       mov  a,c
       cpi  ndisks    * LW im Bereich ?
       rnc
*
       sta  dbank     * LW in Buffer
       add  a         * *2
       add  a         * *4
       add  a         * *8
       add  a         * *16 (L{nge eines DPBs)
       mov  l,a
       lxi  d,dpbase
       dad  d
       ret
*
*
sectra:mov  a,d
       ora  e
       jz   se1       * Test ob Xlate-Tab vorhanden
*
       xchg
       dad  b
       mov  a,m
       sta  iosec
       mov  l,a
       mvi  h,00h
       ret
*
se1:   mov  l,c
       mov  a,c
       sta  iosec
       mvi  h,0h
       ret
*
*
calc:  lda  iosec
       rrc
       ani  0ch
       inr  a
       mov  e,a
       lda  dbank
       mov  c,a
       lda  iotrk
       mov  d,a
       ret
*
*
comp:  lda  aktdrv
       cmp  c
       rnz
       lda  akttrk
       cmp  d
       rnz
       lda  aktsec
       cmp  e
       ret
*
*
read:  call calc
       call comp
       jnz  rload
*
r1rd:  call bufcal
       call copyx
       xra  a
       ret
*
*
*
bufcal:lxi  h,buffer
       lda  iosec
       ani  07h
       rrc
       mov  d,a
       mvi  a,00h
       rar
       mov  e,a
       mov  a,d
       ani  7fh
       mov  d,a
       dad  d
       xchg
       lhld iodma
       xchg
       mvi  b,80h     * L{nge = 128 Bytes
       ret
*
*
*
rload: lda  wrtflg
       ora  a
       jz   r1load
       call puttrk
       jc   errio
*
r1load:call calc
       call store
       call gettrk
       jc   errio
       jmp  r1rd
*
*
*
store: mov  a,c
       sta  aktdrv
       mov  a,e
       sta  aktsec
       mov  a,d
       sta  akttrk
       ret
*
*
*
copyx: mov  a,m
       stax d
       inx  h
       inx  d
       dcr  b
       jnz  copyx
       ret
*
*
*
write: call calc
       call comp
       jnz  wload
*
w1wr:  call bufcal
       xchg
       call copyx
       mvi  a,01h
       sta  wrtflg
       xra  a
       ret
*
*
wload: lda  wrtflg
       ora  a
       jz   w1load
       call puttrk
       ana  a
       jnz  errio
*
w1load:call calc
       call store
       call gettrk
       ana  a
       jnz  errio
       jmp  w1wr
*
*
errio: mvi  a,1h
       ora  a
       ret
*
*
*****************************************************
*
*      GETTRK/PUTTRK (Bufferverwaltung)
*
*****************************************************
*
codbuf:xra  a         * clear wrtflg -"Buffer leer"
       sta  wrtflg
       lxi  h,buffer  * Bereitet Reg f}r LW-Anspr.
       lda  aktsec    * vor
       mov  e,a
       lda  aktdrv
       rlc
       ani  06h
       ori  18h       * DD / 30ms / Side 0
       mov  b,a
       mvi  d,4h      * 4 Sectoren
       ret
*
*
gettrk:call codbuf    * Reg vorbereiten
*
getlp: push h
       push d
       push b
       lda  akttrk
       mov  d,a
       call secrd
       pop  b
       pop  d
       pop  h
       ana  a
       jnz  errx
       call nxtsec
       jnz  getlp
       xra  a
       ret
*
*
nxtsec:push d         * Reg f}r n{chsten Sec setzten
       lxi  d,0100h
       dad  d         * Bufferadr + 256 Bytes
       pop  d
       inr  e         * Sec-Nr. + 1
       dcr  d         *%Sec-Z{hler - 1
       ret
*
*
*
*
puttrk:call codbuf
putlp: push h
       push d
       push b
       lda  akttrk
       mov  d,a
       call secwr
       pop  b
       pop  d
       pop  h
       ana  a
       jnz  errx
       call nxtsec
       jnz  putlp
       xra  a
       ret
*
errx:  stc
       ret
*
*
****************************************************
*
*      Floppy-Routinen
*
*****************************************************
*
comreg      48h  * FDC
trkreg      49h  * FDC
secreg      4ah  * FDC
datreg      4bh  * FDC
status      comreg
ctrl        40h  * (FDC)-Drive-Select
*
*
       nop
*
intrd: in   datreg
       stax d
       inx  d
       ret
*
*
intwr: ldax d
       out  datreg*
       inx  d*
       ret
*
*
inton: push b
       mvi  a,1eh     * 8085-RST5.5 enable
       mvi  b,02h     * NSC800-RSTC enable
       jmp  intcte*
intof: push b
       mvi  a,1fh     * 8085-RST5.5 disable
       mvi  b,00h     * NSC800-RSTC disable
intcte:sim
       nop            * f}r NSC800-JR-Befehl
       mov  a,b
       out  0bbh
       pop  b
       ret
*
secwrx:call init
       push h
       lxi  h,intwr
       shld intprg
       pop  h
       lda  trknr
       mov  d,a
       mvi  a,2ah
       cmp  d         * Sec kleiner Sec 42 ?
       mvi  a,0a6h
       jnc  write1
       mov  b,a
       lda  selbyt
       ani  01h
       mov  a,b
       jnz  write1
       ani  0fdh
write1:sta  rwbef
       jmp  start
*
*
*
secrdx:call init
       push h
       lxi  h,intrd
       shld intprg
       pop  h
       mvi  a,84h     *rdsec;+30 ms
       sta  rwbef
*
start: mov  a,m
*
       rlc
       cnc  recal
       mov  a,m
       ani  7fh
       out  trkreg
       lda  trknr
       out  datreg
       mvi  b,14h     * Seek
       call posit
*
       ani  19h       * Verify
       jnz  end0
       in   trkreg
       mov  d,a
       lda  trknr
       cmp  d
       jnz  poserr
*
       xra  a
       cmp  b
       mov  a,c
       rz
*
       in   trkreg    * FDC-Befehl wurde mit Fehler
       ori  80h       * abgeschlossen
       mov  m,a
*
       mvi  b,4h
wdhg:  push b
       push h
       call rdwr
       ani  5ch
       pop  h
       pop  b
       jz   ende
*
       dcr  b
*
*
       jnz  wdhg
*
end0:  mvi  m,0h
ende:  in   status
       ani  7ch
end1:  push psw
*
       call intof
       pop  psw
       ret
*
*
recal: mvi  b,04h     * Restore
       call posit
       xra  a
       cmp  b
       jz   recal1
       mvi  m,80h
       in   status
       ret
*
recal1:mov  a,c
       ret
*
*
init:  di
       shld datadr
       push b
       mov  a,d
       sta  trknr
       mov  a,e
       sta  secnr
*
*
       lxi  h,0024h
       mvi  m,0e9h    * TRAP :   PCHL
       lxi  h,0066h
       mvi  m,0e9h
*
       lxi  h,002ch
       mvi  m,0f1h    * RST5.5:  POP  PSW
       inx  h
       mvi  m,0dbh    *          IN
       inx  h
       mvi  m,048h    *          48h
       inx  h
       mvi  m,0c9h    *          RET
*
*
*
*
*
       mov  a,b
       sta  selbyt
       rrc
       ani  03h
       push psw
       lxi  h,laufw0
       mvi  d,0h
       mov  e,a
       dad  d
       mov  c,m
       lda  selbyt
       ani  21h
       ora  c
       sta  selout
       lxi  h,track0
       pop  psw
       mvi  d,0h
       mov  e,a
       dad  d
       pop  b
       ret
*
*
*
*
rdwr:  lhld datadr
       push h
       pop  d
       lhld intprg
       lda  secnr
       out  secreg
       call inton
*
       lda  rwbef
       out  comreg
rdwr1: ei
       hlt
       jmp  rdwr1
*
*
laufw0:db   02h
laufw1:db   04h
laufw2:db   08h
laufw3:db   10h
*
*
posit: call inton
*
       lda  selbyt
       rrc
       rrc
       rrc
       ani  03h
       ora  b
       out  comreg
posit1:in   status
       rlc
       jnc  posit1
       lda  selout
       out  ctrl
       ei
       mvi  b,2h
posit2:lxi  d,0ffffh
posit3:dcx  d
       mov  a,d
       ora  e
       jnz  posit3
       dcr  b
       jnz  posit2
       mvi  a,0d0h
       out  comreg
       call intof
*
       in   status
       ani  7ch
       ori  80h
       mov  c,a
       ret
*
poserr:mvi  m,0h      *Posit.-Fehler
       mvi  a,10h
       ret
*
*
secrd: lda  0066h
       sta  nscbuf
*
vsecrd:shld hlbuff
*
       lxi  h,0h
       dad  sp
       shld spbuff
       lxi  sp,stack2
       lhld hlbuff
*
       call secrd0
       shld hlbuff
       lhld spbuff
       sphl
       lhld hlbuff
       push psw
       lda  nscbuf
       sta  0066h
       pop  psw
       ret
*
*
*
secrd0:mvi  c,10h
       lda  tbit
       ora  a
       jz   secrdl
       mvi  a,"R"
       call test
secrdl:push h
       push d
       push b
       call secrdx
       pop  b
       pop  d
       pop  h
       ora  a
       rz
       dcr  c
       jnz  secrdl
       inr  a
       ret
*
*
secwr: lda  0066h
       sta  nscbuf
       mvi  c,10h
vsecwr:lda  tbit
       ora  a
       jz   secwrl
       mvi  a,"W"
       call test
secwrl:push h
       push d
       push b
       call secwrx
       pop  b
       pop  d
       pop  h
       ora  a
       jz   verify
       dcr  c
       jnz  secwrl
       inr  a
       push psw
       lda  nscbuf
       sta  0066h
       pop  psw
       ret
*
*
verify:push h
       shld vbufhl
       lda  tbit
       ora  a
       jz   verxx
       mvi  a,"V"
       call test
*
verxx: push d
       push b
       lxi  h,verbuf
       call vsecrd
       lhld vbufhl
       call compar
       pop  b
       pop  d
       pop  h
       jnz  vsecwr
       lda  nscbuf
       sta  0066h
       xra  a
       ret
*
*
compar:mvi  b,0h
       lxi  d,verbuf
compl: ldax d
       cmp  m
       rnz
*
       inx  h
       inx  d
       dcr  b
       jnz  compl
       ret
*
*
****************************************************
*
*      Kalt- und Warmstart
*
****************************************************
*
boot:  mvi  a,01h
       out  24h       * Only Bank 1 select
*
       mvi  a,80h     * LPT+CON
       sta  iobyte    * IO-BYTE initialisieren
*
       xra  a
       sta  tbit      * l|scht Testbit
*
       lxi  sp,stack  * Initialisierung STACK
*
       lxi  h,msg1    * Begr}~ungstext ausgeben
       call msgout
       xra  a
       sta  wrtflg    * Buffer ung}ltig
       sta  cdisk     * Select Drive 0
       cma
       sta  aktdrv    * letztes Drive undefiniert
       lxi  h,0000h
       shld track0    * trk-reg 0+1  undefiniert
       shld track2    * trk-reg 2+3  undefiniert
gocpm: mvi  a,0c3h    * Initialisierung Page 0
       sta  0000h
       sta  0005h
       lxi  h,wboote
       shld 1h
       lxi  h,bdos
       shld 6h
       lxi  b,buff
       call setdma
       lda  cdisk
       mov  c,a
       jmp  ccp
*
*
wboot: lxi  sp,buff
*
       lda  wrtflg    * wurde alter Buffer auf Disk
       ora  a         * geschrieben ?
       jz   load
       call puttrk    * write alten Buffer auf Disk
*
load:  xra  a
       cma
       sta wrtflg     * Buffer ung}ltig
*
       mvi  c,16h     * 22 Sektoren
       lxi  d,begin   *Warmstart von Disk
       lxi  h,ccp
bloop: push d
       push h
       push b
*
*
       mvi  b,18h     * Select-Byte
*
       call secrd
*
       pop  b
*
       pop  h
       lxi  d,0100h
       dad  d
       pop  d
*
       ora  a
       jnz  load
       inr  e
       dcr  c
       jz   gocpm
       mov  a,e
       cpi  11h
       jz   ntrks
       jmp  bloop
*
ntrks: inr  d
       mvi  e,01h
       jmp  bloop
*
*
*
*
msgout:mov  a,m
       ora  a
       rz
       mov  c,a
       push h
       call co
       pop  h
       inx  h
       jmp  msgout
*
*
*
msg1:  db   0ah
       db   0dh
       db   "T"
       db   "h"
       db   "i"
       db   "s"
       db   20h
       db   "i"
       db   "s"
       db   20h
       db   "6"  * 60 K
       db   "0"
       db   20h
       db   "K"
       db   20h
       db   "C"
       db   "P"
       db   "/"
       db   "M"
       db   20h
       db   "R"
       db   "e"
       db   "l"
       db   "."
       db   20h
       db   "2"
       db   "."
       db   "2"
       db   0ah
       db   0dh
       db   00h
*
*
*
test:  push h
       push d
       push b
       mov  c,a
       call co
       pop  b
       pop  d
       pop  h
       ret
*
*
* Soft-System
*
trknr: db   0h
secnr: db   0h
selbyt:db   0h
selout:db   0h
versnr:db   0h
trkbak:dw   0h
*
tbit:  db   0h
*
*
track0:db   80h       * trk-reg undefiniert
track1:db   80h       *     --  "  --
track2:db   80h       *     --  "  --
track3:db   80h       *     --  "  --
*
rwbef: db   0h
datadr:dw   0h
intprg:dw   0h
*
wrtflg:db   0h
aktdrv:db   0h
akttrk:db   0h
aktsec:db   0h
*
nscbuf:db   0h
*
hlbuff:dw   0h
spbuff:dw   0h
*
vbufhl:ds   2h
*
dbank: db   0h
iopb:  db   80h  * norm IO
ion:   db   1h
iotrk: db   offset
iosec: db   1h
iodma: dw   buff
trkbuf:db   0h
       db   0h
       db   0h
       db   0h
altdrv:db   1h
indadr:dw   0h
indad2:dw   0h
*
begdat      dirbuf
*
dirbuf:ds   80h  * Directory Access Buffer
alv0:  ds   12h
csv0:  ds   10h
alv1:  ds   12h
csv1:  ds   10h
alv2:  ds   12h
csv2:  ds   10h
alv3:  ds   12h
csv3:  ds   10h
enddat:ds   0h
*
datsiz      0108h     * = ENDDAT - BEGDAT
*
uc1out:ds   3h        * User-Consol-Output
uc1in: ds   3h        * User-Consol-Input
uc1sta:ds   3h        * User-Consol-Status
*
ptr:   ds   3h        * Paper-Tape-Reader
ur1:   ds   3h        * User-Reader 1
ur2:   ds   3h        * User-Reader 2
*
ptrsta:ds   3h        * Paper-Tape-Reader-Status
ur1sta:ds   3h        * User-Reader 1 - Status
ur2sta:ds   3h        * User-Reader 2 - Status
*
*
end
*



A>