;-----------------------------------------------------------------------------
; V24Test
; 09.03.2016 zeile bis cr empfangen 
; 06.03.2016
;
; PIO Ansteuerung
;
PIO_A	equ 	0cah			; CAh   Daten Kanal A
PIO_B	equ	0dah			; DAh   Daten Kanal B
PIO_C	equ	0eah			; EAh   Daten Kanal C
PIO_Ctl	equ	0fah			; FAh   Steuerwort
;
PIO_BA	equ	0c1h			; Betriebsart
					; Kanal A bidirektional, Handshake Kanal C
;					; Kanal B als Ausgabe
;
; AVR Befehle
;
AVRres	equ	00h			; Spur 0 Sektor 0 ansteuern
SetSpur equ	10h			; Spurnummer setzen
SetSekt equ	20h   			; Sektornummer setzen
Rdsekt	equ	30h			; Daten vom aktuellen Sektor lesen
Wrsekt	equ	40h			; Daten in den aktuellen Sektor schreiben

v24stat equ	5Fh			; Status der V24 Schnittstelle
					; Bit 3 CTS Signal
					; Bit 4 RTS Signal
					; Bit 5 Senderegister leer
					; Bit 7 Empfangsregister voll
v24tx   equ	52h			; ein byte senden		ohne Buffe
v24rx	equ	53h			; ein byte empfangen
v24str	equ	54h			; String senden Ende 00h	mit Buffer
v24zeil	equ	55h			; Zeile empfangen bis CR
AVRstat	equ	0F0h			; Status CF-Karte ermittel
;
;
;-----------------------------------------------------------------------------
;
; Vorspann Parameterbereich
;
; Monitorprogramme  
;  
CI	EQU 0043h 	; CI 	Tastaturabfrage wartet auf Taste ASCII(A)    
CO	EQU 0049h  	; CO 	Bildschirmausgabe ASCII(C) Ziel (UPDATE)
LOM	EQU 004Fh	; LO 	Drucker über RS232	          
CSTS	EQU 0052h  	; CSTS	Tastaturstatus Taste Z=0, k.Taste Z=1  	          
FILL	EQU 0085h  	; FILL  Speicher mit Konstante fuellen SRCBEG,SRCEND,DSTBEG        
COPYM	EQU 0088h  	; COPY  Speicherbereich verschieben 
onesec	EQU 001bh	; Wartezeit 1Sekunde
dely1	EQU 000bh	;           1ms
;
BELPOR	EQU 52h		; Port fuer Summer 
BYTFF	EQU 1Ah		; PORT FF auf Singel-Step-Modul
COMREG	EQU 48h		; Register Adressen
TRKREG	EQU 49h		; WD1770
SECREG	EQU 4Ah
DATREG	EQU 4BH
STATUS	EQU COMREG
CTRL	EQU 40H      
;
MOVID	EQU 1003h  	; Warmstart Videomonitor
BREAK	EQU 100Fh	; Unterbrechung mit CTRL-C
PARIN	EQU 1012h	;
STRING	EQU 1021h	; STRING
ERROR	EQU 1027h       ; Error Videomonitor
CLRVID	EQU 102Dh	; CLRVID  
CLRLIN	EQU 1030h	; CLRLIN        
CRSPOS	EQU 1033h	; CRSPOS         
CRSON	EQU 1036h 	; CRSON         
CRSOFF	EQU 1039h	; CRSOFF
BYTOT	EQU 103Fh	; BYTOT  (A) zweistellig darstellen Adresse (HL) 
ADROT	EQU 103ch	; (DE) vierstellig ausgeben
CRLF	EQU 137bh	; gibt CR/LF aus
;
; Exteren Programme
;
FDC	EQU 2000h	; Floppy 
EDIT	EQU 7000h	; Editor
ASS:	EQU 6000h	; Assembler
DISSK	EQU 6C00h	; Disassembler
;
STACK	EQU 2F00H	; 
TRAP	EQU 2F8Ch
RST55	EQU 2F98h
RST551	EQU 2F99h
;
HORDSP	EQU 2E50h	; 40/80 Zeichen pro Zeile
BEGIN	EQU 2E54h	; Anfangsadresse letzte Zeile
UPDATE	EQU 2E56h	; aktuelle Cursorposition
;
SRCBEG	EQU 2FBFh	; Startadresse
SRCEND	EQU 2FC1h	; Endadresse
DSTBEG	EQU 2FC3h	; Anfang Zieladresse/Parameter
DSTEND	EQU 2FC5h	; 
LINZ	EQU 2E54h
;
VIDBEG	EQU 3000h	; Bildschirmadresse 	oben links
VIDEND	EQU 377Fh	; 			unten rechts
PRTFLG	EQU 37AFh	; 
RAMBEG	EQU 37B0h	; Anfang Parameterbereich Videomonitor

;
; Buffer Adressen
;
BATBUF	EQU 2D00h
FDCBUF	EQU 2F70h
CPYBUF	EQU 8000h
BUFFER  EQU 9000h	; Eingabebuffer
;
	ORG FDCBUF

TRKNR:	DS 1h		; Spurnummer
SECNR:  DS 1h		; Sektornummer
SIDNR:	DS 1h		; Seite 0/1
SELBYT: DS 1h		; SelectByte Bit1,2 = Laufwerksnummer
SELOUT: DS 1h
TRACK0: DS 4h
RWBEF:	DS 1h
DATADR:	DS 2h		; Buffer-Adresse r/w Sektoren
INTPRG:	DS 2h
RWSUB:	DS 1h
RWSUB1: DS 2h
HIBUF:	DS 2h
BUFDST: DS 1h
BUFSRC: DS 1h		; IM CF-Betrieb = Anzahl der Sektoren die übertragen werden
CPYEND: DS 1h
;
TIMOUT	EQU 32h			;
FQUARZ	EQU 06h			;
DLY100	EQU 13h			;
SECZAL	EQU 16			;
SECLDD	EQU 1			; 256 Bytes
;INTON	EQU 1Eh			; RST 5.5 freigeben
;INTOF	EQU 1Fh			; RST 5.5 sperren
;
;


	org 08000h		; Testadresse
;
kstart:	jmp kalt		; Testprogramm
v24st:	jmp stat		; V24 Status abfragen
	jmp wr			; 1 Byte senden
	jmp rd			; empfangen
	jmp zeilrx		; Zeile bis CR empfangen
	jmp zeiltx		; Zeile senden bis CR
	jmp fbuff		; Buffer mit text fllen
	jmp 0000h
	jmp 0000h

		
		
;-----------------------------------------------------------------------------
;
kalt:	call pioinit
	call cfinit
	cpi  01h		; Fehler
	jz   wende		;
	lxi  h,meld1
	call string
ende:	call onesec		;
wende: 	lxi  h,meld4		;
	call string
	jmp  movid		; zurueck zum Monitor

;
; 16 Byte senden
wr:	lxi  h,meld2		; Meldung
	call string		;
	mvi  b,10h		; Zeichenzaehler
wrloop:	mvi  a,v24tx		; Befehl
	call piowr		;
	mvi  a,2ah		; *
	mov  c,a		;	
	call piowr		;
	call co			;
	call onesec		; Pause
	dcr  b			;
	jnz  wrloop		; 16 Zeichen ausgegeben ?
	jmp  ende
	
;
; 16 Byte Empfangen
	
rd:	lxi  h,meld3		; Meldung
	call string		;
	mvi  b,10h		; Zeichenzaehler
rdloop:	mvi  a,v24rx		; Befehl
	call piowr		;
	call piord		;
	push psw		;
	call bytot		;
	pop  psw		;
	mov  c,a		; 
	call co			;
	mvi  c,0dh		; CR
	call co			;
	mvi  c,0ah		; LF
	call co
	dcr  b			;
	jnz  rdloop		; 16 Zeichen ausgegeben ?
	jmp  ende


;
; V24 Status ermittel

stat: lxi  h,meld6		; Meldung
	call string		;
	mvi a,v24stat		; 
	call piowr		;
	call piord		;
	call bytot		; ausgeben
	jmp  ende	
		
;		
; Zeile bis CR empfangen

zeilrx: lxi  h,meld7		; Meldung
	call string		;
	mvi a,v24zeil		; 
	call piowr		;
	lxi  h,buffer		; Buffer
	mvi  b,40h		; maxbuffer
	
zloop:	call piord		;
	cpi  0dh		; ? CR
	jz   zend		; ende
	mov  m,a		; Daten speichern
	inx  h
	dcr  b			;
	jnz  zloop		; weiter

zerr:	lxi  h,err2		; Buffer ueberlauf
	call string
	jmp  ende		; fertig

zend:	mov  m,a		; CR speichern
	inx  h			;
	xra  a			;
	mov  m,a		; 00h speichern (String ende ablegen)
	lxi  h,buffer
	call string		; Daten anzeigen
	jmp  ende
		
;		
; Zeile senden bis CR
	
zeiltx: lxi  h,meld8		; Meldung
	call string		;
	mvi a,v24str		; Befehl Zeile senden
	call piowr		;
	lxi  h,buffer		; Buffer
	mvi  b,40h		; maxbuffer
	
ztxlp:	mov  a,m		; 
	call piowr		; Zeichen senden
	cpi  0dh		; ? CR
	jz   ztxend		; ende
	inx  h
	dcr  b			;
	jnz  ztxlp		; weiter

ztxerr:	mvi  a,0dh		; CR
	call piowr		; ausgeben und weiter zur Fehlerroutine
	lxi  h,err2		; Buffer ueberlauf
	call string
	jmp  ende		; fertig

ztxend:	lxi  h,buffer		; Buffer ausgeben
	call string		; als test
	jmp  ende

fbuff:	lxi  h,meld9		; Meldung
	call string		;
	lxi  h,buffer		; Buffer
	mvi  b,3eh		; maxbuffer - 2
floop:	call ci			; zeichen von Tastatur holen
	mov  m,a		;
	cpi  0dh		; ? CR
	jz   fend1		;
	inx  h			;
	dcr  b			;
	jnz  floop		; weiter bis Buffer gefllt
	nop			; Bufferende setzen "CR, 00h" ! zeile lschen
	mvi  a,0dh		; CR
	mov  m,a		;
fend1:	inx  h			;
	xra  a			; "00h" String Ende setzen
	mov  m,a		;

fend:	lxi  h,buffer		; Buffer zur Kontraolle
	call string		; anzeigen
	jmp  ende
	
	dw 0000h
	dw 0000h
	dw 0000h
	dw 0000h
	dw 0000h
	dw 0000h
	dw 0000h
	dw 0000h		
;	
;-----------------------------------------------------------------------------
;
; PIO Initialisieren mit Betriebsart
; Kanal A bidirektional
; Kanal C Handshake
; Kanal B Ausgabe
;
pioinit:	push	psw		; PIO Betriebsart einstellen
		mvi	a,PIO_BA	; PIO_BA	equ	0c1h
		out	PIO_Ctl		; 
		pop	psw		;
		ret			;
;
;---------------------------------------------------------------------------
;
; PIO-A lesen (A)
; wartet bis Daten bereitstehen 

piord:		in	PIO_C		; Status ermitteln
		ani	00100000b	; IBF maskieren
		jz	piord		; warte auf Daten
		in	PIO_A		; daten lesen
		ret			; (A) Daten
;
; (A) PIO-A schreiben
; 

piowr:		push	psw		;
pio_sts:	in	PIO_C		; Status ermitteln
		ani	10000000b	; /OBF maskieren
		jz	pio_sts		; warten auf Quittung /ACK
		pop	psw
		out	PIO_A		; Daten schreiben
		ret			; 
;
;-------------------------------------------------------------------------
;
; cfinit = Reset Befehl an CF-Karte
;          
;
cfinit:		call	pioinit		; PIO und AVR initialisieren
		mvi	a,avrres	; Test ob CF-Erweiterung vorhanden ist;
		call	piowr		;
		xra	a		;
		call	piord		;
		cpi	00h		; 	
		jnz	cferr		; CF nicht bereit -> Fehler
		ret			; CF-Interface OK
;
; avr_stat = Status CF-Karte ermitteln 0=OK
;            sonst Fehlermeldung
;
avr_stat:	mvi	a,avrstat	; Status AVR ermitteln
		call	piowr		; 
		call	piord		;
		cpi	00h		;
		jnz	cferr1		; Driver Error
		ret			;

;
cferr:		lxi	h,errmsg1	; Fehlermeldung 
		call	string		; CF nicht bereit
		mvi	a,01		;
		ret
		
cferr1:		lxi	h,errmsg	; Lese/schreibfehler
		mvi	a,27h		;
		call	error
		jmp	ende
		
		
;---------------------------------------------------------------------
; Texte
;
meld1:	DB 0Dh			; CR
	DB 0Ah			; LF     
	DB "V24-Test"
	DB 0Dh			; 
	DB 00h
;
meld2:	DB 0Dh			; CR
	DB 0Ah			; LF     
	DB "1 Byte senden"
	DB 0Dh			; 
	DB 00h
;
meld3:	DB 0Dh			; CR
	DB 0Ah			; LF     
	DB "1 Byte"
	DB " empfangen"
	DB 0Dh			;
	DB 00h	 
;
meld4:	DB 0Dh			; CR
	DB 0Ah			; LF     
	DB "Ende"
	DB 0Dh			;
	DB 00h	 
;	
meld5:	DB 0Dh			; CR
	DB 0Ah			; LF     
	DB "Fehler"
	DB 0Dh			;
	DB 00h
	
meld6:	DB 0Dh			; CR
	DB 0Ah			; LF     
	DB "V24 Status"
	DB 0Dh			; 	 
	DB 00h

meld7:	DB 0Dh			; CR
	DB 0Ah			; LF     
	DB "Zeile bis"
	DB " CR empfangen"
	DB 0Dh			; 	 
	DB 00h

meld8:	DB 0Dh			; CR
	DB 0Ah			; LF     
	DB "Buffer"
	DB " senden"
	DB 0Dh			; 	 
	DB 00h

meld9:	DB 0Dh			; CR
	DB 0Ah			; LF     
	DB "Buffer fuellen"
	DB " bis CR"
	DB 0Dh			; 	 
	DB 00h

err2:	DB 0Dh			; CR
	DB 0Ah			; LF     
	DB "Buffer voll"
	DB 0Dh			; 	 
	DB 00h

errmsg: DB 0Dh			; CR
	DB 0Ah			; LF     
	DB "Error F0"
	DB 0Dh			;
	DB 00h	 
	
errmsg1: DB 0Dh			; CR
	DB 0Ah			; LF     
	DB " CF-Karte "
	db "nicht vorhanden"
	DB 0Dh			;
	DB 00h	 
		
;
