;-----------------------------------------------------------------------------
; 18.02.2016 LPT Ansteuerung
;
; PIO Ansteuerung
;
PIO_A	equ 	0cah			; CAh   Daten Kanal A
PIO_B	equ	0dah			; DAh   Daten Kanal B
PIO_C	equ	0eah			; EAh   Daten Kanal C
PIO_Ctl	equ	0fah			; FAh   Steuerwort
;
;PIO_BA	equ	0c1h			; Betriebsart
					; Kanal A bidirektional, Handshake Kanal C
;					; Kanal B als Ausgabe
PIO_BA	equ	0C4h			; Betriebsart
					; Kanal A bidirektional modus2, Handshake Kanal C
;					; Kanal B als Ausgabe modus 1, C1-C2 Handschake
						
;
; AVR Befehle
;
AVRres	equ	00h			; Spur 0 Sektor 0 ansteuern
SetSpur equ	10h			; Spurnummer setzen
SetSekt equ	20h   			; Sektornummer setzen
Rdsekt	equ	30h			; Daten vom aktuellen Sektor lesen
Wrsekt	equ	40h			; Daten in den aktuellen Sektor schreiben
v24tx   equ	50h			; ein byte senden
v24rx	equ	60h			; ein byte empfangen
v24echo	equ	70h			; avr im echo-modus			;
AVRstat	equ	0F0h			; Status ermittel
;
;
;-----------------------------------------------------------------------------
;
; Vorspann Parameterbereich
;
; Monitorprogramme  
;  
CI	EQU 0043h 	; CI 	Tastaturabfrage wartet auf Taste ASCII(A)    
CO	EQU 0049h  	; CO 	Bildschirmausgabe ASCII(C) Ziel (UPDATE)
LOM	EQU 004Fh	; LO 	Drucker über RS232	          
CSTS	EQU 0052h  	; CSTS	Tastaturstatus Taste Z=0, k.Taste Z=1  	          
FILL	EQU 0085h  	; FILL  Speicher mit Konstante füllen SRCBEG,SRCEND,DSTBEG        
COPYM	EQU 0088h  	; COPY  Speicherbereich verschieben 
onesec	EQU 001bh	; Wartezeit 1Sekunde
dely1	EQU 000bh	;           1ms
;
BELPOR	EQU 52h		; Port für Summer 
BYTFF	EQU 1Ah		; PORT FF auf Singel-Step-Modul
COMREG	EQU 48h		; Register Adressen
TRKREG	EQU 49h		; WD1770
SECREG	EQU 4Ah
DATREG	EQU 4BH
STATUS	EQU COMREG
CTRL	EQU 40H      
;
MOVID	EQU 1003h  	; Warmstart Videomonitor
BREAK	EQU 100Fh	; Unterbrechung mit CTRL-C
PARIN	EQU 1012h	;
STRING	EQU 1021h	; STRING
ERROR	EQU 1027h       ; Error Videomonitor
CLRVID	EQU 102Dh	; CLRVID  
CLRLIN	EQU 1030h	; CLRLIN        
CRSPOS	EQU 1033h	; CRSPOS         
CRSON	EQU 1036h 	; CRSON         
CRSOFF	EQU 1039h	; CRSOFF
BYTOT	EQU 103Fh	; BYTOT  (A) zweistellig darstellen Adresse (HL) 
BYTBIN	EQU 1042h	; BYTBIN (A) achtstellig Bitmuster
ADROT	EQU 103ch	; (DE) vierstellig ausgeben
CRLF	EQU 137bh	; gibt CR/LF aus
;
; Exteren Programme
;
FDC	EQU 2000h	; Floppy 
EDIT	EQU 7000h	; Editor
ASS:	EQU 6000h	; Assembler
DISSK	EQU 6C00h	; Disassembler
;
STACK	EQU 2F00H	; 
TRAP	EQU 2F8Ch
RST55	EQU 2F98h
RST551	EQU 2F99h
;
HORDSP	EQU 2E50h	; 40/80 Zeichen pro Zeile
BEGIN	EQU 2E54h	; Anfangsadresse letzte Zeile
UPDATE	EQU 2E56h	; aktuelle Cursorposition
;
SRCBEG	EQU 2FBFh	; Startadresse
SRCEND	EQU 2FC1h	; Endadresse
DSTBEG	EQU 2FC3h	; Anfang Zieladresse/Parameter
DSTEND	EQU 2FC5h	; 
LINZ	EQU 2E54h
;
VIDBEG	EQU 3000h	; Bildschirmadresse 	oben links
VIDEND	EQU 377Fh	; 			unten rechts
PRTFLG	EQU 37AFh	; 
RAMBEG	EQU 37B0h	; Anfang Parameterbereich Videomonitor

;
; Buffer Adressen
;
BATBUF	EQU 2D00h
FDCBUF	EQU 2F70h
CPYBUF	EQU 9000h
buffer	equ 0A000h	; ACII-Buffer
;
	ORG FDCBUF

TRKNR:	DS 1h		; Spurnummer
SECNR:  DS 1h		; Sektornummer
SIDNR:	DS 1h		; Seite 0/1
SELBYT: DS 1h		; SelectByte Bit1,2 = Laufwerksnummer
SELOUT: DS 1h
TRACK0: DS 4h
RWBEF:	DS 1h
DATADR:	DS 2h		; Buffer-Adresse r/w Sektoren
INTPRG:	DS 2h
RWSUB:	DS 1h
RWSUB1: DS 2h
HIBUF:	DS 2h
BUFDST: DS 1h
BUFSRC: DS 1h		; IM CF-Betrieb = Anzahl der Sektoren die übertragen werden
CPYEND: DS 1h
;
TIMOUT	EQU 32h			;
FQUARZ	EQU 06h			;
DLY100	EQU 13h			;
SECZAL	EQU 16			;
SECLDD	EQU 1			; 256 Bytes
;INTON	EQU 1Eh			; RST 5.5 freigeben
;INTOF	EQU 1Fh			; RST 5.5 sperren
;
;


	org 08000h		; Testadresse
;
kstart:	jmp kalt		; Testprogramm
wstart:	jmp warm		;
	jmp wr			; 1 Byte senden
	jmp rd			; empfangen
	jmp lpt			; LPT-Modus
	jmp ff			; Seitenvorschub
	jmp 0000h
	jmp 0000h
	jmp 0000h
ende:	call onesec		;
	jmp  movid		; zurueck zum Monitor
		
		
;-----------------------------------------------------------------------------
;
kalt:	call pioinit
	call cfinit
	cpi  01h		; Fehler
	jz   wende		;
warm:	lxi  h,meld1
	call string
	jmp  ende

;
wr:	lxi  h,meld2		; Meldung
	call string		;
	mvi  a,0ffh		; 
wloop:	inr  a
	cpi  0ffh
	jz   wende
	out  pio_b
	call bytbin	
	call onesec		; warten
	mvi  c,0dh		;
	call co
	jmp  wloop		;
wende: 	lxi  h,meld4		;
	call string		;
	jmp  ende
	
;

	
rd:	lxi  h,meld3		; Meldung
	call string		;
rloop:	mvi  a,v24rx		; Befehl
	call piowr		;
	call piord		;
	push psw
	call bytot
	pop  psw		;
	mov  c,a		; warten
	call co			;
	jmp  wende		;


;
rdlp:	lxi  h,meld7		; Meldung
	call string		;
rdlp1:	call piord		;
	mov  c,a
	call bytot
	call co			;
	mvi  c,0dh		; CR
	call co
	mvi  c,0ah		; LF
	call co
	call onesec
	jmp  rdlp1		;

;
LPT:	lxi  h,meld6		; Meldung
	call string		;
	lxi  h,buffer
	mvi  b,80h		;
lpt_l:	mov  a,m		;
	out  pio_b		;
	inx  h
	dcr  b
	jnz  lpt_l		;
	mvi  a,0dh		; CR
	out  pio_b
	mvi  a,0ah		; lf
	out  pio_b
	jmp  wende		;	
	
ff:	lxi  h,meld8		; Meldung
	call string		;
	mvi  a,0ch		; Form feed
	out  pio_b		;
	jmp  wende		;
;	
	dw 0000h
	dw 0000h
	dw 0000h
	dw 0000h
	dw 0000h
	dw 0000h
		
;	
;-----------------------------------------------------------------------------
;
; PIO Initialisieren mit Betriebsart
; Kanal A bidirektional
; Kanal C Handshake
; Kanal B Ausgabe
;
pioinit:	push	psw		; PIO Betriebsart einstellen
		mvi	a,PIO_BA	; PIO_BA	equ	0c1h
		out	PIO_Ctl		; 
		xra	a		;
		out	pio_b		;
		pop	psw		;
		ret			;
;
;---------------------------------------------------------------------------
;
; PIO-A lesen (A)
; wartet bis Daten bereitstehen 

piord:		in	PIO_C		; Status ermitteln
		ani	00100000b	; IBF maskieren
		jz	piord		; warte auf Daten
		in	PIO_A		; daten lesen
		ret			; (A) Daten
;
; (A) PIO-A schreiben
; 

piowr:		push	psw		;
pio_sts:	in	PIO_C		; Status ermitteln
		ani	10000000b	; /OBF maskieren
		jz	pio_sts		; warten auf Quittung /ACK
		pop	psw
		out	PIO_A		; Daten schreiben
		ret			; 
;
;-------------------------------------------------------------------------
;
; cfinit = Reset Befehl an CF-Karte
;          
;
cfinit:		call	pioinit		; PIO und AVR initialisieren
		mvi	a,avrres	; Test ob CF-Erweiterung vorhanden ist;
		call	piowr		;
		xra	a		;
		call	piord		;
		cpi	00h		; 	
		jnz	cferr		; CF nicht bereit -> Fehler
		ret			; CF-Interface OK
;
; avr_stat = Status CF-Karte ermitteln 0=OK
;            sonst Fehlermeldung
;
avr_stat:	mvi	a,avrstat	; Status AVR ermitteln
		call	piowr		; 
		call	piord		;
		cpi	00h		;
		jnz	cferr1		; Driver Error
		ret			;

;
cferr:		lxi	h,errmsg1	; Fehlermeldung 
		call	string		; CF nicht bereit
		mvi	a,01		;
		ret
		
cferr1:		lxi	h,errmsg	; Lese/schreibfehler
		mvi	a,27h		;
		call	error
		jmp	ende
		
		
;---------------------------------------------------------------------
; Texte
;
meld1:	DB 0Dh			; CR
	DB 0Ah			; LF     
	DB "V24-Test"
	DB 0Dh			; 
	DB 00h
;
meld2:	DB 0Dh			; CR
	DB 0Ah			; LF     
	DB "1 Byte senden"
	DB 0Dh			; 
	DB 00h
;
meld3:	DB 0Dh			; CR
	DB 0Ah			; LF     
	DB "1 Byte"
	DB " empfangen"
	DB 0Dh			;
	DB 00h	 
;
meld4:	DB 0Dh			; CR
	DB 0Ah			; LF     
	DB "Ende"
	DB 0Dh			;
	DB 00h	 
;	
meld5:	DB 0Dh			; CR
	DB 0Ah			; LF     
	DB "Fehler"
	DB 0Dh			;
	DB 00h	
	
meld6:	DB 0Dh			; CR
	DB 0Ah			; LF     
	DB "LPT-"
	db " Modus"
	DB 0Dh			; 
	DB 00h		 

meld7:	DB 0Dh			; CR
	DB 0Ah			; LF     
	DB "PIO lesen"
	db " endlos"
	DB 0Dh			;
	DB 00h	 	
	
meld8:	DB 0Dh			; CR
	DB 0Ah			; LF     
	DB "LPT-"
	db " FF ausgeben"
	DB 0Dh			; 
	DB 00h	 

errmsg: DB 0Dh			; CR
	DB 0Ah			; LF     
	DB "Error F0"
	DB 0Dh			;
	DB 00h	 
	
errmsg1: DB 0Dh			; CR
	DB 0Ah			; LF     
	DB " CF-Karte "
	db "nicht vorhanden"
	DB 0Dh			;
	DB 00h	 
		
;
