'
' CF-Interface
' AVR-Teil
'
' ECB-Karte fr Moppel 8085
' W.Rmer 04.2016
'
'
' Status:
'  04.04.2016 Quellcode bereinigt, letzte Tests
'  31.03.2016 string von Moppel uebnehmen und an V24 senden
'  09.03.2016 string ueber buffer lesen und an Moppel senden
'  06.03.2016 v24 byte lesen/schreiben und Status mit Handshake RTS/CTS
'  08.02.2016 Test
'  04.02.2016 RS232 ankoppeln
'
'  12.04.2015 RS232 mit Handshake und 20Byte Buffer
'  08.04.2015 Timing Strobesignal verlngert
'             RDBYTE berichtigt
'  08.03.2015 MCS-Bootloader eingerichtet
'  07.03.2015 Initialisierung vereinfacht
'              nur noch Befehl [00] AVR-Reset
'              bergibt den Status aus [Berror]
'              Printanweisungen sind nun ber [Testflg]=0 abschaltbar
'
'  01.03.2015 Datenaustausch auf 512Byte (Sektorweise) erweitert
'     CF-Karte(4MB) im PC formatiert und ein 2MB CP/M Datenbereich angelegt
'     SektorOffset (ab Sektor 128) mu entsprechend angepasst werden,
'     damit der FAT-Bereich nicht von CP/M beschrieben wird.
'
'
'  26.02.2015 CF-Routinen eingebunden (rw-Sektor)
'  15.02.2015 Grundroutinen Spur,Sektor setzen, lesen und schreiben
'  04.02.2015 Testroutinen lesen/schreiben
'  03.02.2015 Programmstrukturen fuer Pollingbetrieb festgelegt
'              Adressen A0,A1 z.Zt. nicht notwendig
'  29.05.2014 Testprogramm Datenaustausch AVR <->ECB
'
' BOOTSZ  1024words Adresse $7C00
' Bootrst x
'
' FUSES: Extended 0xff
'        High     0xDC
'        Low      0xff
'
'        Lockbit  0xff
'
' !Anmerkung JTAG muss abgeschaltet sein, belegt sonst PortC
'
'
'-----------------------------------------------------------------------------
'
'  Konzept: ECB-Karte mit 8255PIO fr den Datenaustausch
'           CF-Seite mit Atmega644p AVR-DOS fr die Verwaltung der CF-Karte
'
'           PIO Kanal A arbeitet in Betriebsart 2 (bidirektional)
'           Handshake ber Kanal C
'
'           PIO Kanal B als Ausgabe fr die Adressen A0 und A1
'           Diese bildet der AVR als Registersatz
'           fr den Befehl/Datenaustausch ab
'
'  ! Read/Write immer aus Sicht ECB/Moppel
'
'
'  Handshake:
'
'     PIO   <---------------------------------------> AVR
'
' Aktion Signal  PIN                            PIN  Richtung  Aktion
'
' Senden  /OBF   PC7  ECB-Daten vorhanden        D2    >>      Daten im
'                      ------      ----                        Ausgangsbuffer
'                           I      I
'                           --------
'         /ACK   PC6  Daten von AVR uebernommen  D4    <<      Empfangsquittung
'                      --------   ------
'                             I   I
'                             -----
'                               ^
'                               I Daten lesen
'
'
' Empfang  IBF   PC5  AVR-Daten vorhanden        D3    >>      Empfangsbereit
'                      ------           ----
'                           I           I
'                          -------------
'          /STB   PC4  Daten bernehmen           D5    <<      Daten senden
'                            --------   ------
'                                   I   I
'                                   -----
'   /ACK, /STB auf 5s eingestellt
'   max Datenrate ca. 25kB/sek
'   (ohne Overhead)
'                                                 '
'
'  ECB-PIO Adressen
'
'     CAh   Daten Kanal A
'     DAh   Daten Kanal B
'     EAh   Daten Kanal C
'     FAh   Steuerwort
'
' PIO-Kanal C lesen (FAh) Handshake
'
'  D7 D6 D5 D4 D3 D2 D1 D0
'  .  .  .  .  .  .  .  .
'  .  .  .  .  .
'  .  .  .  .  .
'  .  .  .  .  1 = INTRa   Interrupt (ISR muss Bit4-7 auswerten)
'  .  .  .  .
'  .  .  .  0 = /STBa      positive Flanke ldt Daten ins Eingangsregister
'  .  .  .
'  .  .  1 = IBFa          logisch 1 zeigt an, das Daten ins Eingangsregister
'  .  .                    geladen sind (AVR muss dies vor dem Senden auswerten
'  .  .                    wenn 0, darf mit /STB ein Byte gesendet werden)
'  .  .
'  .  .
'  .  0 = /ACKa            logisch 0 stellt die Daten ins Ausgangsregister
'  .                       sonst hochohmig
'  0 = /OBFa               logisch 0, Daten stehen im Ausgangsbuffer bereit
'                          und knnen vom AVR mit /ACK abgeholt werden
'
'
' Befehle ans Controlregister (in Anlehnung an Moppel FDC und BIOS)
'
'  Reset    00h   Spur 0 Sektor 0 ansteuern
'  Status   F0h   Status der letzten Aktion
'  SetSpur  10h   Spurnummer setzen
'  SetSekt  20h   Sektornummer setzen
'  DatRD    30h   Daten vom aktuellen Sektor lesen
'  DatWR    40h   Daten in den aktuellen Sektor schreiben
'
' Befehle fuer V24
'
'  v24open     50h   noch nicht implementiert
'  v24close    51h   noch nicht implementiert
'  V24tx       52h   Daten senden (aus Moppelsicht)
'  V24rx       53h   Daten Empfangen
'  V24strtx    54h   String senden (einschliesslich CR + 00h)
'  v24strrx    55h   String empfangen (einschliesslich CR + 00h)
'
'  V24stat     5fh   Status der V24 ermittel
'                       Bit 0 CTS Signal
'                       Bit 1 RTS Signal
'                       Bit 5 Senderegister leer
'                       Bit 7 Empfangsregister voll
'
'-----------------------------------------------------------------------------
$regfile = "m644def.dat"

$crystal = 11059200

$hwstack = 128
$swstack = 128
$framesize = 128
'
Dim Testflg As Boolean                ' Test-Flag unterdrckt Print
Testflg = 0                            ' 0 = ohne print
' $sim                                 ' fuer BASCOM Simulator
'
'-----------------------------------------------------------------------------
' CF Interface
'
$include "Config_CompactFlash_M128.bas" ' Portzuweisungen
'
Dim Berror As Byte                      '
Dim Abuffer(512) As Byte                ' Sektorbuffer
Dim Wsrampointer As Word                ' Zeiger fr Buffer
Dim Lsectornumber As Long               ' Sektor-Nr. im Zugriff
Dim Ph_sektor As Long                   ' physikalischer Sektor
Dim Ph_sekrest As Long                  ' Teilrest aus Umrechnung
'
Dim Cpm_daten As Long                   ' 1. Moppel CP/M Sektor
'
' Parameter fr 1GB-Karte mit 8MB CP/M Datei
' Startsektor (Offset) muss pro Karte einmal ermittelt werden
' z.B. mit Hex-Editor von
' www.mh-nexus.de
'
' hier Sektor 615 = 1.Sektor innerhalb der 8MB Datei
'
'
Cpm_daten = 615                        '
'
'-----------------------------------------------------------------------------
'
' V24 Definitionen
'
$baud = 38400

Config Portd.7 = Output                ' RTS
Rts Alias Portd.7
Config Portd.6 = Input                 ' CTS
Cts Alias Portd.6

' Buffer
'
const maxbuff = 64                      ' Buffer Groesse Moppelbuffer
const rtsbuff = 48                      ' Fuellgrad bis RTS gesetzt wird
dim v24buff(maxbuff) as byte            ' Buffer

dim v24dat as Byte                      ' Daten von/an V24
dim v24bfuell as byte                   ' Fuellstandsanzeige fuer Buffer
dim v24dflg as bit                      ' Flag Daten V24 vorhanden
dim v24eflg as bit                      ' Flag Zeilenende
dim wrbz as byte                        ' Zeiger schreiben
dim rdbz as byte                        ' Zeiger lesen

' irq

on urxc rx_isr
on utxc tx_isr

'------------------------------------------
' Portdefinitionen
'
' Port A = Datenaustausch CF
' Port B = Steuerung CF
' Port C = Datenaustausch ECB
' Port D = Steuerung ECB
'
' Daten ECB
Config Portc = Input
'
' Handshake ECB
'
Config Portd.2 = Input
Config Portd.3 = Input
Config Portd.4 = Output
Config Portd.5 = Output
'
Hs_obf Alias Pind.2                     ' /OBF                              '
Hs_ibf Alias Pind.3                     ' IBF
Hs_ack Alias Portd.4                    ' /ACK
Hs_stb Alias Portd.5                    ' /STB
'
' Unterprogramme fr Datenaustausch ECB
'
Declare Sub Init                        ' Datenaustausch testen
Declare Sub Ecb_rdbyte                  ' 1Byte lesen
Declare Sub Ecb_wrbyte                  ' 1Byte lesen
Declare Sub Avr_reset                   ' CF-Karte Reset
Declare Sub Avr_status                  ' Status ermitteln
Declare Sub Ecb_settr                   ' Spur setzen
Declare Sub Ecb_setsek                  ' Logischen Sektor setzen
Declare Sub Ecb_wrsek                   ' Sektor (512Byte) schreiben
Declare Sub Ecb_rdsek                   ' Sektor (512Byte) lesen
Declare Sub Calc_sektor                 ' physikalischen Sektor berechnen
'
Declare Sub V24_status
Declare Sub V24_btx                     ' 1 Byte senden
Declare Sub V24_brx                     ' 1 Byte empfangen
Declare Sub V24_strtx                   ' String senden
Declare Sub V24_strrx                   ' String empfangen
'
'
' Registersatz fr Handshake ECB
'
'
Dim In_tmp As Byte                      ' Eingabedaten von Moppel
Dim Out_tmp As Byte                     ' Ausgabedaten an Moppel
'
Dim Statin As Bit                       ' /OBF
Dim Statout As Bit                      ' /STB
'
Dim Ecb_track As Long                   ' Spurnummer
Dim Ecb_sektor As Long                  ' Sektornummer
'
Dim Z_bytesek As Long                   ' Byte-Zaehler fuer
'                                                    Sektor lesen/schreiben
'
' AVR Befehle
'
Const Avrres = &H00
Const Setspur = &H10
Const Setsek = &H20
Const Rdsek = &H30
Const Wrsek = &H40
Const Avrstat = &H0F0
Const V24stat = &H5F
Const V24btx = &H52
Const V24brx = &H53
Const V24strtx = &H54
Const V24strrx = &H55
'
'=============================================================================
'
' Hauptprogramm
'
' Karte initalisieren
' Interpretiert die Befehle und zweigt dann in die Routinen ab
' In den Unterroutinen werden dann die nachfolgenden Parameter/Bytes
' abgehandelt
'
If Testflg = 1 Then                     '
   Print "CF-Interface"
End If

Gbdriveerror = Driveinit()              ' CF Initialisieren

Print "CF-Interface V2.0"

If Gbdriveerror <> 0 Then

   If Testflg = 1 Then
      Print "Error during Drive Init: " ; Gbdriveerror
   End If

   Berror = Gbdriveerror        ' Fehler wird in der Statusabrage uebermittelt


End If

Call Init
   If Testflg = 1 Then
      Print "warten auf Befehle"
   End If

Do                                  ' Schleife fr "Befehlsinterpreter"

      Call Ecb_rdbyte

'      If Testflg = 1 Then
        Print "Befehl: " ; In_tmp
'      End If

      Select Case In_tmp
         Case Avrres
            Call Avr_reset              ' Reset
         Case Setspur
            Call Ecb_settr              ' Spur setzen
         Case Setsek
            Call Ecb_setsek             ' Sektor setzen
         Case Wrsek
            Call Ecb_wrsek              ' Sektor schreiben
         Case Rdsek
            Call Ecb_rdsek              ' Sektor lesen
         Case Avrstat
            Call Avr_status             ' CF-Status ausgeben
         Case V24stat
            Call V24_status             ' V24 Status ausgeben
         Case V24btx
            Call V24_btx                ' ein Byte senden
         Case V24brx
            Call V24_brx                ' ein Byte empfanden
         Case V24strtx
            Call V24_strtx              ' String senden
         Case V24strrx
            Call V24_strrx             ' Zeile empfangen

      End Select

Loop
'
'=============================================================================
'
' Daten lesen (AVR-Sicht)
'
Sub Ecb_rdbyte
   Config Portc = Input

   Do                                   ' warten auf Daten
   Loop Until Pind.2 = 0                ' /OBF = 0

   Reset Hs_ack                         '
   Waitus 2
   In_tmp = Pinc                        '  Daten lesen
   Waitus 2                             ' /ACK Quittung
   Set Hs_ack
'
'
End Sub
'
' Daten schreiben (AVR-Sicht)
'
Sub Ecb_wrbyte
   Config Portc = Output

   Do                                   ' warten auf Bereit
   Loop Until Pind.3 = 0                ' IBF = 0

   Portc = Out_tmp                      ' Daten ausgeben
   Waitus 1
   Reset Hs_stb
   Waitus 1                             ' /STB ausgeben
   Set Hs_stb

End Sub
'
'
'-----------------------------------------------------------------------------
'
Sub Init

   Set Hs_ack                                     ' /ACK Quittung
   Set Hs_stb                                     ' /STB Datenbesttigen

End Sub
'
'-----------------------------------------------------------------------------
'
'
Sub Avr_reset

    Ecb_track = 0                  ' CF-Karte
    Ecb_sektor = 0

    wrbz = 1                       ' V24 Zeiger schreiben
    rdbz = 1                       ' V24 Zeiger lesen


    Berror = Drivereset()
    Out_tmp = Berror
    Call Ecb_wrbyte

    If Testflg = 1 Then
      Print "Reset" ; Berror
    End If

End Sub
'
' Status ausgeben
'
Sub Avr_status

    Out_tmp = Berror
    Call Ecb_wrbyte

    If Testflg = 1 Then
       Print "Fehlercode : " ; Berror ; " -- " ; Gbdriveerror
    End If

End Sub
'
'-----------------------------------------------------------------------------
'
' Spur setzen
'
Sub Ecb_settr

   Call Ecb_rdbyte
   Ecb_track = In_tmp

End Sub
'
' Sektor setzen
'
Sub Ecb_setsek

   Call Ecb_rdbyte
   Ecb_sektor = In_tmp
   Call Calc_sektor

End Sub
'
' Sektor schreiben aus ECB Sicht(512 Byte)
'
Sub Ecb_wrsek
'
' Buffer fllen
   Z_bytesek = 1                        ' Startwert
   Do

      Call Ecb_rdbyte

      Abuffer(z_bytesek) = In_tmp
      Z_bytesek = Z_bytesek + 1         ' naechstes Byte

   Loop Until Z_bytesek = 513
'
' Buffer in CF-Sektor schreiben

   Wsrampointer = Varptr(abuffer(1))
   Lsectornumber = Ph_sektor
   Berror = Drivewritesector(wsrampointer , Lsectornumber)

   If Testflg = 1 Then
      Print "WR Sektor"
      Print "Spur:   " ; Ecb_track
      Print "Sektor: " ; Ecb_sektor
      Print "Physikalischer Sektor : " ; Ph_sektor
      Print "----------"
      Waitms 100
   End If

 End Sub
'
' Sektor lesen aus ECB Sicht(512 byte)
'
Sub Ecb_rdsek

' CF-Sektor in Buffer ablegen

   Wsrampointer = Varptr(abuffer(1))
   Lsectornumber = Ph_sektor
   Berror = Drivereadsector(wsrampointer , Lsectornumber)

  '  Buffer nach Moppel bertrageb
   Z_bytesek = 1
   Do

      Out_tmp = Abuffer(z_bytesek)
      Call Ecb_wrbyte
      Z_bytesek = Z_bytesek + 1         ' naechstes Byte


   Loop Until Z_bytesek = 513


   If Testflg = 1 Then
      Print "RD-Sektor"
      Print "Spur:   " ; Ecb_track
      Print "Sektor: " ; Ecb_sektor
      Print "Physikalischer Sektor : " ; Ph_sektor
      Print "----------"
      Waitms 100
   End If

End Sub

'
' physikalischen Sektor berechnen
' Floppyformat:
'
'   32 logische Sektoren/Track  (16 physikalische Sektoren a 256Byte)
'   80 Spuren
'
' ph_sektor = (Track * Sektor/Track) + log Sektor + Offset
'                                      :              :
'                                      :              erster Sektor CP/M
'                                      :              im Datenbereich
'                                      aus Befehl Ecb_setsektor
'
'
'
Sub Calc_sektor

   Ph_sektor = Ecb_track * 16           ' Physikalische Sektoren/Track
   Ph_sektor = Ph_sektor + Ecb_sektor   ' aktueller Sektor
   Ph_sekrest = Ph_sekrest Mod 2
   Ph_sektor = Ph_sektor / 2
   Ph_sektor = Ph_sektor + Ph_sekrest
   Ph_sektor = Ph_sektor + Cpm_daten    ' Offset fr CP/M Bereich

End Sub
'
'-----------------------------------------------------------------------------
'
' V24 Unterprogramme
'
' V24Status an Moppel senden
'
Sub V24_status
'
    Dim Stport As Byte
    Dim Streg As Byte                   ' Status Port
                                         ' Status Register
    Stport = Pind
    Stport = Stport And &B11000000      ' rst,cts maskieren
    Rotate Stport , Left
    Rotate Stport , Left                ' in bit 0,1 verschieben

    Streg = Usr
    Streg = Streg And &B10100000        ' rxc, udre maskieren

    Out_tmp = Streg Or Stport

    Call Ecb_wrbyte                     ' bit7=RXC, bit5=UDRE
'
End Sub
'
' ein Byte an V24 senden
'
Sub V24_btx                             '

   Call Ecb_rdbyte
   $timeout = 10000

   Do
   Loop Until Pind.6 = 0                ' warten auf cts-freigabe

   Do
   Loop Until Usr.udre0 = 1             ' warten bis Senderegister leer ist

   Print Chr(in_tmp);

End Sub
'
' ein Byte von V24 empfangen
'
Sub V24_brx                             '


   Reset Rts
   $timeout = 10000
   Do                                   ' Warten auf Daten
   Loop Until Usr.rxc0 = 1

   Out_tmp = Udr
   Set Rts
   Call Ecb_wrbyte

   If Testflg = 1 Then
      Print Chr(out_tmp)
   end if

End Sub
'
' ASCII Zeile empfangen bis CR
'
Sub V24_strrx

   wrbz = 1                        ' Schreib-Zeiger auf erste Position
   rdbz = 1                        ' Lesezeiger auf 1. Position
   v24bfuell = 0                   ' Fuellstand auf 0
   reset v24dflg
   reset v24eflg
   enable urxc
   enable interrupts
   reset rts

   do

   if v24dflg = 1 then

      disable urxc

      while v24bfuell >= 1
         out_tmp = v24buff(rdbz)   ' Bufferinhalt nach Moppel schieben
         call ecb_wrbyte
         incr rdbz
         decr v24bfuell
      wend      '

      if v24eflg = 1 then          ' Zeilenende gefunden (CR)

         printbin out_tmp

         wrbz = 1
         rdbz = 1
         v24bfuell = 0
         disable interrupts
         reset v24eflg
         reset v24dflg
         exit do                    ' Ende der Datenuebertragung
      end if

      reset v24dflg
      enable urxc
      reset rts

   end if

   loop

End Sub
'
' ASCII Zeile senden bis CR
'
Sub V24_strtx                           '

   Wrbz = 1                             ' Schreib-Zeiger auf erste Position
   Rdbz = 1                             ' Lesezeiger auf 1. Position
   V24bfuell = 0                        ' Fuellstand auf 0
   Reset V24dflg
   Reset V24eflg
   Enable Utxc
   Enable Interrupts

   Do

      While V24eflg = 0

         If Wrbz < Maxbuff Then
            Call Ecb_rdbyte

            V24buff(wrbz) = In_tmp      ' Mopeldaten in Buffer schieben

            If In_tmp = 13 Then         ' CR
               Set V24eflg
            End If

            Incr Wrbz
            Incr V24bfuell
         Else                           ' Bufferueberlauf
            Incr Wrbz
            V24buff(wrbz) = &H0D        ' Buffer mit CR
            Set V24eflg
         End If

      Wend                              '


   Loop Until V24eflg = 1               ' Buffer gefuellt

   while V24bfuell > 0                   ' Warten bis ISR Buffer gesendet hat
         waitms 1
   wend

   Disable Utxc             ' IRQ sperren sobald letztes Byte
   Disable Interrupts      ' Uebertragen wurde


End Sub
'
'
'=============================================================================
'
' Interrupt Service Routinen
'
'
' Daten von V24 in Buffer schreiben bis CR
'
rx_isr:

   v24dat = udr

   if wrbz < maxbuff then           ' Test auf Bufferende

      if v24bfuell = rtsbuff then           ' Bufferueberlauf verhindern
         set rts
      end if

      printbin v24dat

      if v24dat = 13 then           ' CR noch anfuegen
         set rts
         v24buff(wrbz) = v24dat
         incr v24bfuell
         set v24eflg                 ' Ende-Flag setzen

      else
         v24buff(wrbz) = v24dat
      end if

      incr wrbz                     ' Zeiger
      incr v24bfuell                ' Fuellstandsanzeige aktualisieren

   else

        set rts
         v24buff(wrbz) = &H0D       ' Buffer mit CR und ...
         incr v24bfuell
         set v24eflg                 ' Ende-Flag setzen

   end if

   set v24dflg

return
'
' Daten aus Buffer an V24 senden
'
tx_isr:

   If V24bfuell > 0 Then               ' Test Lesezeiger < Schreibzeiger

      if cts = 0 then                  ' Empfnger betriebsbereit ?

         Udr = V24buff(rdbz)
         Incr Rdbz
         Decr V24bfuell

      end if

   else

   End If

return
'
'
'=============================================================================
'
'
End                                     'end program