;	Remcon --- Remot Console for 2nd Host
;	Written by W.A.Kobler  KW821128
;
	ORG	100H
;
SVC	EQU	0005H
MDATA	EQU	0E0H
MSTAT	EQU	0E1H
;
	LD      SP,200H
;
;Signon Message to statusline
;
	CALL 	SIGNON
BEGIN:
	LD  	B,10
;
; Check for input from remote
;
LOOP:
	IN 	A,(MSTAT)
	AND 	1
	JP	NZ,REMIN
	JP	TERMIN
;
;Read character from remote
;
REMIN:
	IN	A,(MDATA)
	AND	07FH
	CALL	TERMOUT
	JP	LOOP
;
;Look for input from keyboard
;
TERMIN:
	LD	C,6
	LD	E,0FFH
	PUSH	BC
	CALL	SVC
	POP	BC
	AND	07FH
	CP	0
	JP	Z,BEGIN
	CP	3
	JP	Z,SIGNOF
	CALL	REMOUT
	CALL	TERMOUT
	JP	LOOP
;
;Echo character to screen
;
TERMOUT:
	LD	C,2
	LD	E,A
	PUSH	BC
	CALL	SVC
	POP	BC
	RET
;
;Echo character to remote
;
REMOUT:
 	LD	C,A
R1:
	IN	A,(MSTAT)
	AND	04
	JP	Z,R1
	LD	A,C
	OUT	(MDATA),A
	RET
;
;Signonmessage to statusline
;
SIGNON:
	LD	C,09H
	LD	DE,ONMSG
	CALL	SVC
	RET
ONMSG:
	DEFB	1BH
	DEFB	6DH
	DEFB	30H
	DEFM	' KW SYSTEM'
	DEFB	84H
	DEFM	'65'
	DEFB	80H
	DEFM	'CONSOLE ONLINE    '
	DEFB	0CH
	DEFB	10H
	DEFB	00H
	DEFB	17H
	DEFB	24H
;
SIGNOF:
	LD	C,09H
	LD	DE,OFMSG
	CALL	SVC
	JP 	0H
OFMSG:
	DEFB	1BH
	DEFB	6DH
	DEFB	30H
	DEFM	' KW SYSTEM 80 CONSOLE ONLINE    '
	DEFB	0CH
	DEFB	10H
	DEFB	00H
	DEFB	17H
	DEFB	24H
;
;
	END
