   title eraq
;
;CP/M Functions
CPM	EQU	0
TPA	EQU	CPM+100H
BDOS	EQU	0005H
FCB1	EQU	005cH
FC2	EQU	006cH
CBUF	EQU	0080H
;
CONIN	EQU	1	;Consol input to (A)                    
CONOUT	EQU	2	;Send char in (E) to con                
LSTOUT	EQU	5	;Printer output from (E)                
PRTBUF	EQU	9	;Print string pointed to by (DE)        
			;       end the string with '$'         
RDBUF	EQU	10	;read consol line into buffer (DE)      
CONSTAT	EQU	11	;Get consol status                      
VERS	EQU	12	;Get CP/M version number                
;
SELDSK	EQU	14	;Log-in a new disk                      
OPENF	EQU	15	;Open a file, FCB in (DE)               
CLOSEF	EQU	16	;Close a file, FCB in (DE)              
SRCHF	EQU	17
SRCHN	EQU	18
DELETF	EQU	19	;Erase a file, FCB in (DE)              
READF	EQU	20	;Read a file sector, FCB in (DE)        
WRITEF	EQU	21	;Write a file sector, FCB in (DE)       
MAKEF	EQU	22	;Make a new file, FCB in (DE)           
SETDMA	EQU	26	;Set the DMA (Disk I/O addr. (DE)       
COMPSZ	EQU	35	;Compute a file's size                  
SETRAND	EQU	36	;Position for random I/O                
;
;Useful quates                                                               
;                                                               
CR	EQU	0DH	;ASCII carriage return character        
LF	EQU	0AH	;ASCII line feed character              
ESC	EQU	1bH
EOF	EQU	1aH
BELL	EQU	07H
BS	EQU	08H
TAB	EQU	09H
FF	EQU	0CH	;ASCII form feed character		
;
TRUE	EQU	0ffH
FALSE	EQU	00H
;
SETATR	EQU	1eH	;change file attribute bits
	;
	org 0100h
eraq:	lda	fcb1+1
	cpi	' '
	cz	allfile
	lxi	d,dmabuf
	mvi	c,setdma
	call	bdos
	lxi	d,fcb1
	mvi	c,srchf
	call	bdos
	inr	a
	jz	fin
eraq0:	dcr	a
	add	a
	add	a
	add	a
	add	a
	add	a
	lxi	h,dmabuf
	mvi	d,0
	mov	e,a
	dad	d
	xchg
	lhld	dirptr
	mvi	c,32
lp1:	ldax	d
	mov	m,a
	inx	h
	inx	d
	dcr	c
	jnz	lp1
	shld	dirptr
	lda	dircnt
	inr	a
	sta	dircnt
	lxi	d,fcb1
	mvi	c,srchn
	call	bdos
	inr	a
	jnz	eraq0
	;
	lxi	h,buffer
	shld	dirptr
disp0:	mvi	a,8
	push	h
disp1:	inx	h
	call	sendstrg
	push	h
	mvi	e,'.'
	call	output
	pop	h
	mvi	a,3
lp2:	call	sendstrg
	;
	mvi	e,' '
	call	output
	mvi	e,' '
	call	output
	pop	h
	lxi	d,9
	dad	d
	mov	a,m
	rlc
	jnc	disp2
	mvi	a,true
	sta	roflg
disp2:	inx	h
	mov	a,m
	rlc
	jnc	disp3
	mvi	a,true
	sta	sysflg
disp3:	lda	roflg
	mov	b,a
	lda	sysflg
	ora	b
	jnz	disp7
	mvi	e,tab
	call	output
	jmp	disp6
disp7:	mvi	e,'('
	call	output
	lda	roflg
	ora	a
	jz	disp4
	lxi	d,ro
	call	strout
disp4:	lda	roflg
	ora	a
	jz	disp8
	mvi	e,','
	call	output
disp8:	lda	sysflg
	ora	a
	jz	disp5
	lxi	d,sys
	call	strout
disp5:	mvi	e,')'
	call	output
disp6:	lxi	d,msg1
	call	strout
	mvi	c,conin
	call	bdos
	push	psw
	call	crlf
	pop	psw
	ani	5fH
	cpi	3
	jz	fin
	cpi	'Y'
	cz	erase
	mvi	a,false
	sta	roflg
	sta	sysflg
	lda	dircnt
	dcr	a
	sta	dircnt
	jz	fin
	lhld	dirptr
	lxi	d,32
	dad	d
	shld	dirptr
	jmp	disp0
	;
erase:	lhld	dirptr
	lda	fcb1
	mov	m,a
	lda	roflg
	ora	a
	jz	eras1
	push	h
	lxi	d,9
	dad	d
	mov	a,m
	ani	7fh
	mov	m,a
	pop	h
	push	h
	xchg
	mvi	c,setatr
	call	bdos
	pop	h
eras1:	xchg
	mvi	c,deletf
	call	bdos
	lda	eracnt
	inr	a
	sta	eracnt
	ret
fin:	cpi	3
	cz	fin9
fin0:	lda	eracnt
	mvi	h,0
	mov	l,a
	lxi	b,-100
	call	cnvrt
	mov	a,e
	cpi	0
	jz	fin1
	call	prtdig
fin1:	lxi	b,-10
	call	cnvrt
	mov	a,e
	cpi	0
	jz	fin2
	call	prtdig
fin2:	mov	a,l
	call	prtdig
	lxi	d,msg2
	mvi	c,prtbuf
	call	bdos
	jmp	cpm
fin9:	lxi	d,msg3
	mvi	c,prtbuf
	call	bdos
	ret
	;
sendstrg:
	push	psw
	push	h
	mov	a,m
	ani	7fh
	mov	e,a
	call	output
	pop	h
	pop	psw
	inx	h
	dcr	a
	jnz	sendstrg
	ret
	;
cnvrt:	mvi	e,-1 and 0ffh
cnvrt1:	inr	e
	dad	b
	jc	cnvrt1
	mov	a,b
	cma
	mov	b,a
	mov	a,c
	cma
	mov	c,a
	inx	b
	dad	b
	ret
	;
prtdig:	adi	'0'
	push	h
	mov	e,a
	call	output
	pop	h
	ret
	;
allfile:
	lxi	d,msg4
	mvi	c,prtbuf
	call	bdos
	mvi	c,conin
	call	bdos
	push	psw
	call	crlf
	pop	psw
	ani	5fh
	cpi	'Y'
	jnz	fin9
	lxi	h,fcb1+1
	mvi	b,11
all1:	mvi	m,'?'
	inx	h
	dcr	b
	jnz	all1
	mvi	b,24
all2:	mvi	m,0
	inx	h
	dcr	b
	jnz	all2
	ret
	;
crlf:	mvi	e,cr
	call	output
	mvi	e,lf
	call	output
	ret
	;
output:	mvi	c,conout
	call	bdos
	ret
	;
strout:	push	h
	push	d
	mvi	c,prtbuf
	call	bdos
	pop	d
	pop	h
	ret
	;
msg1:	db	tab,'Erase this file? $'
msg2:	db	' files erased.',cr,lf,'$'
msg3:	db	'Program aborted.',cr,lf,'$'
msg4:	db	'Use *.* as file match? $'
ro:	db	'R/O$'
sys:	db	'SYS$'
	;
dirptr:	dw	buffer
dircnt:	db	0
eracnt:	db	0
roflg:	db	0
sysflg:	db	0
dmabuf:	ds	130
buffer	equ	$
	end
