	title 'Character I/O handler for info-s system'

;************************************************
; 	Character I/O for info-s and CP/M 3 
;	NONBANKED VERSION
;	(c) COPYRIGHT BY G. KRAUSE 1983
;	changed 10/24/83
;       mod. KW840821
;************************************************

	MACLIB	Z80
;************************************************
;	PUBLIC LABELS
;************************************************
	public	?cinit,?ci,?co,?cist,?cost
	public	@ctbl


;************************************************
;	PORT EQUATES
;************************************************
BAUD    EQU	0EDH
PIOA	EQU	0E4H
PIOB	EQU	0E6H
CONA 	EQU	0E0H
CONB 	EQU	0E2H
V5S	EQU	41H
SC01	EQU	10H
MAXDVC  EQU	04H


	CSEG
;************************************************
;	INIT DEVICE  ADR. IN C
;************************************************
?cinit:
	MOV	A,C
	ORA	A		; TEST FOR V5
	RZ			; NO INIT REQUIRED
	CPI	MAXDVC      	; TEST FOR VALID DEVICE
	JZ      CENTINIT	; init parallel printer
	RNC			; invalid device
	CPI	03H		; TEST FOR SPEECH
	JZ	SPEECH  
	CPI	01H		; TEST FOR A-PORT
				; corrected 10/24/83
	JRNZ	INIT01		; JUMP FOR B-PORT
	MVI	B,0FH		; MASK LOW BITS
	LXI	H,PORT1
	JR	INIT02
INIT01:
	MVI	B,0F0H		; MASK HIGH BITS
	LXI	H,PORT2
INIT02:
	PUSH	H		; SAVE POINTER
	MOV	L,M
	MVI	H,0
	LXI	D,BAUDTAB
	DAD	D
	MOV	A,M
	ANA	B		; MASK 1 HALF
	MOV	C,A		; SAVE IT
	RLCR	B		; CHANGE UPPER
	RLCR	B		; TO LOWER HALF
	RLCR	B
	RLCR	B
	LDA	OLDBAUD		; GET OLD BAUD VALUE
	ANA	B		; MASK ONE HALF
	ORA	C		; ADD NEW VALUE
	STA	OLDBAUD 	; SAVE NEW BAUD VALUE
	OUT	BAUD
	POP	H		; RESTORE POINTER
	MVI	C,CONA+1	; A-PORT CONTROL
	LXI	H,IPORT1	; POINT TO PARAMETER
	MVI	B,11
	OUTIR			; LOAD DART
	MVI	C,CONB+1	; B-PORT CONTROL
	LXI	H,IPORT2
	MVI	B,11
	OUTIR
	RET
SPEECH:
	MVI	A,03FH		; STOP CODE
	OUT	SC01
	OUT	SC01
	OUT	SC01
	RET

CENTINIT:
	MVI	A,0FH
	OUT	PIOB+1
	MVI	A,0CFH
	OUT	PIOA+1
	MVI	A,00FH		; mod. KW840821 Bit4-7 out,0-3 in
	OUT	PIOA+1
	XRA	A
	OUT	PIOA
	RET

;************************************************
?ci:		; character input
;************************************************
	MOV	A,B
	ORA	A
	JZ	V5IN
	CPI    	MAXDVC
	JNC	NULL$INPUT	; can't read from centronics
	CPI	3
	JZ	NULL$INPUT	; CAN'T READ SPEECH

CI1:
	CALL	?CIST
	JZ	CI1
	DCR	C
	INP	A
;	RES	7,A		; changed 10/24/83
	RET

NULL$INPUT:
	MVI	A,01AH		; EOF 
	RET

V5IN:
	CALL	V5STAT
	JZ	V5IN
	IN	V5S-1
	RET

;************************************************
?cist:		; character input status
;************************************************
	MOV	A,B
	ORA	A
	JRZ	V5STAT
	CPI	MAXDVC 
	JNC	NULL$STATUS		; can't read from centronics
	CPI	03	
	JZ	NULL$STATUS
	MOV	L,B 
	MVI	H,0			; make device number 16 bits
	LXI	D,DATA$PORTS
	DAD	D
	MOV	C,M
	INR	C
	INP	A			; read from status port
	ANI	01
	RZ
	ORI	0FFH
	RET


V5STAT:
	IN	V5S
	ANI	2
	RZ
	ORI	0FFH
	RET


;************************************************ 
?co:	; character output
;************************************************
	MOV	A,B	
	ORA	A
	JRZ	V5OUT
	CPI	MAXDVC
	JRZ	CENTRONICS$OUT
	JRNC	NULL$OUTPUT
	CPI	03
	JZ	SPOUT
	MOV	A,C
	PUSH	PSW
	PUSH	B 
CO$SPIN:
	CALL	?COST
	JRZ	CO$SPIN
	POP	H
	MOV	L,H
	MVI	H,0
	LXI	D,DATA$PORTS
	DAD	D
	MOV	C,M
	POP	PSW
	OUTP	A

NULL$OUTPUT:
	
	RET

SPOUT:
	IN	SC01
	ANI	01
	JRZ	SPOUT
	MOV	A,C
	OUT	SC01
	RET

CENTRONICS$OUT:
	
	IN	PIOA
	ANI	0EH
	CPI	0EH
	JRNZ	CENTRONICS$OUT
	RES	7,C
	MOV	A,C
	OUT	PIOB
	MVI	A,10H
	OUT	PIOA
	XRA	A
	OUT	PIOA
	RET

V5OUT:
	IN	V5S
	ANI     01H
	JRZ 	V5OUT
	MOV	A,C
	ANI	7FH
	OUT	V5S-1
	RET

;************************************************
?cost:	; character output status
;************************************************	
	MOV	A,B
	ORA	A
	JRZ	V5OST
	CPI	MAXDVC
	JRZ	CENT$STAT
	JRNC	NULL$STATUS
	CPI	03
	JZ	SPOST
	MOV	L,B
	MVI	H,0
	LXI	D,DATA$PORTS
	DAD	D
	MOV	C,M
	INR	C
	INP	A
	ANI	04H
STRET:
	RZ
	ORI	0FFH
	RET

cent$stat:
	IN	PIOA
	ANI	0EH
	CPI	0EH
	MVI	A,0FFH
	RZ
NULL$STATUS:
	XRA	A
	RET

SPOST:
	IN	SC01
	ANI	1
	JR	STRET


V5OST:
	IN	V5S
	ANI	1
	JR	STRET



data$ports:			; serial base ports by physical device number
	DB	00
	DB	CONA
	DB	CONB
OLDBAUD:
	DB	00
@ctbl:	
	DB	'CRT   '	; device 0, CRT port 0
	DB	03
	DB 	00
	db 	'CHAN-A'	; device 1, LPT port 0 mod. KW840821
	db 	07
PORT1:  DB	06H		; mod.KW840821 300 Baud
	db 	'CHAN-B'	; device 2, CRT port 1 mod. KW840821
	db 	07
PORT2:  DB	0cH		; mod. KW840821 4800 Baud
	DB	'SPEECH'
	DB	02
	DB	00
	db 	'CEN   '	; device 6, Centronics parallel printer
	db 	02
	db 	00
	db	00		; table terminator
BAUDTAB:
	DB	00,00,11H,22H,33H,44H,55H,66H,77H,88H	; changed 10/24/83
	DB	0AAH,0BBH,0CCH,0DDH,0EEH,0FFH

IPORT1:	DB	18H,01H,00H,02H,00H,03H,0C1H,04H,4CH,05H,0EAH	; mod. KW840821
IPORT2: DB	18H,01H,00H,02H,00H,03H,0C1H,04H,4CH,05H,0EAH

	END














