	TITLE 'RAMDEF - RAM-FLOPPY DATA AREA'

;	*****************************************************************
;	*								*
;	*	RAM-FLOPPY DATA AREA	V1.0				*
;	*								*
;	*	COPYRIGHT BY W & S COMPUTERTECHNIK,KAISERSLAUTERN	*
;	*				PIRMASENSER STRASSE 29		*
;	*								*
;	*****************************************************************
;
;
;
;	LAYOUT OF MEMORY USED AS RAM FLOPPY
;
;	CHANGES OF THE SIZE OF THE RAM-FLOPPY OR
;	CHANGES OF MEMORY LAYOUT OF THE RAM-FLOPPY CAN BE MADE WITH
;	THE INFORMATION IN THIS FILE.

;	RF$DIR AND N$TRKS ARE DEPENDENT ON THE SIZE OF THE RAM FLOPPY
;
;	MEMORY SIZE            N$TRKS         RF$DIR
;
;	    48	K		12		16	
;	    96	K		24		32
;	   144	K		36		32
;	   192	K		48		32
;	   240	K		60		32
;	   288	K		72		64
;	   336	K	        84		64
;	   384	K	        96		64
;	   432	K	       108		64
;	   480	K	       120		64
;	   528	K	       132	       128
;	   576	K	       144	       128
;	   624	K	       156	       128
;	   672	K	       168	       128
;	   720	K	       180	       128
;	   768	K	       192	       192


N$TRKS	EQU	36		;NUMBER OF TRACKS PER RAM DISK
RF$SPT	EQU	32		;NUMBER OF SECTORS PER TRACK
RF$DIR	EQU	32		;NUMBER OF DIRECTORY ENTRIES ON YOUR RAM-FLOPPY

RF$TRK	EQU	N$TRKS-1	;PHYSICAL NUMBER OF TRACKS ON RAM FLOPPY

	PAGE

;	THE MEMORY LAYOUT TABLE IS SUPPORTED TO ALLOW GREATER FLEXI-
;	BILITY IN WORKING TOGETHER WITH OTHER SYSTEMS.
;	THE TABLE DEFINES THE BANKS AND PARTS OF BANKS WHICH ARE
;	ALLOWED TO BE USED BY THE RAM-FLOPPY SOFTWARE.
;
;	THE TABLE HAS THE FOLLOWING STRUCTURE:

;	--------------------------------------------
;	!   BASE   !  LEN     !  BANK    !  FLS    !
;	--------------------------------------------
;
;	WHERE BASE IS AN 8 BIT VALUE WHICH CONTAINS THE HIGH BYTE OF THE
;	BASE ADDRESS OF A MEMORY REGION. EVERY REGION MUST BEGIN ON A 
;	PAGE BOUNDARY (I. E. THE LOW PART OF THE ADDR. HAS TO BE ZERO).
;
;	LEN IS 8 BIT VALUE WHICH CONTAINS THE LENGTH OF THE MEMORY
;	REGION THAT SHOULD BE USED AS PART OF YOUR RAM-FLOPPY. THE MINIMUM
;	VALUE FOR THE REGION LENGTH 31 (1FH). MAXIMUM IS 191 (0BFH).
;	THE SUM OF BASE AND LEN MUST NEVER EXEED THE 48 K LIMITS.
;
;	THE BANK INFORMATION CONTAINS THE BANK ADDRESS OF THE MEMORY BANK
;	WHERE THE MEMORY REGION IS LOCATED.
;
;				IMPORTANT
;			ALL ENTRIES OF THE TABLE HAVE
;			TO BE SORTED IN ASCENDING ORDER.
;
;	FLS IS A 16 BIT VALUE AND IS SUPPORTED BY HE RAM-FLOPPY SOFTWARE.
;	IT SHOULD BE INITIALIZED AS ZERO.
;
;	RF$NME CONTAINS THE NUMBER OF ENTRIES USED IN THE TABLE. A MAXIMUM
;	OF 16 ENTRIES MAY BE SPECIFIED.


	MACLIB	Z80
	MACLIB	CPM3


	PUBLIC	FDSD4
	PUBLIC	RF$MLT,RF$NME,TRACKS

	EXTRN	RF$WRT,RF$RD,RF$LOG,RF$INI

	PAGE
	DSEG		;LOAD TO BANKED MEMORY


RF$MLT:	DB	0,0BFH,3,0,0	;MEMORY LAYOUT TABLE
	DB	0,0BFH,4,0,0
	DB	0,0BFH,5,0,0

RF$NME:	DB	3	;NUMBER OF ENTRIES IN MEMORY LAYOUT TABLE (RF$MLT)

	DW	DDB7	;RAM - FLOPPY DEFINITION
	DW	RF$WRT
	DW	RF$RD
	DW	RF$LOG
	DW	RF$INI
	DB	4,00

FDSD4:	DPH	0,DPB7
;------------------------------------------------

	CSEG

DPB7	DPB	128,RF$SPT,RF$TRK,2048,RF$DIR,2,0	; RAM FLOPPY (128K)


	DSEG

DDB7:	DW	DDB7	;RAM- FLOPPY
	DW	0
	DW	DPB7
	DB	00,00

TRACKS:	DB	RF$TRK
	END
