	title 'bank & move module for CP/M3 linked BIOS'


	maclib 	z80
	cseg

CBANK	EQU	0EEH	; CPU BANK REGISTER


	public ?move,?xmove,?bank

	EXTRN	@cbnk


?xmove:			; USE DYNAMIC BANKING
	MOV	A,B	; B=DEST
	SLAR	A
	SLAR	A
	SLAR	A
	SLAR	A
	ORA	C	; C=SOURCE
	STA	SAVEBNK
	MVI	A,-1	; SET FLAG
	STA 	FLAG
 	ret

?move:
	xchg      	
  	PUSH	PSW
	LDA	FLAG
	ORA	A
	JRZ	MOVE1
   	LDA	SAVEBNK
   	OUT	CBANK
MOVE1:
	LDIR		; use Z80 block move instruction
   	CALL	?BANK
	XRA	A
	STA	FLAG
  	POP	PSW
	xchg
	ret

?bank:	
	lda	@cbnk
	PUSH	B
	ANI	0FH
	MOV	B,A
	SLAR	A
	SLAR	A
	SLAR	A
	SLAR	A
	ORA	B	 
	OUT	CBANK
	POP	B
	RET


savebnk:
	DB	00H
FLAG:	DB	00H
	END
