	TITLE	'NONBANKED FLOPPY DRIVER FOR INFO-S CP/M 3.0, 22.12.1983'
	PAGE	70
 
;********************************************************
;
;	FLOPPY DRIVER MODULE FOR CPM 3.0
;	REQUIRES info-s HARDWARE
;	NONBANKED VERSION
;
;	(c) Copyright 1983 by	Computer Elektronik
;				G. Krause
;				Zum R|mergrund 19
;				6501 W|rrstadt
;
;*********************************************************


	maclib	cpm3
	maclib	z80


;************************************************
;	BIOS EQUATES
;************************************************

FDC	EQU	0H	; FLOPPY CONTROLL
FDD	EQU	1H	; FLOPPY DATA PORT
FTC	EQU	2H	; FLOPPY TERMINATE
DMA	EQU	3H	; FLOPPY DMA CONTROLLER
DRIVE	EQU	4H	; DRIVE TYPE SELECT
FBANK	EQU	5H	; FLOPPY BANK REGISTER
CBANK	EQU	0EEH	; CPU BANK REGISTER


;************************************************
;	EXTERNALS 
;************************************************ 

	EXTRN	@adrv,@rdrv,@dma,@trk,@sect
	EXTRN	@dbnk,@ermde,?WBOOT,?PMSG
	EXTRN	?PDEC,?PDERR,?CONIN,?CONO,?CONST

	
;************************************************
;	GLOBALS
;************************************************

	PUBLIC	FDSD0,FDSD1,FDSD2,FDSD3


	PAGE
;************************************************
;	DEFINITION OF FLAG BYTE
;
;	X X X X    X X X X
;	I   I I	   I I I I-----	0 = 8"  /  1 = 5"
;	I   I I	   I I I------- 0 = SS  /  1 = DS
;	I   I I	   I I--------- 0 = SD  /  1 = DD
;	I   I I	   I----------- 0 = NONINV. DATA / 1 = INVERT. DATA
;       I   I I
;	I   I I---------------- 1 = 512 BYTE /SEC.     0
;	I   I------------------ 1 =   2 KBYTE/SEC.     0 = 128 BYTE/SEC.
;	I
;	I---------------------- 0 = 77 TRK. /  1 = 40 TRK
;

;***********************************************
DRVTIME:
;	STEP RATE AND HEAD LOAD 
; 	TIMING FOR DRIVES
; 	TIME FOR 5" UNITS IS DOUBLED
;************************************************

	DB	0AFH		; SRT + HUT 
	DB	020H		; HLT       


	PAGE
;************************************************
;	Extended Disk Parameter Headers (XPDHs)
;************************************************ 

	DW	DDB2    ; default is 8" DD,DS,512 Byte
	DW	fd$write
	DW	fd$read
	DW	fd$login
	DW	fd$init0
	DB	0,1EH	 

fdsd0:	DPH     TRANS2,DPB2        
;------------------------------------------------


	DW	DDB2
	dw	fd$write
	dw	fd$read
	dw	fd$login
	dw	fd$init1
	db	1,1EH	

fdsd1:	DPH     TRANS2,DPB2       
;------------------------------------------------


	PAGE
	DW	DDB6	; default is 5" 96 TPI DS
	DW	FD$WRITE
	DW	FD$READ
	DW	FD$LOGIN
	DW	FD$INIT1
	DB	2,01FH
FDSD2:	DPH	TRANS1,DPB2  
;------------------------------------------------


	DW	DDB4	; default is 5" 48 TPI DS
	DW	FD$WRITE
	DW	FD$READ
	DW	FD$LOGIN
	DW	FD$INIT1
	DB	3,09FH

FDSD3:	DPH	TRANS1,DPB2  
;------------------------------------------------


	PAGE
TRANS0	SKEW	26,6,1			; FOR STANDARD DISK

TRANS1	SKEW	10,2,1			; 5" DD 512-BYTE / SEC

TRANS2	SKEW	15,4,1			; 8" DD 512-BYTE / SEC


	PAGE
DPB0  	DPB	128,26,77,1024,64,2	; 8" 77 TRK SS SD

DPB1  	DPB	512,15,77,2048,192,2	; 8" 77 TRK SS DD

DPB2    DPB	512,15,154,2048,192,2	; 8" 77 TRK DS DD

DPB3  	DPB	512,10,40,2048,64,2	; 5" 40 TRK SS DD


	PAGE
DPB4  	DPB	512,10,80,2048,64,2	; 5" 40 TRK DS DD

DPB5  	DPB	512,10,77,2048,192,2	; 5" 77 TRK SS DD

DPB6  	DPB	512,10,154,2048,192,2	; 5" 77 TRK DS DD


 	PAGE
DDB0:	DW	DDB1	; 8" SD SS  STANDART CPM
	DW	TRANS0
	DW	DPB0 
	DB	00,00

DDB1:	DW	DDB2	; 8" DD SS 512 BYTE
	DW	TRANS2
	DW	DPB1
	DB	1CH,0

DDB2:	DW	DDB0	; 8" DD DS 512BYTE
	DW      TRANS2
	DW	DPB2
	DB	1EH,00

DDB3:	DW	DDB3	; 5" DD SS 48TPI
  	DW	TRANS1
	DW	DPB3
	DB	9DH,00

DDB4:	DW	DDB4	; 5" DD DS 48TPI
	DW	TRANS1
	DW	DPB4
	DB	9FH,00

DDB5:	DW	DDB5	; 5" DD SS 96TPI
	DW	TRANS1
	DW	DPB5
	DB	1DH,00

DDB6:	DW	DDB6	; 5" DD DS 96TPI
	DW	TRANS1
	DW	DPB6
	DB	1FH,00


	PAGE
;****************************************************
; Disk I/O routines for standardized BIOS interface
;****************************************************



;************************************************
fd$init0:
; Initialization entry point.
; called for first time initialization.
;************************************************

	DI
	IM2
	LXI	H,TERMI
	LXI	D,INTVEC+1
	RES	0,E
	MOV	A,L
	STAX	D
	INX	D
	MOV	A,H
	STAX	D
	DCX	D
	MOV	A,D
	STAI
	MOV	A,E
	STA	LIVR
	STA	LIVW
	LXI	H,DRVTIME	; LOAD STEP RATE
	MVI	C,03		; AND HEAD LOAD TIMING
	CALL	CMDOUT
	MOV	C,M
	CALL	CMDOUT
	INX	H
	MOV	C,M
	CALL	CMDOUT
	EI
	RET

FD$INIT1:
	RET


	PAGE
;************************************************
FD$LOGIN:
; This entry is called when a logical drive is about to
; be logged into for the purpose of density determination.
; It may adjust the parameters contained in the disk
; parameter header pointed at by <DE>
;************************************************

	MVI	A,-1		; SET FLAG FOR 1ST ENTRY
	CALL	CHGDRV		; DEFINE DPB IN DPH
LOG02:	PUSH	D
	POP	H
	SHLD	SAVE
	LXI	H,0002
	SHLD	@TRK		; SET TRK 2
	DCX	H
	SHLD	@SECT		; SET SEC 1
	LXI	H,BUFF
	SHLD	@DMA		; READ IN BUFFER
	DCX	D
	PUSH  	D
	XTIX			; EX (SP),IX
	CALL	TRK0		; RECALIBRATE DISK
	CALL	SET0		; ADJUST DISK
	CALL	RDDATA		; READ DIRECTORY
	CALL	RESULT		; GET RESULT
	LXI	H,RESTAB	; ANALYSE RESULT
	MOV	A,M		; STATUS BYTE
	ANI	0C0H		; MASK BITS        
 	JRNZ	LOG01		; TRY ANOTHER DDB
	LDX	A,0		; LOAD MASK BYTE
	BIT	0,A		; TEST FOR 5"
	JRNZ	FOUND		; 5" - JUMP
	ANI	0BFH		; TEST FOR 8" SD FORMAT
	JRZ	FOUND		; 8" SD - JUMP
 	LDA	DRVST		; DRIVE STATUS
 	ANI	08		; TWO SIDET ?
	SRAR	A
	SRAR	A
	MOV	B,A
	LDX	A,0
	ANI	02
	XRA	B
	JRZ	FOUND
LOG01:	LHLD	SAVE		; RESTORE XDPH POINTER
	PUSH	H
	POP	D
	XRA	A		; SET FLAG
	CALL	CHGDRV		; CHANGE DRIVE TYPE
	POPIX
	JR 	LOG02   	; TRY AGAIN

FOUND:	POPIX			; RESTORE IX
	RET 

		
	PAGE
;************************************************ 
CHGDRV:	;CHANGE DRIVE TYPE OR FORMAT
;************************************************

	PUSH	D
	PUSH	D
	LXI	H,-0CH
	DAD	D
	MOV	E,M		; PUT DDB ADDR. IN DE
	INX	H
	MOV	D,M
	ORA	A		; TEST FLAG
	JRNZ	CHGDRV1 	; JUMP ON FIRST ENTRY
	LDAX	D		; FETCH ADDR. OF NEXT DDB
	DCX	H
	MOV	M,A
	MOV	C,A
	INX	H
	INX	D
	LDAX	D
	MOV	M,A		; STORE NEW DDB IN XDPH-12
	MOV	D,A
	MOV	E,C
CHGDRV1:INX	D
	INX	D		; FETCH ADDR. OF XLT
	LDAX	D
	POP	H		; RESTORE ADDR. OF XDPH
	MOV	M,A		; CHANGE XLT POINTER 
	INX	D		; IN XDPH
	LDAX	D
	INX	H
	MOV	M,A
	LXI	B,11		; ADJUST POINTER TO 
	DAD	B		; DPB IN XDPH
	INX	D		; FETCH ADDR. OF NEW DPB
	LDAX	D
	MOV	M,A		; CHANGE DPB IN XDPH
	INX	D
	INX	H 
	LDAX	D
	MOV	M,A
	POP	H		; GET XDPH POINTER
	DCX	H		; POINT TO FLAG BYTE
	INX	D
	LDAX	D		; MOVE FLAG BYTE
	MOV	M,A
	INX	H
	MOV	D,H		; COPY HL IN DE
	MOV	E,L
	RET


	PAGE
;************************************************
FD$READ:	
;       READ SECTOR WITH GIVEN PARAMETERS
; relative drive number in @rdrv (8 bits)
; absolute drive number in @adrv (8 bits)
; disk transfer address in @dma (16 bits)
; disk transfer bank	in @dbnk (8 bits)
; disk track address	in @trk (16 bits)
; disk sector address	in @sect (16 bits)
; pointer to XDPH in <DE>
;
; they transfer the appropriate data, perform retries
; if necessary, then return an error code in <A>
;***********************************************

	XRA	A
	STA	ERRCODE+1	; SET READ FLAG
	DCX	D
	PUSH  	D
	XTIX			; EX (SP),IX
	MVI	A,10
	STA	ERRCNT
	CALL	SET0
READ004:LDA	ERRCNT
	ORA	A		; TEST RETRY COUNT
	JRNZ    READ008		; MAKE MORE RETRIES
	MVI	A,01		; LOAD ERROR CODE 
	JR	READ007		; JUMP TO ERROR RETURN

	PAGE
READ008:DCR	A		; UPDATE ERROR COUNT
	STA	ERRCNT		; STORE IT
	CALL	RDDATA		; READ THE DATA
	CALL	RESULT		; GET THE RESULT
	LXI	H,RESTAB	; POINT TO RESULT TABLE
	MOV	A,M		; GET STATUS BYTE
	ANI	0C0H		; 
	JRZ	READ002		; NO ERROR OCCURED
	INX	H		; POINT TO SENSE BYTE 1
	BIT	0,M		; MISS. ADDR. MARK ?
	JRZ	READ003		; NO - JUMP
	LDA	ERRCNT
	CPI	3		; ALLOW 3 RETRIES
	JRC	READ004
	MVI	A,0FFH
	JMP	READ007		; JUMP TO ERROR RETURN

READ003:INX	H		; POINT TO SENSE BYTE 2
	BIT	4,M		; WRONG TRACK ?
	JRZ	READ004		; NO - JUMP AND DO RETRY
	CALL	RESTORE		; REPOSITION HEAD
	JR	READ004 

READ002:BITX	3,0		; MOVE DATA IF REQUIRED
	JRZ	READ001
	LXI	H,BUFF
	LDED	@DMA
	CALL	MOVE		; INVERTED TRANSFER
READ001:XRA	A		; SUCCESSFUL RETURN
READ007:JMP   	ERRDSPL		; ERROR RETURN 


	PAGE
;************************************************
FD$WRITE:	
;       WRITE SECTOR WITH GIVEN PARAMETERS
; relative drive number in @rdrv (8 bits)
; absolute drive number in @adrv (8 bits)
; disk transfer address in @dma (16 bits)
; disk transfer bank	in @dbnk (8 bits)
; disk track address	in @trk (16 bits)
; disk sector address	in @sect (16 bits)
; pointer to XDPH in <DE>
;
; they transfer the appropriate data, perform retries
; if necessary, then return an error code in <A>
;************************************************

	MVI	A,-1
	STA	ERRCODE+1
	DCX	D
	PUSH  	D
	XTIX			; EX (SP),IX
	BITX	3,0		; TEST FOR INV. DATA
	JRZ	WR001
	LHLD	@DMA
	LXI	D,BUFF
	CALL	MOVE		; INVERTED TRANSFER
WR001:	MVI	A,10
	STA	ERRCNT
	CALL	SET0
WR002:	LDA 	ERRCNT		; TEST RETRY COUNT
	ORA	A
	JRNZ	WR003		; MAKE MORE RETRIES
	MVI	A,01		; LOAD ERROR CODE
	JR	ERRDSPL		; JMP TO ERROR RETURN

	PAGE
WR003:	DCR	A		; UPDATE RETRY COUNT
	STA	ERRCNT		; STORE IT
	CALL	WRDATA		; WRITE THE DATA
	CALL	RESULT		; FETCH THE RESULT
	LXI	H,RESTAB	; POINT TO RESULT TABLE
	MOV	A,M		; GET STATUS BYTE
	ANI	0C0H		; TEST FOR ERRORS
	JRZ	WR005		; NO ERRORS - JUMP
	INX	H		; POINT TO SENSE BYTE 1
	BIT	0,M		; MISS. ADR. MARK
	JRZ	WR006		; NO - JUMP
	LDA	ERRCNT		; CHECK RETRIES
	CPI	3		; 3 ARE MANDATORY
	JRC	WR002		; LESS - JUMP
	MVI	A,0FFH		; DENSITY CHANGED
	JR	ERRDSPL		; REPORT ERROR TO BDOS

WR006:	BIT	1,M		; WRITE PROTECTED
	JRZ	WR007		; NO - JUMP
	LXI	H,WRPROT	; ERROR MSG
	CALL	ERRMES		; SEND MESSAGE
	CPI	'Y'		; RETRIES ?
	JRZ	WR002		; YES
	MVI	A,1		; NO
	JR	ERRDSPL		; ERROR EXIT

WR007:	INX	H		; POINT TO SENSE BYTE 2
	BIT     4,M		; WRONG TRACK
	JRZ	WR002		; NO - DO RETRIES
	CALL	RESTORE		; REPOSITION HEAD
	JR	WR002		; DO RETREIS

WR005:	XRA	A		; NO ERRORS TO REPORT
ERRDSPL:POPIX 
	ORA	A		; TEST FOR ERRORS
	RZ			; NO ERRORS TO DISPLAY
	STA 	ERRCODE		; SAVE ERROR CODE
	LDA	@ERMDE		; TEST ERROR MODE
	CPI	-1
	JRNZ	FULLMSG		; GIVE FULL ERROR MSG
	LDA	ERRCODE		; RESTORE ERROR CODE
	RET

	PAGE
FULLMSG:CALL	?PDERR		; PRINT HEADER
	LDA	ERRCODE+1	; OPERATION CODE
	ORA	A	
	JRZ	RDOP
	LXI	H,WRMSG		; OPERATION WAS WRITE
	JR	SENDOP

RDOP:	LXI	H,RDMSG		; OPERATIN WAS READ
SENDOP:	CALL	?PMSG		; DISPLAY IT
	LXI	H,SENSMSG	; SENS BYTES FOLLOW
	CALL	?PMSG
	LXI	H,RESTAB	; POINT TO RESULT TABLE
	MVI	B,7		; NR. OF BYTES
SENSLP:	PUSH	B
	CALL	ADJUST
	CALL	ADJUST
	INX	H		; POINT TO NEXT BYTE
	MVI	C,'-'		; SEND SEPARATOR
	PUSH	H
	CALL	?CONO		
	POP	H
	POP	B
	DJNZ	SENSLP
	LXI	H,CORRECT
	CALL	?PMSG
	LDA	ERRCODE		; RESTORE ERROR CODE
	RET

ADJUST:	XRA	A
	RLD
	CPI	0AH		
	JRNC	SENSLP1		; A-F JUMP
	ORI	30H		; MAKE ASCII CODE
	JR	SENSLP2

SENSLP1:SUI	9		; MAKE A-F
	ORI	40H		; MAKE ASCII CODE
SENSLP2:MOV	C,A
	PUSH	H
	CALL	?CONO		; SEND DIGIT
	POP	H
	RET


	PAGE
;************************************************
;	DISK SUBROUTINES
;************************************************

SET0:	BITX	3,0
	JRZ	SET1
	LXI	B,BUFF
	JR	SET2

SET1:	LBCD	@DMA
SET2:	SBCD	RBUF
	SBCD	WBUF
	CALL	LENGTH
	DCX	B
	SBCD	WLEN		; DMA TRANSFER LENGTH
	SBCD	RLEN
	BITX	4,0
	LXI	H,PAR512
	JRNZ	SET3
	BITX	5,0
	LXI	H,PAR2K		
	JRNZ	SET3
	LXI	H,PAR128
SET3:	LXI	D,DSKN
	LXI	B,4
	LDIR
	XRA	A
	STA	DSKH		; HEAD 0
	LDA	@RDRV		; UNIT
	MOV	C,A
	LDA	@TRK		; TRACK
	MOV	B,A
	SBCD	DSKU
	BITX	1,0
	JRZ     SET9
	BITX	7,0
	MVI	B,40
	JRNZ	SET10
	MVI	B,77
SET10:	SUB	B
	JRC	SET9
	MOV	B,A
	SBCD	DSKU
	MVI	A,1
	STA	DSKH
SET9:	LDA	@SECT		; SECTOR
     	STA	DSKS	

	PAGE
SET4:	LXI	H,4000H		; NOT READY COUNTER
SET5:	PUSH	HL
	MVI	C,04H
	CALL	CMDOUT
	LDA	DSKU
	MOV	C,A
	CALL	CMDOUT
	CALL	NEXT
	STA	DRVST 
   	BIT	5,A
	POP	HL
	JRNZ	SET6 
	DCX	H
	MOV	A,H
	ORA	L
	JRNZ	SET5 
	LXI	H,DNRDY
	CALL	ERRMES
	CPI	'Y'
	JRZ	SET4
	JMP     ?WBOOT

SET6:	BITX	0,0		; TEST FOR 8"
	JRNZ	SET8
	XRA	A		; CLOCK FOR 8"
	OUT 	DRIVE
	JR	SET7

SET8:	MVI	A,1		; SET 5" DRIVE
	OUT	DRIVE
SET7:	INR	A
	JRNZ	SET7 

	PAGE
;************************************************
SEEK:
;       MOVE HEAD TO TRACK GIVEN BY "DISKT"
;************************************************

	LXI	B,030FH		; SEEK TRACK
	CALL	EXEC 
	XRA	A

	
;************************************************
SENS:
;       SEEK FINISHED ?
;************************************************

     	MVI	C,08    	; SENSE INTERRUPT
	CALL	CMDOUT 
	CALL	NEXT		; FETCH RESULT
	MOV   	B,A		; SAVE RESULT
	CPI 	080H
	CNZ     NEXT
	BIT	5,B		; SEEK FINISHED ?
	JRZ	SENS		; NO 
	RET			; YES


;************************************************
RESTORE:
;	RESTORE HEAD
;************************************************

	CALL	TRK0
	JMP  	SEEK


;************************************************
TRK0:
;	RECALIBRATE HEAD
;************************************************

	MVI	C,07H
	CALL	CMDOUT
	LDA	DSKU
	ANI	03H
	MOV	C,A
	CALL	CMDOUT
	JMP     SENS
	

	PAGE
;************************************************
MOVE:   ;TRANSFERS INVERTED DATA
;************************************************

	CALL	LENGTH
MOVE001:MOV	A,M
	CMA
	STAX	D
	INX	H
	INX	D
	DCX	B
	MOV	A,B
	ORA	C
	JRNZ	MOVE001
	RET


;************************************************
LENGTH: ;DEFINE LENGTH OF FORMAT
;************************************************

	BITX	4,0
	LXI	B,512
	RNZ
	BITX	5,0
	LXI	B,2048
	RNZ
	LXI	B,128
	RET


	PAGE
;************************************************
WRDATA:	
;       WRITE PHYSICAL SECTOR TO DISK
;************************************************

	LXI	B,CWLEN*256+DMA ; C = .DMA
	LXI	H,CWRT
	OUTIR			; DMA WRITE TO DISK
	MVI	A,05H   	; WRITE SECTOR
	BITX	2,0
	JRZ	WR1
	ORI	40H		; DOUBLE DENSITY
WR1:	MOV	C,A
	MVI	B,9		; PARAMETER COUNT
    	JMP  	EXEC



;************************************************
RDDATA:
;       READ PHYSICAL SECTOR FROM DISK
;       RETURNS WITH:  Z = NO ERRORS
;       AND: NZ = READ ERROR
;************************************************
	LXI	B,CRLEN*256+DMA ; C = DMA, B = CMD-LENGTH
	LXI	H,CRDT
	OUTIR			; DMA READ FROM DISK
	MVI	A,06H    	; READ
	BITX	2,0
	JRZ	RD1
	ORI	40H		; DOUBLE DENSITY
RD1:	MOV	C,A
	MVI	B,9		; PARAMETER COUNT
    	JMP  	EXEC


;************************************************
RESULT:
;       FETCH RESULTS OF READ/WRITE OPERATION
;       AND CHECK THEM FOR R/W-ERRORS
;       RETURNS WITH: Z & A=0, IF NO ERRORS
;       AND WITH: NZ & A=? IF ANY ERROR
;************************************************

	LXI	H,RESTAB
	MVI	B,07H		; RESULT COUNT
RES01:	CALL	NEXT
	MOV	M,A		; STORE RESULT BYTE
	INX	H
	DJNZ	RES01 
	RET


	PAGE
;************************************************
ERRMES:	
;************************************************

	CALL	?PMSG		; SEND MESSAGE
	LXI	H,RETRYMSG	; RETRY QUESTION
	CALL	?PMSG		; SEND IT
ERRLP01:CALL	?CONST		; WAIT FOR INPUT
	ORA	A
	JRZ	ERRLP01
	CALL	?CONIN		; GET INPUT
	CPI	'A'
	JRC	ERRLP01		; WRONG INPUT
	ANI	5FH		; MAKE UPPER INPUT
	CPI	'Y'		; TEST 'YES'
	JRZ	ERRLP02		; OK - JUMP
	CPI	'N'		; TEST 'NO'
	JRNZ	ERRLP01		; TRY AGAIN
ERRLP02:PUSH	PSW		; SAVE A
	MOV	C,A
	CALL	?CONO  		; ECHO CHARACTER
	LXI	H,NLMSG		; NEW LINE
	CALL	?PMSG		; SEND IT
	POP	PSW		; RESTORE A
	RET


	PAGE
;************************************************
TERMI:	
;       INTERUPT SERVICE ROUTINE
;************************************************

  	OUT 	FTC		; TERMIN. UPD 765
	PUSH	PSW
	MVI	A,0C3H		; RESET DMA-LOGIC
	OUT 	DMA
	POP	PSW
	EI			
	RETI			


;************************************************
EXEC:	
;       TRANSMITS COMMAND TO FD-CONTROLLER
;************************************************

	LXI	H,DSKU
	PUSH	H
	LDA	DSKH
	ORA	A
	JRZ 	EXEC2
	SETB	2,M 
EXEC2:	LXI	H,CMDTAB	; POINT TO COMMANDTABLE
EXEC1:	CALL    CMDOUT
	INX	H		; POINT TO NEXT BYTE
	MOV	C,M
	DJNZ	EXEC1		; SEND NEXT BYTE
	POP	H
	RES 	2,M 
 	RET			; ALL BYTES TRANSFERRED


;************************************************
CMDOUT:
;	TRANSMIT 1 BYTE TO THE UPD765
;************************************************

	IN	FDC
	BIT	7,A
	JRZ	CMDOUT
	BIT	6,A
	JRZ	CMDOUT1
	IN	FDD
	JR	CMDOUT

CMDOUT1:MOV	A,C
	OUT	FDD
	RET


;************************************************
NEXT:	
;       READ NEXT RESULT-BYTE FROM FD-CONTROLLER
;       DESTROYES: AF
;************************************************

	IN	FDC
	ANI	0C0H
	CPI   	0C0H
	JRNZ	NEXT
	IN	FDD		; YES : FETCH RESULT
	RET

 
	PAGE
;************************************************
;	ERROR - MESSAGES 
;************************************************

WRPROT:	DB	0DH,7,0AH,'WRITE PROTECTED',0DH,0AH,00

DNRDY:  DB	0DH,0AH,7,'DISK DRIVE NOT READY',0DH,0AH,00

NLMSG:	DB	0DH,0AH,00

RETRYMSG:
	DB	'RETRY (Y/N) ?',00

WRMSG:	DB	0DH,0AH,'WRITE OPERATION  ',00

RDMSG:	DB	0DH,0AH,'READ  OPERATION  ',00

SENSMSG:	DB	0DH,0AH,'SENSE BYTE FROM info-s FDC ',00

CORRECT:	DB	08H,' ',0DH,0AH,00


	PAGE
;************************************************
;	COMMAND-TABLES FOR DMA CONTROLLER
;************************************************


;************************************************
CWRT:	
;       DMA WRITE TO DISK
;************************************************

	DB	83H		; DISABLE DMA
	DB	0C3H		; RESET
	DB	79H		; GROUP 0
WBUF:	DW	00		; PORT A STARTING ADDRESS
WLEN:	DW	128-1		; RECORD LENGTH
	DB	54H		; GROUP 1
	DB	0C8H		; PORT A TIMING BYTE
	DB	68H		; GROUP 2
	DB	048H		; PORT B TIMING BYTE
	DB	0D5H		; GROUP 4
WIO:	DB	FDD		; PORT B STARTING ADDRESS
	DB	12H		; INTERRUPT CONTROL BYTE
LIVW:   DB      00H		; INTERRUPT VECTOR
	DB	8AH		; GROUP 5
	DB	0CFH		; GROUP 6: LOAD
	DB	5		; TRANSER  A --> B
	DB	0CFH		; LOAD
	DB	0ABH		; ENABLE INTERRUPT
	DB	87H		; ENABLE DMA
CWRE:
CWLEN	EQU	CWRE-CWRT


;************************************************ 
CRDT:	
;       DMA READ FROM DISK
;************************************************

	DB	83H		; DISABLE DMA
	DB	0C3H		; RESET
	DB	79H		; GROUP 0
RBUF:	DW	00		; PORT A STARTING ADDRESS
RLEN:	DW	128-1		; RECORD LENGHT
	DB	54H		; GROUP 1
	DB	0C8H		; PORT A TIMING BYTE
	DB	68H		; GROUP 2
	DB	0CCH		; PORT B TIMING BYTE
	DB	95H		; GROUP 4
RIO:	DB	FDD		; PORT B STARTING ADDRESS
	DB	12H		; INTERRUPT CONTROL BYTE
LIVR:	DB	00H		; INTERRUPT VECTOR
	DB	8AH		; GROUP 5
	DB	0CFH		; GROUP 6: LOAD
	DB	0ABH		; ENABLE INTERRUPTS
	DB	87H		; ENABLE DMA
CRDE:
CRLEN	EQU	CRDE-CRDT


	PAGE
;************************************************
;	PHYSICAL DISK PARAMETER
;************************************************

CMDTAB:	DB	0		; COMMAND-TABLE
DSKU:   DB	0		; PHYS. UNIT
DSKT:	DB	0  		; PHYS. TRACK 
DSKH:   DB	0		; PHYS. HEAD
DSKS:	DB	0      		; PHYS. SECTOR
DSKN:	DB	0
DSKEOT:	DB	26
DSKGPL:	DB	7
DSKDTL:	DB	128


;************************************************
RESTAB:
;	RESULT TABLE
;************************************************

	DB	0		; ST0
	DB	0		; ST1   
	DB	0		; ST2
	DB	0		; CYLINDER (TRACK)
	DB	0		; HEAD
	DB 	0		; RECORD (SECTOR)
	DB	0		; N (LENTGH)


	PAGE
;************************************************
ERRCNT:
;	RETRY COUNT
;************************************************

	DB	00    


DRVST:	DB	00

ERRCODE:DB	00,00

SAVE:	DW	0000


PAR128:	DB	0,26,7,128

PAR512:	DB	2,26,1BH,0FFH

PAR2K:	DB	4,4,99H,0FFH

BUFF:	DS	512      	; READ WRITE BUFFER 

INTVEC:	DW	0,0,0,0,0,0,0,0


	END

     