1000 '  Name:         CLOCK.BAS
1001 '
1005 '  Description:  Clock Demonstration
1006 '
1010 '  Version:      2.05
1011 '
1015 '  Date:         02/21/84
1016 '
1020 '  Author:       Rene' J. Schuchter
1025 '
1030 '  Copyright (c) 1983 KAYPRO Corporation
1031 '
1035 '  All rights reserved.  No warranties expressed or implied.
1040 '
1045 '  Special thanks to Mathew Sherman for the idea of using
1050 '  the on-board clock RAM for maintaining leap day and year
1055 '  values.
1060 '
1065 '  See CLOCK.DOC for documentation.
1070 '
1071 '  INIT
1072 '
1075 AMERICAN%                    =    1
1080 APRIL%                       =    4
1085 AUGUST%                      =    8
1090 BORDER.BOTTOM.ROW%           =  131
1095 BORDER.LEFT.COLUMN%          =   32
1100 BORDER.RIGHT.COLUMN%         =  191
1105 BORDER.TOP.ROW%              =   59
1110 CLOCK.COLUMN.OFFSET%         =   12
1115 CLOCK.STATUS.FLAG%           =   12
1120 CLOCK.INITIALIZED%           =   29
1125 DATE.TO.TIME.LINE.SPREAD%    =    3
1130 DATE.LENGTH%                 =   20
1135 DAY.OF.THE.MONTH.COUNTER.ID% =    6
1140 DAY.OF.THE.WEEK.COUNTER.ID%  =    5
1145 DAY.OF.THE.WEEK.LENGTH%      =   11
1150 DAY.OF.THE.WEEK.OFFSET%      =   28
1155 DECEMBER%                    =   12
1160 DISPLAY.OFFSET%              =   32
1165 EUROPEAN%                    =    2
1170 FEBRUARY%                    =    2
1175 FIRST.DAY%                   =    1
1180 FIRST.MASK.COLUMN%           =    7
1185 FIRST.MASK.ROW%              =   10
1190 FLAG.RESET%                  =    0
1195 FLAG.SET%                    =   -1
1200 FRIDAY%                      =    6
1205 HOUR.COUNTER.ID%             =    4
1210 HOUR.ROW.ID%                 =    1
1215 HUNDREDTH.COUNTER.ID%        =    1
1220 HUNDREDTH.ROW.ID%            =    4
1225 JANUARY%                     =    1
1230 JULY%                        =    7
1235 JUNE%                        =    6
1240 LEAP.DAY.ACTIVE%             =    1
1245 LEAP.DAY.RESTART%            =    3
1250 LEAP.DAY.ROLLOVER%           =    2
1255 LEAP.DAY.STATUS.FLAG%        =   10
1260 LOGO.COLUMN.OFFSET%          =   10
1265 LOGO.ROW.OFFSET%             =    4
1270 LOGO.TEXT.COLUMN%            =   56
1275 LOGO.TEXT.ROW%               =    5
1280 MARCH%                       =    3
1285 MAY%                         =    5
1290 MESSAGE.COLUMN%              =   59
1295 MESSAGE.ROW%                 =   10
1300 MINUTE.COUNTER.ID%           =    3
1305 MINUTE.ROW.ID%               =    2
1310 MONDAY%                      =    2
1315 MONTH.COUNTER.ID%            =    7
1320 MONTH.HOLD.COUNTER.ID%       =   15
1325 NEW.YEAR.ACTIVE%             =    1
1330 NEW.YEAR.PENDING%            =    0
1335 NEW.YEAR.STATUS.FLAG%        =   11
1340 NO.LOWER.CASE%               =    0
1345 NO.UPPER.CASE%               =    1
1350 NO%                          =    0
1355 NOVEMBER%                    =   11
1360 OCTOBER%                     =   10
1365 PIO.PORT.A%                  =   15
1370 PORT.A%                      =   32
1375 PORT.D%                      =   36
1380 PORT.S%                      =   34
1385 SECOND.COUNTER.ID%           =    2
1390 SECOND.ROW.ID%               =    3
1395 SEPTEMBER%                   =    9
1400 SATURDAY%                    =    7
1405 SUNDAY%                      =    1
1410 THURSDAY%                    =    5
1415 TIME.BAR.SPREAD%             =   12
1420 TUESDAY%                     =    3
1425 WEDNESDAY%                   =    4
1430 TIME.BAR.COLUMN.OFFSET%      =   36
1435 TIME.BAR.ROW.OFFSET%         =   48
1440 TIME.LINE.SPREAD%            =    3
1445 YEAR.COUNTER.ID%             =    9
1450 YEAR.PREFIX%                 =   19
1455 YES.LOWER.CASE%              =    2
1460 YES.UPPER.CASE%              =    3
1465 YES%                         =    1
1470 '
1475 CLOCK.COLUMN%           = FIRST.MASK.COLUMN% + CLOCK.COLUMN.OFFSET%
1480 DATE.COLUMN%            = FIRST.MASK.COLUMN%
1485 DATE.FORMAT%            = EUROPEAN%
1490 DATE.ROW%               = FIRST.MASK.ROW%
1495 DAY.OF.THE.WEEK.COLUMN% = DATE.COLUMN + DAY.OF.THE.WEEK.OFFSET%
1500 FIRST.CLOCK.ROW%        = FIRST.MASK.ROW% + DATE.TO.TIME.LINE.SPREAD%
1505 FIRST.LOGO.COLUMN%      = DISPLAY.OFFSET% + LOGO.COLUMN.OFFSET%
1510 FIRST.LOGO.ROW%         = DISPLAY.OFFSET% + LOGO.ROW.OFFSET%
1515 FIRST.TIME.BAR.COLUMN%  = DISPLAY.OFFSET% + TIME.BAR.COLUMN.OFFSET%
1520 FIRST.TIME.BAR.ROW%     = DISPLAY.OFFSET% + TIME.BAR.ROW.OFFSET%
1525 FIRST.TIME.LINE.ROW%    = FIRST.MASK.ROW% + DATE.TO.TIME.LINE.SPREAD%
1530 HOUR.ROW.OFFSET%        = (HOUR.ROW.ID% - 1) * TIME.LINE.SPREAD%
1535 HUNDREDTH.ROW.OFFSET%   = (HUNDREDTH.ROW.ID% - 1) * TIME.LINE.SPREAD%
1540 MINUTE.ROW.OFFSET%      = (MINUTE.ROW.ID% - 1) * TIME.LINE.SPREAD%
1545 SECOND.ROW.OFFSET%      = (SECOND.ROW.ID% - 1) * TIME.LINE.SPREAD%
1550 TIME.BAR.COLUMN%        = (2 * (FIRST.MASK.COLUMN% - 1)) + FIRST.TIME.BAR.COLUMN%
1555 TIME.LINE.COLUMN%       = FIRST.MASK.COLUMN%
1560 '
1565 BACKSPACE$             = CHR$(8)
1570 CLEAR.SCREEN$          = CHR$(26)
1575 CLEAR.TO.END.OF.LINE$  = CHR$(24)
1580 CURSOR$                = CHR$(52)
1585 CURSOR.HOME$           = CHR$(30)
1590 DRAW$                  = CHR$(76)
1595 EQUALS$                = CHR$(61)
1600 ERASEX$                = CHR$(68)
1605 ESCAPE$                = CHR$(27)
1610 INVERSE$               = CHR$(48)
1615 REDUCED$               = CHR$(49)
1620 RETURN.CURSOR$         = CHR$(13)
1625 SET.OFF$               = CHR$(67)
1630 SET.ON$                = CHR$(66)
1635 TIME.BAR.LEFT.BORDER$  = CHR$(187)
1640 TIME.BAR.RIGHT.BORDER$ = CHR$(183)
1645 UNDERLINE$             = CHR$(51)
1650 VERSION$               = "2.05"
1655 '
1660 CLEAR.LINE$    = RETURN.CURSOR$ + CLEAR.TO.END.OF.LINE$
1665 CURSOR.ON$     = ESCAPE$ + SET.ON$ + CURSOR$
1670 CURSOR.OFF$    = ESCAPE$ + SET.OFF$ + CURSOR$
1675 INVERSE.ON$    = ESCAPE$ + SET.ON$ + INVERSE$
1680 INVERSE.OFF$   = ESCAPE$ + SET.OFF$ + INVERSE$
1685 REDUCED.ON$    = ESCAPE$ + SET.ON$ + REDUCED$
1690 REDUCED.OFF$   = ESCAPE$ + SET.OFF$ + REDUCED$
1695 UNDERLINE.ON$  = ESCAPE$ + SET.ON$ + UNDERLINE$
1700 UNDERLINE.OFF$ = ESCAPE$ + SET.OFF$ + UNDERLINE$
1705 '
1710 DEF FNDRAW.LINE$(DX1%, DY1%, DX2%, DY2%) = ESCAPE$ + DRAW$ + CHR$(DX1%) + CHR$(DY1%) + CHR$(DX2%) + CHR$(DY2%)
1715 DEF FNERASE.LINE$(EX1%, EY1%, EX2%, EY2%) = ESCAPE$ + ERASEX$ + CHR$(EX1%) + CHR$(EY1%) + CHR$(EX2%) + CHR$(EY2%)
1720 DEF FNLOGO.LINE$(LX1%, LY1%, LX2%, LY2%) = FNDRAW.LINE$((FIRST.LOGO.ROW% + LX1%), (FIRST.LOGO.COLUMN% + LY1%), (FIRST.LOGO.ROW% + LX2%), (FIRST.LOGO.COLUMN% + LY2%))
1725 DEF FNPOSITION.CURSOR$(PX%, PY%) = ESCAPE$ + EQUALS$ + CHR$(DISPLAY.OFFSET% + (PX% - 1)) + CHR$(DISPLAY.OFFSET% + (PY% - 1))
1730 '
1735 DIM CLOCK.ROW%(4)
1740 DIM DAY.OF.THE.WEEK.DESCRIPTION$(7)
1745 DIM HOLD.VALUE%(4)
1750 DIM MAXIMUM.COUNTER.VALUE%(9)
1755 DIM MAXIMUM.DAY.OF.THE.MONTH.VALUE%(12)
1760 DIM MINIMUM.COUNTER.VALUE%(9)
1765 '
1770 CLOCK.ROW%(HOUR.ROW.ID%)      = FIRST.CLOCK.ROW% + HOUR.ROW.OFFSET%
1775 CLOCK.ROW%(MINUTE.ROW.ID%)    = FIRST.CLOCK.ROW% + MINUTE.ROW.OFFSET%
1780 CLOCK.ROW%(SECOND.ROW.ID%)    = FIRST.CLOCK.ROW% + SECOND.ROW.OFFSET%
1785 CLOCK.ROW%(HUNDREDTH.ROW.ID%) = FIRST.CLOCK.ROW% + HUNDREDTH.ROW.OFFSET%
1790 '
1795 MAXIMUM.COUNTER.VALUE%(HUNDREDTH.COUNTER.ID%)        = 99
1800 MAXIMUM.COUNTER.VALUE%(SECOND.COUNTER.ID%)           = 59
1805 MAXIMUM.COUNTER.VALUE%(MINUTE.COUNTER.ID%)           = 59
1810 MAXIMUM.COUNTER.VALUE%(HOUR.COUNTER.ID%)             = 23
1815 MAXIMUM.COUNTER.VALUE%(DAY.OF.THE.WEEK.COUNTER.ID%)  = 7
1820 MAXIMUM.COUNTER.VALUE%(DAY.OF.THE.MONTH.COUNTER.ID%) = 31
1825 MAXIMUM.COUNTER.VALUE%(MONTH.COUNTER.ID%)            = 12
1830 MAXIMUM.COUNTER.VALUE%(YEAR.COUNTER.ID%)             = 99
1835 '
1840 MAXIMUM.DAY.OF.THE.MONTH.VALUE%(JANUARY%)            = 31
1845 MAXIMUM.DAY.OF.THE.MONTH.VALUE%(FEBRUARY%)           = 28
1850 MAXIMUM.DAY.OF.THE.MONTH.VALUE%(MARCH%)              = 31
1855 MAXIMUM.DAY.OF.THE.MONTH.VALUE%(APRIL%)              = 30
1860 MAXIMUM.DAY.OF.THE.MONTH.VALUE%(MAY%)                = 31
1865 MAXIMUM.DAY.OF.THE.MONTH.VALUE%(JUNE%)               = 30
1870 MAXIMUM.DAY.OF.THE.MONTH.VALUE%(JULY%)               = 31
1875 MAXIMUM.DAY.OF.THE.MONTH.VALUE%(AUGUST%)             = 31
1880 MAXIMUM.DAY.OF.THE.MONTH.VALUE%(SEPTEMBER%)          = 30
1885 MAXIMUM.DAY.OF.THE.MONTH.VALUE%(OCTOBER%)            = 31
1890 MAXIMUM.DAY.OF.THE.MONTH.VALUE%(NOVEMBER%)           = 30
1895 MAXIMUM.DAY.OF.THE.MONTH.VALUE%(DECEMBER%)           = 31
1900 '
1905 MINIMUM.COUNTER.VALUE%(HUNDREDTH.COUNTER.ID%)        = 0
1910 MINIMUM.COUNTER.VALUE%(SECOND.COUNTER.ID%)           = 0
1915 MINIMUM.COUNTER.VALUE%(MINUTE.COUNTER.ID%)           = 0
1920 MINIMUM.COUNTER.VALUE%(HOUR.COUNTER.ID%)             = 0
1925 MINIMUM.COUNTER.VALUE%(DAY.OF.THE.WEEK.COUNTER.ID%)  = 1
1930 MINIMUM.COUNTER.VALUE%(DAY.OF.THE.MONTH.COUNTER.ID%) = 1
1935 MINIMUM.COUNTER.VALUE%(MONTH.COUNTER.ID%)            = 1
1940 MINIMUM.COUNTER.VALUE%(YEAR.COUNTER.ID%)             = 0
1945 '
1950 DIM CLOCK.INITIALIZATION.MESSAGE$(1)
1955 DIM CLOCK.VALUE.PROMPT$(9)
1960 DIM COPYRIGHT.LINE$(2)
1965 DIM ENTER.PROMPT$(1)
1970 DIM MESSAGE$(2)
1975 DIM LOGO.TEXT$(1)
1980 DIM MONTH.DESCRIPTION$(12)
1985 DIM RESET.PROMPT$(1)
1990 DIM RESPONSE$(4)
1995 DIM RESPONSE.MESSAGE$(2)
2000 DIM TIME.BAR.LABEL$(4)
2005 '
2010 CLOCK.INITIALIZATION.MESSAGE$(1)                  = "Clock nicht initialisiert ..."
2015 '
2020 COPYRIGHT.LINE$(1)                                = "CLOCK  v " + VERSION$ + "  Clock Demonstration"
2025 COPYRIGHT.LINE$(2)                                = "Copyright (c) 1983 KAYPRO Corporation "
2030 '
2035 DAY.OF.THE.WEEK.DESCRIPTION$(SUNDAY%)             = "Sonntag"
2040 DAY.OF.THE.WEEK.DESCRIPTION$(MONDAY%)             = "Montag"
2045 DAY.OF.THE.WEEK.DESCRIPTION$(TUESDAY%)            = "Dienstag"
2050 DAY.OF.THE.WEEK.DESCRIPTION$(WEDNESDAY%)          = "Mittwoch"
2055 DAY.OF.THE.WEEK.DESCRIPTION$(THURSDAY%)           = "Donnerstag"
2060 DAY.OF.THE.WEEK.DESCRIPTION$(FRIDAY%)             = "Freitag"
2065 DAY.OF.THE.WEEK.DESCRIPTION$(SATURDAY%)           = "Samstag"
2070 '
2075 CLOCK.VALUE.PROMPT$(HUNDREDTH.COUNTER.ID%)        = "Hundertstel      (0-99)" + SPACE$(LEN(DAY.OF.THE.WEEK.DESCRIPTION$(SUNDAY%)) + 7)
2080 CLOCK.VALUE.PROMPT$(SECOND.COUNTER.ID%)           = "Sekunden         (0-59)" + SPACE$(LEN(DAY.OF.THE.WEEK.DESCRIPTION$(SUNDAY%)) + 7)
2085 CLOCK.VALUE.PROMPT$(MINUTE.COUNTER.ID%)           = "Minuten          (0-59)" + SPACE$(LEN(DAY.OF.THE.WEEK.DESCRIPTION$(SUNDAY%)) + 7)
2090 CLOCK.VALUE.PROMPT$(HOUR.COUNTER.ID%)             = "Stunden          (0-23)" + SPACE$(LEN(DAY.OF.THE.WEEK.DESCRIPTION$(SUNDAY%)) + 7)
2095 CLOCK.VALUE.PROMPT$(DAY.OF.THE.WEEK.COUNTER.ID%)  = "Wochentag        (1- 7) (" + DAY.OF.THE.WEEK.DESCRIPTION$(SUNDAY%) + " = 1)"
2100 CLOCK.VALUE.PROMPT$(DAY.OF.THE.MONTH.COUNTER.ID%) = "Tag              (1-31)" + SPACE$(LEN(DAY.OF.THE.WEEK.DESCRIPTION$(SUNDAY%)) + 7)
2105 CLOCK.VALUE.PROMPT$(MONTH.COUNTER.ID%)            = "Monat            (1-12)" + SPACE$(LEN(DAY.OF.THE.WEEK.DESCRIPTION$(SUNDAY%)) + 7)
2110 CLOCK.VALUE.PROMPT$(YEAR.COUNTER.ID%)             = "Jahr             (0-99)" + SPACE$(LEN(DAY.OF.THE.WEEK.DESCRIPTION$(SUNDAY%)) + 7)
2115 '
2120 ENTER.PROMPT$(1)                                  = "Setze die Uhr auf:"
2125 '
2130 LOGO.TEXT$(1)                                     = "C O R P O R A T I O N"
2135 '
2140 MESSAGE$(1)                                       = "    GRAPHICS     "
2145 MESSAGE$(2)                                       = " REAL TIME CLOCK "
2150 '
2155 MONTH.DESCRIPTION$(JANUARY%)                      = "Januar"
2160 MONTH.DESCRIPTION$(FEBRUARY%)                     = "Februar"
2165 MONTH.DESCRIPTION$(MARCH%)                        = "MGvArz"
2170 MONTH.DESCRIPTION$(APRIL%)                        = "April"
2175 MONTH.DESCRIPTION$(MAY%)                          = "Mai"
2180 MONTH.DESCRIPTION$(JUNE%)                         = "Juni"
2185 MONTH.DESCRIPTION$(JULY%)                         = "Juli"
2190 MONTH.DESCRIPTION$(AUGUST%)                       = "August"
2195 MONTH.DESCRIPTION$(SEPTEMBER%)                    = "September"
2200 MONTH.DESCRIPTION$(OCTOBER%)                      = "Oktober"
2205 MONTH.DESCRIPTION$(NOVEMBER%)                     = "November"
2210 MONTH.DESCRIPTION$(DECEMBER%)                     = "Dezember"
2215 '
2220 RESPONSE$(NO.LOWER.CASE%)                         = "n"
2225 RESPONSE$(NO.UPPER.CASE%)                         = "N"
2230 RESPONSE$(YES.LOWER.CASE%)                        = "j"
2235 RESPONSE$(YES.UPPER.CASE%)                        = "J"
2240 '
2245 RESET.PROMPT$(1)                                  = "Uhr stellen (" + RESPONSE$(YES.UPPER.CASE%) + "/" + RESPONSE$(NO.UPPER.CASE%) + ")? "
2250 '
2255 RESPONSE.MESSAGE$(NO%)                            = "Nein"
2260 RESPONSE.MESSAGE$(YES%)                           = "Ja"
2265 '
2270 TIME.BAR.LABEL$(HUNDREDTH.COUNTER.ID%)            = "Hundertstel:     "
2275 TIME.BAR.LABEL$(SECOND.COUNTER.ID%)               = "Sekunden:        "
2280 TIME.BAR.LABEL$(MINUTE.COUNTER.ID%)               = "Minuten:         "
2285 TIME.BAR.LABEL$(HOUR.COUNTER.ID%)                 = "Stunden:         "
2290 '
2291 '  MAIN
2292 '
2295 PRINT CLEAR.SCREEN$;
2300 PRINT COPYRIGHT.LINE$(1)
2305 PRINT COPYRIGHT.LINE$(2);
2310 FOR TIMER% = 1 TO 1000
2315 NEXT TIMER%
2320 OUT PORT.S%, PIO.PORT.A%
2325 COUNTER.ID% = CLOCK.STATUS.FLAG%
2330 GOSUB 4110
2335 CLOCK.STATUS% = CLOCK.VALUE%
2340 WHILE NOT (KEY.PRESSED$ = ESCAPE$)
2345 PRINT CLEAR.SCREEN$;
2350 PRINT RESET.PROMPT$(1);
2355 KEY.PRESSED$ = ""
2360 WHILE NOT (KEY.PRESSED$ = ESCAPE$ OR KEY.PRESSED$ = RESPONSE$(YES.UPPER.CASE%) OR KEY.PRESSED$ = RESPONSE$(YES.LOWER.CASE%) OR KEY.PRESSED$ = RESPONSE$(NO.UPPER.CASE%) OR KEY.PRESSED$ = RESPONSE$(NO.LOWER.CASE%))
2365 KEY.PRESSED$ = INKEY$
2370 WEND
2375 IF KEY.PRESSED$ <> ESCAPE$ THEN GOSUB 2390
2380 WEND
2385 END
2386 '
2387 '  SUB-1
2388 '
2390 PRINT BACKSPACE$;
2395 IF KEY.PRESSED$ = RESPONSE$(YES.UPPER.CASE%) OR KEY.PRESSED$ = RESPONSE$(YES.LOWER.CASE%) THEN PRINT RESPONSE.MESSAGE$(YES%): GOSUB 2470
2400 IF KEY.PRESSED$ = RESPONSE$(NO.UPPER.CASE%) OR KEY.PRESSED$ = RESPONSE$(NO.LOWER.CASE%) THEN PRINT RESPONSE.MESSAGE$(NO%)
2405 IF CLOCK.STATUS% <> CLOCK.INITIALIZED% THEN GOSUB 2470
2410 PRINT CURSOR.OFF$;
2415 PRINT CLEAR.SCREEN$;
2420 RESTORE
2425 FOR ROW.ID% = 1 TO 4
2430 HOLD.VALUE%(ROW.ID%) = FLAG.SET%
2435 NEXT ROW.ID%
2440 GOSUB 2855
2445 GOSUB 3375
2450 GOSUB 3510
2455 PRINT CURSOR.ON$;
2460 RETURN
2465 '
2466 '  SUB-2
2467 '
2470 PRINT CLEAR.SCREEN$;
2475 IF CLOCK.STATUS% <> CLOCK.INITIALIZED% THEN PRINT CLOCK.INITIALIZATION.MESSAGE$(1): PRINT
2480 PRINT ENTER.PROMPT$(1)
2485 PRINT
2490 COUNTER.ID% = YEAR.COUNTER.ID%
2495 GOSUB 2775
2500 YEAR.SUFFIX% = NEW.CLOCK.VALUE%
2505 IF (INT(YEAR.SUFFIX% / 4) = (YEAR.SUFFIX% / 4)) AND (INT(YEAR.SUFFIX% / 100) <> (YEAR.SUFFIX% / 100)) THEN LEAP.YEAR% = FLAG.SET% ELSE LEAP.YEAR% = FLAG.RESET%
2510 COUNTER.ID% = MONTH.COUNTER.ID%
2515 GOSUB 2775
2520 MONTH.ID% = NEW.CLOCK.VALUE%
2525 COUNTER.ID% = DAY.OF.THE.MONTH.COUNTER.ID%
2530 GOSUB 2775
2535 DAY.OF.THE.MONTH.ID% = NEW.CLOCK.VALUE%
2540 IF MONTH.ID% = JANUARY% AND DAY.OF.THE.MONTH.ID% = FIRST.DAY% THEN NEW.YEAR.STATUS% = NEW.YEAR.ACTIVE% ELSE NEW.YEAR.STATUS% = NEW.YEAR.PENDING%
2545 GOSUB 4025
2550 GOSUB 4050
2555 COUNTER.ID% = DAY.OF.THE.WEEK.COUNTER.ID%
2560 GOSUB 2775
2565 DAY.OF.THE.WEEK.ID% = NEW.CLOCK.VALUE%
2570 COUNTER.ID% = HOUR.COUNTER.ID%
2575 GOSUB 2775
2580 HOUR.ID% = NEW.CLOCK.VALUE%
2585 COUNTER.ID% = MINUTE.COUNTER.ID%
2590 GOSUB 2775
2595 MINUTE.ID% = NEW.CLOCK.VALUE%
2600 COUNTER.ID% = SECOND.COUNTER.ID%
2605 GOSUB 2775
2610 SECOND.ID% = NEW.CLOCK.VALUE%
2615 COUNTER.ID%      = YEAR.COUNTER.ID%
2620 NEW.CLOCK.VALUE% = YEAR.SUFFIX%
2625 GOSUB 4075
2630 COUNTER.ID%      = MONTH.COUNTER.ID%
2635 NEW.CLOCK.VALUE% = MONTH.ID%
2640 GOSUB 4075
2645 COUNTER.ID%      = MONTH.HOLD.COUNTER.ID%
2650 NEW.CLOCK.VALUE% = MONTH.ID%
2655 GOSUB 4075
2660 COUNTER.ID%      = DAY.OF.THE.MONTH.COUNTER.ID%
2665 NEW.CLOCK.VALUE% = DAY.OF.THE.MONTH.ID%
2670 GOSUB 4075
2675 COUNTER.ID%      = DAY.OF.THE.WEEK.COUNTER.ID%
2680 NEW.CLOCK.VALUE% = DAY.OF.THE.WEEK.ID%
2685 GOSUB 4075
2690 COUNTER.ID%      = HOUR.COUNTER.ID%
2695 NEW.CLOCK.VALUE% = HOUR.ID%
2700 GOSUB 4075
2705 COUNTER.ID%      = MINUTE.COUNTER.ID%
2710 NEW.CLOCK.VALUE% = MINUTE.ID%
2715 GOSUB 4075
2720 COUNTER.ID%      = SECOND.COUNTER.ID%
2725 NEW.CLOCK.VALUE% = SECOND.ID%
2730 GOSUB 4075
2735 COUNTER.ID%      = HUNDREDTH.COUNTER.ID%
2740 NEW.CLOCK.VALUE% = 0
2745 GOSUB 4075
2750 COUNTER.ID%      = CLOCK.STATUS.FLAG%
2755 NEW.CLOCK.VALUE% = CLOCK.INITIALIZED%
2760 GOSUB 4075
2765 CLOCK.STATUS% = CLOCK.INITIALIZED%
2770 RETURN
2771 '
2772 '  SUB-3
2773 '
2775 CLOCK.VALUE.OK% = FLAG.RESET%
2780 WHILE NOT CLOCK.VALUE.OK%
2785 PRINT CLEAR.LINE$;
2790 PRINT CLOCK.VALUE.PROMPT$(COUNTER.ID%);
2795 INPUT; NEW.CLOCK.VALUE%
2800 IF COUNTER.ID% = DAY.OF.THE.MONTH.COUNTER.ID% THEN GOSUB 2825
2805 IF NEW.CLOCK.VALUE% >= MINIMUM.COUNTER.VALUE%(COUNTER.ID%) AND NEW.CLOCK.VALUE% <= MAXIMUM.COUNTER.VALUE%(COUNTER.ID%) THEN CLOCK.VALUE.OK% = FLAG.SET%
2810 WEND
2815 PRINT
2820 RETURN
2821 '
2822 '  SUB-4
2823 '
2825 MAXIMUM.COUNTER.VALUE%(COUNTER.ID%) = MAXIMUM.DAY.OF.THE.MONTH.VALUE%(MONTH.ID%)
2830 IF MONTH.ID% = FEBRUARY% AND LEAP.YEAR% THEN MAXIMUM.COUNTER.VALUE%(COUNTER.ID%) = MAXIMUM.COUNTER.VALUE%(COUNTER.ID%) + 1
2835 IF MONTH.ID% = FEBRUARY% AND LEAP.YEAR% AND NEW.CLOCK.VALUE% = 29 THEN LEAP.DAY.STATUS% = LEAP.DAY.ACTIVE% ELSE LEAP.DAY.STATUS% = FLAG.RESET%
2840 IF LEAP.DAY.STATUS% = LEAP.DAY.ACTIVE% THEN NEW.CLOCK.VALUE% = 28 
2845 RETURN
2850 '
2851 '  SUB-5
2852 '
2855 PRINT CURSOR.HOME$;
2860 PRINT FNLOGO.LINE$(0,  0, 0,  5)
2865 PRINT FNLOGO.LINE$(0, 12, 0, 17)
2870 PRINT FNLOGO.LINE$(0, 20, 0, 27)
2875 PRINT FNLOGO.LINE$(0, 30, 0, 35)
2880 PRINT FNLOGO.LINE$(0, 42, 0, 47)
2885 PRINT FNLOGO.LINE$(0, 50, 0, 59)
2890 PRINT FNLOGO.LINE$(0, 63, 0, 75)
2895 PRINT FNLOGO.LINE$(0, 82, 0, 93)
2900 PRINT CURSOR.HOME$;
2905 PRINT FNLOGO.LINE$(2,  0, 2,  5)
2910 PRINT FNLOGO.LINE$(2, 10, 2, 15)
2915 PRINT FNLOGO.LINE$(2, 19, 2, 28)
2920 PRINT FNLOGO.LINE$(2, 31, 2, 36)
2925 PRINT FNLOGO.LINE$(2, 41, 2, 46)
2930 PRINT FNLOGO.LINE$(2, 49, 2, 51)
2935 PRINT FNLOGO.LINE$(2, 55, 2, 62)
2940 PRINT FNLOGO.LINE$(2, 65, 2, 67)
2945 PRINT FNLOGO.LINE$(2, 71, 2, 78)
2950 PRINT FNLOGO.LINE$(2, 81, 2, 85)
2955 PRINT FNLOGO.LINE$(2, 90, 2, 95)
2960 PRINT CURSOR.HOME$;
2965 PRINT FNLOGO.LINE$(4,  0, 4,  5)
2970 PRINT FNLOGO.LINE$(4,  8, 4, 13)
2975 PRINT FNLOGO.LINE$(4, 18, 4, 29)
2980 PRINT FNLOGO.LINE$(4, 32, 4, 37)
2985 PRINT FNLOGO.LINE$(4, 40, 4, 45)
2990 PRINT FNLOGO.LINE$(4, 48, 4, 51)
2995 PRINT FNLOGO.LINE$(4, 56, 4, 63)
3000 PRINT FNLOGO.LINE$(4, 66, 4, 67)
3005 PRINT FNLOGO.LINE$(4, 72, 4, 79)
3010 PRINT FNLOGO.LINE$(4, 82, 4, 84)
3015 PRINT FNLOGO.LINE$(4, 91, 4, 96)
3020 PRINT CURSOR.HOME$;
3025 PRINT FNLOGO.LINE$(6,  0, 6, 5)
3030 PRINT FNLOGO.LINE$(6,  6, 6, 11)
3035 PRINT FNLOGO.LINE$(6, 17, 6, 22)
3040 PRINT FNLOGO.LINE$(6, 25, 6, 30)
3045 PRINT FNLOGO.LINE$(6, 33, 6, 44)
3050 PRINT FNLOGO.LINE$(6, 47, 6, 51)
3055 PRINT FNLOGO.LINE$(6, 55, 6, 62)
3060 PRINT FNLOGO.LINE$(6, 65, 6, 67)
3065 PRINT FNLOGO.LINE$(6, 71, 6, 78)
3070 PRINT FNLOGO.LINE$(6, 81, 6, 84)
3075 PRINT FNLOGO.LINE$(6, 91, 6, 96)
3080 PRINT CURSOR.HOME$;
3085 PRINT FNLOGO.LINE$(8,  0, 8,  5)
3090 PRINT FNLOGO.LINE$(8,  6, 8, 11)
3095 PRINT FNLOGO.LINE$(8, 16, 8, 21)
3100 PRINT FNLOGO.LINE$(8, 26, 8, 31)
3105 PRINT FNLOGO.LINE$(8, 35, 8, 42)
3110 PRINT FNLOGO.LINE$(8, 46, 8, 59)
3115 PRINT FNLOGO.LINE$(8, 63, 8, 75)
3120 PRINT FNLOGO.LINE$(8, 79, 8, 84)
3125 PRINT FNLOGO.LINE$(8, 91, 8, 96)
3130 PRINT CURSOR.HOME$;
3135 PRINT FNLOGO.LINE$(10,  0, 10,  5)
3140 PRINT FNLOGO.LINE$(10,  8, 10, 13)
3145 PRINT FNLOGO.LINE$(10, 15, 10, 32)
3150 PRINT FNLOGO.LINE$(10, 36, 10, 41)
3155 PRINT FNLOGO.LINE$(10, 46, 10, 51)
3160 PRINT FNLOGO.LINE$(10, 62, 10, 67)
3165 PRINT FNLOGO.LINE$(10, 72, 10, 77)
3170 PRINT FNLOGO.LINE$(10, 80, 10, 84)
3175 PRINT FNLOGO.LINE$(10, 91, 10, 96)
3180 PRINT CURSOR.HOME$;
3185 PRINT FNLOGO.LINE$(12,  0, 12,  5)
3190 PRINT FNLOGO.LINE$(12, 10, 12, 15)
3195 PRINT FNLOGO.LINE$(12, 17, 12, 33)
3200 PRINT FNLOGO.LINE$(12, 36, 12, 41)
3205 PRINT FNLOGO.LINE$(12, 46, 12, 51)
3210 PRINT FNLOGO.LINE$(12, 62, 12, 67)
3215 PRINT FNLOGO.LINE$(12, 73, 12, 78)
3220 PRINT FNLOGO.LINE$(12, 81, 12, 85)
3225 PRINT FNLOGO.LINE$(12, 90, 12, 95)
3230 PRINT CURSOR.HOME$;
3235 PRINT FNLOGO.LINE$(14,  0, 14,  5)
3240 PRINT FNLOGO.LINE$(14, 12, 14, 17)
3245 PRINT FNLOGO.LINE$(14, 28, 14, 34)
3250 PRINT FNLOGO.LINE$(14, 36, 14, 41)
3255 PRINT FNLOGO.LINE$(14, 46, 14, 51)
3260 PRINT FNLOGO.LINE$(14, 62, 14, 67)
3265 PRINT FNLOGO.LINE$(14, 74, 14, 79)
3270 PRINT FNLOGO.LINE$(14, 82, 14, 93)
3275 PRINT FNPOSITION.CURSOR$(LOGO.TEXT.ROW%, LOGO.TEXT.COLUMN%);
3280 PRINT LOGO.TEXT$(1);
3285 PRINT CURSOR.HOME$;
3290 PRINT FNDRAW.LINE$(BORDER.TOP.ROW%, BORDER.LEFT.COLUMN%, BORDER.TOP.ROW%, BORDER.RIGHT.COLUMN%)
3295 PRINT FNDRAW.LINE$(BORDER.TOP.ROW%, BORDER.RIGHT.COLUMN%, BORDER.BOTTOM.ROW%, BORDER.RIGHT.COLUMN%)
3300 PRINT FNDRAW.LINE$(BORDER.BOTTOM.ROW%, BORDER.RIGHT.COLUMN%, BORDER.BOTTOM.ROW%, BORDER.LEFT.COLUMN%)
3305 PRINT FNDRAW.LINE$(BORDER.BOTTOM.ROW%, BORDER.LEFT.COLUMN%, BORDER.TOP.ROW%, BORDER.LEFT.COLUMN%)
3310 PRINT CURSOR.HOME$;
3315 PRINT INVERSE.ON$;
3320 PRINT REDUCED.ON$;
3325 PRINT UNDERLINE.ON$;
3330 PRINT FNPOSITION.CURSOR$(MESSAGE.ROW%, MESSAGE.COLUMN%);
3335 PRINT MESSAGE$(1)
3340 PRINT FNPOSITION.CURSOR$((MESSAGE.ROW% + 1), MESSAGE.COLUMN%);
3345 PRINT MESSAGE$(2)
3350 PRINT UNDERLINE.OFF$;
3355 PRINT REDUCED.OFF$;
3360 PRINT INVERSE.OFF$;
3365 RETURN
3370 '
3371 ' SUB-6
3372 '
3375 TIME.LINE.ROW% = FIRST.TIME.LINE.ROW%
3380 FOR TIME.LINE% = 4 TO 1 STEP -1
3385 READ TIME.BAR.AREA$, TIME.BAR.SCALE$
3390 PRINT FNPOSITION.CURSOR$(TIME.LINE.ROW%, TIME.LINE.COLUMN%);
3395 PRINT TIME.BAR.LABEL$(TIME.LINE%);
3400 PRINT TIME.BAR.LEFT.BORDER$;
3405 PRINT UNDERLINE.ON$;
3410 PRINT REDUCED.ON$;
3415 PRINT TIME.BAR.AREA$;
3420 PRINT REDUCED.OFF$;
3425 PRINT UNDERLINE.OFF$;
3430 PRINT TIME.BAR.RIGHT.BORDER$
3435 PRINT FNPOSITION.CURSOR$((TIME.LINE.ROW% + 1), TIME.LINE.COLUMN%);
3440 PRINT TIME.BAR.SCALE$
3445 TIME.LINE.ROW% = TIME.LINE.ROW% + TIME.LINE.SPREAD%
3450 NEXT TIME.LINE%
3455 COUNTER.ID% = MONTH.COUNTER.ID%
3460 GOSUB 4110
3465 MONTH.ID% = CLOCK.VALUE%
3470 COUNTER.ID% = MONTH.HOLD.COUNTER.ID%
3475 GOSUB 4110
3480 MONTH.HOLD.ID% = CLOCK.VALUE%
3485 IF MONTH.ID% <> MONTH.HOLD.ID% THEN ROLLOVER% = FLAG.SET% ELSE ROLLOVER% = FLAG.RESET%
3490 GOSUB 3685
3495 ROLLOVER% = FLAG.RESET%
3500 RETURN
3505 '
3506 '  SUB-7
3507 '
3510 WHILE NOT (INKEY$ = ESCAPE$)
3515 COUNTER.ID% = HOUR.COUNTER.ID%
3520 ROW.ID%     = HOUR.ROW.ID%
3525 GOSUB 3590
3530 COUNTER.ID% = MINUTE.COUNTER.ID%
3535 ROW.ID%     = MINUTE.ROW.ID%
3540 GOSUB 3590
3545 COUNTER.ID% = SECOND.COUNTER.ID%
3550 ROW.ID%     = SECOND.ROW.ID%
3555 GOSUB 3590
3560 COUNTER.ID% = HUNDREDTH.COUNTER.ID%
3565 ROW.ID%     = HUNDREDTH.ROW.ID%
3570 GOSUB 3590
3575 WEND
3580 IF LEAP.DAY.STATUS% = LEAP.DAY.ROLLOVER% THEN LEAP.DAY.STATUS% = LEAP.DAY.RESTART%: GOSUB 4050
3585 RETURN
3586 '
3587 '  SUB-8
3588 '
3590 GOSUB 4110
3595 IF HOLD.VALUE%(ROW.ID%) <> CLOCK.VALUE% THEN ROLLOVER% = FLAG.SET%
3600 IF ROLLOVER% AND HOLD.VALUE%(ROW.ID%) <> FLAG.SET% AND COUNTER.ID% = HOUR.COUNTER.ID% AND CLOCK.VALUE% = 0 THEN GOSUB 3685: CLOCK.VALUE% = 0
3605 IF ROLLOVER% THEN GOSUB 3615
3610 RETURN
3611 '
3612 '  SUB-9
3613 '
3615 PRINT INVERSE.ON$;
3620 PRINT UNDERLINE.ON$;
3625 PRINT FNPOSITION.CURSOR$(CLOCK.ROW%(ROW.ID%), CLOCK.COLUMN%);
3630 PRINT USING " ## "; CLOCK.VALUE%;
3635 PRINT CURSOR.HOME$;
3640 PRINT UNDERLINE.OFF$
3645 PRINT INVERSE.OFF$
3650 TIME.BAR.ROW%    = (FIRST.TIME.BAR.ROW% + ((ROW.ID% - 1) * TIME.BAR.SPREAD%) + 1)
3655 IF CLOCK.VALUE% < HOLD.VALUE%(ROW.ID%) THEN PRINT FNERASE.LINE$(TIME.BAR.ROW%, TIME.BAR.COLUMN%, TIME.BAR.ROW%, (TIME.BAR.COLUMN% + HOLD.VALUE%(ROW.ID%)))
3660 PRINT FNDRAW.LINE$(TIME.BAR.ROW%, TIME.BAR.COLUMN%, TIME.BAR.ROW%, (TIME.BAR.COLUMN% + CLOCK.VALUE%))
3665 HOLD.VALUE%(ROW.ID%) = CLOCK.VALUE%
3670 ROLLOVER%            = FLAG.RESET%
3675 RETURN
3680 '
3681 '  SUB-10
3682 '
3685 COUNTER.ID% = YEAR.COUNTER.ID%
3690 GOSUB 4110
3695 YEAR.SUFFIX% = CLOCK.VALUE%
3700 COUNTER.ID% = NEW.YEAR.STATUS.FLAG%
3705 GOSUB 4110
3710 NEW.YEAR.STATUS% = CLOCK.VALUE%
3715 IF (INT(YEAR.SUFFIX% / 4) = (YEAR.SUFFIX% / 4)) AND (INT(YEAR.SUFFIX% / 100) <> (YEAR.SUFFIX% / 100)) THEN LEAP.YEAR% = FLAG.SET%
3720 COUNTER.ID% = MONTH.COUNTER.ID%
3725 GOSUB 4110
3730 MONTH.ID% = CLOCK.VALUE%
3735 COUNTER.ID% = DAY.OF.THE.MONTH.COUNTER.ID%
3740 GOSUB 4110
3745 DAY.OF.THE.MONTH.ID% = CLOCK.VALUE%
3750 IF MONTH.ID% = JANUARY% AND DAY.OF.THE.MONTH.ID% = FIRST.DAY% THEN NEW.YEAR% = FLAG.SET% ELSE NEW.YEAR% = FLAG.RESET%
3755 IF (NOT NEW.YEAR%) AND NEW.YEAR.STATUS% = NEW.YEAR.ACTIVE% THEN NEW.YEAR.STATUS% = NEW.YEAR.PENDING%: GOSUB 4025
3760 IF NEW.YEAR% AND NEW.YEAR.STATUS% = NEW.YEAR.PENDING% THEN GOSUB 3955
3765 YEAR.ID% = (YEAR.PREFIX% * 100) + YEAR.SUFFIX%
3770 COUNTER.ID% = LEAP.DAY.STATUS.FLAG%
3775 GOSUB 4110
3780 LEAP.DAY.STATUS% = CLOCK.VALUE%
3785 IF LEAP.DAY.STATUS% = LEAP.DAY.RESTART% AND MONTH.ID% = FEBRUARY% THEN LEAP.DAY.STATUS% = LEAP.DAY.ACTIVE%
3790 IF LEAP.DAY.STATUS% = LEAP.DAY.RESTART% AND MONTH.ID% = MARCH% THEN LEAP.DAY.STATUS% = LEAP.DAY.ROLLOVER%
3795 IF ROLLOVER% AND LEAP.YEAR% AND MONTH.ID% = MARCH% AND DAY.OF.THE.MONTH.ID% = FIRST.DAY% AND LEAP.DAY.STATUS% <> LEAP.DAY.ROLLOVER% THEN GOSUB 3905
3800 COUNTER.ID%      = MONTH.HOLD.COUNTER.ID%
3805 NEW.CLOCK.VALUE% = MONTH.ID%
3810 GOSUB 4075
3815 IF LEAP.DAY.STATUS% = LEAP.DAY.ACTIVE% THEN DAY.OF.THE.MONTH.ID% = 29
3820 COUNTER.ID% = DAY.OF.THE.WEEK.COUNTER.ID%
3825 GOSUB 4110
3830 DAY.OF.THE.WEEK.ID% = CLOCK.VALUE%
3835 PRINT FNPOSITION.CURSOR$(DATE.ROW%, DATE.COLUMN%);
3840 PRINT SPACE$(DATE.LENGTH%);
3845 PRINT FNPOSITION.CURSOR$(DATE.ROW%, DAY.OF.THE.WEEK.COLUMN%);
3850 PRINT SPACE$(DAY.OF.THE.WEEK.LENGTH%);
3855 PRINT INVERSE.ON$;
3860 PRINT FNPOSITION.CURSOR$(DATE.ROW%, DATE.COLUMN%);
3865 IF DATE.FORMAT% = AMERICAN% THEN GOSUB 3990 ELSE GOSUB 4005
3870 PRINT FNPOSITION.CURSOR$(DATE.ROW%, DAY.OF.THE.WEEK.COLUMN%);
3875 PRINT " "; DAY.OF.THE.WEEK.DESCRIPTION$(DAY.OF.THE.WEEK.ID%); " ";
3880 PRINT INVERSE.OFF$;
3885 PRINT CURSOR.HOME$
3890 IF LEAP.DAY.STATUS% = LEAP.DAY.ROLLOVER% THEN LEAP.DAY.STATUS% = FLAG.RESET%: GOSUB 4050
3895 IF LEAP.DAY.STATUS% = LEAP.DAY.ACTIVE% THEN LEAP.DAY.STATUS% = LEAP.DAY.ROLLOVER%: GOSUB 4050
3900 RETURN
3901 '
3902 '  SUB-11
3903 '
3905 COUNTER.ID%      = MONTH.COUNTER.ID%
3910 NEW.CLOCK.VALUE% = FEBRUARY%
3915 GOSUB 4075
3920 MONTH.ID%        = FEBRUARY%
3925 COUNTER.ID%      = DAY.OF.THE.MONTH.COUNTER.ID%
3930 NEW.CLOCK.VALUE% = 28
3935 GOSUB 4075
3940 LEAP.DAY.STATUS% = LEAP.DAY.ACTIVE%
3945 GOSUB 4050
3950 RETURN
3951 '
3952 '  SUB-12
3953 '
3955 YEAR.SUFFIX% = YEAR.SUFFIX% + 1
3960 COUNTER.ID%      = YEAR.COUNTER.ID%
3965 NEW.CLOCK.VALUE% = YEAR.SUFFIX%
3970 GOSUB 4075
3975 NEW.YEAR.STATUS% = NEW.YEAR.ACTIVE%
3980 GOSUB 4025
3985 RETURN
3986 '
3987 '  SUB-13
3988 '
3990 PRINT " "; MONTH.DESCRIPTION$(MONTH.ID%);
3995 PRINT STR$(DAY.OF.THE.MONTH.ID%); ","; YEAR.ID%;
4000 RETURN
4001 '
4002 '  SUB-14
4003 '
4005 PRINT STR$(DAY.OF.THE.MONTH.ID%); ". "; MONTH.DESCRIPTION$(MONTH.ID%);
4010 PRINT YEAR.ID%;
4015 RETURN
4020 '
4021 '  SUB-15
4022 '
4025 COUNTER.ID%      = NEW.YEAR.STATUS.FLAG%
4030 NEW.CLOCK.VALUE% = NEW.YEAR.STATUS%
4035 GOSUB 4075
4040 RETURN
4045 '
4046 ' SUB-16
4047 '
4050 COUNTER.ID%      = LEAP.DAY.STATUS.FLAG%
4055 NEW.CLOCK.VALUE% = LEAP.DAY.STATUS%
4060 GOSUB 4075
4065 RETURN
4070 '
4071 '  SUB-17
4072 '
4075 SET.TENS%        = INT(NEW.CLOCK.VALUE% / 10)
4080 SET.ONES%        = NEW.CLOCK.VALUE% - 10 * SET.TENS%
4085 BCD.CLOCK.VALUE% = 16 * SET.TENS% + SET.ONES%
4090 OUT PORT.A%, COUNTER.ID%
4095 OUT PORT.D%, BCD.CLOCK.VALUE%
4100 RETURN
4105 '
4106 '  SUB-18
4107 '
4110 OUT PORT.A%, COUNTER.ID%
4115 BCD.CLOCK.VALUE% = INP(PORT.D%)
4120 GET.SIXTEENS%    = INT(BCD.CLOCK.VALUE% / 16)
4125 GET.ONES%        = BCD.CLOCK.VALUE% - 16 * GET.SIXTEENS%
4130 CLOCK.VALUE%     = 10 * GET.SIXTEENS% + GET.ONES%
4135 RETURN
4140 '
4141 '  DATA
4142 '
4145 DATA                   "            "
4150 DATA "                  0    12   23"
4155 DATA                   "                              "
4160 DATA "                  0   10   20   30   40   50  59"
4165 DATA                   "                              "
4170 DATA "                  0   10   20   30   40   50  59"
4175 DATA                   "                                                  "
4180 DATA "                  0   10   20   30   40   50   60   70   80   90  99"
