; MKP4-10.ASM --	Kaypro 4/10 overlay file for MDM730.    5/24/84
;
; This is a slightly modified version of M7KP-2.ASM and is set up to 
; default to 1200 baud, 8bits, 1stopbit, no parity.  Runs great on Kaypro
; 4 & 10 (Clock set for 4mz). Baud can be reset to 300 by SET Command. 
; It has been written not to exceed 896 bytes, a constraint documented
; in M7KP-1.ASM.  Because of this, some code was taken out.
; (Baudrate can be set only to 300 or 1200). Also set for Touchtone, which
; can also be changed. 
;
;
; Edit this file for your preferences then follow the "TO USE:", example
; shown below.
;
;    Edit Examples:
;       CLOCK:  20 or 40  (20 will run at 2mz for Kaypro-2, 40 for 4&10)
;       TOUCHPULSE: 'T' or 'P' (Touchtone or Pulse Dialing)
;       MSPEED: 1 or 5   (1=300 baud, 5=1200 baud)
;       SYSVER: 'Version For Kaypro 4-10' (Change to what you want)
;       SETBD:  A,05H or A,07H  (This is to set initial baud rate)
;                               (05H=300 and 07H=1200            ) 
;
;
; TO USE: First edit this file filling in answers for your own
;		equipment.  Then assemble with ASM.COM or equivalent
;		assembler.   Use MLOAD21 to overlay the results of this
;		program to the original MDM730.COM file:
;
;		A>MLOAD21 *YOUNAME.COM=MDM730.COM, MKP4-10
;               *Name the new file whatever you wish.
;
; If you don't want to change anything, just use the KM1200.COM file
; included in the library.  It runs as described in the first paragraph. 
;
; If you want to also use the autodial phone number directory feature,
; use ASM to assemble the M7NM-6.ASM file and include it on the MLOAD21
; command line:
;
;                A>MLOAD21 *YOUNAME.COM=MDM730.COM,MKP4-10,M7NM-6
;
;  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =
;  Overlay code begins here-
BELL:		EQU	07H		;bell
CR:		EQU	0DH		;carriage return
ESC:		EQU	1BH		;escape
LF:		EQU	0AH		;linefeed
;
YES:		EQU	0FFH
NO:		EQU	0
;
PORT:		EQU	04H		;Kaypro	II,4,10 serial output port
MODCTL1:	EQU	PORT+2		;Modem control port
MODDATP:	EQU	PORT		;Modem data port
MODCTL2:	EQU	PORT+2		;Modem control port
;
MODRCVB:EQU	01H	;Your bit to test for receive   .... ...1
MODRCVR:EQU	01H	;Your value when receive ready  .... ...1
;                       ;Int pending                    .... ..1.
MODSNDB:EQU	04H	;Your bit to test for send      .... .1..
MODSNDR:EQU	04H	;Your value when send ready     .... .1..
;DCT:   EQU     80H     ;data carier detect             .... 1...
;                       ;sync hunt                      ...1 ....
;                       ;Clear to Send                  ..1. ....
;                       ;Tx underrun                    .1.. ....
;                       ;Break/Abort                    1... ....
;
; The following are used in setting up the Z80 SIO.
;
;                       ;all sent                       .... ...1
;                       ;parity error                   ...1 ....
;                       ;overrun error                  ..10 ....
;                       ;framing error                  .1.. ....
;                       ;end of frame (SDLC)            1... ....
;WRREG0
;                       ;write to register              .... .xxx
;                       ;reset flags                    ..xx x...
RSTERR:	EQU	30H	;reset parity and overrun flags	..11 0...
RSTINS:	EQU	18H	;reset SIO - register 0         ..01 1...
WRREG1:	EQU	0	;no interrupts - register 1
;                       ;ext int enable                 .... ...1
;                       ;tx int enable                  .... ..1.
;                       ;rx int disable                 ...0 0...
;                       ;rx int on first character      ...0 1...
;                       ;int on all rx char/parity eff  ...1 0...
;                       ;int on all rx char             ...1 1...
;                       ;wait/ready on r/t              ..1. ....
;                       ;wait/ready function            .1.. ....
;                       ;wait/ready enable              1... ....
;
;			;register 3 equates
WRREG3:	EQU	0C1H	;8 Rx bits, Rx enable
RENABLE	EQU	1	;Rx enable -			.... ...1
;                       ;sync character load inhibit -  .... ..1.
;                       ;address serch mode (SDLC) -    .... .1..
;                       ;Rx CRC enabel -                .... 1...
;                       ;Enter hunt phase               ...1 ....
;                       ;Auto enables                   ..1. ....
MSKWD:	EQU	0C0H	;word length mask -		xx.. ....
;                       ;receive five bit work -        00.. ....
RSEVEN:	EQU	040H	;receive seven bit word	-	01.. ....
;                       ;receive six bit word -         10.. ....
REIGHT:	EQU	0C0H	;receive eight bit word	-	11.. ....
;
;			;register 4 equates
WRREG4:	EQU	44H	;16X baud rate,	1 stop bit, no parity
MSKPA:	EQU	03H	;mask for parity bits -		.... ..xx
NONE:	EQU	00H	;no parity -			.... ..00
ODD:	EQU	01H	;odd parity -			.... ..01
EVEN:	EQU	03H	;even parity -			.... ..11
MSKST:	EQU	0CH	;stop bit mask -		.... xx..
;                       ;sync modes enable -            .... 00..
ONE:	EQU	04H	;one stop bit  -		.... 01..
;      	       	       	;1.5 STOP BITS -		.... 10..
TWO:	EQU	0CH	;two stop bits -		.... 11..
;                       ;sync modes -                   ..xx ....
;CLK01: EQU     00H     ;1X clock mode -                00.. ....
CLK16:	EQU	40H	;16X clock mode -               01.. ....
;CLK32: EQU     80H     ;32X clock mode -               10.. ....
;CLK64: EQU     c0H     ;64X clock mode -               11.. ....
;			;register 5 equates
WRREG5:	EQU	0EAH	;8 Tx bits, Tx enable, RTS, DTR
;TXCRC  EQU     001H    ;Tx CRC enable                  .... ...1
;RTS    EQU     002H    ;Request to send                .... ..1.
;SLDC   EQU     004H    ;SDLC/CRC-16                    .... .1..
TENABLE:EQU	008H	;Tx enable			.... 1...
;BREAK  EQU     010H    ;Send break                     ...1 ....
;                       ;Transmit five bit word -       .00. ....
TSEVEN:	EQU	020H	;Transmit seven	bit word -	.01. ....
;                       ;Transmit six bit word -        .10. ....
TEIGHT:	EQU	060H	;Transmit eight	bit word -	.11. ....
;DTR    EQU     080H    ;Data terminal ready            1... ....
DTRON:	EQU	08AH	;Tx enable, RTS, DTR -		1... 1.1.
DTROFF:	EQU	000H	;DTR off, RTS off -		0... ..0.
;
		ORG	100H
;
; Change the clock speed as needed for your system.
;
		DS	3	;(for  "JMP   START" instruction)
;
PMMIMODEM:	DB	NO	;yes=PMMI S-100	Modem			103H
SMARTMODEM:	DB	YES	;yes=HAYES Smartmodem, no=non-PMMI	104H
TOUCHPULSE:	DB	'T'	;T=touch, P=pulse (Smartmodem-only)	105H
CLOCK:		DB	40	;clock speed in	MHz x10, 25.5 MHz max.	106H
				;20=2 MHh, 37=3.68 MHz,	40=4 MHz, etc.
MSPEED:		DB	1	;0=110 1=300 2=450 3=600 4=710 5=1200	107H
				;6=2400	7=4800 8=9600 9=19200 default
BYTDLY:		DB	5	;0=0 delay  1=10ms  5=50 ms - 9=90 ms	108H
				;default time to send character	in ter-
				;minal mode file transfer for slow BBS.
CRDLY:		DB	5	;0=0 delay 1=100 ms 5=500 ms - 9=900 ms	109H
				;default time for extra	wait after CRLF
				;in terminal mode file transfer
NOOFCOL:	DB	5	;number	of DIR columns shown		10AH
SETUPTST:	DB	YES	;yes=user-added	Setup routine		10BH
SCRNTEST:	DB	YES	;Cursor	control	routine			10CH
ACKNAK:		DB	YES	;yes=resend a record after any non-ACK	10DH
				;no=resend a record after a valid NAK
BAKUPBYTE:	DB	NO	;yes=change any	file same name to .BAK	10EH
CRCDFLT:	DB	YES	;yes=default to	CRC checking		10FH
TOGGLECRC:	DB	YES	;yes=allow toggling of CRC to Checksum	110H
CONVBKSP:	DB	NO	;yes=convert backspace to rub		111H
TOGGLEBK:	DB	NO	;yes=allow toggling of bksp to rub	112H
ADDLF:		DB	NO	;no=no LF after	CR to send file	in	113H
				;terminal mode (added by remote	echo)
TOGGLELF:	DB	YES	;yes=allow toggling of LF after	CR	114H
TRANLOGON:	DB	YES	;yes=allow transmission	of logon	115H
				;write logon sequence at location LOGON
SAVCCP:		DB	YES	;yes=do	not overwrite CCP		116H
LOCONEXTCHR:	DB	NO	;yes=local command if EXTCHR precedes	117H
				;no=external command if	EXTCHR precedes
TOGGLELOC:	DB	YES	;yes=allow toggling of LOCONEXTCHR	118H
LSTTST:		DB	YES	;yes=printer available on printer port	119H
XOFFTST:	DB	NO	;yes=chcks for XOFF from remote	while	11AH
				;sending a file	in terminal mode
XONWAIT:	DB	NO	;yes=wait for XON after	CR while	11BH
				;sending a file	in terminal mode
TOGXOFF:	DB	YES	;yes=allow toggling of XOFF checking	11CH
IGNORCTL:	DB	NO	;yes=CTL-chars above ^M	not displayed	11DH
EXTRA1:		DB	0	;for future expansion			11EH
EXTRA2:		DB	0	;for future expansion			11FH
BRKCHR:		DB	'@'-40H	;^@ = Send a 300 ms. break tone		120H
NOCXNNCT:	DB	'N'-40H	;^N = Disconnect from the phone	line	121H
LOGCHR:		DB	'L'-40H	;^L = Send logon			122H
LSTCHR:		DB	'P'-40H	;^P = Toggle printer			123H
UNSAVE:		DB	'R'-40H	;^R = Close input text buffer		124H
TRANCHR:	DB	'T'-40H	;^T = Transmit file to remote		125H
SAVECHR:	DB	'Y'-40H	;^Y = Open input text buffer		126H
EXTCHR:		DB	'^'-40H	;^^ = Send next	character		127H
PULSERATE:	DS	1	;                                       128H
CHGBAUD		DS	1	;        				129H
;
IN$MODCTL1:	MVI	A,10H		;channel 0, reset interrupts.	12AH
		OUT	MODCTL1
		IN	MODCTL1		;get the status	bits
		RET
		DB	0,0,0
;
OUT$MODDATP:	OUT	MODDATP	! RET	;out modem data	port		134H
		DB	0,0,0,0,0,0,0
IN$MODDATP:	IN	MODDATP	! RET	;in modem data port		13EH
		DB	0,0,0,0,0,0,0
ANI$MODRCVB:	ANI	MODRCVB	! RET	;bit to	test for receive ready	148H
CPI$MODRCVR:	CPI	MODRCVR	! RET	;value of receive bit when rdy	14BH
ANI$MODSNDB:	ANI	MODSNDB	! RET	;bit to	test for send ready	14EH
CPI$MODSNDR:	CPI	MODSNDR	! RET	;value of send bit when	ready	151H
IN$BAUDRP:	DS	3		;IN baudrate port               154H
OUT$BAUDRP:	DS	3		;OUT baudrate port              157H
OUT$MODCTL1:	OUT	MODCTL1	! RET	;out modem control port		15AH
OUT$MODCTL2:	OUT	MODCTL2	! RET	;out modem status port		15DH
;
LOGONPTR:	DW	LOGON		;for user message.		160H
JMP$DAIL:	DS	3		;Use routine in	main program	162H
JMP$DISCONNT:	DS	3		;Use routine in	main program	165H
JMP$GOODBYE:	JMP	GOODBYE		;Routine in this overlay	168H
JMP$INITMOD:	JMP	INITMOD		;Initialization	in this	overlay	16BH
JMP$NEWBAUD:	RET  !	NOP  !	NOP	;Bypass	PMMI routine		16EH
JMP$NOPARITY:	RET  !	NOP  !	NOP	;Bypass	PMMI routine		171H
JMP$PARITY:	RET  !	NOP  !	NOP	;Bypass	PMMI routine		174H
JMP$SETUPR:	JMP	SETUPR		;Set command in	this overlay	177H
JMP$SPCLMENU:	RET  !	NOP  !	NOP	;Bypass	special	menu routine	17AH
JMP$SYSVER:	JMP	SYSVER		;Version message in this overlay17DH
JMP$BREAK:	JMP	SENDBRK		;Break	routine	in this	overlay	180H
;
;
; Do not change	the following six lines, the routine are in main program.
;
JMP$ILPRT:	DS	3		;Inline	print routine		183H
JMP$INBUF	DS	3		;Input buffer routine		186H
JMP$INLNCOMP:	DS	3		;Inline	compare	routine		189H
JMP$INMODEM	DS	3		;				18CH
JMP$NXTSCRN:	DS	3		;				18FH
JMP$TIMER:	DS	3		;Timer routine			192H
;
; Clear	sequences -- CLREOS is clear to	end of screen, CLRSCRN is clear
; entire screen.  Last entry must be 0.  Any other 0's act as NOP's.
;
CLREOS:		CALL	JMP$ILPRT	;				195H
		DB	017H,0,0,0,0	;				198H
		RET			;				19DH
;
CLRSCRN:	CALL	JMP$ILPRT	;				19EH
		DB	01AH,0,0,0,0	;				1A1H
		RET			;				1A6H
;
;
SYSVER:		CALL	JMP$ILPRT	;				1A7H
		DB	'>> Micro Cornucopia V730.1 <<',0	;	1AAH
		RET
;
; NOTE:	 You can change	the SYSVER message to be longer	or shorter.  The
;	 end of	your last routine should terminate by 0380H (390 bytes
;	 available after start of SYSVER) if using the Hayes Smartmodem
;	 or by address 0B80H (2521 bytes) otherwise.
;
; You can put in a message at this location which can be called	up with
; CTL-L	if TRANLOGON has been set YES.	You can	put in several lines if
; desired.  End	with a 0.
;
LOGON:	  DB	'hello',CR,LF,0
;
;
; This routine allows a	300 ms.	break tone to be sent to reset some
; time-share computers.
;
SENDBRK:  MVI	A,5		;select	register 5
	  OUT	MODCTL1
	  MVI	A,0F8H		;send a	break tone
	  JMP	GOODBYE1
;
; This routine sends a 300 ms. break tone and sets DTR low for the same
; length of time to disconnect some modems such	as the Bell 212A, etc.
;
GOODBYE:  MVI	A,5		;select	register 5
	  OUT	MODCTL1		;send to the status port
	  MVI	A,DTROFF	;turn off dtr
;
GOODBYE1: OUT	MODCTL1
	  MVI	B,3		;delay 300 ms.
	  CALL	JMP$TIMER
	  MVI	A,5		;select	register 5
	  OUT	MODCTL1
	  LDA	REG5+1		;has been set to word length, etc.
	  OUT	MODCTL1
	  RET
;
; Kaypro 4-10 initialization -- resets the SIO, sets the interrupt
; mode, the receive and transmit mode.
; Sets the baud rate to port 00. Hex 05=300 baud, 07=1200
;
INITMOD:MVI	A,0		;select	register 0
	OUT	MODCTL1
	MVI	A,RSTINS	;reset SIO - 18h
	OUT	MODCTL1
;
	MVI	A,1		;select	register 1
	OUT	MODCTL1
	MVI	A,WRREG1	;no interrupts
	OUT	MODCTL1
;
	MVI	A,3		;select	register 3 - receive
	OUT	MODCTL1
REG3:	MVI	A,WRREG3	;8 Rx bits, Rx enable
	OUT	MODCTL1
;
	MVI	A,4		;select	register 4
	OUT	MODCTL1
	MVI	A,CLK16		;16X baud rate
PARIT:	ORI	NONE		;type of parity
STPLN:	ORI	ONE		;number of stop bits
	OUT	MODCTL1
;
	MVI	A,5		;select	register 5 - transmit
	OUT	MODCTL1
REG5:	MVI	A,WRREG5	;8 Tx bits, Tx enable, no RTS, no DTR
	OUT	MODCTL1
;
SETBD:	MVI	A,07H		;set baudrate to 1200 bps (A,05H=300)
	OUT	00
	RET
;
; The following routine changes the baud rate, word length, stop bits
; and parity on the Z80 SIO from the command level.  Note the routine
; MUST modify the parameters used by the INITMOD routine.
;
SETUPR:	PUSH	H
AGAIN:	LXI	D,BAUDBUF	;point to input	buffer for JMP$INLNCOMP
	CALL	JMP$ILPRT
	DB	1AH,'Baud Rate (300, 1200): ',0
	CALL	JMP$INBUF
	LXI	H,BAUDTB
BAUDLP:	MOV	A,M		;first character to check
	ORA	A		;is it null
	JZ	NOTOK		;no matches found
	STA	BAUDCP		;store in compare area
	INX	H		;point to next character
	MOV	A,M		;second character to check or null
	STA	BAUDCP+1	;store in comparea area
	INX	H		;point to MSPEED constant
	LXI	D,BAUDBUF+2	;compare baudbuf and baudcp
	CALL	JMP$INLNCOMP	;was valid baud specified
BAUDCP:	DB	0,0,0		;baudrate from table gets stored here
	JNC	OK		;match, go save it
	INX	H		;skip MSPEED
	INX	H		;and CTC constant
	JMP	BAUDLP		;and check next entry
NOTOK:	CALL	WRONG		;tell messed up
	JNC	AGAIN2		;null line entered bypass baud change
	JMP	AGAIN		;try again
;
OK:	MOV	A,M		;get MSPEED
	STA	MSPEED		;change	time-to-send to	match baudrate
	INX	H		;point to CTC constant
	MOV	A,M		;and get it
	STA	SETBD+1		;store in INITMOD routine
;
AGAIN2:	LXI	D,BAUDBUF	;point to input	buffer
	CALL	JMP$ILPRT
	DB	'Word Length (7, 8): ',0
	CALL	JMP$INBUF
	LXI	D,BAUDBUF+2
	CALL	JMP$INLNCOMP	;was eight bits	requested
	DB	'8',0
	MVI	A,REIGHT+RENABLE;receive eight bits  -  C1h
	MVI	B,TEIGHT+DTRON	;transmit eight	bits -  EAh
	JNC	OK2
	CALL	JMP$INLNCOMP	;was seven bits requested
	DB	'7',0
	MVI	A,RSEVEN+RENABLE;receive seven bits  - 41h
	MVI	B,TSEVEN+DTRON	;transmit seven	bits - AAh
	JNC	OK2
	CALL	WRONG
	JNC	AGAIN3		;bypass word length change
	JMP	AGAIN2
;
OK2:	STA	REG3+1		;store in MVI instruction
	MOV	A,B		;get transmit word length
	STA	REG5+1		;store in MVI instruction
;
AGAIN3:	LXI	D,BAUDBUF	;point to input	buffer for JMP$INLNCOMP
	CALL	JMP$ILPRT
	DB	'Stop Bits (1, 2): ',0
	CALL	JMP$INBUF
	LXI	D,BAUDBUF+2
	CALL	JMP$INLNCOMP	;was 1 stop bit	requested
	DB	'1',0
	MVI	A,ONE		;1 stop	bit - 04h
	JNC	OK3
	CALL	JMP$INLNCOMP	;was 2 stop bits requested
	DB	'2',0
	MVI	A,TWO		;2 stop	bits - 0Ch
	JNC	OK3
	CALL	WRONG
	JNC	AGAIN4		;bypass stop bit mod
	JMP	AGAIN3		;go ask again
;
OK3:	STA	STPLN+1		;save stop bits	in MVI
;
AGAIN4:	LXI	D,BAUDBUF	;point to input	buffer for JMP$INLNCOMP
	CALL	JMP$ILPRT
	DB	'Parity (None, Even, Odd): ',0
	CALL	JMP$INBUF
	LXI	D,BAUDBUF+2
	CALL	JMP$INLNCOMP	;was no	parity requested
	DB	'N',0		;just check first character
	MVI	A,NONE		;no parity - 00h
	JNC	OK4		;go if got match
	CALL	JMP$INLNCOMP	;was even parity requested
	DB	'E',0
	MVI	A,EVEN		;even parity - 03h
	JNC	OK4
	CALL	JMP$INLNCOMP	;was odd parity	requested
	DB	'O',0
	MVI	A,ODD		;odd parity - 01h
	JNC	OK4
	CALL	WRONG		;no matches
	JNC	GOSET		;bypass parity changes
	JMP	AGAIN4		;try again
;
OK4:	STA	PARIT+1		;save in MVI
;
; now go modify the init routine to initialize the Kaypro to the values
; requested.
;
GOSET:	POP	H		;restore HL register
	JMP	INITMOD		;reset Z80 SIO (and return)
;
WRONG:	CALL	JMP$INLNCOMP	;was null string entered
	DB	' ',0
	RNC			;all is ok
	CALL	JMP$ILPRT	;all matches failed - tell operator
	DB	' Wrong!',CR,LF,BELL,0
	STC			;Set carry flag
	RET
;
; Due to space constraints some baud rates have been commented out
;
BAUDTB:	EQU	$		;Valid baud rates
;                               ;BAUD  MSPEED   CTC
;BD110:	DB	'11',0,2	; 110    0      02
BD300:	DB	'3',0,1,5	; 300    1      05
;BD600:	DB	'6',0,3,6	; 600    3      06
BD1200:	DB	'12',5,7	;1200    5      07
;BD2400:DB	'24',6,10	;2400    6      0A
;BD4800:DB	'48',7,12	;4800    7      0C
;BD9600:DB	'96',8,14	;9600    8      0E
;BD192:	DB	'19',8,15	;19.2    9      0F
	DB	0
;
BAUDBUF:
	DB	10,0
	DS	10
;
;---------------------------------------------------------------------
;
;
; NOTE:  MUST TERMINATE PRIOR TO 0380H (with Smartmodem)
;				 0B80H (without Smartmodem)
;
;---------------------------------------------------------------------
	END
