REM X and Y coordinates of the user.
VAR USER_X, USER_Y = INTEGER

REM # of machines left, maximum # of pits & machines.
VAR MACH_LEFT, MACH_MAX, PIT_MAX = INTEGER

REM Message to be displayed upon completion of game.
VAR MSG = STRING

REM Possible values for any square on the board.
VAR USER, MACH, EMPTY, PIT, B_PIT = INTEGER

REM State and it's possible values.
VAR STATE, LOST, WON, RESIGN, PLAY, QUIT = INTEGER

REM Borders of the board.
VAR TOP, BOTTOM, L_SIDE, R_SIDE = INTEGER

REM The board, pits' and the machines' coordinates.
DIM INTEGER BOARD(30,20)  MACH_X(19)  MACH_Y(19)  PIT_Y(15)  PIT_X(15)

REM The possible video attributes.
VAR INVERSE, REDUCED, BLINKING, UNDERLINE, CURSOR = CHAR

PROCEDURE SET_ON (ATT=CHAR)
	PRINT CHR(27); 'B'; ATT;
END

PROCEDURE SET_OFF (ATT=CHAR)
	PRINT CHR(27); 'C'; ATT;
END

PROCEDURE POSITION (HORZ, VERT = CHAR)
	PRINT CHR(27); '=' ; VERT+31; HORZ+31;
END

PROCEDURE WAIT ( WCOUNT = INTEGER )
	VAR W = INTEGER
	FOR W = 1 TO WCOUNT
	NEXT W
END 

PROCEDURE EXPLODE ( HORZ, VERT = CHAR )
	POSITION HORZ, VERT
	PRINT "\.<}-";
	POSITION HORZ, VERT+1
	PRINT "&* **";
	POSITION HORZ, VERT+2
	PRINT "'>@#;";

	POSITION HORZ, VERT
	PRINT " ' . ";
	POSITION HORZ, VERT+1
	PRINT ". ' .";
	POSITION HORZ, VERT+2
	PRINT " ' - ";

	POSITION HORZ, VERT
	PRINT ". : -";
	POSITION HORZ, VERT+1
	PRINT ". * -";
	POSITION HORZ, VERT+2
	PRINT "!   `";

	POSITION HORZ, VERT
	PRINT " - . ";
	POSITION HORZ, VERT+1
	PRINT " : : ";
	POSITION HORZ, VERT+2
	PRINT ". ( '";

	POSITION HORZ, VERT
	PRINT "     ";
	POSITION HORZ, VERT+1
	PRINT "     ";
	POSITION HORZ, VERT+2
	PRINT "     ";
END

PROCEDURE DRAW_CHASER ( HORZ, VERT = CHAR )
	POSITION HORZ, VERT
	PRINT " ";
	SET_ON INVERSE
	PRINT "    ";
	SET_OFF INVERSE
	PRINT " "

	POSITION HORZ, VERT+1
	PRINT " ";
	SET_ON INVERSE
	PRINT "    ";
	SET_OFF INVERSE
	PRINT " "

	POSITION HORZ, VERT+2
	PRINT " ";
	SET_ON INVERSE
	PRINT "    ";
	SET_OFF INVERSE
	PRINT " "
END

PROCEDURE DRAW_RUNNER ( HORZ, VERT = CHAR )
	VAR C = CHAR

	POSITION HORZ, VERT
	PRINT "  ";CHR(0FCH);CHR(0A8H);"  ";

	POSITION HORZ, VERT+1
	PRINT " ";
	SET_ON INVERSE
	C = 0D4H
	PRINT C;" ";C;
	C = 0D5H
	PRINT C;
	SET_OFF INVERSE
	PRINT " ";

	POSITION HORZ, VERT+2
	PRINT " ";CHR(0D0H);CHR(8AH);CHR(0DAH);" ";
END

PROCEDURE ERASE_BLOCK ( HORZ, VERT = CHAR )
	POSITION HORZ, VERT
	PRINT "     "
	POSITION HORZ, VERT+1
	PRINT "     "
	POSITION HORZ, VERT+2
	PRINT "     "
END

PROCEDURE DRAW_PAINTER ( HORZ, VERT = CHAR )
	VAR C = CHAR

	POSITION HORZ, VERT
	PRINT "  ";CHR(0FCH);CHR(0A8H);
	SET_ON INVERSE
	PRINT CHR(0DAH);
	SET_OFF INVERSE
	PRINT " ";

	POSITION HORZ, VERT+1
	PRINT " ";
	SET_ON INVERSE
	C = 0D4H
	PRINT C;" ";C;
	SET_OFF INVERSE
	PRINT "  ";

	POSITION HORZ, VERT+2
	PRINT " ";CHR(0D0H);CHR(8AH);CHR(0DAH);" ";
END

PROCEDURE SHOW_OFF
	PRINT CHR(26)
	SET_OFF CURSOR
	VAR F = INTEGER
	VAR STR_1, STR_2A, STR_2B, STR_2C, STR_3 = STRING
	STR_1 = "K A Y P R O    P R E S E N T S"
	STR_2A = "                                         "
	STR_2B = "                                         "
	STR_2C = "                                         "
	STR_3 = "By Robert Schrader"

	MID(STR_2A,1,1) = CHR(0D0H)
	MID(STR_2A,2,1) = CHR(089H)
	MID(STR_2A,3,1) = CHR(083H)
	MID(STR_2A,4,1) = CHR(086H)
	MID(STR_2A,7,1) = CHR(0D5H)
	MID(STR_2A,10,1) = CHR(0D5H)
	MID(STR_2A,13,1) = CHR(0C0H)
	MID(STR_2A,14,1) = CHR(0A9H)
	MID(STR_2A,15,1) = CHR(083H)
	MID(STR_2A,16,1) = CHR(0E8H)
	MID(STR_2A,19,1) = CHR(0D0H)
	MID(STR_2A,20,1) = CHR(089H)
	MID(STR_2A,21,1) = CHR(083H)
	MID(STR_2A,22,1) = CHR(086H)
	MID(STR_2A,25,1) = CHR(0D5H)
	MID(STR_2A,26,1) = CHR(083H)
	MID(STR_2A,27,1) = CHR(083H)
	MID(STR_2A,28,1) = CHR(083H)

	MID(STR_2B,1,1) = CHR(0D5H)
	MID(STR_2B,7,1) = CHR(0D5H)
	MID(STR_2B,8,1) = CHR(08CH)
	MID(STR_2B,9,1) = CHR(08CH)
	MID(STR_2B,10,1) = CHR(0DDH)
	MID(STR_2B,13,1) = CHR(0D5H)
	MID(STR_2B,14,1) = CHR(08CH)
	MID(STR_2B,15,1) = CHR(08CH)
	MID(STR_2B,16,1) = CHR(0DDH)
	MID(STR_2B,20,1) = CHR(086H)
	MID(STR_2B,21,1) = CHR(08CH)
	MID(STR_2B,22,1) = CHR(0E0H)
	MID(STR_2B,25,1) = CHR(0D5H)
	MID(STR_2B,26,1) = CHR(08CH)
	MID(STR_2B,27,1) = CHR(08CH)
	MID(STR_2B,28,1) = CHR(088H)

	MID(STR_2C,1,1) = CHR(081H)
	MID(STR_2C,2,1) = CHR(098H)
	MID(STR_2C,3,1) = CHR(0B0H)
	MID(STR_2C,4,1) = CHR(0A4H)
	MID(STR_2C,7,1) = CHR(095H)
	MID(STR_2C,10,1) = CHR(095H)
	MID(STR_2C,13,1) = CHR(095H)
	MID(STR_2C,16,1) = CHR(095H)
	MID(STR_2C,19,1) = CHR(084H)
	MID(STR_2C,20,1) = CHR(0B0H)
	MID(STR_2C,21,1) = CHR(0B0H)
	MID(STR_2C,22,1) = CHR(089H)
	MID(STR_2C,25,1) = CHR(095H)
	MID(STR_2C,26,1) = CHR(0B0H)
	MID(STR_2C,27,1) = CHR(0B0H)
	MID(STR_2C,28,1) = CHR(0B0H)


	POSITION 1,7
	PRINT "----------------------------------------";
	PRINT "---------------------------------------";

	FOR F = 1 TO 20
		WAIT 75
		DRAW_RUNNER F,4
	NEXT F
	FOR F = 21 TO 50
		DRAW_PAINTER F,4
		POSITION F+4, 3
		PRINT MID( STR_1, F-20, 1 )
		DRAW_CHASER F-20,4
	NEXT F
	FOR F = 51 TO 74
		DRAW_RUNNER F,4
		DRAW_CHASER F-20,4
	NEXT F
	ERASE_BLOCK 74,4
	FOR F = 75 TO 94
		WAIT 75
		DRAW_CHASER F-20,4
	NEXT F
	ERASE_BLOCK 74,4
	
	WAIT 500

	POSITION 1,7
	PRINT "- - - - - - - - - - - - - - - - - - - - ";
	PRINT "- - - - - - - - - - - - - - - - - - - -";

	WAIT 500

	POSITION 1,7
	PRINT "                                        ";
	PRINT "                                       ";

	WAIT 1000

	POSITION 1,14
	PRINT "----------------------------------------";
	PRINT "---------------------------------------";
	
	FOR F = 1 TO 26
		WAIT 100
		DRAW_RUNNER 75-F,11
	NEXT F
	FOR F = 27 TO 48
		DRAW_PAINTER 75-F,11
		POSITION 81-F,10
		PRINT MID ( STR_2A, 57-F, 1 );
		POSITION 81-F,11
		PRINT MID ( STR_2B, 57-F, 1 );
		POSITION 81-F,12
		PRINT MID ( STR_2C, 57-F, 1 );
		DRAW_CHASER 101-F,11
	NEXT F
	EXPLODE 53,11
	WAIT 200
	EXPLODE 53,11
	FOR F = 49 TO 56
		DRAW_PAINTER 75-F,11
		POSITION 81-F,10
		PRINT MID ( STR_2A, 57-F, 1 );
		POSITION 81-F,11
		PRINT MID ( STR_2B, 57-F, 1 );
		POSITION 81-F,12
		PRINT MID ( STR_2C, 57-F, 1 );
	NEXT F
	FOR F = 57 TO 74
		WAIT 125
		DRAW_RUNNER 75-F,11
	NEXT F
	ERASE_BLOCK 1,11

	WAIT 500

	POSITION 1,14
	PRINT "- - - - - - - - - - - - - - - - - - - - ";
	PRINT "- - - - - - - - - - - - - - - - - - - -";

	WAIT 500

	POSITION 1,14
	PRINT "                                        ";
	PRINT "                                       ";

	WAIT 1000

	POSITION 1,21
	PRINT "----------------------------------------";
	PRINT "----------------------         --------";
	POSITION 63,22
	PRINT "|       |"
	POSITION 63,23
	PRINT "|       |"
	POSITION 63, 24
	PRINT " ------- ";

	FOR F = 1 TO 19
		DRAW_RUNNER F,18
		WAIT 75
	NEXT F
	FOR F = 20 TO 37
		DRAW_PAINTER F,18
		POSITION F+4, 17
		PRINT MID ( STR_3, F-19, 1)
		DRAW_CHASER F-19,18
	NEXT F
	FOR F = 38 TO 57
		DRAW_RUNNER F,18
		DRAW_CHASER F-19,18
	NEXT F
	POSITION 57,20
	PRINT "      "
	FOR F = 58 TO 60
		DRAW_RUNNER F,17
		DRAW_CHASER F-19,18
	NEXT F
	POSITION 60,19
	PRINT "      "
	FOR F = 61 TO 68
		DRAW_RUNNER F,16
		DRAW_CHASER F-19,18
	NEXT F
	POSITION 68,16
	PRINT "     "
	FOR F = 69 TO 71
		DRAW_RUNNER F,17
		DRAW_CHASER F-19,18
	NEXT F
	POSITION 71,17
	PRINT "     "
	FOR F = 72 TO 74
		DRAW_RUNNER F,18
		DRAW_CHASER F-19,18
	NEXT F
	FOR F = 56 TO 63
		WAIT 75
		DRAW_CHASER F,18
	NEXT F
	POSITION 63,18
	PRINT "      "
	DRAW_CHASER 64,19
	POSITION 64,19
	PRINT "      "
	DRAW_CHASER 64,20
	POSITION 64,20
	PRINT "      "
	DRAW_CHASER 64,21

	EXPLODE 64,21
	WAIT 200
	EXPLODE 64,21
	WAIT 200
	EXPLODE 64,21
	WAIT 2000

	POSITION 1,21
	PRINT "- - - - - - - - - - - - - - - - - - - - ";
	PRINT "- - - - - - - - - - - -  ";
	POSITION 63,22
	PRINT "'       '"
	POSITION 63,23
	PRINT ".       ."
	POSITION 63, 24
	PRINT " - - - - ";

	WAIT 200

	POSITION 1,21
	PRINT "                                        ";
	PRINT "                            ";
	POSITION 63,22
	PRINT "         "
	POSITION 63,23
	PRINT "         "
	POSITION 63, 24
	PRINT "         ";

	WAIT 10000

	SET_ON CURSOR
	PRINT CHR(26)
END

PROCEDURE RANDOMIZE
	REM This is really ugly: it should be re-written.
	REM However, currently, this is the only way that it will work.
	VAR I, J = INTEGER
	VAR CH, RTN = CHAR
	VAR R = REAL
	I = 1
	RTN = 0DH
	PRINT "Warte einen Moment und dr";chr(1bh);"Gz";chr(1bh);"Acke ";
	PRINT "dann irgendwelche Tasten."
$LINES
	PRINT
	ECHO OFF
	CH = 00H
	REPEAT
		BEGIN
		INPUT3 #4; CH
		PRINT CHR(00BH), CHR(00BH)
		I = I + 1
		PRINT RTN
		END
	UNTIL ( CH <> 00H )
	ECHO ON 
$LINES
	FOR J = 1 TO I
		R = RND(1)
	NEXT J
END

PROCEDURE INSTRUCT
	VAR CH = CHAR
	PRINT CHR(26)
	PRINT "Brauchst Du Anleitungen? <J>: ";
	INPUT2 CH
	IF CH="J" OR CH="j" THEN BEGIN
TEXT 0,%

	Dies ist ein Verfolgungsspiel, in dem Du in einem, mit einem Hoch-
spannungszaun umspannten Feld, gefangen bist. In diesem Feld sind einige
Fallen, in die Du hineinfallen kannst und es gibt JGvAger, die Dich zu
fangen versuchen. Deine Chance ist es, daG~A diese JGvAer auch nicht
so clever sind und in die Fallen geraten, wenn Sie Dich jagen.

	Der Zaun ist dargestellt durch: " +-------------------- ",

	die JGvAger durch ein:  "+",

	die Fallen durch ein:  "O",

	und Du bist das groG~Ae:  "X".


	Deine Bewegungen steuerst Du mit dem KEYPAD.       	7 8 9
Mit `4` nach links, mit `8` nach oben usw. Mit '5' bleibst	4 5 6
Du auf Deiner Position und mit `0` begehst Du Selbstmord.	1 2 3
								0

	Deine Aufgabe ist nur, zu GzAberleben! Versuch' es einmal.
DrGzAcke nun irgendeine Taste, um zu beginnen.
%
INPUT3 CH
END
END

PROCEDURE INIT_GAME
	REM Initialize the state values.
	LOST = 1
	WON = 2
	RESIGN = 3
	PLAY = 4
	QUIT = 5

	REM Define the size of the board.
	L_SIDE = 1
	R_SIDE = 25
	TOP = 1
	BOTTOM = 20

	REM Initialize values for board.
	EMPTY = 0
	USER = 1
	PIT = 2
	B_PIT = 3
	MACH = 4

	REM Intitialize attributes.
	INVERSE = '0'
	REDUCED = '1'
	BLINKING = '2'
	UNDERLINE = '3'
	CURSOR = '4' 

	MACH_MAX = 9
	PIT_MAX = 14
END

PROCEDURE INIT_BOARD
	REM Set up the board randomly.
	VAR P, I, M, X, Y = INTEGER
	VAR R, R1, R2 = REAL

	REM Clear out any garbage.
	FOR Y = TOP TO BOTTOM
		FOR X = L_SIDE TO R_SIDE
			BOARD [X,Y] = EMPTY
			PRINT ".";
		NEXT X
	NEXT Y

	REM Define the pits. They are almost useless if placed at the edge.
	FOR P = 1 TO PIT_MAX
		REPEAT
		    BEGIN
		    PRINT ".";
		    REM Throw out one random number, or else they cluster(?).
		    R1 = RND(1)
		    R1 = RND(1) * R_SIDE + 1
		    R2 = RND(1) * BOTTOM + 1
		    END
		UNTIL ( ((BOTTOM-R2)>2) AND ((R_SIDE-R1)>2) AND (R1>2) AND \
			(R2>2) AND (BOARD[R1,R2] = EMPTY) )
		BOARD [R1,R2] = PIT
		PIT_X[P] = R1
		PIT_Y[P] = R2
	NEXT P

	REM Place the machines randomly.
	FOR M = 1 TO MACH_MAX
		PRINT ".";
		R = RND(1) * R_SIDE + 1
		MACH_X[M] = R
		R = RND(1) * BOTTOM + 1
		MACH_Y[M] = R
		BOARD [MACH_X[M],MACH_Y[M]] = MACH
	NEXT M

	REM Place the user on an empty square. (i.e: don't drop him in a pit
	REM or on top of a machine). Also avoid squares too close to the edge.
	REPEAT
		BEGIN
		PRINT ".";
		R = RND(1) * R_SIDE + 1
 		USER_X = R 
		R = RND(1) * BOTTOM + 1
		USER_Y = R
		END
	UNTIL ( (BOARD[USER_X,USER_Y]=EMPTY) AND ((BOTTOM-USER_Y)>3) AND\
		 ((R_SIDE-USER_X)>3) AND (USER_X>3) AND (USER_Y>3) )

	BOARD [USER_X,USER_Y] = USER

	MSG = "YOU WON !        "

	MACH_LEFT = MACH_MAX
END

PROCEDURE PRINT_BOARD
	VAR I, TEMP, X, Y = INTEGER

	REM Clear the screen.
	PRINT CHR(26)
	PRINT

	REM Print the top border.
	PRINT "+";
	FOR I = 1 TO (R_SIDE - L_SIDE)*2 + 3
		PRINT "-";
	NEXT 
	PRINT "+"

	REM Print the board.
	FOR Y = TOP TO BOTTOM
		PRINT "| ";
		FOR X = L_SIDE TO R_SIDE
			TEMP = BOARD[X,Y]
			IF TEMP = EMPTY THEN PRINT "  ";
			IF TEMP = USER THEN PRINT "X ";
			IF TEMP = MACH THEN PRINT "+ ";
			IF TEMP = PIT THEN PRINT "O ";
			NEXT X
		PRINT "|"
	NEXT Y

	REM Print the bottom border.
	PRINT "+";
	FOR I = 1 TO (R_SIDE - L_SIDE)*2 + 3
		PRINT "-";
	NEXT 
	PRINT "+";

	POSITION 58,10
	PRINT MACH_LEFT;" J";chr(1bh);"Gv";chr(1bh);"Ager bleiben";

	POSITION 58,16
	PRINT "7 8 9"
	POSITION 58,17
	PRINT "4 5 6"
	POSITION 58,18
	PRINT "1 2 3"
	POSITION 58,20
	PRINT "0 , ist Selbstmord!"
END

PROCEDURE ERASE ( XX, YY = INTEGER )
	POSITION  2*XX +1, YY+3
	PRINT "  ";
END

PROCEDURE DISPLAY ( TYPE, XX, YY = INTEGER )
	POSITION  2*XX +1, YY+3
	CASE TYPE OF
		EMPTY: PRINT "  ";
		USER:  PRINT "X ";
		PIT:   PRINT "O ";
		B_PIT: BEGIN
			SET_ON BLINKING
			PRINT "O ";
			SET_OFF BLINKING
		       END
		MACH:  PRINT "+ ";
	END
END

PROCEDURE MOVE_USER
	REM Move the user according to his number pad entry.
	VAR MOVE = CHAR

	REM Get a legal move.
	ECHO OFF
	REPEAT INPUT3 MOVE
	UNTIL ((MOVE=>'0') AND (MOVE<='9'))
	ECHO ON

	REM Clear the square that we are moving from.
	ERASE USER_X,USER_Y
	BOARD [USER_X,USER_Y] = EMPTY

	REM Adjust the coordinates.
	CASE MOVE OF
	    '0': BEGIN
		   STATE = RESIGN
		   MSG = "Das war nett!"
		 END
	    '1': BEGIN
		   USER_X = USER_X - 1
		   USER_Y = USER_Y + 1
		 END
	    '2': USER_Y = USER_Y + 1
	    '3': BEGIN
		   USER_X = USER_X + 1
		   USER_Y = USER_Y + 1
		 END
	    '4': USER_X = USER_X - 1
	    '6': USER_X = USER_X + 1
	    '7': BEGIN
		   USER_X = USER_X - 1
		   USER_Y = USER_Y - 1
		 END
	    '8': USER_Y = USER_Y - 1
	    '9': BEGIN
		   USER_X = USER_X + 1
		   USER_Y = USER_Y - 1
		 END
	END

	REM Check to see if we have hit the wires or a pit or a machine.
	IF( (USER_X>R_SIDE) OR (USER_X<L_SIDE) \
		OR (USER_Y<TOP) OR (USER_Y>BOTTOM) ) THEN BEGIN
		MSG = "Du h"+chr(1bh)+"Gv"+chr(1bh)+"Angstim Zaun"
		STATE = LOST
		END
	IF BOARD [USER_X,USER_Y] = PIT THEN BEGIN
		MSG = "Du liegst im Loch"
		STATE = LOST
		END
	IF BOARD [USER_X,USER_Y] = MACH THEN BEGIN
		MSG = "Ich hab Dich schon"
		STATE = LOST
		END

	REM Assign the new position.
	DISPLAY USER, USER_X, USER_Y
	BOARD [USER_X,USER_Y] = USER
END

PROCEDURE MOVE_MACH
	REM Move the machines in pursuit.
	VAR M, TEMP = INTEGER

	IF (STATE = PLAY) THEN BEGIN
		FOR M = 1 TO MACH_MAX
			REM An X coord of zero means machine is destroyed. 
			IF MACH_X[M] <> 0 THEN BEGIN
				REM Clear the old square.
				ERASE MACH_X[M], MACH_Y[M]
				BOARD [MACH_X[M],MACH_Y[M]] = EMPTY

				REM Move 1 square in direction of user.
				MACH_X[M] = MACH_X[M] - SGN(MACH_X[M]-USER_X)
				MACH_Y[M] = MACH_Y[M] - SGN(MACH_Y[M]-USER_Y)

				REM Use temp to aviod repititious,
				REM time-consuming table lookups.
				TEMP = BOARD [ MACH_X[M], MACH_Y[M] ]

				REM Determine results of movement. 
				IF TEMP = PIT THEN BEGIN
					DISPLAY B_PIT, MACH_X[M], MACH_Y[M]
					MACH_X[M] = 0
					END
 				IF TEMP = MACH THEN MACH_X[M] = 0
				IF TEMP = USER THEN BEGIN
					MSG = "Schade um Dich!"
					STATE = LOST
					END

				REM If still functioning, draw movement.
				IF MACH_X[M] <> 0 THEN\
					DISPLAY MACH, MACH_X[M], MACH_Y[M]
					BOARD [MACH_X[M],MACH_Y[M]] = MACH
				END
		NEXT M   REM Go process another machine.
 
		MACH_LEFT = 0
		REM Count the machines.
		FOR M = 1 TO MACH_MAX
			MACH_LEFT = MACH_LEFT + SGN(MACH_X[M])
		NEXT M
		IF MACH_LEFT = 0 THEN STATE = WON
		POSITION 58,10
		IF MACH_LEFT = 1 THEN PRINT " 1 Feind bleibt   ";
			ELSE PRINT MACH_LEFT; " Feinde bleiben";
	END
END

PROCEDURE RESET_PITS
	VAR P = INTEGER
	FOR P = 1 TO PIT_MAX
		DISPLAY PIT, PIT_X[P], PIT_Y[P]
		BOARD [PIT_X[P], PIT_Y[P]] = PIT
	NEXT P
END

PROCEDURE GUANTLET
	REM Challenge user to another game.
	VAR ANSWER = CHAR
	POSITION 58, 14
	PRINT "Noch ein Spielchen <J>: ";
	INPUT3 ANSWER
	PRINT CHR(26)
	IF ANSWER="J" OR ANSWER="j" THEN STATE = PLAY
		  ELSE STATE = QUIT
END


REM **************** MAINLINE STARTS HERE *******************

control.c.trap off
INIT_GAME
SHOW_OFF
RANDOMIZE
INSTRUCT

STATE = PLAY
SET_OFF CURSOR

REPEAT
	BEGIN
	INIT_BOARD
	PRINT_BOARD
	REPEAT
		BEGIN
		MOVE_USER
		RESET_PITS
		MOVE_MACH
		END
	UNTIL ( (STATE=LOST) OR (STATE=WON) OR (STATE=RESIGN) )
	POSITION 58, 12
	PRINT MSG
	GUANTLET
	END
UNTIL (STATE = QUIT)

SET_ON CURSOR

END
