	title	'DDATA 1.501 (20.05.84)'
	;************************************************
	;*	disk-format-definition module		*
	;*	--- for banked CP/M PLUS ---		*
	;************************************************
	;*	Copyright (c) 1984 by			*
	;*	Michels und  Kleberhoff Computer GmbH	*
	;*	Hauptstrasse 78, D-5600 Wuppertal 12	*
	;************************************************
	;*	globals:				*
	;*	fdata,ddatid				*
	;************************************************
	;*	written:	28.04.84	l.k.	*
	;*	modfied:	20.05.84	l.k.	*
	;************************************************
	public	ddatid,fdata
	dseg
ddatid:
	db	'ID',0dh,0ah,'DDATA    1.501',0
	page
;
;	definition of disk format table (stranger-disks)
;
;   B	valid-flag		0 = not defined, 1...253 = valid, 255 = end
;				254 = intermediate format during analyse disk
; XXDPH-values
;
;   B	disk-size		0 = 8", 1 = 5.25"
;   B	FM/MFM			0 = FM, 40h = MFM, 0c0h = MFM (Systemtracks: FM)
;   B	sector-size		0 = 128 byte, 1 = 256 byte, 2 = 512 byte, ...
;   B	side-bias		disk-id	(normally: 0)
;   B	track-bias		(normally: 0)
;   B	sides / disk		1 or 2 (0 = login-error)
;   B	tracks / disk		35, 40, 77, 80 ... (for 1 side)
;   B	sectors / track		(for 1 side)
;   B	r/w-gap-length		may be 10
;   B	format-gap-length	may be 30
;   B	format-skew		1 = continuos, 2, 3 ...
;   B	normal/invers		0 = normal, 1 = invers
;   B	-- not used --		reserved for future use
;
; DPB-values
;
;   W	SPT			128 byte records / track
;   B	BSH			data allocation block shift factor
;   B	BLM			block mask
;   B	EXM			extent mask
;   W	DSM			storage capacity in blocks
;   W	DRM			total number of directory entries - 1
;   B	AL0			reserved directory blocks
;   B	AL1			reserved directory blocks
;   W	CKS			directory check vector size
;   W	OFF			number of reserved tracks
;   B	PSH			physical record shift factor
;   B	PHM			physical record mask
;
; XLT-values
;
;   B	52 bytes for sector translation (range: 1 .. 52)
;
;		 ( B = byte, W = word )
;
	dseg
entrylength	equ	39h+26	; for all disk-formats
	dw	fdend-fdata	; length of fdata
fdata:
	page
	;************************************************
	;*	1st format	ZDOS 80 track		*
	;************************************************
start	set	$
	db	1		; valid ( 1 = ZDOS 80 track )
	;***** XXDPH *****
	db	1		; 5.25"
	db	40h		; MFM
	db	2		; 512 bytes / sector
	db	0		; side bias
	db	0		; track bias
	db	82h		; should be two sided
	db	80		; 96 tpi
	db	10		; 10 sectors
	db	10		; r/w-gap
	db	1eh		; format-gap
	db	1		; format-skew
	db	1		; invers
	db	0
	;***** DPB *****
	dw	40		; 128 byte sectors / track
	db	4		; 2 k blocks
	db	15		; 2 k blocks
	db	0		; extent mask
	dw	790/2-1		; capacity
	dw	128-1		; directory entries
	db	11000000b	; AL0
	db	00000000b	; AL1
	dw	((128-1)/4)+1	; CKS
	dw	2		; OFF
	db	2		; 512 byte physical sector
	db	3		; 512 byte physical sector
	;***** XLT *****
	db	1,3,5,7,9,2,4,6,8,10
	db	0,0,0,0,0,0,0,0
	db	0,0,0,0,0,0,0,0
	ds	26
	if	$-start-entrylength
	db	lenerror	; error <entrylength>
	endif
	page
	dseg
	;************************************************
	;*	2nd format	ZDOS 40 track		*
	;************************************************
start	set	$
	db	2		; valid ( 2 = ZDOS 40 track )
	;***** XXDPH *****
	db	1		; 5.25"
	db	40h		; MFM
	db	2		; 512 bytes / sector
	db	0		; side bias
	db	0		; track bias
	db	82h		; should be two sided
	db	40		; 48 tpi
	db	10		; 10 sectors
	db	10		; r/w-gap
	db	1eh		; format-gap
	db	1		; format-skew
	db	1		; invers
	db	0
	;***** DPB *****
	dw	40		; 128 byte sectors / track
	db	4		; 2 k blocks
	db	15		; 2 k blocks
	db	1		; extent mask
	dw	390/2-1		; capacity
	dw	64-1		; directory entries
	db	10000000b	; AL0
	db	00000000b	; AL1
	dw	((64-1)/4)+1	; CKS
	dw	2		; OFF
	db	2		; 512 byte physical sector
	db	3		; 512 byte physical sector
	;***** XLT *****
	db	1,3,5,7,9,2,4,6,8,10
	db	0,0,0,0,0,0,0,0
	db	0,0,0,0,0,0,0,0
	ds	26
	if	$-start-entrylength
	db	lenerror	; error <entrylength>
	endif
	page
	dseg
	;************************************************
	;*	3rd format	ZDOS 8" DD		*
	;************************************************
start	set	$
	db	3		; valid ( 3 = ZDOS 8" DD )
	;***** XXDPH *****
	db	0		; 8"
	db	40h		; MFM
	db	2		; 512 bytes / sector
	db	0		; side bias
	db	0		; track bias
	db	82h		; should be two sided
	db	77		; 48 tpi
	db	15		; 15 sectors
	db	1bh		; r/w-gap
	db	54h		; format-gap
	db	1		; format-skew
	db	1		; invers
	db	0
	;***** DPB *****
	dw	60		; 128 byte sectors / track
	db	4		; 2 k blocks
	db	15		; 2 k blocks
	db	0		; extent mask
	dw	570-1		; capacity
	dw	0c0h-1		; directory entries
	db	11100000b	; AL0
	db	00000000b	; AL1
	dw	((0c0h-1)/4)+1	; CKS
	dw	2		; OFF
	db	2		; 512 byte physical sector
	db	3		; 512 byte physical sector
	;***** XLT *****
	db	1,5,9,13,2,6,10,14
	db	3,7,11,15,4,8,12,0
	db	0,0,0,0,0,0,0,0,0,0
	ds	26
	if	$-start-entrylength
	db	lenerror	; error <entrylength>
	endif
	page
	dseg
	;************************************************
	;*	4th format	CP/M A1 SD SS		*
	;************************************************
start	set	$
	db	4		; valid ( 4 = CP/M A1 )
	;***** XXDPH *****
	db	0		; 8"
	db	0h		; FM
	db	0		; 128 bytes / sector
	db	0		; side bias
	db	0		; track bias
	db	1		; single sided
	db	77		; 48 tpi
	db	26		; 26 sectors
	db	7		; r/w-gap
	db	1bh		; format-gap
	db	1		; format-skew
	db	0		; normal
	db	0
	;***** DPB *****
	dw	26		; 128 byte sectors / track
	db	3		; 1 k blocks
	db	7		; 1 k blocks
	db	0		; extent mask
	dw	0f2h		; capacity
	dw	3fh		; directory entries
	db	0c0h		; AL0
	db	0		; AL1
	dw	10h		; CKS
	dw	2		; OFF
	db	0		; 128 byte physical sector
	db	0		; 128 byte physical sector
	;***** XLT *****
	db	1,7,13,19,25,5,11,17
	db	23,3,9,15,21,2,8,14
	db	20,26,6,12,18,24,4,10,16,22
	ds	26
	if	$-start-entrylength
	db	lenerror	; error <entrylength>
	endif
	page
	dseg
	;************************************************
	;*	leave space for 6 disk-formats		*
	;************************************************
	db	0
	ds	entrylength-1
	db	0
	ds	entrylength-1
	db	0
	ds	entrylength-1
	db	0
	ds	entrylength-1
	db	0
	ds	entrylength-1
	;************************************************
	;*	end of table				*
	;************************************************
	db	255
fdend:
	end
