/******************************************************************************
*  F O R M A T  *  U T I L S 0 0 4  *  T h o m a s   H o l t e * 8 4 0 3 1 5  *
*******************************************************************************
* 									      *
*    F O R M A T T I N G   U T I L I T Y   F O R   C P / M - V E R . 2 . 2    *
*    =====================================================================    *
* 									      *
*  	O N   T H E   S P E E D M A S T E R   M I C R O C O M P U T E R       *
*       ===============================================================       *
* 									      *
* 									      *
*   Thomas Holte			                         Version 1.0  *
* 									      *
******************************************************************************/

#define HSTBUF 0xF8D8		/* default disk buffer     */
#define ROMIO  0xFF02		/* ROM device driver entry */

#define HOME   8
#define SELDSK 9


main (argc, argv)
  int argc;
  char *argv[];
{
  char buf[7000], **buffer, *DCT, *dct, density, *drive, errmsg (), errno,
       firstsec, firsttrk, *german, lasttrk, *maxdrv, no, seccount, secno,
       *sector, *side, skew, sl, surface, *track;
  int beginsec, endsec, gap, i, seclen, wholesec;
  register int j;

  maxdrv = 0xFE92;	/* contains maximum drive no */
  DCT	 = 0xFFCD;	/* drive control table	     */
  buffer = 0xFFDD;	/* contains buffer address   */
  drive  = 0xFFDF;	/* drive  address in SYSTAB  */
  track  = 0xFFE0;	/* track  address in SYSTAB  */
  side   = 0xFFE2;	/* side   address in SYSTAB  */
  sector = 0xFFE2;	/* sector address in SYSTAB  */

  /* turn on German character set */
  *(german = 0xFF2B) = 0xFF;

  if (!--argc || !bios(SELDSK, no = toupper(**++argv) - 'A', 0))
  {
    printf ("UNG]LTIGER LAUFWERKSNAME (BENUTZEN SIE A - %c)\n", *maxdrv + 'A');
    exit   ();
  }

  /* prompt */
  printf ("M\\CHTEN SIE WIRKLICH DIE DISKETTE IN LAUFWERK %c FORMATIEREN ? ",
	  no + 'A');
  if (toupper(getchar()) != 'J') exit ();

  /* get disk parameters */
  dct      = DCT + no * 5;
  surface  = *dct >> 6 & 1;
  density  = *dct >> 5 & 1;
  firsttrk = density ? 0 : *dct >> 4 & 1;
  firstsec = *dct++ >> 3 & 1;     
  seccount = *dct++ / (surface + 1);
  lasttrk  = *dct++ + firsttrk;
  i = sl   = *dct >> 6;
  seclen   = 128;
  while (i--) seclen *= 2;
  skew     = (skew = *dct >> 1 & 0x1F) ? skew : 32;

  /* restore drive */
  *dct &= 0xFE;

  /* build track buffer */
  if (density)
  {
    gap = 25;
    switch (sl)
    {
      case 3: gap += 98;
      case 2: gap += 15;
    }

    wholesec = gap + 60 + seclen;
    beginsec = gap + 16;
    endsec   = seccount * wholesec;
    for (i = 0; i < endsec; i += wholesec)
    {
      j = 0;	
      while (j < gap               ) buf[i + j++] = 0x4E;
      while (j < gap + 12          ) buf[i + j++] = 0x00;
      while (j < gap + 15          ) buf[i + j++] = 0xF5;
         		             buf[i + j  ] = 0xFE;
			                     j   += 3   ;
			             buf[i + j++] = 0xFF;
			             buf[i + j++] = sl  ;	
    			             buf[i + j++] = 0xF7;
      while (j < gap + 43          ) buf[i + j++] = 0x4E;
      while (j < gap + 55          ) buf[i + j++] = 0x00;
      while (j < gap + 58          ) buf[i + j++] = 0xF5;
      			             buf[i + j++] = 0xFB;
      while (j < gap + 59 + seclen)  buf[i + j++] = 0xE5;
			 	     buf[i + j++] = 0xF7;
    }  
    for (i = endsec; i < 7000; i++) buf[i] = 0x4E;
  }
  else
  {
    gap = 27;
    if (sl == 1) gap -= 11;

    wholesec = gap + 31 + seclen;	
    beginsec = gap +  7;
    endsec   = seccount * wholesec;
    for (i = 0; i < endsec; i += wholesec)
    {
      j = 0;
      while (j < gap    	  ) buf[i + j++] = 0xFF;	
      while (j < gap +  6	  ) buf[i + j++] = 0x00;
         		     	    buf[i + j  ] = 0xFE;
			              	    j   += 3   ;	
                              	    buf[i + j++] = 0xFF;
		       	      	    buf[i + j++] = sl  ;
    			      	    buf[i + j++] = 0xF7;
      while (j < gap + 23	  ) buf[i + j++] = 0xFF;	
      while (j < gap + 29	  ) buf[i + j++] = 0x00;
      			     	    buf[i + j++] = 0xFB;
      while (j < gap + 30 + seclen) buf[i + j++] = 0xE5;
			      	    buf[i + j++] = 0xF7;
    }  
    for (i = endsec; i < 7000; i++) buf[i] = 0xFF;
  }
  
  /* number sectors */
  for (i = secno = 0; i < seccount; i++)
  {
    j = beginsec + 2 + wholesec * secno;
    if (buf[j] != 0xFF)
    {
      secno++;
      i--;
    }
    else
    {
      buf[j] = i + firstsec; 
      if ((secno += skew) >= seccount) secno -= seccount;
    }
  }

  /* formatting */
  printf ("\nFORMATIEREN VON SPUR   ");

  *buffer = buf;		/* set buffer pointer */
  *drive  = no;			/* set drive */
  
  for (*track = firsttrk; *track < lasttrk; (*track)++)
  {
    for (i = beginsec; i < endsec; i += wholesec) buf[i] = *track;
    printf ("\b\b%02d", *track);
    
    for (*side = 0; *side <= surface; (*side)++)
    {
      for (i = beginsec + 1; i < endsec; i += wholesec) buf[i] = *side;

      /* format track */	
      if (errno = ccalla(ROMIO, 0, 0, 8, 0))
      {
	switch (errmsg(errno))
	{
	  case 'A': exit (); 		
	  case 'W': track--;
        }
	printf ("\nFORMATIEREN VON SPUR   ");
	break;
      }		
    }
  }

  /* verifying */
  printf ("\rVERIFIZIEREN VON SPUR   ");

  *buffer = HSTBUF;		/* set buffer pointer */

  for (*track = firsttrk; *track < lasttrk; (*track)++)
  {
    printf ("\b\b%02d", *track);

    for (*sector = 0; *sector < seccount; (*sector)++)
    {
      if (errno = ccalla(ROMIO, 0, 0, 6, 0))
      {
	switch (errmsg(errno))
	{
	  case 'A': exit ();
	  case 'W': for (i = beginsec; i < endsec; i += wholesec)
		      buf[i] = *track;
		    *buffer = buf;
		    for (*side = 0; *side <= surface; (*side)++)
		    {
		      for (i = beginsec + 1; i < endsec; i += wholesec)
			buf[i] = *side;
		      ccalla (ROMIO, 0, 0, 8, 0);
		    }
		    *buffer = HSTBUF;
		    *sector = -1;
	}
	printf ("\nVERIFIZIEREN VON SPUR %02d", *track);
      }  	
    }
  }

  /* reset formatted disk */
  bdos (37, 1 << *drive);

  printf ("\nPROGRAMM BEENDET\n");
} 
	 		

char errmsg (errno)
  char errno;
{
  char c;

  switch (errno)
  {
    case 1: puts ("\nUNG]LTIGES LAUFWERK\n");
	    exit ();
    case 2: puts ("\nUNG]LTIGE SPUR\n");
	    exit ();
    case 3: puts ("\nUNG]LTIGER SEKTOR\n");
	    exit ();
    case 4: puts ("\nLAUFWERK NICHT BEREIT\n");
	    break;
    case 5: puts ("\nDISKETTE SCHREIBGESCH]TZT\n");
	    break;
    case 6: puts ("\nLAUFWERKSFEHLER\n");
	    exit ();
    case 7: puts ("\nDATEN-RECORD NICHT GEFUNDEN\n");
	    break;
    case 8: puts ("\nCRC-FEHLER\n");
	    break;
    case 9: puts ("\nDATEN VERLOREN\n");
	    exit   ();
  }
  printf ("(A)BBRECHEN, (W)IEDERHOLEN ODER (F)ORTFAHREN\n");
  do
  {
    printf ("\b");
    c = toupper(getchar());
  }
  while (c != 'A' && c != 'F' && c != 'W');
  printf ("\n");
  return c;
}
