/******************************************************************************
*  C O P Y  *  U T I L S 0 0 3  *  T h o m a s   H o l t e  *   8 4 0 3 1 5   *
*******************************************************************************
* 									      *
* 	   B A C K U P   U T I L I T Y   F O R   C P / M - B A S E D	      *
*          =========================================================          *
* 									      *
*		   M I C R O C O M P U T E R   S Y S T E M S 		      *
*                  =========================================                  *
* 									      *
* 									      *
*   Thomas Holte			                         Version 2.0  *
* 									      *
******************************************************************************/

#include <stdio.h>

#define ETX 3

#define HOME     8
#define SELDSK   9
#define SETTRK  10
#define SETSEC  11
#define SETDMA  12
#define READ    13
#define WRITE   14
#define SECTRAN 16

#define VERIFY  17

#define WRDIR    1	/* write to directory   */
#define WRUAL    2	/* write to unallocated */

char lasttrk, track;
int lastsec;

main (argc, argv)
  int argc;
  char *argv[];
{
  extern char tab[4][3];
  char class, cmd[80], *dmaadr, errno, firsttrk, *german, sector, state, *tbuf,
       tracks[80], val, work;
  register int i;
  int dirsize, first_of_all, firstsec, j, n, no, no1, no2, start, trksiz;

  struct {
	   char mode[7], source, dest, automatic, verify;
	 } list;
  struct {
	   char *XLT;
	   int filler[3];
	   char *DIRBUF;
	   struct {
		    int SPT;
		    char BSH, BLM, EXM;
		    int DSM, DRM;
		    char AL0, AL1;
		    int CKS, OFF;
		  } *DPB;
	   char *CSV, *ALV;
	 } *SDPBASE, *DDPBASE;
  struct {
	   char del, name[8], type[3], extent, reserved[2], eof;
	   union {
		   char sno[16];
		   int lno[8];
		 } block;
	 } *entry;


  /* initialize control structure */
  list.mode[0] = list.automatic = list.verify = 0;
  list.source  = list.dest      	      = 0xFF;

  /* initialize control variables */
  state = 0;
  start = 1;

  /* turn on German character set */
  *(german = 0xFF2B) = 0xFF;

  printf ("\nKOPIER VER 2.0\n");

  for (;;)
  {
    /* convert arguments to upper case */
    for (i = start; i < argc; i++) for (j = 0; j < strlen(argv[i]); j++)
      argv[i][j] = toupper(argv[i][j]);

    for (i = start; i < argc; i++)
    {		
        class = 0xFF;
      if (streq("ALLES", argv[i]) || streq("SYSTEM", argv[i]) ||
          streq("DATEN", argv[i]) || streq("ENDE"  , argv[i]))   class = 0;
      if (strlen(argv[i]) == 1 && *argv[i] >= 'A' && *argv[i] <= 'P')
        class = 1;
      if (streq("[A]"  , argv[i]) || streq("[V]" , argv[i]) ||
          streq("[AV]" , argv[i]) || streq("[VA]", argv[i]))   class = 2;

      if (class == 0xFF) break;

      /* get table entry */
      val = tab[state][class]; 

      /* working entry */
      work = val & 7;

      switch (work)
      {
        case 1 : strcpy (list.mode, argv[i]);
	         break;
        case 2 : list.source    = *argv[i] - 'A';
	         break;
        case 3 : list.dest      = *argv[i] - 'A';
	         break;
        case 4 : list.automatic = index(argv[i], 'A');
		 list.verify    = index(argv[i], 'V');
      }

      if ((state = val >> 4) == 4) break;
    }

    restart:

    argc  = 1;	
    start = state = 0;
  
    if (list.mode[0] == 'E') exit ();

    if (list.mode[0] == '\0')
    {
      printf ("\nMODUS    FUNKTION\n\n");
      printf ("ALLES    KOPIEREN DER GANZEN DISKETTE\n");
      printf ("SYSTEM   KOPIEREN DER SYSTEMSPUREN\n");
      printf ("DATEN    KOPIEREN DER DATENSPUREN\n");
      printf ("ENDE     PROGRAMMENDE\n");
      printf ("\nMODUS: ");
      if (strlen(argv[0] = instr()) <= 1) argv[0][0] = '\0';
      continue;
    }
            
    if (list.source == 0xFF)
    {
      printf ("\nQUELLAUFWERK: ");
      argv[0] = instr();
      continue;
    }
    else if (!(SDPBASE = bios(SELDSK, list.source, 0)))
         {
           printf ("\nUNG]LTIGES QUELLAUFWERK\n");
           exit   ();
         }

    if (list.dest == 0xFF)
    {
      printf ("\nZIELLAUFWERK: ");
      argv[0] = instr();
      state   = 2;
      continue;
    }
    else
      if (!(DDPBASE = bios(SELDSK, list.dest, 0)))
      {
        printf ("\nUNG]LTIGES ZIELLAUFWERK\n");
        exit   ();
      }
      else if (notequal(SDPBASE->DPB, DDPBASE->DPB, sizeof *SDPBASE->DPB))
	   {
	     printf ("\nUNTERSCHIEDLICHE LAUFWERKSSPEZIFIKATIONEN\n");
	     exit   ();
	   }
	   else bios (HOME, 0, 0);

    break;   
  }

  /* big copy loop */
  do
  {
    if (!list.automatic)
    {
      printf ("\n(^C F]R PROGRAMMABBRUCH)\n");
      printf ("DR]CKEN SIE <NEW LINE>, UM %s VON %c NACH %c ZU KOPIEREN ",
	      list.mode, list.source + 'A', list.dest + 'A');
      instr  ();
    } 
    printf ("\n");

    /* initialize track numbers */
    firsttrk = 0;
    lasttrk  = SDPBASE->DPB->OFF - 1;

    /* read directory of source disk */
    if (list.mode[0] != 'S')
    {
      /* get directory buffer */
      if (!(dmaadr = entry
		   = alloc(((dirsize = SDPBASE->DPB->DRM / 4) + 1) * 128)))
      {
        printf ("\nNICHT GEN]GEND SPEICHERPLATZ VERF]GBAR\n");
        exit   ();
      }

      lasttrk = (firsttrk = SDPBASE->DPB->OFF) + dirsize / SDPBASE->DPB->SPT;

      bios (SELDSK, list.source, 0);
      bios (HOME  , 0          , 0);   
      for (track = firsttrk; track <= lasttrk; track++)
      {
        bios(SETTRK, track, 0);
        for (sector = 0; sector <= dirsize && sector < SDPBASE->DPB->SPT;
	     sector++)
        {
          bios (SETSEC, bios(SECTRAN, sector, 0), 0);
          bios (SETDMA, dmaadr		        , 0);
          if (errno = bios(READ, 0, 0))
          {
            errmsg (errno);
	    exit   ();
          }
          dmaadr += 128;
        }
        dirsize -= SDPBASE->DPB->SPT;
      }

      if (list.mode[0] != 'D') firsttrk = 0; else firsttrk = lasttrk;
      for (i = 0; i <= lasttrk; i++) tracks[i] = TRUE;
      for (i = lasttrk; i < 80; i++) tracks[i] = FALSE;

      /* detect unallocated tracks */
      for (i = 0; i <= SDPBASE->DPB->DRM; i++)
        if (entry[i].del != 0xE5)
          if (SDPBASE->DPB->DSM > 255)
            for (j = 0; j < 8; j++) 
	    {
	      lastsec = (firstsec = entry[i].block.lno[j]
		      * (SDPBASE->DPB->BLM + 1)) + SDPBASE->DPB->BLM;
	    
	      no1 = firstsec / SDPBASE->DPB->SPT + SDPBASE->DPB->OFF;
	      no2 = lastsec  / SDPBASE->DPB->SPT + SDPBASE->DPB->OFF;
	      for (track = no1; track <= no2; track++)
	      {
	        tracks[track] = TRUE;
	        lasttrk       = max(lasttrk, track);
	      }
            }
          else 
            for (j = 0; j < 16; j++) 
	    {
	      lastsec = (firstsec = entry[i].block.sno[j]
		      * (SDPBASE->DPB->BLM + 1)) + SDPBASE->DPB->BLM;

	      no1 = firstsec / SDPBASE->DPB->SPT + SDPBASE->DPB->OFF;
	      no2 = lastsec  / SDPBASE->DPB->SPT + SDPBASE->DPB->OFF;
	      for (track = no1; track <= no2; track++)
	      {
	        tracks[track] = TRUE;
	        lasttrk       = max(lasttrk, track);
	      }
            }

      free (entry);		/* free directory buffer */
    }

    /* get buffer for n tracks */
    trksiz = SDPBASE->DPB->SPT * 128;
    n	   = 0;			    /* safety */  	
    while (tbuf = alloc(trksiz * ++n + 0x200)) free (tbuf);
    if (!--n || !(tbuf = alloc(trksiz * n)))
    {
      printf ("\nNICHT GEN]GEND SPEICHERPLATZ VERF]GBAR\n");
      exit   ();
    }

    /* copying */
    lastsec = SDPBASE->DPB->SPT - 1;
    track   = first_of_all = firsttrk;

    while (track <= lasttrk)
    {
      if (list.source == list.dest && track != first_of_all)
      {
        printf (
	  "\n\nDR]CKEN SIE <NEW LINE>, WENN QUELLDISKETTE IN LAUFWERK %c ",
	  list.source + 'A');
        instr  ();
        printf ("\n");
      }	

      printf ("\rLESEN     VON SPUR   ");

      for (i = 0; i < n; i++)
      {
	if (tracks[track]) 			
	{
	  printf ("\b\b%02d", track);
	  if (trackio(list.source, &tbuf[i * trksiz], READ)) i--;
	}
	else i--;

	if (++track > lasttrk)
	{
	  n = ++i;
	  break;
	}
      }

      if (list.source == list.dest)
      {
	printf (
 	 "\n\nDR]CKEN SIE <NEW LINE>, WENN ZIELDISKETTE IN LAUFWERK %c ",
	  list.dest + 'A');
        instr  ();
        printf ("\n");
      }	
      printf ("\rSCHREIBEN VON SPUR   ");	
      track = firsttrk;

      for (i = 0; i < n; i++, track++)
	if (tracks[track])
	{
	  printf ("\b\b%02d", track);
	  if (trackio(list.dest, &tbuf[i * trksiz], WRITE)) i--;
	  else if (list.verify) if (trackio(list.dest, tbuf, VERIFY)) i--;
        }
	else i--;

      firsttrk = track;
    }

    free (tbuf);		/* free track buffer */

    if (list.automatic) exit ();
    printf ("\n\nM\\CHTEN SIE DAS KOPIEREN WIEDERHOLEN ? ");
  }
  while (toupper(getchar()) == 'J');

  /* restart copy program */
  list.mode[0] = '\0';
  list.source  = list.dest = 0xFF;
  printf ("\n");
  goto restart;
}


static char buf[7];

static char *instr ()
{
  register char i;

  for (i = 0; i < 6; i++)
  {
    if ((buf[i] = getchar()) == ETX) exit ();
    if (buf[i] == '\n')	
    {
      buf[i] = '\0';
      break; 
    }
    if (i == 5)
    {
      buf[6] = '\0';
      printf ("\n");
    }
  }

  return buf;
}


BOOLEAN notequal (s1, s2, n)
  char *s1, *s2;
  int n;
{
  register int i;

  for (i = 0; i < n; i++) if (*s1++ != *s2++) return TRUE;
					      return FALSE;
}	


errmsg (errno)
  char errno;
{
  switch (errno)
  {
    case 1: puts ("UNG]LTIGES LAUFWERK\n");
	    exit ();
    case 2: puts ("UNG]LTIGE SPUR\n");
	    exit ();
    case 3: puts ("UNG]LTIGER SEKTOR\n");
	    exit ();
    case 4: puts ("LAUFWERK NICHT BEREIT\n");
	    break;
    case 5: puts ("DISKETTE SCHREIBGESCH]TZT\n");
	    break;
    case 6: puts ("LAUFWERKSFEHLER\n");
	    exit ();
    case 7: puts ("DATEN-RECORD NICHT GEFUNDEN\n");
	    break;
    case 8: puts ("CRC-FEHLER\n");
	    break;
    case 9: puts ("DATEN VERLOREN\n");
	    exit ();
  }
}


BOOLEAN trackio (drive, buffer, mode)
  char drive, *buffer, mode;
{
  char c, dummy[REC_SIZE], mode1, sector;

  bios (SELDSK, drive, 0);
  bios (SETTRK, track, 0);
  if (mode == VERIFY)
  {
    buffer = dummy;
    mode1  = READ;
  }
  else mode1 = mode;

  for (sector = 0; sector <= lastsec; sector++)
  {
    bios (SETSEC, bios(SECTRAN, sector, 0), 0);
    bios (SETDMA, buffer		  , 0);    
    if (errno = bios(mode1, track == lasttrk && sector == lastsec ?
		     WRDIR : WRUAL, 0))
    {
      printf ("\n\n");
      errmsg (errno);
      printf ("(A)BBRECHEN, (W)IEDERHOLEN ODER (F)ORTFAHREN\n");
      do
      {
        printf ("\b");
        c = toupper(getchar());
      } 
      while (c != 'A' && c != 'F' && c != 'W');
      printf ("\n");
      switch (c)
      {
        case 'A': exit ();
        case 'F': if (mode == READ) printf ("\nLESEN     VON SPUR   ");
		  	       else printf ("\nSCHREIBEN VON SPUR   ");
		  break;	
        case 'W': if (mode == READ) printf ("\nLESEN     VON SPUR   ");
		  	       else printf ("\nSCHREIBEN VON SPUR   ");
		  track--;
		  return TRUE;
      }
    }
    if (mode != VERIFY) buffer += 128;
  }
  return FALSE;
}
