/******************************************************************************
*  C O N F I G  *  U T I L S 0 0 2  *  T h o m a s   H o l t e  * 8 3 1 1 2 0 *
*******************************************************************************
*									      *
*  	     S Y S T E M   C O N F I G U R A T O R   F O R   T H E	      *
*            =====================================================            *
*									      *
*  	       S P E E D M A S T E R   M I C R O C O M P U T E R	      *
*	       =================================================	      *
*									      *
*									      *
*  Version 1.1						        Thomas Holte  *
*									      *
******************************************************************************/

#include <stdio.h>

#define EOT   0x04
#define BS    0x08
#define VT    0x0B   
#define ESC   0x1B

#define HOME     8
#define SELDSK   9
#define SETTRK  10
#define SETSEC  11
#define SETDMA  12
#define READ    13
#define WRITE   14

#define WRDIR    1	/* write to directory   */
#define WRUAL    2	/* write to unallocated */


xmain ()
{
  register char i;
  extern char zbuf[];
  extern wtab[][5];
  char *cursor, dirsize, *dmaadr, *german, j, key, *lock, *maxdrv, no, option,
       system[3072], temp;
  int index, int2;

  struct {
	   char BLKSIZ, CPMSPT, SECMSK, SECSHF;
         } *CPMHST;  
  struct dpb {
               int SPT;
	       char BSH, BLM, EXM;
	       int DSM, DRM;
	       char AL0, AL1;
	       int CKS, OFF;
	     } *DPB; 	 		 
  struct {
	   char *XLT;
	   int filler[3];
	   char *DIRBUF;
	   struct dpb *DPB0;
	   char *CSV, *ALV;
	 } *DPBASE, *DPH0;	
  struct {
	   char td1, spt, tc, td2, curtrk;
         } *DCT;

  /* read system */
  DPH0   = bios (SELDSK, 0, 0);
  	   bios (HOME  , 0, 0);
  dmaadr = system;
  for (i = 48; i < 72; i++)
  {
    bios (SETTRK, i / DPH0->DPB0->SPT, 0);
    bios (SETSEC, i % DPH0->DPB0->SPT, 0);
    bios (SETDMA, dmaadr	     , 0);
    if (errno = bios(READ, 0, 0)) errmsg (errno);
    dmaadr += 128;
  }

  /* turn on German character set */
  *(german = 0xFF2B) = 0xFF;

  /* initialize structure pointers */
  CPMHST = &system[0xA7E];	
  DPBASE = &system[0xA8B];
  DPB    = &system[0xABB];
  DCT    = &system[0xBCD];

  maxdrv = &system[0xA8A];	/* contains maximum drive no. */
  lock   = &system[0xB2A];	/* switch bit for SHIFT LOCK  */
  german = &system[0xB2B];	/* switch bit for char set    */
  cursor = &system[0xBB8];	/* cursor character   	      */

  /* get parameters loop */
  for (i = 0;; i++)
  {
    index  = wtab[i][3];
    option = wtab[i][4];

    key = window(wtab[i][0], wtab[i][1], wtab[i][2], &zbuf[index]);

    /* check BACKTAB function */
    if (key == EOT || key == BS || key == VT)
    {
      if (i >= 51) while (i > 51) if (wtab[--i][0] == 3); else break;
      else if (i > 22) while (i > 22) if (wtab[--i][0] == 3);
	               		      else 	
                                      {
	        	           	if (i == 26 && !(DCT->td1 & 0x20))
					  i -= 2;
	  	         	   	break;
        	                      }
      i--;
      continue;
    } 

    /* check ESC function */
    if (key == ESC)
    {
      puts ("\33=/ \n\nPROGRAMM ABGEBROCHEN\n");
      exit ();
    }	

    /* check options */
    switch (option)
    {
      /* decimal ASCII --> binary --> ASCII */	
      case  1: int2 = convert(0x10, int2, 0, wtab[i][2] - wtab[i][1] + 1,
			      &zbuf[index]);
	       continue;
	
      /* hexadecimal ASCII --> binary --> ASCII */
      case  2: int2 = hexconv(0, int2, wtab[i][2] - wtab[i][1] + 1,
			      &zbuf[index]);
	       continue;
		
      case  3: switch (toupper(zbuf[index]))
               {
		 case 'L': zbuf[343] = *maxdrv + 'A';
			   if (!*maxdrv) i--;
			   break;
		 case 'S': /* get cursor character */
			   hexconv (1, *cursor, 2, &zbuf[1084]);

			   /* get lock bit */
			   zbuf[1212] = *lock ? 'G' : 'K';

			   /* get switch bit for char set */
			   zbuf[1340] = *german ? 'J' : 'N';

			   /* get drive count */
			   zbuf[1468] = *maxdrv + '1';
			   i = 48;
		 default : i--;
               }
               continue;
 
      case  4: if ((no = toupper(zbuf[index]) - 'A') >= 1 && no <= *maxdrv)
	       {
		 CPMHST += no;
                 DPBASE += no;
		 DPB    += no;
		 DCT    += no;

		 /* get disk size */
                 if (DCT->td1 & 0x80) zbuf[381] = '8'; else zbuf[381] = '5';

		 /* get no. of surfaces */
                 if (DCT->td1 & 0x40) zbuf[413] = 'D'; else zbuf[413] = 'E';

		 /* get density */
		 if (DCT->td1 & 0x20) zbuf[445] = 'D'; else zbuf[445] = 'E';

		 /* get density of first track */	    zbuf[477] = 'E';
   		 if (zbuf[445] == 'D') if (DCT->td1 & 0x10) zbuf[477] = 'D';

                 /* get no. of first sector */
    		 zbuf[509] = (DCT->td1 >> 3 & 1) + '0';

                 /* get track stepping rate */
		 zbuf[541] = (DCT->td1 & 3) + '0';
			
                 /* no. of steps per track to track */
                 zbuf[573] = (DCT->td1 >> 2 & 1) + '1';	

                 /* get no. of sectors per track */
		 convert (0x11, DCT->spt, 0, 2, &zbuf[636]);

		 /* get track count */
		 convert (0x11, DCT->tc, 0, 2, &zbuf[700]);

     		 /* get sector length */
 		 zbuf[733] = (DCT->td2 >> 6) + '0';
  
		 /* get interleaving factor */
		 int2 = (int2 = DCT->td2 >> 1 & 0x1F) ? int2 : 32;
		 convert (0x11, int2, 0, 2, &zbuf[764]);

		 /* get block size */
	         convert (0x11, CPMHST->BLKSIZ / 8, 0, 2, &zbuf[828]);

		 /* get dir size */
		 zbuf[893] = DPB->DRM / 32 + 1 + '0';

		 /* get no. of system tracks */
		 zbuf[925] = DPB->OFF + '0';
	       }
	       else i--;
	       continue;

      case  5: /* check disk size */
	       switch (zbuf[index])
	       {
		 case '5': DCT->td1 &= 0x7F;
			   break;
		 case '8': DCT->td1 |= 0x80;
			   break;
		 default : i--;
	       }
	       continue;

      case  6: /* check no. of surfaces */
	       switch (toupper(zbuf[index]))
	       {
		 case 'D': DCT->td1 |= 0x40;
			   break;
		 case 'E': DCT->td1 &= 0xBF;
			   break;
		 default : i--;
	       }
	       continue;

      case  7: /* check density */
	       switch (toupper(zbuf[index]))
	       {
		 case 'D': DCT->td1 |= 0x20;
			   i++;
			   break;
		 case 'E': DCT->td1 &= 0xCF;
			   zbuf[477] = 'E';
			   break;
		 default : i--;
	       }
	       continue;

      case  8: /* check density of first track */
	       switch (toupper(zbuf[index]))
	       {
		 case 'D': DCT->td1 |= 0x10;
			   break;
		 case 'E': DCT->td1 &= 0xEF;
			   break;
		 default : i--;
	       }
	       continue;

      case  9: /* check no. of first sector */
	       if (!int2 || int2 == 1) DCT->td1 = DCT->td1 & 0xF7 | int2 << 3;
	       else i -= 2;
	       continue; 						

      case 10: /* check track stepping rate */
	       if (int2 >= 0 && int2 <= 3) DCT->td1 = DCT->td1 & 0xFC | int2;
	       else i -= 2;
	       continue;

      case 11: /* check no. of steps per track to track */
	       if (int2 == 1 || int2 == 2)
		 DCT->td1 = DCT->td1 & 0xFB | (int2 - 1) << 2;
	       else i -= 2;
	       continue;

      case 12: /* check no. of sectors per track */
	       if (int2 > 0) DCT->spt = int2; else i -= 2;
	       continue;

      case 13: /* check track count */
	       if (int2 > 0) DCT->tc = int2; else i -= 2;
	       continue;

      case 14: /* check physical sector length */
	       if (int2 >= 0 && int2 <= 3)
	       {
		 DCT->td2 = (CPMHST->SECSHF = int2) << 6;
		 temp     = 1;
		 switch (int2)
		 {
		   case 3: temp += temp;
		   case 2: temp += temp;
		   case 1: temp += temp;
		 }
		 CPMHST->CPMSPT = DPB->SPT = DCT->spt * temp--;
		 CPMHST->SECMSK = temp;
	       }
	       else i -= 2;
	       continue;

      case 15: /* check interleaving factor */
	       if (int2 >= 1 && int2 <= 32)
		 DCT->td2 = DCT->td2 & 0xC0 | (int2 == 32 ? 0 : int2) << 1;
	       else i -= 2;
	       continue;

      case 16: /* check block size */
	       switch (int2)
	       {
		 case  1: CPMHST->BLKSIZ =   8;
			  DPB->BSH 	 =   3;		 	
			  DPB->BLM 	 =   7;
			  break;
		 case  2: CPMHST->BLKSIZ =  16;
			  DPB->BSH	 =   4;
			  DPB->BLM 	 =  15;
			  break;
		 case  4: CPMHST->BLKSIZ =  32;
			  DPB->BSH 	 =   5;
			  DPB->BLM 	 =  31;
			  break;
		 case  8: CPMHST->BLKSIZ =  64;
			  DPB->BSH 	 =   6;
			  DPB->BLM 	 =  63;
			  break;
		 case 16: CPMHST->BLKSIZ = 128;
			  DPB->BSH 	 =   7;
			  DPB->BLM 	 = 127;
			  break;
		 default: i -= 2;
	       }
	       continue;

      case 17: /* check directory size */
	       if (int2 > 0)
	       {
		 DPB->CKS = ((DPB->DRM = int2 * 32 - 1) + 1) / 4;

		 /* calc. block count for directory */
		 dirsize = CPMHST->BLKSIZ / 8;
		 dirsize = int2 / dirsize + (int2 % dirsize ? 1 : 0);
		 for (DPB->AL0 = 0, temp = 128; temp && dirsize;
		      temp /= 2, dirsize--) DPB->AL0 += temp;
		 for (DPB->AL1 = 0, temp = 128; temp && dirsize;
		      temp /= 2, dirsize--) DPB->AL1 += temp;
	       }
	       else i -= 2;
	       continue;

      case 18: /* check no. of system tracks */
	       if (int2 >= 0)
		 if ((DPB->DSM = (DCT->tc - (DPB->OFF = int2))
		      * CPMHST->CPMSPT / CPMHST->BLKSIZ - 1) <= 255)
		   switch (CPMHST->BLKSIZ)
		   {
		     case   8: DPB->EXM =  0;
			       break;
		     case  16: DPB->EXM =  1;
			       break;
		     case  32: DPB->EXM =  3;
			       break;
		     case  64: DPB->EXM =  7;
			       break;
		     case 128: DPB->EXM = 15;
		   }
		 else
		   switch (CPMHST->BLKSIZ)
		   {
		     case   8: i -= 6;		/* error */
			       break;
		     case  16: DPB->EXM = 0;
			       break;
		     case  32: DPB->EXM = 1;
			       break;
		     case  64: DPB->EXM = 3;
			       break;
		     case 128: DPB->EXM = 7;
		   }
	       else i -= 2;
	       continue;

      case 19: switch (toupper(zbuf[index]))
	       {
		 case 'J': if ((DCT->td1 & 0xFC) == 0x88 && DCT->spt == 26 &&
			       DCT->tc  == 77) DPBASE->XLT = 0xFEE8;
			   else DPBASE->XLT = 0;
			   break;
		 case 'N': i = 22;
		 default : i--;
			   continue;
	       }
	       break;

      case 20: /* check cursor character */
	       *cursor = int2;
	       continue;

      case 21: /* check upper/lower case */
	       switch (toupper(zbuf[index]))
	       {
		 case 'G': *lock = 0xFF;
			   break;
		 case 'K': *lock = 0;
			   break;
		 default : i--;
	       }
	       continue;

      case 22: /* check character set */
	       switch (toupper(zbuf[index]))
	       {
		 case 'N': *german = 0;
			   break;
		 case 'J': *german = 0xFF;
			   break;
		 default : i--;
	       }
	       continue;

      case 23: /* check drive count */
	       if (int2 >= 1 && int2 <= 3) *maxdrv = int2 - 1; else i -= 2;
	       continue;

      case 24: switch (toupper(zbuf[index]))
	       {
		 case 'J': break;
		 case 'N': i = 51;
		 default : i--;
			   continue;
	       }
	       break;	

      case 25: /* jump over next window */
	       i++;
	
      default: /* no option specified */
	       continue;
    }	
    break;
  } 

  puts ("\33=/ \n\n");

  /* write system */
  dmaadr = system;
  for (i = 48; i < 72; i++)
  {
    bios (SETTRK, i / DPH0->DPB0->SPT, 0);
    bios (SETSEC, i % DPH0->DPB0->SPT, 0);
    bios (SETDMA, dmaadr	     , 0);
    if (errno = bios(WRITE, i == 71 ? WRDIR : WRUAL, 0)) errmsg (errno);
    dmaadr += 128;
  }

  puts ("PROGRAMM BEENDET\n");
  puts ("DR]CKEN SIE <RESET>, UM DAS NEUKONFIGURIERTE SYSTEM ZU LADEN\n");
}


errmsg (errno)
  char errno;
{
  switch (errno)
  {
    case 1: puts ("UNG]LTIGES LAUFWERK\n");
	    break;
    case 2: puts ("UNG]LTIGE SPUR\n");
	    break;
    case 3: puts ("UNG]LTIGER SEKTOR\n");
	    break;
    case 4: puts ("LAUFWERK NICHT BEREIT\n");
	    break;
    case 5: puts ("DISKETTE SCHREIBGESCH]TZT\n");
	    break;
    case 6: puts ("LAUFWERKSFEHLER\n");
	    break;
    case 7: puts ("DATEN-RECORD NICHT GEFUNDEN\n");
	    break;
    case 8: puts ("CRC-FEHLER\n");
	    break;
    case 9: puts ("DATEN VERLOREN\n");
  }
  exit ();
}
