/******************************************************************************
*  C H A R G E N  *  C P M S Y S 4  *  T h o m a s   H o l t e  * 8 4 0 4 1 0 *
*******************************************************************************
*  									      *
*   F O N T   F I L E   E D I T O R   F O R   T H E   S P E E D M A S T E R   *
*   =======================================================================   *
*                                                                             *
*           	    	   M I C R O C O M P U T E R			      *
*                          =========================              	      *
*  									      *
*                            						      *
*  Version 1.0                                                  Thomas Holte  *
*  									      *
******************************************************************************/
    
#include <stdio.h>

/* ASCII control codes */
#define STX 0x02		/* start of text	 */
#define ETX 0x03		/* end of text      	 */
#define EOT 0x04		/* end of transmission   */
#define BEL 0x07		/* bell			 */
#define BS  0x08		/* backspace        	 */
#define HT  0x09		/* horizontal tabulation */
#define LF  0x0A		/* line feed		 */
#define VT  0x0B		/* vertical tabulation   */
#define FF  0x0C		/* form feed		 */
#define CR  0x0D		/* carriage return	 */
#define DC2 0x12		/* device control 2	 */
#define CAN 0x18		/* cancel		 */
#define ESC 0x1B		/* escape		 */


xmain ()
{
  register char i;
  extern wtab[][4];
  extern char zbuf[];
  char chr[16], cset[16][256], fname[15], *hborder, heigth, j, key, length,
       option, *vborderl, *vborderr, width;	 
  int index, int2;
  BOOLEAN edit;
  FILE *fontfile;

  /* initialize font border */
  hborder  = " 0 1 2 3 4 5 6 7";
  vborderl = " 0 1 2 3 4 5 6 7 8 9101112131415";
  vborderr = "0 1 2 3 4 5 6 7 8 9 101112131415";

  /* clear font buffer */
  setmem (cset, sizeof cset, 0);

  /* turn on graphics mode */
  outp (0xF5, 0);

  /* get parameters loop */
  for (i = 0;; i++)
  {
    index  = wtab[i][3] >> 4;
    option = wtab[i][3] &  7;  

    key = window(wtab[i][0], wtab[i][1], wtab[i][2], &zbuf[index]);

    /* check BACKTAB function */
    if (key == BS || key == VT)
    {
      while (i > 8 && wtab[--i][0] != 0x7F14);
      i--;
      continue;
    }

    /* check ESC function */
    if (key == ESC)	
    {
      puts ("\33=7 \n\nPROGRAM ABORTED\n");
      exit ();
    }

    /* check options */
    switch (option)
    {
      /* ASCII --> binary --> ASCII */
      case 1: int2 = convert(0, int2, 0, wtab[i][2] - wtab[i][1] + 1,
			     &zbuf[index]);
	      break;

      case 2: /* isolate filename */
	      length = 14;
	      while ((zbuf[index] == ' ' || zbuf[index] == 0x7F) && length)
	      {
		index++;
		length--;
	      }
	      for (j = 0; j < length; j++)
		if ((fname[j] = zbuf[index + j]) == ' ' || fname[j] == 0x7F)
		  break;
	      fname[j] = '\0';		/* terminate string */

       	      /* open font file */	
	      if ((fontfile = open(fname, 0)) != ERROR)
	      {
		read  (fontfile, cset, sizeof cset);
		close (fontfile);
	      	wtab[9][0] = 0;
	      }	
	      else if ((fontfile = creat(fname, 0)) != ERROR)
		   {
		     close (fontfile);
		     wtab[9][0] = 3;
		   }
		   else i--;	

	      break; 		

      case 3: /* read width of dot matrix */
 	      if (int2 > 0 && int2 <= 8) width = int2 - 1; else i -= 2;
	      break;	
	      	
      case 4: /* read heigth of dot matrix */
	      if (int2 > 0 && int2 <= 16)
	      {
		heigth = int2 - 1;

		/* output font border */
		window (3, 431		     , 432 		  + width * 2,
			hborder );
		window (3, 529		     , 530 + heigth * 100	     ,
			vborderl);		
		window (3, 533 + width  *   2, 534 + heigth * 100 + width * 2,
			vborderr);
		window (3, 631 + heigth * 100, 632 + heigth * 100 + width * 2,
		 	hborder );
	      }
	      else i -= 2;
	      break;

      case 5: /* get character code */
	      int2 = hexconv(-1, int2, 2, &zbuf[index]);
	      edit = FALSE;

	      /* check completion key */
	      switch (key)
	      {
		case 0x83: if (int2) int2--;
			   break;

		case 0x84: if (int2 < 255) int2++;
  			   break;

		case 0x82: edit = TRUE;
			   break;

		case 0x86: puts ("\33=7 \n\nFUNCTION COMPLETE");
			   if ((fontfile = open(fname, 1)) == ERROR ||
			      write(fontfile, cset, sizeof cset) < sizeof cset)
			     puts (" WITH ERRORS");
			   puts  ("\n");
			   close (fontfile);
			   exit  ();
	      }
	      hexconv (1, int2, 2, &zbuf[index]);
	      break;

      case 6: /* output and edit character font */
	      for (j = 0; j < 16; j++) chr[j] = cset[j][int2];
	      if (edit)
	      {
		if (cfont(4, width, heigth, chr) == 0x80)
		  for (j = 0; j < 16; j++) cset[j][int2] = chr[j];
	      }
	      else cfont(3, width, heigth, chr);
	      i -= 2;
    }
  }
} 		


char cfont (ctrl, width, heigth, buffer)
  char ctrl, width, heigth, buffer[];

{
  char code, es, ez, *init, ls, lz, *setcur;

  code   = 0;
  init   = "\33\14\33I%\33J \33K?\33L \36";
  setcur = "\33=  ";

  /* Berechnen der letzten Zeile des Fensters */
  init[7] = (ez = heigth) + '%';

  /* Berechnen der letzten Spalte des Fensters */
  init[13] = (es = width) * 2 + '@';

  puts (init);

  for (lz = 0; lz <= ez; lz++)
  {
    for (ls = 0; ls <= es; ls++)
      if (buffer[lz] & 1 << ls) puts ("\277\277"); else puts ("  ");
    if (lz < ez) putchar ('\n');
  }

  if (ctrl == 4)
  {
    lz = ls = 0;
    for (;;)
    {
      setcur[2] = lz     + ' ';
      setcur[3] = ls * 2 + ' ';
      puts (setcur);
      if (buffer[lz] & 1 << ls) puts ("\246\231"); else puts ("\231\246");
      puts ("\b\b");

      /* Holen eines Zeichens von der Tastatur */
      while (!(code = bdos(6, 0xFF)));
      if (buffer[lz] & 1 << ls) puts ("\277\277"); else puts ("  ");
      puts ("\b\b");

      switch (code)
      {
        case ETX : lz = ez;		/* SHIFT + cursor down  */
		   continue;

        case BS  : if (ls) ls--;       	/* cursor left          */
		   continue;

        case HT  : ls = es;		/* SHIFT + cursor right */
		   continue;

        case LF  : if (lz < ez) lz++; 	/* cursor down 		*/
		   continue;

        case VT  : if (lz) lz--;  	/* cursor up 		*/	
		   continue;

        case FF  : if (ls < es) ls++;	/* cursor right		*/
		   continue;

        case CR  : if (ez < lz) lz++;	/* NEW LINE 		*/
		   ls = 0;
		   continue;

        case DC2 : lz = 0;		/* SHIFT + cursor up    */
		   continue;

        case CAN : ls = 0;		/* SHIFT + cursor left */
		   continue;

        case ' ' : buffer[lz] &= ~(1 << ls);
		   puts ("  ");
		   if (ls < es) ls++;
		   continue;

        case '.' : buffer[lz] |= 1 << ls;
	           puts ("\277\277");
	           if (ls < es) ls++;
		   continue;

	case ESC :
        case 0x80:
        case 0x81: break;
		
        default : continue;
      }
    break;
    }
  } 
  puts ("\36\33I \33J7\33K \33Lo\33\15");
  return code;
}
