/******************************************************************************
*  A U T O L O A D  * U T I L S 0 0 1 * T h o m a s   H o l t e * 8 4 0 3 1 2 *	
*******************************************************************************
*									      *
*  	   A U T O S T A R T   O F   U S E R   P R O G R A M S   A T	      *
*          =========================================================          *
*									      *
*	            	  P O W E R - O N / R E S E T			      *
*		          ===========================       		      *
*									      *
*									      *
*  Version 1.0						        Thomas Holte  *
*									      *
******************************************************************************/

#define ROMIO 0xFF02	

#define ESC   0x1B

xmain ()
{
  extern char zbuf[];
  extern tab[][4];
  register char i;
  char *drive, errno, *german, *HSTBUF, key, option, *sector, *track;
  int index;

  /* initialize buffer pointer */
  HSTBUF = 0xF8D8;

  /* read boot sector */
  *(drive = 0xFFDF) = *(track = 0xFFE0) = *(sector = 0xFFE2) = 0;
  if (errno = ccalla(ROMIO, 0, 0, 6, 0)) errmsg (errno);

  /* move command line into form buffer */
  i = 0;
  while (i < HSTBUF[0x5C]) zbuf[869 + i  ] = HSTBUF[0x5D + i++];
  while (i < 25		 ) zbuf[869 + i++] = ' ';

  /* turn on German character set */
  *(german = 0xFF33) = 0xFF;

  /* get parameters loop */
  for (i = 0;; i++)
  {
    index  = tab[i][3] >> 4;
    option = tab[i][3] &  1;

    key = window(tab[i][0], tab[i][1], tab[i][2], &zbuf[index]);

    /* check ESC function */
    if (key == ESC)
    {
      puts ("\33=/ \n\nPROGRAMM ABGEBROCHEN\n");
      exit ();
    }

    /* check options */
    if (option)
    {
      switch (toupper(zbuf[index]))
      {
	case 'J': break;
        case 'N': i--;
	default : i--;
	continue;
      }
      break;
    }
  }

  puts ("\33=/ \n\n");

  /* move command line into disk buffer */
  i = 24;
  while (i >= 0 && zbuf[869 + i] == ' ') i--;
  HSTBUF[0x5C] = ++i;
  for   (i = 0; i < HSTBUF[0x5C]; i++) HSTBUF[0x5D + i  ] = zbuf[869 + i];
  while (       i < 25		     ) HSTBUF[0x5D + i++] = 0;  

  /* write boot sector */
  if (errno = ccalla(ROMIO, 0, 0, 7, 0)) errmsg (errno);

  puts ("PROGRAMM BEENDET\n");

}


errmsg (errno)
  char errno;
{
  switch (errno)
  {
    case 1: puts ("UNG]LTIGES LAUFWERK\n");
	    break;
    case 2: puts ("UNG]LTIGE SPUR\n");
	    break;
    case 3: puts ("UNG]LTIGER SEKTOR\n");
	    break;
    case 4: puts ("LAUFWERK NICHT BEREIT\n");
	    break;
    case 5: puts ("DISKETTE SCHREIBGESCH]TZT\n");
	    break;
    case 6: puts ("LAUFWERKSFEHLER\n");
	    break;
    case 7: puts ("DATEN-RECORD NICHT GEFUNDEN\n");
	    break;
    case 8: puts ("CRC-FEHLER\n");
	    break;
    case 9: puts ("DATEN VERLOREN\n");
  }
  exit ();
}
