;******************************************
;***	BEDIENPROGRAMM FUER PGS48	***
;***	ERTEC GMBH / ERLANGEN		***
;***	V1.0 / 5.9.83 / KRUSE		***
;******************************************
;***    ADAPTIERT FUER GENIE III S      ***
;***	VON THOMAS HOLTE (C) 1985	***
;****************************************** 
;
ENTRY:	ORG	100H

ENT:	LXI 	SP,1500H 
    	MVI	A,INI	;PGS INITIALISIEREN
	CALL	OUTA
	MVI	A,0
	STA	ERRFLA
	STA	UNGFL
  	LXI	H,0
	SHLD	ZEIT3
INL:	LXI	H,TYPE	;TEXT FUER EPROM ANWAHL
	CALL	STR	;AUSGEBEN
	CALL	GET	;TASTATUR ABFRAGEN
	CPI	'A'	;BEREICHS FESTGELEGUNG
	JC	INL	;DER ANWAEHLBAREN TASTEN
	CPI	'I'
	JNC	INL
	PUSH	PSW
	MVI	A,36H
	CALL	OUTA
	POP     PSW
	CPI	'A'
	JNZ	TB
	MVI	A,T1658
	MVI	B,0	;ES FUER JEDEN EPROM TYPEN
	LXI	H,800H	;SOWOHL LAENGE ALS AUCH
	JMP	SETPR	;EIN TYPEN ZEICHEN ABGESPEICHERT
TB:	CPI	'B'	;UND AUSSERDEM DER EPROMER AUF
	JNZ	TC	;DEN ENTSPRECHENDEN TYPEN	
	MVI	B,1	;INITIALISIERT
	MVI	A,T2732
	LXI	H,1000H
	JMP	SETPR
TC:	CPI	'C'
	JNZ	TD
	MVI	B,2
	MVI	A,T2764
	LXI	H,2000H
	JMP	SETPR
TD:	CPI	'D'
	JNZ	TE
	MVI	B,3
	MVI	A,T2732A
	LXI	H,1000H
	JMP	SETPR
TE:	CPI	'E'
	JNZ	TF
	MVI	B,4
	MVI	A,T2564
	LXI	H,2000H
	JMP	SETPR
TF:	CPI	'F'
	JNZ	TG
	MVI	B,5
	MVI	A,T2532
	LXI	H,1000H
	JMP	SETPR
TG:	CPI	'G'
	JNZ	TH
	MVI	B,6
	MVI	A,T27128
	LXI	H,4000H
	JMP	SETPR
TH:	MVI	A,T2816A
	LXI	H,800H
	MVI	B,7
SETPR:	SHLD	LAENGE	;UEBERGABE DER ERMITTELTEN PARMETER
	MOV	C,A
	MOV	A,B
	STA	ETYPE
	MOV	A,C
	CALL	OUTA
	CALL	INLOOP
	CMP	C
	JZ	HLOOP
	LXI	H,NOTRED;WENN PGS UNKLAR
	CALL	STR	;DAS GESENDETE TYPEN ZEICHEN ZURUECK
	CALL GET
	JMP	ENTRY

HLOOP:	LXI	SP,1500H;STACK POINTER SETZEN
	LXI	H,MENUE	;UND MENUE TEXT AUSGEBEN
	CALL	STR
	CALL	MODUS	;ANZEIGEN DES ANGEWAEHLTEN
	CALL	GET	;EPROM TYPENS UND WARTEN BIS EINE TASTE
	LXI	H,CLS	;GEDRUCKT WIRD DANACH BILDSCHIRM LOESCHEN
	CALL	STR
	CPI	'A'	;PROGRAMMIEREN
	JZ	PROG
	CPI	'B'
	JZ	LESEN	;EPROM IN MEMORY LESEN
	CPI	'C'
	JZ	VERGL
	CPI	'D'
	JZ	DUMP	;EPROM INHALT AUSDUMPEN
	CPI	'E'
	JZ	TESTER	;EPROM AUF VERLAESSLICHKEIT PRUEFEN
	CPI	'F'
	JZ	EMPTY	;TESTEN OB EPROM LEER IST
	CPI	'G'
	JZ	ENT	;EPROM TYPEN WECHSELN
	CPI	'H'	;MEMORY DUMPER
	JZ	MDUMP
	CPI	'I'
	JZ	MCHANGE
	CPI	'K'
	JZ	FINDER
	CPI	'L'
	JZ	LOADER1
	CPI	'M'
	JZ	SAVER1
	CPI	'N'
	JZ	HEXRECH
	CPI	'O'
	JZ	0	;ZURUECK ZUM SYSTEM
	CPI	'P'	;DIR
	JZ	DIRE
	CPI	'R'
	JZ	H38	;ENTRY NACH DDT ODER SID
	JMP	HLOOP	;WENN KEINE TASTEN ZUTRIFFT WARTEN
DIRE:	CALL	DIR
	JMP	HLOOP
LOADER1:CALL	LOADER
	JMP	HLOOP
SAVER1:	CALL	SAVER
	JMP	HLOOP
PROG:	CALL	ENDANFME  ;DIE MEMORY END - UND ANFANGSADRESSE HOLEN
	CALL	ANFPR	;EPROM ANFANGSADRESSE HOLEN
PROGII:	CALL	PROGGER	;ZUR EIGENTLICHEN PROGRAMMIER ROUTINE
	LXI	H,REPEAT
	CALL	STR
	CALL	GET
	CPI	'Y'
	JZ	PROGII
	JMP	HLOOP
LESEN:	CALL	ENDANFPR  ;ANFANGS - UND ENDADRESSE EPROM HOLEN
	CALL	ANFME	;MEMORY ANFANGSADRESSE HOLEN
	CALL	LESEIN
	JMP	HLOOP
EMPTY:	CALL	TEMPTY
	JMP	HLOOP
DUMP:	CALL	ENDANFPR	;END UND ANFANGSADRESSE EPROM HOLEN
	CALL	LESE
	JMP	HLOOP
VERGL:	CALL	ENDANFME
	CALL	ANFPR
	CALL	VERG
	JMP	HLOOP
TESTER:	CALL	TESTEN
	JMP	HLOOP
MDUMP:	LXI H,LPRA
	CALL STR
	CALL	ANFME
	CALL	DUMPERM
	JMP	HLOOP
H38:	LXI	H,SURE	;MIT JA / NEIN ABFRAGE
	CALL	STR	;IN DDT ODER SID VERZWEIGEN
	CALL	GET
	CPI	'Y'
	JNZ	HLOOP
	RST	7
HEXRECH:CALL	HEXREC
	JMP	HLOOP
MCHANGE:CALL	ANFME
	CALL	CHMEM
	JMP	HLOOP
FINDER:	LXI	H,ANFA
	CALL	STR
	CALL	HEX4IN
	SHLD	MEMANF
	LXI	H,ENDA
	CALL	STR
	CALL	HEX4IN
	SHLD	MEMEND
	CALL	FIND
	JMP	HLOOP

;* EXTERN ANSPRECHBARE ROUTINEN *

CHMEM:	LXI H,SPTABB
	CALL STR
	LHLD	MEMANF	;MIT DIESER ROUTINE KANN EINZELNE
	MVI	A,0FFH	;MEMBYTES IN HEXADEZIMALER FORM GE]NDERT WERDEN
	STA	ERRFLA	;ANFANGS ADRESSE IN HL LADEN
CHMEML:	PUSH	H	;DERZEITIGE ADRESSE RETTEN UND AUSGEBEN
	CALL	ADDOUT
	MOV	A,M	;DANN DAS ADRESSIERTE BYTE
	CALL	HEX2OUT	;ALS 2 STELLIGE HEXZAHL AUSGEBEN
	MVI	A,20H	;DANACH EIN SPACE
	CALL	PUT
	MVI	A,'-'	;EINEN BINDESTRICH
	CALL	PUT
	MVI	A,20H	;UND NOCH EIN SPACE
	CALL	PUT
	CALL	HEX4IN	;DANACH EINGEGENEN WERT HOLEN
	MOV	E,L	;IN L STEHT DER WERT
	POP	H	;DERZEITIGE ADRESSE WIEDER HOLEN
	LDA	FLAENGE	;TESTEN OB KEINE AENDERUNG ERWUENSCHT
	CPI	0
	JZ	NOCH
	MOV	A,E	;WENN DOCH DANN WERT IN MEMORY LEGEN
	MOV	M,A
NOCH	INX	H	;ADRESSE HOCH ZAEHLEN
	JMP	CHMEML	;IM LOOP VERHARREN
FIND:	CALL	FINDL	;DIESE ROUTINE ERMOEGLICHT ES EIN 50 BYTE LANGEN
	CALL	MFIND	;BELIEBIGEN STRING MIT DUMMY ELEMENTEN ZU SUCHEN
 	RET
MFIND:	LHLD	MEMEND	;ANFANGS UND ENDADRESSE DES FINDERS HOLEN
	XCHG
	LHLD	MEMANF
MFILO:	PUSH	H	;BEIDES RETTEN
	PUSH	D

	CALL	FOUNDER	;TESTEN OB AN DIESER MEM STELLE DER ENTSPRECHENDE
	POP	D	;STRING VORHANDEN IST
	POP	H
	CALL	TEST1	;TESTEN OB ROUTINE BEENDET IST
	JC	LEFIND
	INX	H	;WENN NICHT ADRESSE INCREMENTIEREN
	CALL	STATUS	;TESTEN OB TASTE GEDRUECKT
	JZ	MFILO	;WENN NICHT WEITER SUCHEN
	CALL	GET	;ANSONSTEN TASTE HOLEN
	PUSH	PSW
	MVI	A,8
	CALL	PUT
	POP 	PSW	;ZEICHEN LOESCHEN
	CPI	20H	;BEI CTRL.ZEICHEN ROUTINE VERLASSEN
	RC
	JNZ	MFILO	;BEI ANDEREM ZEICHEN ALS SPACE WEITERMACHEN
	CALL	GET	;ANSONSTEN AUF NAECHSTES ZEICHEN WARTEN
	CPI	20H	;BEI CTRL ZEICHEN RETURNEN
	RC
	MVI	A,8	;ANSONSTEN ZEICHEN LOESCHEN UND
	CALL	PUT	;WEITER SUCHEN
	JMP	MFILO
FOUNDER:LDA	FLAENGE	;DIESE ROUTINE VERGLEICHT DAS DURCH HL
	MOV	B,A	;ADRESSIERTE MEMORY MIT DEM ZU SUCHENDEN STRING
	SHLD	MEMP	;MEMPOINTER RETTEN
	SHLD	MEMP5	;UND FUER BERECHNUNG SPEICHERN
	LXI	H,MEMP2	;STRING POINTER ZUM INCREMENTIEREN
	SHLD	MEMP1	;ZWISCHENSPEICHERN
	LXI	H,MEMP3	;INHL STEHT DER FLAG POINTER DES FINDSTRINGS
	SHLD	MEMP4	;HIER FUER BERECHNUNG ZWISCHENSPEICHERN
FOLO:	MOV	A,M	;AKKU MIT FLAG LADEN
	CPI	0FFH	;WENN = FFH DANN DIESES BYTE NICHT VERGLEICHEN
	JZ	MAYRIGHT
	LHLD	MEMP1	;ANSONSTEN STRINGPOINTER HOLEN
	XCHG		;IN DE LADEN
	LHLD	MEMP	;UND MEMPOINTER IN HL
	LDAX	D	;AKKU MIT BYTE VON DE LADEN
	CMP	M	;UND MIT BYTE VON HL VERGLEICHEN
	RNZ		;WENN UNGLEICH RETUR OHNE TEXT AUSGABE
MAYRIGHT:LHLD	MEMP	;STRING-, MEM- UND FLAGPOINTER
	INX	H	;INCREMENTIEREN
	SHLD	MEMP
	LHLD	MEMP1
	INX	H
	SHLD	MEMP1
	LHLD	MEMP4
	INX	H
	SHLD	MEMP4
	DCR	B	;TESTEN OB GANZER STRING ABGEARBEITET WURDE
	JNZ	FOLO	;WENN NICHT WEITER TESTEN
	LXI	H,FINTEXT	;ANSONSTEN GEFUNDEN MELDUNG MIT SAM
	CALL	STR	;ADRESSE AUSGEBEN	
	LHLD	MEMP5	;UND RETURNEN
	CALL	HEX4OUT
	RET
FINDL:	LXI	H,MEMP2-1
	SHLD	MEMP1
	LXI	H,GFIND
	CALL	STR	
	LXI	H,INBUFER	;INPUT BUFFER
	CALL	INSTR	;DEN STRING EINLESEN
	MOV	A,M	;HL STEHT AUF DER LAENGE DES INPUTS
	MOV	B,A	;IN B SPEICHERN
	INX	H	;HL AUF ERSTES BYTE UND SAVEN
	PUSH	H
	MVI	C,1
	PUSH	B
KOMMAL:	MOV	A,M	;STRING NACH KOMMAS DURCHSUCHEN
	CPI	' '	;UND SPACES IGNORIEREN
	JZ	DECB
	CPI	','	;JEDES KOMMA BEDEUTET EINEN WERT
	JNZ	DECB
	INR	C	;IN C STEHT DIE ANZAHL DER BYTES
DECB:	INX	H
	DCR	B
	JNZ	KOMMAL	;STRING BIS ENDE DURCHSUCHEN
	POP	D
	POP	H	;HL WIEDER ERSTES BYTE
	PUSH	D
	SHLD	MEMP	;UND IN MEMORY SPEICHERN
	MOV	A,C	;ANZAHL DER BYTES ZWISCHEN SPEICHERN
	STA	FLAENGE
	POP	B	;INPUT LAENGE WIEDER IN B
BYTELO:	MOV	A,M	;STRING NACH X UND WERTEN DURCHSUCHEN
	CPI	' '	;SPACES UND KOMMAS IGNORIEREN
	JZ	DECB1	;NUR DIE MEMPOINTER DES INPUTBUFFERS ERHOEHEN
	CPI	','	;UND LAENGE DECREMENTIEREN
	JZ	DECB1
	CPI	'X'	;WENN X DANN FLAG ENTSPRECHEND SETZEN
	JZ	NOTEST
	CALL	HEXCHANGE   ;ANSONSTEN DIE FOLGENDE ZAHL IN HEX UMRECHNEN
DECB1:	INX	H	;POINTER ERHOEHEN
	DCR	B	;LAENGE DECREMENTIEREN
	JNZ	BYTELO	;UND BEI UNGLEICH 0 WEITERMACHEN
	RET
NOTEST:	PUSH	H	;MEMPOINTER DES FINDSTRINGS HOLEN
	LHLD	MEMP1
	INX	H	;ERHOEHEN UND WIEDER SPEICHERN
	SHLD	MEMP1
	LXI	D,50	;50 BYTES HOEHER
	DAD	D	;EIN
	MVI	A,0FFH	;FF ABSPEICHERN ALS ZEICHEN FUER EINEN
	MOV	M,A	;DUMMY
	POP	H	;MEM POINTER DES INPUTBUFFERS VOM STACK HOLEN
	INX	H	;FALLS ZWEI X DANN EINS LOESCHEN
	CPI	'X'	;ZURUECK INS LOOP
	JNZ	NTET
	MVI	M,20H
NTET:  	DCX	H
	JMP	DECB1
HEXCHANGE:CALL	HEXLLL	;DER DURCH HL ADRESSIERTE WERT WIRD
	PUSH	H	;UMGERECHNET IN 8 BIT UND IM AKKU ABGELEGT
	LHLD	MEMP1	;FINDSTRING POINTER ERHOEHEN
	INX	H
	SHLD	MEMP1
	MOV	M,A	;UND DAS ZU SUCHENDE BYTE ABLEGEN
	LXI	D,50	;50 BYTE WEITER DIE FLAGGE
	MVI	A,0	;0 ABLEGEN ZUM ZEICHEN DAS
	DAD	D	;DIESES BYTE VERGLICHEN WERDEN MUSS
	MOV	M,A
	POP	H
	RET		;WEITERLOOPEN
HEXLLL:	CALL	HECH	;EIN ZEICHEN VOM ASCII IN 4 BIT UMWANDELN
	MOV	E,A	;IN E SPEICHERN
	INX	H	;INPUTBUFFER POINTER ERHOEHEN
	DCR	B	;LAENGEN POINTER DECREMENTIEREN
	JNZ	NHECH	;WENN > 0 NAECHSTES BYTE TESTEN
	INR	B	;ANSONSTEN WEGEN FOLGENDEM VERGLEICH IN DER
	JMP	LFIND	;HAUPTSCHLEIFE WIEDER ERHOEHEN
NHECH:	MOV	A,M	;EIN KOMMA ZEIGT AN DASS DER WERT NUR
	CPI	','	;DURCH EIN ZEICHEN ERSTELLT WURDE
	JZ	LFIND	;
	CPI	' '	;EIN SPACE WIRD IGNORIERT
	JZ	HECH1
	CALL	HECH	;WENN EIN ZEICHEN IM AKKU DANN UMRECHNEN LASSEN
	MOV	D,A	;UND IN D SPEICHERN
	MOV	A,E	;DANN DIE ERSTEN VIER BIT AUS E LADEN
	RAL		;VIERMAL NACH LINKS ROTIEREN
	RAL
	RAL
	RAL
	ANI	0F0H	;UND EVENTUELLE UEBERTRAEGE DURCH DAS CARRY LOESCHEN
	ORA	D	;MIT D ODERIEREN SO DASS IE LETZTEN VIER BIT
	RET		;DIE NIEDERWERTIGEN SIND
LFIND:	MOV	A,E	;WENN NUR 1 ZEICHEN EINGEGEBEN DANN ZEICHEN AUS
	RET		;E IN AKKU UND RETURNEN
HECH1:	INX	H	;BEI SPACE INPUTBUFFER POINTER ERHOEHEN
	JMP	NHECH
HECH:	CPI	'0'	;DIESE ROUTINE MACH AUS EINEM ASCII ZEICHEN VIER BIT
	JC	HEXERR	;IM AKKU
	CPI	'9'+1	;WENN EIN ZEICHEN < '0' ODER '9' < X < ?
	JC	HEZIFF	;ODER > 'G' AUFTAUCHT ERROR MELDEN
	CPI	'A'	
	JC	HEXERR
	CPI	'G'
	JNC	HEXERR
	SUI	7	;BEI BUCHSTABEN SIEBEN MEHR SUBTRAHIEREN
HEZIFF:	SUI	30H	;ALS BEI ZIFFERN
	ANI	0FH	;DIE OBEREN VIER BIT LOESCHEN
	RET		;UND RETURNEN
HEXERR:	LXI	H,ERRHEX	;ERROR MELDEN UND AUF TEASTEN WARTEN
	CALL	STR
	CALL	GET	;DANN ZURUECK IN MENUE
	JMP	HLOOP
LEFIND:	LXI	H,READ	;READY MELDUNG SENDEN
	CALL	STR
	CALL	GET	;NACH DRUECKEN EINER TASTE FIND ROUTINE
	RET		;VERLASSEN
HEXREC:	LXI	H,WERT1	;DIESE BERECHNET VON ZWEI EINGEGEBENEN WERTEN
	CALL	STR	;DIE SUMME UND DIE DIFFERENZEN IN
	CALL	HEX4IN	;HEXADEZIMALER UND DEZIMALER FORM
 	SHLD	MEMANF
	LXI	H,WERT2
	CALL	STR
	CALL	HEX4IN
	PUSH	H
	LXI	H,WERT3
	CALL	STR
	POP	H
	SHLD	MEMEND
	XCHG
	LHLD	MEMANF
	XRA	A
	DAD	D
	CALL	HEX4OUT
	LXI	H,FUNFSP
	CALL	STR
	LHLD	MEMEND
	XCHG
	LHLD	MEMANF
	CALL	TEST3
	INX	H
	SHLD	PANFANG
	CALL	HEX4OUT
	LXI	H,FUNFSP
	CALL	STR
	LHLD	MEMANF
	XCHG
	LHLD	MEMEND
	INX	H
	CALL	TEST3
	SHLD	PREND
	CALL	HEX4OUT
	LXI	H,WERT4
	CALL	STR
	LHLD	MEMANF
	XCHG
	LHLD	MEMEND
	XRA	A
	DAD	D
	CALL	ASCIIOUT
	LXI	H,FUNFSP+1
	CALL	STR
	LHLD	PANFANG
	CALL	ASCIIOUT
	LXI	H,FUNFSP+1
	CALL	STR
	LHLD	PREND
	CALL	ASCIIOUT
	CALL	GET
	RET
DUMPERM:	LHLD	MEMANF	;DIESE ROUTINE DUMPT EINEN MEMORYBEREICH
	CALL	ADDOUT	;UND KANN MIT SPACE ODER CTRL S
	MOV	A,M	;ANGEHALTEN WERDEN
	CALL	HEX2OUT	;JEDE CTRL FUNKTION AUSSER CTRL S
	MVI	A,20H
	CALL	PUT	;BEWIRKT EINE RUECKKEHR INS MENUE
			;1. BYTE MIT SPACE AUSGEBEN
	INX	H	;HL AUF 2. BYTE
DULOP:	MOV	A,M	;AKKU MIT BYTE LADEN
	CALL	HEX2OUT	;BYTE ALS 2 STELLIGE HEXZAHL
	MVI	A,20H
	CALL	PUT   ;AUSGEBEN UND SPACE SENDEN
	INX	H	;HL AUF NAECHSTES ZEICHEN
	MOV	A,L	;BEI JEDEM 16. ZEICHEN
	ANI	0FH	;DIE DERZEITIGE ADRESSE
	CZ	ADDOUT	;AUSGEBEN
	CALL	STATUS	;TESTEN OB TASTE GEDRUECKT WURDE
	JZ	DULOP	;WENN NICHT WEITERLOOPEN
	CALL	GET	;ANSONSTEN TASTE HOLEN
	PUSH	PSW
	MVI A,8
	CALL	PUT
	POP PSW
	CPI	20H	;JEDE CONTROL TASTE BEWIRKT
	RC		;RUECKKKEHR ZUM MENUE
	JNZ	DULOP	;BEI SPACE ANHALTEN
	CALL	GET	;WENN CTRL RETURN
	CPI	20H
	RC
	PUSH	PSW!MVI A,8!CALL	PUT!POP PSW
	JMP	DULOP	;NACH NAECHSTEM TASTEN DRUCK WEITERMACHEN
TEMPTY:	LXI H,EWAGU
	CALL STR
	MVI	A,39H	;DIESE ROUTINE TESTET OB
	CALL	OUTA	;EIN EPROM GELOESCHT IST
	CALL	INLOOP	;UND GIBT DEN ENTSPRECHENDEN TEXT AUS
	CPI	0FFH
	JZ	OKPR
	LXI	H,NCLEAR	;TEXT FUER PROGRAMMIERTES
	CALL	STR		;EPROM
	CALL	GET
	RET
OKPR:	LXI	H,CLEAR	;TEXT FUER EPROM GELOESCHT
	CALL	STR
	CALL	GET
	RET
LESEIN:
	CALL	TIMING	;EPROMINHALT IN MEMORY LEGEN
	CALL	BALKEN	;ZUERST TEILUNGSWERTE FUER ANZEIGE
	LHLD	PANFANG	;DER LAENGE BERECHNEN
	MVI	A,READAD;DANN ADRESSE MIT ENTSPRECHENDEM
	CALL	OUTA	;CODEWORT AN EPROMER SENDEN
	MOV	A,H
	CALL	OUTA
	MOV	A,L
	CALL	OUTA
		CALL	INLOOP	;1. BYTE LESEN
	LHLD	MEMEND	;MEMORY ANFANGS UND ENDADRESSE HOLEN
	XCHG
	LHLD	MEMANF
	MOV	M,A	;UND ERSTES BYTE ABSPEICHERN
LES:	INX	H	;HL AUF NAECHSTES BYTE
	CALL	BALKEN	;GEGEBENENFALLS EINEN DER '=' LOESCHEN
	CALL	TEST1	;TESTEN OB SCHLEIFE ZU ENDE
	RC
	MVI	A,READNOAD	;CODEWORT FUER NAECHSTES BYTE
	CALL	OUTA	;ABSCHICKEN
	CALL	INLOOP	;BYTE LADEN
	MOV	M,A	;UND IN MEMORY LEGEN
	CALL	DELAY	;WARTESCHLEIFE FUER SCHNITTSTELLEN
	JMP	LES	;SYNCHRONISATION
VERG:	LXI	H,VERLAU
	CALL	STR
	LHLD	PANFANG	;DIESE ROUTINE VERGLEICHT MEM MIT EPROM
	MVI	A,READAD
	CALL	OUTA	;1. CODEWORT + ADRESSE SENDEN
	MOV	A,H
	CALL	OUTA
	MOV	A,L
	CALL	OUTA
	LHLD	MEMEND	;MEMORY ANFANGS UND ENDADRESSE LADEN
	XCHG
	LHLD	MEMANF
	CALL	INLOOP	;BYTE HOLEN UND VERGLEICHEN
	CMP	M
	CNZ	UNGL	;BEI UNGLEICHHEIT TEXT FUER FEHLER AUSGEBEN
VERGLLO:INX	H	;HL EIN BYTE WEITER
	CALL	TEST1	;TESTEN OB ENDE
	JC	GL	;WENN TESTEN OB BISHER KEIN FEHLER
	MVI	A,READNOAD	;WENN WEITER DANN CODE SCHICKEN
	CALL	OUTA	;
	CALL	INLOOP	;NAECHSTES BYTE HOLEN UND MIT MEM
	CMP	M	;VERGLEICHEN BEI UNTERSCHIEDLICHEN WERTEN
	CNZ	UNGL	;FEHLER MELDUNG MIT ADRESS ANGABE AUSGEBEN
	CALL	DELAY	;WARTESCHLEIFE FUER SYNCHRONISATION
	CALL	STATUS	;TASTATUR STATUS HOLEN
	JZ	VERGLLO	;WENN KEINE TASTE GEDRUECKT WEITER MACHEN
	CALL	GET	;ANSONSTEN BEI JEDER CTRL TASTE RETURNEN
	CPI	20H
	RC
	PUSH	PSW!MVI A,8!CALL	PUT!POP PSW
	JMP	VERGLLO
UNGL:	PUSH	H	;TEXT FUER UNTERSCHIEDE ZWISCHEN
	LXI	H,WRONG	;RAM UND EPROM AUSGEBEN
	CALL	STR
	POP	H
	PUSH	H
	PUSH	D
	CALL	HEX4OUT	;RAM ADRESSE SENDEN
	POP	D
	POP	H
	MVI	A,0FFH	;FEHLER FLAG SETZEN
	STA	UNGFL
	RET
GL:	LDA	UNGFL	;FEHLER FLAG TESTEN UND LOESCHEN
	CPI	0FFH
	MVI	A,0
	STA	UNGFL
	JZ	NGL	;WENN GESETZT KEIN TEXT
	LXI	H,EPRGUT;ANSONSTEN GUT MELDUNG SENDEN
	CALL	STR
NGL:	CALL	GET
	JMP	HLOOP
PROGGER:CALL	TIMI2	;ANZAHL DER LEERSCHRITTE BERECHNEN
	CALL	BALKEN
	LHLD PANFANG
	MVI A,PROGAD
	CALL OUTA
	MOV A,H
	CALL OUTA
	MOV A,L
	CALL OUTA
	LHLD MEMEND
	XCHG
	LHLD MEMANF
	MOV A,M
	MOV C,A
	CALL	OUTA	;BYTE SENDEN
	CALL	INLOOP	;AUF QUITTUNG WARTEN
	CMP	C	;WENN QUITTUNG UNGLEICH GESENDETES BYTE
	JNZ	EPRPUT	;EPROM DEFEKT TEXT AUSGEBEN
	INX	H	;HL AUF NAECHSTES BYTE STELLEN
PRLOOP:	CALL	BALKEN	;'=' LOESCHEN ODER NICHT
	CALL	TEST1	;TESTEN OB SCHLEIFE BEENDIGT
	RC		;WENN JA RETURNEN
	MVI	A,PROGNOAD	;PROGRAMMIERER WORT SENDEN
	CALL	OUTA
	MOV	A,M	;MEMBYTE HOLEN IN SPEICHER UND SENDEN
	MOV	C,A
	CALL	OUTA
	CALL	INLOOP	;QUITTUNG MIT C VERGLEICHEN BEI <> ERROR
	CMP	C
	JNZ	EPRPUT
	INX	H
	CALL DELAY	;ANSONSTEN WARTE SCHLEIFE
	JMP	PRLOOP
LESE:	LHLD	PREND	;EPROM ENDADRESSE IN DE
	XCHG
	LHLD	PANFANG	;ANFANGSADRESSE IN HL
	CALL	TEST1	;VERGLEICH AUF FEHLERHAFTE ADRESSEINGABE
	JC	ADDFAL
	MVI	A,READAD	;CODE WORT AN EPROMER SENDEN
	CALL	OUTA	;UND DIE ADRESSE
	MOV	A,H
	CALL	OUTA
	MOV	A,L
	CALL	OUTA
	CALL	ADDOUT	;ERSTE ADRESSE AUSGEBEN
	MVI	A,20H
	CALL	PUT	;EIN SPACE SENDEN
	CALL	INLOOP	;ERSTES BYTE EINLESEN
	CALL	HEX2OUT	;UND AUSGEBEN
LESELOP	INX	H	;EPROM POINTER ERHOEHEN
	CALL	TEST1	;VERGLEICHEN OB ENDADRESSE ERREICHT
	JC	GET	;WENN JA RETURNEN NACH 1 TASTEN DRUCK
	MOV	A,L	;FESTLEGEN WANN EINE ADRESSE GESENDET
	ANI	0FH	;WIRD
	CZ	ADDOUT
	MVI	A,20H
	CALL	PUT   	;NACH JEDEN BYTE EIN SPACE
	MVI	A,READNOAD	;NAECHSTES BYTE VOM EPROMER
	CALL	OUTA	;ANFORDERN
	CALL	INLOOP	;ZEICHEN EMPFANGEN
	CALL	HEX2OUT	;UND AUSGEBEN
	CALL	STATUS	;TESTEN OB EINE TASTE GEDRUECKT
	JZ	LESELOP	;WURDE WENN  NICHT WEITER MACHEN
	CALL	GET	;ANSONSTEN TASTE HOLEN
	PUSH	PSW
	MVI A,8
	CALL	PUT
	POP PSW
	CPI	20H	;JEDE CONTROL TASTE BEWIRKT
	RC		;RUECKKEHR ZUM MENUE
	JNZ	LESELOP	;BEI SPACE ANHALTEN
	CALL	GET
	PUSH	PSW!MVI A,8!CALL	PUT!POP PSW
	CPI	20H
	RC
 	JMP	LESELOP	;NACH NAECHSTEM TASTEN DRUCK WEITERMACHEN
TEST1:	PUSH	H
	PUSH D
	MOV	A,E	;VERGLEICHEN OB DE < HL
	CMA		;WENN DE < HL DANN CARRY GESETZT
	MOV	E,A	;ABER MIT ERHALTENEN REGISTERN
	MOV	A,D	;RETURNEN
	CMA
	MOV	D,A
	DAD	D
	POP	D	
	POP	H
	RET
TEST3:	MOV	A,E	;VERGLEICHEN OB DE < HL
	CMA		;WENN DE < HL DANN CARRY GESETZT
	MOV	E,A
	MOV	A,D
	CMA
	MOV	D,A
	DAD	D
	RET
TESTEN:	LXI	H,TESTLAU
	CALL	STR
	MVI	A,TEST	;TEST CODE WORT SENDEN
	CALL	OUTA
	CALL	INLOOP	;UND AUF ANTWORT WARTEN
	CPI	TOK
	JZ	EPROMOK
EPRPUT:	LXI	H,DEFEKT;EPROM DEFEKT MELDEN
	CALL	STR	
	JMP	GET

;		EQUALS

BDOS:	EQU	5	;ALLGEMEINER CP/M EINSPRUNG
GETCHAR	EQU	1	;CODEWORT FUER 1 ZEICHEN LESEN
PRT:	EQU	2	;CODEWORT FUER 1 ZEICHEN AUSGEBEN
PGSOUT:	EQU	4	;CODEWORT FUER SER.KANAL Z. PGS
PGSIN:	EQU	3	;CODEWORT FUER SER.KANAL V. PGS
STRING:	EQU	9	;CODEWORT FUER SPRING PRINT
INPUT:	EQU	10	;CODEWORT FUER INPUT ROUTINE
DATPORT	EQU	0EEH	;HIER PORT DER SYSTEM SCHNITTSTELLE
STPORT:	EQU	DATPORT+1	;EINTRAGEN UND GEGEBENENFALLS
			;DIE I/O DRIVER ANPASSEN


;MEMBYTES


MEM:	EQU	1500H	;DIE PARAMETER TABLE LIEGT
			;AB 2100H
ETYPE:	EQU	MEM	;ZWISCHEN SPEICHERN DES TYPES
PANFANG	EQU	MEM+1	;ANFANGSADRESSE IM EPROM
PREND	EQU	MEM+3	;ENDADRESSE EPROM
MEMANF	EQU	MEM+5	;MEMORY ANFANGSADRESSE
MEMEND	EQU	MEM+7	;MEMORY ENDADRESSE
LAENGE	EQU	MEM+9	;DIE LAENGE DES ERPROMS IN BYTE
ZEIT	EQU	MEM+11	;DIE ZEITKONSTANTE FUER ANZEIGE
ZEIT2	EQU	MEM+13	;ZWISCHENSPEICHER
UNGFL	EQU	MEM+15	;FLAG UNGLEICHHEIT MIT MEM
ZEIT3	EQU	MEM+17	;
STORE	EQU	MEM+19	;ASCIISTRING = 5 ZEICHEN
MEMP	EQU	MEM+25	;POINTER FUER FIND
MEMP1	EQU	MEM+27	;MEMPOINTER FUER FIND
MEMP4	EQU	MEM+29	;BYTEPOINTER FUER FIND
MEMP5	EQU	MEM+31	;
FLAENGE	EQU	MEM+33	;LAENGE DES FIND STRINGS
ERRFLA	EQU	MEM+35	;ERROR FLAG
LAFL:	EQU	MEM+37
PFFL:	EQU	MEM+39
MEMP2	EQU	MEM+100	;ANFANG DES FIND STRINGS
MEMP3	EQU	MEM+150	;ANGANG DER FLAGS FUER FIND
INBUFER EQU	13F0H	;INPUT BUFFER FUER CP/M


;* DATEN WORTE DES EPROMERS


INI:	EQU	30H	;SETZT EPROMER IN GRUNDSTELLUNG
TYP:	EQU	36H	;EPROMER ERWARTET TYPENNUMMER
T1658:	EQU	01	;TYPEN WORT FUER 2716/2758
T2732:	EQU	04	;  "     "   "   2732
T2764:	EQU	05	;  "     "   "   2764
T2732A:	EQU	07	;  "     "   "   2732A
T2564:	EQU	09	;  "     "   "   2564
T2532:	EQU	10	;  "     "   "   2532
T27128:	EQU	11	;  "     "   "   27128
T2816A: EQU	13	;  "     "   "   2816A
TEST:	EQU	0B7H	;TESTLAUF FUER BAUSTEIN
TOK:	EQU	35H	;TEST OK QUITTUNG
TBAD:	EQU	0FFH	;TEST FEHLERHAFT QUITTUNG
LEER:	EQU	39H	;TEST OB EPROM LEER
LEEROK:	EQU	0FFH	;EPROM LEER QUITTUNG
LEERBAD:EQU	00	;EPROM NICHT LEER QUITTUNG
PROGAD:	EQU	0B1H	;PROGRAMMIEREN MIT NACH FOLGENDER ADRESSE
			;UND DATEN WORT
PROGNOAD: EQU	0B2H	;PROGRAMMIEREN OHNE ADRESSE
				;EINGABE DATEN WORT FOLGT
READAD:	EQU	33H	;DATENBYTE LESEN MIT ADRESS-
			;ANGABE
READNOAD: EQU	0B4H	;DATEN BYTE LESEN


;*  EPROMER I/O UNTERPROGRAMME


OUTA:	PUSH	PSW	;SENDET EIN DATUM ZUM PGS
	PUSH	B
	PUSH	D
	PUSH	H
	MVI	C,PGSOUT
	MOV 	E,A
	CALL 	BDOS
	POP H
	POP D
	POP B
	POP PSW
	RET
;
INLOOP:	PUSH H
	PUSH D
	PUSH B
	MVI C,PGSIN	;HOLT EIN DATENWORT VOM PGS
	CALL BDOS
	POP B
	POP D
	POP H
	RET


;*  WICHTIGE UNTERPROGRAMME FUER CONSOLE


GET:	PUSH	H
	PUSH	D
	PUSH	B
	MVI	C,GETCHAR	;IN DEN AKKU LESEN
	CALL	BDOS
	POP	B
	POP	D
	POP	H
	RET
PUT:	PUSH	H
	PUSH	D
	PUSH	B	;EIN ZEICHEN IM AKKU
	MVI	C,PRT		;AUF CONSOLE SENDEN
	MOV	E,A
	CALL	BDOS
	POP	B
	POP	D
	POP	H
	RET
STATUS:	PUSH	H!PUSH	D!PUSH	B
	MVI	C,11
	CALL	BDOS
	ORA A
	POP	B!POP	D!POP	H
	RET
STR:	PUSH	H!PUSH	D!PUSH	B!PUSH	PSW!	;SENDET STRING AB H
	MVI	C,STRING	;BIS $ AUF CONSOLE
	XCHG
	CALL	BDOS
	POP	PSW!POP B!POP	D!POP	H
	RET
INSTR:	PUSH	H
	PUSH	D
	PUSH	B
	PUSH	PSW		;LIEST STRING VON
	MVI	M,255	
	XCHG			;SPEICHERT DIESEN
	MVI	C,INPUT
	CALL	BDOS		;AB HL+2
	POP	PSW
	POP	B
	POP	D
	POP	H
	INX	H
	RET
ENDANFME:	LXI	H,ANFA	;TEXT FUER EINGABE ANFANG AUSGEBEN
	CALL	STR
	CALL	HEX4IN	;WERT IN HL HOLEN
	SHLD	MEMANF	;UND SPEICHERN
	LXI	H,ENDA	;TEXT FUER EINGABE ENDADRESSE
	CALL	STR	;AUSGEBEN
	CALL	HEX4IN	;UND UMRECHNEN DER EINGABE
	SHLD	MEMEND
	CALL	TMEADD
	RET
ENDANFPR:	LXI	H,ANFAPR
	CALL	STR	;ANFANGS UND ENDADRESSE DES EPROMS HOLEN
	CALL	HEX4IN
	SHLD	PANFANG
	LXI	H,ENDAPR
	CALL	STR
	CALL	HEX4IN
	SHLD	PREND
	CALL	TPRADD
	RET
ANFPR:	LXI	H,ANFAPR	;ANFANG EPROM
	CALL	STR
	CALL	HEX4IN
	SHLD	PANFANG
	RET
ANFME:	LXI	H,ANFA+4	;ANFANG MEMORY
	CALL	STR
	CALL	HEX4IN
	SHLD	MEMANF
	RET
EPROMOK:LXI	H,GUTTEXT	;EPROM GUT MELDEN
	CALL	STR
	CALL	GET
	RET
ADDFAL:	LDA	ERRFLA
	CPI	0FFH
	MVI	A,0
	STA	ERRFLA
	JZ	HLOOP
	LXI	H,FALADD	;ERROR MELDUNG
	CALL	STR		;BEI FALSCHEN
	CALL	GET		;ADRESSEN
	JMP	HLOOP
CRLF:	MVI	A,10		;CARRIAGE RETURN
	CALL	PUT		;LINE FEED AUSGEBEN
	MVI	A,13
	JMP	PUT
HEX4IN:	LXI	H,INBUFER	;CP/M STRING INPUT
	CALL	INSTR		;AUFRUFEN
	MOV	A,M
	STA	FLAENGE
	MOV	B,A		;INPUT LAENGE IN B
	LXI	D,0		;INPUT REGISTER LOESCHEN
	CPI	0		;WENN KEINE EINGABE
	JZ	EXIT		;MIT 0 RETURNEN
HEXLOOP:INX	H		;HL AUF ASCII ZEICHEN
	MOV	A,M
	CPI	20H		;SPACES IGNORIEREN
	JZ	HEXLO2
	CPI	'0'		;WENN < ASCII 0
	JC	ADDFAL		;ERROR MELDEN
	CPI	'9'+1
	JC	ZIFF		;WENN 0< X <=9
	CPI	'A'		;DANN ZIFFER ERKANNT
	JC	ADDFAL		;WENN KLEINER A ERROR
	CPI	'F'+1		;WENN KLEINER GUELTIGER
	JC	LETTER		;BUCHSTABE
	JMP	ADDFAL
HEXLO2:	DCR	B		;TESTEN OB ALLE ZEICHEN
	JNZ	HEXLOOP		;GELESEN
EXIT:	XCHG			;WERT IN HL
	RET			;UND ZURUECK
ZIFF:	ADI	7		;ZIFFERN UND BUCHSTABEN
LETTER:	SUI	55		;UMRECHNEN
	PUSH	H		;UND DR ROTIEREN
	LXI	H,0
	DAD	D
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	LXI	D,0
	MOV	E,A
	DAD	D
	XCHG
	POP	H
	JMP	HEXLO2
HEX4OUT:MOV	A,H		;HL IN 4 HEXZEICHEN
	CALL	HEX2OUT		;AUSGEBEN
	MOV	A,L
	CALL	HEX2OUT
	RET
HEX2OUT:MOV	C,A		;AKKU ALS ZWEI HEXZEICHEN
	RAR			;AUSGEBEN
	RAR
	RAR
	RAR
	CALL	HEXOUT
	MOV	A,C
	CALL	HEXOUT
	RET
HEXOUT:	ANI	0FH		;DIE UNTEREN 4 BIT
	CPI	10		;DES AKKUS ALS
	JC	ZIFFER		;HEXZEICHEN AUSGEBEN
	ADI	7
ZIFFER:	ADI	30H
	JMP	PUT
ASCIIOUT:	CALL	ASCII	;DIESE ROUTINE RECHNET
	LXI	H,STORE	;DEN IN HL ANGEGEBENEN WERT IN 5 BYTE
	MVI	B,5	;DEZIMAL SSCIICODE UM
ASCLO:	MOV	A,M	;UND GIBT IHN AN DIE COURSOR
	CALL	PUT	;POSITION AUS
	DCR	B
	INX	H
	JNZ	ASCLO
	MVI A,20H
	CALL PUT
	MVI A,20H
	CALL PUT
	RET
ASCII:	PUSH	H
	PUSH	D
	PUSH	B
	PUSH	PSW
	LXI	B,STORE
	LXI	D,10000
	CALL	STORE1
	LXI	D,1000
	CALL	STORE1
	LXI	D,100
	CALL	STORE1
	LXI	D,10
	CALL	STORE1
	LXI	D,1
	CALL	STORE1
	POP	PSW
	POP	B
	POP	D
	POP	H
	RET
STORE1:	PUSH	B
	CALL	SUBLO
	MOV	A,B
	ADI	30H
	POP	B
	STAX	B
	INX	B
	RET
SUBLO:	MVI	B,0
SUBLO1:	CALL	SAB
	INR	B
	JMP	SUBLO1
SAB:	MOV	A,L
	SUB	E
	MOV	L,A
	MOV	A,H
	SBB	D
	MOV	H,A
	RNC
	DAD	D
	POP	D
	RET
ADDOUT:	CALL	CRLF		;ADDRESSAUSGABE
	CALL	HEX4OUT		;VON HL MIT CRLF
	MVI	A,':'		;DOPPELPUNKT
	CALL	PUT		;UND SPACE
	MVI	A,20H
	CALL	PUT
	RET
TPRADD:	LHLD	PANFANG		;VERGLE	A,L
	XCHG
	LHLD PREND
	JMP TEST2
TMEADD:	LHLD MEMANF
	XCHG
	LHLD MEMEND
TEST2:	DCX	D
	CALL	TEST3
	XCHG
	LHLD	LAENGE
	CALL TEST3
	JNC ADDFAL
	RET
MEMANR:	LHLD PANFANG
	XCHG
	LHLD PREND
	DCX D
	CALL TEST3
	XCHG
	LHLD MEMANF
	DAD	D
	SHLD	MEMEND
	RET
MODUS:	LXI	H,MODI1		;EPROMER MODUS
	CALL	STR		;AUSGEBEN
	LDA	ETYPE
	RAL
	RAL
	RAL
	ANI	00111000B
	LXI	H,MODE
	LXI	D,0
	MOV	E,A
	DAD	D
	CALL	STR
	RET
TIMING:	PUSH	H
	PUSH	D
	PUSH	B
	CALL	MEMANR
	POP	B
	POP	D
	POP	H
TIMI2:	PUSH	H
	PUSH	D
	PUSH	B
	LHLD	MEMEND
	XCHG
	LHLD	MEMANF
	XCHG
	DCX	D
	CALL	TEST3
	INX	H
	PUSH	H
	PUSH	H
	MOV	A,H
	MOV	L,A
	MVI	H,0
	DAD	H
	DAD	H
	POP	D
	MOV	A,E
	ANI	0C0H
	RAL
	RAL
	RAL
	ANI	3
	MVI	B,0
	MOV	C,A
	DAD	B
	SHLD	ZEIT
	SHLD	ZEIT2
	POP	H
	MOV	A,L
	ANI	3FH
	STA	ZEIT3
	LHLD	ZEIT
	MOV	A,H
	ORA	L
	JZ	LESS1
	LXI	H,TIME
	CALL	STR
	LXI	H,TIMEST
	CALL	STR
	POP	B
	POP	D
	POP	H
	RET
LESS1:	LDA	ZEIT3
	MVI	L,1
	SHLD	ZEIT
	SHLD	ZEIT2
	LXI	H,TIME
	CALL	STR
	INR	A
	MOV	B,A
	XRA	A
	STA	ZEIT3
LESSLO:	MVI	A,'='
	CALL	PUT
	DCR	B
	JNZ	LESSLO
	POP	B
	POP	D
	POP	H
	RET
BALKEN:	PUSH	H
	LHLD	ZEIT3
	MOV	A,H
	ORA	L
	JNZ	NOTB
	LHLD	ZEIT2
	DCX	H
	SHLD	ZEIT2
	MOV	A,H
	ORA	L
	POP	H
	RNZ
	PUSH	H		
	LHLD	ZEIT
	SHLD	ZEIT2
	MVI	A,8
	CALL	PUT
	MVI	A,20H
	CALL	PUT
	MVI	A,8
	CALL	PUT
	POP	H
	RET
NOTB:	DCX	H
	SHLD	ZEIT3
	POP	H
	RET
DELAY:	PUSH	B
	LXI	B,10H
DLOP:	DCX	B
	MOV	A,B
	ORA	C
	JNZ	DLOP
	POP	B
	RET
BDOS:	EQU	5
OPENF:	EQU	15
CLOSEF:	EQU	16
DELETF:	EQU	19
WRITES:	EQU	21
READS:	EQU	20
MAKEF:	EQU	22
SETDMA:	EQU	26
FCB:	EQU	5CH
FILENM:	EQU	65H
SAVER:	LXI	H,IN1ADR
	CALL	STR
	CALL	HEX4IN
	SHLD	ADR1
	LXI	H,IN2ADR
	CALL	STR
	CALL	HEX4IN
	SHLD	ADR2
	CALL	INNAME
	CALL	SAVE
	RET
LOADER:	LXI	H,IN1ADR
	CALL	STR
	CALL	HEX4IN
	SHLD	ADR1
	CALL	INNAME
	CALL	LOAD
	RET
INNAME: LXI	H,INPSTR
	CALL	STR
	LXI H,COMFOR
	CALL STR
	LXI	H,INBUFER
	CALL	INSTR
	MOV	A,M
	MOV	C,A
	MVI	B,0
	PUSH	H
	INX	B
	DAD	B
	MVI	M,0
	POP	H
	CPI	0
	RZ
DPFIN:	MOV	A,M
	PUSH	H
	CPI	':'
	JZ	DPYES
	CPI	0
	JZ	DPNO
	POP	H
	INX	H
	JMP	DPFIN
DPYES:	DCX	H
	MOV	A,M
	CPI	' '
	JZ	DPYES
	CPI	'A'
	JC	BERR
	CPI	'D'
	JNC	BERR
	SUI	40H
	STA	FCB
	JMP	TYPFIN
DPNO:	POP	H
	LXI	H,INBUFER+1
	PUSH	H
	MVI	A,0
	STA	FCB
TYPFIN:	POP	H
	LXI	D,FCB+1
	MVI	C,9
TYPLOP: INX	H
	MOV	A,M
	CPI	'.'
	JZ	FILLSP
	CPI	' '
	JZ	TYPLOP
	CPI	'A'
	JC	BERR
	CPI	'Z'+1
	JNC	BERR
	STAX	D
	INX	D
	DCR	C
	JZ	BERR
	JMP	TYPLOP
FILLSP:	DCR	C
	JZ	TYPTRA
	MVI	A,20H
	STAX	D
	INX	D
	JMP	FILLSP
TYPTRA:	MVI	C,3
	LXI	D,FILENM
TRANLO:	INX	H
	MOV	A,M
	CPI	0
	JZ	BERR
	CPI	' '
	JZ	TRANLO
	CPI	'A'
	JC	BERR
	CPI	'Z'
	JNC	BERR
	STAX	D
	INX	D
	DCR	C
	JNZ	TRANLO
	RET
BERR:	LXI	H,INPUTER
	CALL	STR
	CALL	GET
	JMP	HLOOP	;ACHTUNG HIER ADRESSE EINGEBEN
			;AN DER DER STACK NEU  GESETZT WIRD
SAVE:	PUSH	H
	PUSH	D
	PUSH	B
	XRA	A
	STA	7CH
	LXI	H,FCB
	MVI	C,DELETF
	LXI	D,FCB
	CALL	BDOS
	MVI	C,MAKEF
	LXI	D,FCB
	CALL	BDOS
	CPI	0FFH
	JZ	BDOSERR
	LHLD	ADR1
	LXI	D,80H
SETADR:	PUSH	H
	PUSH	D
	XCHG
	MVI	C,SETDMA
	CALL	BDOS
	MVI	C,WRITES
	LXI	D,FCB
	CALL	BDOS
	POP	D
	POP	H
	DAD	D
	CPI	0
	JNZ	BDOSERR
	LDA	ADR2+1
	CMP	H
	JC	FILEEND
	JNZ	SETADR
	LDA	ADR2
	CMP	L
	JC	FILEEND
	JNZ	SETADR
FILEEND	MVI	C,CLOSEF
	LXI	D,FCB
	CALL	BDOS
	MVI	A,0
BDOSEX:	POP	B
	POP	D
	POP	H
	RET
BDOSERR:MVI	A,0FFH
	JMP	BDOSEX
LOAD:	PUSH	H
	PUSH	D
	PUSH	B
	XRA	A
	STA	7CH
	LXI	H,FCB
	MVI	C,OPENF
	LXI	D,FCB
	CALL	BDOS
	CPI	0FFH
	JZ	BDOSERR
	LHLD	ADR1
	LXI	D,80H
SETADRL:PUSH	H
	PUSH	D
	XCHG
	MVI	C,SETDMA
	CALL	BDOS
	MVI	C,READS
	LXI	D,FCB
	CALL	BDOS
	POP	D
	POP	H
	DAD	D
	CPI	0
	JZ	SETADRL
	MVI	C,CLOSEF
	LXI	D,FCB
	CALL	BDOS
	MVI	A,0
	POP	B
	POP	D
	POP	H
	RET
DIR:	LXI	H,LAUFWER
	CALL	STR
	CALL	GET
	PUSH	PSW
	MVI	C,13
	CALL	BDOS
	POP	PSW
	CPI	'A'
	JC	DIRE
	CPI	'D'
	JNC	DIRE
	SUI	64
	STA	FCB
	MVI	A,3
	STA	LAFL
	MVI	A,12
	LXI	H,FCB+1
DIRLO:	MVI	M,'?'
	INX	H
	DCR	A
	JNZ	DIRLO
	MVI	A,13
	CALL	PUT
	MVI	A,10
	CALL	PUT
	MVI	C,11H
	LXI	D,FCB
	CALL	BDOS
	CALL	OUTPROG
	MVI	A,20H
	CALL	PUT
	MVI	A,20H
	CALL	PUT
DIRLO3:	LDA	LAFL
	MOV	B,A
	MVI	A,4
	STA	LAFL
DIRLO2:	PUSH	B
	MVI	C,12H
	LXI	D,FCB
	CALL	BDOS
	CALL	OUTPROG
	MVI	C,2
SPAA:	MVI	A,20H
	CALL	PUT
	DCR	C
	JNZ	SPAA
	POP	B
	DCR	B
	JNZ	DIRLO2
	MVI	A,13
	CALL	PUT
	MVI	A,10
	CALL	PUT
	JMP	DIRLO3
OUTPROG:CPI	0FFH
	JZ	DIREX
	ANI	03
	RAL
	RAL
	RAL
	RAL
	RAL
	ANI	1100000B
	MOV	C,A
	LXI	H,80H
	DAD	B
	INX	H
	MVI	C,8
OUTNAM:	MOV	A,M
	CALL	PUT
	INX	H
	DCR	C
	JNZ	OUTNAM
	MVI	A,20H
	CALL	PUT
	MVI	A,20H
	CALL	PUT
	MVI	A,'.'
	CALL	PUT
	MVI	C,3
OUTNA:	MOV	A,M
	CALL	PUT
	INX	H
	DCR	C
	JNZ	OUTNA
	RET
DIREX:	CALL	GET
	JMP	HLOOP

INPSTR:	DB	10,10,13,'DATEINAME........ $'
IN1ADR:	DB	26,10,10,13,'ANFANGSADRESSE... $'
IN2ADR: DB	10,10,13,'ENDEADRESSE...... $'
ADR1:	DW	0
ADR2:	DW	0
INPUTER	DB	10,10,13,'EINGABE-FEHLER !!$'


;TEXTE UND SEQUENZEN


EWAGU:	DB	26,13,'EPROM WIRD AUF GELOESCHT UNTERSUCHT !$'
LPRA:	DB	26,10,13,'(LEERTASTE->PAUSE / RETURN->ABBRUCH)',10,13,'$'
COMFOR:	DB	'(FORMAT: *.COM) $'
MENUE:	DB	26,10,13
	DB	'	A = EPROM AUS SPEICHER PROGRAMMIEREN',10,13
	DB	'	B = EPROM IN SPEICHER LADEN',10,13
	DB	'	C = EPROM MIT SPEICHER VERGLEICHEN',10,13
	DB	'	D = EPROM-INHALT AUSGEBEN',10,13
	DB	'	E = EPROM TESTEN',10,13
	DB	'	F = PRUEFEN OB EPROM GELOESCHT',10,13
	DB	'	G = EPROM-TYP AENDERN',10,13
	DB	'	H = SPEICHER-INHALT AUSGEBEN',10,13
	DB	'	I = SPEICHER EDITIEREN',10,13
	DB	'	K = STRING SUCHEN',10,13
	DB	'	L = DATEI LADEN',10,13
	DB	'	M = DATEI SCHREIBEN',10,13
	DB	'	N = HEX RECHNEN',10,13
	DB	'	O = ZURUECK ZUM SYSTEM',10,13
	DB	'	P = DISKETTEN-INHALTSANGABE',10,13,'$'
TYPE:	DB	26,10,10,13,' BEDIENPROGRAMM FUER PROGRAMMIERGERAET PGS48 / V1.0'
	DB	10,13,   ' --------------------------------------------------'
	DB	10,10,13,' URHEBERRECHTE BEI "ERTEC GMBH", ERLANGEN',10,10,13
	DB	10,'	A = 2716/2758',10,13
	DB	'	B = 2732',10,13
	DB	'	C = 2764',10,13
	DB	'	D = 2732A',10,13
	DB	'	E = 2564',10,13
	DB	'	F = 2532',10,13
	DB	'	G = 27128',10,13
	DB	'	H = 2816A',10,10,13
	DB	10,10,'EPROM-TYP... $'
SURE:	DB	10,10,13
	DB	'NUR MOEGLICH WENN PROGRAMM VOM DEBUGGER GESTARTET (Y/N) $'
LAUFWER DB	26,10,10,10,'LAUFWERK (A,B,C)...$'
ANFA:	DB	26,10,13,10,10,'SPEICHER-ANFANGSADRESSE... $'
ENDA:	DB		 13,10,'SPEICHER-ENDEADRESSE...... $'
ANFAPR:	DB		 13,10,'EPROM-ANFANGSADRESSE...... $'
ENDAPR:	DB		 13,10,'EPROM-ENDEADRESSE......... $'
WRONG:	DB		 13,10,'FEHLER AUF ADRESSE	: $'
EPRGUT:	DB	13,10,10,7,'EPROM = SPEICHER $'
CLEAR:	DB	10,10,13,7,'EPROM IST GELOESCHT',10,13,'$'
NCLEAR:	DB	10,10,13,7,'EPROM IST NICHT GELOESCHT',10,13,'$'
PROK:	DB	10,10,13,7,'PROGRAMMIERUNG RICHTIG BEENDET',10,13,'$'
PRMURKS	DB	10,10,13,7,'PROGRAMMIERUNG MIT FEHLER ABGEBROCHEN',10,13,'$'
DEFEKT:	DB	10,10,13,7,'PROGRAMMIERFEHLER',10,13,'$'
GUTTEXT	DB	10,10,13,7,'EPROM IST IN ORDNUNG$'
CLS:	DB	26,10,10,10,'$'
ERRORTXT	DB	26,10,10,10,'E R R O R$'
NOTRED	DB	26,10,10,10,7,'P G S 4 8  -  U N K L A R  $'
FALADD	DB	13,10,10,'EINGABE-FEHLER$'
MODI1	DB	13,10,10,'    ANGEWAEHLTER TYP: $'
MODE	DB	'2716   $2732   $2764   $2732A  $2564   $2532   $'
	DB	'27128  $2816A	$'
TIME:	DB	10,10,13,'0                                 '
	DB	'                            100',10,13,'$'
TIMEST:	DB	'==========================================='
	DB	'===================$'
WERT1:	DB	26,10,10,10,10,10,10,'1. WERT... $'
WERT2:	DB	10,10,13,'2. WERT... $'
WERT3:	DB	10,10,13,'  X+Y    X-Y    Y-X ',10,10,13,' $'
WERT4:	DB	10,10,13,'$'
FUNFSP:	DB	'	$'
REPEAT:	DB	10,10,13,7,'PROGRAMMIERUNG WIEDERHOLEN (Y/N)$'
GFIND:	DB	13,10,10,'STRING... ',13,10,' ? : $'
FINTEXT	DB	13,10,'GEFUNDEN BEI ADDRESSE ; $'
ERRHEX:	DB	13,10,10,'INPUT ERROR$'
READ:	DB	13,10,10,'SUCHEN BEENDET$'
VERLAU:	DB	13,10,10,'VERGLEICH EPROM<->SPEICHER LAUEFT !$'
TESTLAU	DB	13,10,10,'EPROM WIRD GETESTET !$'
SPTABB	DB	13,10,'(ABBRUCH MIT CTRL/S,RETURN)$'
STOP:	DB	0
	END	100H
