/******************************************************************************
*  I N I T W  *  C P M S Y S 4  *  T h o m a s   H o l t e  *   8 5 0 4 2 9   *
*******************************************************************************
* 									      *
*    U T I L I T Y   F O R   G E N E R A T I N G   A   G E N I E   I I I s    *
*    =====================================================================    *
* 									      *
*  	   C P / M   V e r . 3 . 0   H A R D   D I S K   S Y S T E M	      *
*          =========================================================          *
* 									      *
* 									      *
*   Thomas Holte			                         Version 1.0  *
* 									      *
******************************************************************************/
  
#include <stdio.h>

/* port addresses of Western Digital Winchester Disk Controller */
#define DATA      0x48		/* data register    */
#define ERR       0x49		/* error register   */
#define WPC       0x49		/* write precomp    */
#define SECNT     0x4A		/* sector count     */
#define SECNO     0x4B		/* sector number    */
#define CYLLO     0x4C		/* cylinder low     */
#define CYLHI     0x4D		/* cylinder high    */
#define SDH       0x4E		/* size/drive/head  */
#define COMND     0x4F		/* command register */
#define STATUS    0x4F		/* status register  */

/* commands of Western Digital Winchester Disk Controller */
#define REST	  0x16		/* restore	     */
#define FORMAT    0x50		/* format track      */

/* characteristics of BASF 6188 Winchester Disk */
#define SECLEN    1024		/* sector length       	    */   
#define SECSIZE   0x40		/* size bits for controller */
#define SECCOUNT     9		/* sector count        	    */
#define TRKCOUNT   612		/* track count         	    */
#define HEADCOUNT    4		/* surface count       	    */
#define SKEW         1    	/* interleaving factor 	    */
#define DIRSIZE    512		/* # of directory entries   */

/* disk parameter block of Winchester drive */
#define DPBA {72, 5, 31, 1, 1373, 511, 0xF0, 0, 0x8000, 1, 3, 7}


xmain ()
{
  	 char err;			/* error code			   */
  	 char secno;			/* current sector number	   */
  	 char surface;			/* current surface number	   */
  	 int  cylinder;			/* current cylinder number	   */
  	 int  track;			/* current track number		   */
  	 int  i, j;			/* loop counters		   */
	 char c;			/* temporary char storage	   */
  	 char buf1[SECLEN];		/* contains formatting data	   */
  	 char buf2[SECLEN];		/* contains worst case bit pattern */
  	 char buf3[SECLEN];		/* buffer for spare directory      */
  static char buf4[SECLEN] = 		/* copyright message		   */
    "MM/DD/YY  HH:MM:SS  formatted by INITW, written by Thomas Holte (c) 1985";

  struct {
	   unsigned track;		/* bad track 			   */
	   char     sector;		/* bad sector			   */
	 } *sd = buf3;			/* pointer to spare directory	   */

  	 int  sdc = 0;			/* bad sector counter 		   */
	
         FILE *CPM3_SYS;		/* file containing complete CP/M 3
				           system			   */ 
  	 char print[REC_SIZE];		/* CPM3.SYS print record	   */
  	 char *CPM3;			/* pointer to system buffer	   */
  	 char *tCPM3;			/* temporary pointer		   */
  	 int  size;			/* size of CPM3.SYS		   */
	 char *search ();		/* search a byte string 	   */

  /* disk parameter block */
  static struct {
	     	  int  SPT;
	     	  char BSH, BLM, EXM;
	     	  int  DSM, DRM;
	     	  char AL0, AL1;
	     	  int  CKS, OFF;
	     	  char PSH, PHM;
	        } DPB = DPBA, *pDPB;

  /* CPM3.SYS header record */
  struct header {
	   	  char res_top_page;	/* top page plus one, at which the
				           resident portion of CP/M 3 is to
				           be loaded top down 	 	    */
	   	  char res_length;	/* length in pages of the resident
				      	   portion of CP/M 3		    */
	   	  char bnk_top_page;    /* top page plus one, at which the
				           banked portion of CP/M 3 is to
				           be loaded top down		    */
	   	  char bnk_length;	/* length in pages of the banked 
				           portion of CP/M 3		    */
	   	  char *entry;		/* address of CP/M 3 cold boot
				      	   entry point			    */
	   	  char filler[122];	
	        } HEADER;


  /* get time & date */
  movmem (date(),  buf4    , 8);
  movmem (time(), &buf4[10], 8);

  printf ("\nInitialization of a CP/M Ver 3 Hard Disk System\n\n");

  printf ("Configuration table:\n");
  printf ("Drive A: 5.4 MBytes Winchester\n");
  printf ("Drive B: 800 KBytes mini floppy\n");     
  printf ("Drive C: 800 KBytes mini floppy\n");     

  /* restore drive */
  restore (); 

  /* try to read second sector */
  if (!system(16, 0x10, 1, buf2, 0) && streq(&buf2[20], &buf4[20]))
  {
    printf ("\nDisk already initialized\n");
    printf ("Reply (C)ancel or (P)roceed\n");
    do
    {
      printf ("\b");
      c = toupper(getchar());
    }
    while (c != 'C' && c != 'P');
    printf ("\n");
    if (c == 'C') abort (0);
  }

  /* initialize buffers */
  for (i = 0; i < SECCOUNT * 2; i++)
  {
    buf1[i++] = 0x00;
    buf1[i  ] = 0xFF;
  }
  for (i = 0; i < SECLEN; i += 3) buf2[i] = 0x6D;
  for (i = 1; i < SECLEN; i += 3) buf2[i] = 0xB6;
  for (i = 2; i < SECLEN; i += 3) buf2[i] = 0xDB;

  setmem (buf3, SECLEN, 0xFF);

  /* number sectors */
  for (i = secno = 0; i < SECCOUNT; i++)
  {
    j = 1 + 2 * secno;
    if (buf1[j] != 0xFF)
    {
      secno++;
      i--;
    }
    else
    {
      buf1[j] = i;
      if ((secno += SKEW) >= SECCOUNT) secno -= SECCOUNT;
    }
  }

  /* formatting */
  printf ("\nFormatting track    ");

  for (cylinder = 0; cylinder < TRKCOUNT / HEADCOUNT; cylinder++)
    for (surface = 0; surface < HEADCOUNT; surface++)
    {
      printf ("\b\b\b%03d", track = cylinder * HEADCOUNT + surface);

      format_track (surface, cylinder, buf1);

      /* write worst case bit pattern */	
      for (secno = 0; secno < SECCOUNT; secno++) 
	system (17, 0x10, secno, buf2, track);
    } 	  
	  
  /* verifying */
  printf ("\rVerifying track     \b");

  for (track = 0; track < TRKCOUNT; track++)
  {
    printf ("\b\b\b%03d", track);

    for (secno = 0; secno < SECCOUNT; secno++)
      if (system(16, 0x10, secno, buf2, track))
	if (track && sdc < 255 && sdc < SECLEN / sizeof *sd)	  
	{
	  sd[sdc].track  = track;
	  sd[sdc].sector = secno;
	  printf ("\n%d bad sectors detected", ++sdc);
	  printf ("\r\13Verifying track %03d", track);
	}
	else fatal_error ();
  } 

  /* write spare directory */
  if (system(17, 0x10, 0, buf3, 0) || system(17, 0x10, 1, buf4, 0))
    fatal_error ();

  /* initialize directory */
  setmem (buf2, SECLEN, 0xE5);

  printf ("\n\nInitializing directory\n");
   
  for (i = SECCOUNT; i < DIRSIZE / 4 / (SECLEN / REC_SIZE) + SECCOUNT; i++)
  {
    track = i / SECCOUNT;
    secno = i % SECCOUNT;

    /* calc offset */
    for (j = 0;; j++) if (sd[j].track  > track) break; 
      		 else if (sd[j].track == track) if (sd[j].sector > secno)
						  break;

    track = (i + j) / SECCOUNT;
    secno = (i + j) % SECCOUNT;

    if (system(17, 0x10, secno, buf2, track)) fatal_error ();
  }


  /* read system */
  puts ("\nCopying system\n");
  if ((CPM3_SYS = open("CPM3HD.SYS", 0)) == ERROR)
  {
    puts  ("\nCan't open CPM3HD.SYS\n");
    abort (1);
  }

  /* read header record and print record */
  read (CPM3_SYS, &HEADER, REC_SIZE);
  read (CPM3_SYS, print  , REC_SIZE);
  
  /* get memory for CPM3.SYS data */
  if (!(CPM3 = alloc(size = (HEADER.res_length + HEADER.bnk_length) * 0x100)))
  {
    puts  ("\nOut of memory\n");
    abort (1);
  }

  /* read system in reversed order */
  for (tCPM3 = CPM3 + size - REC_SIZE; tCPM3 >= CPM3; tCPM3 -= REC_SIZE)
    read (CPM3_SYS, tCPM3, REC_SIZE);

  close (CPM3_SYS);

  /* search disk parameter block of drive A: */
  if (!(pDPB = search(&DPB, CPM3, sizeof *pDPB, size)))
  {
    puts  ("\nSynchronization error\n");
    abort (1);
  }

  /* set maximum block count */
  pDPB->DSM = (long)(SECCOUNT * (TRKCOUNT - pDPB->OFF) - sdc) 
	    * (SECLEN / REC_SIZE) / (pDPB->BLM + 1) - 1;

  /* write system */
  if ((CPM3_SYS = creat("C:CPM3.SYS", 1)) == ERROR)
  {
    puts  ("\nCan't create C:CPM3.SYS\n");
    abort (1);
  }

  /* write header record and print record */
  write (CPM3_SYS, &HEADER, REC_SIZE);
  write (CPM3_SYS, print  , REC_SIZE);
  
  /* write system in reversed order */
  for (tCPM3 = CPM3 + size - REC_SIZE; tCPM3 >= CPM3; tCPM3 -= REC_SIZE)
    write (CPM3_SYS, tCPM3, REC_SIZE);

  close (CPM3_SYS);


  /* copy CCP.COM */
  if ((CPM3_SYS = open("CCP.COM", 0)) == ERROR)
  {
    puts  ("\nCan't open CCP.COM\n");
    abort (1);
  }
  i = read(CPM3_SYS, CPM3, 0x1000);
  close (CPM3_SYS);

  if ((CPM3_SYS = creat("C:CCP.COM", 0)) == ERROR)
  {
    puts  ("\nCan't create C:CCP.COM\n");
    abort (1);
  }
  write(CPM3_SYS, CPM3, i);
  close (CPM3_SYS);
}

 
static restore ()
{
  uptask (0    , 0, 0  );
  outp   (COMND, REST  );

  while (inp(STATUS) & 0x80);
}


static format_track (surface, cylinder, buffer)
  char surface, *buffer;
  int cylinder;
{
  register int i;

  uptask (surface, cylinder,  0);
  outp   (SECNT  , SECCOUNT    );
  outp   (COMND  , FORMAT      );

  for (i = 0; i < SECLEN; i++) outp (DATA, *buffer++);

  while (inp(STATUS) & 0x80);
}


static uptask (surface, cylinder, sector)
  char surface, sector;
  int cylinder;
{
  outp (WPC  , 16     		       );
  outp (SECNO, sector		       );
  outp (CYLHI, cylinder >> 8           );
  outp (CYLLO, cylinder                );
  outp (SDH  , 0x80 + SECSIZE + surface);
}


static char *search (pa, pb, na, nb)
  char *pa, *pb;
  unsigned na, nb;
{
  char *a, *b;
  unsigned i;

  while (nb--)
  {
    if (*pa == *pb++)
    {
      a = pa;
      b = pb;
      for (i = 1; i < na; i++) if (*++a != *b++) goto endwhile;
      return --pb;
    }	
    endwhile:;
  }
  return NULL;
}


static fatal_error ()
{
  printf ("\nWINCHESTER DISK DRIVE FAULT\n");
  abort  (1);
}
