/******************************************************************************
*  F K E Y  *  U T I L S 0 0 5  *  T h o m a s   H o l t e  *   8 5 0 1 1 3   *
*******************************************************************************
*                                                                             *
*        F U N C T I O N   K E Y   P R O G R A M M E R   F O R   T H E        *
*        =============================================================        *
*                                                                             *
*         G E N I E   I I I   M I C R O C O M P U T E R   S Y S T E M         *
*         ===========================================================         *
*									      *
*		     W I T H   G E N I E P L U S   C A R D		      *
*		     =====================================		      *
*                                                                             *
*                                                                             *
*   Thomas Holte                                                 Version 1.0  *
*                                                                             *
******************************************************************************/

#include <stdio.h>

#define NAK      0x15

#define SEC_SIZE 512

xmain ()
{
  extern char zbuf[];			/* menu buffer		       */
  extern int  wtab[][4];		/* window parameters	       */

  char SYSTAB[3 * SEC_SIZE];		/* table of system constants   */
  char drive;				/* current drive	       */
  char type;				/* drive type		       */
  char *dmaadr;				/* current DMA address	       */
  int  first;				/* first sector		       */
  int  last;				/* last  sector		       */
  int  i, j, k;				/* loop counters	       */
  int  index;				/* menu buffer index	       */
  char key;				/* last input key	       */
  int  option;				/* current task number         */ 
  BOOL control;				/* marker for control sequence */
  char *version = 0xFFFF;		/* place of version # in BIOS  */

  /* extended disk parameter header */
  struct {
	   char (*_WRITE) ();		/* addr of sector WRITE */
	   char (*_READ ) (); 		/* addr of sector READ  */
	   char (*LOGIN ) ();		/* addr of disk   LOGIN */
	   char (*INIT  ) ();		/* addr of disk   INIT  */
	   char unit;			/* physical unit number */
	   char type;			/* drive type		*/
	   char *XLT;			/* translate vector	*/
	   char scratch[9];		/* scratch area		*/
	   char MF;			/* media flag		*/
	   char *DPB;			/* disk parameter block */
	   char *CSV;			/* check vector		*/
	   char *ALV;			/* alloc vector		*/
	   char **DIRBCB;		/* dir BCB  header  	*/
	   char **DTABCB;		/* data BCB header	*/
	   char *HASH;			/* hashing table	*/
	   char HBANK;			/* hash bank		*/
         } *(*DTBL)[16],		/* drive table		*/
	   *XDPH;

  struct {
           char length, string[80];
         } *fkeys;

  control = FALSE;

  /* get current drive */
  drive = bdos(25, 0);

  /* get drive table */
  DTBL = bios(DRVTBL, 0, 0, 0);

  /* search for first floppy disk */
  for (i = 0;; i++)
  {
    XDPH = (char *)(*DTBL)[i] - 10;
    if (*version) system (15, 1, 1, &XDPH->type, &type);/*    banked version */
    else type = XDPH->type;				/* nonbanked version */

    if (!type) break;    
  }

  /* read system */
  bios (SELDSK, i, 0, 0);
  bios (HOME  , 0, 0, 0);
  bios (SETTRK, 0, 0, 0);
  dmaadr = SYSTAB;
  if (*version) 
  {
    first = 16;			/* CP/M 3a with Genieplus Card */
    last  = 18;
    fkeys = &SYSTAB[0x04C];
  }
  else
  {
    first =  8;			/* CP/M 3a  		       */
    last  = 10;
    fkeys = &SYSTAB[0x14C];
  }
  for (i = first; i <= last; i++)
  {
        bios (SETSEC, i     , 0, 0);
        bios (SETDMA, dmaadr, 0, 0);
    if (bios (READ  ,      0, 0, 0)) xabort (1, drive);
    dmaadr += SEC_SIZE;
  }

  /* move fkeys into menu buffer */
  for (i = 0; i < 13; i++)
  {
    k     = 0;
    index = 984 + i * 69;               /* calc buffer index */

    for (j = 0; j < fkeys[i].length; j++)
      if (!fkeys[i].string[j])
      {
        if (k < 69) zbuf[index + k++] = ' ';    /* convert NULL to space */
      }
      else
        if (fkeys[i].string[j] < ' ')        /* convert controls */
        {
          if (k < 68)
          {
            zbuf[index + k++] = '^';
            zbuf[index + k++] = fkeys[i].string[j] + '@';
          }
        }
        else
          if (k < 69)
            zbuf[index + k++] =
              fkeys[i].string[j] == ' ' ? '_' : fkeys[i].string[j];

    for (; k < 69; k++) zbuf[index + k] = ' ';
  }

  /* turn on graphics mode */
  outp (0xF5, 0);

  /* get parameters loop */
  for (i = 0;; i++)
  {
    index  = wtab[i][3] >>  4;
    option = wtab[i][3] & 0xF;

    key = window(wtab[i][0], wtab[i][1], wtab[i][2], &zbuf[index]);

    /* check ESC function */
    if (key == NAK)
    {
      puts   ("\33=7 \n\n");
      xabort (0, drive);
    }

    /* check options */
    if (option)
    {
      switch (toupper(zbuf[index]))
      {
        case 'Y': break;
        case 'N': i--;
        default : i--;
                  continue;
      }
      break;
    }
  }

  /* move fkeys into system buffer */
  for (i = 0; i < 13; i++)
  {
    k     = 0;
    index = 984 + i * 69;               /* calc buffer index */

    for (j = 0; j < 69; j++)
      if (control)
      {
        fkeys[i].string[k++] = zbuf[index + j] & 0x1F;
        control              = FALSE;
      }
      else
      {
	switch (zbuf[index + j])
	{
	  case ' ': break;
	  case '^': control = TRUE;
		    continue;
	  case '_': fkeys[i].string[k++] = ' ';
		    continue;
	  default : fkeys[i].string[k++] = zbuf[index + j];
		    continue;
	}
	break;
      }

    for (; k < 69; k++) fkeys[i].string[k] = 0;

    k = 69;
    while (k-- && !fkeys[i].string[k]);
    fkeys[i].length = ++k ? k : ++k;
  }

  puts ("\33=7 \n\n");

  /* write SYSTAB */
  dmaadr = SYSTAB;
  for (i = first; i <= last; i++)
  {
        bios (SETSEC, i     , 0, 0);
        bios (SETDMA, dmaadr, 0, 0);
    if (bios (WRITE , i     , 0, 0)) xabort (1, drive);
    dmaadr += SEC_SIZE;
  }

  /* select current disk */
  bios (SELDSK, drive, 0, 0);

  puts ("Press <RESET> to activate programmed function keys\n");
}


static xabort (mode, drive)
  char mode, drive;
{
  bios  (SELDSK, drive, 0, 0);
  abort (mode);
}
