/******************************************************************************
*  C O N F I G  *  U T I L S 0 0 3  *  T h o m a s   H o l t e  * 8 4 1 2 1 5 *
*******************************************************************************
*									      *
*  S Y S T E M   C O N F I G U R A T O R   F O R   T H E   G E N I E   I I I  *
*  =========================================================================  *
*									      *
*		    M I C R O C O M P U T E R   S Y S T E M		      *
*		    =======================================		      *
*									      *
*									      *
*  Version 2.0							Thomas Holte  *
*									      *
******************************************************************************/

#include <stdio.h>

/* ASCII control codes */
#define NUL	  0x00		/* null			     */	
#define SOH	  0x01		/* start of heading	     */
#define STX	  0x02		/* start of text	     */
#define ETX	  0x03		/* end of text		     */
#define EOT	  0x04		/* end of transmission	     */
#define ENQ       0x05		/* enquiry		     */
#define ACK	  0x06		/* acknowledge		     */
#define BEL	  0x07		/* bell			     */
#define BS        0x08		/* backspace		     */
#define HT	  0x09		/* horizontal tabulation     */ 	
#define LF	  0x0A		/* line feed		     */	
#define VT	  0x0B		/* vertical tabulation	     */
#define FF	  0x0C		/* form feed		     */
#define CR	  0x0D		/* carriage return	     */
#define SO	  0x0E		/* shift out		     */
#define SI	  0x0F		/* shift in		     */
#define DLE	  0x10		/* data link escape	     */
#define DC1	  0x11		/* device control 1	     */
#define DC2	  0x12		/* device control 2	     */
#define DC3	  0x13		/* device control 3	     */
#define DC4	  0x14		/* device control 4	     */
#define NAK       0x15		/* negative acknowledge	     */
#define SYN	  0x16		/* synchronous idle	     */
#define ETB	  0x17		/* end of transmission block */
#define CAN	  0x18		/* cancel		     */
#define EM	  0x19		/* end of medium	     */	
#define SUB	  0x1A		/* substitute		     */
#define ESC	  0x1B		/* escape		     */
#define FS	  0x1C		/* file separator	     */
#define GS	  0x1D		/* group separator	     */
#define RS	  0x1E		/* record separator	     */

#define WRALL     0		/* write to allocated    */
#define WRDIR     1		/* write to directory    */
#define WRUAL     2		/* write to unallocated  */

#define BIOS_BASE 0xF400	/* base address of CBIOS */
#define VERSION   1   		/* legal version no.     */


/* disk parameter block */
struct dpb {
	     int  SPT;
	     char BSH, BLM, EXM;
	     int  DSM, DRM;
	     char AL0, AL1;
	     int  CKS, OFF;
	   };

/* extended disk parameter header */
struct xdph {
	      char (*write) ();		/* addr of sector WRITE */
	      char (*read) (); 		/* addr of sector READ  */
	      char blksiz;		/* CP/M sectors/block   */
	      int  cpmspt;		/* CP/M sectors/track   */
	      char secmsk;		/* sector mask	    	*/
	      char secshf;		/* log2(hstblk)		*/
	      char type;		/* drive type		*/
	      char unit;		/* physical unit number */
	      int  base;		/* base track		*/
	      char *XLT;		/* translate vector	*/
	      int  scratch[3];		/* scratch area		*/
	      char *DIRBUF;		/* directory buffer	*/
	      struct dpb *DPB;		/* disk parameter block */
	      char *CSV;		/* check vector		*/
	      char *ALV;		/* alloc vector		*/
	    };


xmain ()
{
  extern char zbuf[];
  extern wtab[][5];

  char CBIOS[0xC00], *dmaadr, errno, first, *german, key, last, *NBOARD,
       SYSTAB[0x700], *version, *vidpar, *WBOARD;	
  int  btab, comma, i, index, int2, j, k, option;
  long convert (), int4;

  struct dpb  *DPB, *DPBp, *DPBC;
  struct xdph *(*DTBL)[16], *XDPH, *XDPHp, *XDPHC;

  struct {
	   char bits;
	   int  divisor;
	 } *RS232C;
  struct {
	   char td1, td2, ilf, spt, tc, curtrk;
	 } *DCT, *DCTp;

  /* layout for old keyboard */
  static char oldkeys[] = {']', '}' , GS , 'a' , 'A' , SOH, 'b', 'B', STX,
			   'c', 'C' , ETX, 'd' , 'D' , EOT, 'e', 'E', ENQ,
			   'f', 'F' , ACK, 'g' , 'G' , BEL, 'h', 'H', BS ,
			   'i', 'I' , HT , 'j' , 'J' , LF , 'k', 'K', VT ,
			   'l', 'L' , FF , 'm' , 'M' , CR , 'n', 'N', SO ,
			   'o', 'O' , SI , 'p' , 'P' , DLE, 'q', 'Q', DC1,
			   'r', 'R' , DC2, 's' , 'S' , DC3, 't', 'T', DC4,
			   'u', 'U' , NAK, 'v' , 'V' , SYN, 'w', 'W', ETB,
			   'x', 'X' , CAN, 'z' , 'Z' , SUB, 'y', 'Y', EM ,
			   ';', '+' , 0  , '[' , '{' , ESC, ':', '*', 0  ,
			   '@', '`' , NUL, 0   , 0   , 0  , '0', '_', 0  ,
			   '1', '!' , 0  , '2' , '\"', 0  , '3', '#', 0  ,
			   '4', '$' , 0  , '5' , '%' , 0  , '6', '&', 0  ,
			   '7', '\'', 0  , '8' , '(' , 0  , '9', ')', 0  ,
			   '^', '~' , RS , '\\', '|' , FS};

  /* layout for new keyboard */
  static char newkeys[] = {'@', '`' , NUL, 'a' , 'A' , SOH, 'b', 'B', STX,
			   'c', 'C' , ETX, 'd' , 'D' , EOT, 'e', 'E', ENQ,
			   'f', 'F' , ACK, 'g' , 'G' , BEL, 'h', 'H', BS ,
			   'i', 'I' , HT , 'j' , 'J' , LF , 'k', 'K', VT ,
			   'l', 'L' , FF , 'm' , 'M' , CR , 'n', 'N', SO ,
			   'o', 'O' , SI , 'p' , 'P' , DLE, 'q', 'Q', DC1,
			   'r', 'R' , DC2, 's' , 'S' , DC3, 't', 'T', DC4,
			   'u', 'U' , NAK, 'v' , 'V' , SYN, 'w', 'W', ETB,
			   'x', 'X' , CAN, 'y' , 'Y' , EM , 'z', 'Z', SUB,
			   '[', '{' , ESC, '\\', '|' , FS , ']', '}', GS ,
			   '^', '~' , RS , '_' , '^' , RS , '0', '0', 0  ,
			   '1', '!' , 0  , '2' , '\"', 0  , '3', '#', 0  ,
			   '4', '$' , 0  , '5' , '%' , 0  , '6', '&', 0  ,
			   '7', '\'', 0  , '8' , '(' , 0  , '9', ')', 0  ,
			   ':', '*' , 0  , ';' , '+' , 0};


  /* search for first floppy disk */
  for (i = 0;; i++) if (!(XDPH = bios(SELDSK, i, 0) - 13)->type) break;

  /* read SYSTAB */
  bios (HOME  , 0, 0);
  bios (SETTRK, 0, 0);
  dmaadr = SYSTAB;
  for (i = 30; i < 44; i++)
  {
    bios (SETSEC,      i, 0);
    bios (SETDMA, dmaadr, 0);
    if (errno = bios(READ, 0, 0)) errmsg (errno);
    dmaadr += 128;
  }

  /* read CBIOS */
  bios (SETTRK, 1, 0);
  dmaadr = CBIOS;
  for (i = 8; i < 32; i++)
  {
    bios (SETSEC,      i, 0);
    bios (SETDMA, dmaadr, 0);
    if (errno = bios(READ, 0, 0)) errmsg (errno);
    dmaadr += 128;
  }

  /* initialize structure pointers */
  DTBL    = &CBIOS [0xA4E];
  XDPH    = (char *)(*DTBL)[ 0] - 13 - BIOS_BASE + (unsigned)CBIOS;
  XDPHC   = (char *)(*DTBL)[12] - 13 - BIOS_BASE + (unsigned)CBIOS;
  DPB     = (char *)XDPH ->DPB	     - BIOS_BASE + (unsigned)CBIOS;
  DPBC    = (char *)XDPHC->DPB       - BIOS_BASE + (unsigned)CBIOS;
  version = &CBIOS [0xBFF];
  NBOARD  = &SYSTAB[0x00A];
  WBOARD  = &SYSTAB[0x112];
  DCT     = &SYSTAB[0x6D1];

  index   = *(int *)&CBIOS[0x001]    - BIOS_BASE;
  vidpar  = &CBIOS [index +  2];	/* video parameter table   */
  german  = &CBIOS [index + 18];	/* switch bit for char set */
  RS232C  = &CBIOS [index + 19];

  /* legal version no. ? */
  if (*version != VERSION)
  {
    puts  ("\nFALSCHE CP/M VERSION\n\n");
    abort (1);
  }

  /* get floppy drive count */
  for (i = 0;; i++)
    if (XDPHp = (*DTBL)[i])
      if (!((struct xdph *)
	((char *)XDPHp - 13 - BIOS_BASE + (unsigned)CBIOS))->type)
      {
	first = i;
	break;
      }
  for (;; i++) if (!(XDPHp = (*DTBL)[i]))
	       {	
		 last = --i;
		 break;
	       }	

  /* switch on German character set */
  puts ("\33G");	

  /* turn on graphics mode */
  outp (0xF5, 0);

  /* get parameters loop */
  for (i = 0;; i++)
  {
    index  = wtab[i][3];
    option = wtab[i][4] >> 8;
    btab   = wtab[i][4] & 0xFF;

    key = window(wtab[i][0], wtab[i][1], wtab[i][2], &zbuf[index]);

    /* check special keys */
    switch (key)
    {
      case ENQ:
      case BS : i -= btab + 1;
		continue;
      case NAK: puts ("\33=7 \n\n");
		abort (0);
    }

    /* check options */
    switch (option)
    {
      /* ASCII --> binary --> ASCII */
      case  1: int2 = int4 = convert(0x10, int4, 0,
				     wtab[i][2] - wtab[i][1] + 1,
				     &zbuf[index]);
	       break;

      /* get control code */	
      case  2: switch (int2)
	       {
		 /* system parameters */
		 case 1 : /* calc size of additional RAM */
			  switch (DPBC->DSM)
			  {
			    case  31: int4 =  64L;
			 	      break;
			    case  95: int4 = 128L;
				      break;
			    case 159: int4 = 192L;
				      break;
			    case 223: int4 = 256L;
				      break;
			    case 143: int4 = 320L;
				      break;
			    case 175: int4 = 384L;
			  }
			  convert (1, int4, 0, 3, &zbuf[1066]);

			  /* get cursor character */
			  zbuf[1119] = vidpar[10] & 0x1F ? 'U' : 'B';

			  /* get blink rate */
			  zbuf[1172] = vidpar[10] & 0x60 ? 'J' : 'N';

			  /* get keyboard type */
			  zbuf[1225] = *NBOARD == '@' ? 'J' : 'N';

			  /* get switch bit for char set */
			  zbuf[1278] = *german == 'G' ? 'J' : 'N';

			  /* get drive count */
			  zbuf[1331] = last - first + '1';
			  break;

		 /* floppy disk drives */
		 case 2 : zbuf[2310] = first + 'B';
			  zbuf[2314] = last  + 'A';
			  i += 33;
			  break;

		 /* RS-232-C parameters */
		 case 3 : for (j = k = 0; j < 3; j++, k += 264)
			  {
			    /* get no. of data bits */
			    zbuf[1514 + k] = (RS232C[j].bits & 3) + '5';
			   
			    /* get no. of stop bits */
			    zbuf[1558 + k] = (RS232C[j].bits >> 2 & 1) + '1';

			    /* get parity */
			    if (RS232C[j].bits & 8)
			      zbuf[1602 + k] =
			        RS232C[j].bits & 0x10 ? 'G' : 'U';
			    else zbuf[1602 + k] = 'K';

			    /* get baud rate */
			    comma = 0;	/* reset digit count of fraction */
			    switch (RS232C[j].divisor)
			    {
			      case    5: int4  = 38400L;
			 		 break;
			      case   10: int4  = 19200L;
					 break;
			      case   20: int4  =  9600L;
					 break;
			      case   27: int4  =  7200L;
					 break;
			      case   40: int4  =  4800L;
					 break;
			      case   53: int4  =  3600L;
					 break;
			      case   80: int4  =  2400L;
					 break;
			      case   96: int4  =  2000L;
					 break;
			      case  107: int4  =  1800L;
					 break;
			      case  160: int4  =  1200L;
					 break;
			      case  320: int4  =   600L;
					 break;
			      case  640: int4  =   300L;
					 break;
			      case 1280: int4  =   150L;
					 break;
			      case 1428: int4  =  1345L;
					 comma =     1 ;
					 break;
			      case 1745: int4  =   110L;
					 break;
			      case 2560: int4  =    75L;
					 break;
			      case 3840: int4  =    50L;
					 break;
			      default  : int4  =     0L;
			    }
			    convert (1, int4, comma, 5, &zbuf[1646 + k]);
			  }
			  i += 10;
			  break;

		 /* store system and exit program */
		 case 4 : puts ("\33=7 \n\n");

  			  /* write CBIOS */
 			  dmaadr = CBIOS;
 			  for (j = 8; j < 32; j++)
 			  {
   			    bios (SETSEC,      j, 0);
 			    bios (SETDMA, dmaadr, 0);
 			    if (errno = bios(WRITE, WRUAL, 0)) errmsg (errno);
 			    dmaadr += 128;
 			  }

			  /* write SYSTAB */			
 			  bios (SETTRK, 0, 0);
 			  dmaadr = SYSTAB;
 			  for (j = 30; j < 44; j++)
 			  {
 			    bios (SETSEC,      j, 0);
 			    bios (SETDMA, dmaadr, 0);
 			    if (errno =
				bios(WRITE, j == 43 ? WRDIR : WRALL, 0))
			      errmsg (errno);
 			    dmaadr += 128;
 			  }

			  puts (
        "DR]CKEN SIE <RESET>, UM DAS NEUKONFIGURIERTE SYSTEM ZU AKTIVIEREN\n");
			  return;

		 /* illegal entry */
		 default: i -= 2;
	       }
	       break;

      case  3: /* check size of additional RAM */
	       switch (int2)
	       {
		 case  64: XDPHC->blksiz =   8;
			   DPBC->BSH     =   3;
			   DPBC->BLM     =   7;
			   DPBC->EXM     =   0;
			   DPBC->DSM     =  31;
			   DPBC->DRM     =  31;
			   break;

		 case 128: XDPHC->blksiz =   8;
			   DPBC->BSH     =   3;
			   DPBC->BLM     =   7;
			   DPBC->EXM     =   0;
			   DPBC->DSM     =  95;
			   DPBC->DRM     =  31;
			   break;
	
		 case 192: XDPHC->blksiz =   8;
			   DPBC->BSH     =   3;
			   DPBC->BLM     =   7;
			   DPBC->EXM     =   0;
			   DPBC->DSM     = 159;
			   DPBC->DRM     =  31;
			   break;
	
		 case 256: XDPHC->blksiz =   8;
			   DPBC->BSH     =   3;
			   DPBC->BLM     =   7;
			   DPBC->EXM     =   0;
			   DPBC->DSM     = 223;
			   DPBC->DRM     =  31;
			   break;
	
		 case 320: XDPHC->blksiz =  16;
			   DPBC->BSH     =   4;
			   DPBC->BLM     =  15;
			   DPBC->EXM     =   1;
			   DPBC->DSM     = 143;
			   DPBC->DRM     =  63;
			   break;
	
		 case 384: XDPHC->blksiz =  16;
			   DPBC->BSH     =   4;
			   DPBC->BLM     =  15;
			   DPBC->EXM     =   1;
			   DPBC->DSM     = 175;
			   DPBC->DRM     =  63;
			   break;
	
		 default: i -= 2;
	       }
	       break;

      /* check cursor character */
      case  4: switch (toupper(zbuf[index]))
	       {
		 case 'B': vidpar[10] =  0;
			   break;
		 case 'U': vidpar[10] = 11;
			   break;
		 default : i--;
	       }
	       break;

      /* blinking cursor ? */
      case  5: switch (toupper(zbuf[index]))
	       {
		 case 'N': vidpar[10] &= 0x1F;
			   break;
		 case 'J': vidpar[10] |= 0x40;
			   break;
		 default : i--;
	       }
	       break;

      /* new keyboard ? */
      case  6: switch (toupper(zbuf[index]))
	       {
		 case 'N': movmem (oldkeys, NBOARD, sizeof oldkeys);
			   movmem (oldkeys, WBOARD, sizeof oldkeys);
			   break;
		 case 'J': movmem (newkeys, NBOARD, sizeof newkeys);
			   movmem (newkeys, WBOARD, sizeof newkeys);
			   break;
		 default : i--;
	       }		
	       break;

      /* check character set */
      case  7: switch (toupper(zbuf[index]))
	       {
		 case 'N': *german = 'A';
			   break;
		 case 'J': *german = 'G';
	                   break;
		 default : i--;
	       }
	       break;

      /* check drive count */
      case  8: if (int2 >= 2 && int2 <= 4)
	       {	
		 for (j = first + 2; j < first + int2; j++)
		   (*DTBL)[j] = (char *)&XDPH[j] + 13 - CBIOS + BIOS_BASE;
		 for (; j < first + 4; j ++) (*DTBL)[j] = 0;
		 last = first + int2 - 1;
		 i   -= 12;
	       }	
	       i -= 2;
	       break;

      /* check no. of data bits */
      case  9: j = (i - 17) / 7;
	       if (int2 >= 5 && int2 <= 8) RS232C[j].bits = int2 - 5;
	       else i -= 2;
	       break;

      /* check no. of stop bits */
      case 10: j = (i - 19) / 7;
	       if (int2 == 1 || int2 == 2)
		 RS232C[j].bits = RS232C[j].bits & 3 | (int2 - 1) << 2;
	       else i -= 2;
	       break;

      /* check parity */
      case 11: j = (i - 20) / 7;
	       switch (toupper(zbuf[index]))
	       {
		 case 'G': RS232C[j].bits |= 0x18;
			   break;
		 case 'K': RS232C[j].bits &= 7;
			   break;
		 case 'U': RS232C[j].bits |= 8;
			   break;
		 default : i--;
	       }
	       break;

      /* check baud rate */
      case 12: j = (i - 21) / 7;
	       int2 = (int4 = convert(-1, int4, 1, wtab[i][2] - wtab[i][1] + 1,
			      	      &zbuf[index])) / 10L;

	       /* special case: baud rate = 134.5 */
	       if (int4 == 1345L)
	       {
		 convert(1, int4, 1, wtab[i][2] - wtab[i][1] + 1,
			 &zbuf[index]);
		 RS232C[j].divisor = 1428;
		 break;
	       }

	       switch (int2)
	       {	
	         case     50: RS232C[j].divisor = 3840;
			      break;
	         case     75: RS232C[j].divisor = 2560;
			      break;
	         case    110: RS232C[j].divisor = 1745;
			      break;
	         case    150: RS232C[j].divisor = 1280;
			      break;
	         case    300: RS232C[j].divisor =  640;
			      break;
	         case    600: RS232C[j].divisor =  320;
			      break;
	         case   1200: RS232C[j].divisor =  160;
			      break;
	         case   1800: RS232C[j].divisor =  107;
			      break;
	         case   2000: RS232C[j].divisor =   96;
			      break;
	         case   2400: RS232C[j].divisor =   80;
			      break;
	         case   3600: RS232C[j].divisor =   53;
			      break;
	         case   4800: RS232C[j].divisor =   40;
			      break;
	         case   7200: RS232C[j].divisor =   27;
			      break;
	         case   9600: RS232C[j].divisor =   20;
			      break;
	         case  19200: RS232C[j].divisor =   10;
			      break;
	         case -27136: RS232C[j].divisor =    5;   /* 38400 */
			      break;
	         default    : i--;
			      continue;
	       }
	       convert(1, (long)(unsigned)int2, 0, wtab[i][2] - wtab[i][1] + 1,
			 &zbuf[index]);
	       break;

      /* return to main menu */
      case 13: i -= 37;
	       break;

      /* get drive code */
      case 14: if ((j = toupper(zbuf[index]) - 'A') > first && j <= last)
	       {
   	         XDPHp = XDPH + j;
	         DPBp  = DPB  + j;
	         DCTp  = DCT  + j - first; 				 

		 /* get disk size */
		 if (DCTp->td1 & 0x80) zbuf[2417] = '8'; else zbuf[2417] = '5';

		 /* get no. of surfaces */
		 if (DCTp->td1 & 0x40) zbuf[2483] = 'D'; else zbuf[2483] = 'E';

		 /* get density */
		 if (DCTp->td1 & 0x20) zbuf[2549] = 'D'; else zbuf[2549] = 'E';
 
		 /* get density of first track */	      zbuf[2615] = 'E';
		 if (zbuf[2549] == 'D') if (DCTp->td1 & 0x10) zbuf[2615] = 'D';

		 /* get track count */
		 convert (0x11, (long)DCTp->tc, 0, 2, &zbuf[2681]);

		 /* no. of steps per track to track */
		 zbuf[2747] = (DCTp->td1 >> 2 & 1) + '1';

		 /* get track stepping rate */
		 switch (DCTp->td1 & 3)
		 {
		   case 0: int4 =  3L;
			   break;
		   case 1: int4 =  6L;
			   break;
		   case 2: int4 = 10L;
			   break;
		   case 3: int4 = 15L;
		 }
		 convert (0x11, int4, 0, 2, &zbuf[2813]);

		 /* get no. of sectors per track */
		 convert (0x11, (long)DCTp->spt, 0, 2, &zbuf[2879]);

		 /* get sector length */
		 k    = DCTp->td2 >> 6;
		 int4 = 128L;
		 for (j = 0; j < k; j++) int4 *= 2;
		 convert (0x11, int4, 0, 4, &zbuf[2945]);

		 /* get no. of first sector */
		 zbuf[3011] = (DCTp->td1 >> 3 & 1) + '0';

		 /* sector numbering continued on back side */
			 		   zbuf[3077] = 'N';
		 if (zbuf[2483] == 'D')
		   if (DCTp->td2 >> 5 & 1) zbuf[3077] = 'J';

		 /* get interleaving factor */
		 convert (0x11, (long)DCTp->ilf  	 , 0, 2, &zbuf[3143]);

		 /* get block size */
		 convert (0x11, (long)(XDPHp->blksiz / 8), 0, 2, &zbuf[3275]);

		 /* get dir size */
		 zbuf[3341] = DPBp->DRM / 32 + 1 + '0';

		 /* get no. of system tracks */
		 zbuf[3407] = DPBp->OFF + '0';
	       }
	       else i--;
	       break;
			
      /* check disk size */
      case 15: switch (int2)
	       {
		 case 5 : DCTp->td1 &= 0x7F;
			  break;
		 case 8 : DCTp->td1 |= 0x80;
			  break;
		 default: i -= 2;
	       }
	       break;

      /* check no. of surfaces */
      case 16: switch (toupper(zbuf[index]))
	       {
		 case 'D': DCTp->td1      |= 0x40;
			   wtab[i + 16][0] = 0x7F14;
			   wtab[i + 17][4] = (wtab[i + 17][4] & 0xFF00) + 1;
			   break;
		 case 'E': DCTp->td1      &= 0xBF;
			   zbuf[3077]      = 'N';
			   wtab[i + 16][0] = 3;
			   wtab[i + 17][4] = (wtab[i + 17][4] & 0xFF00) + 3;
			   break;
		 default : i--;
	       }
	       break;

      /* check density */
      case 17: switch (toupper(zbuf[index]))
	       {
	  	 case 'D': DCTp->td1 |= 0x20;
			   wtab[i + 3][4] = (wtab[i + 3][4] & 0xFF00) + 2;
			   break;
		 case 'E': DCTp->td1     &= 0xCF;
			   zbuf[2615]     = 'E';
			   wtab[i + 3][4] = (wtab[i + 3][4] & 0xFF00) + 3;
			   i++;
			   break;
		 default : i--;
	       }
	       break;
						
      /* check density of first track */
      case 18: switch (toupper(zbuf[index]))
	       {
		 case 'D': DCTp->td1 |= 0x10;
			   break;
		 case 'E': DCTp->td1 &= 0xEF;
			   break;
		 default : i--;
	       }
	       break;

      /* check track count */
      case 19: if (int2 > 0) DCTp->tc = int2; else i -= 2;
	       break;

      /* check no. of steps per track to track */
      case 20: if (int2 == 1 || int2 == 2)
		 DCTp->td1 = DCTp->td1 & 0xFB | (int2 - 1) << 2;
	       else i -= 2;
	       break;

      /* check track stepping rate */
      case 21: switch (int2)
	       {
		 case  3: DCTp->td1 = DCTp->td1 & 0xFC;
			  break;
		 case  6: DCTp->td1 = DCTp->td1 & 0xFC | 1;
			  break;
		 case 10: DCTp->td1 = DCTp->td1 & 0xFC | 2;
			  break;
		 case 15: DCTp->td1 = DCTp->td1        | 3;
			  break;
		 default: i -= 2;
	       }	
	       break;

      /* check no. of sectors per track */
      case 22: if (int2 > 0) DCTp->spt = int2; else i -= 2;
	       break;

      /* check physical sector length */
      case 23: switch (int2)
	       {
		 case  128: XDPHp->secshf = 0;
			    XDPHp->secmsk = 0;
			    XDPHp->cpmspt = DPBp->SPT = DCTp->spt;
			    DCTp->td2     = DCTp->td2 & 0x3F; 
			    break;
		 case  256: XDPHp->secshf = 1;
			    XDPHp->secmsk = 1;
			    XDPHp->cpmspt = DPBp->SPT = DCTp->spt * 2;
			    DCTp->td2     = DCTp->td2 & 0x3F | 0x40;
			    break;
		 case  512: XDPHp->secshf = 2;
			    XDPHp->secmsk = 3;
			    XDPHp->cpmspt = DPBp->SPT = DCTp->spt * 4;
			    DCTp->td2     = DCTp->td2 & 0x3F | 0x80;
			    break;
		 case 1024: XDPHp->secshf = 3;
			    XDPHp->secmsk = 7;
			    XDPHp->cpmspt = DPBp->SPT = DCTp->spt * 8;
			    DCTp->td2     = DCTp->td2 | 0xC0;
			    break;
		 default  : i -= 2;
	       }
	       break;

      /* check no. of first sector */
      case 24: if (!int2 || int2 == 1)
		 DCTp->td1 = DCTp->td1 & 0xF7 | int2 << 3;
	       else i -= 2;
	       break;

      /* sector numbering continued on back side ? */
      case 25: switch (toupper(zbuf[index]))
	       {
		 case 'N': DCTp->td2 &= 0xDF;
			   break;
		 case 'J': DCTp->td2 |= 0x20;
			   break;
		 default : i--;
	       }
	       break;

      /* check interleaving factor */
      case 26: DCTp->ilf = int2;
	       break;

      /* check block size */
      case 27: switch (int2)
	       {
		 case  1: XDPHp->blksiz =   8;
			  DPBp->BSH     =   3;
			  DPBp->BLM     =   7;
			  break;
		 case  2: XDPHp->blksiz =  16;
			  DPBp->BSH     =   4;
			  DPBp->BLM     =  15;
			  break;
		 case  4: XDPHp->blksiz =  32;
			  DPBp->BSH     =   5;
			  DPBp->BLM     =  31;
			  break;
		 case  8: XDPHp->blksiz =  64;
			  DPBp->BSH     =   6;
			  DPBp->BLM     =  63;
			  break;
		 case 16: XDPHp->blksiz = 128;
			  DPBp->BSH     =   7;
			  DPBp->BLM     = 127;
			  break;
		 default: i -= 2;
 	       }
	       break;

      /* check directory size */
      case 28: if (int2 > 0)
      	       {
		 DPBp->CKS = ((DPBp->DRM = int2 * 32 - 1) + 1) / 4;

		 /* calc. block count for directory */
		 j = XDPHp->blksiz / 8;
		 j = int2 / j + (int2 % j ? 1 : 0);
		 for (DPBp->AL0 = 0, k = 128; k && j; k /= 2, j--)
		   DPBp->AL0 += k;
		 for (DPBp->AL1 = 0, k = 128; k && j; k /= 2, j--)
		   DPBp->AL1 += k;
      	       }
      	       else i -= 2;
      	       break;

      /* check no. of system tracks */
      case 29: if (int2 >= 0)
		 if ((DPBp->DSM = (DCTp->tc - (DPBp->OFF = int2))
		      * XDPHp->cpmspt / XDPHp->blksiz - 1) <= 255)
		   switch (XDPHp->blksiz)
		   {
		     case   8: DPBp->EXM =  0;
			       break;
		     case  16: DPBp->EXM =  1;
			       break;
		     case  32: DPBp->EXM =  3;
			       break;
		     case  64: DPBp->EXM =  7;
			       break;
		     case 128: DPBp->EXM = 15;
			       break;
		   }
 		 else
		   switch (XDPHp->blksiz)
		   {
		     case   8: i -= 6;			/* error */
			       continue;
		     case  16: DPBp->EXM =  0;
			       break;
		     case  32: DPBp->EXM =  1;
			       break;
		     case  64: DPBp->EXM =  3;
			       break;
		     case 128: DPBp->EXM =  7;
			       break;
		   } 
	       else
	       { 	
		 i -= 2;
		 break;
	       }		
	
	       /* IBM 3740 format ? */	
	       if ((DCTp->td1 & 0xFC) == 0x88 && DCTp->spt == 26 &&	
		    DCTp->tc == 77) XDPHp->XLT = 0xFF84;
	       else XDPHp->XLT = 0;	
	       i -= 82;
    }
  }
}
		

errmsg (errno)
  char errno;
{
  switch (errno)
  {
    case 1: printf ("\nUNG]LTIGES LAUFWERK\n");
	    break;
    case 2: printf ("\nUNG]LTIGE SPUR\n");
	    break;
    case 3: printf ("\nUNG]LTIGER SEKTOR\n");
	    break;
    case 4: printf ("\nLAUFWERK NICHT BEREIT\n");
	    break;
    case 5: printf ("\nDISKETTE SCHREIBGESCH]TZT\n");
 	    break;
    case 6: printf ("\nLAUFWERKSFEHLER\n");
	    break;
    case 7: printf ("\nDATEN-RECORD NICHT GEFUNDEN\n");
	    break;
    case 8: printf ("\nCRC-FEHLER\n");
	    break;
    case 9: printf ("\nDATEN VERLOREN\n");
  }
  abort (1);
}
