/******************************************************************************
*  M 6 8 4 5  *  C P M S Y S 1 0  *  T h o m a s   H o l t e  *  8 4 1 0 0 1  *
*******************************************************************************
*                                                                             *
*  	A D J U S T M E N T   T O O L   F O R   T H E   M O T O R O L A	      *
*       ===============================================================       *
*                                                                             *
*  		  V I D E O   C O N T R O L L E R   M 6 8 4 5		      *
*                 ===========================================		      *
*									      *
*                                                                             *
*   Thomas Holte                                                 Version 1.0  *
*                                                                             *
******************************************************************************/

#include <stdio.h>

#define ETX    0x03
#define ENQ    0x05
#define CR     0x0D
#define DC2    0x12
#define NAK    0x15
#define CAN    0x18
#define ESC    0x1B

#define CRTREG 0xF6		/* CRT address register */
#define CRTCMD 0xF7		/* CRT command register */

#define WRDIR  1      		/* write to directory   */
#define WRUAL  2      		/* write to unallocated */


xmain ()
{
  extern char zbuf[];
  char CBIOS[0xD00], *dmaadr, errno, *vidpar;
  char *version = 0xFFFF;		/* place of version # in CBIOS */
  int BIOS_BASE, first, i, last, track;

  struct {
	   char (*write) ();		/* addr of sector WRITE */
	   char (*read) (); 		/* addr of sector READ  */
	   char blksiz;			/* CP/M sectors/block   */
	   int  cpmspt;			/* CP/M sectors/track   */
	   char secmsk;			/* sector mask	    	*/
	   char secshf;			/* log2(hstblk)		*/
	   char type;			/* drive type		*/
	   char unit;			/* physical unit number */
	   int  base;			/* base track		*/
	   char *XLT;			/* translate vector	*/
	   int  scratch[3];		/* scratch area		*/
	   char *DIRBUF;		/* directory buffer	*/
	   char *DPB;			/* disk parameter block */
	   char *CSV;		  	/* check vector		*/
	   char alv[2];			/* alloc vector		*/
  	 } *XDPH;	   


  /* search for first floppy disk */
  for (i = 0;; i++) if (!(XDPH = bios(SELDSK, i, 0) - 13)->type) break;

  switch (*version)
  {
    case 0: track     =  0;		/* CP/M 2.2d		      */ 
	    first     = 48;
	    last      = 71;
	    BIOS_BASE = 0xEC00;
	    break;

    case 1: track     =  1;		/* CP/M 2.2d + Genieplus card */
	    first     =  8;
	    last      = 31;
	    BIOS_BASE = 0xF400;
	    break;

    case 2: track     =  1;		/* CP/M 2.2d + 5MB Winchester */
	    first     =  8;
	    last      = 33;
	    BIOS_BASE = 0xF300;
  }	    

  /* read CBIOS */
  bios (HOME  ,     0, 0);
  bios (SETTRK, track, 0);
  dmaadr = CBIOS;
  for (i = first; i <= last; i++)
  {
    bios (SETSEC,      i, 0);
    bios (SETDMA, dmaadr, 0);
    if (errno = bios(READ, 0, 0)) errmsg (errno);
    dmaadr += 128;
  }

  i 	 = *(int *)&CBIOS[0x001] - BIOS_BASE;
  vidpar = &CBIOS[i + 2];		    /* video parameter table */

  /* turn on graphics mode */
  outp (0xF5, 0);

  window (0, 0, 2379,    0);		    	      /* clear screen	     */
  window (3, 0, 2379, zbuf);		    	      /* output menu	     */
  puts   ("\33E"); puts (&zbuf[1920]); puts ("\33D"); /* display status line */

  for (i = 0;;)
  {
    /* convert binary parameter to ASCII */
    convert (0x11, (long)vidpar[i], 0, 3, &zbuf[2342 + i * 3]);

    /* output parameter */
    window (3, 2103, 2140, &zbuf[2000 + i * 38]);

    /* read keyboard */
    for (;;)
    {
      switch (window(0x7F04, 2146, 2148, &zbuf[2342 + i * 3]))
      {
        case ETX: if (i < 8) i++;		/* next par         */
                  break;

        case ENQ: vidpar[i]--;			/* decrement par    */
		  conv:
		  convert (0x11, (long)vidpar[i], 0, 3, &zbuf[2342 + i * 3]);
		  goto outpar; 

        case CR : vidpar[i] = 
		    convert(0x10, (long)vidpar[i], 0, 3, &zbuf[2342 + i * 3]);
		  outpar:
		  outp    (CRTREG,        i );	/* select CRT reg   */
		  outp    (CRTCMD, vidpar[i]);	/* output CRT par   */
		  continue;

        case DC2: if (i) i--;                   	/* previous par     */
                  break;

        case NAK: puts  ("\33E\32\33D\33=7 \n\n");	/* abort program    */
		  abort (0);

        case CAN: vidpar[i]++;				/* increment par    */
		  goto conv;

	case ESC: goto store;

        default : continue;
      }
      break;
    }
  }

  /* write CBIOS */
  store:
  dmaadr = CBIOS;
  for (i = first; i <= last; i++)
  {
    bios (SETSEC,      i, 0);
    bios (SETDMA, dmaadr, 0);
    if (errno = bios(WRITE, i == last ? WRDIR : WRUAL, 0)) errmsg (errno);
    dmaadr += 128;
  }

  puts ("\33E\32\33D\33=7 \n\n");
}


errmsg (errno)
  char errno;
{
  switch (errno)
  {
    case 1: puts ("ILLEGAL DRIVE #\n");
            break;
    case 2: puts ("TRACK # TOO HIGH\n");
            break;
    case 3: puts ("SECTOR # TOO HIGH\n");
            break;
    case 4: puts ("DEVICE NOT AVAILABLE\n");
            break;
    case 5: puts ("WRITE PROTECTED DISKETTE\n");
            break;
    case 6: puts ("WRITE FAULT ON DISK DRIVE\n");
            break;
    case 7: puts ("DATA RECORD NOT FOUND\n");
            break;
    case 8: puts ("PARITY ERROR\n");
            break;
    case 9: puts ("LOST DATA\n");
  }
  abort (1);
}
