/******************************************************************************
*  W I N D O W  *  U L I B 0 0 3  *  T h o m a s   H o l t e  *  8 3 0 3 2 8  *
*******************************************************************************
*  									      *
*     R O U T I N E   F U E R   D I E   E I N -   B Z W .   A U S G A B E     *
*     ===================================================================     *
*                                                                             *
*            A U F   E I N E M   B I L D S C H I R M F E N S T E R            *
*            =====================================================	      *
*  									      *
*                            						      *
*  Version 3.0                                                  Thomas Holte  *
*  									      *
******************************************************************************/
    
char window (ctrl, anfang, ende, buffer)
  int ctrl, anfang, ende;
  char buffer[];

/*
Diese Routine legt ueber einen Teil des Bildschirms ein Fenster beliebiger
Groesse, von dem Daten eingelesen bzw. auf dem Daten ausgegeben werden koennen.
   Bei der Dateneingabe koennen alle Editierfunktionstasten benutzt werden.
Abgeschlossen wird dir Routine durch den Druck einer der Funktionstasten F3-F6
bzw. der Taste BREAK. Die Daten werden dann in den buffer uebertragen, und es
erfolgt die Rueckkehr ins aufrufende Programm.
Bedeutung der Uebergabeparameter:
ctrl   = 16 Bit langer Kontrollcode mit nachstehender Bedeutung:
	 Bits 15-8: Hexadezimaler ASCII-Code eines evt. auszugebenden
	  	    Promptzeichens. Sind diese Bits Null, wird das Blank als
		    Prompt benutzt.
	 Bit     5: Piepston:
		    0 = aus
		    1 = an
	 Bit     4: Uebertragungsmodus:
		    0 = Abbruch durch Druck einer Funktionstaste (normaler
		        Mode)
		    1 = Automatischer Abbruch bei Erreichen der letzten
		        Kursorposition
	 Bits  3-0: Steuercode:
		    0 = Loeschen des Fensters		  (Clear window)
		    1 = Loeschen des Fensters und Eingabe (Clear, input)
		    3 = Ausgabe auf dem Fenster	   	  (Output      )
		    4 = Editieren auf dem Fenster   	  (Edit        )
anfang = ZeilennummerSpaltennummer der ersten Zeichenposition des Fensters
							   (siehe Bild 1).
	 Fuer diese beiden Angaben gilt: 0 <= Zeilennummer  <= 23
					 0 <= Spaltennummer <= 79
	 Zeilennumer und Spaltennummer stehen hintereinander in einer int-
	 Variablen.
  ende = ZeilennummerSpaltennummer der letzten Spaltenposition des Fensters
							   (siehe Bild 1).
buffer = Feld, in das bzw. aus dem die Daten gelesen werden.

Als Funktionswert wird der ASCII-Code der abschliessenden Taste zurueckgegeben.


	|-------------------------------------------------------|
	|Anfang							|
	|							|
	|							|
	|		       W I N D O W			|
   	|			(Fenster)		        |
	|							|
	|							|
	|						    Ende|
	|-------------------------------------------------------|
				  Bild 1
*/

#define TRUE   1
#define FALSE  0

#define CONIN  3

#define ETX 0x03
#define BEL 0x07
#define BS  0x08
#define HT  0x09
#define LF  0x0A
#define VT  0x0B
#define FF  0x0C
#define CR  0x0D
#define DC2 0x12
#define CAN 0x18
#define DEL 0x7F

{
  char as, az, code, es, ez, flag, *init, ins, ls, lz, prompt, sanz, *setcur,
       zanz;	

  ins = FALSE;			/* Vorbesetzen des Insertflags */

  code   = 0;
  flag   = FALSE; 
  init   = "\33\14\33I \33J \33K \33L \36";
  setcur = "\33=  ";

  /* Berechnen des Promptzeichens */
  if ((prompt = ctrl >> 8) < ' ') prompt = ' ';

  if (ctrl & 0x20) putchar (BEL);	/* Ausgabe eines Piepstons */

  /* Pruefen, ob Flag fuer automatischen Abbruch gesetzt */
  if (ctrl & 0x10) flag = TRUE;

  /* Berechnen der ersten und letzten Zeile des Fensters */
  init[4] = (az = anfang / 100) + ' ';
  init[7] = (ez = ende   / 100) + ' ';

  /* Berechnen der ersten und letzten Spalte des Fensters */
  init[10] = (as = anfang % 100) + ' ';
  init[13] = (es = ende   % 100) + ' ';

  puts (init);

  sanz = (es -= as) + 1;		/* Berechnen der Spaltenanzahl */
  zanz = (ez -= az) + 1;		/* Berechnen der Zeilenanzahl  */

  switch (ctrl &= 7)
  {
    case 1: setmem (buffer, zanz * sanz, ' ');

    case 0: for (lz = 0; lz <= ez; lz++)
	    {
              for (ls = 0; ls <= es; ls++) putchar (prompt);
              if (lz < ez) putchar ('\n');
	    }
	    if (ctrl == 1) goto read;
	    break;

    case 3:
    case 4: for	(lz = 0; lz <= ez; lz++)
	    {
	      for (ls = 0; ls <= es; ls++) putchar (buffer[lz * sanz + ls]);
	      if (lz < ez) putchar ('\n');
	    }
	    if (ctrl == 3) break;

            read:
	    lz = ls = 0;
	    for (;;)
	    {
	      setcur[2] = lz + ' ';
	      setcur[3] = ls + ' ';
	      puts (setcur); puts ("\33\15");

	      /* Holen eines Zeichens von der Tastatur */
	      while (!(code = bdos(6, 0xFF)));
	      puts ("\33\14");

	      if (code < ' ' || code > 0x7F)
	      {
		ins = FALSE;
		switch (code)
		{
		  case ETX : lz = ez;		/* SHIFT + cursor up   */
			     continue;	

		  case BS  : if (ls > 0) ls--; else if (!lz) break;
			     continue;			/* cursor left */

		  case HT  : ls = es;		/* SHIFT + cursor right */
			     continue;

		  case LF  : if (lz == ez) break; 	/* cursor down */
			     lz++; 
			     continue;

		  case VT  : if (!lz) break;  		/* cursor up */
			     lz--;
			     continue;

		  case FF  : if (ls < es) ls++; else if (lz == ez) break;
			     continue;			/* cursor right */

		  case CR  : if (ez <= lz++) break;	/* NEW LINE */
			     ls = 0;
			     continue;

		  case DC2 : lz = 0;		/* SHIFT + cursor up   */
			     continue;

		  case CAN : ls = 0;		/* SHIFT + cursor left */
			     continue;

		  case 0x80: ins = TRUE;		/* ins mode */
		  	     continue;

		  case 0x81: if (lz < ez) movmem (&buffer[ lz      * sanz],
			     /* ins line */	  &buffer[(lz + 1) * sanz],
						  (ez - lz) * sanz);
			     puts ("\33V");
			     setmem (&buffer[lz * sanz], sanz, ' ');
			     for (ls = 0; ls <= es; ls++) putchar (prompt);
			     ls = 0;
			     continue;

		  case 0x85: if (ls < es) movmem (&buffer[lz * sanz + ls + 1],
			     /* del char */       &buffer[lz * sanz + ls    ],
			                          es - ls);
			     puts ("\33Q");
			     setcur[3] = es + ' ';
			     puts (setcur);
			     buffer[lz * sanz + es] = ' ';
			     putchar (prompt);
			     continue;

		  case 0x87: if (lz < ez) movmem (&buffer[(lz + 1) * sanz],
			     /* del line */       &buffer[ lz      * sanz],
				                  (ez - lz) * sanz);
			     puts ("\33W");
			     setcur[2] = ez + ' ';
			     setcur[3] =      ' ';
			     puts (setcur);
			     setmem (&buffer[ez * sanz], sanz, ' ');
			     for (ls = 0; ls <= es; ls++) putchar (prompt);
			     ls = 0;
			     continue;
		}
		break;
	      }

	      if (code == DEL)
	      {
		setcur[2] = setcur[3] = ' ';
		puts (setcur);
                setmem (buffer, zanz * sanz, ' ');
           	for (lz = 0; lz <= ez; lz++)
	        {
                  for (ls = 0; ls <= es; ls++) putchar (prompt);
                  if (lz < ez) putchar ('\n');
     	        }
	        lz = ls = 0;
	      }	
	      else
	      {
	        if (ins)
	        {
		  if (ls < es) movmem (&buffer[lz * sanz + ls    ],
		 		       &buffer[lz * sanz + ls + 1], es - ls);
		  puts ("\33P");
	        }
	        putchar (buffer[lz * sanz + ls] = code);
	        if (ls == es && lz == ez && flag) break;
	        if (++ls > es) ls = es;
	      }	
	    }
  }
  puts ("\36\33I \33J7\33K \33Lo\33\15");
  return code;
}
