/******************************************************************************
*  D A N A L  *  C P M S Y S 9  *  T h o m a s   H o l t e  *   8 4 1 0 1 8   *
*******************************************************************************
*  									      *
*        D I S K   A N A L Y Z E R   F O R   T H E   G E N I E   I I I        *
*        =============================================================        *
*                                                                             *
*            	    M I C R O C O M P U T E R   S Y S T E M		      *
*                   =======================================       	      *
*  									      *
*                            						      *
*  Version 1.0                                                  Thomas Holte  *
*  									      *
******************************************************************************/
    
#include <stdio.h>

#define DCTBASE 0x13D1		/* base of drive control blocks */

/* ASCII control codes */
#define ENQ 0x05		/* enquiry	        */	
#define BS  0x08		/* backspace 	        */
#define NAK 0x15		/* negative acknowledge */

char *dct;

xmain ()
{
  extern wtab[][4];
  extern char zbuf[];
  char address[100][4], DCT[6], drive, errno, first, key, last, side, track;
  char *version = 0xFFFF;		/* CP/M 2.2d version #  */
  int firstsec, i, index, int2, option, seccount, sector;
  
  struct {
	   char (*write) ();		/* addr of sector WRITE */
	   char (*read) (); 		/* addr of sector READ  */
	   char blksiz;			/* CP/M sectors/block   */
	   int  cpmspt;			/* CP/M sectors/track   */
	   char secmsk;			/* sector mask	    	*/
	   char secshf;			/* log2(hstblk)		*/
	   char type;			/* drive type		*/
	   char unit;			/* physical unit number */
	   int  base;			/* base track		*/
	   char *XLT;			/* translate vector	*/
	   int  scratch[3];		/* scratch area		*/
	   char *DIRBUF;		/* directory buffer	*/
	   char *DPB;			/* disk parameter block */
	   char *CSV;		  	/* check vector		*/
	   char alv[2];			/* alloc vector		*/
  	 } *XDPH;	   


  /* search for first floppy disk */
  for (i = 0;; i++) if (!(XDPH = bios(SELDSK, i, 0) - 13)->type) break;
  first = i;

  /* search for last floppy disk */
  for (i++;; i++) if (!bios(SELDSK, i, 0)) break; 
  last = --i;

  /* turn on graphics mode */
  outp (0xF5, 0);

  /* get parameters loop */
  for (i = 0;; i++)
  {
    index  = wtab[i][3] >> 4;
    option = wtab[i][3] &  7;  

    key = window(wtab[i][0], wtab[i][1], wtab[i][2], &zbuf[index]);

    /* check BACKTAB function */
    if (key == ENQ || key == BS)
    {
      while (i > 3 && wtab[--i][0] != 0x7F14);
      i--;
      continue;
    }

    /* check ESC function */
    if (key == NAK)
    {
      puts ("\33=7 \n");

      /* reset drive system */
      bdos  (13, 0);
      abort (0);
    }
 
    /* check options */
    switch (option)
    {
      /* ASCII --> binary --> ASCII */
      case 1: int2 = convert(0x10, (long)int2, 0, wtab[i][2] - wtab[i][1] + 1,
			     &zbuf[index]);
	      break;		

      case 2: /* bump loop counter */
	      i++;
	      break;

      case 3: /* get drive # */
	      if ((drive = toupper(zbuf[index]) - 'A') < first || drive > last)
		i--;
	      else
	      {	
  		/* get disk parameters */
  		if (*version)		/* CP/M 2.2d with Genieplus Card */
    		  system (XMOVE, 0, sizeof DCT,
			  DCTBASE + (drive - first) * sizeof DCT, dct = DCT);
  		else dct = 0xFED1;	/* CP/M 2.2d                     */
	
		dct[1] &= 0xFE;		/* reset init bit		 */

		/* set disk parameters */
		if (*version)		/* CP/M 2.2d with Genieplus Card */
		  system (XMOVE, 1, sizeof DCT, dct, 
			  DCTBASE + (drive - first) * sizeof DCT);
	      }	
      	      break;

      case 4: /* get track # */
	      track = int2;
	      break;

      case 5: /* get side # */
	      side = int2;

	      /* clear display buffer */
	      for (sector = 0; sector < 14; sector++)
	      {
		setmem (&zbuf[646 + sector * 80], 28, ' ');
		setmem (&zbuf[686 + sector * 80], 28, ' ');
	      }	

	      /* read address bytes */
	      for (seccount = 0;; seccount++)
		if (errno =
		   read_address(drive - first, side, track, address[seccount]))
		{
		  errmsg (errno);
		  i = 1;
		  break;
		}
		else if (seccount && address[seccount][2] == address[0][2])
		       break;	
	      break;

      case 6: /* seek first sector */
	      firstsec = 0;
	      for (sector = 1; sector < seccount; sector++)
		if (address[sector][2] < address[firstsec][2])
		  firstsec = sector;

	      /* move address marks into display buffer */
	      for (sector = 0; sector < seccount && sector < 14; sector++)
	      {
		index = (firstsec + sector) % seccount;
	        convert (0x11, (long)address[index][0], 0, 3,
			 &zbuf[646 + sector * 80]);
		convert (0x11, (long)address[index][1], 0, 1,
			 &zbuf[654 + sector * 80]);
		convert (0x11, (long)address[index][2], 0, 3,
			 &zbuf[661 + sector * 80]);

		/* calc sector length */
		int2 = 128;
		switch (address[index][3])
		{
		  case 3: int2 += 512;
		  case 2: int2 += 256;
		  case 1: int2 += 128;
		}

		convert (0x11, (long)int2, 0, 4, &zbuf[670 + sector * 80]);
	      }

	      for (sector = 14; sector < seccount && sector < 28; sector++)
	      {
		index = (firstsec + sector) % seccount;
		convert (0x11, (long)address[index][0], 0, 3,
			 &zbuf[686 + (sector - 14) * 80]);
		convert (0x11, (long)address[index][1], 0, 1,
			 &zbuf[694 + (sector - 14) * 80]);
		convert (0x11, (long)address[index][2], 0, 3,
			 &zbuf[701 + (sector - 14) * 80]);

		/* calc sector length */
		int2 = 128;
		switch (address[index][3])
		{
		  case 3: int2 += 512;
		  case 2: int2 += 256;
		  case 1: int2 += 128;
		}

		convert (0x11, (long)int2, 0, 4,
			 &zbuf[710 + (sector - 14) * 80]);
	      }
	      break;

      case 7: /* reset loop counter */
	      i = 3; 
    }
  }
}


errmsg (errno)
  char errno;
{
  switch (errno)
  {
    case 1: window (3, 2300, 2332, "ILLEGAL DRIVE #                  ");
	    break;
    case 2: window (3, 2300, 2332, "TRACK # TOO HIGH                 ");
	    break;
    case 3: window (3, 2300, 2332, "ILLEGAL SIDE #                   ");
	    break;
    case 4: window (3, 2300, 2332, "DEVICE NOT AVAILABLE             ");
	    break;
    case 7: window (3, 2300, 2332, "DATA RECORD NOT FOUND DURING READ");
	    break;
    case 8: window (3, 2300, 2332, "PARITY ERROR DURING READ         ");
	    break;
    case 9: window (3, 2300, 2332, "LOST DATA DURING READ            ");
  }
}
 