/******************************************************************************
*  F O R M A T  *  U T I L S 0 0 6  *  T h o m a s   H o l t e * 8 5 0 3 0 2  *
*******************************************************************************
* 									      *
*      F O R M A T T I N G   U T I L I T Y   F O R   C P / M - V E R . 3      *
*      =================================================================      *
* 									      *
*  O N   T H E   G E N I E   I I I   M I C R O C O M P U T E R   S Y S T E M  *
*  =========================================================================  *
* 									      *
*		     W I T H   G E N I E P L U S   C A R D		      *
*		     =====================================		      *
*									      *
* 									      *
*   Thomas Holte			                         Version 1.0  *
* 									      *
******************************************************************************/

#include <stdio.h>

#define DCTBASE 0x15D1		/* base of drive control blocks */

/* sector table */
char stab[52] = {0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF};

char *dct;			/* drive control table 			*/

main (argc, argv)
  int argc;
  char *argv[];
{
  char type;			/* drive type				*/
  char first;			/* number of first floppy disk drive	*/
  char last;			/* number of last  floppy disk drive	*/
  char drive;			/* drive number				*/
  char DCT[6];			/* physical drive control table		*/
  char surface;			/* number of surfaces			*/
  char density;			/* disk density				*/
  char sl;			/* sector length byte			*/
  int  seclen;			/* sector length			*/
  char skew;			/* interleaving factor			*/
  char base;			/* base number of first sector on 
				   current surface			*/
  char buf[7000];		/* track buffer				*/
  int  beginsec;		/* start of  1st sector in track buffer */
  int  endsec;			/* start of last sector in track buffer	*/
  int  gap;			/* length of sector gap			*/
  int  wholesec;		/* length of sector with gaps		*/
  char firsttrk;		/* number of first track		*/
  char lasttrk;			/* number of last  track		*/
  char track;			/* current track number			*/
  char firstsec;		/* number of first sector		*/
  char secno;			/* current sector number		*/
  char seccount;		/* sectors per track			*/
  char side;			/* current surface number		*/
  char *version = 0xFFFF;	/* contains BIOS version number		*/
  char errno;			/* error code				*/
  char errmsg ();		/* prompts error message		*/
  int  i, j;			/* loop counters 			*/

  /* extended disk parameter header */
  struct {
	   char (*_WRITE) ();		/* addr of sector WRITE */
	   char (*_READ ) (); 		/* addr of sector READ  */
	   char (*LOGIN ) ();		/* addr of disk   LOGIN */
	   char (*INIT  ) ();		/* addr of disk   INIT  */
	   char unit;			/* physical unit number */
	   char type;			/* drive type		*/
	   char *XLT;			/* translate vector	*/
	   char scratch[9];		/* scratch area		*/
	   char MF;			/* media flag		*/
	   char *DPB;			/* disk parameter block */
	   char *CSV;			/* check vector		*/
	   char *ALV;			/* alloc vector		*/
	   char **DIRBCB;		/* dir BCB  header  	*/
	   char **DTABCB;		/* data BCB header	*/
	   char *HASH;			/* hashing table	*/
	   char HBANK;			/* hash bank		*/
         } *(*DTBL)[16],		/* drive table		*/
	   *XDPH;


  /* get drive table */
  DTBL = bios(DRVTBL);

  /* search for first floppy disk */
  for (i = 0;; i++)
  {
    XDPH = (char *)(*DTBL)[i] - 10;
    if (*version) system (15, 1, 1, &XDPH->type, &type);/*    banked version */
    else type = XDPH->type;				/* nonbanked version */

    if (!type) break;    
  }
  first = i;

  /* search for last floppy disk */
  for (i++;; i++) if (!(*DTBL)[i]) break; 
  last = --i;

  /* switch on German character set */
  printf ("\33G");

  if (!--argc || ((drive = toupper(**++argv) - 'A') < first || drive > last)
	      &&   drive != 15)
  {
    printf ("Ung}ltiger Laufwerksname (Benutzen Sie %c - %c, P)\n",
	    first + 'A', last + 'A');  
    abort  (1);
  }

  /* prompt */
  printf ("M|chten Sie wirklich die Diskette in Laufwerk %c formatieren ? ",
	  drive + 'A');
  if (toupper(getchar()) != 'J') return;


  /* get disk parameters */
  if (*version)					/* banked version */
  {
    dct = DCT; 
    if (drive == 15) 
    {
      XDPH = (char *)(*DTBL)[15] - 10;
      system (15, 1, sizeof DCT, (char *)XDPH + 35, dct);
      first = 0;
    }	
    else system (15, 1, sizeof DCT, DCTBASE + (drive - first) * sizeof DCT,  
		 dct);
  }
  else						/* nonbanked version */
    if (drive == 15) 
    {
      XDPH  = (char *)(*DTBL)[15] - 10;
      dct   = (char *)XDPH        + 35;
      drive = XDPH->unit;
      first = 0;	
    }
    else dct = 0xFED1 + (drive - first) * sizeof DCT;

  dct[1] &= 0xFE;		/* reset init bit */

  /* set disk parameters */
  if (*version)  
    if (drive == 15)
    {
      system (15,    1, 	     1, &XDPH->unit, &drive	      );
      system (15, 0x10, sizeof DCT - 1, dct	   , (char *)XDPH + 35);
    }
    else system (15, 0x10, sizeof DCT, dct,
		 DCTBASE + (drive - first) * sizeof DCT);

  surface  = dct[0] >> 6 & 1;
  density  = dct[0] >> 5 & 1;
  firsttrk = density ? !(dct[0] >> 4 & 1) : 0;
  firstsec = dct[0] >> 3 & 1;     
  seccount = dct[3] / (surface + 1);
  base     = dct[1] >> 5 & 1 ? seccount : 0;
  lasttrk  = dct[4] + firsttrk;
  i = sl   = dct[1] >> 6 & 3;
  seclen   = 128;
  while (i--) seclen *= 2;
  skew     = dct[2];

  /* build track buffer */
  if (density)
  {
    gap = 25;
    switch (sl)
    {
      case 3: gap += 98;
      case 2: gap += 15;
    }

    wholesec = gap + 60 + seclen;
    beginsec = gap + 16;
    endsec   = seccount * wholesec;
    for (i = 0; i < endsec; i += wholesec)
    {
      j = 0;	
      while (j < gap               ) buf[i + j++] = 0x4E;
      while (j < gap + 12          ) buf[i + j++] = 0x00;
      while (j < gap + 15          ) buf[i + j++] = 0xF5;
         		             buf[i + j  ] = 0xFE;
			                     j   += 4   ;
			             buf[i + j++] = sl  ;	
    			             buf[i + j++] = 0xF7;
      while (j < gap + 43          ) buf[i + j++] = 0x4E;
      while (j < gap + 55          ) buf[i + j++] = 0x00;
      while (j < gap + 58          ) buf[i + j++] = 0xF5;
      			             buf[i + j++] = 0xFB;
      while (j < gap + 59 + seclen)  buf[i + j++] = 0xE5;
			 	     buf[i + j++] = 0xF7;
    }  
    for (i = endsec; i < 7000; i++) buf[i] = 0x4E;
  }
  else
  {
    gap = 27;
    if (sl == 1) gap -= 11;

    wholesec = gap + 31 + seclen;	
    beginsec = gap +  7;
    endsec   = seccount * wholesec;
    for (i = 0; i < endsec; i += wholesec)
    {
      j = 0;
      while (j < gap    	  ) buf[i + j++] = 0xFF;	
      while (j < gap +  6	  ) buf[i + j++] = 0x00;
         		     	    buf[i + j  ] = 0xFE;
			              	    j   += 4   ;	
		       	      	    buf[i + j++] = sl  ;
    			      	    buf[i + j++] = 0xF7;
      while (j < gap + 23	  ) buf[i + j++] = 0xFF;	
      while (j < gap + 29	  ) buf[i + j++] = 0x00;
      			     	    buf[i + j++] = 0xFB;
      while (j < gap + 30 + seclen) buf[i + j++] = 0xE5;
			      	    buf[i + j++] = 0xF7;
    }  
    for (i = endsec; i < 7000; i++) buf[i] = 0xFF;
  }
  
  /* number sectors */
  for (i = secno = 0; i < seccount; i++)
  {
    j = secno;
    if (stab[j] != 0xFF)
    {
      secno++;
      i--;
    }
    else
    {
      stab[j] = i;
      if ((secno += skew) >= seccount) secno -= seccount;
    }
  }

  /* duplicate sector table with offset */
  if (surface) for (i = 0; i < seccount; i++)
		 stab[i + seccount] = stab[i] + seccount;

  /* formatting */
  printf ("\nFormatieren von Spur   ");	

  for (track = firsttrk; track < lasttrk; track++)
  {
    for (i = beginsec; i < endsec; i += wholesec) buf[i] = track;
    printf ("\b\b%02d", track);
    
    for (side = 0; side <= surface; side++)
    {
      for (i = beginsec + 1, j = 0; j < seccount; i += wholesec, j++)
      {	
        buf[i    ] = side;
	buf[i + 1] = stab[j] + firstsec + base * side;
      }

      /* format track */	
      if (errno = formtrk(drive - first, side, track, buf))
      {
	switch (errmsg(errno))
	{
	  case 'A': abort (1);		
	  case 'W': track--;
        }
        printf ("\nFormatieren von Spur   ");
	break;
      }		
    }
  }

  /* verifying */
  printf ("\rVerifizieren von Spur   ");

  for (track = firsttrk; track < lasttrk; track++)
  {
    printf ("\b\b%02d", track);

    if (errno = checktrk (drive - first, track))
    {
      switch (errmsg(errno))
      {
        case 'A': abort (1);
	case 'W': for (i = beginsec; i < endsec; i += wholesec)
		    buf[i] = track;
		  for (side = 0; side <= surface; side++)
		  {
      		    for (i = beginsec + 1, j = 0; j < seccount;
			 i += wholesec, j++)
      		    {	
        	      buf[i    ] = side;
		      buf[i + 1] = stab[j] + firstsec + base * side;
      		    }
		    formtrk (drive - first, side, track, buf);
		  }
		  track--;
       }
       printf ("\nVerifizieren von Spur   ");
    }
  }
} 
	 		

char errmsg (errno)
  char errno;
{
  char c;

  switch (errno)
  {
    case 1: printf ("\nUng}ltiges Laufwerk\n");
	    abort  (1);	
    case 2: printf ("\nUng}ltige Spur\n");
	    abort  (1);
    case 3: printf ("\nUng}ltiger Sektor\n");
	    abort  (1);	
    case 4: printf ("\nLaufwerk nicht bereit\n");
	    break;
    case 5: printf ("\nDiskette schreibgesch}tzt\n");
 	    break;
    case 6: printf ("\nLaufwerksfehler\n");
	    abort  (1);
    case 7: printf ("\nDaten-Record nicht gefunden\n");
	    break;
    case 8: printf ("\nCRC-Fehler\n");
	    break;
    case 9: printf ("\nDaten verloren\n");
	    abort  (1);
  }
  printf ("(A)bbrechen, (W)iederholen oder (F)ortfahren\n");
  do
  {
    printf ("\b");
    c = toupper(getchar());
  }
  while (c != 'A' && c != 'F' && c != 'W');
  printf ("\n");
  return c;
}
