/******************************************************************************
*  C O N F I G  *  U T I L S 0 0 2  *  T h o m a s   H o l t e  * 8 5 0 5 1 2 *
*******************************************************************************
*									      *
*  S Y S T E M   C O N F I G U R A T O R   F O R   T H E   G E N I E   I I I  *
*  =========================================================================  *
*									      *
*  		    M I C R O C O M P U T E R   S Y S T E M		      *
*		    =======================================		      *
*									      *
*									      *
*  Version 1.1							Thomas Holte  *
*									      *
******************************************************************************/

#include <stdio.h>

/* ASCII control codes */
#define NUL	  0x00		/* null			     */	
#define SOH	  0x01		/* start of heading	     */
#define STX	  0x02		/* start of text	     */
#define ETX	  0x03		/* end of text		     */
#define EOT	  0x04		/* end of transmission	     */
#define ENQ       0x05		/* enquiry		     */
#define ACK	  0x06		/* acknowledge		     */
#define BEL	  0x07		/* bell			     */
#define BS        0x08		/* backspace		     */
#define HT	  0x09		/* horizontal tabulation     */ 	
#define LF	  0x0A		/* line feed		     */	
#define VT	  0x0B		/* vertical tabulation	     */
#define FF	  0x0C		/* form feed		     */
#define CR	  0x0D		/* carriage return	     */
#define SO	  0x0E		/* shift out		     */
#define SI	  0x0F		/* shift in		     */
#define DLE	  0x10		/* data link escape	     */
#define DC1	  0x11		/* device control 1	     */
#define DC2	  0x12		/* device control 2	     */
#define DC3	  0x13		/* device control 3	     */
#define DC4	  0x14		/* device control 4	     */
#define NAK       0x15		/* negative acknowledge	     */
#define SYN	  0x16		/* synchronous idle	     */
#define ETB	  0x17		/* end of transmission block */
#define CAN	  0x18		/* cancel		     */
#define EM	  0x19		/* end of medium	     */	
#define SUB	  0x1A		/* substitute		     */
#define ESC	  0x1B		/* escape		     */
#define FS	  0x1C		/* file separator	     */
#define GS	  0x1D		/* group separator	     */
#define RS	  0x1E		/* record separator	     */

#define SEC_SIZE     512   	/* physical sector size      */
#define BDOS_SIZE 0x1F00	/* size of resident BDOS     */
#define BIOS_SIZE 0x1500	/* size of resident BIOS     */

#define FIRST	       0	/* number of first floppy    */
#define LAST	       1	/* number of last  floppy    */


/* disk parameter block */
struct dpb {
	     int  SPT;
	     char BSH, BLM, EXM;
	     int  DSM, DRM;
	     char AL0, AL1;
	     int  CKS, OFF;
	     char PSH, PHM;
	   };

/* buffer control block */
struct bcb {
	     char DRV, REC[3], WFLG, scratch;
	     int  TRACK, SECTOR;
	     char *BUFFAD;
	   };

/* extended disk parameter header */
struct xdph {
	      char (*_WRITE) ();	/* addr of sector WRITE */
	      char (*_READ ) (); 	/* addr of sector READ  */
	      char (*LOGIN ) ();	/* addr of disk   LOGIN */
	      char (*INIT  ) ();	/* addr of disk   INIT  */
	      char unit;		/* physical unit number */
	      char type;		/* drive type		*/
	      char *XLT;		/* translate vector	*/
	      char scratch[9];		/* scratch area		*/
	      char MF;			/* media flag		*/
	      struct dpb *DPB;		/* disk parameter block */
	      char *CSV;		/* check vector		*/
	      char *ALV;		/* alloc vector		*/
	      struct bcb *DIRBCB;	/* dir BCB          	*/
	      struct bcb *DTABCB;	/* data BCB       	*/
	      char *HASH;		/* hashing table	*/
	      char HBANK;		/* hash bank		*/
	    };

/* character device table */
struct ctbl {
	      char device_name[6], type, baud_rate;
	    };

/* CPM3.SYS header record */
struct header {
	   	char res_top_page;	/* top page plus one, at which the
				           resident portion of CP/M 3 is to
				           be loaded top down 	 	    */
	   	char res_length;	/* length in pages of the resident
				      	   portion of CP/M 3		    */
	   	char bnk_top_page;      /* top page plus one, at which the
				           banked portion of CP/M 3 is to
				           be loaded top down		    */
	   	char bnk_length;	/* length in pages of the banked 
				           portion of CP/M 3		    */
	   	char *entry;		/* address of CP/M 3 cold boot
				      	   entry point			    */
	   	char filler[122];	
	      };

/* physical RS232C parameters */
struct rs232c {
	 	char bits;
	 	int  divisor;
              };

/* physical drive parameters */
struct dct {
	     char td1, td2, ilf, spt, tc, curtrk;
           };


xmain ()
{
  extern char zbuf[];			/* menu buffer			    */
  extern int  wtab[][5];		/* window parameters		    */

  FILE *CPM3_SYS;			/* file containing complete CP/M 3
				           system			    */ 
  char print[REC_SIZE];			/* CPM3.SYS print record	    */
  char *CPM3;				/* pointer to system buffer	    */
  char *tCPM3;				/* temporary pointer		    */
  int  size;				/* size of CPM3.SYS		    */
  char *BIOS;				/* pointer to BIOS		    */
  int  base;				/* base offset to BIOS		    */
  char LDRBIOS[    SEC_SIZE];		/* table of system constants (p. 1) */
  char SYSTAB [2 * SEC_SIZE];		/* table of system constants (p. 2) */
  char errno;				/* disk I/O completion code	    */
  char drive;				/* current drive		    */
  char user;				/* current user			    */
  char type;				/* type of mass storage medium	    */
  char key;				/* ASCII code of breaking key	    */
  int  btab;				/* no. of BACKTAB steps		    */
  int  option;				/* no. of next task		    */
  int  int2;      			/* temp number storage  for convert */
  long int4;				/* temp number storage  for convert */
  int  comma;				/* no of decimal digits for convert */
  char *german;				/* switch byte for character set    */
  char *vidpar;				/* parameter table for video 
					   controller M6845                 */
  char *NBOARD;				/* pointer to keyboard table	    */
  char *WBOARD;				/* pointer to keyboard table
					   (WordStar version)		    */
  int  i, j, k, l, m;			/* loop counters		    */
  int  index;				/* menu buffer index		    */
  long convert  ();			/* ASCII --> binary conversion	    */
  BOOL notequal ();			/* comparison function		    */

  struct xdph   **dtbl;			/* drive table in memory	    */
  struct xdph   **DTBL;			/* drive table in CPM3.SYS file     */
  struct xdph   *XDPHF;			/* extended DPH for drive P:	    */
  struct xdph   *XDPHp;			/* temporary extended DPH pointer   */
  char          *XLTF;			/* translation table for drive P:   */
  struct dpb    *DPBF;			/* DPB for drive P:		    */
  struct ctbl   *CTBL;			/* character device table	    */
  struct header HEADER;			/* CPM3.SYS header record	    */
  struct rs232c *RS232C;		/* physical RS232C parameters	    */
  struct dct	*DCT;       		/* physical drive parameters	    */


  /* layout for old keyboard */
  static char oldkeys[] = {']', '}' , GS , 'a' , 'A' , SOH, 'b', 'B', STX,
			   'c', 'C' , ETX, 'd' , 'D' , EOT, 'e', 'E', ENQ,
			   'f', 'F' , ACK, 'g' , 'G' , BEL, 'h', 'H', BS ,
			   'i', 'I' , HT , 'j' , 'J' , LF , 'k', 'K', VT ,
			   'l', 'L' , FF , 'm' , 'M' , CR , 'n', 'N', SO ,
			   'o', 'O' , SI , 'p' , 'P' , DLE, 'q', 'Q', DC1,
			   'r', 'R' , DC2, 's' , 'S' , DC3, 't', 'T', DC4,
			   'u', 'U' , NAK, 'v' , 'V' , SYN, 'w', 'W', ETB,
			   'x', 'X' , CAN, 'z' , 'Z' , SUB, 'y', 'Y', EM ,
			   ';', '+' , 0  , '[' , '{' , ESC, ':', '*', 0  ,
			   '@', '`' , NUL, 0   , 0   , 0  , '0', '_', 0  ,
			   '1', '!' , 0  , '2' , '\"', 0  , '3', '#', 0  ,
			   '4', '$' , 0  , '5' , '%' , 0  , '6', '&', 0  ,
			   '7', '\'', 0  , '8' , '(' , 0  , '9', ')', 0  ,
			   '^', '~' , RS , '\\', '|' , FS};

  /* layout for new keyboard */
  static char newkeys[] = {'@', '`' , NUL, 'a' , 'A' , SOH, 'b', 'B', STX,
			   'c', 'C' , ETX, 'd' , 'D' , EOT, 'e', 'E', ENQ,
			   'f', 'F' , ACK, 'g' , 'G' , BEL, 'h', 'H', BS ,
			   'i', 'I' , HT , 'j' , 'J' , LF , 'k', 'K', VT ,
			   'l', 'L' , FF , 'm' , 'M' , CR , 'n', 'N', SO ,
			   'o', 'O' , SI , 'p' , 'P' , DLE, 'q', 'Q', DC1,
			   'r', 'R' , DC2, 's' , 'S' , DC3, 't', 'T', DC4,
			   'u', 'U' , NAK, 'v' , 'V' , SYN, 'w', 'W', ETB,
			   'x', 'X' , CAN, 'y' , 'Y' , EM , 'z', 'Z', SUB,
			   '[', '{' , ESC, '\\', '|' , FS , ']', '}', GS ,
			   '^', '~' , RS , '_' , '^' , RS , '0', '0', 0  ,
			   '1', '!' , 0  , '2' , '\"', 0  , '3', '#', 0  ,
			   '4', '$' , 0  , '5' , '%' , 0  , '6', '&', 0  ,
			   '7', '\'', 0  , '8' , '(' , 0  , '9', ')', 0  ,
			   ':', '*' , 0  , ';' , '+' , 0};


  /* get current drive */
  drive = bdos(25, 0   );

  /* get current user */
  user  = bdos(32, 0xFF);

  /* set user 0 */
  bdos (32, 0);

  /* read LDRBIOS */
      bios (SELDSK, FIRST  );
      bios (HOME  ,       0);
      bios (SETTRK,       0);
      bios (SETSEC,       6);
      bios (SETDMA, LDRBIOS);
  if (bios (READ  ,       0)) xabort (1, drive, user);

  /* read SYSTAB */
      bios (SETSEC,      	    7);
      bios (SETDMA, SYSTAB	     );
  if (bios (READ  ,      	    0)) xabort (1, drive, user);
      bios (SETSEC,      	    8);
      bios (SETDMA, SYSTAB + SEC_SIZE);
  if (bios (READ  ,      	    0)) xabort (1, drive, user);
      bios (SELDSK,      	    0);
  
  /* read system */
  if ((CPM3_SYS = open("A:CPM3.SYS", 0)) == ERROR)
  {
    puts   ("\nA:CPM3.SYS nicht vorhanden\n");
    xabort (1, drive, user);
  }

  /* read header record and print record */
  read (CPM3_SYS, &HEADER, REC_SIZE);
  read (CPM3_SYS, print  , REC_SIZE);
  
  /* get memory for CPM3.SYS data */
  if (!(CPM3 = alloc(size = (HEADER.res_length + HEADER.bnk_length) * 0x100)))
  {
    puts   ("\nNicht gen}gend Speicherplatz verf}gbar\n");
    xabort (1, drive, user);
  }

  /* read system in reversed order */
  for (tCPM3 = CPM3 + size - REC_SIZE; tCPM3 >= CPM3; tCPM3 -= REC_SIZE)
    read (CPM3_SYS, tCPM3, REC_SIZE);

  /* calculate pointer to BIOS */
  BIOS = CPM3 + BDOS_SIZE;
  base = HEADER.res_top_page * 0x100 - BIOS_SIZE - BIOS; 

  close (CPM3_SYS);

  
  /* check for legal system */
  dtbl = bios(DRVTBL);
  DTBL = (char *)dtbl - base;

  if (notequal(dtbl, DTBL, sizeof *DTBL * 16))
  {
    puts   ("\nSynchronisierungsfehler\n");
    xabort (1, drive, user);
  }


  /* initialize structure pointers */
  XDPHF  = (char *)DTBL[15] - 10 - base;
  XLTF   = (char *)XDPHF->XLT    - base;
  DPBF   = (char *)XDPHF->DPB	 - base;
  DCT    = (char *)XDPHF    + 35;

  CTBL   = bios(DEVTBL) + 2 * sizeof(struct ctbl) - base;  

  NBOARD = &SYSTAB[0x10A];
  WBOARD = &SYSTAB[0x212];

  vidpar = &LDRBIOS[0x0F1];     	/* video parameter table   */
  german = &LDRBIOS[0x101];     	/* switch bit for char set */
  RS232C = &LDRBIOS[0x102];     	/* RS232C parameters	   */


  /* check for legal boot floppy */
  if (vidpar[1] != 80 || vidpar[6] != 25)
  {
    puts   ("\nSynchronisierungsfehler\n");
    xabort (1, drive, user);
  }


  /* switch on German character set */
  puts ("\33G");

  /* turn on graphics mode */
  outp (0xF5, 0);

  /* get parameters loop */
  for (i = 0;; i++)
  {
    index  = wtab[i][3];
    option = wtab[i][4] >> 8;
    btab   = wtab[i][4] & 0xFF;

    key = window(wtab[i][0], wtab[i][1], wtab[i][2], &zbuf[index]);

    /* check special keys */
    switch (key)
    {
      case ENQ:
      case BS : i -= btab + 1;
		continue;
      case NAK: if (i == 5)
		{
		  puts   ("\33=7 \n\n");
		  xabort (0, drive, user);
		}
		else
		{
		  i = 54;
		  goto recalc;
		}
    }

    /* check options */
    switch (option)
    {
      /* ASCII --> binary --> ASCII */
      case  1: int2 = convert(0x10, (long)int2, 0, wtab[i][2] - wtab[i][1] + 1,
			      &zbuf[index]);
	       break;

      /* get control code */	
      case  2: switch (int2)
	       {
		 /* system parameters */
		 case 1 : /* get cursor character */
			  zbuf[1021] = vidpar[10] & 0x1F ? 'U' : 'B';

			  /* get blink rate */
			  zbuf[1076] = vidpar[10] & 0x60 ? 'J' : 'N';

			  /* get keyboard type */
			  zbuf[1131] = *NBOARD == '@' ? 'J' : 'N';

			  /* get switch bit for char set */
			  zbuf[1186] = *german == 'G' ? 'J' : 'N';

			  /* get no. of data bits */
			  zbuf[1296] = (RS232C->bits & 3) + '5';
			   
			  /* get no. of stop bits */
			  zbuf[1351] = (RS232C->bits >> 2 & 1) + '1';

			  /* get parity */
			  if (RS232C->bits & 8)
			    zbuf[1406] = RS232C->bits & 0x10 ? 'G' : 'U';
			  else zbuf[1406] = 'K';

			  /* get baud rate */
			  comma = 0;	/* reset digit count of fraction */
			  switch (RS232C->divisor)
			  {
			    case   10: int2  = 19200;
				       break;
			    case   20: int2  =  9600;
				       break;
			    case   27: int2  =  7200;
				       break;
			    case   40: int2  =  4800;
				       break;
			    case   53: int2  =  3600;
				       break;
			    case   80: int2  =  2400;
				       break;
			    case  107: int2  =  1800;
				       break;
			    case  160: int2  =  1200;
				       break;
			    case  320: int2  =   600;
				       break;
			    case  640: int2  =   300;
				       break;
			    case 1280: int2  =   150;
				       break;
			    case 1428: int2  =  1345;
				       comma =     1;
				       break;
			    case 1745: int2  =   110;
				       break;
			    case 2560: int2  =    75;
				       break;
			    case 3840: int2  =    50;
				       break;
			    default  : int2  =     0;
			  }
			  convert (1, (long)int2, comma, 5, &zbuf[1461]);

			  /* XON/XOFF protocol ? */
			  zbuf[1516] = CTBL->type & 0x10 ? 'J' : 'N';
			  break;

		 /* floppy disk drives */
		 case 2 : zbuf[1693] = FIRST + 'B';
			  zbuf[1697] = LAST  + 'A';

			  /* get physical drive */
			  zbuf[1704] = XDPHF->unit + FIRST + 'A'; 

		 	  /* get disk size */
		          if (DCT->td1 & 0x80) zbuf[1770] = '8'; 
					  else zbuf[1770] = '5';

		 	  /* get no. of surfaces */
		 	  if (DCT->td1 & 0x40) zbuf[1836] = 'D'; 
					  else zbuf[1836] = 'E';

		 	  /* get density */
		 	  if (DCT->td1 & 0x20) zbuf[1902] = 'D'; 
					  else zbuf[1902] = 'E';
 
		 	  /* get density of first track */	      
			    zbuf[1968] = 'E';
		 	  if (zbuf[1902] == 'D') if (DCT->td1 & 0x10) 
			    zbuf[1968] = 'D';

		 	  /* get track count */
		 	  convert (0x11, (long)DCT->tc, 0, 2, &zbuf[2034]);

		 	  /* no. of steps per track to track */
		 	  zbuf[2100] = (DCT->td1 >> 2 & 1) + '1';

		 	  /* get track stepping rate */
		 	  switch (DCT->td1 & 3)
		 	  {
		   	    case 0: int2 =  3;
			   	    break;
		   	    case 1: int2 =  6;
			   	    break;
		   	    case 2: int2 = 10;
			   	    break;
		   	    case 3: int2 = 15;
		 	  }
		 	  convert (0x11, (long)int2, 0, 2, &zbuf[2166]);

		 	  /* get no. of sectors per track */
		 	  convert (0x11, (long)DCT->spt, 0, 2, &zbuf[2232]);

		 	  /* get sector length */
		 	  k    = DCT->td2 >> 6;
		 	  int2 = 128;
		 	  for (j = 0; j < k; j++) int2 *= 2;
		 	  convert (0x11, (long)int2, 0, 4, &zbuf[2298]);

		 	  /* get no. of first sector */
		 	  zbuf[2364] = (DCT->td1 >> 3 & 1) + '0';

		 	  /* sector numbering continued on back side */
			 		   	   zbuf[2430] = 'N';
		 	  if (zbuf[1836] == 'D')
		   	    if (DCT->td2 >> 5 & 1) zbuf[2430] = 'J';

		 	  /* get interleaving factor */
		 	  convert (0x11, (long)DCT->ilf, 0, 2, &zbuf[2496]);

		 	  /* get block size */
		 	  convert (0x11, (long)((DPBF->BLM + 1) / 8), 0, 2,
				   &zbuf[2628]);

		 	  /* get dir size */
		 	  zbuf[2694] = DPBF->DRM / 32 + 1 + '0';

			  /* get skew factor */
			  convert (0x11, (long)(XLTF[1] - XLTF[0]), 0, 2,
				   &zbuf[2760]);

		 	  /* get no. of system tracks */
		 	  zbuf[2826] = DPBF->OFF + '0';

			  i += 14;
			  break;

		 /* store system and exit program */
		 case 3 : puts ("\33=7 \n\n");

  			  /* write system */
  			  if ((CPM3_SYS = open("A:CPM3.SYS", 1)) == ERROR)
  			  {
    			    puts   ("\nA:CPM3.SYS schreibgesch}tzt\n");
    			    xabort (1, drive, user);
  			  }

  			  /* write header record and print record */
  			  write (CPM3_SYS, &HEADER, REC_SIZE);
  			  write (CPM3_SYS, print  , REC_SIZE);
  
  			  /* write system in reversed order */
  			  for (tCPM3 = CPM3 + size - REC_SIZE; tCPM3 >= CPM3;
			       tCPM3 -= REC_SIZE)
         		    write (CPM3_SYS, tCPM3, REC_SIZE);

			  close (CPM3_SYS);

  			  /* write SYSTAB */
			      bios (SELDSK, FIRST );
      			      bios (HOME  ,      0);
      			      bios (SETTRK,      0);
      			      bios (SETSEC,      7);
      			      bios (SETDMA, SYSTAB);
  			  if (bios (WRITE ,      0)) xabort (1, drive, user);
      			      bios (SETSEC,      8);
      			      bios (SETDMA, SYSTAB + SEC_SIZE);
  			  if (bios (WRITE ,      0)) xabort (1, drive, user);
  
  			  /* write LDRBIOS */
      			      bios (SETSEC,       6);
      			      bios (SETDMA, LDRBIOS);
  			  if (bios (WRITE ,       0)) xabort (1, drive, user);

			  /* select current drive */
			  bios (SELDSK, drive);

			  /* select current user */
			  bdos (32, user);

			  puts (
        "Dr}cken Sie <RESET>, um das neukonfigurierte System zu aktivieren\n");
			  return;

		 /* illegal entry */
		 default: i -= 2;
	       }
	       break;

      /* check cursor character */
      case  3: switch (toupper(zbuf[index]))
	       {
		 case 'B': vidpar[10] &= 0x60;
			   break;
		 case 'U': vidpar[10] = (vidpar[10] & 0x60) + 11;
			   break;
		 default : i--;
	       }
	       break;

      /* blinking cursor ? */
      case  4: switch (toupper(zbuf[index]))
	       {
		 case 'N': vidpar[10] &= 0x1F;
			   break;
		 case 'J': vidpar[10] |= 0x40;
			   break;
		 default : i--;
	       }
	       break;

      /* new keyboard ? */
      case  5: switch (toupper(zbuf[index]))
	       {
		 case 'N': movmem (oldkeys, NBOARD, sizeof oldkeys);
			   movmem (oldkeys, WBOARD, sizeof oldkeys);
			   break;
		 case 'J': movmem (newkeys, NBOARD, sizeof newkeys);
			   movmem (newkeys, WBOARD, sizeof newkeys);
			   break;
		 default : i--;
	       }
	       break;			

      /* check character set */
      case  6: switch (toupper(zbuf[index]))
	       {
		 case 'N': *german = 'A';
			   break;
		 case 'J': *german = 'G';
	                   break;
		 default : i--;
	       }
	       break;

      /* check no. of data bits */
      case  7: if (int2 >= 5 && int2 <= 8)
		 RS232C->bits = RS232C->bits & 0xFC | int2 - 5;
	       else i -= 2;
	       break;

      /* check no. of stop bits */
      case  8: if (int2 == 1 || int2 == 2)
		 RS232C->bits = RS232C->bits & 0xFB | (int2 - 1) << 2;
	       else i -= 2;
	       break;

      /* check parity */
      case  9: switch (toupper(zbuf[index]))
	       {
		 case 'G': RS232C->bits |= 0x18;
			   break;
		 case 'K': RS232C->bits &= 7;
			   break;
		 case 'U': RS232C->bits |= 8;
			   break;
		 default : i--;
	       }
	       break;

      /* check baud rate */
      case 10: int2 = (int4 = 
		       convert(-1, (long)int2, 1, wtab[i][2] - wtab[i][1] + 1,
			       &zbuf[index])) / 10L;

	       /* special case: baud rate = 134.5 */
	       if (int4 == 1345)
	       {
		 convert (1, int4, 1, wtab[i][2] - wtab[i][1] + 1, 
			  &zbuf[index]);
		 RS232C->divisor   = 1428;
		 CTBL->baud_rate   =    4;

		 break;
	       }

	       switch (int2)
	       {	
	         case     50: RS232C->divisor = 3840;
			      CTBL->baud_rate =    1;
			      break;
	         case     75: RS232C->divisor = 2560;
			      CTBL->baud_rate =    2;
			      break;
	         case    110: RS232C->divisor = 1745;
			      CTBL->baud_rate =    3;
			      break;
	         case    150: RS232C->divisor = 1280;
			      CTBL->baud_rate =    5;
			      break;
	         case    300: RS232C->divisor =  640;
			      CTBL->baud_rate =    6;
			      break;
	         case    600: RS232C->divisor =  320;
			      CTBL->baud_rate =    7;
			      break;
	         case   1200: RS232C->divisor =  160;
			      CTBL->baud_rate =    8;
			      break;
	         case   1800: RS232C->divisor =  107;
			      CTBL->baud_rate =    9;
			      break;
	         case   2400: RS232C->divisor =   80;
			      CTBL->baud_rate =   10;
			      break;
	         case   3600: RS232C->divisor =   53;
			      CTBL->baud_rate =   11;
			      break;
	         case   4800: RS232C->divisor =   40;
			      CTBL->baud_rate =   12;
			      break;
	         case   7200: RS232C->divisor =   27;
			      CTBL->baud_rate =   13;
			      break;
	         case   9600: RS232C->divisor =   20;
			      CTBL->baud_rate =   14;
			      break;
	         case  19200: RS232C->divisor =   10;
			      CTBL->baud_rate =   15;
			      break;
	         default    : i--;
			      continue;
	       }
	       convert(1, (long)(unsigned)int2, 0, wtab[i][2] - wtab[i][1] + 1,
			 &zbuf[index]);
	       break;

      /* XON/XOFF protocol */
      case 11: switch (toupper(zbuf[index]))
	       {
		 case 'N': CTBL->type &= 0xEF;
			   break;
		 case 'J': CTBL->type |= 0x10;
	                   break;
		 default : i--;
			   continue;
	       }

	       /* return to main menu */
	       i -= 19;
	       break;

      /* get drive code */
      case 12: if ((j = toupper(zbuf[index]) - 'A') > FIRST && j <= LAST)
   	         XDPHF->unit = j - FIRST;
	       else i--;
	       break;
			
      /* check disk size */
      case 13: switch (int2)
	       {
		 case 5 : DCT->td1 &= 0x7F;
			  break;
		 case 8 : DCT->td1 |= 0x80;
			  break;
		 default: i -= 2;
	       }
	       break;

      /* check no. of surfaces */
      case 14: switch (toupper(zbuf[index]))
	       {
		 case 'D': DCT->td1       |= 0x40;
			   wtab[i + 16][0] = 0x7F14;
			   wtab[i + 17][4] = (wtab[i + 17][4] & 0xFF00) + 1;
			   break;
		 case 'E': DCT->td1      &= 0xBF;
			   zbuf[2430]     = 'N';
			   wtab[i + 16][0] = 3;
			   wtab[i + 17][4] = (wtab[i + 17][4] & 0xFF00) + 3;
			   break;
		 default : i--;
	       }
	       break;

      /* check density */
      case 15: switch (toupper(zbuf[index]))
	       {
	  	 case 'D': DCT->td1 	 |= 0x20;
			   wtab[i + 3][4] = (wtab[i + 3][4] & 0xFF00) + 2;
			   break;
		 case 'E': DCT->td1      &= 0xCF;
			   zbuf[1968]     = 'E';
			   wtab[i + 3][4] = (wtab[i + 3][4] & 0xFF00) + 3;
			   i++;
			   break;
		 default : i--;
	       }
	       break;
						
      /* check density of first track */
      case 16: switch (toupper(zbuf[index]))
	       {
		 case 'D': DCT->td1 |= 0x10;
			   break;
		 case 'E': DCT->td1 &= 0xEF;
			   break;
		 default : i--;
	       }
	       break;

      /* check track count */
      case 17: if (int2 > 0) DCT->tc = int2; else i -= 2;
	       break;

      /* check no. of steps per track to track */
      case 18: if (int2 == 1 || int2 == 2) 
		 DCT->td1 = DCT->td1 & 0xFB | (int2 - 1) << 2;
	       else i -= 2;
	       break;

      /* check track stepping rate */
      case 19: switch (int2)
	       {
		 case  3: DCT->td1 = DCT->td1 & 0xFC;
			  break;
		 case  6: DCT->td1 = DCT->td1 & 0xFC | 1;
			  break;
		 case 10: DCT->td1 = DCT->td1 & 0xFC | 2;
			  break;
		 case 15: DCT->td1 = DCT->td1        | 3;
			  break;
		 default: i -= 2;
	       }	
	       break;

      /* check no. of sectors per track */
      case 20: if (int2 > 0) DPBF->SPT = (DCT->spt = int2) * (DPBF->PHM + 1);
	       else i -= 2;
	       break;

      /* check physical sector length */
      case 21: switch (int2)
	       {
		 case  128: DPBF->SPT = DCT->spt;
			    DPBF->PSH = 0;
			    DPBF->PHM = 0;
			    DCT->td2  = DCT->td2 & 0x3F; 
			    break;
		 case  256: DPBF->SPT = DCT->spt * 2;
			    DPBF->PSH = 1;
			    DPBF->PHM = 1;
			    DCT->td2  = DCT->td2 & 0x3F | 0x40;
			    break;
		 case  512: DPBF->SPT = DCT->spt * 4;
			    DPBF->PSH = 2;
			    DPBF->PHM = 3;
			    DCT->td2  = DCT->td2 & 0x3F | 0x80;
			    break;
		 case 1024: DPBF->SPT = DCT->spt * 8;
			    DPBF->PSH = 3;
			    DPBF->PHM = 7;
			    DCT->td2  = DCT->td2 | 0xC0;
			    break;
		 default  : i -= 2;
	       }
	       break;

      /* check no. of first sector */
      case 22: if (!int2 || int2 == 1)
		 DCT->td1 = DCT->td1 & 0xF7 | int2 << 3;
	       else i -= 2;
	       break;

      /* sector numbering continued on back side ? */
      case 23: switch (toupper(zbuf[index]))
	       {
		 case 'N': DCT->td2 &= 0xDF;
			   break;
		 case 'J': DCT->td2 |= 0x20;
			   break;
		 default : i--;
	       }
	       break;

      /* check interleaving factor */
      case 24: DCT->ilf = int2;
	       break;

      /* check block size */
      case 25: switch (int2)
	       {
		 case  1: DPBF->BSH =   3;
			  DPBF->BLM =   7;
			  break;
		 case  2: DPBF->BSH =   4;
			  DPBF->BLM =  15;
			  break;
		 case  4: DPBF->BSH =   5;
			  DPBF->BLM =  31;
			  break;
		 case  8: DPBF->BSH =   6;
			  DPBF->BLM =  63;
			  break;
		 case 16: DPBF->BSH =   7;
			  DPBF->BLM = 127;
			  break;
		 default: i -= 2;
 	       }
	       break;

      /* check directory size */
      case 26: if (int2 > 0)
      	       {
		 DPBF->CKS = ((DPBF->DRM = int2 * 32 - 1) + 1) / 4;

		 /* calc. block count for directory */
		 j = (DPBF->BLM + 1) / 8;
		 j = int2 / j + (int2 % j ? 1 : 0);
		 for (DPBF->AL0 = 0, k = 128; k && j; k /= 2, j--)
		   DPBF->AL0 += k;
		 for (DPBF->AL1 = 0, k = 128; k && j; k /= 2, j--)
		   DPBF->AL1 += k;
      	       }
      	       else i -= 2;
      	       break;

      /* check skew factor */
      case 27: if (int2 > 0)
	       {
		 /* build sector translate table */
		 m = DCT->spt / ((DCT->td1 >> 6 & 1) + 1);
		 for (j = k = 0; j < m; j++)
		 {
		   XLTF[j]=k;
		   if ((k += int2) >= m)
		   {
		     k -= m;
		     for (l = 0; l <= j; l++) if (XLTF[l] == k)
		     			      {
		       				k++;	 		  	
		       				l = -1;
		     			      }
		   }
		 }

		 /* double sided ? */
		 if (m != DCT->spt) for (j = 0; j < m; j++)
				      XLTF[j + m] = XLTF[j] + m;				
	       }
	       else i -= 2;
	       break;

      /* check no. of system tracks */
      case 28: if (int2 >= 0)
	       {
		 DPBF->OFF = int2;	

		 recalc:
		 if ((DPBF->DSM = (DCT->tc - DPBF->OFF) * DPBF->SPT 
			        / (DPBF->BLM + 1) - 1) <= 255)
		   switch (DPBF->BLM)
		   {
		     case   7: DPBF->EXM =  0;
			       break;
		     case  15: DPBF->EXM =  1;
			       break;
		     case  31: DPBF->EXM =  3;
			       break;
		     case  63: DPBF->EXM =  7;
			       break;
		     case 127: DPBF->EXM = 15;
		   }
 		 else
		   switch (DPBF->BLM)
		   {
		     case   7: i -= 8;			/* error */
			       continue;
		     case  15: DPBF->EXM =  0;
			       break;
		     case  31: DPBF->EXM =  1;
			       break;
		     case  63: DPBF->EXM =  3;
			       break;
		     case 127: DPBF->EXM =  7;
		   } 
	       }	
	       else
	       { 	
		 i -= 2;
		 break;
	       }		
	
	       i -= 53;
    }
  }
}


static BOOL notequal (buf1, buf2, n)
  char *buf1, *buf2;
  int n;
{
  int i;

  for (i = 0; i < n; i++) if (buf1[i] != buf2[i]) return TRUE;
						  return FALSE;
}


static xabort (mode, drive, user)
  char mode, drive, user;
{
  bios  (SELDSK, drive);
  bdos  (    32, user );
  abort (mode);
}
