/******************************************************************************
*  S T D I O  *  C L I B X X X  *  T h o m a s   H o l t e  *   8 5 0 1 1 5   *
*******************************************************************************
*
* Version 1.0 by Thomas Holte
*
* Header file with common definitions.
*
* Note: This file generates no code !
*/

#define BOOL    char
#define RESULT  int

#define TRUE    1
#define FALSE   0
#define NULL    0
#define SUCCESS 0
#define ERROR   (-1)
#define BDOSERR 0xFF

/* CP/M-80 BIOS entry points */
#define BOOT    0		/* perform cold start initialization    */
#define WBOOT   1		/* perform warm start initialization    */
#define CONST   2		/* check for console input char ready   */
#define CONIN   3		/* read  console character in	        */
#define CONOUT  4		/* write console character out	        */
#define LIST    5		/* write list    character out	        */
#define AUXOUT  6		/* write auxiliary output character     */
#define AUXIN   7		/* read  auxiliary input  character     */
#define HOME    8		/* move to track 00 on selected disk    */ 
#define SELDSK  9		/* select disk drive		        */
#define SETTRK 10		/* set track  number		        */
#define SETSEC 11		/* set sector number		        */
#define SETDMA 12		/* set DMA address		        */
#define READ   13		/* read  specifidd sector	        */
#define WRITE  14		/* write specified sector	        */
#define LISTST 15		/* return list status		        */
#define SECTRN 16		/* translate logical to physical sector */
#define CONOST 17		/* return output status of console	*/
#define AUXIST 18		/* return input  status of aux. port    */
#define AUXOST 19		/* return output status of aux. port	*/
#define DEVTBL 20		/* return address of char. I/O table	*/
#define DEVINI 21		/* initialize char. I/O devices		*/
#define DRVTBL 22		/* return address of disk drive table	*/
#define MULTIO 23		/* set number of logically consecutive  */
				/* sectors to be read or written	*/
#define FLUSH  24		/* force physical buffer flushing for   */
				/* user-supported deblocking		*/
#define MOVE   25		/* memory to memory move		*/
#define TIME   26		/* time set/get signal			*/
#define SELMEM 27		/* select bank of memory		*/
#define SETBNK 28		/* specify bank for DMA operation	*/
#define XMOVE  29		/* set bank when a buffer is in a bank  */
				/* other than 0 or 1			*/
#define USERF  30		/* reserved for system implementor	*/ 
	
/* file area */
#define CON 	  0x80
#define AUX 	  0x81
#define LST 	  0x82

#define FCB_READ     0
#define FCB_WRITE    1
#define FCB_R_W      2

#define MAX_DRIVE  15
#define REC_SIZE  128

struct filedesc {
		  char     dr;		/* drive code (0 - 16)		     */
		  char     f[8];	/* file name in ASCII upper case     */
		  char     t[3];	/* file type in ASCII upper case     */
		  char     ex;		/* current extent number	     */
		  int      s;		/* reserved for internal system use  */
		  char     rc;		/* record count for extent "ex"      */
		  char     d[16];	/* filled in by CP/M, reserved	     */
		  char     cr;		/* current record in "ex"	     */
	  union {
		  unsigned sr[2];
		  long     lr;
		} r;          	 	/* random record number              */
		  char     pw[8];	/* password field		     */
		  char     md;		/* creation mode		     */
		  char     fm;	  	/* access   mode		     */
		  char     eof;		/* last record byte count	     */
		  char     *ps;		/* pointer to seq buffer	     */
		};

#define FILE 	struct filedesc
#define SIZE_FD sizeof(struct filedesc)
