/******************************************************************************
*  F O R M A T  *  U T I L S 0 0 6  *  T h o m a s   H o l t e * 8 4 1 1 1 8  *
*******************************************************************************
* 									      *
*    F O R M A T T I N G   U T I L I T Y   F O R   C P / M - V E R . 2 . 2    *
*    =====================================================================    *
* 									      *
*  O N   T H E   G E N I E   I I I   M I C R O C O M P U T E R   S Y S T E M  *
*  =========================================================================  *
* 									      *
*		     W I T H   G E N I E P L U S   C A R D		      *
*		     =====================================		      *
*									      *
* 									      *
*   Thomas Holte			                         Version 1.0  *
* 									      *
******************************************************************************/

#include <stdio.h>

#define DCTBASE 0x13D1		/* base of drive control blocks */

char *dct;			/* drive control block */

/* sector table */
char stab[52] = {0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF};

main (argc, argv)
  int argc;
  char *argv[];
{
  char base, buf[7000], DCT[6], density, drive, errmsg (), errno, first,
       firstsec, firsttrk, last, lasttrk, secno, seccount, side, skew, sl,
       surface, track;
  char *version = 0xFFFF;		/* CP/M 2.2d version # */
  int beginsec, endsec, gap, i, j, seclen, wholesec;

  struct {
	   char (*write) ();		/* addr of sector WRITE */
	   char (*read) (); 		/* addr of sector READ  */
	   char blksiz;			/* CP/M sectors/block   */
	   int  cpmspt;			/* CP/M sectors/track   */
	   char secmsk;			/* sector mask	    	*/
	   char secshf;			/* log2(hstblk)		*/
	   char type;			/* drive type		*/
	   char unit;			/* physical unit number */
	   int  base;			/* base track		*/
	   char *XLT;			/* translate vector	*/
	   int  scratch[3];		/* scratch area		*/
	   char *DIRBUF;		/* directory buffer	*/
	   char *DPB;			/* disk parameter block */
	   char *CSV;		  	/* check vector		*/
	   char alv[2];			/* alloc vector		*/
  	 } *XDPH;	   


  /* search for first floppy disk */
  for (i = 0;; i++) if (!(XDPH = bios(SELDSK, i, 0) - 13)->type) break;
  first = i;

  /* search for last floppy disk */
  for (i++;; i++) if (!bios(SELDSK, i, 0)) break; 
  last = --i;

  /* switch on German character set */
  printf ("\33G");

  if (!--argc || (drive = toupper(**++argv) - 'A') < first || drive > last)
  {
    printf ("UNG]LTIGER LAUFWERKSNAME (BENUTZEN SIE %c - %c)\n", first + 'A',
								  last + 'A');
    abort  (1);
  }

  /* prompt */
  printf ("M\\CHTEN SIE WIRKLICH DIE DISKETTE IN LAUFWERK %c FORMATIEREN ? ",
	  drive + 'A');
  if (toupper(getchar()) != 'J') return;

  if (*version)				/* CP/M 2.2d with Genieplus Card */
    /* get disk parameters */
    system (XMOVE, 0, sizeof DCT, DCTBASE + (drive - first) * sizeof DCT,
	    dct = DCT);
  else dct = 0xFED1 + (drive - first) * sizeof DCT;	/* CP/M 2.2d	 */

  dct[1] &= 0xFE;		/* reset init bit */

  /* set disk parameters */
  if (*version)
    system (XMOVE, 1, sizeof DCT, dct, DCTBASE + (drive - first) * sizeof DCT);

  surface  = dct[0] >> 6 & 1;
  density  = dct[0] >> 5 & 1;
  firsttrk = density ? 0 : dct[0] >> 4 & 1;
  firstsec = dct[0] >> 3 & 1;     
  seccount = dct[3] / (surface + 1);
  base     = dct[1] >> 5 & 1 ? seccount : 0;
  lasttrk  = dct[4] + firsttrk;
  i = sl   = dct[1] >> 6 & 3;
  seclen   = 128;
  while (i--) seclen *= 2;
  skew     = dct[2];

  /* build track buffer */
  if (density)
  {
    gap = 25;
    switch (sl)
    {
      case 3: gap += 98;
      case 2: gap += 15;
    }

    wholesec = gap + 60 + seclen;
    beginsec = gap + 16;
    endsec   = seccount * wholesec;
    for (i = 0; i < endsec; i += wholesec)
    {
      j = 0;	
      while (j < gap               ) buf[i + j++] = 0x4E;
      while (j < gap + 12          ) buf[i + j++] = 0x00;
      while (j < gap + 15          ) buf[i + j++] = 0xF5;
         		             buf[i + j  ] = 0xFE;
			                     j   += 4   ;
			             buf[i + j++] = sl  ;	
    			             buf[i + j++] = 0xF7;
      while (j < gap + 43          ) buf[i + j++] = 0x4E;
      while (j < gap + 55          ) buf[i + j++] = 0x00;
      while (j < gap + 58          ) buf[i + j++] = 0xF5;
      			             buf[i + j++] = 0xFB;
      while (j < gap + 59 + seclen)  buf[i + j++] = 0xE5;
			 	     buf[i + j++] = 0xF7;
    }  
    for (i = endsec; i < 7000; i++) buf[i] = 0x4E;
  }
  else
  {
    gap = 27;
    if (sl == 1) gap -= 11;

    wholesec = gap + 31 + seclen;	
    beginsec = gap +  7;
    endsec   = seccount * wholesec;
    for (i = 0; i < endsec; i += wholesec)
    {
      j = 0;
      while (j < gap    	  ) buf[i + j++] = 0xFF;	
      while (j < gap +  6	  ) buf[i + j++] = 0x00;
         		     	    buf[i + j  ] = 0xFE;
			              	    j   += 4   ;	
		       	      	    buf[i + j++] = sl  ;
    			      	    buf[i + j++] = 0xF7;
      while (j < gap + 23	  ) buf[i + j++] = 0xFF;	
      while (j < gap + 29	  ) buf[i + j++] = 0x00;
      			     	    buf[i + j++] = 0xFB;
      while (j < gap + 30 + seclen) buf[i + j++] = 0xE5;
			      	    buf[i + j++] = 0xF7;
    }  
    for (i = endsec; i < 7000; i++) buf[i] = 0xFF;
  }
  
  /* number sectors */
  for (i = secno = 0; i < seccount; i++)
  {
    j = secno;
    if (stab[j] != 0xFF)
    {
      secno++;
      i--;
    }
    else
    {
      stab[j] = i;
      if ((secno += skew) >= seccount) secno -= seccount;
    }
  }

  /* duplicate sector table with offset */
  if (surface) for (i = 0; i < seccount; i++)
		 stab[i + seccount] = stab[i] + seccount;

  /* formatting */
  printf ("\nFORMATIEREN VON SPUR   ");	

  for (track = firsttrk; track < lasttrk; track++)
  {
    for (i = beginsec; i < endsec; i += wholesec) buf[i] = track;
    printf ("\b\b%02d", track);
    
    for (side = 0; side <= surface; side++)
    {
      for (i = beginsec + 1, j = 0; j < seccount; i += wholesec, j++)
      {	
        buf[i    ] = side;
	buf[i + 1] = stab[j] + firstsec + base * side;
      }

      /* format track */	
      if (errno = formtrk(drive - first, side, track, buf))
      {
	switch (errmsg(errno))
	{
	  case 'A': abort (1);		
	  case 'W': track--;
        }
        printf ("\nFORMATIEREN VON SPUR   ");
	break;
      }		
    }
  }

  /* verifying */
  printf ("\rVERIFIZIEREN VON SPUR   ");

  for (track = firsttrk; track < lasttrk; track++)
  {
    printf ("\b\b%02d", track);

    if (errno = checktrk (drive - first, track))
    {
      switch (errmsg(errno))
      {
        case 'A': abort (1);
	case 'W': for (i = beginsec; i < endsec; i += wholesec)
		    buf[i] = track;
		  for (side = 0; side <= surface; side++)
		  {
      		    for (i = beginsec + 1, j = 0; j < seccount;
			 i += wholesec, j++)
      		    {	
        	      buf[i    ] = side;
		      buf[i + 1] = stab[j] + firstsec + base * side;
      		    }
		    formtrk (drive - first, side, track, buf);
		  }
		  track--;
       }
       printf ("\nVERIFIZIEREN VON SPUR   ");
    }
  }

  /* reset formatted disk */
  bdos (37, 1 << drive);
} 
	 		

char errmsg (errno)
  char errno;
{
  char c;

  switch (errno)
  {
    case 1: printf ("\nUNG]LTIGES LAUFWERK\n");
	    abort  (1);	
    case 2: printf ("\nUNG]LTIGE SPUR\n");
	    abort  (1);
    case 3: printf ("\nUNG]LTIGER SEKTOR\n");
	    abort  (1);	
    case 4: printf ("\nLAUFWERK NICHT BEREIT\n");
	    break;
    case 5: printf ("\nDISKETTE SCHREIBGESCH]TZT\n");
 	    break;
    case 6: printf ("\nLAUFWERKSFEHLER\n");
	    abort  (1);
    case 7: printf ("\nDATEN-RECORD NICHT GEFUNDEN\n");
	    break;
    case 8: printf ("\nCRC-FEHLER\n");
	    break;
    case 9: printf ("\nDATEN VERLOREN\n");
	    abort  (1);
  }
  printf ("(A)BBRECHEN, (W)IEDERHOLEN ODER (F)ORTFAHREN\n");
  do
  {
    printf ("\b");
    c = toupper(getchar());
  }
  while (c != 'A' && c != 'F' && c != 'W');
  printf ("\n");
  return c;
}
