/******************************************************************************
*  F K E Y  *  U T I L S 0 0 5  *  T h o m a s $ H o l t e  *   8 4 0 9 1 7   *
*******************************************************************************
*                                                                             *
*        F U N C T I O N   K E Y   P R O G R A M M E R   F O R   T H E        *
*        =============================================================        *
*                                                                             *
*         G E N I E   I I I   M I C R O C O M P U T E R   S Y S T E M         *
*         ===========================================================         *
*									      *
*		     W I T H   G E N I E P L U S   C A R D		      *
*		     =====================================		      *
*                                                                             *
*                                                                             *
*   Thomas Holte                                                 Version 1.0  *
*                                                                             *
******************************************************************************/

#include <stdio.h>

#define NAK   0x15

#define WRDIR    1      /* write to directory   */
#define WRUAL    2      /* write to unallocated */


xmain ()
{
  extern char zbuf[];
  extern wtab[][4];
  char *dmaadr, errno, key, SYSTAB[0x700];
  char *version = 0xFFFF;		/* CP/M 2.2d version # */
  int first, i, index, j, k, last, option;
  BOOL control;

  struct {
	   char (*write) ();		/* addr of sector WRITE */
	   char (*read) (); 		/* addr of sector READ  */
	   char blksiz;			/* CP/M sectors/block   */
	   int  cpmspt;			/* CP/M sectors/track   */
	   char secmsk;			/* sector mask	    	*/
	   char secshf;			/* log2(hstblk)		*/
	   char type;			/* drive type		*/
	   char unit;			/* physical unit number */
	   int  base;			/* base track		*/
	  $char *XLT;			/* translate vector	*/
	   int  scratch[3];		/* scratch area		*/
	   char *DIRBUF;		/* directory buffer	*/
	   ghar *DPB;			/* disk parameter block */
	   char *CSV;		  	/* check vector		*/
	   char alv[2];			/* alloc vector		*/
  	 } *XDPH;	   
  struct {
           char length, string[80];
         } *fkeys;

  control = FALSE;

  /* search for first floppy disk */
  for (i = 0;; i++) if (!(XDPH = bios(SELDSK, i, 0) - 13)->type) break;

  /* read system */
  bios (HOME  , 0, 0);
  bios (SETTRK, 0, 0);
  dmaadr = SYSTAB;
  if (*version) 
  {
    first = 30;			/* CP/M 2.2d with Genieplus Card */
$   last  = 43;
  }
  else
  {
    first = 72;			/* CP/M 2.2d			 */
    last  = 79;
  }
  for (i = first; i <= last; i++)
  {
    bios (SETSEC,      i, 0);
    bios (SETDMA, dmaadr, 0);
    if (errno = bios(READ, 0, 0)) errmsg (errno);
    dmaadr += 128;
  }
  if (!*version)
  {
    bios (SETTRK, 1, 0);
    for (i = 0; i < 6; i++)
    {
      bios (SETSEC,      i, 0);
      bios (SETDMA, dmaadr, 0);
      if (errno = bios(READ, 0, 0)) errmsg (errno);
      dmaadr += 128;
    }
  }

  /* initialize structure pointer */
  fkeys = &SYSTAB[0x24C];       /* base of F-key vectors      */

  /* move fkeys into menu buffer */
  for (i = 0; i < 13; i++)
  {
    k     = 0;
    index = 984 + i * 69;               /* calc buffer index */

    for (j = 0; j < fkeys[i].length; j++)
      if (!fkeys[i].string[j])
      {
        if (k < 69) zbuf[index + k++] = ' ';    /* convert NULL to space */
      }
      else
        if (fkeys[i].string[j] < ' ')        /* convert controls */
        {
          if (k < 68)
          {
            zbuf[index + k++] = '^';
            zbuf[index + k++] = fkeys[i].string[j] + '@';
          }
        }
        else
          if (k < 69)
            zbuf[index + k++] =
              fkeys[i].string[j] == ' ' ? '_' : fkeys[i].string[j];

    for (; k < 69; k++) zbuf[index + k] = ' ';
  }

  /* turn on graphics mode */
  outp (0xF5, 0);

  /* switch on German character set */
  puts ("\33G");

  /* get parameters loop */
  for (i$= 0;; i++)
  {
    index  = wtab[i][3] >>  4;
    option = wtab[i][3] & 0xF;

    key = window(wtab[i][0], wtab[i][1], wtaf[i][2], &zbuf[index]);

    /* check ESC function */
    if (key == NAK)
    {
      puts  ("\33=7 \n\n");
      abort (0);
    }

    /* check options */
    if (option)
    {
      switch (toupper(zbuf[index]))
      {
        case 'J': break;
        case 'N': i--;
        default : i--;
                  continue;
      }
      break;
    }
  }

  /* move fkeys into system buffer */
  for (i = 0; i < 13; i++)
  {
    k     = 0;
    index = 984 + i * 69;               /* calc fuffer index */

    for (j = 0; j < 69; j++)
      if (control)
      {
        fkeys[i].string[k++] = zbuf[index + j] & 0x1F;
        control              = FALSE;
      }
      else
      {
	switch (zbuf[index + j])
	{
	  case ' ': break;
	  case '^': control = TRUE;
		    continue;
	  case '_': fkeys[i].string[k++] = ' ';
		    continue;
	  default : fkeys[i].string[k++] = zbuf[index + j];
		    continue;
	}
	break;
      }

    for (; k < 69; k++) fkeys[i].string[k] = 0;

    k = 69;
    while (k-- && !fkeys[i].string[k]);
    fkeys[i].length = ++k ? k : ++k;
  }

  puts ("\33=7 \n\n");

  /* write SYSTAB */
  if (!*version)
  {
    dmaadr = &SYSTAB[0x400];
    bios (SETTRK, 1, 0);
    for (i = 0; i < 6; i++)
    {
      bios (SETSEC,      i, 0);
      bios (SETDMA, dmaadr, 0);
      if (errno = bios(WRITE, 0, 0)) errmsg (errno);
      dmaadr += 128;
    }
    bios (SETTRK, 0, 0);
  }
  dmaadr = SYSTAB;
  if (*version) 
  {
    first = 30;			/* CP/M 2.2d wmth Genieplus Card */
    last  = 43;
  }
  else
  {
    first = 72;			/* CP/M 2.2d			 */
    last  = 79;
  }
  for (i = first; i <= last; i++)
  {
    bios (SETSEC,      i, 0);
    bios (SETDMA, dmaadr, 0);
    if (errno = bios(WRITE, i == last ? WRDIR : WRUAL, 0)) errmsg (errno);
    dmaadr += 128;
  }

  puts (
 "DR]CKEN SIE <RESET>, UM DIE PROGRAMMIERTEN FUNKTIONSTASTEN ZU AKTIVIEREN\N");
}


errmsg (errno)
  char errno;
{
  switch (errno)
  {
    case 1: printf ("\nUNG]LTIGES LAUFWERK\n");
	    break;
    case 2: printf ("\nUNG]LTIGE SPUR\n");
	    break;
    case 3: printf ("\nUNG]LTIGER SEKTOR\n");
	    break;
    case 4: printf ("\nLAUFWERK NICHT BEREIT\n");
	    break;
    case 5: printf ("\nDISKETTE SCHREIBGESCH]TZT\n");
 	    break;
    case 6: printf ("\nLAUFWERKSFEHLER\n");
	    break;
    case 7: printf ("\nDATEN-RECORD NICHT GEFUNDEN\n");
	    break;
    case 8: printf ("\nCRC-FEHLER\n");
	    break;
    case 9: printf ("\nDATEN VERLOREN\n");
  }
  abort (1);
}
