/******************************************************************************
*  I N I T W  *  C P M S Y S 4  *  T h o m a s   H o l t e  *   8 4 0 5 2 0   *	
*******************************************************************************
* 									      *
*     U T I L I T Y   F O R   G E N E R A T I N G   A   G E N I E   I I I     *
*    =====================================================================    *
* 									      *
*  	   C P / M   V e r . 2 . 2   H A R D   D I S K   S Y S T E M	      *
*          =========================================================          *
* 									      *
* 									      *
*   Thomas Holte			                         Version 1.0  *
* 									      *
******************************************************************************/
  
#include <stdio.h>

/* port addresses of Western Digital Winchester Disk Controller */
#define DATA      0x48		/* data register    */
#define ERR       0x49		/* error register   */
#define WPC       0x49		/* write precomp    */
#define SECNT     0x4A		/* sector count     */
#define SECNO     0x4B		/* sector number    */
#define CYLLO     0x4C		/* cylinder low     */
#define CYLHI     0x4D		/* cylinder high    */
#define SDH       0x4E		/* size/drive/head  */
#define COMND     0x4F		/* command register */
#define STATUS    0x4F		/* status register  */

/* commands of Western Digital Winchester Disk Controller */
#define REST	  0x16		/* restore	     */
#define _READ	  0x20		/* read sector       */
#define _WRITE    0x30		/* write sector      */
#define FORMAT    0x50		/* format track      */
#define DESELECT  0x98		/* deselect disk     */

/* characteristics of Cynthia D505 Winchester Disk */
#define SECLEN     512		/* sector length       	    */   
#define SECSIZE   0x20		/* size bits for controller */
#define SECCOUNT    16		/* sector count        	    */
#define TRKCOUNT   612		/* track count         	    */
#define HEADCOUNT    4		/* surface count       	    */
#define SKEW         1  	/* interleaving factor 	    */


static char status;

xmain ()
{
  char buf[SECLEN], check_sector (), err, errmsg (), format_track (), j,
       restore (), secno, surface, write_sector (); 
  int cylinder, i;
  BOOL bad_sector;


  printf ("\nINITIALIZATION OF A CP/M VER 2.2 HARD DISK SYSTEM\n\n");

  printf ("CONFIGURATION TABLE:\n");
  printf ("Drive A: 4.8 MBytes Winchester\n");
  printf ("Drive B: 800 KBytes mini floppy\n");     
  printf ("Drive C: 800 KBytes mini floppy\n");     
  printf ("Drive D: optional\n");
  printf ("Drive E: optional\n");

  /* restore drive */
  for (;;)
    if (err = restore()) if (errmsg(err) == 'R'); else abort (1); else break;

  /* initialize data buffer */
  for (i = 0; i < (SECCOUNT + 1) * 2; i += 2) buf[i] = 0x00;

  /* initialize bad block marker */
  bad_sector = FALSE;

  /* formatting */
  printf ("\nFORMATTING TRACK    ");

  for (cylinder = 0; cylinder < TRKCOUNT / HEADCOUNT; cylinder++)
    for (surface = 0; surface < HEADCOUNT; surface++)
    {
      printf ("\b\b\b%03d", cylinder * HEADCOUNT + surface);

      /* init format data */
      for (i = 1; i < (SECCOUNT + 1) * 2; i += 2) buf[i] = 0xFF;

      /* number sectors */
      retry:
      for (i = secno = 0; i < SECCOUNT; i++)
      {
        j = 1 + 2 * secno;
        if (buf[j] != 0xFF)
        {
          secno++;
          i--;
        }
        else
        {
          buf[j] = i;
          if ((secno += SKEW) > SECCOUNT) secno -= SECCOUNT + 1;
        }
      }

      if (err = format_track(surface, cylinder, buf))
	if (errmsg(err) == 'R')
	{
	  surface--;
	  printf ("\nFORMATTING TRACK    ");
 	  continue;
	}
	else abort (1);

      /* verifying */
      for (secno = 0; secno < SECCOUNT; secno++)
        if (check_sector(surface, cylinder, secno))
	  if (bad_sector) fatal_error ();
	  else 
          {
            for (i = 1; i < (SECCOUNT + 1) * 2; i += 2)
	      if (buf[i] == secno) buf[i] = 0xFE; else buf[i] = 0xFF;
	    bad_sector = TRUE;
	    goto retry;
	  } 
	 
      /* reset bad sector marker */
      bad_sector = FALSE;
    }

  /* initialize directory of logical drive A */
  for (i = 0; i < SECLEN; i++) buf[i] = 0xE5;

  printf ("\n\nINITIALIZING DIRECTORY\n");
   
  for (secno = 0; secno < SECCOUNT; secno++)
    if (write_sector(0, 0, secno, buf)) fatal_error ();
  for (secno = 0; secno < SECCOUNT; secno++)
    if (check_sector(0, 0, secno     )) fatal_error ();
  for (secno = 0; secno < SECCOUNT; secno++)
    if (write_sector(1, 0, secno, buf)) fatal_error ();
  for (secno = 0; secno < SECCOUNT; secno++)
    if (check_sector(1, 0, secno     )) fatal_error ();

  /* deselect Winchester disk drive */
  outp (SDH, DESELECT);
}

 
char restore ()
{
  uptask (0    , 0, 0  );
  outp   (COMND, REST  );

  while ((status = inp(STATUS)) & 0x80);
  if (status & 0x01) return inp(ERR); else return 0;
}


char check_sector (surface, cylinder, sector)
  char surface, sector;
  int cylinder;
{
  uptask (surface, cylinder, sector);
  outp   (COMND  , _READ	   );

  while ((status = inp(STATUS)) & 0x80);

  if (status & 0x01) return inp(ERR); else return 0;
} 


char write_sector (surface, cylinder, sector, buffer)
  char surface, sector, *buffer;
  int cylinder;
{
  register int i;

  uptask (surface, cylinder, sector);
  outp   (COMND  , _WRITE          );

  for (i = 0; i < SECLEN; i++) outp (DATA, *buffer++);

  while ((status = inp(STATUS)) & 0x80);

  if (status & 0x01) return inp(ERR); else return 0;
}


char format_track (surface, cylinder, buffer)
  char surface, *buffer;
  int cylinder;
{
  register int i;

  uptask (surface, cylinder,  0);
  outp   (SECNT  , SECCOUNT + 1);
  outp   (COMND  , FORMAT      );

  for (i = 0; i < SECLEN; i++) outp (DATA, *buffer++);

  while ((status = inp(STATUS)) & 0x80);

  if (status & 0x01) return inp(ERR); else return 0;
}


uptask (surface, cylinder, sector)
  char surface, sector;
  int cylinder;
{
  outp (WPC  , 16    		       );
  outp (SECNO, sector		       );
  outp (CYLHI, cylinder >> 8           );
  outp (CYLLO, cylinder                );
  outp (SDH  , 0x80 + SECSIZE + surface);
}


char errmsg (error)
  char error;
{
  char c, errbit;

  register int i;

  for (i = 0; i < 8; i++)
    switch (errbit = error & 1 << i)
    {
      case 0x01:
      case 0x02:	
      case 0x10: printf ("\nDATA RECORD NOT FOUND\n");
	         break;
      case 0x04: switch (status & 0x60)
		 {
		   case 0x40: printf ("\nDEVICE NOT AVAILABLE\n");
			      break;	
		   case 0x20: printf ("\nWRITE FAULT ON DISK DRIVE\n");
			      abort  (1);
		 }
		 break;	
      case 0x20:
      case 0x40:
      case 0x80: printf ("\nPARITY ERROR\n");
    }

  printf ("REPLY C (CANCEL) OR R (RETRY)\n");
  do
  {
    printf ("\b");
    c = toupper(getchar());
  }
  while (c != 'C' && c != 'R');
  printf ("\n");
  return c;
}
      

fatal_error ()
{
  printf ("\nWINCHESTER DISK DRIVE FAULT\n");
  abort  (1);
}
