/******************************************************************************
*  C O P Y  *  U T I L S 0 0 4  *  T h o m a s   H o l t e  *   8 4 0 8 3 1   *
*******************************************************************************
* 									      *
* 	   B A C K U P   U T I L I T Y   F O R   C P / M - B A S E D	      *
*          =========================================================          *
* 									      *
*		   M I C R O C O M P U T E R   S Y S T E M S 		      *
*                  =========================================                  *
* 									      *
* 									      *
*   Thomas Holte			                         Version 2.0  *
* 									      *
******************************************************************************/

#include <stdio.h>

#define ETX 3

#define HOME     8
#define SELDSK   9
#define SETTRK  10
#define SETSEC  11
#define SETDMA  12
#define READ    13
#define WRITE   14
#define SECTRAN 16

#define VERIFY  17

#define WRDIR    1	/* write to directory   */
#define WRUAL    2	/* write to unallocated */

static char errno, lasttrk, track;
static lastsec;

/* disk parameter header */
struct dph {
	     char *XLT;
	     int  filler[3];
	     char *DIRBUF;
	     struct {
		      int  SPT;
		      char BSH, BLM, EXM;
		      int  DSM, DRM;
		      char AL0, AL1;
		      int  CKS, OFF;
		    } *DPB;
	     char *CSV, *ALV;
           };


main (argc, argv)
  int argc;
  char *argv[];
{
  char class, *dmaadr, firsttrk, s[80], sector, state, *tbuf, tracks[80], val,
       work;
  int dirsize, first_of_all, firstsec, i, j, n, no, no1, no2, start, trksiz;

  struct {
	   char mode[6], source, dest, automatic, verify;
	 } list;
  struct {
	   char del, name[8], type[3], extent, reserved[2], eof;
	   union {
		   char sno[16];
		   int  lno[8];
		 } block;
	 } *entry;
  struct dph *SDPBASE, *DDPBASE;

  /* structure of the decision table:
     a) states:     0. initial
		    1. mode encountered
		    2. source drive encountered
		    3. destination drive encountered
		    4. end
     b) activities: 0. NOP
		    1. save copy mode
		    2. save source drive
		    3. save destination drive
		    4. save options

  	     	           mode drive option */
  static char tab[][3] = {{0x11, 0x22, 0x44},
	                  {0x40, 0x22, 0x44},
		          {0x40, 0x33, 0x44},
		          {0x40, 0x40, 0x44}};

  BOOL notequal (), trackio ();


  /* initialize control structure */
  list.mode[0] = list.automatic = list.verify = 0;
  list.source  = list.dest      	      = 0xFF;

  /* initialize control variables */
  state = 0;
  start = 1;

  printf ("\nCOPY VER 2.0\n");

  for (;;)
  {
    /* convert arguments to upper case */
    for (i = start; i < argc; i++) for (j = 0; j < strlen(argv[i]); j++)
      argv[i][j] = toupper(argv[i][j]);

    for (i = start; i < argc; i++)
    {		
        class = 0xFF;
      if (streq("ALL"  , argv[i]) || streq("BOOT", argv[i]) ||
          streq("FILES", argv[i]) || streq("END" , argv[i]))   class = 0;
      if (strlen(argv[i]) == 1 && *argv[i] >= 'A' && *argv[i] <= 'P')
        class = 1;
      if (streq("[A]"  , argv[i]) || streq("[V]" , argv[i]) ||
          streq("[AV]" , argv[i]) || streq("[VA]", argv[i]))   class = 2;

      if (class == 0xFF) break;

      /* get table entry */
      val = tab[state][class]; 

      /* working entry */
      work = val & 7;

      switch (work)
      {
        case 1 : strcpy (list.mode, argv[i]);
	         break;
        case 2 : list.source    = *argv[i] - 'A';
	         break;
        case 3 : list.dest      = *argv[i] - 'A';
	         break;
        case 4 : list.automatic = index(argv[i], 'A');
		 list.verify    = index(argv[i], 'V');
      }

      if ((state = val >> 4) == 4) break;
    }

    restart:

    argc  = 1;	
    start = state = 0;
  
    if (list.mode[0] == 'E') return;

    if (list.mode[0] == '\0')
    {
      printf ("\nMODE    FUNCTION\n\n");
      printf ("ALL     COPY THE WHOLE DISK\n");
      printf ("BOOT    COPY THE BOOT TRACKS\n");
      printf ("FILES   COPY THE NON-BOOT TRACKS\n");
      printf ("END     END THIS PROGRAM\n");
      printf ("\nENTER YOUR COPY MODE: ");
      gets   (argv[0] = s);
      if (strlen(s) <= 1) argv[0][0] = '\0';
      continue;
    }
            
    if (list.source == 0xFF)
    {
      printf ("\nENTER SOURCE DRIVE: ");
      gets   (argv[0] = s);
      continue;
    }
    else if (!(SDPBASE = bios(SELDSK, list.source, 0)))
         {
           printf ("\nDISK SELECT ERROR ON SOURCE\n");
           abort  (1);
         }

    if (list.dest == 0xFF)
    {
      printf ("\nENTER DESTINATION DRIVE: ");
      gets   (argv[0] = s);
      state = 2;
      continue;
    }
    else
      if (!(DDPBASE = bios(SELDSK, list.dest, 0)))
      {
        printf ("\nDISK SELECT ERROR ON DESTINATION\n");
        abort  (1);
      }
      else if (notequal(SDPBASE->DPB, DDPBASE->DPB, sizeof *SDPBASE->DPB))
	   {
	     printf ("\nINCOMPATIBLE DISKS\n");
	     abort  (1);
	   }
	   else bios (HOME, 0, 0);

    break;   
  }

  /* big copy loop */
  do
  {
    if (!list.automatic)
    {
      printf ("\n(^C TO ABORT)\n");
      printf ("RETURN TO COPY %s FROM %c TO %c ", list.mode, list.source + 'A',
							     list.dest  + 'A');
      gets   (s);
    } 
    printf ("\n");

    /* initialize track numbers */
    firsttrk = 0;
    lasttrk  = SDPBASE->DPB->OFF - 1;
    for (track = firsttrk; track <= lasttrk; track++) tracks[track] = TRUE;

    /* read directory of source disk */
    if (list.mode[0] != 'B')
    {
      /* get directory buffer */
      if (!(dmaadr = entry
		   = alloc(((dirsize = SDPBASE->DPB->DRM / 4) + 1) * 128)))
      {
        printf ("\nOUT OF MEMORY\n");
        abort  (1);
      }

      lasttrk = (firsttrk = SDPBASE->DPB->OFF) + dirsize / SDPBASE->DPB->SPT;

      bios (SELDSK, list.source, 0);
      bios (HOME  , 0          , 0);   
      for (track = firsttrk; track <= lasttrk; track++)
      {
        bios(SETTRK, track, 0);
        for (sector = 0; sector <= dirsize && sector < SDPBASE->DPB->SPT;
	     sector++)
        {
          bios (SETSEC, bios(SECTRAN, sector, 0), 0);
          bios (SETDMA, dmaadr		        , 0);
          if (errno = bios(READ, 0, 0))
          {
            errmsg (errno);
	    abort  (1);
          }
          dmaadr += 128;
        }
        dirsize -= SDPBASE->DPB->SPT;
      }

      for (track = firsttrk; track <= lasttrk; track++) tracks[track] = TRUE;
      if (list.mode[0] != 'F') firsttrk = 0;
      for (track = lasttrk + 1; track < 80   ; track++) tracks[track] = FALSE;

      /* detect unallocated tracks */
      for (i = 0; i <= SDPBASE->DPB->DRM; i++)
        if (entry[i].del != 0xE5)
          if (SDPBASE->DPB->DSM > 255)
            for (j = 0; j < 8; j++) 
	    {
	      lastsec = (firstsec = entry[i].block.lno[j]
		      * (SDPBASE->DPB->BLM + 1)) + SDPBASE->DPB->BLM;
	    
	      no1 = firstsec / SDPBASE->DPB->SPT + SDPBASE->DPB->OFF;
	      no2 = lastsec  / SDPBASE->DPB->SPT + SDPBASE->DPB->OFF;
	      for (track = no1; track <= no2; track++)
	      {
	        tracks[track] = TRUE;
	        lasttrk       = max(lasttrk, track);
	      }
            }
          else 
            for (j = 0; j < 16; j++) 
	    {
	      lastsec = (firstsec = entry[i].block.sno[j]
		      * (SDPBASE->DPB->BLM + 1)) + SDPBASE->DPB->BLM;

	      no1 = firstsec / SDPBASE->DPB->SPT + SDPBASE->DPB->OFF;
	      no2 = lastsec  / SDPBASE->DPB->SPT + SDPBASE->DPB->OFF;
	      for (track = no1; track <= no2; track++)
	      {
	        tracks[track] = TRUE;
	        lasttrk       = max(lasttrk, track);
	      }
            }

      free (entry);		/* free directory buffer */
    }

    /* get buffer for n tracks */
    trksiz = SDPBASE->DPB->SPT * 128;
    n	   = 0;			    /* safety */  	
    while (tbuf = alloc(trksiz * ++n)) free (tbuf);
    if (!--n || !(tbuf = alloc(trksiz * n)))
    {
      printf ("\nOUT OF MEMORY\n");
      abort  (1);
    }

    /* copying */
    lastsec = SDPBASE->DPB->SPT - 1;
    track   = first_of_all = firsttrk;

    while (track <= lasttrk)
    {
      if (list.source == list.dest && track != first_of_all)
      {
        printf (
	  "\n\nPRESS <NEW LINE> WHEN SOURCE DISKETTE MOUNTED ON DRIVE %c ",
	  list.source + 'A');
        gets   (s);
        printf ("\n");
      }	

      printf ("\rREADING TRACK   ");

      for (i = 0; i < n; i++)
      {
	if (tracks[track]) 			
	{
	  printf ("\b\b%02d", track);
	  if (trackio(list.source, &tbuf[i * trksiz], READ)) i--;
	}
	else i--;

	if (++track > lasttrk)
	{
	  n = ++i;
	  break;
	}
      }

      if (list.source == list.dest)
      {
	printf (
 	 "\n\nPRESS <NEW LINE> WHEN DESTINATION DISKETTE MOUNTED ON DRIVE %c ",
	  list.dest + 'A');
        gets   (s);
        printf ("\n");
      }	
      printf ("\rWRITING TRACK   ");	
      track = firsttrk;

      for (i = 0; i < n; i++, track++)
	if (tracks[track])
	{
	  printf ("\b\b%02d", track);
	  if (trackio(list.dest, &tbuf[i * trksiz], WRITE)) i--;
	  else if (list.verify) if (trackio(list.dest, tbuf, VERIFY)) i--;
        }
	else i--;

      firsttrk = track;
    }

    free (tbuf);		/* free track buffer */

    if (list.automatic) return;
    printf ("\n\nDO YOU WISH TO REPEAT THE COPY ? ");
  }
  while (toupper(getchar()) == 'Y');

  /* restart copy program */
  list.mode[0] = '\0';
  list.source  = list.dest = 0xFF;
  printf ("\n");
  goto restart;
}


BOOL notequal (s1, s2, n)
  char *s1, *s2;
  int n;
{
  register int i;

  for (i = 0; i < n; i++) if (*s1++ != *s2++) return TRUE;
					      return FALSE;
}	


errmsg (errno)
  char errno;
{
  switch (errno)
  {
    case 1: printf ("\nILLEGAL DRIVE #\n");
	    abort  (1);
    case 2: printf ("\nTRACK # TOO HIGH\n");
	    abort  (1);
    case 3: printf ("\nSECTOR # TOO HIGH\n");
	    abort  (1);	
    case 4: printf ("\nDEVICE NOT AVAILABLE\n");
	    break;
    case 5: printf ("\nWRITE PROTECTED DISKETTE\n");
 	    break;
    case 6: printf ("\nWRITE FAULT ON DISK DRIVE\n");
	    abort  (1);
    case 7: printf ("\nDATA RECORD NOT FOUND\n");
	    break;
    case 8: printf ("\nPARITY ERROR\n");
	    break;
    case 9: printf ("\nLOST DATA\n");
	    abort  (1);
  }
}


BOOL trackio (drive, buffer, mode)
  char drive, *buffer, mode;
{
  char c, dummy[REC_SIZE], mode1, sector;

  bios (SELDSK, drive, 0);
  bios (SETTRK, track, 0);
  if (mode == VERIFY)
  {
    buffer = dummy;
    mode1  = READ;
  }
  else mode1 = mode;

  for (sector = 0; sector <= lastsec; sector++)
  {
    bios (SETSEC, bios(SECTRAN, sector, 0), 0);
    bios (SETDMA, buffer		  , 0);    
    if (errno = bios(mode1, track == lasttrk && sector == lastsec ?
		     WRDIR : WRUAL, 0))
    {
      printf ("\n");
      errmsg (errno);
      printf ("REPLY C (CANCEL), R (RETRY) OR P (PROCEED)\n");
      do
      {
        printf ("\b");
        c = toupper(getchar());
      } 
      while (c != 'C' && c != 'P' && c != 'R');
      printf ("\n");
      switch (c)
      {
        case 'C': abort (1);
        case 'P': if (mode == READ) printf ("\nREADING TRACK   ");
		  	       else printf ("\nWRITING TRACK   ");
		  break;	
        case 'R': if (mode == READ) printf ("\nREADING TRACK   ");
		  	       else printf ("\nWRITING TRACK   ");
		  track--;
		  return TRUE;
      }
    }
    if (mode != VERIFY) buffer += 128;
  }
  return FALSE;
}
